\ Demonstration of INTS and EXCEPTIO (Catch/Throw) packages
\ Contents of this file placed in Public Domain by the author, Tom Almy

\ Control-Break sets a flag (BREAK-SET) the demo does a Ctrl-Break THROW
\ from the KEYS? word, but this could be placed in the EMIT definition
\ and others as well.

\ Control-C does a Ctrl-C THROW.
\ Divide by zero does a 0Divide THROW.


\ STOP EXECUTION BY TYPING ANY KEY BUT "CONTROL-C" OR "CONTROL-
\   BREAK"


256 MSDOS
HEX

INCLUDE INTS
INCLUDE EXCEPTIO

23 CONSTANT CC-INT  ( Control-C software interrupt number from DOS)
1B CONSTANT CB-INT  ( Control-Break software interrupt from BIOS)
0  CONSTANT /0-INT  ( Zero Divide interrupt )

\ Throw values:
DECIMAL
-28 CONSTANT Ctrl-C      ( User interrupt )
 28 CONSTANT Ctrl-Break  ( Not defined by standard )
-10 CONSTANT 0Divide
HEX


\ CONTROL-C HANDLER

L: CC-ENTRY ( actual interrupt handler )
  DECIMAL Ctrl-C HEX # AX MOV   AX PUSH 
  CALL' THROW  \ Never returns



\ I don;t know how to throw from this
\ CONTROL-BREAK HANDLER
20 ALLOT  HERE CONSTANT PARAMSTACK	\ our new stacks
20 ALLOT  HERE CONSTANT RETSTACK
2VARIABLE SS-SAVE			\ Stack segment save area

VARIABLE BREAK-SET

0 0 IN/OUT
: CB-HANDLER  BREAK-SET ON  ;


L: CB-ENTRY ( actual interrupt handler )
  ( save registers )
	AX PUSH  DS PUSHSEG  AX CS <SEG  AX DS >SEG	\ save AX, DS, set DS
	SS-SAVE [] SS <SEG  SP SS-SAVE CELL+ [] MOV	\ save SS SP
	AX SS >SEG PARAMSTACK # SP MOV			\ set SS,SP
	BX PUSH  CX PUSH  DX PUSH  SI PUSH  DI PUSH	\ Save remaining
	BP PUSH ES PUSHSEG 
	RETSTACK # BP MOV				\ set BP
	CALL' CB-HANDLER  ( high level interrupt handler )
	ES POPSEG BP POP DI POP SI POP DX POP CX POP BX POP \ restore registers
	SS-SAVE [] SS >SEG SS-SAVE CELL+ [] SP MOV DS POPSEG  AX POP
	IRET FORTH

\ Because this is a BIOS interupt, rather than an MS-DOS interupt,
\ as CC-INT was, we have to set our data segment register, and 
\ use new stacks with minimum impact on the DOS stack


\  ZERO-DIVIDE TRAP HANDLER

L: /0-ENTRY  
	0Divide # AX MOV AX PUSH 
        CALL' THROW



\ INTERUPT HANDLER DEMO
0 1 IN/OUT
: KEYS? ( like key?, but returns keystroke if there is one)
       KEY? IF KEY ELSE 0 THEN  
       BREAK-SET @ IF BREAK-SET OFF Ctrl-Break THROW THEN ;

DECIMAL
: DO/ / ;	\ We do the divide within a CATCH specific to the
                \ single divide instance, for fine grain control
                \ Contrast this with catching Control-C

: RUNLOOP \ Normal return when key is hit
	BEGIN  10 0 DO
		10000 I ['] DO/ CATCH CASE
                      0 OF   .  ( good case ) ENDOF
                      0Divide OF ." DIVIDE BY ZERO" 2DROP ENDOF
                       THROW ( we won't handle it here ) ENDCASE
		LOOP
		CR KEYS? UNTIL 
;


2VARIABLE /0-SAVE  ( we will want to save the vectors )
2VARIABLE CB-SAVE

: MAIN  
	/0-INT get-handler /0-SAVE 2!		\ get and save old handlers
	CB-INT get-handler CB-SAVE 2!
	?CS: CC-ENTRY CC-INT set-handler	\ set handlers to us
	?CS: CB-ENTRY CB-INT set-handler
	?CS: /0-ENTRY /0-INT set-handler
	." TYPE ANY KEY TO STOP, OR TYPE CONTROL-C OR BREAK" CR
        BEGIN
		['] RUNLOOP CATCH ?DUP WHILE
                CASE  Ctrl-C OF ." CONTROL-C HIT!" CR ENDOF
                      Ctrl-Break OF CR ." BREAK HIT!" CR ENDOF
		      THROW \ In this example, there is nothing to catch it
		ENDCASE
        REPEAT
	/0-SAVE 2@ /0-INT set-handler		\ restore handlers
	( We dont need to restore the control-C handler )
	CB-SAVE 2@ CB-INT set-handler ;


INCLUDE FORTHLIB
END
