// ========================================================================
//  TODB LIBRARY
//    schema.cpp
//
//    Schema
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#include "schema.h"
#include <iomanip.h>
#include <string.h>

//-------------------------------------------------------------------------
// MakeTokenUW class
//-------------------------------------------------------------------------

// make Upper case Word
MakeTokenUW::MakeTokenUW()
{
    buf_ = NULL;
    postoken_ = NULL;
    length_ = 0;
}

void MakeTokenUW::Put( const char * s )
{
    delete [] buf_;
    length_ = strlen( s );
    buf_ = new char[ length_ + 1 ];
    strcpy( buf_, s );
}

int MakeTokenUW::First( char * token )
{
    char seps[] = " !\"#$%&'()*+-,./:;<=>?@[\\]^_`{}|~";

    postoken_ = strtok( buf_, seps );
	if ( postoken_ == NULL ) {
	*token = 0;
	return 0;
    }
    #ifdef MSC
    _strupr( postoken_ );
    #endif
    #ifdef BCC
    strupr( postoken_ );
    #endif
    strcpy( token, postoken_ );
    return AcceptToken( token );
}

int MakeTokenUW::Next( char * token )
{
    char seps[] = " !\"#$%&'()*+-,./:;<=>?@[\\]^_`{}|~";

    postoken_ = strtok( NULL, seps );
    if ( postoken_ == NULL ) {
	*token = 0;
	return 0;
    }
    #ifdef MSC
    _strupr( postoken_ );
    #endif
    #ifdef BCC
    strupr( postoken_ );
    #endif
    strcpy( token, postoken_ );
    return AcceptToken( token );
}

// Exclude list
int MakeTokenUW::AcceptToken( char * token )
{
    // reject single characters
    if ( strlen( token ) == 1 ) 	return 0;

    if ( strcmp( token, "AN" ) == 0 )	return 0;
    if ( strcmp( token, "THE" ) == 0 )	return 0;
    if ( strcmp( token, "LA" ) == 0 )	return 0;
    if ( strcmp( token, "LE" ) == 0 )	return 0;
    if ( strcmp( token, "LES" ) == 0 )	return 0;

    return 1;
}

//-------------------------------------------------------------------------
// Count class
//-------------------------------------------------------------------------
// Count class implements a RECORD-ID generator.  Useful for the demo
// program, this class is useless for a real life application.
// On the other	hand, it give an example on using KSpersistent
// class to save related data in the key set database.

Count::Count( KeyType countno ) :
    KSPersistent( *ksDB, COUNT )
{
    LoadObject( countno );
}

Count::Count() :
    KSPersistent( *ksDB, COUNT )
{
    LoadObject( 1 );
}

Count::~Count()
{
    ChangeObject();
    SaveObject();
}

void Count::SetCNote( KeyType cn )
{
    cnote_ = cn;
}

void Count::SetVersion( String & vs )
{
    version_ = vs;
}

Boolean Count::Dirty()
{
    return (Boolean)dirty_;
}

void Count::SetDirty()
{
    dirty_ = 1;
}

void Count::ResetDirty()
{
    dirty_ = 0;
}

void Count::Read()
{
    ReadObject( version_ );
    ReadObject( dirty_ );
    ReadObject( cnote_ );
}

void Count::Write()
{
    WriteObject( version_ );
    WriteObject( dirty_ );
    WriteObject( cnote_ );
}

//-------------------------------------------------------------------------
// BibNote class
//-------------------------------------------------------------------------

BibNote::BibNote( KeyType nno ) :
    IdxColl( *ksDB, BIBNOTE )
{
    noteno = nno;
}

void BibNote::Delete()
{
    DeleteIdx();
}

void BibNote::Index()
{
    IndexObject( noteno, TITLES, UW_token, title );
    IndexObject( noteno, TITLES, UW_token, article_title );
    IndexObject( noteno, SUBTITLES, UW_token, subtitle	);
    IndexObject( noteno, SUBTITLES, UW_token, article_subtitle );
    IndexObject( noteno, AUTHOR, UW_token, author );
    IndexObject( noteno, PUBLISHER, UW_token, publisher );
    IndexObject( noteno, KEYWORDS, UW_token, keywords );
    IndexObject( noteno, DATE, UW_token, date );
    IndexObject( noteno, PUB_PLACE, UW_token, publishing_place );
}
