#include <pmio.h>
#include "pmtext.h"

class Test: public PMTextWindow
{
public:
  void put (const char *s) { put_std (strlen (s), s); }
  Test ();
};

Test::Test ()
: PMTextWindow ("10.System VIO")
{
  const char *color_names[] = {
    "Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "Light Gray",
    "Dark Gray", "Light Blue", "Light Green", "Light Cyan", "Light Red",
    "Light Magenta", "Yellow", "White"
    };
  int color;
  set_bg (BLACK);
  clrscr ();
  for (color = 0; color < 16; color++)
    {
      set_fg ((color < 8) ? WHITE : BLACK);
      set_bg (color);
      put (color_names[color]);
      clreol ();
      put ("\n");
    }
}



int main ()
{
  Test test;
  test.activate_window ();
  StdWin::StdMessageLoop ();
  return 0;
}
