#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#include <pmio.h>
#include <stdlib.h>
#include "eventwin.h"
#include "pmstdio.h"


int origin_x = 1;
int origin_y = 1;
const char *pmio_fontspec = "10.System VIO";

static int pmiowidth = 80;
static int pmioheight = 25;
static int pmioeventbuffersize = 32;
static HEV pmio_startup_semaphore;
static TID pmio_thread_id;

class PMIOWindow: public PMEventWindow
{
  typedef PMEventWindow inherited;
  virtual MRESULT msg_create ();
public:
  void shutdown ();
  PMIOWindow ();
};

static PMIOWindow *pmio = 0;

MRESULT PMIOWindow::msg_create ()
{
  MRESULT ret = inherited::msg_create ();
  // Unblock the main thread
  DosPostEventSem (pmio_startup_semaphore);
  return ret;
}

void PMIOWindow::shutdown ()
{
  send_close ();
}

PMIOWindow::PMIOWindow ()
: PMEventWindow (pmio_fontspec, pmioeventbuffersize, pmiowidth, pmioheight)
{
}

void pmio_batch_on (void)
{
  if (pmio)
    pmio->batch_on ();
}

void pmio_batch_off (void)
{
  if (pmio)
    pmio->batch_off ();
}

void set_screen_size (int width, int height)
{
  if (pmio)
    pmio->set_screen_size (width, height);
  else
    {
      pmiowidth = width;
      pmioheight = height;
    }
}

void set_width (int width)
{
  if (pmio)
    pmio->set_width (width);
  else
    pmiowidth = width;
}

void set_height (int height)
{
  if (pmio)
    pmio->set_height (height);
  else
    pmioheight = height;
}

int get_screen_width (void)
{
  if (pmio)
    return pmio->get_screen_width ();
  else
    return pmiowidth;
}

int get_screen_height (void)
{
  if (pmio)
    return pmio->get_screen_height ();
  else
    return pmioheight;
}

void set_attr (unsigned char attr)
{
  if (pmio)
    pmio->set_attr (attr);
}

void set_fg (unsigned char fg_color)
{
  if (pmio)
    pmio->set_fg (fg_color);
}

void set_bg (unsigned char bg_color)
{
  if (pmio)
    pmio->set_bg (bg_color);
}

int getx (void)
{
  if (pmio)
    return origin_x + pmio->getx ();
  else
    return origin_x;
}

int gety (void)
{
  if (pmio)
    return origin_y + pmio->gety ();
  else
    return origin_y;
}

void gotoxy (int x, int y)
{
  if (pmio)
    pmio->gotoxy (x - origin_x, y - origin_y);
}

void put_raw (int len, const char *text)
{
  if (pmio)
    pmio->put_raw (len, text);
}

void put_tty (int len, const char *text)
{
  if (pmio)
    pmio->put_tty (len, text);
}

void put_std (int len, const char *text)
{
  if (pmio)
    pmio->put_std (len, text);
}

void set_cells (int len, const char *text)
{
  if (pmio)
    pmio->set_cells (len, text);
}

void clrscr (void)
{
  if (pmio)
    pmio->clrscr ();
}

void clreol (void)
{
  if (pmio)
    pmio->clreol ();
}

void scroll_window (int scroll_distance)
{
  if (pmio)
    pmio->scroll_window (scroll_distance);
}

void set_window (int x1, int y1, int x2, int y2)
{
  if (pmio)
    pmio->set_window (x1 - origin_x, y1 - origin_y,
		      x2 - origin_x, y2 - origin_y);
}

void unset_window (void)
{
  if (pmio)
    pmio->unset_window ();
}

void hide_cursor (void)
{
  if (pmio)
    pmio->hide_cursor ();
}

void set_cursor (int start_line, int stop_line)
{
  if (pmio)
    pmio->set_cursor (start_line, stop_line);
}

void set_cursor_color (int cursor_color)
{
  if (pmio)
    pmio->set_cursor_color (cursor_color);
}

int get_cursor_color (void)
{
  if (pmio)
    return pmio->get_cursor_color ();
  else
    return -1;
}

void *pmio_save_screen_content (void)
{
  if (pmio)
    return pmio->save_screen_content ();
  else
    return 0;
}

void pmio_restore_screen_content (void *p)
{
  if (pmio)
    pmio->restore_screen_content (p);
}

void pmio_main (long unsigned)
{
  // Create the standard PM gunk for this thread
  HAB hab = WinInitialize (0);
  HMQ hmq = WinCreateMsgQueue (hab, 0);
  
  // Start the pmio window
  pmio = new PMIOWindow;
  pmio->activate_window ();
  
  // Process all messages for the window
  QMSG qmsg;
  while (WinGetMsg (hab, &qmsg, 0, 0, 0))
    WinDispatchMsg (hab, &qmsg);
  
  // Make sure the window is shutdown
  pmio->destroy_window ();
  
  // Eliminate the PM data structures
  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  
  // We really should raise SIGTERM for the main thread.
  // This will terminate the main thread without predjudice
  DosExit (EXIT_PROCESS, 0);
}

void stop_pmio (void)
{
  pmio->shutdown ();
  DosWaitThread (&pmio_thread_id, DCWW_WAIT);
}

void start_pmio (void)
{
  int rc;
  if (pmio == 0)
    {
      DosCreateEventSem (0, &pmio_startup_semaphore, 0, FALSE);
      DosCreateThread (&pmio_thread_id, pmio_main, 0, 0, 1000000);
      do
	rc = DosWaitEventSem (pmio_startup_semaphore,
			      (unsigned) SEM_INDEFINITE_WAIT);
      while (rc == ERROR_INTERRUPT);
      atexit (stop_pmio);

      // Attach stdout/stderr to pmio window
      start_pmstdio ();
    }
}


void pmio_get_event (PMIOEvent *e)
{
  if (pmio && e)
    pmio->q->blocking_remove (e);
}

int pmio_event_availible (void)
{
  if (pmio)
    return pmio->q->event_availible ();
  else
    return 0;
}
