#define INCL_WININPUT
#include <os2.h>
#include "pmio.h"

/* Convert pmio event E into its equivalent character representation
 * C1 or function key representation C2.
 *
 * If the representation is a function key, C1 is zero.
 * If the event does not correspond to any known character or function key,
 * both C1 and C2 will be set to zero.
 */
void pmio_event_convert (const PMIOEvent *e, char *c1, char *c2)
{
#define CH(value) do { if (c1) *c1 = (value); return; } while (0)
#define FN(value) do { if (c2) *c2 = (value); return; } while (0)
#define NOKEY() do { if (c1) *c1 = 0; if (c2) *c2 = 0; return; } while (0)
  if (c1)
    *c1 = 0;
  if (c2)
    *c2 = 0;
  if (e->event_type != pmio_event_char)
    NOKEY ();
  if (e->e.key.flags & KC_KEYUP)
    NOKEY ();
  if (e->e.key.flags & KC_CHAR)
    {
      if (/* 0 <= e->e.key.charcode && */ e->e.key.charcode <= 255)
	CH (e->e.key.ch);
    }
  else if (e->e.key.flags & KC_CTRL)
    {
      if (e->e.key.flags & KC_VIRTUALKEY)
	switch (e->e.key.virtualkeycode)
	  {
	  case VK_F1: 
	    FN (94);
	  case VK_F2:
	    FN (95);
	  case VK_F3:
	    FN (96);
	  case VK_F4:
	    FN (97);
	  case VK_F5:
	    FN (98);
	  case VK_F6:
	    FN (99);
	  case VK_F7:
	    FN (100);
	  case VK_F8:
	    FN (101);
	  case VK_F9:
	    FN (102);
	  case VK_F10:
	    FN (103);
	  case VK_PRINTSCRN:
	    FN (114);
	  case VK_LEFT:
	    FN (115);
	  case VK_RIGHT:
	    FN (116);
	  case VK_END:
	    FN (117);
	  case VK_PAGEDOWN:
	    FN (118);
	  case VK_HOME:
	    FN (119);
	  case VK_PAGEUP:
	    FN (132);
	  case VK_F11:
	    FN (137);
	  case VK_F12:
	    FN (138);
	  case VK_NEWLINE:
	    CH (10);
	  case VK_BACKSPACE:
	    CH (0x7F);
	  }
      else
	{
	  if ('A' <= e->e.key.charcode && e->e.key.charcode <= 'Z')
	    CH (1 + (e->e.key.ch - 'A'));
	  else if ('a' <= e->e.key.charcode && e->e.key.charcode <= 'z')
	    CH (1 + (e->e.key.ch - 'a'));
	  else if (e->e.key.charcode == '@')
	    CH (0);  /* This obviously doesn't work right, 
			but what is the Right Thing to do here? */
	}
    }
  else if (e->e.key.flags & KC_ALT)
    {
      if (e->e.key.flags & KC_VIRTUALKEY)
	switch (e->e.key.virtualkeycode)
	  {
	  case VK_F1:
	    FN (104);
	  case VK_F2:
	    FN (105);
	  case VK_F3:
	    FN (106);
	  case VK_F4:
	    FN (107);
	  case VK_F5:
	    FN (108);
	  case VK_F6:
	    FN (109);
	  case VK_F7:
	    FN (110);
	  case VK_F8:
	    FN (111);
	  case VK_F9:
	    FN (112);
	  case VK_F10:
	    FN (113);
	  case VK_F11:
	    FN (139);
	  case VK_F12:
	    FN (140);
	  }
      else
	switch (e->e.key.charcode)
	  {
	  case 'Q':
	  case 'q':
	    FN (16);
	  case 'W':
	  case 'w':
	    FN (17);
	  case 'E':
	  case 'e':
	    FN (18);
	  case 'R':
	  case 'r':
	    FN (19);
	  case 'T':
	  case 't':
	    FN (20);
	  case 'Y':
	  case 'y':
	    FN (21);
	  case 'U':
	  case 'u':
	    FN (22);
	  case 'I':
	  case 'i':
	    FN (23);
	  case 'O':
	  case 'o':
	    FN (24);
	  case 'P':
	  case 'p':
	    FN (25);
	  case 'A':
	  case 'a':
	    FN (30);
	  case 'S':
	  case 's':
	    FN (31);
	  case 'D':
	  case 'd':
	    FN (32);
	  case 'F':
	  case 'f':
	    FN (33);
	  case 'G':
	  case 'g':
	    FN (34);
	  case 'H':
	  case 'h':
	    FN (35);
	  case 'J':
	  case 'j':
	    FN (36);
	  case 'K':
	  case 'k':
	    FN (37);
	  case 'L':
	  case 'l':
	    FN (38);
	  case 'Z':
	  case 'z':
	    FN (44);
	  case 'X':
	  case 'x':
	    FN (45);
	  case 'C':
	  case 'c':
	    FN (46);
	  case 'V':
	  case 'v':
	    FN (47);
	  case 'B':
	  case 'b':
	    FN (48);
	  case 'N':
	  case 'n':
	    FN (49);
	  case 'M':
	  case 'm':
	    FN (50);
	  case '1':
	    FN (120);
	  case '2':
	    FN (121);
	  case '3':
	    FN (122);
	  case '4':
	    FN (123);
	  case '5':
	    FN (124);
	  case '6':
	    FN (125);
	  case '7':
	    FN (126);
	  case '8':
	    FN (127);
	  case '9':
	    FN (128);
	  case '0':
	    FN (129);
	  case '-':
	    FN (130);
	  case '=':
	    FN (131);
	  }
    }
  else if (e->e.key.flags & KC_VIRTUALKEY)
    {
      /* A few vk's need special handling when used with just the
	 shift modifier */
      if (e->e.key.flags & KC_SHIFT)
	switch (e->e.key.virtualkeycode)
	  {
	  case VK_F1:
	    FN (84);
	  case VK_F2:
	    FN (85);
	  case VK_F3:
	    FN (86);
	  case VK_F4:
	    FN (87);
	  case VK_F5:
	    FN (88);
	  case VK_F6:
	    FN (89);
	  case VK_F7:
	    FN (90);
	  case VK_F8:
	    FN (91);
	  case VK_F9:
	    FN (92);
	  case VK_F10:
	    FN (93);
	  case VK_F11:
	    FN (133);
	  case VK_F12:
	    FN (134);
	  }
      switch (e->e.key.virtualkeycode)
	{
	case VK_BACKTAB:
	  FN (15);
	case VK_F1:
	  FN (59);
	case VK_F2:
	  FN (60);
	case VK_F3:
	  FN (61);
	case VK_F4:
	  FN (62);
	case VK_F5:
	  FN (63);
	case VK_F6:
	  FN (64);
	case VK_F7:
	  FN (65);
	case VK_F8:
	  FN (66);
	case VK_F9:
	  FN (67);
	case VK_F10:
	  FN (68);
	case VK_HOME:
	  FN (71);
	case VK_UP:
	  FN (72);
	case VK_PAGEUP:
	  FN (73);
	case VK_LEFT:
	  FN (75);
	case VK_RIGHT:
	  FN (77);
	case VK_END:
	  FN (79);
	case VK_DOWN:
	  FN (80);
	case VK_PAGEDOWN:
	  FN (81);
	case VK_INSERT:
	  FN (82);
	case VK_DELETE:
	  FN (83);
	case VK_F11:
	  FN (133);
	case VK_F12:
	  FN (134);
	case VK_TAB:
	  CH ('\t');
	case VK_ESC:
	  CH (27);
	}
    }
  NOKEY ();
}

// DOS Compatibility Functions
static char key;
static enum { key_none, key_character, key_function } keytype = key_none;

static void event_process (const PMIOEvent *e)
{
  char c1, c2;
  pmio_event_convert (e, &c1, &c2);
  if (c1 != 0)
    {
      key = c1;
      keytype = key_character;
    }
  else if (c2 != 0)
    {
      key = c2;
      keytype = key_function;
    }
}

static void event_try (void)
{
  while (keytype == key_none
	 && pmio_event_availible ())
    {
      PMIOEvent e;
      pmio_get_event (&e);
      event_process (&e);
    }
}

int kbhit (void)
{
  event_try ();
  return keytype != key_none;
}

char getch (void)
{
  event_try ();
  while (keytype == key_none)
    {
      PMIOEvent e;
      pmio_get_event (&e);
      event_process (&e);
    }
  if (keytype == key_character)
    {
      keytype = key_none;
      return key;
    }
  else /* keytype == key_function */
    {
      keytype = key_character;
      return 0;
    }
}

char getche (void)
{
  char c = getch ();
  put_std (1, &c);
  return c;
}
