/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/



#define INCL_PM
#include <os2.h>
#include "frame.h"
#ifndef NDEBUG
#define NDEBUG
#endif
#include "bugme.h"

MRESULT Frame::GenericWindowProcedure (HWND frame, USHORT msg, 
				       MPARAM mp1, MPARAM mp2)
{
  Frame *object = (Frame *) WinQueryWindowPtr (frame, QWL_USER);
  return object->WindowProcedure (msg, mp1, mp2);
}

MRESULT Frame::WindowProcedure (int msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg)
    {
#define SH(rect) BUGME(("%s:%d: " #rect " = %d,%d, %d,%d", __FILE__, __LINE__, (rect).xLeft, (rect).yBottom, (rect).xRight, (rect).yTop))


    case WM_WINDOWPOSCHANGED:
      BUGME(("%s:%d: WM_WINDOWPOSCHANGED", __FILE__, __LINE__));
      SWP *change = (SWP *) mp1;
      BUGME(("%s:%d: WM_WINDOWPOSCHANGED: Calling old winproc", 
	     __FILE__, __LINE__));
      MRESULT oldresult = old_wndproc (frame, msg, mp1, mp2);
      BUGME(("%s:%d: WM_WINDOWPOSCHANGED: Old proc returned %d",
	     __FILE__, __LINE__, oldresult));
      if ((change->fl & SWP_SIZE) && frame_mode == absolute_size)
	{
	  BUGME(("%s:%d: SWP_SIZE type change", __FILE__, __LINE__));
	  BUGME(("width requested is %d,%d", change->cx, change->cy));
	  // Calc current frame rectangle
	  RECTL rectl;
	  rectl.xLeft = change->x;
	  rectl.yBottom = change->y;
	  rectl.xRight = rectl.xLeft + change->cx;
	  rectl.yTop = rectl.yBottom + change->cy;
	  // Convert to client rectangle
	  WinCalcFrameRect (frame, &rectl, TRUE);
	  // See if it is the right size
	  if (rectl.xRight - rectl.xLeft != x
	      || rectl.yTop - rectl.yBottom != y)
	    {
	      // Not the right size!
	      BUGME(("altering to width %d,%d", x, y));
	      // Make it the right size
	      // Leave the top right corner where it is so that the window
	      // controls will still be availible to the user.
	      rectl.xRight = rectl.xLeft + x;
	      rectl.yBottom = rectl.yTop - y;
	      // Convert it to frame rectl
	      WinCalcFrameRect (frame, &rectl, FALSE);
	      // The resize accordingly
	      WinSetWindowPos (frame, 0,0,0,
			       rectl.xRight - rectl.xLeft,
			       rectl.yTop - rectl.yBottom,
			       SWP_SIZE);
	    }
	}
      return oldresult;

    case WM_QUERYTRACKINFO:
      // Call the base class windproc, fail if it fails
      MRESULT ret = old_wndproc (frame, msg, mp1, mp2);
      if (!ret)
	return ret;

      // Grab out the trackinfo pointer
      TRACKINFO *ti = (TRACKINFO *) mp2;

      // Calculate the client rectangle
      RECTL client_rectangle = ti->rclTrack;
      WinCalcFrameRect (frame, &client_rectangle, TRUE);

      // Determine the size of the vertical and horizontal overhead
      // imposed by the frame
      SH (ti->rclTrack);
      SH (client_rectangle);
#define RECT_WIDTH(r) ((r).xRight - (r).xLeft)
#define RECT_HEIGHT(r) ((r).yTop - (r).yBottom)
      int extra_x = RECT_WIDTH (ti->rclTrack) - RECT_WIDTH (client_rectangle);
      int extra_y = RECT_HEIGHT(ti->rclTrack) - RECT_HEIGHT(client_rectangle);
      BUGME(("%s:%d: extra_x = %d, extra_y = %d", __FILE__, __LINE__,
	     extra_x, extra_y));

      // Implement absolute sizing
      if (frame_mode == absolute_size)
	{
	  ti->ptlMinTrackSize.x = ti->ptlMaxTrackSize.x = x + extra_x;
	  ti->ptlMinTrackSize.y = ti->ptlMaxTrackSize.y = y + extra_y;
	}
      return ret;
    }
  return old_wndproc (frame, msg, mp1, mp2);
}

void Frame::attach (HWND aframe)
{
  frame = aframe;
  is_attached = 1;
  WinSetWindowPtr (frame, QWL_USER, this);
  old_wndproc = WinSubclassWindow (frame, GenericWindowProcedure);
}

Frame::Frame ()
: is_attached (0),
  frame_mode (normal)
{
}

MRESULT Frame::MsgQueryTrackInfo (unsigned short flags, TRACKINFO *trackinfo)
{
  if (frame_mode == normal)
    return old_wndproc (frame, WM_QUERYTRACKINFO, MPFROMSHORT (flags),
			MPFROMP (trackinfo));

  WinCalcFrameRect (frame, &trackinfo->rclTrack, TRUE);
  trackinfo->rclBoundary = trackinfo->rclTrack;
  trackinfo->fs = flags;
  RECTL *b = &trackinfo->rclBoundary;
  if (flags & TF_TOP)
    b->yTop = b->yBottom + y;
  else if (flags & TF_BOTTOM)
    b->yBottom = b->yTop - y;
  if (flags & TF_RIGHT)
    b->xRight = b->xLeft + x;
  else if (flags & TF_LEFT)
    b->xLeft = b->xRight - x;
  if (flags & (TF_TOP | TF_BOTTOM | TF_RIGHT | TF_LEFT))
    trackinfo->fs |= TF_ALLINBOUNDARY;

  return (MRESULT) TRUE;
}


void Frame::set_absolute_size (int ax, int ay)
{
  frame_mode = absolute_size;
  x = ax;
  y = ay;
  if (is_attached)
    {
      // Make this request take effect immediately
//      WinSetWindowPos (frame, 0, 0,0, ax,ay, SWP_SIZE);
    }
}
