#define INCL_PM
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include "stddia.h"
#include "diaman.h"
#include "pmman.h"
#include "bugme.h"
#include "manuals.h"

/***************************************/
/**** Renaming of inherited classes ****/
/***************************************/

class CB_ManualSection: public ComboBox
{
  virtual void enter();
protected:
  virtual void section_changed() = 0;
  CB_ManualSection(int id);
};

void CB_ManualSection::enter() 
{ 
  ENTRY (CB_ManualSection::enter); 
  section_changed (); 
}
CB_ManualSection::CB_ManualSection(int id): ComboBox(id) 
{
  ENTRY (CB_ManualSection::CB_ManualSection);
}

class CB_ManualPage: public ComboBox
{
  virtual void enter();
protected:
  virtual void page_selected() = 0;
  CB_ManualPage(int id);
};

void CB_ManualPage::enter() 
{ 
  ENTRY (CB_ManualPage::enter); 
  page_selected (); 
}
CB_ManualPage::CB_ManualPage(int id): ComboBox(id) 
{ 
  ENTRY (CB_ManualPage::CB_ManualPage);
}


/****************/
/**** Dialog ****/
/****************/

class ManualDialog: UserDialogBase, CB_ManualSection, CB_ManualPage, OKMessage
{
  virtual void section_changed();
  virtual void page_selected();
  virtual void dialog_init();
  virtual void ok_message();
  int current_section ();
  int current_page ();
  const char *final_text;
  char *final_section_selection, *init_section_selection;
  char *final_man_selection, *init_man_selection;
public:
  char *get_section ();
  char *get_man ();
  void set_section (const char *);
  void set_man (const char *);
  const char *result();
  void dialog(HWND owner);
  ManualDialog();
  virtual ~ManualDialog();
};

ManualDialog::ManualDialog()
: CB_ManualSection(ID_DIAMAN_SECTION), CB_ManualPage(ID_DIAMAN_MANPAGE),
  final_text(0),
  final_section_selection(0),
  final_man_selection(0),
  init_section_selection(0),
  init_man_selection(0)
{
  ENTRY (ManualDialog::ManualDialog);
}

ManualDialog::~ManualDialog()
{
  if (final_section_selection)
    free (final_section_selection);
  if (final_man_selection)
    free (final_man_selection);
  if (init_section_selection)
    free (init_section_selection);
  if (init_man_selection)
    free (init_man_selection);
}

void ManualDialog::dialog(HWND owner)
{
  ENTRY (ManualDialog::dialog);
  UserDialogBase::dialog(owner, ID_DIAMAN);
}

void ManualDialog::section_changed() 
{ 
  ENTRY (ManualDialog::section_changed);
  CB_ManualPage::deleteall();

  int index = current_section ();
  if (index == -1)
    return;

  // Fill the manpage combox with the appriopriate text
  const ManualSection *section = manual.get_manual_section(index);
  for (int i = 0; i < section->count(); i++)
    CB_ManualPage::insertitem_sortascending (section->man_page(i)->pagename);
  CB_ManualPage::selectitem(0);
}

void ManualDialog::page_selected() 
{ 
  ENTRY (ManualDialog::page_selected);
  send_ok_message ();
}

void ManualDialog::dialog_init() 
{ 
  ENTRY (ManualDialog::dialog_init);
  CB_ManualSection::deleteall();
  int i;
  for (i = 0; i < manual.count_of_sections(); i++)
    {
      CB_ManualSection::insertitem_sortascending (manual.get_section_name (i));
    }
  CB_ManualSection::selectitem(0);
  if (init_section_selection)
    CB_ManualSection::set_entryfield_text (init_section_selection);
  section_changed();
  if (init_man_selection)
    CB_ManualPage::set_entryfield_text (init_man_selection);
}

void ManualDialog::ok_message ()
{
  ENTRY (ManualDialog::ok_message);

  // Save of the current entries for later
  final_section_selection = CB_ManualSection::get_entryfield_text ();
  BUGME(("ManualDialog::ok_message: final_section_selection = '%s'",
	 final_section_selection));
  final_man_selection = CB_ManualPage::get_entryfield_text ();
  BUGME(("ManualDialog::ok_message: final_man_selection = '%s'",
	 final_man_selection));

  int section = current_section ();
  int page = current_page ();
  BUGME(("ManualDialog: section=%d, page=%d", section, page));
  if (section == -1 || page == -1)
    return;
  final_text = manual.get_manual_section (section)->man_page(page)->filename;
  BUGME(("ManualDialog: final_text = '%s'", final_text));
}

int ManualDialog::current_section ()
{
  ENTRY (ManualDialog::current_section);
  // Determine the currently selected item
  int selection = CB_ManualSection::queryselection();
  BUGME(("selection: %d", selection));
  if (selection == LIT_NONE)
    return -1;
  int selection_length = CB_ManualSection::queryitemtextlength (selection);
  BUGME(("selection_length: %d", selection_length));
  if (selection_length == LIT_ERROR)
    return -1;
  char selection_text[selection_length+1];
  CB_ManualSection::queryitemtext (selection, selection_length, 
				   selection_text);
  selection_text[selection_length] = '\0';
  BUGME(("selection: '%s'", selection_text));

  // Determine which section is selected
  int index;
  for (index = 0; index < manual.count_of_sections(); index++)
    {
      if (!strcmp (selection_text, manual.get_section_name (index)))
	break;
    }
  BUGME(("selection translates to %d", index));
  return (index >= manual.count_of_sections()) ? -1 : index;
}

int ManualDialog::current_page ()
{
  // Determine the currently selected item
  int selection = CB_ManualPage::queryselection();
  if (selection == LIT_NONE)
    return -1;
  int selection_length = CB_ManualPage::queryitemtextlength (selection);
  if (selection_length == LIT_ERROR)
    return -1;
  char selection_text[selection_length+1];
  CB_ManualPage::queryitemtext (selection, selection_length, 
				selection_text);
  selection_text[selection_length] = '\0';

  // Determine which page is selected
  int section_index = current_section ();
  if (section_index == -1)
    return -1;
  const ManualSection *section = manual.get_manual_section (section_index);
  int index;
  for (index = 0; index < section->count(); index++)
    {
      if (!strcmp (selection_text, section->man_page(index)->pagename))
	break;
    }
  return (index >= section->count()) ? -1 : index;
}

const char *ManualDialog::result()
{
  return final_text;
}

char *ManualDialog::get_section ()
{
  return (final_section_selection) ? strdup (final_section_selection) : 0;
}

char *ManualDialog::get_man ()
{
  return (final_man_selection) ? strdup (final_man_selection) : 0;
}

void ManualDialog::set_section (const char *section)
{
  init_section_selection = strdup (section);
}

void ManualDialog::set_man (const char *man)
{
  init_man_selection = strdup (man);
}

/****************************/
/**** External Interface ****/
/****************************/

static char *current_section = 0;
static char *current_man = 0;

const char *manual_select_dialog(HWND owner)
{
  C_ENTRY (manual_select_dialog);
  ManualDialog dialog;
  if (current_section)
    dialog.set_section (current_section);
  if (current_man)
    dialog.set_man (current_man);

  dialog.dialog (owner);

  if (current_section)
    free (current_section);
  current_section = dialog.get_section ();

  if (current_man)
    free (current_man);
  current_man = dialog.get_man ();

  return dialog.result ();
}
