diff -cr gdb-4.13/bfd/emx-aout.c g:gdb-4.13/bfd/emx-aout.c
*** gdb-4.13/bfd/emx-aout.c	Tue Jul 12 16:46:28 1994
--- g:gdb-4.13/bfd/emx-aout.c	Thu Oct 06 21:42:08 1994
***************
*** 1,4 ****
! /* BFD back-end for i386 a.out binaries.
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
  
  This file is part of BFD, the Binary File Descriptor library.
--- 1,4 ----
! /* BFD back-end for emx a.out binaries, derived from i386aout.c and aout-target.h
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
  
  This file is part of BFD, the Binary File Descriptor library.
***************
*** 27,55 ****
  #define N_HEADER_IN_TEXT(x) 0
  #define BYTES_IN_WORD 4
  
! #define N_TXTOFF(x) 0x20
! #define N_TXTADDR(x) (N_MAGIC(x)==ZMAGIC ? 0x1020 : 0)
  
! #define N_TXTSIZE(x) ((x).a_text)
! #if 0
! #define N_DATADDR(x) (N_MAGIC(x)==OMAGIC? (N_TXTADDR(x)+(x).a_text) : (SEGMENT_SIZE + ((0x1020+(x).a_text-1) & ~(SEGMENT_SIZE-1))))
! #define NOSUBEXECB
! 
! #endif
! #define PAGE_SIZE 4096
! #define SEGMENT_SIZE 0x400000
! #define DEFAULT_ARCH bfd_arch_i386
! 
! #define MY(OP) CAT(i386aout_,OP)
! #define TARGETNAME "a.out-i386"
  #define NO_WRITE_HEADER_KLUDGE 1
  
  #include "bfd.h"
  #include "sysdep.h"
  #include "libbfd.h"
  #include "libaout.h"
! static boolean MY(set_sizes)();
  #define MY_backend_data &MY(backend_data)
  static CONST struct aout_backend_data MY(backend_data) = {
    0,				/* zmagic contiguous */
    1,				/* text incl header */
--- 27,56 ----
  #define N_HEADER_IN_TEXT(x) 0
  #define BYTES_IN_WORD 4
  
! #define PAGE_SIZE       0x1000
! #define SEGMENT_SIZE    0x10000
! #define TEXT_START_ADDR 0x10000
! #define DEFAULT_ARCH    bfd_arch_i386
  
! #define MY(OP) CAT(emx_aout_,OP)
! #define TARGETNAME "a.out-emx"
  #define NO_WRITE_HEADER_KLUDGE 1
  
+ #define MY_object_p MY(object_p)
+ 
  #include "bfd.h"
+ 
+ static PROTO (const bfd_target *, MY(callback), (bfd *abfd));
+ static PROTO (const bfd_target *, MY(object_p), (bfd *abfd));
+ 
  #include "sysdep.h"
  #include "libbfd.h"
  #include "libaout.h"
! 
  #define MY_backend_data &MY(backend_data)
+ static boolean MY(set_sizes)();
+ 
+ 
  static CONST struct aout_backend_data MY(backend_data) = {
    0,				/* zmagic contiguous */
    1,				/* text incl header */
***************
*** 66,68 ****
--- 67,100 ----
  };
  
  #include "aout-target.h"
+ 
+ /* Finish up the reading of an a.out file header */
+ 
+ static const bfd_target *
+ DEFUN(MY(object_p),(abfd),
+      bfd *abfd)
+ {
+   struct external_exec exec_bytes;	/* Raw exec header from file */
+   struct internal_exec exec;		/* Cleaned-up exec header */
+   const bfd_target *target;
+   long org_pos, add;
+ 
+   org_pos = bfd_tell (abfd);
+   (void)_fseek_hdr(bfd_cache_lookup(abfd));
+   add = bfd_tell (abfd) - org_pos;
+   if (bfd_read ((PTR) &exec_bytes, 1, EXEC_BYTES_SIZE, abfd)
+       != EXEC_BYTES_SIZE) {
+     if (bfd_get_error () != bfd_error_system_call)
+       bfd_set_error (bfd_error_wrong_format);
+     return 0;
+   }
+ 
+   exec.a_info = bfd_h_get_32 (abfd, exec_bytes.e_info);
+ 
+   if (N_BADMAG (exec)) return 0;
+ 
+   NAME(aout,swap_exec_header_in)(abfd, &exec_bytes, &exec);
+   exec.emx_add = add;
+   target = NAME(aout,some_aout_object_p) (abfd, &exec, MY(callback));
+   return target;
+ }
diff -cr gdb-4.13/bfd/libaout.h g:gdb-4.13/bfd/libaout.h
*** gdb-4.13/bfd/libaout.h	Thu Jul 14 22:34:04 1994
--- g:gdb-4.13/bfd/libaout.h	Thu Oct 06 20:49:18 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* libaout.h -- changed for emx by Eberhard Mattes -- Nov 1993 */
+ 
  /* BFD back-end data structures for a.out (and similar) files.
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
     Written by Cygnus Support.
***************
*** 170,175 ****
--- 172,180 ----
  struct internal_exec
  {
      long a_info;		/* Magic number and flags, packed */
+ #if defined (__EMX__)
+     long emx_add;
+ #endif
      bfd_vma a_text;		/* length of text, in bytes  */
      bfd_vma a_data;		/* length of data, in bytes  */
      bfd_vma a_bss;		/* length of uninitialized data area in mem */
diff -cr gdb-4.13/bfd/sysdep.h g:gdb-4.13/bfd/sysdep.h
*** gdb-4.13/bfd/sysdep.h	Wed Nov 17 23:09:42 1993
--- g:gdb-4.13/bfd/sysdep.h	Thu Oct 06 21:24:16 1994
***************
*** 8,13 ****
--- 8,14 ----
  #include <string.h>
  #include <sys/file.h>
  
+ #define EMX
  #define	HAVE_STRERROR
  
  #define	POSIX_UTIME
diff -cr gdb-4.13/bfd/targets.c g:gdb-4.13/bfd/targets.c
*** gdb-4.13/bfd/targets.c	Thu Jul 14 22:34:38 1994
--- g:gdb-4.13/bfd/targets.c	Thu Oct 06 21:24:00 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* targets.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Generic target-file-type support for the BFD library.
     Copyright 1990, 91, 92, 93, 1994 Free Software Foundation, Inc.
     Written by Cygnus Support.
***************
*** 443,448 ****
--- 444,452 ----
  extern const bfd_target ecoff_big_vec;
  extern const bfd_target ecoff_little_vec;
  extern const bfd_target ecoffalpha_little_vec;
+ #ifdef EMX
+ extern const bfd_target emx_aout_vec;
+ #endif /* EMX */
  extern const bfd_target h8300coff_vec;
  extern const bfd_target h8500coff_vec;
  extern const bfd_target host_aout_vec;
diff -cr gdb-4.13/bfd/trad-cor.c g:gdb-4.13/bfd/trad-cor.c
*** gdb-4.13/bfd/trad-cor.c	Tue Jul 12 20:14:26 1994
--- g:gdb-4.13/bfd/trad-cor.c	Sun Oct 23 14:12:00 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* trad-cor.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* BFD back end for traditional Unix core files (U-area and raw sections)
     Copyright 1988, 1989, 1991, 1992, 1993, 1994 Free Software Foundation, Inc.
     Written by John Gilmore of Cygnus Support.
***************
*** 51,56 ****
--- 52,60 ----
    struct trad_core_struct 
      {
        asection *data_section;
+ #ifdef __EMX__
+       asection *heap_section;
+ #endif /* __EMX__ */
        asection *stack_section;
        asection *reg_section;
        struct user u;
***************
*** 58,63 ****
--- 62,70 ----
  
  #define core_upage(bfd) (&((bfd)->tdata.trad_core_data->u))
  #define core_datasec(bfd) ((bfd)->tdata.trad_core_data->data_section)
+ #ifdef __EMX__
+ #define core_heapsec(bfd) ((bfd)->tdata.trad_core_data->heap_section)
+ #endif /* __EMX__ */
  #define core_stacksec(bfd) ((bfd)->tdata.trad_core_data->stack_section)
  #define core_regsec(bfd) ((bfd)->tdata.trad_core_data->reg_section)
  
***************
*** 95,100 ****
--- 102,111 ----
      }
  
    /* Sanity check perhaps??? */
+ #ifdef __EMX__
+   if (u.u_magic != UMAGIC)
+     return 0;
+ #else /* !__EMX__ */
    if (u.u_dsize > 0x1000000)	/* Remember, it's in pages... */
      {
        bfd_set_error (bfd_error_wrong_format);
***************
*** 141,146 ****
--- 152,158 ----
        }
  #endif
    }
+ #endif /* !__EMX__ */
  
    /* OK, we believe you.  You're a core file (sure, sure).  */
  
***************
*** 175,192 ****
    }
    core_regsec (abfd) = (asection *) bfd_zmalloc (sizeof (asection));
    if (core_regsec (abfd) == NULL) {
      free ((void *)core_datasec (abfd));
      goto loser1;
    }
  
    core_stacksec (abfd)->name = ".stack";
    core_datasec (abfd)->name = ".data";
    core_regsec (abfd)->name = ".reg";
  
    core_stacksec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_datasec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_regsec (abfd)->flags = SEC_HAS_CONTENTS;
! 
    core_datasec (abfd)->_raw_size =  NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
--- 187,226 ----
    }
    core_regsec (abfd) = (asection *) bfd_zmalloc (sizeof (asection));
    if (core_regsec (abfd) == NULL) {
+ #ifdef EMX
+   loser2:
+ #endif /* EMX */
      free ((void *)core_datasec (abfd));
      goto loser1;
    }
+ #ifdef EMX
+   core_heapsec (abfd) = (asection *) bfd_zmalloc (sizeof (asection));
+   if (core_heapsec (abfd) == NULL) {
+     free ((void *)core_regsec (abfd));
+     goto loser2;
+   }
+ #endif /* EMX */
  
    core_stacksec (abfd)->name = ".stack";
    core_datasec (abfd)->name = ".data";
+ #ifdef EMX
+   core_heapsec (abfd)->name = ".heap";
+ #endif /* EMX */
    core_regsec (abfd)->name = ".reg";
  
    core_stacksec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_datasec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_regsec (abfd)->flags = SEC_HAS_CONTENTS;
! #ifdef EMX
!   core_heapsec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
! #endif /* EMX */
! 
! #ifdef EMX
!   core_datasec (abfd)->_raw_size =  u.u_data_end - u.u_data_base;
!   core_heapsec (abfd)->_raw_size = u.u_heap_brk - u.u_heap_base;
!   core_stacksec (abfd)->_raw_size = u.u_stack_end - u.u_stack_low;
!   core_regsec (abfd)->_raw_size = sizeof (struct user);
! #else /* not EMX */
    core_datasec (abfd)->_raw_size =  NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
***************
*** 194,202 ****
--- 228,242 ----
        ;
    core_stacksec (abfd)->_raw_size = NBPG * u.u_ssize;
    core_regsec (abfd)->_raw_size = NBPG * UPAGES; /* Larger than sizeof struct u */
+ #endif /* not EMX */
  
    /* What a hack... we'd like to steal it from the exec file,
       since the upage does not seem to provide it.  FIXME.  */
+ #ifdef EMX
+   core_datasec (abfd)->vma = u.u_data_base;
+   core_heapsec (abfd)->vma = u.u_heap_base;
+   core_stacksec (abfd)->vma = u.u_stack_low;
+ #else /* not EMX */
  #ifdef HOST_DATA_START_ADDR
    core_datasec (abfd)->vma = HOST_DATA_START_ADDR;
  #else
***************
*** 208,213 ****
--- 248,254 ----
  #else
    core_stacksec (abfd)->vma = HOST_STACK_END_ADDR - (NBPG * u.u_ssize);
  #endif
+ #endif /* not EMX */
  
    /* This is tricky.  As the "register section", we give them the entire
       upage and stack.  u.u_ar0 points to where "register 0" is stored.
***************
*** 225,247 ****
--- 266,303 ----
       using minor trickery to get around the offset-or-absolute-addr problem. */
    core_regsec (abfd)->vma = 0 - (int) u.u_ar0;
  
+ #ifdef EMX
+   core_datasec (abfd)->filepos = u.u_data_off;
+   core_heapsec (abfd)->filepos = u.u_heap_off;
+   core_stacksec (abfd)->filepos = u.u_stack_off;
+ #else /* not EMX */
    core_datasec (abfd)->filepos = NBPG * UPAGES;
    core_stacksec (abfd)->filepos = (NBPG * UPAGES) + NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
  #endif
        ;
+ #endif /* not EMX */
    core_regsec (abfd)->filepos = 0; /* Register segment is the upage */
  
    /* Align to word at least */
    core_stacksec (abfd)->alignment_power = 2;
    core_datasec (abfd)->alignment_power = 2;
+ #ifdef EMX
+   core_heapsec (abfd)->alignment_power = 2;
+ #endif /* EMX */
    core_regsec (abfd)->alignment_power = 2;
  
    abfd->sections = core_stacksec (abfd);
    core_stacksec (abfd)->next = core_datasec (abfd);
+ #ifdef EMX
+   core_datasec (abfd)->next = core_heapsec (abfd);
+   core_heapsec (abfd)->next = core_regsec (abfd);
+   abfd->section_count = 4;
+ #else /* not EMX */
    core_datasec (abfd)->next = core_regsec (abfd);
    abfd->section_count = 3;
+ #endif /* not EMX */
  
    return abfd->xvec;
  }
diff -cr gdb-4.13/gdb/annotate.c g:gdb-4.13/gdb/annotate.c
*** gdb-4.13/gdb/annotate.c	Wed May 18 01:59:10 1994
--- g:gdb-4.13/gdb/annotate.c	Sat Oct 08 23:49:48 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* annotate.c -- changed for emx by Eberhard Mattes -- Nov 1994 */
  /* Annotation routines for GDB.
     Copyright 1986, 1989, 1990, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 366,372 ****
--- 367,377 ----
    else
      printf_filtered ("\032\032");
  
+ #if defined (__EMX__)
+   printf_filtered ("%s;%d;%d;%s:", filename,
+ #else /* not __EMX__ */
    printf_filtered ("%s:%d:%d:%s:", filename,
+ #endif /* not __EMX__ */
  		   line, character,
  		   mid ? "middle" : "beg");
    print_address_numeric (pc, 0, gdb_stdout);
diff -cr gdb-4.13/gdb/command.c g:gdb-4.13/gdb/command.c
*** gdb-4.13/gdb/command.c	Sat Mar 26 16:14:56 1994
--- g:gdb-4.13/gdb/command.c	Sun Oct 09 00:42:10 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* command.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* Handle lists of commands, their decoding and documentation, for GDB.
     Copyright 1986, 1989, 1990, 1991 Free Software Foundation, Inc.
  
***************
*** 1219,1224 ****
--- 1221,1230 ----
    int rc, status, pid;
    char *p, *user_shell;
  
+ #if defined (__EMX__)
+   if (system ((arg == NULL ? "" : arg)) < 0)
+       error ("system() failed");
+ #else
    if ((user_shell = (char *) getenv ("SHELL")) == NULL)
      user_shell = "/bin/sh";
  
***************
*** 1246,1251 ****
--- 1252,1258 ----
        ;
    else
      error ("Fork failed");
+ #endif /* !defined (__EMX__) */
  #endif /* Can fork.  */
  }
  
diff -cr gdb-4.13/gdb/corelow.c g:gdb-4.13/gdb/corelow.c
*** gdb-4.13/gdb/corelow.c	Thu Feb 17 19:18:34 1994
--- g:gdb-4.13/gdb/corelow.c	Thu Oct 06 22:10:08 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* corelow.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Core dump and executable file functions below target vector, for GDB.
     Copyright 1986, 1987, 1989, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 133,147 ****
--- 134,165 ----
      }
  
    filename = tilde_expand (filename);
+ #if defined (__EMX__)
+     {
+       char tmp[512];
+       if (_fullpath (tmp, filename, sizeof (tmp)) == 0)
+         {
+           strlwr (tmp);
+           filename = strsave (tmp);
+         }
+       else
+         filename = strsave (filename);
+     }
+ #else
    if (filename[0] != '/') {
      temp = concat (current_directory, "/", filename, NULL);
      free (filename);
      filename = temp;
    }
+ #endif
  
    old_chain = make_cleanup (free, filename);
  
+ #if defined (__EMX__)
+   scratch_chan = open (filename, (write_files? O_RDWR: O_RDONLY) | O_BINARY, 0);
+ #else
    scratch_chan = open (filename, write_files? O_RDWR: O_RDONLY, 0);
+ #endif
    if (scratch_chan < 0)
      perror_with_name (filename);
  
diff -cr gdb-4.13/gdb/dbxread.c g:gdb-4.13/gdb/dbxread.c
*** gdb-4.13/gdb/dbxread.c	Thu Jul 14 22:31:18 1994
--- g:gdb-4.13/gdb/dbxread.c	Thu Oct 06 22:10:28 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* dbxread.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Read dbx symbol tables and convert to internal format, for GDB.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 1205,1211 ****
--- 1206,1214 ----
       for this source file out of the ELF symbol table, to compensate for
       Sun brain death.  This replaces the section_offsets in this psymtab,
       if successful.  */
+ #if !defined (__EMX__)
    elfstab_offset_sections (objfile, result);
+ #endif
  
    /* Deduce the source language from the filename for this psymtab. */
    psymtab_language = deduce_language_from_filename (filename);
diff -cr gdb-4.13/gdb/i386v-na.c g:gdb-4.13/gdb/i386v-na.c
*** gdb-4.13/gdb/i386v-na.c	Thu Aug 11 01:10:04 1994
--- g:gdb-4.13/gdb/i386v-na.c	Tue Nov 01 14:10:10 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* i386v-na.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Intel 386 native support for SYSV systems (pre-SVR4).
     Copyright (C) 1988, 1989, 1991, 1992, 1994 Free Software Foundation, Inc.
  
***************
*** 273,279 ****
  
  #endif /* TARGET_CAN_USE_HARDWARE_WATCHPOINT */
  
! #if 0
  /* using FLOAT_INFO as is would be a problem.  FLOAT_INFO is called
     via a command xxx and eventually calls ptrace without ever having
     traversed the target vector.  This would be terribly impolite
--- 274,372 ----
  
  #endif /* TARGET_CAN_USE_HARDWARE_WATCHPOINT */
  
! 
! #if defined (__EMX__)
! 
! /* Taken from i386-xdep.c of GDB 4.6 */
! /* and modified by Eberhard Mattes */
! 
! struct env387 
! {
!   unsigned short control;
!   unsigned short r0;
!   unsigned short status;
!   unsigned short r1;
!   unsigned short tag;
!   unsigned short r2;
!   unsigned long eip;
!   unsigned short code_seg;
!   unsigned short opcode;
!   unsigned long operand;
!   unsigned short operand_seg;
!   unsigned short r3;
!   unsigned char regs[8][10];
! };
! 
! static
! print_387_status (status, ep)
!      unsigned short status;
!      struct env387 *ep;
! {
!   int i;
!   int bothstatus;
!   int top;
!   int fpreg;
!   unsigned char *p;
!   
!   bothstatus = ((status != 0) && (ep->status != 0));
!   if (status != 0) 
!     {
!       if (bothstatus)
! 	printf ("u: ");
!       print_387_status_word (status);
!     }
!   
!   if (ep->status != 0) 
!     {
!       if (bothstatus)
! 	printf ("e: ");
!       print_387_status_word (ep->status);
!     }
!   
!   print_387_control_word (ep->control);
!   printf ("last exception: ");
!   printf ("opcode %s; ", local_hex_string(ep->opcode));
!   printf ("pc %s:", local_hex_string(ep->code_seg));
!   printf ("%s; ", local_hex_string(ep->eip));
!   printf ("operand %s", local_hex_string(ep->operand_seg));
!   printf (":%s\n", local_hex_string(ep->operand));
!   
!   top = (ep->status >> 11) & 7;
!   
!   printf ("reg    tag   msb              lsb  value\n");
!   for (fpreg = 7; fpreg >= 0; fpreg--) 
!     {
!       double val;
! 
!       printf ("st(%d): ", fpreg);
!       
!       switch ((ep->tag >> (((top + fpreg) & 7) * 2)) & 3)
! 	{
! 	case 0: printf ("valid "); break;
! 	case 1: printf ("zero  "); break;
! 	case 2: printf ("trap  "); break;
! 	case 3: printf ("empty "); break;
! 	}
!       for (i = 9; i >= 0; i--)
! 	printf ("%02x", ep->regs[fpreg][i]);
!       
!       floatformat_to_double (&floatformat_i387_ext, (char *)ep->regs[fpreg],
!                              &val);
!       printf ("  %g\n", val);
!     }
!   if (ep->r0)
!     warning ("reserved0 is %s\n", local_hex_string(ep->r0));
!   if (ep->r1)
!     warning ("reserved1 is %s\n", local_hex_string(ep->r1));
!   if (ep->r2)
!     warning ("reserved2 is %s\n", local_hex_string(ep->r2));
!   if (ep->r3)
!     warning ("reserved3 is %s\n", local_hex_string(ep->r3));
! }
! 
! #define U_FPSTATE(u) u.u_fpstate
! 
! /* __EMX__ #if 0 */
  /* using FLOAT_INFO as is would be a problem.  FLOAT_INFO is called
     via a command xxx and eventually calls ptrace without ever having
     traversed the target vector.  This would be terribly impolite
***************
*** 292,298 ****
--- 385,393 ----
    char fpvalid = 0;
    unsigned int rounded_addr;
    unsigned int rounded_size;
+ #if !defined (__EMX__)
    extern int corechan;
+ #endif
    int skip;
    
    uaddr = (char *)&u.u_fpvalid - (char *)&u;
***************
*** 356,359 ****
    print_387_status (fpstatep->status, (struct env387 *)fpstatep->state);
  }
  
! #endif /* never */
--- 451,454 ----
    print_387_status (fpstatep->status, (struct env387 *)fpstatep->state);
  }
  
! #endif
diff -cr gdb-4.13/gdb/inflow.c g:gdb-4.13/gdb/inflow.c
*** gdb-4.13/gdb/inflow.c	Fri Jul 29 21:58:06 1994
--- g:gdb-4.13/gdb/inflow.c	Thu Oct 06 22:47:18 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* inflow.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* Low level interface to ptrace, for GDB when running under Unix.
     Copyright 1986, 1987, 1989, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 26,31 ****
--- 28,36 ----
  #include "terminal.h"
  #include "target.h"
  #include "thread.h"
+ #if defined (__EMX__)
+ #include "gdbcmd.h"
+ #endif /* __EMX__ */
  
  #include <signal.h>
  #include <fcntl.h>
***************
*** 103,108 ****
--- 108,117 ----
  
  enum {yes, no, have_not_checked} gdb_has_a_terminal_flag = have_not_checked;
  
+ #if defined (__EMX__)
+ int switch_sessions = 1;
+ #endif
+ 
  /* Does GDB have a terminal (on stdin)?  */
  int
  gdb_has_a_terminal ()
***************
*** 201,206 ****
--- 210,219 ----
      {
        int result;
  
+ #ifdef __EMX__
+       if (switch_sessions)
+         ptrace (10, inferior_pid, 0, 2);
+ #endif /* __EMX__ */
  #ifdef F_GETFL
        /* Is there a reason this is being done twice?  It happens both
  	 places we use F_SETFL, so I'm inclined to think perhaps there
***************
*** 301,306 ****
--- 314,323 ----
  
        terminal_is_ours = 1;
  
+ #ifdef __EMX__
+       if (switch_sessions)
+         ptrace (10, inferior_pid, 0, 0);
+ #endif /* __EMX__ */
  #ifdef SIGTTOU
        if (job_control)
  	osigttou = (void (*) ()) signal (SIGTTOU, SIG_IGN);
***************
*** 683,688 ****
--- 700,715 ----
  
    add_com ("kill", class_run, kill_command,
  	   "Kill execution of program being debugged.");
+ 
+ #ifdef __EMX__
+   add_show_from_set
+     (add_set_cmd ("switch", class_run, var_boolean,
+                   (char *)&switch_sessions,
+                   "Set whether to switch to the child session when running "
+                   "the inferior.",
+                   &setlist),
+      &showlist);
+ #endif /* __EMX__ */
  
    inferior_pid = 0;
  
diff -cr gdb-4.13/gdb/infptrac.c g:gdb-4.13/gdb/infptrac.c
*** gdb-4.13/gdb/infptrac.c	Sun Jul 17 01:00:02 1994
--- g:gdb-4.13/gdb/infptrac.c	Thu Oct 06 22:17:18 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* infptrac.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Low level Unix child interface to ptrace, for GDB when running under Unix.
     Copyright 1988, 1989, 1990, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 448,458 ****
--- 449,467 ----
  	  buffer[i] = ptrace (PT_READ_I, inferior_pid,
  			      (PTRACE_ARG3_TYPE) addr, 0);
  	  if (errno)
+ #ifdef __EMX__
+             break;
+ #else
  	    return 0;
+ #endif
  	  QUIT;
  	}
  
        /* Copy appropriate bytes out of the buffer.  */
+ #ifdef __EMX__
+       if (i < count)
+         len = i * sizeof (int);
+ #endif
        memcpy (myaddr,
  	      (char *) buffer + (memaddr & (sizeof (PTRACE_XFER_TYPE) - 1)),
  	      len);
diff -cr gdb-4.13/gdb/infrun.c g:gdb-4.13/gdb/infrun.c
*** gdb-4.13/gdb/infrun.c	Thu Aug 11 06:26:50 1994
--- g:gdb-4.13/gdb/infrun.c	Thu Oct 06 22:17:42 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* infrun.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Target-struct-independent code to start (run) and stop an inferior process.
     Copyright 1986, 1987, 1988, 1989, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 41,46 ****
--- 42,53 ----
  #include <sys/file.h>
  #endif
  
+ #if defined (__EMX__)
+ #include "gdbcmd.h"
+ 
+ int close_sessions = 0;
+ #endif
+ 
  /* Prototypes for local functions */
  
  static void
***************
*** 1975,1980 ****
--- 1982,1995 ----
    register int i;
    register int numsigs;
  
+ #if defined (__EMX__)
+   add_show_from_set
+     (add_set_cmd ("close", class_run, var_boolean,
+                   (char *)&close_sessions,
+                   "Set whether to automatically close the next child session.",
+                   &setlist),
+       &showlist);
+ #endif
    add_info ("signals", signals_info,
  	    "What debugger does when program gets various signals.\n\
  Specify a signal number as argument to print info on that signal only.");
diff -cr gdb-4.13/gdb/inftarg.c g:gdb-4.13/gdb/inftarg.c
*** gdb-4.13/gdb/inftarg.c	Wed Jun 01 20:28:16 1994
--- g:gdb-4.13/gdb/inftarg.c	Thu Oct 06 23:17:34 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* inftarg.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* Target-vector operations for controlling Unix child processes, for GDB.
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
     Contributed by Cygnus Support.
***************
*** 219,225 ****
--- 221,231 ----
       char *arg;
       int from_tty;
  {
+ #if defined (__EMX__)
+   error ("Use the \"run\" command to start an emx child process.");
+ #else
    error ("Use the \"run\" command to start a Unix child process.");
+ #endif
  }
  
  /* Stub function which causes the inferior that runs it, to be ptrace-able
***************
*** 282,289 ****
--- 288,300 ----
  
  struct target_ops child_ops = {
    "child",			/* to_shortname */
+ #if defined (__EMX__)
+   "emx child process",		/* to_longname */
+   "emx child process (started by the \"run\" command).",	/* to_doc */
+ #else
    "Unix child process",		/* to_longname */
    "Unix child process (started by the \"run\" command).",	/* to_doc */
+ #endif
    child_open,			/* to_open */
    0,				/* to_close */
    child_attach,			/* to_attach */
diff -cr gdb-4.13/gdb/main.c g:gdb-4.13/gdb/main.c
*** gdb-4.13/gdb/main.c	Sun Aug 14 00:06:56 1994
--- g:gdb-4.13/gdb/main.c	Thu Oct 06 22:25:56 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* main.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Top level stuff for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 102,107 ****
--- 103,112 ----
      alloca (4 - i);
  #endif
  
+ #if defined (__EMX__)
+   (void)setvbuf (stdout, NULL, _IOLBF, BUFSIZ);
+ #endif
+ 
    /* If error() is called from initialization code, just exit */
    if (SET_TOP_LEVEL ()) {
      exit(1);
***************
*** 120,125 ****
--- 125,133 ----
    instream = stdin;
  
    getcwd (gdb_dirbuf, sizeof (gdb_dirbuf));
+ #ifdef EMX
+   strlwr (gdb_dirbuf);
+ #endif /* EMX */
    current_directory = gdb_dirbuf;
  
    /* Parse arguments and options.  */
diff -cr gdb-4.13/gdb/source.c g:gdb-4.13/gdb/source.c
*** gdb-4.13/gdb/source.c	Sun Aug 14 00:07:10 1994
--- g:gdb-4.13/gdb/source.c	Sat Oct 08 23:51:52 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* source.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* List lines of source files for GDB, the GNU debugger.
     Copyright (C) 1986, 1987, 1988, 1989, 1991 Free Software Foundation, Inc.
  
***************
*** 40,45 ****
--- 42,54 ----
  #define DIRNAME_SEPARATOR ':'
  #endif
  
+ #if defined (__EMX__)
+ /* The file positions computed by GDB don't match a text file's file
+    positions.  Use binary mode instead. */
+ #undef FOPEN_RT
+ #define FOPEN_RT "rb"
+ #endif /* __EMX__ */
+ 
  /* Prototypes for local functions. */
  
  static int
***************
*** 313,319 ****
--- 322,332 ----
  	  }
        }
  
+ #if defined (__EMX__)
+       if (PATHSEP (p[-1]))
+ #else
        if (p[-1] == '/')
+ #endif
  	/* Sigh. "foo/" => "foo" */
  	--p;
        *p = '\0';
***************
*** 326,332 ****
--- 339,349 ----
  	      name = current_directory;
  	      goto append;
  	    }
+ #if defined (__EMX__)
+ 	  else if (PATHSEP (p[-2]))
+ #else
  	  else if (p[-2] == '/')
+ #endif
  	    {
  	      if (p - name == 2)
  		{
***************
*** 348,355 ****
--- 365,377 ----
  
        if (name[0] == '~')
  	name = tilde_expand (name);
+ #if defined (__EMX__)
+       else if (name[0] != '$')
+         name = absfname (name);
+ #else
        else if (name[0] != '/' && name[0] != '$')
  	name = concat (current_directory, "/", name, NULL);
+ #endif
        else
  	name = savestring (name, p - name);
        make_cleanup (free, name);
***************
*** 539,545 ****
--- 561,571 ----
        }
  
        /* Remove trailing slashes */
+ #if defined (__EMX__)
+       while (len > 1 && PATHSEP (filename[len-1]))
+ #else
        while (len > 0 && filename[len-1] == '/')
+ #endif
         filename[--len] = 0;
  
        strcat (filename+len, "/");
***************
*** 553,561 ****
--- 579,594 ----
    if (filename_opened)
      if (fd < 0)
        *filename_opened = (char *) 0;
+ #if defined (__EMX__)
+     else if (ABSPATH (filename))
+ #else
      else if (filename[0] == '/')
+ #endif
        *filename_opened = savestring (filename, strlen (filename));
      else
+ #if defined (__EMX__)
+       *filename_opened = absfname (filename);
+ #else
        {
  	/* Beware the // my son, the Emacs barfs, the botch that catch... */
  	   
***************
*** 563,568 ****
--- 596,602 ----
  	   '/' == current_directory[strlen(current_directory)-1]? "": "/",
  				   filename, NULL);
        }
+ #endif
  
    return fd;
  }
***************
*** 582,588 ****
--- 616,626 ----
    /* Quick way out if we already know its full name */
    if (s->fullname) 
      {
+ #if defined (__EMX__)
+       result = open (s->fullname, O_RDONLY | O_BINARY);
+ #else
        result = open (s->fullname, O_RDONLY);
+ #endif
        if (result >= 0)
          return result;
        /* Didn't work -- free old one, try again. */
***************
*** 610,622 ****
--- 648,668 ----
        }
      }
  
+ #if defined (__EMX__)
+   result = openp (path, 0, s->filename, O_RDONLY | O_BINARY, 0, &s->fullname);
+ #else /* not __EMX__ */
    result = openp (path, 0, s->filename, O_RDONLY, 0, &s->fullname);
+ #endif /* not __EMX__ */
    if (result < 0)
      {
        /* Didn't work.  Try using just the basename. */
        p = basename (s->filename);
        if (p != s->filename)
+ #if defined (__EMX__)
+ 	result = openp (path, 0, p, O_RDONLY | O_BINARY, 0, &s->fullname);
+ #else /* not __EMX__ */
  	result = openp (path, 0, p, O_RDONLY, 0, &s->fullname);
+ #endif /* not __EMX__ */
      }
    if (result >= 0)
      {
***************
*** 886,891 ****
--- 932,941 ----
        printf_filtered ("%d\t", current_source_line++);
        do
  	{
+ #if defined (__EMX__)
+           if (c == '\r')
+             ; else
+ #endif
  	  if (c < 040 && c != '\t' && c != '\n' && c != '\r')
  	      printf_filtered ("^%c", c + 0100);
  	  else if (c == 0177)
***************
*** 1241,1246 ****
--- 1291,1299 ----
      if (c == EOF)
        break;
      do {
+ #if defined (__EMX__)
+      if (c != '\r')
+ #endif
        *p++ = c;
      } while (c != '\n' && (c = getc (stream)) >= 0);
  
***************
*** 1314,1319 ****
--- 1367,1375 ----
        if (c == EOF)
  	break;
        do {
+ #if defined (__EMX__)
+         if (c != '\r')
+ #endif
  	*p++ = c;
        } while (c != '\n' && (c = getc (stream)) >= 0);
  
diff -cr gdb-4.13/gdb/symtab.c g:gdb-4.13/gdb/symtab.c
*** gdb-4.13/gdb/symtab.c	Sun Jul 10 00:30:30 1994
--- g:gdb-4.13/gdb/symtab.c	Thu Oct 06 22:18:06 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* symtab.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Symbol table lookup for the GNU debugger, GDB.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994
               Free Software Foundation, Inc.
***************
*** 1926,1931 ****
--- 1927,1945 ----
        if (p[0] == ':' || p[0] == ' ' || p[0] == '\t')
  	break;
      }
+ #if defined (__EMX__)
+   if (p == *argptr + 1 && p[0] == ':' && p[1] != ':'
+       && isascii (p[-1]) && isalpha (p[-1]))
+     {
+       int i;
+ 
+       for (i = 1; p[i] != 0; ++i)
+         if (p[i] == ' ' || p[i] == '\t' || p[i] == ':')
+           break;
+       if (p[i] == ':')
+         p = p + i;
+     }
+ #endif
    while (p[0] == ' ' || p[0] == '\t') p++;
  
    if ((p[0] == ':') && !has_parens)
diff -cr gdb-4.13/gdb/terminal.h g:gdb-4.13/gdb/terminal.h
*** gdb-4.13/gdb/terminal.h	Fri Oct 08 23:18:18 1993
--- g:gdb-4.13/gdb/terminal.h	Sun Oct 09 00:42:02 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* terminal.h -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* Terminal interface definitions for GDB, the GNU Debugger.
     Copyright 1986, 1989, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 36,42 ****
--- 38,48 ----
  #undef TIOCSETN
  #define TIOCSETN TCSETA
  #undef TIOCSETP
+ #if defined (__EMX__)
+ #define TIOCSETP TCSETA
+ #else
  #define TIOCSETP TCSETAF
+ #endif
  #define TERMINAL struct termio
  
  #else /* sgtty */
diff -cr gdb-4.13/gdb/top.c g:gdb-4.13/gdb/top.c
*** gdb-4.13/gdb/top.c	Sun Aug 14 00:07:18 1994
--- g:gdb-4.13/gdb/top.c	Thu Oct 06 22:25:02 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* top.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* Top level stuff for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994
     Free Software Foundation, Inc.
***************
*** 1872,1877 ****
--- 1873,1881 ----
  {
    if (args) error ("The \"pwd\" command does not take an argument: %s", args);
    getcwd (gdb_dirbuf, sizeof (gdb_dirbuf));
+ #ifdef EMX
+   strlwr (gdb_dirbuf);
+ #endif /* EMX */
  
    if (!STREQ (gdb_dirbuf, current_directory))
      printf_unfiltered ("Working directory %s\n (canonically %s).\n",
***************
*** 1904,1909 ****
--- 1908,1916 ----
      perror_with_name (dir);
  
    len = strlen (dir);
+ #ifdef EMX
+   dir = current_directory = absfname (".");
+ #else /* not EMX */
    dir = savestring (dir, len - (len > 1 && dir[len-1] == '/'));
    if (dir[0] == '/')
      current_directory = dir;
***************
*** 1955,1960 ****
--- 1962,1968 ----
  	  ++p;
  	}
      }
+ #endif /* not EMX */
  
    forget_cached_source_info ();
  
***************
*** 2280,2286 ****
--- 2288,2298 ----
      /* We include the current directory so that if the user changes
         directories the file written will be the same as the one
         that was read.  */
+ #ifdef EMX
+     history_filename = absfname ("!gdb_history");
+ #else /* not EMX */
      history_filename = concat (current_directory, "/.gdb_history", NULL);
+ #endif /* not EMX */
    }
    read_history (history_filename);
  }
diff -cr gdb-4.13/gdb/utils.c g:gdb-4.13/gdb/utils.c
*** gdb-4.13/gdb/utils.c	Sun Aug 14 00:07:20 1994
--- g:gdb-4.13/gdb/utils.c	Sun Oct 09 00:47:36 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* utils.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* General utility routines for GDB, the GNU debugger.
     Copyright 1986, 1989, 1990, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 67,72 ****
--- 69,78 ----
  #define ISATTY(FP)	(isatty (fileno (FP)))
  #endif
  
+ #if defined (__EMX__)
+   extern FILE *gdbrxStream;
+ #endif
+ 
  /* Chain of cleanup actions established with make_cleanup,
     to be executed if an error happens.  */
  
***************
*** 539,545 ****
--- 545,555 ----
    /* Restore the signal handler.  Harmless with BSD-style signals, needed
       for System V-style signals.  So just always do it, rather than worrying
       about USG defines and stuff like that.  */
+ #if defined (__EMX__)
+   signal (signo, SIG_ACK);
+ #else /* not __EMX__ */
    signal (signo, request_quit);
+ #endif /* not __EMX__ */
  
  #ifdef REQUEST_QUIT
    REQUEST_QUIT;
***************
*** 1070,1075 ****
--- 1080,1088 ----
  {
    char *ignore;
    char cont_prompt[120];
+ #if defined (__EMX__)
+   int old_quit;
+ #endif /* __EMX__ */
  
    if (annotation_level > 1)
      printf_unfiltered ("\n\032\032pre-prompt-for-continue\n");
***************
*** 1084,1090 ****
--- 1097,1107 ----
       screen.  */
    reinitialize_more_filter ();
  
+ #if defined (__EMX__)
+   old_quit = immediate_quit; immediate_quit = 0;
+ #else /* not __EMX__ */
    immediate_quit++;
+ #endif /* not __EMX__ */
    /* On a real operating system, the user can quit with SIGINT.
       But not on GO32.
  
***************
*** 1109,1115 ****
--- 1126,1136 ----
  	request_quit (SIGINT);
        free (ignore);
      }
+ #if defined (__EMX__)
+   immediate_quit = old_quit;
+ #else
    immediate_quit--;
+ #endif
  
    /* Now we have to do this again, so that GDB will know that it doesn't
       need to save the ---Type <return>--- line at the top of the screen.  */
***************
*** 1237,1242 ****
--- 1258,1271 ----
  
    if (linebuffer == 0)
      return;
+ 
+ #if defined (__EMX__)
+   if ((stream == stdout || stream == stderr) && gdbrxStream != NULL)
+     {
+       fputs (linebuffer, gdbrxStream);
+       return;
+     }
+ #endif
    
    /* Don't do any filtering if it is disabled.  */
    if (stream != gdb_stdout
***************
*** 1782,1790 ****
--- 1811,1855 ----
       &showprintlist);
  }
  
+ #if defined (__EMX__)
+ 
+ char *
+ absfname (filename)
+      char *filename;
+   {
+     char tmp[512];
+ 
+     if (_fullpath (tmp, filename, sizeof (tmp)) == 0)
+       {
+         strlwr (tmp);
+         filename = tmp;
+       }
+     return strsave (filename);
+   }
+ 
+ char *
+ tilde_expand (filename)
+      char *filename;
+   {
+     return (strsave (filename));
+   }
+ 
+ #endif
+ 
  /* Machine specific function to handle SIGWINCH signal. */
  
  #ifdef  SIGWINCH_HANDLER_BODY
          SIGWINCH_HANDLER_BODY
  #endif
  
+ 
+ #if defined (__EMX__)
+ 
+ int emx_isatty (int fd)
+ {
+   int ht;
+ 
+   return (ioctl (fd, FGETHTYPE, &ht) >= 0 && ht != HT_FILE);
+ }
+ 
+ #endif /* __EMX__ */
diff -cr gdb-4.13/libibert/argv.c g:gdb-4.13/libibert/argv.c
*** gdb-4.13/libibert/argv.c	Fri Apr 08 20:51:54 1994
--- g:gdb-4.13/libibert/argv.c	Thu Oct 06 20:49:22 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* argv.c -- changed for emx by Eberhard Mattes -- Nov 1993 */
+ 
  /* Create and destroy argument vectors (argv's)
     Copyright (C) 1992 Free Software Foundation, Inc.
     Written by Fred Fish @ Cygnus Support
***************
*** 40,46 ****
--- 42,50 ----
  
  #define isspace(ch) ((ch) == ' ' || (ch) == '\t')
  
+ #if !defined (__EMX__)
  #include "alloca-conf.h"
+ #endif
  
  #include "ansidecl.h"
  #include "libiberty.h"
diff -cr gdb-4.13/libibert/cplus-de.c g:gdb-4.13/libibert/cplus-de.c
*** gdb-4.13/libibert/cplus-de.c	Wed Jun 29 08:27:58 1994
--- g:gdb-4.13/libibert/cplus-de.c	Thu Oct 06 20:49:24 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* cplus-de.c -- changed for emx by Eberhard Mattes -- May 1994 */
  /* Demangler for GNU C++ 
     Copyright 1989, 1991 Free Software Foundation, Inc.
     Written by James Clark (jjc@jclark.uucp)
***************
*** 199,205 ****
  #endif
  
  static int
! demangle_template PARAMS ((struct work_stuff *work, CONST char **, string *,
  			   string *));
  
  static int
--- 200,206 ----
  #endif
  
  static int
! demangle_template PARAMS ((struct work_stuff *, CONST char **, string *,
  			   string *));
  
  static int
diff -cr gdb-4.13/libibert/strsigna.c g:gdb-4.13/libibert/strsigna.c
*** gdb-4.13/libibert/strsigna.c	Mon Feb 21 02:24:20 1994
--- g:gdb-4.13/libibert/strsigna.c	Thu Oct 06 21:20:24 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* strsigna.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* Extended support for using signal values.
     Copyright (C) 1992 Free Software Foundation, Inc.
     Written by Fred Fish.  fnf@cygnus.com
***************
*** 21,27 ****
--- 23,31 ----
  #include "ansidecl.h"
  #include "libiberty.h"
  
+ #if !defined (__EMX__)
  #include "config.h"
+ #endif
  
  #ifdef LOSING_SYS_SIGLIST
  #define sys_siglist no_such_symbol
***************
*** 227,232 ****
--- 231,241 ----
  #if defined (SIGSAK)
    ENTRY(SIGSAK, "SIGSAK", "Secure attention"),
  #endif
+ #if defined (__EMX__)
+ #if defined (SIGBREAK)
+   {SIGBREAK, "BREAK", "Break"},
+ #endif
+ #endif /* __EMX__ */
    ENTRY(0, NULL, NULL)
  };
  
diff -cr gdb-4.13/readline/emacs_ke.c g:gdb-4.13/readline/emacs_ke.c
*** gdb-4.13/readline/emacs_ke.c	Sun Jan 16 04:39:24 1994
--- g:gdb-4.13/readline/emacs_ke.c	Thu Oct 06 21:11:00 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* emacs_ke.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* emacs_keymap.c -- the keymap for emacs_mode in readline (). */
  
  /* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.
***************
*** 33,39 ****
--- 34,44 ----
  KEYMAP_ENTRY_ARRAY emacs_standard_keymap = {
  
    /* Control keys. */
+ #if defined (__EMX__)
+   { ISKMAP, (Function *)emacs_emx_keymap }, /* Control-@ */
+ #else
    { ISFUNC, (Function *)0x0 },		/* Control-@ */
+ #endif
    { ISFUNC, rl_beg_of_line },		/* Control-a */
    { ISFUNC, rl_backward },		/* Control-b */
    { ISFUNC, (Function *)0x0 },		/* Control-c */
***************
*** 883,885 ****
--- 888,1025 ----
    { ISFUNC, (Function *)0x0 }
  #endif /* KEYMAP_SIZE > 128 */
  };
+ 
+ #if defined (__EMX__)
+ 
+ KEYMAP_ENTRY_ARRAY emacs_emx_keymap = {
+   { ISFUNC, (Function *)0x0 },      /*   0 */
+   { ISFUNC, (Function *)0x0 },      /*   1 */
+   { ISFUNC, (Function *)0x0 },      /*   2 */
+   { ISFUNC, (Function *)0x0 },      /*   3 */
+   { ISFUNC, (Function *)0x0 },      /*   4 */
+   { ISFUNC, (Function *)0x0 },      /*   5 */
+   { ISFUNC, (Function *)0x0 },      /*   6 */
+   { ISFUNC, (Function *)0x0 },      /*   7 */
+   { ISFUNC, (Function *)0x0 },      /*   8 */
+   { ISFUNC, (Function *)0x0 },      /*   9 */
+   { ISFUNC, (Function *)0x0 },      /*  10 */
+   { ISFUNC, (Function *)0x0 },      /*  11 */
+   { ISFUNC, (Function *)0x0 },      /*  12 */
+   { ISFUNC, (Function *)0x0 },      /*  13 */
+   { ISFUNC, (Function *)0x0 },      /*  14 */
+   { ISFUNC, (Function *)0x0 },      /*  15 */
+   { ISFUNC, (Function *)0x0 },      /*  16 */
+   { ISFUNC, (Function *)0x0 },      /*  17 */
+   { ISFUNC, (Function *)0x0 },      /*  18 */
+   { ISFUNC, (Function *)0x0 },      /*  19 */
+   { ISFUNC, (Function *)0x0 },      /*  20 */
+   { ISFUNC, (Function *)0x0 },      /*  21 */
+   { ISFUNC, (Function *)0x0 },      /*  22 */
+   { ISFUNC, (Function *)0x0 },      /*  23 */
+   { ISFUNC, (Function *)0x0 },      /*  24 */
+   { ISFUNC, (Function *)0x0 },      /*  25 */
+   { ISFUNC, (Function *)0x0 },      /*  26 */
+   { ISFUNC, (Function *)0x0 },      /*  27 */
+   { ISFUNC, (Function *)0x0 },      /*  28 */
+   { ISFUNC, (Function *)0x0 },      /*  29 */
+   { ISFUNC, (Function *)0x0 },      /*  30 */
+   { ISFUNC, (Function *)0x0 },      /*  31 */
+   { ISFUNC, (Function *)0x0 },      /*  32 */
+   { ISFUNC, (Function *)0x0 },      /*  33 */
+   { ISFUNC, (Function *)0x0 },      /*  34 */
+   { ISFUNC, (Function *)0x0 },      /*  35 */
+   { ISFUNC, (Function *)0x0 },      /*  36 */
+   { ISFUNC, (Function *)0x0 },      /*  37 */
+   { ISFUNC, (Function *)0x0 },      /*  38 */
+   { ISFUNC, (Function *)0x0 },      /*  39 */
+   { ISFUNC, (Function *)0x0 },      /*  40 */
+   { ISFUNC, (Function *)0x0 },      /*  41 */
+   { ISFUNC, (Function *)0x0 },      /*  42 */
+   { ISFUNC, (Function *)0x0 },      /*  43 */
+   { ISFUNC, (Function *)0x0 },      /*  44 */
+   { ISFUNC, (Function *)0x0 },      /*  45 */
+   { ISFUNC, (Function *)0x0 },      /*  46 */
+   { ISFUNC, (Function *)0x0 },      /*  47 */
+   { ISFUNC, (Function *)0x0 },      /*  48 */
+   { ISFUNC, (Function *)0x0 },      /*  49 */
+   { ISFUNC, (Function *)0x0 },      /*  50 */
+   { ISFUNC, (Function *)0x0 },      /*  51 */
+   { ISFUNC, (Function *)0x0 },      /*  52 */
+   { ISFUNC, (Function *)0x0 },      /*  53 */
+   { ISFUNC, (Function *)0x0 },      /*  54 */
+   { ISFUNC, (Function *)0x0 },      /*  55 */
+   { ISFUNC, (Function *)0x0 },      /*  56 */
+   { ISFUNC, (Function *)0x0 },      /*  57 */
+   { ISFUNC, (Function *)0x0 },      /*  58 */
+   { ISFUNC, (Function *)0x0 },      /*  59 */
+   { ISFUNC, (Function *)0x0 },      /*  60 */
+   { ISFUNC, (Function *)0x0 },      /*  61 */
+   { ISFUNC, (Function *)0x0 },      /*  62 */
+   { ISFUNC, (Function *)0x0 },      /*  63 */
+   { ISFUNC, (Function *)0x0 },      /*  64 */
+   { ISFUNC, (Function *)0x0 },      /*  65 */
+   { ISFUNC, (Function *)0x0 },      /*  66 */
+   { ISFUNC, (Function *)0x0 },      /*  67 */
+   { ISFUNC, (Function *)0x0 },      /*  68 */
+   { ISFUNC, (Function *)0x0 },      /*  69 */
+   { ISFUNC, (Function *)0x0 },      /*  70 */
+   { ISFUNC, rl_beg_of_line },       /*  71: home */
+   { ISFUNC, rl_get_previous_history }, /*  72: cursor up */
+   { ISFUNC, rl_beginning_of_history }, /*  73: page up */
+   { ISFUNC, (Function *)0x0 },      /*  74 */
+   { ISFUNC, rl_backward },          /*  75: cursor left */
+   { ISFUNC, (Function *)0x0 },      /*  76: center cursor */
+   { ISFUNC, rl_forward },           /*  77: cursor right */
+   { ISFUNC, (Function *)0x0 },      /*  78 */
+   { ISFUNC, rl_end_of_line },       /*  79: end */
+   { ISFUNC, rl_get_next_history },  /*  80: cursor down */
+   { ISFUNC, rl_end_of_history },    /*  81: page down */
+   { ISFUNC, (Function *)0x0 },      /*  82: ins */
+   { ISFUNC, rl_delete },            /*  83: del */
+   { ISFUNC, (Function *)0x0 },      /*  84 */
+   { ISFUNC, (Function *)0x0 },      /*  85 */
+   { ISFUNC, (Function *)0x0 },      /*  86 */
+   { ISFUNC, (Function *)0x0 },      /*  87 */
+   { ISFUNC, (Function *)0x0 },      /*  88 */
+   { ISFUNC, (Function *)0x0 },      /*  89 */
+   { ISFUNC, (Function *)0x0 },      /*  90 */
+   { ISFUNC, (Function *)0x0 },      /*  91 */
+   { ISFUNC, (Function *)0x0 },      /*  92 */
+   { ISFUNC, (Function *)0x0 },      /*  93 */
+   { ISFUNC, (Function *)0x0 },      /*  94 */
+   { ISFUNC, (Function *)0x0 },      /*  95 */
+   { ISFUNC, (Function *)0x0 },      /*  96 */
+   { ISFUNC, (Function *)0x0 },      /*  97 */
+   { ISFUNC, (Function *)0x0 },      /*  98 */
+   { ISFUNC, (Function *)0x0 },      /*  99 */
+   { ISFUNC, (Function *)0x0 },      /* 100 */
+   { ISFUNC, (Function *)0x0 },      /* 101 */
+   { ISFUNC, (Function *)0x0 },      /* 102 */
+   { ISFUNC, (Function *)0x0 },      /* 103 */
+   { ISFUNC, (Function *)0x0 },      /* 104 */
+   { ISFUNC, (Function *)0x0 },      /* 105 */
+   { ISFUNC, (Function *)0x0 },      /* 106 */
+   { ISFUNC, (Function *)0x0 },      /* 107 */
+   { ISFUNC, (Function *)0x0 },      /* 108 */
+   { ISFUNC, (Function *)0x0 },      /* 109 */
+   { ISFUNC, (Function *)0x0 },      /* 110 */
+   { ISFUNC, (Function *)0x0 },      /* 111 */
+   { ISFUNC, (Function *)0x0 },      /* 112 */
+   { ISFUNC, (Function *)0x0 },      /* 113 */
+   { ISFUNC, (Function *)0x0 },      /* 114 */
+   { ISFUNC, rl_backward_word },     /* 115: ctrl cursor left */
+   { ISFUNC, rl_forward_word },      /* 116: ctrl cursor right */
+   { ISFUNC, rl_kill_line },         /* 117: ctrl end */
+   { ISFUNC, (Function *)0x0 },      /* 118: ctrl page down */
+   { ISFUNC, rl_backward_kill_line },/* 119: ctrl home */
+   { ISFUNC, (Function *)0x0 },      /* 120: alt 1 */
+   { ISFUNC, (Function *)0x0 },      /* 121 */
+   { ISFUNC, (Function *)0x0 },      /* 122 */
+   { ISFUNC, (Function *)0x0 },      /* 123 */
+   { ISFUNC, (Function *)0x0 },      /* 124 */
+   { ISFUNC, (Function *)0x0 },      /* 125 */
+   { ISFUNC, (Function *)0x0 },      /* 126 */
+   { ISFUNC, (Function *)0x0 },      /* 127 */
+ };
+ 
+ #endif
diff -cr gdb-4.13/readline/history.c g:gdb-4.13/readline/history.c
*** gdb-4.13/readline/history.c	Sun Jun 12 11:54:44 1994
--- g:gdb-4.13/readline/history.c	Thu Oct 06 20:51:48 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* history.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* History.c -- standalone history library */
  
  /* Copyright (C) 1989, 1992 Free Software Foundation, Inc.
***************
*** 469,477 ****
--- 471,484 ----
        if (!home)
  	home = ".";
  
+ #ifdef __EMX__
+       return_val = (char *)xmalloc (2 + strlen (home) + strlen ("!history"));
+       sprintf (return_val, "%s/!history", home);
+ #else /* not __EMX__ */
        return_val = (char *)xmalloc (2 + strlen (home) + strlen (".history"));
  
        sprintf (return_val, "%s/.history", home);
+ #endif /* not __EMX__ */
      }
  
    return (return_val);
diff -cr gdb-4.13/readline/keymaps.h g:gdb-4.13/readline/keymaps.h
*** gdb-4.13/readline/keymaps.h	Thu Feb 24 13:19:20 1994
--- g:gdb-4.13/readline/keymaps.h	Thu Oct 06 20:52:24 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* keymaps.h -- changed for emx by Eberhard Mattes -- Oct 1994 */
+ 
  /* keymaps.h -- Manipulation of readline keymaps. */
  
  /* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.
***************
*** 64,69 ****
--- 66,74 ----
  #define ISMACR 2
  
  extern KEYMAP_ENTRY_ARRAY emacs_standard_keymap, emacs_meta_keymap, emacs_ctlx_keymap;
+ #ifdef __EMX__
+ extern KEYMAP_ENTRY_ARRAY emacs_emx_keymap;
+ #endif /* __EMX__ */
  extern KEYMAP_ENTRY_ARRAY vi_insertion_keymap, vi_movement_keymap;
  
  /* Return a new, empty keymap.
diff -cr gdb-4.13/readline/readline.c g:gdb-4.13/readline/readline.c
*** gdb-4.13/readline/readline.c	Thu Jun 30 23:31:44 1994
--- g:gdb-4.13/readline/readline.c	Thu Oct 06 23:13:16 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* readline.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* readline.c -- a general facility for reading lines of input
     with emacs style editing and completion. */
  
***************
*** 1165,1170 ****
--- 1166,1180 ----
        screenheight = (int) window_size.ws_row;
      }
  #endif /* TIOCGWINSZ */
+ 
+ #if defined (__EMX__)
+   {
+     int size[2];
+ 
+     _scrsize (size);
+     screenwidth = size[0]; screenheight = size[1];
+   }
+ #endif /* __EMX__ */
  
    /* Environment variable COLUMNS overrides setting of "co" if IGNORE_ENV
       is unset. */
diff -cr gdb-4.13/readline/rldefs.h g:gdb-4.13/readline/rldefs.h
*** gdb-4.13/readline/rldefs.h	Wed May 04 22:42:12 1994
--- g:gdb-4.13/readline/rldefs.h	Thu Oct 06 23:13:12 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* rldefs.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* rldefs.h -- an attempt to isolate some of the system-specific defines
     for readline.  This should be included after any files that define
     system-specific constants like _POSIX_VERSION or USG. */
***************
*** 43,48 ****
--- 44,53 ----
  #undef NEW_TTY_DRIVER
  #undef HAVE_BSD_SIGNALS
  #endif
+ 
+ #ifdef __EMX__
+ #undef HAVE_BSD_SIGNALS
+ #endif /* __EMX__ */
  
  #if defined (__linux__)
  #  include <termcap.h>
diff -cr gdb-4.13/readline/rltty.c g:gdb-4.13/readline/rltty.c
*** gdb-4.13/readline/rltty.c	Fri Jul 08 21:23:56 1994
--- g:gdb-4.13/readline/rltty.c	Thu Oct 06 21:05:18 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* rltty.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* rltty.c -- functions to prepare and restore the terminal for readline's
     use. */
  
***************
*** 401,406 ****
--- 402,410 ----
  {
    readline_echoing_p = (otio.c_lflag & ECHO);
  
+ #if defined (__EMX__)
+   tiop->c_lflag &= ~IDEFAULT;
+ #endif /* __EMX__ */
    tiop->c_lflag &= ~(ICANON | ECHO);
  
    if ((unsigned char) otio.c_cc[VEOF] != (unsigned char) _POSIX_VDISABLE)
diff -cr gdb-4.13/readline/signals.c g:gdb-4.13/readline/signals.c
*** gdb-4.13/readline/signals.c	Tue May 10 00:02:06 1994
--- g:gdb-4.13/readline/signals.c	Thu Oct 06 21:03:56 1994
***************
*** 1,3 ****
--- 1,4 ----
+ /* signals.c -- changed for emx by Eberhard Mattes -- Oct 1994 */
  /* signals.c -- signal handling support for readline. */
  
  /* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.
***************
*** 151,156 ****
--- 152,160 ----
        rl_deprep_terminal ();
        rl_clear_signals ();
        rl_pending_input = 0;
+ #if defined (__EMX__)
+       signal (sig, SIG_ACK);
+ #endif /* __EMX__ */
  
        kill (getpid (), sig);
  
