     REM
     REM                      SATSAT1.BAS
     REM
     REM     This BASIC program computes and displays the locations
     REM  of Saturn's Satellites for a given date and time.  See
     REM  "Practical Astronomy with your Calculator" by Peter
     REM  Duffett-Smith and the Astronomical Almanac for explanations
     REM  of some of the calculations here.  The code is included so
     REM  that users can make changes or convert to another language.
     REM  This code was made for QBASIC (comes with DOS 5.0 or greater).
     REM
     NMF$ = "SATSAT1"
     MODE = 1
     IF MODE = 1 THEN XMAX = 639: YMAX = 479: RATYX = 1: SCREEN 12: WIDTH 80, 30: STRT = 17
     IF MODE = 2 THEN XMAX = 639: YMAX = 349: RATYX = 480 / 350: SCREEN 9: WIDTH 80, 43: STRT = 24
     REM ************************ CONSTANTS *********************************
     REM # means double-precision, $ means string
     DIM SMA(10), E(10), U(10), U0(10), CS(10), N$(10), PD#(10), RSS(10)
     PI = 3.14159265#
     P = PI / 180
     REM Orbital Rate of Saturn in Degrees per Days
     TP = 360 / (29.45771 * 365.2422)
     REM Orbital Rate of Earth in Degrees per Day
     TE = 360 / (1.00004 * 365.2422)
     REM Eccentricity of Saturn's Orbit
     EP = .0556155#
     REM Eccentricity of Earth's Orbit
     EE = .016718#
     REM Semimajor axis of Earth's and Saturn's orbit in Astronomical Units
     RE0 = 1: RP0 = 9.554747
     REM Tilt of Earth's Axis - obliquity of the ecliptic
     OBL = 23.43928
     REM Names of the Satellites
     N$(1) = "Mimas": N$(2) = "Enceladus": N$(3) = "Tethys": N$(4) = "Dione"
     N$(5) = "Rhea": N$(6) = "Titan": N$(7) = "Hyperion": N$(8) = "Iapetus"
     REM Semimajor Axis of the Satellites' Orbit in Kilometers
     SMA(1) = 185600: SMA(2) = 238100: SMA(3) = 294700: SMA(4) = 377500
     SMA(5) = 527200: SMA(6) = 1221600: SMA(7) = 1483000: SMA(8) = 3560100
     REM Visual Magnitude of the Satellites
     MAG(1) = 13: MAG(2) = 11.8: MAG(3) = 10.3: MAG(4) = 10.2
     MAG(5) = 9.8: MAG(6) = 8.4: MAG(7) = 14.3: MAG(8) = 11.2
     REM Pixel Size of Moons
     RSS(1) = 0: RSS(2) = 0: RSS(3) = 0: RSS(4) = 0
     RSS(5) = 1: RSS(6) = 1: RSS(7) = 0: RSS(8) = 0
     REM Semimajor Axis of the Satellites' Orbit in Kilometers
     SMA(1) = 185600: SMA(2) = 238100: SMA(3) = 294700: SMA(4) = 377500
     SMA(5) = 527200: SMA(6) = 1221600: SMA(7) = 1483000: SMA(8) = 3560100
     REM Eccentricity of Satellites' Orbit (Program uses 0)
     REM Satellites' Color
     CS(1) = 15: CS(2) = 15: CS(3) = 15: CS(4) = 15
     CS(5) = 15: CS(6) = 15: CS(7) = 15: CS(8) = 15
     REM Synodic Orbital Period of Moons in Days
     PD#(1) = .9425059#
     PD#(2) = 1.3703741#
     PD#(3) = 1.888095#
     PD#(4) = 2.7375229#
     PD#(5) = 4.5191641#
     PD#(6) = 15.966903#
     PD#(7) = 21.3792654#
     PD#(8) = 79.8768329#
     RS = 60330: REM Radius of planet in kilometers
     RS1 = 92000: REM Inner radius of inner ring in kilometers
     RS2 = 117500: REM Outer radius of inner ring in kilometers
     RS3 = 122500: REM Inner radius of outer ring in kilometers
     RS4 = 136500: REM Outer radius of outer ring in kilometers
     NM = 8: REM Number of moons displayed
     REM ************************ EPOCH INFORMATION *************************
     JDE# = 2444238.5#: REM Epoch Jan 0.0 1980 = December 31,1979 0:0:0 UT
     LPE = 165.322242#: REM Longitude of Saturn at Epoch
     LPP = 92.6653974#: REM Longitude of Saturn's Perihelion
     LEE = 98.83354#: REM Longitude of Earth at Epoch
     LEP = 102.596403#: REM Longitude of Earth's Perihelion
     REM U0(I) = Angle from inferior geocentric conjuction
     REM         measured westward along the orbit at epoch
     U0(1) = 19.094
     U0(2) = 174.5
     U0(3) = 173.313
     U0(4) = 76.5
     U0(5) = 36.969
     U0(6) = 57.414
     U0(7) = 150.781
     U0(8) = 181.058
     REM ********************************************************************
     REM *                                                                  *
     REM *    Program Control                                               *
     REM *                                                                  *
     REM ********************************************************************
     IJK = 5: REM Starting Zoom Size
     O1 = 0: O2 = 1: REM Option to Draw Orbits
     C1 = 15: C2 = 7: REM Color to Blink Moons
     MOON = 5: REM Moon to Blink?
     CHI = 0: REM Change Zoom Factor?
     GOSUB 9700: REM Show Startup Screen
1    GOSUB 9800: REM Get Local Date and Time
     LASTH = LHOUR: LASTM = NMIN
     GOSUB 1000: REM Calculations
     GOSUB 2000: REM Display
5    GOSUB 9800: REM Get Local Date and Time
     IF NSEC = LSEC THEN GOTO 100
     LOCATE STRT, 1
     PRINT USING "LT: ##:##:##  ##/##/####"; LHOUR; NMIN; NSEC; LMONTH; LDAY; LYEAR;
     LOCATE STRT + 1, 1
     PRINT USING "UT: ##:##:##  ##/##/####"; NHOUR; NMIN; NSEC; NMONTH; NDAY; NYEAR
     IF INT(NMIN / 10) <> INT(LASTM / 10) THEN GOSUB 1000: GOSUB 2000
     IF NMIN <> LASTM THEN GOSUB 1000: GOSUB 2900
     LASTM = NMIN
99   T$ = RIGHT$(LEFT$(TIME$, 7), 1): NSC = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(TIME$, 8), 1): NSC = NSC + ASC(T$) - 48
     IF NSC = LSC THEN GOTO 100
     SWAP C1, C2
     IF MOON > 0 AND Y(1, MOON) < YMAX / 2 THEN CIRCLE (X(1, MOON), Y(1, MOON)), RSS(MOON), C1
     IF MOON > 0 AND MOON <= IJK THEN CIRCLE (X(2, MOON), Y(2, MOON)), RSS(MOON), C1
     IF MOON > 0 THEN LOCATE STRT + 4 + MOON, 5: COLOR C1: PRINT N$(MOON);
     COLOR 15
     LSC = NSC
100  Z$ = INKEY$
101  IF Z$ = "1" THEN MOON = 1: GOSUB 2900
     IF Z$ = "2" THEN MOON = 2: GOSUB 2900
     IF Z$ = "3" THEN MOON = 3: GOSUB 2900
     IF Z$ = "4" THEN MOON = 4: GOSUB 2900
     IF Z$ = "5" THEN MOON = 5: GOSUB 2900
     IF Z$ = "6" THEN MOON = 6: GOSUB 2900
     IF Z$ = "7" THEN MOON = 7: GOSUB 2900
     IF Z$ = "8" THEN MOON = 8: GOSUB 2900
     IF Z$ = "D" OR Z$ = "d" THEN GOSUB 9600: CHG = 1: GOSUB 1000: GOSUB 2000
     IF Z$ = "X" OR Z$ = "x" THEN GOTO 9999
     IF Z$ = "Z" THEN IJK = IJK - 1: CHI = 1
     IF Z$ = "z" THEN IJK = IJK + 1: CHI = 1
     IF IJK < 1 THEN IJK = 1: CHI = 0
     IF IJK > NM THEN IJK = NM: CHI = 0
     IF CHI = 1 THEN CHI = 0: GOSUB 2000
     IF Z$ = "C" OR Z$ = "c" THEN CHG = 0: GOTO 1
     IF Z$ = "O" OR Z$ = "o" THEN SWAP O1, O2: GOSUB 2000
     IF Z$ = "h" OR Z$ = "H" THEN GOSUB 9500: GOSUB 2000
     IF Z$ = "T" OR Z$ = "t" THEN GOSUB 9400: GOSUB 2000
     IF CHG = 0 THEN GOTO 5 ELSE GOTO 99
1000 REM ********************** JULIAN DATE *******************************
     GGG = 1: IF NYEAR <= 1585 THEN GGG = 0
     JD# = -1 * INT(7 * (INT((NMONTH + 9) / 12) + NYEAR) / 4)
     S = SGN(NMONTH - 9): A = ABS(NMONTH - 9)
     J1 = INT(NYEAR + S * INT(A / 7))
     J1 = -1 * INT((INT(J1 / 100) + 1) * 3 / 4)
     JD# = JD# + INT(275 * NMONTH / 9) + NDAY + (GGG * J1)
     JD# = JD# + 1721027 + 2 * GGG + 367 * NYEAR - .5
     JD# = JD# + (NHOUR / 24) + (NMIN / (24 * 60))
     REM ****************** FIND MOON ORBITAL ANGLES ************************
     NN = JD# - JDE#: REM NN = Number of days since epoch
     ME = ((TE * NN) + LEE - LEP) * P: REM Mean Anomoly of Earth
     MP = ((TP * NN) + LPE - LPP) * P: REM Mean Anomoly of Saturn
     VE = ME: VP = MP: REM True Anomolies - Solve Kepler's Equation
     FOR I = 1 TO 3
     VE = VE - (VE - (EE * SIN(VE)) - ME) / (1 - (EE * COS(VE)))
     VP = VP - (VP - (EP * SIN(VP)) - MP) / (1 - (EP * COS(VP)))
     NEXT I
     VE = 2 * ATN(SQR((1 + EE) / (1 - EE)) * TAN(VE / 2)) / P
     IF VE < 0 THEN VE = 360 + VE
     VP = 2 * ATN(SQR((1 + EP) / (1 - EP)) * TAN(VP / 2)) / P
     IF VP < 0 THEN VP = 360 + VP
     REM  Heliocentric Longitudes of Earth and Saturn
     LE = VE + LEP: IF LE > 360 THEN LE = LE - 360
     LP = VP + LPP: IF LP > 360 THEN LP = LP - 360
     REM  Distances of Earth and Saturn from the Sun in AU's
     RE = RE0 * (1 - EE * EE) / (1 + EE * COS(VE * P))
     RP = RP0 * (1 - EP * EP) / (1 + EP * COS(VP * P))
     REM  DT = Distance from Saturn to Earth in AU's - Law of Cosines
     DT = SQR((RE ^ 2) + (RP ^ 2) - (2 * RE * RP * COS((LE - LP) * P)))
     REM  II = Angle between Earth and Sun as seen from Saturn
     II = RE * SIN((LE - LP) * P) / DT
     II = ATN(II / SQR(1 - II * II)) / P: REM  ArcSIN and Law of Sines
     REM   F = NN - (Light Time to Earth in days)
     F = NN - (DT / 173.83)
     F1 = II + (MP / P) - VP
     REM U(I) = Angle from inferior geocentric conjuction measured westward
     FOR I = 1 TO NM
     U(I) = U0(I) + (F * 360 / PD#(I)) + F1
     U(I) = ((U(I) / 360) - INT(U(I) / 360)) * 360
     NEXT I
     REM ****** FIND SYSTEM I LONGITUDE OF SATURN'S CENTRAL MERIDAIN ********
     REM SYSI = EpochSYSI + (F * (Rotational Rate in Degrees per Day)) + Perspective Angle
     SYSI# = 313.95999# + ((JD# - 2449353.5# - (DT / 173.83)) * 844.2682661#) + F1
     SYSI# = ((SYSI# / 360) - INT(SYSI# / 360)) * 360
     REM ******************** FIND SATURN'S COORDINATES *********************
     LAMB = RE * SIN((LP - LE) * P)
     LAMB = ATN(LAMB / (RP - RE * COS((LP - LE) * P))) / P + LP
     NUM = SIN(LAMB * P) * COS(OBL * P)
     DEN = COS(LAMB * P)
     RA = ATN(NUM / DEN) / P
     IF NUM * DEN < 0 THEN RA = RA + 180
     IF NUM < 0 THEN RA = RA + 180
     SINDEC = SIN(OBL * P) * SIN(LAMB * P)
     DEC = ATN(SINDEC / SQR(1 - SINDEC * SINDEC)) / P: REM ArcSIN
     REM **************** FIND INCLINATION OF RINGS *************************
     REM Use dot product of Earth-Saturn vector and Saturn's rotation axis
     TAX = (90 - 83.51) * P: REM Theta coordinate of Saturn's axis
     PAX = 40.27 * P: REM Phi coordinate of Saturn's axis
     TSAT = (90 - DEC) * P
     PSAT = RA * P
     DOT1 = SIN(TAX) * COS(PAX) * SIN(TSAT) * COS(PSAT)
     DOT1 = DOT1 + SIN(TAX) * SIN(PAX) * SIN(TSAT) * SIN(PSAT)
     DOT1 = DOT1 + COS(TAX) * COS(TSAT)
     INC = ATN(SQR(1 - DOT1 ^ 2) / DOT1) / P: REM   ArcCOS
     IF INC > 0 THEN INC = 90! - INC ELSE INC = -90! - INC
     REM ************* FIND INCLINATION OF IAPETUS' ORBIT *******************
     REM Use dot product of Earth-Saturn vector and Iapetus' orbit axis
     TAX = (90 - 76) * P: REM Theta coordinate of Iapetus' orbit axis (estimate)
     PAX = 20.6 * P * 360 / 24: REM Phi coordinate of Iapetus' orbit axis (estimate)
     DOT2 = SIN(TAX) * COS(PAX) * SIN(TSAT) * COS(PSAT)
     DOT2 = DOT2 + SIN(TAX) * SIN(PAX) * SIN(TSAT) * SIN(PSAT)
     DOT2 = DOT2 + COS(TAX) * COS(TSAT)
     INCI = ATN(SQR(1 - DOT2 ^ 2) / DOT2) / P: REM   ArcCOS
     IF INCI > 0 THEN INCI = 90! - INCI ELSE INCI = -90! - INCI
     REM ************* FIND ROTATION ANGLE OF IAPETUS' ORBIT ****************
     REM Use inclination of Iapetus' orbit with respect to ring plane
     GAM = COS(14.47 * P) - DOT1 * DOT2
     GAM = ATN(SQR(1 - GAM ^ 2) / GAM) / P: REM   ArcCOS
     GAM = -1 * GAM
     REM ********************************************************************
     RETURN
2000 REM ******************** DRAW SATURN (Earth View) **********************
     CLS
2900 SCALE = (3 * XMAX) / (17 * SMA(IJK))
     XC = XMAX / 2: YC = YMAX / 4
     ASP = SIN(INC * P) / RATYX: REM Aspect Ratio
     A1 = PI: A2 = 0: REM Start and End of Arcs
     IF ASP < 0 THEN SWAP A1, A2: ASP = -ASP
     REM Draw planet
     CIRCLE (XC, YC), RS * SCALE, 7, , , .9 / RATYX
     PAINT (XC, YC), 7, 7
     REM Draw rings
     CIRCLE (XC, YC), RS1 * SCALE - 1, 8, , , ASP
     CIRCLE (XC, YC), RS2 * SCALE + 1, 8, , , ASP
     CIRCLE (XC, YC), RS3 * SCALE - 1, 8, , , ASP
     CIRCLE (XC, YC), RS4 * SCALE + 1, 8, , , ASP
     PAINT (XC - (SCALE * (RS1 + RS2) / 2), YC), 7, 8
     PAINT (XC + (SCALE * (RS1 + RS2) / 2), YC), 7, 8
     PAINT (XC - (SCALE * (RS3 + RS4) / 2), YC), 7, 8
     PAINT (XC + (SCALE * (RS3 + RS4) / 2), YC), 7, 8
     REM ****************** DRAW MOONS (Earth View) *************************
     FOR I = 1 TO NM - 1
     REM   Orbital Paths
     IF SMA(I) * SCALE * ASP < YMAX / 4 AND O1 = 1 THEN CIRCLE (XC, YC), SMA(I) * SCALE, 8, , , ASP
     X(1, I) = XC - (SMA(I) * SIN(U(I) * P) * SCALE)
     Y(1, I) = YC + INT((SMA(I) * COS(U(I) * P) * SIN(INC * P) * SCALE / RATYX))
     IF Y(1, I) < YMAX / 2 THEN CIRCLE (X(1, I), Y(1, I)), RSS(I), CS(I)
     NEXT I
     REM ********************** Iapetus' Orbit *****************************
     TEMPX = -1 * (SMA(8) * SIN(U(8) * P) * SCALE)
     TEMPY = INT((SMA(8) * COS(U(8) * P) * SIN(INCI * P) * SCALE / RATYX))
     X(1, 8) = XC + TEMPX * COS(GAM * P) + TEMPY * SIN(GAM * P): REM Rotation
     Y(1, 8) = YC - TEMPX * SIN(GAM * P) + TEMPY * COS(GAM * P)
     IF X(1, 8) > XMAX OR X(1, 8) < 0 THEN GOTO 2910
     IF Y(1, 8) > YMAX / 2 OR Y(1, 8) < 0 THEN GOTO 2910
     IF O1 = 0 THEN GOTO 2909
     REM   Orbital Path
     TEMPY = INT((SMA(8) * SIN(INCI * P) * SCALE / RATYX))
     XLAST = XC + TEMPY * SIN(GAM * P): REM Rotation
     YLAST = YC + TEMPY * COS(GAM * P)
     FOR I = 0 TO 360 STEP 2
     TEMPX = -1 * (SMA(8) * SIN(I * P) * SCALE)
     TEMPY = INT((SMA(8) * COS(I * P) * SIN(INCI * P) * SCALE / RATYX))
     XDRAW = XC + TEMPX * COS(GAM * P) + TEMPY * SIN(GAM * P): REM Rotation
     YDRAW = YC - TEMPX * SIN(GAM * P) + TEMPY * COS(GAM * P)
     IF YDRAW < YMAX / 2 AND YLAST < YMAX / 2 THEN LINE (XLAST, YLAST)-(XDRAW, YDRAW), 8
     XLAST = XDRAW: YLAST = YDRAW
     NEXT I
     REM Draw Iapetus
2909 CIRCLE (X(1, 8), Y(1, 8)), RSS(8), CS(8)
2910 REM ************** Redraw Saturn's exposed hemisphere ****************
     CIRCLE (XC, YC), RS * SCALE + 1, 0, A2, A1, .9 / RATYX
     LINE (XC - RS * SCALE - 1, YC)-(XC + RS * SCALE + 1, YC), 0
     PAINT (XC, YC - RS * SCALE * SGN(INC) / 2), 1, 0
     PAINT (XC, YC - RS * SCALE * SGN(INC) / 2), 7, 0
     CIRCLE (XC, YC), RS * SCALE + 1, 8, A2, A1, .9 / RATYX
     LINE (XC - RS * SCALE - 1, YC)-(XC + RS * SCALE + 1, YC), 7
     REM ***************** DRAW SATURN (Polar View) **********************
     XC = INT(XMAX / 2): YC = 3 * YMAX / 4
     XS1 = XC + (RS * SCALE * COS(II * P)) + 1
     XS2 = XC - (RS * SCALE * COS(II * P)) - 1
     YS1 = YC + (RS * SCALE * SIN(II * P))
     YS2 = YC - (RS * SCALE * SIN(II * P))
     XS3 = YMAX * TAN(II * P) / 4
     REM Draw rings
     CIRCLE (XC, YC), RS1 * SCALE, 8
     CIRCLE (XC, YC), RS2 * SCALE, 8
     CIRCLE (XC, YC), RS3 * SCALE, 8
     CIRCLE (XC, YC), RS4 * SCALE, 8
     PAINT (XC - (SCALE * (RS1 + RS2) / 2), YC), 7, 8
     PAINT (XC + (SCALE * (RS1 + RS2) / 2), YC), 7, 8
     PAINT (XC - (SCALE * (RS3 + RS4) / 2), YC), 7, 8
     PAINT (XC + (SCALE * (RS3 + RS4) / 2), YC), 7, 8
     CIRCLE (XC, YC), RS1 * SCALE + 1, 7
     CIRCLE (XC, YC), RS2 * SCALE - 1, 7
     CIRCLE (XC, YC), RS3 * SCALE + 1, 7
     CIRCLE (XC, YC), RS4 * SCALE - 1, 7
     REM **********************  Draw Shadows *************************
     CIRCLE (XC, YC), RS * SCALE, 7
     PAINT (XC, YC), 7, 7
     LINE (5 * XMAX / 16, YMAX / 2)-(11 * XMAX / 16, YMAX - 1), 15, B: REM   Bottom White Box
     LINE (XS1, YS1)-(XS2, YS2), 15
     LINE (XS1 + XS3, YMAX / 2)-(XS1, YS1), 15
     LINE (XS2 + XS3, YMAX / 2)-(XS2, YS2), 15
     PAINT (XC, YC - 2), 8, 15
     PAINT (XC, YC - 2), 0, 15
     LINE (XS1, YS1)-(XS2, YS2), 0
     LINE (XS1 + XS3, YMAX / 2)-(XS1, YS1), 0
     LINE (XS2 + XS3, YMAX / 2)-(XS2, YS2), 0
     REM ****************** DRAW MOONS (Polar View) *************************
     FOR I = 1 TO IJK
     REM   Orbital Paths
     CIRCLE (XC, YC), SMA(I) * SCALE, 8
     X(2, I) = XC - (SMA(I) * SIN(U(I) * P) * SCALE)
     Y(2, I) = YC + INT((SMA(I) * COS(U(I) * P) * SCALE / RATYX))
     CIRCLE (X(2, I), Y(2, I)), RSS(I), CS(I)
     NEXT I
     REM ********************* DRAW BACKGROUND *****************************
     LINE (3, 6)-(XMAX - 4, YMAX / 2 - 8), 15, B: REM          Top White Box
     LINE (5 * XMAX / 16, YMAX / 2)-(11 * XMAX / 16, YMAX - 1), 15, B: REM   Bottom White Box
     LOCATE STRT, 1
     PRINT USING "LT: ##:##:##  ##/##/####"; LHOUR; NMIN; NSEC; LMONTH; LDAY; LYEAR;
     LOCATE STRT + 1, 1
     PRINT USING "UT: ##:##:##  ##/##/####"; NHOUR; NMIN; NSEC; NMONTH; NDAY; NYEAR
     LOCATE STRT + 4, 1: PRINT "No. SATELLITE  MAGNITUDE"
     FOR I = 1 TO NM
     LOCATE STRT + 4 + I, 1
     PRINT USING " #  \         \   ##.#"; I; N$(I); MAG(I);
     NEXT I
     LOCATE STRT + 0, 58: PRINT "System I Longitude of"
     LOCATE STRT + 1, 57: PRINT USING "Central Meridian = ###!"; SYSI#; CHR$(248)
     LOCATE STRT + 4, 59: PRINT "C O M M A N D S"
     LOCATE STRT + 5, 61: PRINT "h - help";
     LOCATE STRT + 6, 61: PRINT "x - exit";
     LOCATE STRT + 7, 61: PRINT "o - draw orbits";
     LOCATE STRT + 8, 61: PRINT "d - set date";
     LOCATE STRT + 9, 61: PRINT "c - current view";
     LOCATE STRT + 10, 61: PRINT "t - show table";
     LOCATE STRT + 11, 59: PRINT "Z/z - zoom in/out";
     LOCATE STRT + 12, 59: PRINT "1-8 - identify";
     LOCATE 1, 38: PRINT "SOUTH"
     LOCATE 6, 1: PRINT "W"
     LOCATE 7, 1: PRINT "E"
     LOCATE 8, 1: PRINT "S"
     LOCATE 9, 1: PRINT "T"
     LOCATE 6, 80: PRINT "E";
     LOCATE 7, 80: PRINT "A";
     LOCATE 8, 80: PRINT "S";
     LOCATE 9, 80: PRINT "T";
     LOCATE 15, 38: PRINT "NORTH"
2999 RETURN
    
9400 REM ********************************************************************
     REM *                                                                  *
     REM *   Show Table                                                     *
     REM *                                                                  *
     REM ********************************************************************
     CLS
     PRINT
     PRINT USING "          Local Date: ##/##/####    Univ. Date: ##/##/####"; LMONTH; LDAY; LYEAR; NMONTH; NDAY; NYEAR
     PRINT USING "          Local Time:  ##:##:##     Univ. Time:  ##:##:##"; LHOUR; NMIN; NSEC; NHOUR; NMIN; NSEC
     PRINT
     PRINT USING "                           Julian Date : ########.###"; JD#
     PRINT USING "             Right Ascension of Saturn : ###.## Hours"; RA * 24 / 360
     PRINT USING "                 Declination of Saturn : ###.##!"; DEC; CHR$(248)
     PRINT USING "   Ring Inclination as seen from Earth : ###.##!"; INC; CHR$(248)
     PRINT USING "      Heliocentric Longitude of Saturn : ###.##!"; LP; CHR$(248)
     PRINT USING "       Heliocentric Longitude of Earth : ###.##!"; LE; CHR$(248)
     PRINT USING "                Sun-Saturn-Earth Angle : ###.##!"; II; CHR$(248)
     PRINT USING "     Distance between Saturn and Earth : ###.## AU = #### million miles"; DT; (DT * 93)
     PRINT USING "       Light time from Saturn to Earth : ###.## minutes"; DT * 8.28
     TEMP = 2 * ATN(TAN(165.6 * P / (2 * 3600)) / DT) * 3600 / P
     PRINT USING "                Angular Size of Saturn : ###.## arcsec"; TEMP
     PRINT USING "  Major Angular Size of Saturn's Rings : ###.## arcsec"; RS4 * TEMP / RS
     PRINT USING "  Minor Angular Size of Saturn's Rings : ###.## arcsec"; ABS(RS4 * TEMP * SIN(INC * P) / RS)
     PRINT
     PRINT "     SATELLITE    MAGNITUDE    ORBITAL RADIUS    ORBITAL PERIOD "
     FOR I = 1 TO NM
     PRINT USING "    \          \     ##.#        ####### km       ###.## days"; N$(I); MAG(I); SMA(I); PD#(I)
     NEXT I
     PRINT : PRINT "                              Press Enter."
     WHILE INKEY$ = "": WEND
     RETURN

9500 REM ********************************************************************
     REM *                                                                  *
     REM *   Help Screen                                                    *
     REM *                                                                  *
     REM ********************************************************************
     CLS : SCREEN 12: WIDTH 80, 30
     LOCATE 1, 1
     PRINT : PRINT : PRINT
     PRINT "                             E A R T H   V I E W"
     PRINT
     PRINT "        Saturn and its moons are shown here as they appear though Earth"
     PRINT "   based telescopes.  The orientation of the display is the same as the"
     PRINT "   view seen in astronomical (inverting) telescopes.  Titan is the easiest"
     PRINT "   moon to see, followed by wide-ranging Iapetus.  A 4-inch telescope"
     PRINT "   often shows Rhea and Dione and sometimes Tethys, but Enceladus usually"
     PRINT "   requires at least a 10-inch.  Hyperion requires an even larger telescope."
     PRINT : PRINT : PRINT : PRINT : PRINT : PRINT
     PRINT "                              P O L A R   V I E W       "
     PRINT
     PRINT "                           A view from above Saturn's  "
     PRINT "                          South pole is shown here     "
     PRINT "                          with the Sun-Saturn-Earth    "
     PRINT "                          angle used to mark the       "
     PRINT "                          shadows on the planet and    "
     PRINT "                          rings.  Earth is straight    "
     PRINT "                          down in this view."
     LINE (3, 6)-(XMAX - 4, YMAX / 2 - 8), 15, B: REM          Top White Box
     LINE (5 * XMAX / 16, YMAX / 2)-(11 * XMAX / 16, YMAX - 1), 15, B: REM   Bottom White Box
     LOCATE STRT, 1
     PRINT "  Local time (LT) and"
     PRINT "  Universal time (UT) "
     PRINT "    are given here."
     PRINT : PRINT : PRINT
     PRINT " Satellites are listed"
     PRINT "   here in order of"
     PRINT "  increasing orbital"
     PRINT "        radii."
     LOCATE STRT + 1, 58: PRINT " The System I Longitude";
     LOCATE STRT + 2, 58: PRINT "of the Central Meridian";
     LOCATE STRT + 3, 58: PRINT "and a list of commands";
     LOCATE STRT + 4, 58: PRINT "    are given here.";
     LOCATE STRT + 9, 58: PRINT "      Press Enter.   ";
     WHILE INKEY$ = "": WEND
     CLS
     PRINT
     PRINT "             C O M M A N D S"
     PRINT
     PRINT "     h - shows the help screens"
     PRINT
     PRINT "     x - exits the program  "
     PRINT
     PRINT "     o - draws the orbits for the moons"
     PRINT "         for the Earth view (toggles on/off)"
     PRINT
     PRINT "     d - changes the date and time of observation"
     PRINT "         (does not change the computer clock date and time)"
     PRINT
     PRINT "     c - displays current view of the Saturn and its moons"
     PRINT "         (use this after changing the date and time)"
     PRINT
     PRINT "     t - displays data table with Saturn's coordinates, ring"
     PRINT "         inclination and other information"
     PRINT
     PRINT "   Z/z - changes the zoom setting; includes 8 settings which allow"
     PRINT "         the orbits of each moon to fit in the polar view box"
     PRINT
     PRINT "   1-8 - press any number between 1 and 8 and the corresponding satellite"
     PRINT "         will blink if it is visible; use the zoom command if the moon is"
     PRINT "         not in the field of view"
     PRINT
     PRINT "                           Press Enter."
     WHILE INKEY$ = "": WEND
     IF MODE = 1 THEN SCREEN 12
     IF MODE = 2 THEN SCREEN 9: WIDTH 80, 43
     RETURN
    
9600 REM ********************************************************************
     REM *                                                                  *
     REM *   Change Date and Time Manually                                  *
     REM *                                                                  *
     REM ********************************************************************
     LINE (11 * XMAX / 16, YMAX / 2)-(XMAX - 1, YMAX - 1), 8, B
     PAINT (11 * XMAX / 16 + 3, YMAX / 2 + 3), 8, 8
     LINE (11 * XMAX / 16, YMAX / 2)-(XMAX - 1, YMAX - 1), 15, B
     PAINT (11 * XMAX / 16 + 3, YMAX / 2 + 3), 0, 15
     LOCATE STRT, 58
     PRINT "Enter Universal Date"
     LOCATE STRT + 2, 60
     INPUT "Month (MM) : ", NMONTH
     LOCATE STRT + 3, 60
     INPUT "Day (DD) : ", NDAY
     LOCATE STRT + 4, 60
     INPUT "Year (YYYY) : ", NYEAR
     LOCATE STRT + 6, 58
     PRINT "Enter Universal Time"
     LOCATE STRT + 8, 60
     INPUT "Hour : ", NHOUR
     LOCATE STRT + 9, 60
     INPUT "Minute : ", NMIN
     LHOUR = NHOUR - DHOUR
     LDAY = NDAY
     LYEAR = NYEAR
     LMONTH = NMONTH
     NSEC = 0
     GOSUB 9900
     RETURN
    
9700 REM ********************************************************************
     REM *                                                                  *
     REM *    Startup Screen                                                *
     REM *                                                                  *
     REM ********************************************************************
     TEMP$ = NMF$ + ".CFG"
     OPEN TEMP$ FOR INPUT AS #1
     INPUT #1, Z$, DHOUR
     CLOSE
     LOCATE 10, 23
     PRINT "             SATSAT "
     LOCATE 11, 23
     PRINT "      Satellites of Saturn "
     LOCATE 12, 23
     PRINT "           Version 1.0"
     PRINT : PRINT
     PRINT
     PRINT TAB(17); " Enter the number of hours to add to your local"
     PRINT TAB(17); " time to get Universal Time (Default -> "; DHOUR; ") : ";
     INPUT "", DHOUR$
     IF DHOUR$ = "" THEN GOTO 9702
     LN = LEN(DHOUR$): DHOUR = 0
     FOR I = 1 TO LN
     DHOR$ = LEFT$(RIGHT$(DHOUR$, I), 1)
     DHOR = ASC(DHOR$) - 48
     IF DHOR = -3 THEN DHOUR = -1 * DHOUR: GOTO 9701
     DHOUR = DHOUR + (DHOR * (10 ^ (I - 1)))
9701 NEXT I
     OPEN TEMP$ FOR OUTPUT AS #1
     PRINT #1, Z$
     PRINT #1, DHOUR
     CLOSE
9702 RETURN

9800 REM ********************************************************************
     REM *                                                                  *
     REM *    Determine Time                                                *
     REM *                                                                  *
     REM ********************************************************************
     T$ = LEFT$(DATE$, 1): LMONTH = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(DATE$, 2), 1): LMONTH = LMONTH + ASC(T$) - 48
     T$ = RIGHT$(LEFT$(DATE$, 4), 1): LDAY = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(DATE$, 5), 1): LDAY = LDAY + ASC(T$) - 48
     T$ = RIGHT$(LEFT$(DATE$, 7), 1): LYEAR = (ASC(T$) - 48) * 1000
     T$ = RIGHT$(LEFT$(DATE$, 8), 1): LYEAR = LYEAR + (ASC(T$) - 48) * 100
     T$ = RIGHT$(LEFT$(DATE$, 9), 1): LYEAR = LYEAR + (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(DATE$, 10), 1): LYEAR = LYEAR + ASC(T$) - 48
     T$ = (LEFT$(TIME$, 1)): LHOUR = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(TIME$, 2), 1): LHOUR = LHOUR + ASC(T$) - 48
     T$ = RIGHT$(LEFT$(TIME$, 4), 1): NMIN = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(TIME$, 5), 1): NMIN = NMIN + ASC(T$) - 48
     T$ = RIGHT$(LEFT$(TIME$, 7), 1): NSEC = (ASC(T$) - 48) * 10
     T$ = RIGHT$(LEFT$(TIME$, 8), 1): NSEC = NSEC + ASC(T$) - 48
     GOSUB 9900
     RETURN

9900 REM ********************************************************************
     REM *                                                                  *
     REM *  Correct Time after Time Increment                               *
     REM *                                                                  *
     REM ********************************************************************
     IF NSEC >= 60 THEN NSEC = NSEC - 60: NMIN = NMIN + 1
     IF NSEC < 0 THEN NSEC = NSEC + 60: NMIN = NMIN - 1
     IF NMIN >= 60 THEN NMIN = NMIN - 60: LHOUR = LHOUR + 1
     IF NMIN < 0 THEN NMIN = NMIN + 60: LHOUR = LHOUR - 1
     LastDAY = 31
     IF (LMONTH = 4) OR (LMONTH = 6) THEN LastDAY = 30
     IF (LMONTH = 9) OR (LMONTH = 11) THEN LastDAY = 30
     IF LMONTH = 2 THEN LastDAY = 28
     IF (INT(LYEAR / 4) = (LYEAR / 4)) AND (LMONTH = 2) THEN LastDAY = 29
     IF LHOUR >= 24 THEN LHOUR = LHOUR - 24: LDAY = LDAY + 1
     IF LHOUR < 0 THEN LHOUR = LHOUR + 24: LDAY = LDAY - 1
     IF LDAY > LastDAY THEN LDAY = LDAY - LastDAY: LMONTH = LMONTH + 1
     LastDAY = 31
     IF ((LMONTH - 1) = 4) OR ((LMONTH - 1) = 6) THEN LastDAY = 30
     IF ((LMONTH - 1) = 9) OR ((LMONTH - 1) = 11) THEN LastDAY = 30
     IF (LMONTH - 1) = 2 THEN LastDAY = 28
     IF (INT(LYEAR / 4) = (LYEAR / 4)) AND ((LMONTH - 1) = 2) THEN LastDAY = 29
     IF LDAY < 1 THEN LDAY = LDAY + LastDAY: LMONTH = LMONTH - 1
     IF LMONTH > 12 THEN LMONTH = LMONTH - 12: LYEAR = LYEAR + 1
     IF LMONTH < 1 THEN LMONTH = LMONTH + 12: LYEAR = LYEAR - 1
     NMONTH = LMONTH
     NYEAR = LYEAR
     NDAY = LDAY
     NHOUR = LHOUR + DHOUR
     LastDAY = 31
     IF (NMONTH = 4) OR (NMONTH = 6) THEN LastDAY = 30
     IF (NMONTH = 9) OR (NMONTH = 11) THEN LastDAY = 30
     IF NMONTH = 2 THEN LastDAY = 28
     IF (INT(NYEAR / 4) = (NYEAR / 4)) AND (NMONTH = 2) THEN LastDAY = 29
     IF NHOUR >= 24 THEN NHOUR = NHOUR - 24: NDAY = NDAY + 1
     IF NHOUR < 0 THEN NHOUR = NHOUR + 24: NDAY = NDAY - 1
     IF NDAY > LastDAY THEN NDAY = NDAY - LastDAY: NMONTH = NMONTH + 1
     LastDAY = 31
     IF ((NMONTH - 1) = 4) OR ((NMONTH - 1) = 6) THEN LastDAY = 30
     IF ((NMONTH - 1) = 9) OR ((NMONTH - 1) = 11) THEN LastDAY = 30
     IF (NMONTH - 1) = 2 THEN LastDAY = 28
     IF (INT(NYEAR / 4) = (NYEAR / 4)) AND ((NMONTH - 1) = 2) THEN LastDAY = 29
     IF NDAY < 1 THEN NDAY = NDAY + LastDAY: NMONTH = NMONTH - 1
     IF NMONTH > 12 THEN NMONTH = NMONTH - 12: NYEAR = NYEAR + 1
     IF NMONTH < 1 THEN NMONTH = NMONTH + 12: NYEAR = NYEAR - 1
     RETURN
    
9999 REM ********************************************************************
     REM *                                                                  *
     REM *  Print End of Program Information                                *
     REM *                                                                  *
     REM ********************************************************************
     SCREEN 0
     WIDTH 80, 25
     CLS : LOCATE 11, 1
     PRINT TAB(17); "                    Dan Bruton"
     PRINT TAB(17); "              Texas A & M University"
     PRINT TAB(17); "                  astro@tamu.edu"
     PRINT TAB(17); "                   October 1994"
     PRINT : PRINT : PRINT : PRINT : PRINT : PRINT : PRINT : PRINT
     END
     REM ************************ END OF PROGRAM ***************************

