{ Golf43 ... rebuilt}
{$M $4000,0,0} {No Heap needed...no "dynamic" variables}
{With $N, uses 80x87 chip with if available, else uses simulation of it}
{Shorter & faster with $N+,$E- ,but then 80x87 is required}
{Works OK without either!...i.e. no IEEE math...shortest.}
Program Golf;
{This is a program to calculate the golf handicap of any number of
 individuals who may have played on any number of courses.  It provides
 and a file of courses, plus an individual game file for each golfer.
 It shows the last max_diffs scores , or all scores, whichever is less (used in
 actual handicap calculations) with the ones used (Best 10 or best half)
 highlighted.  A separate highlight shows the midpoint scores which are
 the ones that are most likely to be replaced by a new score.  The Hcp
 is 96% of the average of the best (lowest) differences between adjusted
 gross score and course rated par.  The adjusted gross score is the score
 resulting from reducing the score for any given hole in which a net
 score of more than a bogie was recorded (1973 rules). The 1993 rules
 changed this to a maximum of double bogie plus hcp/10.  The change is
 incorporated for scores after 1992.}


uses Dos,Crt,Printer;
{$I golfspec}

  procedure Surname(instring: string; var outstring: string);
  {Called by Gindex}
  var
    i,j        : byte;
    tail       : string;

  begin
    j := 0;
    outstring := '';
    tail := '';

    for i := 1 to Length(instring) do
    if instring[i] = ' '
      then
        begin
          j := 0;
          tail := outstring;
        end
      else
        begin
          if j = 0 then
            outstring := '';
          outstring := outstring + instring[i];
          j := succ(j);
        end;
    outstring := outstring + tail;
  end; {Surname}

  procedure Test(var x:array255; var iname:string;
                     jname:string; i,j:integer);
  {Called by Cindex and Gindex}
  var
    k : integer;
  begin
    if jname > iname then
      begin
        k := x[i];
        x[i] := x[j];
        x[j] := k;
        iname := jname;
      end {if statement}
  end;      {of test procedure}

  procedure Align(fsize,msize: integer; var line_no,over_top: byte);
    begin
      line_no := line_no + over_top;
      if line_no > msize then
        if line_no < (fsize - msize)
         then
          begin
            over_top := line_no - (msize div 2) - 1;
            line_no  := line_no - over_top;
          end
         else
          begin
            over_top := fsize - msize;
            line_no  := line_no - over_top;
          end
        else
         over_top := 0;
    end;

  procedure Cindex(ctype : byte);
    var
      i,j,k,n,xi : integer;
      iname,jname,name
                 : string;

    begin
      reset(courses);
      n := filesize(courses);
      if club.id <> 0 then course_id := club.id;     {Not "Nowhere"}
        case ctype of
      1: for i := 0 to n
           do cx[i] := i;
      2: for i := n-1 downto 1 do
           begin
             Seek(courses,cx[i]);
             Read(courses,club);
             iname := club.name;
             for j := i-1 downto 1 do
               begin
                 Seek(courses,cx[j]);
                 Read(courses,club);
                 jname := club.name;
                 Test(cx,iname,jname,i,j);
               end    {j loop}
           end;       {i loop}
      end;    {case statement}
      for i := 0 to FileSize(courses) do
          if cx[i] = course_id then
             course_hiline := i + 1;
          course_over_top := 0;
      Align(FileSize(courses),max_course_box,course_hiline,course_over_top);
    end;     {Cindex procedure}

  procedure Gindex(gtype : byte);
    var
      i,j,k,n,xi : integer;
      iname,jname,name
                 : string;

    begin
      reset(golfers);
      n := filesize(golfers);
      if golfer.id <> 0 then golfer_id := golfer.id;  {Not "Nobody"}
        case gtype of
      1: for i := 0 to n do
             gx[i] := i;
      2..4: for i := n-1 downto 1 do
            begin
             Seek(golfers,gx[i]);
             Read(golfers,golfer);
             case gtype of
               2: iname := golfer.name;
               3: Surname(golfer.name,iname);
               4: Str(golfer.hcp:5:2,iname);
             end;  {inner case 1 statement}
             for j := i-1 downto 1 do
               begin
                 Seek(golfers,gx[j]);
                 Read(golfers,golfer);
                 case gtype of
                   2: jname := golfer.name;
                   3: Surname(golfer.name,jname);
                   4: Str(golfer.hcp:5:2,jname);
                 end;  {inner case 2 statement}
                 Test(gx,iname,jname,i,j);
               end     {j loop}
            end;       {i loop}
      end;    {outer case statement}
      for i := 0 to FileSize(golfers) do
          if gx[i] = golfer_id then
             golfer_hiline := i + 1;
          golfer_over_top := 0;
      Align(FileSize(golfers),max_golfer_box,golfer_hiline,golfer_over_top);
    end;     {Gindex procedure}

  Procedure Select (var ch: char; var hiline,over_top: byte;
                        file_size: integer; height: byte);
    begin
       ch := ReadKey;
       if ch = #0
       then
       begin
         ch := ReadKey;
         case ch of
           'H':   {Up-arrow}
            if hiline > 1
              then hiline := Pred(hiline)
              else if (hiline = 1) and (over_top > 0)
                      then over_top := Pred(over_top);
           'P':   {Down-arrow}
            if hiline < height
              then hiline :=Succ(hiline)
              else if (hiline = height) and (file_size > (over_top + height))
                      then over_top := Succ(over_top);
            '-':  {Alt-x}
            begin
              option := ProgramExit;
              exit;
            end;
         end; {case}
         case ch of
           'H','P' : ch := #0;
         end;  {set for repeat of arrows (Non-zero if not arrows)}
       end {if then block}
    end;     {Select}


  Procedure GetName(var name:string; len : byte);
    var
      x,y,counter : byte;
      ch : char;
    begin
      x := WhereX;
      y := WhereY;
      name := '';
      counter := 0;
      repeat
        ch := ReadKey;
        case ch of
        #0:
          begin
          ch := ReadKey;
          case ch of
          '-':   {Alt-x}
             begin
               option := ProgramExit;
               exit;
             end;
          'K':   {Back-arrow}
            if counter > 0 then
             begin
              counter := pred(counter);
              name := Copy(name,1,counter);
             end; {if counter}
          end; {inner case}
          end; {#0 response}

        #8 : if counter > 0 then
             begin
              counter := pred(counter);
              name := Copy(name,1,counter);
             end; {if counter}
        #13: len := counter;
        #27: Exit;
        ' '..'~': begin
                    name := name + ch;
                    counter := succ(counter);
                  end;
        end; {outer case}
      GotoXY(x,y);
      ClrEol;
      Write(name);
      until counter = len;
    end; {GetName}



  Procedure ScoreCard;
    var
      hole,t1,t2,t3: byte;
    begin
      Window(1,15,80,25);   {score screen}
      ClrScr;
      GotoXY(1,1);
      Writeln ('Golfer: ',golfer.name,'      HCP = ',golfer.hcp:4:1
      ,'     Anti_Hcp = ',AntiHcp:4:1);
      Write ('Course: ',club.name);
      Write ('       Rated par = ',club.rated_par:5:1);
      xloc := WhereX;
      yloc := WhereY;
      Writeln;
      if color then TextColor(yellow);
      Write('Hole ');
      for hole := 1 to max_holes do Write(hole:3);
      Writeln;
      Write('Par  ');
      card_par := 0;
      for hole := 1 to max_holes do
        begin
          T2 := club.card_par[hole];
          Write(T2:3);
          card_par := card_par + T2;
        end;
      Writeln(' = ',card_par:3);
      if color then Textcolor(yellow);
      option := CourseAnalysis;
    end;      {ScoreCard}

  Procedure Course_Box( xloc, yloc: byte;
                             width, height: byte;
                             name: string;
                             file_size:integer;
                             var over_top,hiline:byte); forward;

    Procedure Add_Course(var ch : char; var club : course_type);
       var sum : byte;
           x,y    : integer;
           name   : string;

       begin
             begin
               Window(1,15,80,25);
               ClrScr;
               GotoXY(1,11);
               Write('Escape to abort, digits for score,');
               Write(' Backspace to correct, other for next score');
               GotoXY(1,1);
               club.name := '                                 ';
               Write ('Name of new course is: ');

               GetName(name,32);
               if option = ProgramExit then exit;
               club.name := name;
               Writeln;

               Write('  Rated par,(space), slope for ',club.name,' = ');
               y := WhereY;
               x := WhereX;
               Readln(club.rated_par,ch,club.slope);
               GotoXY(x,y);
               ClrEol;
               Writeln(club.rated_par:4:1,'/',club.slope);
               Writeln('Enter pars from card (',max_holes,' holes)');
               sum := 0;
               Window(1,18,80,20);
              for hole := 1 to max_holes do
                 begin
                   club.card_par[hole] := 4;  {Could be set in golfspec}
                   sum := sum + club.card_par[hole];
                   Write(club.card_par[hole]:3);
                 end;
               Writeln(' = ',sum:3);
               hole := 1;
               repeat {until not back-arrow}
                 repeat  {until hole > max_holes}
                   Window (3 * hole -2,18,3 * hole,20);
                   TextBackground(white);
                   Write(club.card_par[hole]:2,' ');
                   GotoXY(1,1);
                   club.card_par[hole] := Getnum(ch,club.card_par[hole],99);
                   TextBackground(green);
                   if option = ProgramExit then exit;
                   if ch = #27 then exit;
                   GotoXY(1,1);
                   Writeln(club.card_par[hole]:3);
                   case ch of
                     #203 : if hole > 1 then hole := pred(hole);
                     else
                       hole := succ(hole);
                     end;
                 until hole > max_holes;
                 begin
                   Window(3*max_holes +1,18,80,25);
                   sum := 0;
                   for hole := 1 to max_holes do
                     sum := sum + club.card_par[hole];
                   TextBackground(white);
                   Writeln(' = ',sum:3);
                   TextBackground(green);
                   ch := ReadKey;
                   case ch of
                    #0 : begin
                           ch := Readkey;
                           case ch of
                             'K' : begin      {Back-Arrow}
                                     GotoXY(1,1);
                                     Writeln(' = ',sum:3);
                                     hole := max_holes;
                                     ch := #8;
                                   end;
                           end;
                         end;
                    #8 : begin  {Backspace}
                           GotoXY(1,1);
                           Writeln(' = ',sum:3);
                           hole := max_holes;
                         end;
                   end;
                 end;
               until ch <> #8;
               club.id := FileSize(courses);
               Window(1,15,80,25);
               ClrScr;
               GotoXY(1,2);
               if club.rated_par <= 0 then club.rated_par := sum;
               Writeln('Club id ',club.id,': Clubname: "',club.name,
               '", rated par = ', club.rated_par:4:1);
               Write(' Pars = ');
               for hole := 1 to max_holes do
                   Write(club.card_par[hole]:3);
               Writeln(' = ',sum:3);
               Writeln('Is this OK to save?  Y/N');
               ch := ReadKey;
               if ch = #27 then exit;
               if (ch = 'Y') or (ch = 'y') then
                begin
                  Seek(courses,club.id);
                  Write(courses,club);
                  course_id := club.id;
                  Cindex(course_view);
                  Course_Box (80,1, SizeOf(club.name) + 2, max_course_box,
                   'Courses',FileSize(courses),course_over_top,course_hiline);
                end;
             end;

       end;    {Add_Course}

  Procedure Course_Box;
    var
      lineno        : byte;
      CurrCourse    : course_type;
      ch            : char;
      course_height : byte;
      print         : boolean;
    begin
      If file_size > max_course_box then course_height := max_course_box
        else course_height := file_size;
      If hiline > course_height then over_top := hiline - course_height;
      Repeat
        Box (xloc,yloc,width,course_height,name);
        if color then TextBackground(green);
        if color then TextColor(yellow);
        repeat
           ClrScr;
           Seek (courses,over_top);
           for lineno :=  1 to course_height do
           begin
             GotoXY(1,lineno);
             Seek (courses,cx[over_top + lineno - 1]);
             Read(courses,CurrCourse);
             if lineno = hiline then
               begin
                 if color then TextBackground(red)
                          else HighVideo ;
                 club := CurrCourse;  {'club' is the selected course}
               end;
             ClrEol;      {in case there is some garbage on the line}
                          {Paints correct Background color}
             Write(CurrCourse.name);     {On assured clear background}
             GotoXY(width - 2,lineno);   {Prepare to write club.id}
             Write(CurrCourse.id:3);
             if color then TextBackground(green)
                      else LowVideo;
             GotoXY (1,hiline);
           end; {for loop}
           Select(ch,hiline,over_top,file_size,course_height);
           if ch = #27 then exit;
        until ch <> #0; { "Enter" key}
        If club.id = 0 then
          Add_Course(ch,club);
        course_id := club.id;
        if option = ProgramExit then exit;
        if ch = #27 then exit;
       Until club.id <> 0;
      option := SelectGolfer;
    end;   {Course_Box}

  Procedure Golfer_Box( xloc, yloc: byte;
                           width, height: byte;
                           name: string;
                           file_size:integer;
                           var over_top,hiline:byte);forward;

    Procedure Add_Golfer(var ch : char; var golfer : golfer_type);

    var
      i   : byte;
      status : char;
      name   : string;

    begin
      Window(1,15,80,25);
      ClrScr;
      golfer := nobody;
      Write(golfer.name,': ');
      golfer.name := space20;   {Clear the background}

      GetName(name,20);
      if option = ProgramExit then exit;
      golfer.name := name;

      Writeln;
      Writeln('Declared handicap : ');
      Readln(golfer.hcp);
      if option = ProgramExit then exit;
      if status = #27 then exit;
      golfer.id := FileSize(golfers);
      ClrScr;
      Writeln('New golfer #',golfer.id,' is ',golfer.name);
      Writeln('Declared Handicap is ',golfer.hcp:3:1);
      Writeln('Is this OK? Y/N');
      ch := Readkey;
      if ch = #27 then exit;
      if (ch = 'Y') or (ch = 'y') then
        begin
          Seek(golfers,golfer.id);
          Write(golfers,golfer);
          golfer_id := golfer.id;
          Gindex(golfer_view);
          Str(golfer.id,s);
          Assign (game_file,'golfr' + s);
          Rewrite (game_file);
          Close(game_file);
          golfer.id := FileSize(golfers);
          if golfer.id > max_golfer_box then
          begin
            golfer_hiline := max_golfer_box;
            golfer_over_top := golfer.id - max_golfer_box;
          end
          else
          begin
            golfer_hiline := golfer.id;
            golfer_over_top := 0;
          end;
          Golfer_Box (1,1,SizeOf(golfer.name) + 6,max_golfer_box,'Golfers',
          FileSize(golfers),golfer_over_top,golfer_hiline);
        end
        else
          golfer.id := 0;
    end;  {Add_Golfer}

    Procedure Handicap_Box(xloc,yloc,width,height: byte);
    begin
      if width < 15 then width := 15;
      Box(xloc,yloc,width,height,'Handicap Box');
    end; {Handicap_Box}

    Function Handicap(var last20 : real20;last : word) : real;
       var
         BestLast : real20;
         front,back,last_game,middle : word;
         temp,temp2,realtemp : real;
         i,j  : word;
         x_pos,y_pos  : shortint;
       begin
         if last = 0 then
         begin
           handicap := 0;
           AntiHcp  := 0;
           exit;
         end;
         BestLast := last20;
         if last < max_diffs then last_game := last
                      else last_game:= max_diffs;
         middle := (last_game + 1) div 2;
         for front := 1 to last_game do    {Sort}
         begin
           for back := front to last_game do
           begin
              if BestLast[front] > BestLast[back] then
              begin
                temp := BestLast[front];
                BestLast[front] := BestLast[back];
                BestLast[back] := temp;
              end
           end
         end;
         temp := 0;
         temp2 := 0;

           for front := 1 to middle do
             temp := temp + BestLast[front] * 2;
           for front := middle + 1 to last_game do
             temp2 := temp2 + BestLast[front] * 2;

         if ((middle * 2) <> last_game) then
         begin
           temp := temp - BestLast[middle];
           temp2 := temp2 + BestLast[middle];
         end;
         Realtemp := (temp / last_game) * percent/100;
         handicap := realtemp;
         AntiHcp  := (temp2 / last_game) * percent/100;
         x_pos := WhereX;
         y_pos := WhereY;
         Handicap_Box(1,11,((last_game + 1) div 2)* 5,2);
         GotoXY(1,1);
         if (last_game div 2) * 2 = last_game
          then temp := (BestLast[middle] + BestLast[middle + 1]) / 2
          else temp := BestLast[middle];
         for i := 1 to last_game do
           begin
             if color then TextColor(black);
             if last20[i] = temp then
               if color then TextColor(blue);
             if last20[i] < temp then
               if color then TextColor(red);
           Write(last20[i]:5:1);
           if i = last_game - (last_game div 2) then Writeln;
           end;
         if color then TextColor(yellow);
         Window(1,15,80,25);
         GotoXY(x_pos,y_pos);
       end;  {Handicap}

    Procedure Get_Score (var status: char; var curr_game: game_type);forward;
    Procedure Post;forward;

  Procedure Golfer_Box;
    var
      lineno         : byte;
      CurrGolfer     : golfer_type;
      ch             : char;
      hcp            : real;
      golfer_height  : byte;
      status         : char;

    begin
      if file_size > max_golfer_box then golfer_height := max_golfer_box
        else golfer_height := file_size;
      if hiline > golfer_height then over_top := hiline - golfer_height;
      repeat
        Box (xloc,yloc,width,golfer_height,name);
        if color then TextBackground(green);
        if color then TextColor(yellow);
        repeat
          ClrScr;
          Seek (golfers,over_top);
          for lineno := 1 to  golfer_height do
          begin
            GotoXY(1,lineno);
            Seek(golfers,gx[over_top + lineno -1]);
            Read(golfers,CurrGolfer);
            if lineno = hiline then
              begin
                if color then TextBackground(red)
                         else HighVideo;
                golfer := CurrGolfer;  {'golfer' is selected golfer}
              end;
            ClrEol;      {in case there is some garbage on the line}
                         {Paints correct Background color}
             Write(CurrGolfer.name);
            GotoXY(width - 4,lineno);
            Write(CurrGolfer.hcp:4:2);
            if color then TextBackground(green)
                     else LowVideo;
            GotoXY (1,hiline);
          end;
          Select (ch,hiline,over_top,file_size,golfer_height);
          if ch = #27 then exit
        until  ch <> #0;  {"Almost any" key}
        if golfer.id <> 0
          then
            begin
              Str(Golfer.id,s);
              Assign (game_file,'golfr' + s);
{$I-}
              Reset(game_file);
{$I+}
              if ioresult <> 0 then
                begin
                  Rewrite(game_file);
                  Reset(game_file);
                end     {if ioresult}
            end    {if golfer.id then}
          else  {golfer.id = 0}
            Add_golfer(status,golfer);
        golfer_id := golfer.id;
        if option = ProgramExit then exit;
        if status = #27 then exit;
      until golfer.id <> 0;
      Seek(golfers,golfer.id);
      Read(golfers,golfer);
      hcp := Handicap(golfer.last_20,golfer.no_of_games);
      option := PostScore;
    end;    {Golfer_Box}


  Procedure Equitable_Stroke_Control
        (var esc_score : scores;actual,par : scores;hcp : real);

    var
       hole,normal_over,extra,hole_max : shortint;

    Procedure ESC1973;
      begin
       if actual[hole] <= (par[hole] + normal_over)
          then esc_score[hole] := actual[hole]
          else
           begin
             esc_score[hole] := par[hole] + normal_over;
             if extra > 0 then
                begin
                   extra := extra - 1;
                   esc_score[hole] := esc_score[hole] + 1;
                end
           end
       end;

    Procedure ESC1993;
      begin
        if actual[hole] > hole_max then esc_score[hole] := hole_max
                                   else esc_score[hole] := actual[hole];
      end;

    begin  {Equitable_Stroke_Control}

       {Values needed for 1973 Equitable Stroke Control rules}
       normal_over := (System.Round(hcp) div max_holes) + 1;
       extra := System.Round(hcp) mod max_holes;

       {Value needed for 1993 Equitable Stroke Control rules}
       hole_max := (System.Round(hcp) div 10) + 6;

       Window(1,20,80,21);
       Write('EqStr');
       Eq_sum := 0;
       for hole := 1 to max_holes do
          begin
            case adj_score_rule of
              0: esc_score[hole] := actual[hole];
              1: if actual[hole] > 2 * par[hole]  {double par rule}
                   then esc_score[hole] := 2 * par[hole]
                   else esc_score[hole] := actual[hole];
              2: ESC1973;
              3: ESC1993;
              4: if year < 1973
                  then esc_score[hole] := actual[hole]
                  else if year < 1993
                          then ESC1973
                          else ESC1993;
            end; {case}
            if color then
              begin
                if esc_score[hole] < par[hole] then TextColor(red);
                if esc_score[hole] > par[hole] then TextColor(black);
                if esc_score[hole] = par[hole] then TextColor(blue);
              end;
            if esc_score[hole] = actual[hole]
              then Write('  .')
              else Write(esc_score[hole]:3);
            eq_sum := eq_sum + esc_score[hole];
            if color then TextColor(yellow);
          end; {for holes}
            Write(' =',eq_sum:5:1);
            Write('- ',club.rated_par:4:1,' =');
            eq_sum := eq_sum - club.rated_par;
            Writeln (eq_sum:5:1);
    end;     {Equitable_Stroke_Control}

  Procedure Get_Score;
    var
      hole,t1,t2,t3: integer;
    begin
      GetDate(year,month,day,dayofweek);
      Window(1,15,80,25);   {score screen}
      GotoXY(1,11);
      Write('press <enter> when date is OK.');
      GotoXY(xloc +3 ,2);
      Write('Date  ',month:2,'/',day:2,'/',year);
      GotoXY(xloc +8,2);
      Get_Date(status,month,day,year);
      if option = ProgramExit then exit;
      if status = #27 then
        begin
          option := PostScore;
          Window(1,20,80,21);
          exit;
        end;
      GotoXY(1,11);
      Write('Escape to abort, digits for score,');
      Write(' Backspace to correct, other for next score');
      GotoXY(1,5);
      Write('Score');
      T1 := 0;
      for hole := 1 to max_holes do
        curr_game.score[hole] := club.card_par[hole];
      hole := 1;
      repeat {until not <- }
        repeat {until hole > max_holes}
          T2 := curr_game.score[hole];
          Window(3+hole*3,19,5+hole*3,20);
          if color then TextBackground(white);
          Write(T2:3);
          GotoXY(2,1);
          T2 := GetNum(status,T2,99);
          if option = ProgramExit then exit;
          case status of
            #27 :
              begin
                option := SelectGolfer;
                Window(1,20,80,21);
                exit;
              end;
            #203 :
             if hole > 1 then
                         begin
                           curr_game.score[hole] := T2;
                           hole := hole - 2;
                         end;
            else  {case}
              begin
                if color then
                  begin
                    if T2 < club.card_par[hole] then TextColor(Lightred);
                    if T2 > club.card_par[hole] then TextColor(Darkgray);
                    if T2 = club.card_par[hole] then  TextColor(LightBlue);
                  end;
                GotoXY (1,1);
                if color then TextBackground(green);
                Write(T2:3);
                if color then TextColor(yellow);
                curr_game.score[hole] := T2;
              end; {else case}
            end; {case}
          hole := succ(hole);
        until hole > max_holes;
        for hole := 1 to max_holes do T1 := T1 + curr_game.score[hole];
        Window(6+max_holes*3,19,80,20);
        TextBackground(white);
        Write(' =',T1:4);
        ch := Readkey;
        if ch = #0 then ch := Readkey;
        if ch = 'K' then
          begin
            hole := max_holes;
            GotoXY(1,1);
            TextBackground(green);
            ClrEol;
            T1 := 0;
          end; {of reset for a back-arrow}
      until ch <> 'K';  {Until not a back-arrow}
      Window(6 + max_holes*3,19,80,20);
      TextBackground(green);
      Write(' =',T1:4,' -',card_par:3,' =');
      T1 := T1 - card_par;
      Writeln(T1:3);
      Equitable_Stroke_Control( esc_score,
                                curr_game.score,
                                club.card_par,
                                golfer.hcp);
      if color then TextBackground(green);
    end;     {Get_Score}

  Procedure Post;
    var
      s : integer;
      i : shortint;
      ans,ch : char;
      temp : real;
      status : char;

    begin
      scorecard;
      Get_Score(status,curr_game);
      if option = ProgramExit then exit;
      repeat
        GotoXY(1,7);
        ClrEol;
        if status = #27 then ans := status
          else
            begin
              Write('OK for posting? Y/N ');
              ans := ReadKey;
              if ans = #0 then
                begin
                  ans := Readkey;
                  if ans = '-' then
                    begin
                      option := ProgramExit;
                      exit;
                    end
                end
            end;
      until ans in ['Y','y','N','n',#27];
      case ans of
        'Y','y':
          begin
{$I-}
            s := FileSize(game_file);
            if IOResult <> 0 then exit;
{$I+}
            if s < max_diffs
              then s := s + 1
              else
                begin
                  s := max_diffs;
                  for i := 1 to s-1 do
                    golfer.last_20[i] := golfer.last_20[i+1];
                end; {if FileSize}
            if IOResult <> 0 then exit;
            golfer.last_20[s] := eq_sum; {New game always at end}
            curr_game.game_no := FileSize(game_file) + 1;
            golfer.no_of_games := curr_game.game_no;
            golfer.hcp := Handicap(golfer.last_20,golfer.no_of_games);
            curr_game.hcp := round(golfer.hcp);
            curr_game.course_id := club.id;
            curr_game.year := year - 1900;
            curr_game.month := month;
            curr_game.day   := day;
            GotoXY(1,WhereY + 5);
            Writeln('Posted..New Hcp is: ',golfer.hcp:5:2,' (',
                     round(golfer.hcp):2,'), Game no ',curr_game.game_no:4);
            i := WhereY;
            Seek (game_file,FileSize(game_file));
            Write(game_file,curr_game);
            Seek(golfers,golfer.id);
            Write(golfers,golfer);
          end; {Yes case}
        'N','n',#27: Write('--not posted');
      end; {case}
      option := CourseAnalysis;
    end;     {Post}

  Procedure Analysis(var gamefile: game_file_type;
                         club : course_type );
    type
      score_range = -3..10;
      over_by_hole_type = array[score_range,holes] of integer;
      difficulty_type = record
                          order  : shortint;
                          rank   : shortint;
                          overage: real;
                        end;
      ranking_type = array[holes] of difficulty_type;
    const
      over_par:array [score_range] of string[15] =
      ('Double Eagle...','Eagles.........','Birdies........'
      ,'Pars...........','Bogies.........','Double_bogies..'
      ,'Triple_bogies..','Quad_bogies....','Five_overs.....'
      ,'Six_overs......','Seven_overs....','Eight_overs....'
      ,'Nine_overs.....','Over Nine over!');
    var
      over_by_hole   : over_by_hole_type;
      average        : array [holes] of real;
      front9,back9   : real;
      totals         : real;
      hole           : shortint;
      sums           : array [holes] of integer;
      current_game   : game_type;
      this_course,
      this_game_file : shortint;
      score_count    : integer;
      sum_scores     : array [score_range] of integer;
      sum_card_pars  : integer;
      overage        : score_range;
      hole_rank      : ranking_type;
      key            : shortint;
      start_date,end_date,
      curr_date      : longint;
      month,day,year,dayofweek : word;
      total          : integer;
      status         : char;
      BestSum,  WorstSum,  LastSum : byte;
      BestDate, WorstDate, LastDate: longint;
      Hcp            : real;
    procedure Sort (var row : ranking_type; key:shortint; length : shortint);

    {row is an array of elements to be sorted, while length is the number of
    elements in the array.  row[i] serves as both element and sort key.
    Necessary to write a new procedure for each element type and sort key!?
    The elements here MUST be in an array (not a file) }

      var
        jump, m, n : shortint;    {These are used as indices into array}
        temp       : difficulty_type;  {This too must be same type as element}
        alldone    : boolean;

      procedure Interchange;
        begin   {interchange elements ... within Sort}
          temp   := row[m];   {Here row[i] is used as element}
          row[m] := row[n];
          row[n] := temp;
          alldone:= false;
        end;    {Interchange}

      begin   {Sort ... within Analysis}
        jump := length;
        while jump > 1 do
         begin
           jump := jump div 2;
           repeat
             alldone := true;
             for m := 1 to length - jump do
               begin
                 n := m + jump;
                 {Test sort keys for desired order}
                 case key of
                   1: {Here row[i] is used as sort key}
                     if row[m].overage < row[n].overage then Interchange;
                   2:
                     if row[m].order > row[n].order then Interchange;
                 end; {case}
               end {for}
           until alldone
        end {while}
      end; {Sort}

    begin   {Analysis}
      Window(1,10,80,25);
      ClrScr;
{$I-}
      Reset (game_file);
{$I-}
      if ioresult <> 0 then
        begin
          Window(1,1,80,25);
          GotoXY(25,15);
          Writeln('No game file for this golfer!');
          option := PostScore;
          exit;
        end;
      GetDate(year,month,day,dayofweek);
      month := 1;
      day   := 1;
      Window(1,11,80,25);
      Writeln('Starting date for analysis');
      Window(1,12,80,25);
      Get_Date(status,month,day,year);
      Window(1,13,80,25);
      start_date := 10000*(Year - 1990) + month*100 + day;
      Window(1,14,80,25);
      Writeln('Ending date');
      Window(1,15,80,25);
      GetDate(year,month,day,dayofweek);
      Get_Date(status,month,day,year);
      end_date := 10000*(year - 1990)+month*100+day;
      Window(1,17,80,25);
      Writeln('Printing? Y/N ');
      ch := ReadKey;
      printing := ch in ['y','Y'];
      if ch = #0 then ch := ReadKey;
      Window(1,1,80,25);
      ClrScr;
      for hole := 1 to max_holes do
        begin
          for overage := -3 to 10 do
              over_by_hole[overage,hole] := 0;
          sums[hole] := 0;
          average[hole] := 0;
        end;
      for overage := -3 to 10 do
          sum_scores [overage] := 0;
      sum_card_pars := 0;
      total := 0;
      score_count := 0;
      While FilePos(game_file) < FileSize(game_file) do
        begin
{$I-}
          Read(game_file,current_game);
          if ioresult <> 0 then
            begin
              GotoXY(10,10);
              Write('No Game file for this golfer!');
              option := ProgramExit;
              exit;
            end;
{$I+}
          with club do
            begin;
              with current_game do
                begin;
                  curr_date := 10000*(year - 90)+month*100+day;
                  if (curr_date >= start_date) and
                  (curr_date <= end_date) then
                    begin
                      total := total + 1;
                      last_game_no := current_game.game_no;
                      if first_game_no = 0 then
                        first_game_no := last_game_no;
                      if club.id = current_game.course_id then
                        begin
                          score_count := Succ(score_count);
                          LastSum  := 0;
                          LastDate := curr_date;
                      for hole := 1 to max_holes do
                        begin
                          lastsum := lastsum + score[hole];
                          for overage := -3 to 10 do
                            if score[hole] = (card_par[hole] + overage ) then
                              over_by_hole[overage,hole] :=
                                Succ(over_by_hole[overage,hole]);
                          if score[hole] > (card_par[hole] + 10) then
                            over_by_hole[10,hole] :=
                              Succ(over_by_hole[10,hole]);
                          sums[hole] := sums[hole] + score[hole];
                        end; {hole 1 to max_holes}
                        if score_count = 1
                         then
                           begin
                             Worstsum := lastsum;
                             Bestsum := lastsum;
                             bestdate := curr_date;
                             worstdate := curr_date;
                           end
                         else
                           begin
                             if lastsum > worstsum then
                               begin
                                 worstsum := lastsum;
                                 worstdate := curr_date;
                               end;
                             if bestsum > lastsum then
                               begin
                                 bestsum  := lastsum;
                                 bestdate := curr_date;
                               end;
                           end; {Best,worst,last}
                      end; {club.id = curr_game.course_id}
                  end; {current_date in bounds}
              end; {inner with (current_game)}
          end; {outer with (club)}
        end;  {while}
      Window(1,1,80,25);
      if score_count = 0 then
        begin
          GotoXY(5,12);
          Writeln(golfer.name,' has not played at ',club.name,'!');
          option := ProgramExit;
          exit;
        end;
      if printing then
{$I-}
        repeat
          Writeln(lst,'Analysis ',score_count,' scores at ',club.name,
           ' (',total,' in all) For ',golfer.name );
           errcode := IOResult;
           if errcode <> 0 then Writeln('Turn on Printer');
        until errcode = 0;
{$I+}
      ClrScr;
      Writeln('Analysis of ',score_count,' scores at ',club.name,
      ' (',total,' in all) For ',golfer.name );
      if color then
        TextColor(yellow);
      Write('For Hole number');
      for hole := 1 to max_holes do
        Write(hole:3);
      Writeln(' Total');
      Write(' Card par      ');
      for hole := 1 to max_holes do
        begin
          Write(club.card_par[hole]:3);
          sum_card_pars := sum_card_pars + club.card_par[hole];
        end;
      Write(' =',sum_card_pars:4);
      Writeln;
      for overage := -3 to 10 do
        begin
          case overage of
            -1,-2,-3: if color then TextColor(red);
             0   : if color then TextColor(blue);
          else
            if color then TextColor(black);
          end; {case}
          for hole := 1 to max_holes do
              sum_scores[overage] := sum_scores[overage]
              + over_by_hole[overage,hole];
          if sum_scores[overage] <> 0 then
            begin
              Write(over_par[overage]);
              for hole := 1 to max_holes do
                if over_by_hole[overage,hole] = 0 then Write('  .')
                else Write(over_by_hole[overage,hole]:3);
              Writeln(' =',sum_scores[overage]:4);
            end;
        end; {for overage loop}
      if color then
        TextColor(yellow);
      Writeln('  Hole number (Personal difficulty rank) and ''over_par average''');
      front9 := 0;
      back9  := 0;
      for hole := 1 to front do
        begin
          average[hole] := sums[hole] / score_count;
          front9 := front9 + average[hole];
        end;
      for hole := front + 1 to max_holes do
        begin
           average[hole] := sums[hole] / score_count;
           back9 := back9 + average[hole];
        end;
      totals := front9 + back9;
      for hole := 1 to max_holes do
        begin
          hole_rank[hole].order := hole;
          hole_rank[hole].overage := average[hole] - club.card_par[hole];
        end;
      Sort(hole_rank,1,max_holes);
      for hole := 1 to max_holes do
        hole_rank[hole].rank := hole;
      Sort(hole_rank,2,max_holes);
      for hole := 1 to front do
        begin
          Write(' hole ',hole:2,' (',hole_rank[hole].rank:2,') : ',
            average[hole]:6:3);
          Write(' -',club.card_par[hole]:2,' = ');
          Write(average[hole] - club.card_par[hole]:6:3);
          If hole + front <= max_holes then
            begin
              Write('   hole ',hole + front:2,' (',
                    hole_rank[hole + front].rank:2,
                    ') : ',average[hole + front]:6:3);
              Write(' -',club.card_par[hole + front]:2,' = ');
              Write(average[hole + front] - club.card_par[hole + front]:6:3);
            end;
          Writeln;
        end;
      Write(' Front       :',front9:7:3);Write('                ');
      Writeln('Back        :',back9:7:3);
      GetDate(year,month,day,dayofweek);
      Writeln(' Grand average =',totals:7:3,' , current (',
      month,'/',day,'/',year,') hcp =',
      golfer.hcp:5:1,'  Anti-hcp =', AntiHcp:5:1);
      Write(' Best: ',BestSum,' on ',(BestDate mod 10000) div 100,'/',
                                    (BestDate mod 100),'/',
                                    (BestDate div 10000) + 1990,';  ');
      Write('Worst: ',WorstSum,' on ',(WorstDate mod 10000) div 100,'/',
                                    (WorstDate mod 100),'/',
                                    (WorstDate div 10000) + 1990,';  ');
      Write('Last: ',LastSum,' on ',(LastDate mod 10000) div 100,'/',
                                    (LastDate mod 100),'/',
                                    (LastDate div 10000) + 1990);
      if printing then
        begin
          Write(lst,' from ', (start_Date mod 10000) div 100,'/',
                       (start_Date mod 100),'/',
                       (start_Date div 10000) + 1990,';  ');
          Writeln(lst,' to ', (end_Date mod 10000) div 100,'/',
                       (end_Date mod 100),'/',
                       (end_Date div 10000) + 1990,';  ');
          Writeln(lst);
          Write(lst,'For Hole number');
          for hole := 1 to max_holes do
            Write(lst,hole:3);
          Writeln(lst,' Total');
          Write(lst,' Card par      ');
          for hole := 1 to max_holes do
            Write(lst,club.card_par[hole]:3);
          Write(lst,' =',sum_card_pars:4);
          Writeln(lst);
          for overage := -3 to 10 do
            begin
              if sum_scores[overage] <> 0 then
                begin
                  Write(lst,over_par[overage]);
                  for hole := 1 to max_holes do
                    if over_by_hole[overage,hole] = 0 then Write(lst,'  .')
                    else Write(lst,over_by_hole[overage,hole]:3);
                  Writeln(lst,' =',sum_scores[overage]:4);
                end;
            end;
          for hole := 1 to 3 do
            Writeln(lst);
          Writeln(lst,'  Hole number (Personal difficulty rank) and ''over_par average''');
          Writeln(lst);
          for hole := 1 to front do
            begin
              Write(lst,' hole ',hole:2,' (',hole_rank[hole].rank:2,') : ',
                average[hole]:6:3);
              Write(lst,' -',club.card_par[hole]:2,' = ');
              Write(lst,average[hole] - club.card_par[hole]:6:3);
              If hole + front <= max_holes then
                begin
                  Write(lst,'   hole ',hole + front:2,' (',hole_rank[hole + front].rank:2,
                  ') : ',average[hole + front]:6:3);
                  Write(lst,' -',club.card_par[hole + front]:2,' = ');
                  Write(lst,average[hole + front] - club.card_par[hole + front]:6:3);
                end;
              Writeln(lst);
          end;
          Write(lst,' Front       :',front9:7:3);Write(lst,'                ');
          Writeln(lst,'Back        :',back9:7:3);
          GetDate(year,month,day,dayofweek);
          Writeln(lst,' Grand average =',totals:7:3,' , current (',
          month,'/',day,'/',year,') hcp =',
          golfer.hcp:5:1,'  Anti-hcp =', AntiHcp:5:1);
          Writeln(lst);
          Writeln(lst,' Best:  ',BestSum,' on ',
               (BestDate mod 10000) div 100,'/',
               (BestDate mod 100),'/',
               (BestDate div 10000) + 1990,';  ');
          Writeln(lst,' Worst: ',WorstSum,' on ',
               (WorstDate mod 10000) div 100,'/',
               (WorstDate mod 100),'/',
               (WorstDate div 10000) + 1990,';  ');
          Writeln(lst,' Last:  ',LastSum,' on ',
               (LastDate mod 10000) div 100,'/',
               (LastDate mod 100),'/',
               (LastDate div 10000) + 1990);
          Writeln(lst,#12);
          Write(lst,golfer.name,'''s Game list from ',
               (start_date mod 10000) div 100,'/',
               (start_date mod 100),'/',
               (start_date div 10000) + 1990);
          Writeln(lst,' to ',
               (end_date mod 10000) div 100,'/',
               (end_date mod 100),'/',
               (end_date div 10000) + 1990);
          prev_game.course_id := 0;
          for score_count := first_game_no to last_game_no do
            begin
              Seek(game_file,score_count - 1);
              Read(game_file,current_game);
              if current_game.course_id <> prev_game.course_id then
                begin
                  prev_game.course_id := current_game.course_id;
                  Seek(courses,current_game.course_id);
                  Read(courses,club);
                  Writeln(lst,'      ',club.name);
                  total := 0;
                  Write(lst,'   Par =  ');
                  for hole := 1 to max_holes do
                    begin
                      Write(lst,club.card_par[hole]:3);
                      total := total + club.card_par[hole];
                    end;
                  Writeln(lst,' =',total:4);
                end;
                total := 0;
                with current_game do
                begin
                  Write(lst,month:2,'/',day:2,'/19',year:2);
                  for hole := 1 to max_holes do
                   begin
                     write(lst,score[hole]:3);
                               total := total + score[hole];
                   end;
                  Writeln(lst,' =',total:4);
                end;
            end;
          Writeln(lst,#12);
        end;
      Readln;
      if color then TextBackground(black);
      ClrScr;
      option := ProgramExit;
    end;   {Analysis}

  Procedure Edit(var hiline: byte);
    var
      oldfile  : string[12];
      saveid   : byte;
      i        : integer;
      t1,t2    : integer;
      t3,t4    : integer;
      chr      : char;
      newfile  : string[12];
      copycom  : string;
      ch       : string[1];
      hcp      : real;
    const
      savename : string[20] = '                    ';
      quit     : byte = 4;

    begin
      Str(golfer.id,s);
      copycom := '/c copy golfr' + s + ' golfr' + s + '.bak >temp ';
      SwapVectors;
      exec('c:\command.com',copycom);
      SwapVectors;
      if DosError <> 0 then Writeln('DosError = ',DosError);
      newfile := savename;
      if color then TextColor(black);
      if color then TextBackground(green);
      Seek(golfers,golfer_id);
      Read(golfers,golfer);
      hcp := Handicap(golfer.last_20,golfer.no_of_games);
      savename := golfer.name;
      saveid := golfer.id;
      golfer := nobody;
      golfer.name := savename;
      golfer.id := saveid;
      Str(saveid,ch);
      newfile := 'golfr' + ch;
      Window (40,11,80,16);
      ClrScr;
      Writeln('Name of gamefile: ');
      Read(oldfile);
      t1 := WhereX;
      if oldfile = '' then oldfile := newfile + '.bak';
      Assign (old,oldfile);
{$I-}
      Reset (old);
{$I+}
      if ioresult <> 0 then
        begin
          Writeln('File error');
          option := ProgramExit;
          exit;
        end;
      GotoXY(t1,2);
      Writeln(oldfile ,'  --> ', newfile);
      Assign (game_file, newfile);Rewrite (game_file);
      Writeln('Press <delete> to skip game');
      Writeln('Press <insert> to add game, ');
      Write('<esc> to abort,');
      Writeln(' other to include ');
      repeat
        Read(old,curr_game);
        Seek(courses,curr_game.course_id);
        year := curr_game.year + 1900;
        month := curr_game.month;
        day := curr_game.day;
        if color then TextColor(black);
        if color then TextBackground(green);
{$I-}
        Read(courses,club);
        if ioresult <> 0 then
          begin
            Write('Error in ''''courses'''' file');
            option := ProgramExit;
            exit;
          end;
{$I+}
        Scorecard;
        if color then TextColor(black);
        if color then TextBackground(green);
        GotoXY(xloc + 2,2);
        Writeln ('Date ', month:2,'/',day:2,'/',year);
        GotoXY(1,5);
        Write('Score');
        t2 := 0;
        t4 := 0;
        for hole := 1 to max_holes do
          begin
            t1 := curr_game.score[hole];
            t3 := club.card_par[hole];
            if t3 = t1 then if color then TextColor(blue);
            if t3 > t1 then if color then TextColor(red);
            Write(t1:3);
            t2 := t2 + t1;
            t4 := t4 + t3;
            if color then TextColor(black);
          end;
        Writeln(' = ', t2:4,' - ',t4,' = ',t4 - t3);
        Equitable_Stroke_Control(esc_score,curr_game.score,
                              club.card_par,golfer.hcp);
        chr := ReadKey;
        if chr = #0 then chr := ReadKey;
        case chr of
         'R':  {Insert key}
           begin
             Course_Box (80,1, SizeOf(club.name) + 2, max_course_box,
             'Courses', FileSize(courses), course_over_top, course_hiline);
             Post;
             Seek(old,FilePos(old) - 1);
           end;
         'S',#27: {Nothing}
        else
          begin {compound statement}
            Seek (game_file,FileSize(game_file));
            curr_game.game_no := FilePos(game_file) + 1;
            if golfer.no_of_games > max_diffs - 1
              then
                begin
                  for i := 1 to max_diffs - 1 do
                    golfer.last_20[i] := golfer.last_20[i+1];
                  golfer.last_20[max_diffs] := eq_sum;
                end
              else
                golfer.last_20[golfer.no_of_games+1] := eq_sum;
            golfer.no_of_games := curr_game.game_no;
            golfer.hcp := Handicap(golfer.last_20,golfer.no_of_games);
            curr_game.hcp := round(golfer.hcp);
            curr_game.course_id := club.id;
            Write(game_file,curr_game);
            Seek(golfers,golfer.id);
            Write(golfers,golfer);
          end {compound statement}
        end; {case}
     until eof(old) or (chr = #27);
     Window(42,8,80,12);
     GotoXY(1,2);
     hiline := quit;
     Close(old);
     Close(game_file);
     option := ProgramExit;
    end;  {Edit}

  Procedure View_Golfer_Box(xloc,yloc: byte);

    var
      ch : char;
      x,view,over_top,hiline,counter : byte;
    const
      NumberOfViews : byte = 5;
      ViewWidth     : byte = 14;
            {array[1..NumberOfViews] won't compile}
            {Nor will string[ViewWidth]....neither are REALLY constants!}
      views : array[1..5] of string[34] =
                  (' Original Entry Order',
                   ' Alphabetic Order',
                   ' last name',
                   ' handicap',
                   '  ------Print-----');

    Procedure PrintGolfers;
      var i,j : integer;
      begin
{$I-}
        repeat
          Writeln(lst,'  Roster sorted by ',views[golfer_view]);
          errcode := IOResult;
          if errcode <> 0 then writeln('Turn on Printer');
        until errcode = 0;
{$I+}
        Writeln(lst);
        Write(lst,' Name                    ');
        Writeln(lst,'Hcp');
        for i := 1 to FileSize(golfers) - 1 do
          begin
            Seek(golfers,gx[i]);
            Read(golfers,golfer);
            Write(lst,golfer.name);
            for j := 1 to 25 - Length(golfer.name) do Write(lst,' ');
            Writeln(lst,golfer.hcp:5:2);
          end;
        Writeln(lst,#12);
      end;

    begin  {View_Golfer_Vox}
      over_top := 0;
      hiline   := golfer_view;
      Box (xloc, yloc, ViewWidth + 6, NumberOfViews, 'View golfer in');
      if color then TextColor(yellow);
      repeat
        for counter := 1 to NumberOfViews do
        begin
          if counter = hiline
           then
              begin
                if color then TextBackground(red)
                         else HighVideo;
                view := counter;
              end
           else
              begin
                if color then TextBackground(green)
                         else LowVideo;
              end;
          GotoXY(1,counter);
          Write(views[counter]);
          GotoXY(1,view);
        end; {for loop}
        Select(ch,hiline,over_top,NumberOfViews,NumberOfViews);
        if option = ProgramExit then exit;
        if ch = #13
           then
           case hiline of
             1..4 :
               begin
                Gindex(hiline);
                golfer_view := view;
               end;
             5: PrintGolfers;
           end;
        TextBackground(green);
      until ch = #13;
      Golfer_Box (1,1, SizeOf(golfer.name) + 5, max_golfer_box,
        'Golfer name-Hcp', FileSize(golfers), golfer_over_top,
         golfer_hiline);
      option := SelectGolfer;
    end;    {View_Golfer_Box}

  Procedure View_Course_Box(xloc,yloc: byte);

    var
      ch : char;
      view,over_top,hiline,counter : byte;

    const
       NumberOfViews : byte = 3;
       ViewWidth     : byte = 14;
            {array[1..NumberOfViews] won't compile}
            {Nor will string[ViewWidth]....neither are REALLY constants!}
       views : array[1..3] of string[22] =
                  (' Entry Order     ',
                   ' Alphabetic Order',
                   ' ----Print---    ');

    Procedure PrintCourses;
      var i,j,counter : integer;
      begin
{$I-}
        repeat
          Writeln(lst,'   Courses in',views[course_view],
                      '     Par   Rated/Slope');
          errcode := IOResult;
          if errcode <> 0 then Writeln('Turn on Printer');
        until errcode = 0;
{$I+}
        Writeln(lst);
        for counter := 1 to FileSize(courses) - 1 do
          begin
            Seek(courses,cx[counter]);
            Read(courses,club);
            Write(lst,club.name);
            for j := 1 to 32 - Length(club.name) do Write(lst,' ');
            j := 0;
            for i := 1 to max_holes do j := j + club.card_par[i];
            Write(lst,j:5);
            Writeln(lst,club.rated_par:9:1,'/',club.slope:4);
          end;
            Writeln(lst,#12);
      end; {PrintCourses}

    begin  {View_Course_Box}
      over_top := 0;
      hiline   := course_view;
      Box (xloc, yloc, ViewWidth + 6, NumberOfViews, 'View Course in');
      if color then TextColor(yellow);
      repeat
        for counter := 1 to NumberOfViews do
          begin
            if counter = hiline
              then
                begin
                  if color then TextBackground(red)
                           else HighVideo;
                  view := counter;
                end
              else
                begin
                  if color then TextBackground(green)
                           else LowVideo;
                end;
            GotoXY(1,counter);
            Write(views[counter]);
            GotoXY(1,view);
          end; {for loop}
        Select(ch,hiline,over_top,NumberOfViews,NumberOfViews);
        if option = ProgramExit then exit;
        if ch = #13
          then
            case hiline of
              1..2 :
                begin
                  Cindex(view);
                  course_view := view;
                end;
              3: PrintCourses;
            end;
        TextBackground(green);
      until ch = #13;
      Course_Box (80,1, SizeOf(club.name) + 2, max_course_box,
      'Courses', FileSize(courses), course_over_top, course_hiline);
      option := SelectGolfer;
    end;    {ViewCourseBox}

  Procedure Option_Box(xloc,yloc: byte);
    var
      ch : char;
      over_top,hiline,counter : byte;
    const
      NumberOfOptions : byte = 8;
      OptionWidth     : byte = 14;
            {array[1..NumberOfOptions] won't compile}
            {Nor will string[OptionWidth]....neither are REALLY constants!}
      options : array[1..8] of string[14] =
                  (' View - Course',
                   ' Course  (->)',
                   ' View - Golfer',
                   ' Golfer  (<-)',
                   ' Post a score',
                   ' Analysis',
                   ' Quit  (Alt-x)',
                   ' Edit gamefile');
    begin
      over_top := 0;
      option := SelectCourse;
      repeat {until exit}
        hiline := ord(option) + 1;
          repeat {till C/R, left or right arrow}
            Box (xloc, yloc, OptionWidth + 4, NumberOfOptions, 'Options');
            if color then
              begin
                TextColor(yellow);
                TextBackground(green);
              end;
            Clrscr;
            for counter := 1 to NumberOfOptions do
              begin
                if counter = hiline
                  then
                    begin
                    if color then TextBackground(red)
                             else HighVideo
                    end
                  else
                    begin
                      if color then TextBackground(green)
                               else LowVideo
                    end;
                GotoXY(1,counter);
                Write(options[counter]);
                GotoXY(1,counter + 1);
              end;  {counter loop}
            GotoXY(1,hiline);
            Select(ch,hiline,over_top,NumberOfOptions,NumberOfOptions);
            GotoXY(1,hiline);
            case ch of
              '-': hiline := ord(succ(option_type(ProgramExit)));
              'K':  {Left-arrow}
                   hiline := ord(succ(option_type(SelectGolfer)));
              'M':  {Right-arrow}
                   hiline := ord(succ(option_type(SelectCourse)));
            end;   {ch case }
            option := option_type(pred(hiline));
            GotoXY(1,hiline);
          until ch in [#13,'K','M'];
          case option of
            ViewCourses:
              View_Course_Box(50,2);
            SelectCourse:
              Course_Box(80,1,SizeOf(club.name) + 2,max_course_box,
              'Courses', FileSize(courses), course_over_top, course_hiline);
            ViewGolfer:
              View_Golfer_box(2,2);
            SelectGolfer:
              Golfer_Box (1,1,SizeOf(golfer.name) + 5,max_golfer_box,
              'Golfer name-Hcp', FileSize(golfers), golfer_over_top,
               golfer_hiline);
            PostScore: Post;
            CourseAnalysis: Analysis(game_file, club);
            ProgramExit: Exit;
            EditGames: Edit(hiline);
          end; {case option}
          TextBackground(green);
      until false; {actually, till an exit is taken above}
    end;
{--------------------------------------------------------}
{  Start of Main Program  }
  var
    hcp : real;
  begin
    Window(1,1,80,25);
    for id := 1 to ParamCount do
      begin
        pstring := ParamStr(id);
        case pstring[1] of
          'h' : val(Copy(pstring,2,Length(pstring)),max_holes,code);
          '%' : val(Copy(pstring,2,Length(pstring)),percent,code);
          'g' : val(Copy(pstring,2,Length(pstring)),max_diffs,code);
          'a' : val(Copy(pstring,2,Length(pstring)),adj_score_rule,code);
          's' : begin
                  ch := char(pstring[2]);
                  case ch of
                    '+' : use_slope := true;
                    '-' : use_slope := false;
                  end; {case of slope + or -}
                end;  { of slope}
        end; { of case pstring}
      end;  { of Params}
  {See if mono or color}
    intr($11,regs);
    mono := (regs.ax and $30) = $30;
    color := not mono;
    ClrScr;
    writeln(' Color = ',color);
    writeln(' Nmbr of holes = ',max_holes:2);
    writeln(' Adj. Score rule #',adj_score_rule:1);
    GotoXY(55,1);
    writeln('Max diffs in Hcp = ',max_diffs:2);
    GotoXY(55,2);
    writeln('Percent is ',percent:3,'%');
    GotoXY(55,3);
    writeln('Slope = ',use_slope);
    Back := max_holes div 2;
    Front := max_holes - Back;
   {Get status from last execution}
    Assign(default,'golf.ini');
{$I-}
    Reset(default);
    Readln(default, golfer_view  , course_view,
                    golfer_id    , course_id);
{$I+}
    if ioresult <> 0 then
      begin
        Rewrite(default);
        Writeln(default,1,' ',1,' ',0,' ',0);
        Close(default);
        Reset(default);
        Readln(default, golfer_view  , course_view,
                        golfer_id    , course_id);
      end;
 {Prepare Golfers and Courses files}
    Assign (golfers,'Golfers');
{$I-}
    Reset(golfers);
    Seek(golfers,golfer_id);
    Read(golfers,golfer);
{$I+}
    if IOResult <> 0
      then
        begin
          Rewrite(golfers);
          Write(golfers,nobody);
          Close(golfers);
          Reset(golfers);
          Read(golfers,golfer);
        end
      else
        begin
          Str(golfer_id,s);
          Assign(game_file,'golfr' + s);
          if golfer_id <> 0 then
            Reset(game_file);
        end;
    Assign(courses,'courses');
{$I-}
    Reset(courses);
    Seek(courses,course_id);
    Read(courses,club);
{$I+}
    if IOResult <> 0 then
      begin
        Rewrite(courses);
        Write(courses,nowhere);
        Close (courses);
        Reset(courses);
        Read(courses,club);
      end;
   {Initialize cx and gx background}
    for id := 0 to 255 do
      begin
        cx[id] := 0;
        gx[id] := 0;
      end;
   {Equivalent to Cindex(1) and Gindex(1) without Align}
    for id := 0 to FileSize(courses) do  cx[id] := id;
    for id := 0 to FileSize(golfers) do  gx[id] := id;
    Course_hiline := course_id;
    Course_over_top := 0;
    Cindex(course_view);
    Seek(courses,course_id);
    Read(courses,club);

    golfer_hiline := golfer_id;
    golfer_over_top := 0;
    Gindex(golfer_view);
    GotoXY(32,16);
    Writeln(version);
    GotoXY(24,17);
    Writeln(copyrite);
    GotoXY(19,18);
    Writeln('See Golf.txt to see how and why to register');
    GotoXY(12,20);
    Writeln('Use up/down arrows to select, Enter to activate selection');
    Seek(golfers,golfer_id);
    Read(golfers,golfer);
    hcp := Handicap(golfer.last_20,golfer.no_of_games);

    Option_Box(28,1);

    Close(Golfers);
    Close(courses);
{$I-}
     Close(game_file);
     if IOResult <> 0 then;  {No Operation?}
{$I+}
     Close (default); Assign(default,'golf.ini'); Rewrite(default);
     Writeln(default, golfer_view:4   ,course_view:4,
                      golfer_id:4     ,course_id:4);
     Close(default);
     Window(1,1,80,25);
     if color then TextColor(lightgray);
     if color then TextBackground(black)
              else LowVideo;
     ClrScr;
  end.
