/*** info.c ***/

#include <stdio.h>
#include <string.h>
#include "windows.h"
#include "info.h"

extern HWND hInfoWnd;

static char Temp[25];

static char ASstring[21] = " Bytes:            ";
static char XYstring[21] = "Packet:            ";
static struct
  {char FileName[21];
   char FileSize[21];
   char Packet[21];
   char Errors[21];
   char Status[21];
  } InfoData = {"F'Name:             ",
                "F'Size:             ",
                "Packet:             ",
                "Errors:             ",
                "Status:             "};

void InfoChoose(char Which)
{if(Which=='A')
 strcpy(&InfoData.Packet[0],ASstring);
 else strcpy(&InfoData.Packet[0],XYstring);
}

void InfoFileName(char *Ptr)
{strncpy(&InfoData.FileName[8],Ptr,12);
}

void InfoFileSize(long Size)
{sprintf(Temp,"%ld  ",Size);
 strcpy(&InfoData.FileSize[8],Temp);
}

void InfoPacket(unsigned int Packet)
{sprintf(Temp,"%u  ",Packet);
 strcpy(&InfoData.Packet[8],Temp);
}

void InfoBytes(unsigned int Bytes)
{InfoPacket(Bytes);
}

void InfoErrors(int Errors)
{sprintf(Temp,"%d  ",Errors);
 strcpy(&InfoData.Errors[8],Temp);
}

void InfoStatus(char *Ptr)
{strcpy(&InfoData.Status[8],Ptr);
}

long FAR PASCAL InfoWndProc(HWND hWnd,UINT iMessage, UINT wParam, LONG lParam)
{HDC  hDC;
 hInfoWnd = hWnd;
 switch(iMessage)
   {case WM_USER:
      hDC = GetDC(hInfoWnd);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      TextOut(hDC, 0,  0, InfoData.FileName, strlen(InfoData.FileName) );
      TextOut(hDC, 0, 15, InfoData.FileSize, strlen(InfoData.FileSize) );
      TextOut(hDC, 0, 30, InfoData.Packet,   strlen(InfoData.Packet) );
      TextOut(hDC, 0, 45, InfoData.Errors,   strlen(InfoData.Errors) );
      TextOut(hDC, 0, 60, InfoData.Status,   strlen(InfoData.Status) );
      ReleaseDC(hInfoWnd,hDC);
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    default:
      return DefWindowProc(hInfoWnd,iMessage,wParam,lParam);
   } /* end switch */
 return 0L;
} /* end InfoWndProc */