' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
'Routines related to reading of messages only:
'  AlterTheMessagesData
'  EditSentMessage
'  ForwardNoteAdd
'  MoveDirectory
'  SendFileAttach
'  SysopStandardReply
'  ReLocateMessage
'  ReGetIDX2
'  PRTheMessage
'  SaveMessageFile
'  DoFileAttach
'
SUB OverLay8
END SUB




        '* * * * * *
        ' This routine, internal to ReadMessages, will edit the
        ' header record of a message.
        '
        ' p  .IDX record number
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB AlterTheMessagesData (p)

  TT = 20071
  CALL SendTT
  K = FileOpenR(FileNames(134))
  K& = Blocks&(3,44)
  K0& = Message.MsgNum
  FOR K0 = 1 TO 15
    SELECT CASE K0
      CASE 1  : K$ = Message.MsgFrom 
      CASE 2  : K$ = Message.MsgTo
      CASE 3  : K$ = UnSq$(Message.MsgSubject)
      CASE 4  : K$ = STR$(Message.MsgNum)
      CASE 5  : K$ = IntToAttr$(Message.Attr)
      CASE 6  : K$ = IntToDate3$(Message.MsgDateSent)
      CASE 7  : K$ = IntToTime2$(Message.MsgTimeSent)
      CASE 8  : K$ = IntToDate3$(Message.MsgDateRcvd)
      CASE 9  : K$ = IntToTime2$(Message.MsgTimeRcvd)
      CASE 10 : K$ = STR$(ASC(Message.NumberReplies))
      CASE 11 : K$ = STR$(Message.TimesRead)
      CASE 12 : K$ = IntToDate3$(Message.LastDateRead)
      CASE 13 : K$ = IntToAttr$(Message.Attr2)
      CASE 14 : K$ = FidoForm$(Message.SourceAddr)
      CASE 15 : K$ = FidoForm$(Message.DestAddr)
    END SELECT
    K1& = K&
    TT$ = MID$(FileGetLine$(K,K&),3) + o$(72)
    SELECT CASE K0
      CASE 3     : TT$ = o$(73) + TT$ + LTRIM$(RTRIM$(K$)) + o$(74)
      CASE 5, 13 : TT$ = o$(73) + TT$ + K$ + o$(76)
      CASE ELSE  : TT$ = o$(73) + TT$ + LTRIM$(RTRIM$(K$)) + o$(76)
    END SELECT
    IF K0 = 1 OR K0 = 2 THEN K1 = GetUserNameTT _
                        ELSE K$ = LineEditTT$(51) : _
                             K2& = Val2&(K$) : _
                             K1 = LEN(K$)
    IF NoCarrier THEN EXIT FOR
    CALL DispCRLF
    SELECT CASE K1
      CASE IS > 0
           SELECT CASE K0
             CASE 1  : Message.MsgFrom = AnyUser.UserName
             CASE 2  : Message.MsgTo = AnyUser.UserName
             CASE 3  : Message.MsgSubject = Sq$(K$)
             CASE 4  : Message.MsgNum = K2&
             CASE 5  : IF ASC(K$) = 63 THEN CALL DispTextBlock(3,51,Null$) : _
                                            K& = K1& : _
                                            K0 = K0 - 1 _
                                       ELSE Message.Attr = AttrToInt(K$)
             CASE 6  : Message.MsgDateSent = DateToInt(K$)
             CASE 7  : Message.MsgTimeSent = TimeToInt(K$)
             CASE 8  : Message.MsgDateRcvd = DateToInt(K$)
             CASE 9  : Message.MsgTimeRcvd = TimeToInt(K$)
             CASE 10 : IF K2& < 256 THEN Message.NumberReplies = Chars$(K2&)
             CASE 11 : Message.TimesRead = K2&
             CASE 12 : Message.LastDateRead = DateToInt(K$)
             CASE 13 : IF ASC(K$) = 63 THEN CALL DispTextBlock(3,52,Null$) : _
                                            K& = K1& : _
                                            K0 = K0 - 1 _
                                       ELSE Message.Attr2 = AttrToInt(K$)
             CASE 14 : Message.SourceAddr = StrToAddr$(K$)
             CASE 15 : Message.DestAddr = StrToAddr$(K$)
           END SELECT
    END SELECT
  NEXT
  CALL FileCloseR(K)
  IF NoCarrier THEN EXIT SUB
  CALL ReGetIDX(p,K0&,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenW(FileNames(2))
  CALL FilePutLoc(K0,MsgIDX.MsgLoc,136,Message)
  CALL FileCloseW(K0)
  MsgIDX.MsgFrom = StrCkSum(Message.MsgFrom)
  MsgIDX.MsgTo = StrCkSum(Message.MsgTo)
  MsgIDX.MsgNum = Message.MsgNum
  CALL FilePutRec(K,p,12,MsgIDX)
  CALL FileCloseW(K)
  IF Message.MsgNum <> K0& AND BitTest(Message.Attr,12) _
     THEN CALL MoveDirectory(K0&,Message.MsgBase,Message.MsgNum)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' altering, deletion, and re-creation of an already sent
        ' message.
        '
        ' p   .IDX record number
        '
        ' p0  directional flag.
        '
        ' p$  message text
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB EditSentMessage (p,p0,p$)

'  p = p - p0
  CALL SubsEditMsg(1,p$,K)
  IF K = 0 THEN EXIT SUB
  TT = 20077
  CALL SendTT
  IF BitTest(Message.Attr,2) THEN p$ = Sq$(p$)
  Message.NumOfBytes = LEN(p$)
  CALL ReGetIDX2(p,Message.MsgNum,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenW(FileNames(2))
  K1 = FileOpenWDA(FileNames(73))
  Message.MsgLoc = FileLof&(K1,1)
  CALL FilePutLoc(K0,MsgIDX.MsgLoc,136,Message)
  CALL FilePutSEnd(K1,p$)
  CALL FileCloseW(K1)
  CALL FileCloseW(K0)
  CALL FileCloseR(K)
  TT = 20020
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' creation and adding of Forward notes.  Also the deletion
        ' of the original message.
        '
        ' p   .IDX record number
        '
        ' p0  directional flag
        '
        ' p$  message body
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ForwardNoteAdd (p,p0,p$)

  TT = 20078
  CALL SendTT
  CALL TGet2(o$(80) + C13$)
  IF TGot = -1 THEN TT = 20081 : _
                    CALL SendTT : _
                    p0 = 0 : _
                    EXIT SUB
  K = Message.MsgBase
  K& = Message.MsgNum
  K0 = Message.Attr
  K1 = TGot
  SELECT CASE K1
    CASE 1                             'Forward to another user.
         TT = 20082
         CALL SendTT
         TT = 20108
         DO
           kz = GetUserNameTT
           IF kz < 2 OR NoCarrier THEN TT = 20083 : _
                                       CALL SendTT : _
                                       p0 = 0 : _
                                       EXIT DO
           CALL TGet(C13$ + C8$)
           IF TGot = 8 THEN CALL Wipe(LEN(RTRIM$(AnyUser.UserName))) : _
                            Kz = 0
           TT$ = Null$
         LOOP UNTIL kz <> 0
         IF kz < 2 OR NoCarrier THEN EXIT SUB
         CALL DispCRLF
    CASE 2                             'Forward to another msg area.
         TT = 20084
         CALL SendTT
         aa$ = Null$
         FOR K2 = 1 TO BasesSize + 1
           aa$ = aa$ + MsgAreaInfo3$(K2,2) + C0$
         NEXT
         TT = 20085
         CALL MenuSystem(aa$,0)
         IF TGot = 0 THEN p0 = 0 : _
                          EXIT SUB
         Message.MsgBase = TGot - 1
         K2 = TGot - 1
  END SELECT
  TT = 20086
  SELECT CASE GetYNTT
    CASE -1
         TT = 20087
         CALL SendTT
         K0$ = p$
         p$ = Null$
         CALL GetMessageText(0,p$)
         K3 = LEN(p$)
         SELECT CASE K3
           CASE IS < 3
                TT = 20088
                CALL SendTT
                p$ = K0$
           CASE ELSE
                p$ = LEFT$(p$,K3 - 1)
                p$ = o$(89) + Form$(20,User.UserName) + o$(90) + C13$ + p$ + _
                     o$(89) + C13$
                TT = 20091
                IF GetYNTT THEN p$ = K0$ + p$ + C13$ _
                           ELSE p$ = p$ + C32$ + C13$ + K0$
         END SELECT
  END SELECT
  K0$ = NCR$(User.UserName)
  SELECT CASE K1
    CASE 1
         CALL DispCRLF
         Message.MsgTo = AnyUser.UserName
         p$ = o$(92) + K0$ + o$(93) + C13$ + C32$ + C13$ + p$
         CALL AddAMessage(0,p$,0,0)
    CASE 2
         aa$ = MsgAreaInfo3$(K + 1,2)
         K4 = LEN(LTRIM$(aa$))
         CALL IntMax(K4,LEN(K0$))
         K4 = K4 * 100 + 65
         p$ = o$(92) + Form$(K4,aa$) + o$(89) + C13$ + _
              o$(95) + Form$(K4,K0$) + o$(96) + C13$ + C32$ + C13$ + p$
         Message.MsgBase = K2
         CALL AddAMessage(1,p$,0,0)
  END SELECT
  IF BitTest(K0,12) THEN CALL MoveDirectory(K&,K,Message.MsgNum)
  CALL RemoveAMessage(p,K&,p0)
  TT = 20020
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' moving of the contents of a messages attached files when
        ' the message changes number or area.
        '
        ' p&   original message's number.
        '
        ' p    original message's area.
        '
        ' p0&  new message's number
        '
        ' Message.MsgBase = new message's area.
        '
        ' Does use, but doesn't alter, Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB MoveDirectory (p&,p,p0&)

  K$ = MakePathName$(p&,p + 1)
  K0$ = MakePathName$(p0&,Message.MsgBase + 1)
  CALL DirCreate(K0$)
  K0 = FindF2(K$ + o$(38),FFile)
  WHILE K0 <> 0
    CALL CopyFile(1,K$ + FFile.FName,K0$ + FFile.FName)
    K0 = FindF2(K$ + o$(38),FFile)
  WEND
  CALL DirDelete(K$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, will either
        ' send out the contents of a file attach or download the
        ' file attach.
        '
        ' p  number of files available to view/send.
        '
        ' p0 whether to view or download
        '    1 to view
        '    2 to DL
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB SendFileAttach (p,p0)

  K$ = MakePathName$(Message.MsgNum,Message.MsgBase + 1)
  TT = 20099 + (p0 = 1)
  SELECT CASE p
    CASE 1
         CALL SendTT
         K = FindF(K$ + o$(38),FFile) 
         K0$ = FFile.FName
         TT$ = K0$
         CALL SendTT
    CASE ELSE
         K0$ = LTRIM$(RTRIM$(LineEditTT$(13)))
         IF LEN(K0$) = 0 THEN CALL DispCRLF : _
                              EXIT SUB
         K0$ = Form$(1201,UCASE$(K0$))
         K = -1
         K0 = FindF(K$ + o$(38),FFile) 
         WHILE K0 <> 0 AND K
           IF FFile.FName = K0$ THEN K = 0 : _
                                ELSE K0 = FindF(Null$,FFile)
         WEND
         IF K THEN TT = 20100 : _
                   CALL SendTT : _
                   EXIT SUB
  END SELECT
  K$ = K$ + K0$
  SELECT CASE p0
    CASE 1
         K0 = FileType(K$)
         IF K0 >= 1 AND K0 <= 6 THEN TT = 20109 : _
                                     CALL SendTT : _
                                     EXIT SUB
         TT = 20101
         CALL SendTT
         K = FileOpenR(K$)
         K& = FileLof&(K,1)
         K0& = 0
         WHILE TGot < 1 AND K0& < K&
           CALL SendIt(o$(102) + FileGetBlock$(K,K0&,K&))
         WEND
         CALL FileCloseR(K)
         CALL Paused
         IF GInUse > 0 OR UGInUse > 0 THEN TT = 10064 : _
                                           CALL SendTT
    CASE 2
         IF CanDL& < FFile.FSize AND NOT BitTest(Message.Attr,14) _
            AND NOT BitTest(User.Attr,16) _
            THEN EXIT SUB
         CALL BuildFnamesCtl(K$)
         CALL AdjustProtocol(User.Protocol)
         TGot = 1000
  END SELECT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' creation of a standard reply to a message.
        '
        ' p   .IDX record number
        '
        ' p0  directional flag
        '
        ' p$  message body
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB SysopStandardReply (p,p0,p$)

  TT = 20097
  CALL SendTT
  Message.MsgTo = Message.MsgFrom            'Quote the sender.
  CALL QuoteTheMessage(p$,MsgAreaInfo3$(Message.MsgBase + 1,1),Message.MsgTo)
  p$ = o$(94) + UnSq$(RTRIM$(Message.MsgSubject)) + C13$ + C32$ + C13$ + _
       p$ + GetBlock$(0,13)
  K$ = Message.MsgFrom
  CALL BitSet(Message.Attr,11)               'Set redirected-to-AI.
  Message.MsgTo = Chars$(2)
  K = ASC(Message.NumberReplies)
  IF K < 255 THEN Message.NumberReplies  = Chars$(K + 1)
  CALL ReGetIDX2(p,Message.MsgNum,K)
  IF p = 0 THEN EXIT SUB
  K0 = FileOpenW(FileNames(2))
  CALL FilePutLoc(K0,MsgIDX.MsgLoc,136,Message)
  CALL FileCloseW(K0)
  CALL FileCloseR(K)
  CALL BitSet(Message.Attr,8)                'Set redirected-from-sysop.
  Message.MsgTo = K$
  CALL RemoveAMessage(p,Message.MsgNum,p0)
  CALL AddAMessage(2,p$,0,0)
  p0 = 1

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine, internal to ReadMessages, will re-locate
        ' the message to another area.
        '
        ' p  .IDX record number
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ReLocateMessage (p)

  TT = 20079
  CALL SendTT
  K$ = Null$
  FOR K = 1 TO BasesSize + 1
    K$ = K$ + MsgAreaInfo3$(K,2) + C0$
  NEXT
  TT = 20075
  CALL MenuSystem(K$,0)
  K = Message.MsgBase
  IF TGot < 1 OR TGot = K + 1 THEN EXIT SUB  'Ignore if moving to same area.
  Message.MsgBase = TGot - 1
  TT = 20077
  CALL SendTT
  K& = Message.MsgNum
  CALL ReGetIDX(p,K&,K0)
  IF p = 0 THEN EXIT SUB
  CALL IncreaseNextNumber
  MsgIDX.MsgNum = Message.MsgNum
  K1 = FileOpenW(FileNames(2))
  CALL FilePutLoc(K1,MsgIDX.MsgLoc,136,Message)
  CALL FileCloseW(K1)
  CALL CutOut(K0,Null$,p * 12& - 11,12&)
  CALL FileCloseW(K0)
  CALL PutAtEndMSGIDX(MsgIDX.MsgLoc)
  IF BitTest(Message.Attr,12) THEN CALL MoveDirectory(K&,K,Message.MsgNum)
  TT = 20020
  CALL SendTT

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to ReadMessages, will re-locate
        ' the MsgIDX. record in the .IDX file.
        '
        ' p   .IDX record number
        '
        ' p&  message number to match
        '
        ' p0  returns with the opened .IDX file handle.
        '     if not found, we return 0 and close the file.
        '
        ' Also returns with MsgIDX.
        '
        ' This routine is just like ReGetIDX except we only open
        ' the file for read-only access.
        '
        ' The record can actually disapper if another node did
        ' something with it.
        '
        ' Due to other nodes deleting messages, the .IDX record location
        ' is not guaranteed.  This routine resolves that problem by
        ' starting at our last known location and looking backward into
        ' the file for the record.  No need to look forward because no
        ' routine inserts index records.
        '
        ' By keeping the file opened upon exit, we guarantee that the
        ' the record number is still correct for the calling routine.
        '
        ' This MUST be called after any period in which all the message
        ' files (header, body, and index) have been closed to re-get the
        ' index record number.  Because during that period of 'all closed'
        ' a purge could have been done on another node and everything
        ' would have changed.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB ReGetIDX2 (p,p&,p0)

  p0 = FileOpenR(Form4$(10,BaseIndex + 1))
  FOR K = p TO 1 STEP -1
    CALL FileGetRec(p0,K,12,MsgIDX)
    IF MsgIDX.MsgNum = p& THEN EXIT FOR
  NEXT
  IF K = 0 THEN CALL FileCloseR(p0)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This subroutine, internal to ReadMessages, handles the
        ' process of sending the user into Peer Review and creating
        ' the Peer Review text file for them.
        '
        ' p   .IDX record number
        '
        ' p0  directional flag
        '
        ' p$  message body
        '
        ' Current message must be loaded in Message.
        '
        ' Date last checked for perfection: Aug 1 1993
        '
SUB PRTheMessage (p,p0,p$)

  TT = 20053
  CALL SendTT
  CALL RemoveAMessage(p,Message.MsgNum,p0)
  K = ReadStuff(2,Message.MsgFrom)
  SELECT CASE LEN(RTRIM$(AnyUser.SysopNote))
    CASE 0
         CALL BitSet(AnyUser.Attr,10)
         p$ = Message.MsgFrom + o$(51) + C13$ + C32$ + C13$ + p$
         K1 = 1
         CALL SaveMessageFile(K1,p$)
         AnyUser.SysopNote = Form4$(2,K1) + o$(49)
         K = WriteStuff(2)
         IF Settings.PRMsgStart <> o$(18) _
            THEN p$ = o$(12) + Settings.PRMsgStart : _
                 Message.MsgTo = AnyUser.UserName : _
                 CALL AddAMessage(2,p$,0,0)
    CASE ELSE
         CALL BitSet(AnyUser.Attr,10)
         K = WriteStuff(2)
         CALL SharedWriteEOF(0,-1,RTRIM$(FileNames(39)) + o$(103) + _
                                  LEFT$(AnyUser.SysopNote,2),o$(55) + C13$ + C32$ + C13$ + p$)
  END SELECT
  p0 = 1

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will save the current message's text
        ' to a message file.
        '
        ' p  0 to create messages of MESSAGE.001 to MESSAGE.999.
        '    1 to create messages of MESSAGE.P01 to MESSAGE.P99--using
        '      the first available slot.
        '    returns with the file number the message was stored in.
        '
        ' p$ message body
        '
        ' Message files are of the form: MESSAGE.xxx, where xxx is
        ' pretty much anything--but I've always envisioned it as .001
        ' to .999, except for a few special-use ones.  They are
        ' inserted into a message with the phrase '%%%xxx' (anywhere
        ' in the message, no quotes).  xxx must always be 3 characters
        ' long.
        '
        ' It gives the new message the next higher message number, not
        ' the first available message number.  If there is a .999
        ' message, then it starts back at .001 again (overwriting a
        ' .001 message if you have one).  I've pretty much assumed
        ' this is a rarely used routine--that is, that, on average,
        ' the sysop will only create 1 or 2 new messages per month (at
        ' the rate of one new message per week, this is good for 20
        ' years).
        '
        ' Date last checked for perfection: Sep 15 1992
        '
SUB SaveMessageFile (p,p$)

  SELECT CASE p
    CASE 0
         IF FindF2(RTRIM$(FileNames(39)) + Chars$(42),FFile) _
            THEN DO : CALL IntMax(p,Val2&(FFile.FName)) : _
                 LOOP UNTIL FindF2(Null$,FFile) = 0
         p = p + 1
         K$ = Form4$(3,p)
    CASE 1
         FOR p = 1 TO 99
           K$ = Chars$(80) + Form4$(2,p)
           IF NOT FindF2(RTRIM$(FileNames(39)) + K$,FFile) THEN EXIT FOR
         NEXT
  END SELECT
  CALL SharedWriteEOF(0,-1,RTRIM$(FileNames(39)) + K$,p$)
  TT$ = Lines$(177) + K$ + Short$(304)
  CALL SendTT

END SUB
        '
        '* * * *



        '* * * * * *
        ' This routine handles getting and attaching files to
        ' messages.
        '
        ' TGot is relied upon for what to do:
        '      712  -- BiModem auto-detected.
        '      713  -- Zmodem auto-detected.
        '      Anything else: default protocol
        '
        ' Properly handles attaching files at the console.
        '
        ' Date last checked for perfection: Nov 19 1992
        '
SUB DoFileAttach

  K& = DriveSpc&(Paths$(5))
  SELECT CASE TGot
    CASE 712
         IF Levels(UserSL).SecLevel < Settings.BiSL _
            OR K& < Settings.MinULSpace _
            THEN EXIT SUB
         CALL AdjustProtocol(Chars$(66))
    CASE 713
         IF K& < Settings.MinULSpace THEN EXIT SUB
         CALL AdjustProtocol(Chars$(90))
    CASE ELSE
         TT$ = Short$(107) + RTRIM$(Form$(7908,Lines$(150) + _
               Commas$(K&) + Lines$(149)))
         CALL SendTT
         IF K& < Settings.MinULSpace THEN TT = 148 : _
                                          CALL SendTT : _
                                          CALL Paused : _
                                          EXIT SUB
         SELECT CASE CommPort
           CASE 0
                TT = 10716
                CALL SendTT
                K$ = MakePathName$(Message.MsgNum,Message.MsgBase + 1)
                K1 = 0
                DO
                  TT = 10719
                  K1$ = LineEditTT$(56)
                  IF LEN(K1$) = 0 THEN EXIT DO
                  SELECT CASE FindF2(K1$,FFile)
                    CASE 0 : TT = 166
                    CASE ELSE
                         zz$ = FFile.FName
                         TT = 10811
                         CALL SendTT
                         CALL DirCreate(K$)
                         zz = 0
                         WHILE FindF2(Null$,FFile) <> 0
                            zz$ = zz$ + FFile.FName
                            zz = zz + 1
                         WEND
                         z$ = ParseForPath$(K1$)
                         FOR zz2 = 0 TO zz
                           zz2$ = MID$(zz$,zz2 * 12 + 1,12)
                           CALL CopyFile(0,z$ + zz2$,K$ + zz2$)
                         NEXT
                         TT = 10622
                         K1 = 1
                  END SELECT
                  CALL SendTT
                LOOP UNTIL LEN(K1$) = 0
           CASE ELSE
                CALL AdjustProtocol(User.Protocol)
                K1$ = TT$
                TT$ = Short$(739) + RTRIM$(Form$(7908,MID$(TT$,20,34))) + _
                      Lines$(171)
                CALL SendTT
                TT$ = K1$
         END SELECT
  END SELECT
  IF CommPort > 0 THEN K2$ =  TT$ : _
                       K1$ = TIME$ : _
                       TT$ = Null$ : _
                       CALL ShellDosTT(12) : _
                       CALL FileAppendToLog(MID$(K2$,54,40)) : _
                       K1 = ElapsedTime(K1$,K3) : _
                       CALL AI(6,MakePathName$(Message.MsgNum,Message.MsgBase + 1),K1,0,0,0,0,0&,0&)

END SUB
        '
        '* * * *

'p& message number
'p message area
SUB MoveAllFAs (p&,p)

  TT = 20105
  K0$ = LineEditTT$(40)
  CALL DispCRLF
  IF LEN(K0$) = 0 THEN EXIT SUB
  IF AscRight(K0$) <> 92 THEN K0$ = K0$ + Chars$(92)
  K$ = MakePathName$(p&,p + 1)
  CALL DirCreate(K0$)
  K0 = FindF(K$ + o$(38),FFile)
  IF K0 = 0 THEN EXIT SUB
  K1$ = Null$
  WHILE K0 <> 0
    K1$ = K1$ + FFile.FName + MKL$(FFile.FSize)
    K0 = FindF(Null$,FFile)
  WEND
  DO
    K2$ = RTRIM$(LEFT$(K1$,12))
    TT$ = o$(106) + K2$
    IF DriveSpc&(K0$) <= LongMid(K1$,13) _
       THEN TT$ = TT$ + "  [0;31mNot enough drive space.  Aborted." : _
            CALL SendTT : _
            EXIT DO _
       ELSE CALL SendTT : _
            CALL CopyFile(0,K$ + K2$,K0$ + K2$)
    CALL DispCRLF
    K1$ = MID$(K1$,17)
  LOOP UNTIL LEN(K1$) = 0
  IF LEN(K1$) <> 0 THEN CALL Paused : _
                        EXIT SUB
'based on K2
'  TT$ = ">[1;32mShall we delete the file attached to the message"
  TT$ = ">[1;32mShall we delete the files attached to the message"
  IF GetYNTT THEN CALL DeleteAllFAs(1,p&,p)

'print o$(109)  <- points to the last entry 'compressed...'
'call delay



END SUB

