' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'

'
'Various tiny routines that output or input, or related, something:
'  AnsiTT
'  AutoLogoff
'  BlockToO
'  CommOut
'  ConfirmFile%
'  CopyFile
'  DispTextBlock
'  DispCRLF
'  FileAppendToLog
'  FileGetBlock$
'  FileGetLine$
'  FileGetLineR$
'  GetBlock$
'  GetLine$
'  GetYNTT
'  HangUp
'  MakeFileFromBlock
'  NoCarrier
'  Paused
'  PurgeComIO
'  ShowMeter
'  Wipe






        '* * * * * *
        ' This routine sends text to the screen (if wanted).
        '
        ' This routine is not used from Wipe or DispCRLF because
        ' neither output's anything that can be seen, and both will
        ' soon be assembly language.
        '
        ' Blanking the screen will also turn off the beeps.
        '
        ' TT or TT$ contains the text to display.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB AnsiTT

  IF BitTest(Settings.Toggles2,2) THEN TT = 0 : _
                                       EXIT SUB
  CALL IDTT
  CALL Ansi2(TT$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will tick down 5 seconds before logging the
        ' user off--unless they hit [Enter].
        '
        ' Date last checked for perfection: Sep 21 1992
        '
SUB AutoLogoff

  TT$ = Short$(107)
  FOR K = 5 TO 1 STEP -1
    TT$ = TT$ + Lines$(100) + STR$(K) + Lines$(228 + (K = 1))
  NEXT
  CALL SendTT
  IF TGot < 1 THEN CALL Quote(0)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine reads in a text block, and puts each one of
        ' its lines into the o$() array.
        '
        ' p  block number
        '
        ' Date last checked for perfection: Jun 27 1993
        '
SUB BlockToO (p,p0)

  IF o$(0) = Chars$(p) + Chars$(p0) THEN EXIT SUB
  CALL BlockPrep(p,p0,K,K$)
  K1 = 1
  K2 = StrSrch1(K$,10)
  K3 = 1
  WHILE K2 > 0
    IF Val3(K$,K1) = p0 THEN o$(K3) = MID$(K$,K1 + 2,K2 - K1 - 3) : _
                             K3 = K3 + 1
    K1 = K2 + 1
    K2 = StrSrch2(K2,K$,10)
  WEND
  CALL FileCloseR(K)
  o$(K3) = Null$
  o$(0) = Chars$(p) + Chars$(p0)

END SUB
        '
        '* * * *

SUB BlockPrep(p,p0,K,K$)

  SELECT CASE p
    CASE 0 : K0 = 113
    CASE 1 : K0 = 111
    CASE 2 : K0 = 115
    CASE 3 : K0 = 134
  END SELECT
  K = FileOpenR(FileNames(K0))
  K& = Blocks&(p,p0)
  FOR K1 = p0 + 1 TO 99
    IF Blocks&(p,K1) > 0 THEN EXIT FOR
  NEXT
  IF K1 < 100 THEN K0& = Blocks&(p,K1) _
              ELSE K0& = FileLof&(K,1)
  K$ = SPACE$(K0& - K&)
  CALL FileGetSLoc(K,K&,K$)

END SUB




        '* * * * * *
        ' This routine output's a string to the comm port (and trap
        ' file if it's open).
        '
        ' p$  string to send
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB CommOut (p$)

  CALL BlockOut(CommPort,p$)
  IF CommPort = 0 THEN EXIT SUB    'Don't duplicate to session.log.
  IF BitTest(Settings.Toggles2,8) OR BitTest(User.Attr,6) _
     THEN IF DriveSpc&(FileNames(51)) > Settings.MinSpace _
             THEN CALL FilePutSEnd(Handle(1),p$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine waits for the user to enter a pathname, and
        ' then confirms that it exists.
        '
        ' p$  returns with the pathname if found
        '
        ' returns with 0 if the file was not found, -1 if it was.
        '
        ' A SendTT is done, so just set TT or TT$ and call this.
        '
        ' A CR/LF is displayed no matter the result.
        '
        ' If the file is not found, p$ is not set to zero, but
        ' instead contains the pathname not found.  If [Enter]
        ' alone is hit, then NULL is returned in p$.
        '
        ' Date last checked for perfection: Dec 29 1992
        '
FUNCTION ConfirmFile% (p$)

  p$ = UCASE$(LTRIM$(RTRIM$(LineEditTT$(40))))
  IF LEN(p$) = 0 THEN ConfirmFile% = 0 : _
                      EXIT FUNCTION
  k = FindF(p$,FFile)
  IF k = 0 THEN TT = 195 : _
                CALL SendTT : _
                ConfirmFile% = 0 _
           ELSE CALL DispCRLF : _
                ConfirmFile% = -1

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will copy a file to another file name.
        '
        ' K   0 to just copy the file (the new file gets the same
        '       time/date stamp as the original.
        '     1 to copy the file, deleting the original.
        '     < 0 then K=1 and p = file handle of already opened p$.
        '
        ' p$  is the pathname to copy from.
        '
        ' p0$ is the pathname to copy to.
        '
        ' The second file is always deleted if it already exists.
        '
        ' The second file will still be deleted (if found) even if the
        ' first file isn't found.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB CopyFile (p,p$,p0$)

  KK = 0
  SELECT CASE p
    CASE IS < 0
         K = - p
         p = 1
         IF RTRIM$(p$) = RTRIM$(p0$) THEN CALL FileCloseW(K) : _
                                          EXIT SUB
         CALL KillFile(p0$)
         IF ASC(p$) = ASC(p0$) THEN CALL FileCloseW(K) : _
                                    NAME p$ AS p0$ : _
                                    KK = -1 _
                               ELSE K& = FileLof&(K,1)
    CASE ELSE
         IF RTRIM$(p$) = RTRIM$(p0$) THEN EXIT SUB
         CALL KillFile(p0$)
         IF FindF(p$,FFile) = 0 THEN EXIT SUB
         IF p = 1 AND ASC(p$) = ASC(p0$) THEN K = FileOpenWDA(p$) : _
                                              CALL FileCloseW(K) : _
                                              NAME p$ AS p0$ : _
                                              KK = -1 _
                                         ELSE K& = FFile.FSize : _
                                              K = FileOpenWDA(p$)
  END SELECT
  SELECT CASE KK
    CASE 0
         K1 = FileOpenWDA(p0$)
         SELECT CASE DriveSpc&(p0$)
           CASE IS <= K& : K& = -1
           CASE ELSE
                K1& = 0
                IF K& > 16384 THEN K$ = SPACE$(16384)
                WHILE K& > 16384
                  CALL FileGetSLoc(K,K1&,K$)
                  K1&  = K1& + 16384
                  CALL FilePutSEnd(K1,K$)
                  K& = K& - 16384
                WEND
                IF K& > 0 THEN K$ = SPACE$(K&) : _
                               CALL FileGetSLoc(K,K1&,K$) : _
                               CALL FilePutSEnd(K1,K$)
                CALL SameDate(K,K1)
         END SELECT
         CALL FileCloseR(K)
         CALL FileCloseW(K1)
  END SELECT
  IF FindF2(p0$,FFile) = 0 THEN K& = -2
  SELECT CASE K&
    CASE -1, -2
         CommPort = Settings.CommPort
         CALL HangUp
         CALL CommOut(RTRIM$(Settings.ModemOffHook) + C1310$)
         CALL TTInsertStr2(Short$(154 + (K& = -1)),p$,p0$)
         CALL AnsiTT
         CALL ShellDosTT(2)
  END SELECT
  IF p = 1 THEN CALL KillFile(p$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will read in a block of sequential text, that
        ' was previously stored with a two-digit identifying number in
        ' front of it.
        '
        ' p   which block file to use.
        '
        ' p0  block number to display
        '
        ' p$  valid stop and exit keys
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB DispTextBlock (p,p0,p$)

  IF p0 = 0 THEN EXIT SUB
  SELECT CASE p
    CASE 0 : K0 = 113
    CASE 1 : K0 = 111
    CASE 2 : K0 = 115
    CASE 3 : K0 = 134
  END SELECT
  k = FileOpenR(FileNames(k0))
  k& = Blocks&(p,p0)
  k$ = FileGetLine$(k,k&)
  DO
    IF RIGHT$(k$,2) = Short$(250) THEN k0 = 1 : _
                                       k$ = LEFT$(k$,LEN(k$) - 2) _
                                  ELSE k0 = 0
    TT$ = Short$(152) + p$ + Chars$(124) + MID$(k$,3)
    k$ = FileGetLine$(K,K&)                           'Don't CRLF last line.
    k1 = Val3(k$,1)
    IF k1 = p0 AND k0 = 0 THEN TT$ = TT$ + C1310$
    CALL SendTT
  LOOP UNTIL k1 <> p0 OR TGot > 0 OR NoCarrier
  CALL FileCloseR(k)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will output to comm and screen a CR/LF.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB DispCRLF

  CALL CommOut(C1310$)
  CALL Ansi2(C1310$)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine appends the contents of a file to the log file,
        ' and then deletes it.
        '
        ' p$ is the file to append.
        '
        ' Date last checked for perfection: Sep 22 1992
        '
SUB FileAppendToLog (p$)

  IF FindF(p$,FFile) = 0 THEN EXIT SUB
  k0 = FileIndex
  FileIndex = 1
  k = FileOpenR(p$)
  k& = 0
  DO
    TT$ = FileGetLine$(k,k&)
    CALL LogTT
  LOOP UNTIL k& = -1
  CALL FileCloseR(k)
  CALL KillFile(p$)
  FileIndex = k0

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine gets the next 8192 block of data from a file.
        '
        ' p   file handle
        '
        ' p&  starting point (updated upon exit)
        '
        ' p0& file's size
        '
        ' Returns p& = p0& when we are at then end of the file.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION FileGetBlock$ (p,p&,p0&)

  IF p0& <= p& THEN p0& = p& : _
                    FileGetBlock$ = Null$ : _
                    EXIT FUNCTION
  SELECT CASE p& + 8192
    CASE IS > p0&
         k$ = SPACE$(p0& - p&)
         CALL FileGetSLoc(p,p&,k$)
         p& = p0&
         FileGetBlock$ = k$
    CASE ELSE
         k$ = SPACE$(8192)
         CALL FileGetSLoc(p,p&,k$)
         '
         ' First try to find last CR/LF.  Standard text.
         ' Then try ASCII 27.  Optimized ANSI's.
         ' Then try a space.  All text.
         ' Then give up and use it all.  Alien text.
         '
         k = StrSrchR(k$,10)
         IF k = 0 THEN k = StrSrchR(k$,27) : _
                       IF k = 0 THEN k = StrSrchR(k$,32) : _
                                     IF k = 0 THEN k = p0& - p&
         p& = p& + k
         FileGetBlock$ = LEFT$(k$,k)
  END SELECT

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine retrieves the next line of 'sequential' text
        ' from an already opened file.
        '
        ' p   file handle to read from.
        '     If < 0 then we use a 512 buffer instead of a 128 byte
        '     buffer.  (512 is the maximum BLKS file line allowed).
        '
        ' p&  location to start reading from.  p& is increased by the
        '     size of the returned string + 2.  -1 is returned at EOF.
        '
        ' If the retrieved 128 byte buffer has no CR/LF, then returns
        ' with all 128 bytes read.
        '
        ' A line with only a CR/LF on it is returned as a null.
        '
        ' The CR/LF is not included in the returned text.
        '
        ' At EOF, returned text may or may not contain text, but p&
        ' will be -1.
        '
        ' The last line read may or may not contain data (assume it
        ' does).
        '
        ' If ever looking to improve this routine, the following tests
        ' must be done: blank line handling, no CR on line handling, and
        ' only CR on line (or LF).
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION FileGetLine$ (p,p&)

  IF p > 0 THEN K0 = 128 _
           ELSE p = - p : _
                K0 = 512
  IF p& >= FileLof&(p,1) - 2 OR p& < 0 THEN FileGetLine$ = Null$ : _
                                            p& = -1 : _
                                            EXIT FUNCTION
  K$ = SPACE$(K0)
  DO
    CALL FileGetSLoc(p,p&,k$)
    k = StrSrch1(k$,13)
    WHILE K > 0 AND AscMid(K$,k + 1) <> 10
      K = StrSrch2(K,K$,13)
    WEND
    IF k = 0 THEN K$ = K$ + K$
  LOOP UNTIL k <> 0 OR LEN(K$) = 8192
  k$ = LEFT$(k$,k - 1)
  p& = p& + k + 1
  IF p& >= FileLof&(p,1) - 2 THEN p& = -1
  FileGetLine$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine retrieves the next line of 'sequential' text
        ' from an already opened file.  However, it does it from the
        ' bottom up.
        '
        ' p   file number to read from.
        '
        ' p&  location to start reading from.  p& is decreased by the
        '     size of the returned string + 2.  -1 is returned whne
        '     the start of the file (first line) is reached.
        '
        ' The CR/LF is not included in the returned text.
        '
        ' Do a p& = FileLof&(handle%,1) before calling this the first
        ' time.
        '
        ' If the very first line of the file is also just a CR/LF, it
        ' will be ignored.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION FileGetLineR$ (p,p&)

  IF p& = FileLof&(p,1) THEN p& = p& - 2
  IF p& < 3 THEN FileGetLineR$ = Null$ : _
                 p& = -1 : _
                 EXIT FUNCTION
  IF p& > 127 THEN k = 128 : _
                   p& = p& - 128 _
              ELSE k = p& : _
                   p& = 0
  k$ = SPACE$(k)
  CALL FileGetSLoc(p,p&,k$)
  k = StrSrchR(k$,13)
  IF k > 0 THEN k$ = MID$(k$,k + 2) : _
                p& = p& + k - 1
  IF p& < 3 THEN p& = -1
  FileGetLineR$ = k$

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine displays a progress graph and percentage
        ' report.
        '
        ' p&  is our total and the current partial (the amount of
        '     total p& that is done).
        '     When first run: p& less than zero to reset the gauge.
        '
        ' Don't use Short$() here.
        '
        ' Date last checked for perfection: Jan 10 1993
        '
SUB ShowMeter (p&)

  SELECT CASE p&
    CASE 0
    CASE IS < 0
         Gauge.NextStep = 0
         Gauge.StepSize = (- p&) \ 20
         IF Gauge.StepSize = 0 THEN Gauge.StepSize = 1
         Gauge.NextStepNum = Gauge.StepSize
    CASE IS >= NextStepNum
         TGot = -1
         WHILE Gauge.NextStep < 20 AND p& >= Gauge.NextStepNum AND TGot = -1
           Gauge.NextStep = Gauge.NextStep + 1
           Gauge.NextStepNum = Gauge.NextStepNum + Gauge.StepSize
           k0 = Gauge.NextStep \ 2
           TT$ = "|~|[s[1;31;41m" + STRING$(k0,219)
           IF k0 * 2 <> Gauge.NextStep THEN TT$ = TT$ + Chars$(221) : _
                                            k0 = k0 + 1
           TT$ = TT$ + STRING$(10 - k0,32) + "[40m (" + _
                 IntToStr$((Gauge.NextStep * 100) \ 20) + "%) [u"
           CALL SendTT
           IF TGot > 0 THEN Kz = TGot : _
                            TT$ = "[u" : _
                            CALL SendTT : _
                            TGot = Kz
         WEND
  END SELECT

END SUB



        '* * * * * *
        ' This routine will read in, and return with, a block of text
        ' from BLOCK.TXT.
        '
        ' p  block number to load
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION GetBlock$ (p,p0)

  CALL BlockPrep(p,p0,K,K$)
  K1 = 0
  K2 = StrSrch1(K$,10)
  K0$ = Null$
  WHILE K2 > 0
    IF Val3(K$,K1 + 1) = p0 THEN K0$ = K0$ + MID$(K$,K1 + 3,K2 - K1 - 4)
    K1 = K2
    K2 = StrSrch2(K2,K$,10)
  WEND
  CALL FileCloseR(K)
  GetBlock$ = K0$

END FUNCTION
        '
        '* * * *



        '* * * * * *
        ' This routine will get a Y, N, or CR/LF.  Good for all
        ' Y/N questions which default to No.
        '
        ' TT/TT$ will be displayed first, and a '? [y/N]' is added.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION GetYNTT%

  CALL IDTT
  TT$ = TT$ + Lines$(8)
  CALL SendTT
  k$ = Lines$(9) + C13$
  IF RTRIM$(User.UserName) = Null$ THEN k$ = k$ + Chars$(3)
  CALL TGet2(k$)
  CALL Wipe(6)
  TT = 11 + (TGot = 1)
  GetYNTT = (TGot = 1)
  CALL SendTT

END FUNCTION
        '
        '* * * *



        '* * * * * *
        ' This routine will hang up the phone.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB HangUp

  TT = 0
  TT$ = Null$
  CommPort = Settings.CommPort
  IF NoCarrier THEN CALL PurgeComIO(CommPort) : _
                    EXIT SUB
  DO
    k = FosIntAX(CommPort,&H600)                  'Lower DTR.
    CALL Delay
    k = FosIntAX(CommPort,&H601)                  'Raise DTR.
    CALL Delay
    IF CommPort = 0 OR BitTest(Settings.Toggles2,15) THEN EXIT DO
  LOOP UNTIL NoCarrier
  CALL PurgeComIO(CommPort)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will create a file containing everything in
        ' a text block of data.
        '
        ' p   file handle
        '
        ' p1  block number
        '
        ' The desired file must be opened before calling this.
        '
        ' Date last checked for perfection: Dec 29 1992
        '
SUB MakeFileFromBlock (p,p0,p1)

  CALL BlockPrep(p0,p1,K,K$)
  K1 = 0
  K2 = StrSrch1(K$,10)
  WHILE K2 > 0
    IF Val3(K$,K1 + 1) = p1 THEN CALL FilePutSEnd(p,MID$(K$,K1 + 3,K2 - K1 - 2))
    K1 = K2
    K2 = StrSrch2(K2,K$,10)
  WEND
  CALL FileCloseR(K)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will signal Yea or Nay as to the status of the
        ' carrier.
        '
        ' returns  -1 if no carrier detected
        '           0 if carrier present
        '
        ' Remember, this is 'NO Carrier'--true when no carrier is
        ' detected.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
FUNCTION NoCarrier%

  IF BitTest(FosIntAX(CommPort,&H300),8) OR (CommPort = 0) _
     OR BitTest(Settings.Toggles2,15) _
     THEN NoCarrier = 0 _
     ELSE NoCarrier = -1

END FUNCTION
        '
        '* * * *




        '* * * * * *
        ' This routine will/will not display 'Paused' and wait for
        ' either the spacebar or enter key.
        '
        ' Since this is always called after something is displayed,
        ' it is assumed that TGot$ comes in null, if not null, the
        ' routine is skipped.
        '
        ' If the output ends in col 80, do SendTT before this with no
        ' CR/LF.
        '
        ' Date last checked for perfection: Sep 21 1992
        '
SUB Paused

  IF LEN(TGot$) = 0 THEN TT = 3 : _
                         CALL SendTT : _
                         IF LEN(TGot$) = 0 THEN CALL TGet(C32$ + C13$)
END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will purge the fossil and modem I/O buffers.
        '
        ' p  Comm Port
        '
        ' It relies on the fossil to purge the modem buffers.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB PurgeComIO (p)

  k = FosIntAX(p,&HA00)                      'Purge the fossil's input buffer.
  k = FosIntAX(p,&H900)                      'Purge the fossil's output buffer.
  DO : k = FosIntAX(p,&H2000)                'Purge the modem's input buffer.
  LOOP UNTIL k < 1

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine will 'delete' a number of characters from the
        ' screen.
        '
        ' p  number of characters to delete.
        '
        ' In the future, try just a C8$ (destructive backspace).  Test
        ' with various comm programs to see what's needed/etc.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB Wipe (p)

  k$ = C8$ + C32$ + C8$
  FOR k = 1 TO p
    CALL CommOut(k$)
    CALL Ansi2(k$)
  NEXT

END SUB
        '
        '* * * *


SUB Ansi2 (p$)

  '
  ' We draw the text normally if not in GIP graphics, or if the user is in GIP
  ' graphics but the screen mode is outside our range.
  '
  SELECT CASE GInUse
    CASE 0
         IF BitTest(Settings.Toggles2,1) THEN CALL BiosAnsi(p$) _
                                         ELSE CALL Ansi(p$)
    CASE ELSE
         '
         ' Draw graphics text.
         '
         K$ = p$
         WHILE LEN(K$) > 0
           K = ASC(K$)
           IF K = 10 THEN K = -1
           IF K = 13 THEN GHoriz = 0 : _
                          GVert = GVert + 8 : _
                          K = -1
           IF K >= 0 THEN CALL ColorText(GHoriz,GVert,GColor,K) : _
                          GHoriz = GHoriz + 8
           K$ = MID$(K$,2)
         WEND
  END SELECT
  IF CommPort <> 0 THEN EXIT SUB
  IF BitTest(Settings.Toggles2,8) OR BitTest(User.Attr,6) _
     THEN IF DriveSpc&(FileNames(51)) > Settings.MinSpace _
             THEN CALL FilePutSEnd(Handle(1),p$)


END SUB



'Parse the information from NodeIndex. into o$().
'returns o$(1) first part (hub/host/nothing/etc.)
'        o$(2) node/net/zone number
'        o$(3) BBS's name
'        o$(4) Location (city/state/etc.)
'        o$(5) Sysop's name
'        o$(6) BBS's phone number
'        o$(7) remaining attributes
'        o$(8) net address in STRING*6 form
'        o$(9) database from whence it came.
SUB ParseNodeIndex

  FOR K1 = 1 TO 7
    o$(K1) = Null$
  NEXT
  K$ = SPACE$(126)
  K = FileOpenR(FileNames(106))
  CALL FileGetSLoc(K,126& * ASC(NodeIndex.NodeList) - 126,K$)
  o$(9) = RTRIM$(MID$(K$,65,60))
  K$ = LEFT$(K$,64)
  IF NOT FindF2(K$,FFile) THEN CALL FileCloseR(K) : _
                               EXIT SUB
  K0 = FileOpenR(ParseForPath$(K$) + FFile.FName)
  K$ = FileGetLine$(K0,NodeIndex.Location)
  CALL FileCloseR(K0)
  CALL FileCloseR(K)
  K = 0
  K0 = StrSrch1(K$,44)
  FOR K1 = 1 TO 6
    K0$ = MID$(K$,K + 1,K0 - K - 1)
    CALL ReplaceCharacters(K0$,95,Null$,32)
    o$(K1) = K0$
    K = K0
    K0 = StrSrch2(K0,K$,44)
    IF K0 = 0 THEN EXIT FOR
  NEXT
  IF K0 > 0 THEN o$(7) = MID$(K$,K0 + 1)
  o$(8) = NodeIndex.Addr
  o$(1) = UCASE$(RTRIM$(LTRIM$(o$(1))))

END SUB


FUNCTION GetDate%

  K$ = LineEditTT$(9)
  IF LEN(K$) = 0 THEN GetDate% = 0 : _
                      EXIT FUNCTION
  k = StrSrch1(k$,47)
  k0 = StrSrch2(k,k$,47)
  IF k0 = 0 OR LEN(K$) <> 8 THEN TT = 57 : _
                                 CALL SendTT : _
                                 GetDate% = 0 : _
                                 EXIT FUNCTION
  GetDate% = DateToInt(K$)

END FUNCTION



'p = commport
'p& = baud rate
SUB InitFossil (p,p&)

  IF p = 0 THEN EXIT SUB
  TT = 10899
  CALL AnsiTT
  '
  'Make sure a fossil is installed, exit with message if not, otherwise it
  'will be turned on.
  '
  IF FosIntAX(p,&H1C00) <> &H1954 _
     THEN TT$ = C1310$ + C1310$ + Short$(700) + C1310$ : _
          CALL AnsiTT : _
          CALL Delay : _
          TT$ = Null$ : _
          CALL ShellDosTT(2)
  '
  ' Re-init fossil.
  '
  SELECT CASE p&
    CASE 38400& : K0 = 35               '001 00011
    CASE 19200  : K0 = 3                '000 00011
    CASE 9600   : K0 = 227              '111 00011
    CASE 1200   : K0 = 131              '100 00011
    CASE ELSE   : K0 = 163              '101 00011
  END SELECT
  K = FosIntAX(p,K0)

END SUB



'Use this when you want 'exclusive mode'--that is, you don't want it to have
'been opened previously, and you don't want anyone else opening it until
'you're done with it.
'
'If the file is already in use, it loops in the FileOpen call until it can
'open it.
'Once it's opened, it allows this program to read/write to the file, but
'disallows any other process (program/task) to open it (the other programs
'will either loop waiting or ask for help from a person depending on how
'they're written).
'
'The software may appear to 'lock up' under two circumstances: while the
'routine is waiting to access a file that is opened by another process.
'Any other lock-up's and it's a programming bug, and while another process
'is waiting to access this file.
'
FUNCTION FileOpenWDA% (p$)

  K = FileOpen(p$,146)
  IF K = -1 THEN SYSTEM       'a problem opening the file.
  FileOpenWDA% = K

END FUNCTION




'Use this when you want to write to a file either at the file's end or
'updating a record.
'
'If the file is already in use in a 'deny write' mode, it loops in the
'FileOpen call until it can open it.
'
'Once it's opened, it allows this program and any other processes to
'read/write to the file, but disallows 'WDA' until it's done.
'
'The software may appear to 'lock up' under one circumstance: while the
'routine is waiting to access a file that is opened for 'deny write' by
'another process.
'Any other lock-up's and it's a programming bug.
'
FUNCTION FileOpenW% (p$)

  K = FileOpen(p$,130)
  IF K = -1 THEN SYSTEM      'a problem opening the file.
  FileOpenW% = K

END FUNCTION

SUB FileCloseW (p)

  IF p = 0 THEN SYSTEM      'something went wrong.
  CALL FileClose(p)

END SUB



'Use this when you want to 'just read' from a file.
'
'If the file is already in use in a 'deny read' mode, it loops in the
'FileOpen call until it can open it.
'
'Once it's opened, it allows this program and any other processes to
'read to the file, and other processes to write to the file, but disallows
''WDA' until it's done.
'
'The software may appear to 'lock up' under one circumstance: while the
'routine is waiting to access a file that is opened for 'deny read' by
'another process.
'Any other lock-up's and it's a programming bug.  Such as if I open a
'file with FileOpenR and then try to write to it.
'
FUNCTION FileOpenR% (p$)

  K = FileOpen(p$,128)
  IF K = -1 THEN SYSTEM    'a problem opening the file.
  FileOpenR% = K

END FUNCTION

SUB FileCloseR (p)

  IF p = 0 THEN SYSTEM    'something went wrong.
  CALL FileClose(p)

END SUB

'k = 1 for zip
'k = 2 for arj
'k = 3 for lzh
'k = 4 for arc
'k = 5 for zoo
'k = 6 for gif
'k = 7 for exe
FUNCTION FileType% (p$)

  IF NOT FindF2(p$,FFile) THEN FileType% = 0 : _
                               EXIT FUNCTION
  K$ = SPACE$(5)
  K = FileOpenR(p$)
  CALL FileGetSLoc(K,0&,K$)
  CALL FileCloseR(K)
  K = 0
  IF LEFT$(K$,4) = Short$(572) + Chars$(3) + Chars$(4) THEN K = 1
  IF K = 0 AND LEFT$(K$,2) = Short$(456) THEN K = 2
  IF K = 0 AND MID$(K$,3,3) = Short$(457) THEN K = 3
  IF K = 0 AND ASC(K$) = 26 THEN K = 4
  IF K = 0 AND ASC(K$) = 90 THEN K = 5
  IF K = 0 AND LEFT$(K$,3) = Short$(458) THEN K = 6
  IF K = 0 AND LEFT$(K$,2) = Short$(459) THEN K = 7


'below works fine, but the .exe's have a different structure than normal
'archives, so I need to study it more.
'  SELECT CASE K
'    CASE 7
'         K$ = SPACE$(64)
'         K = FileOpenR(p$)
'         CALL FileGetSLoc(K,0&,K$)
'         CALL FileCloseR(K)
'         IF StrSrch(1,K$,"RJSX") > 0 THEN K = 3
'         IF StrSrch(1,K$,"LHA") > 0 THEN K = 2
'         IF StrSrch(1,K$,"PKWARE") > 0 AND StrSrch(1,K$,"PKLITE") = 0 THEN K = 1
'  END SELECT
  FileType% = K

END FUNCTION

'p  handle of already-opened pathname or zero if should open it here.
'p$ pathname to use.
'p& starting location (1..n)
'p0& length of to-remove text (1..n)
SUB CutOut (p,p$,p&,p0&)

  IF p0& < 1 THEN EXIT SUB
  K = p
  IF p = 0 THEN K = FileOpenWDA(p$)
  K1& = FileLof&(K,1)
  K& = p& - 1
  K0& = K& + p0&
  IF K1& - K0& > 16384 THEN K$ = SPACE$(16384)
  WHILE K1& - K0& > 16384
    CALL FileGetSLoc(K,K0&,K$)
    CALL FilePutSLoc(K,K&,K$)
    K0& = K0& + 16384
    K& = K& + 16384
  WEND
  K0 = K1& - K0&
  IF K0 > 0 THEN K$ = SPACE$(K0) : _
                 CALL FileGetSLoc(K,K0&,K$) : _
                 CALL FilePutSLoc(K,K&,K$)
  CALL FilePutLoc(K,K& + K0,0,K0)
  IF p = 0 THEN CALL FileCloseW(K)

END SUB



'p  handle of already-opened pathname or zero if should open it here.
'p$ pathname to use.
'p& insert before this location (1..n)
'p0$ text to insert
SUB CutIn (p,p$,p&,p0$)

  K0 = LEN(p0$)
  IF K0 = 0 THEN EXIT SUB
  K = p
  IF p = 0 THEN K = FileOpenWDA(p$)
  K& = p&
  K1& = FileLof&(K,1)
  CALL FilePutSEnd(K,p0$)                  'Extend the file.
  IF K1& - K& > 16384 THEN K$ = SPACE$(16384)
  WHILE K1& - K& > 16384
    K1& = K1& - 16384
    CALL FileGetSLoc(K,K1&,K$)
    CALL FilePutSLoc(K,K1& + K0,K$)
  WEND
  K1 = K1& - K&
  IF K1 > 0 THEN K$ = SPACE$(K1) : _
                 CALL FileGetSLoc(K,K& - 1,K$) : _
                 CALL FilePutSLoc(K,K& + K0 - 1,K$)
  CALL FilePutSLoc(K,K& - 1,p0$)
  IF p = 0 THEN CALL FileCloseW(K)

END SUB





FUNCTION WriteStuff% (p)

  K = 0
  SELECT CASE p
    CASE 1
         K0 = FileOpenW(FileNames(1))
         K1 = BiSearch(5,0,User.UserName)
         IF K1 > 0 THEN CALL FilePutRec(K0,K1,384,User) : _
                        K = -1
         CALL FileCloseW(K0)
    CASE 2
         K0 = FileOpenW(FileNames(1))
         K1 = BiSearch(5,0,AnyUser.UserName)
         IF K1 > 0 THEN CALL FilePutRec(K0,K1,384,AnyUser) : _
                        K = -1
         CALL FileCloseW(K0)
    CASE 3
         K0 = FileOpenW(FileNames(75))
         CALL FilePutLoc(K0,0&,901,Settings)
         CALL FileCloseW(K0)
    CASE 4
         K0 = FileOpenW(FileNames(3))
         K1 = BiSearch(5,0,User.UserName)
         IF K1 > 0 _
            THEN CALL FilePutSLoc(K0,1& * (K1 - 1) * LEN(UserMsgInfo$),UserMsgInfo$) : _
                 K = -1
         CALL FileCloseW(K0)
   END SELECT
   WriteStuff% = K

END FUNCTION

'uses useridx which tells us where to write.
SUB WriteStuff2

  K0 = FileOpenW(FileNames(1))
  CALL FilePutRec(K0,UserIDX.RecNum,384,AnyUser)
  CALL FileCloseW(K0)

END SUB

'returns -1 if OK, 0 if failed.
FUNCTION ReadStuff% (p,p$)

  K = 0
  SELECT CASE p
    CASE 1
         K0 = FileOpenR(FileNames(1))
         IF LEN(p$) = 0 THEN K1 = 1 _
                        ELSE K1 = BiSearch(5,0,Form$(3001,p$))
         IF K1 > 0 THEN CALL FileGetRec(K0,K1,384,User) : _
                        K = -1
         CALL FileCloseR(K0)
    CASE 2
         K0 = FileOpenR(FileNames(1))
         IF LEN(p$) = 0 THEN K1 = 1 _
                        ELSE K1 = BiSearch(5,0,Form$(3001,p$))
         IF K1 > 0 THEN CALL FileGetRec(K0,K1,384,AnyUser) : _
                        K = -1
         CALL FileCloseR(K0)
    CASE 4
         K0 = FileOpenR(FileNames(3))
         IF LEN(p$) = 0 THEN K1 = 1 _
                        ELSE K1 = BiSearch(5,0,Form$(3001,p$))
         IF K1 > 0 _
            THEN CALL FileGetSLoc(K0,1& * (K1 - 1) * LEN(UserMsgInfo$),UserMsgInfo$) : _
                 K = -1
         CALL FileCloseR(K0)
  END SELECT
  ReadStuff% = K

END FUNCTION



        '* * * * * *
        ' This routine writes to the end of a file, provided no other
        ' file is doing so.
        '
        ' p   FileNames() array location.
        '
        ' p0  .xxx based extension to use (if not 0 or negative)
        '      0 for no .xxx addition.
        '     -1 for no .xxx, but also don't add a CR/LF.
        '
        ' p$  Use this if p is 0.
        '
        ' p0$ text to put at end of the file.
        '
        ' Date last checked for perfection: Sep 22 1992
        '
SUB SharedWriteEOF (p,p0,p$,p0$)

  IF p0 > 0 THEN k$ = Form4$(3,p0) _
            ELSE k$ = Null$
  IF p > 0 THEN k$ = RTRIM$(FileNames(p)) + k$ _
           ELSE k$ = p$
  k = FileOpenW(k$)
  IF p0 >= 0 THEN k$ = C1310$ _
             ELSE k$ = Null$
  CALL FilePutSEnd(k,p0$ + k$)
  CALL FileCloseW(k)

END SUB
        '
        '* * * *


'record what the current user is doing in the NODEINFO.USE file.
'This file is (for now) 30 char user name + 1 char what doing.
'p = 0 for unknown
'    1 for transfering files
'    2 for in a door
'    3 entering mail
'    4 reading mail
'    5 chatting with sysop
'    6 in internode chat
'    -1 to wipe the entry (logout).
SUB WhatDoing (p)

  IF Settings.Node = 0 THEN EXIT SUB
  IF p = -1 THEN K$ = SPACE$(60) + C0$ + C0$ _
            ELSE K$ = User.UserName + User.CityState + Chars$(p) + Chars$(CommPort)
  K = FileOpenW(FileNames(7))
  CALL FilePutSLoc(K,(Settings.Node - 1) * 62,K$)
  CALL FileCloseW(K)

END SUB


'read the file area info for p into FileArea.
SUB FileAreaInfo (p)

  K = FileOpenR(FileNames(20))
  IF p < 1 OR p > FileLof&(K,188) THEN CALL FileCloseR(K) : _
                                       EXIT SUB
  CALL FileGetRec(K,p,188,FileArea)
  K$ = RTRIM$(FileArea.Path)
  IF AscRight(K$) <> 92 THEN K$ = K$ + Chars$(92) : _
                             FileArea.Path = K$
  IF FileArea.TemplateC < 1 THEN FileArea.TemplateC = 1
  IF FileArea.TemplateP < 1 THEN FileArea.TemplateP = 1
  CALL FileCloseR(K)

END SUB

'p0 = get what
FUNCTION FileAreaInfo2% (p,p0)

'1  DLSL       AS INTEGER   'use FileAreaI
'2  ULSL       AS INTEGER
'3  ScanSL     AS INTEGER   'use FileAreaI
'4  StartTime  AS INTEGER
'5  EndTime    AS INTEGER
'6  BufferSize AS INTEGER
'7  Attr       AS INTEGER   'use FileAreaI
'8  TemplateC  AS INTEGER
'9  TemplateP  AS INTEGER

  K0 = 0
  K = FileOpenR(FileNames(20))
'  k& = (p - 1) * 188& + (p0 - 1) * 2
  k& = p * 188& - 188 + p0 * 2 - 2
  IF p > 0 AND p <= FileLof&(K,188) _
     THEN CALL FileGetLoc(K,k&,2,K0) : _
          FileAreaI(p).HiFilePtr = FileArea.HiFilePtr
  CALL FileCloseR(K)
  IF p0 = 8 AND K0 < 1 THEN K0 = 1
  IF p0 = 9 AND K0 < 1 THEN K0 = 1
  FileAreaInfo2% = K0

END FUNCTION


'p0 = get what
FUNCTION FileAreaInfo3$ (p,p0)

  SELECT CASE p0
    CASE 1 : K0 = 30   'file-op
             K1 = 166
    CASE 2 : K0 = 64   'path
             K1 = 136
    CASE 3, 4 : K0 = 72   'title
                K1 = 72
    CASE ELSE : K0 = 1
                K1 = 0
  END SELECT
  K$ = SPACE$(K0)
  K = FileOpenR(FileNames(20))
'  k& = (p - 1) * 188& + 1 + 21 + K1
  k& = p * 188& - K1
  IF p > 0 AND p <= FileLof&(K,188) THEN CALL FileGetSLoc(K,k&,K$)
  CALL FileCloseR(K)
  IF p0 = 2 OR p0 = 4 THEN K$ = RTRIM$(K$)
  IF p0 = 2 THEN IF AscRight(K$) <> 92 THEN K$ = K$ + Chars$(92)
  FileAreaInfo3$ = k$

END FUNCTION



SUB UpdateHiFilePtr (p,p&)

  K = FileOpenW(FileNames(20))
  IF p > 0 AND p <= FileLof&(K,188) _
     THEN CALL FilePutLoc(K,p * 188& - 170,4,p&) : _
          FileAreaI(p).HiFilePtr = p&
  CALL FileCloseW(K)

END SUB





'p = msg area (1..n)
'p0 = get what
FUNCTION MsgAreaInfo2% (p,p0)

'1  PostSL     AS INTEGER
'2  ReadSL     AS INTEGER

  K0 = 0
  K = FileOpenR(FileNames(38))
  k& = p * 108& - 108 + p0 * 2 - 2
  IF p > 0 AND p <= FileLof&(K,108) THEN CALL FileGetLoc(K,k&,2,K0)
  CALL FileCloseR(K)
  MsgAreaInfo2% = K0

END FUNCTION

'p = msg area (1..n)
'p0 = get what
FUNCTION MsgAreaInfo3$ (p,p0)

  SELECT CASE p0
    CASE 1 : K0 = 30   'msg-op
             K1 = 90
    CASE 2 : K0 = 60   'title
             K1 = 60
    CASE ELSE : K0 = 1
                K1 = 0
  END SELECT
  K$ = SPACE$(K0)
  K = FileOpenR(FileNames(38))
  k& = p * 108& - K1
  IF p > 0 AND p <= FileLof&(K,108) THEN CALL FileGetSLoc(K,k&,K$)
  CALL FileCloseR(K)
  IF p0 = 2 THEN K$ = RTRIM$(K$)
  MsgAreaInfo3$ = k$

END FUNCTION



'note: depending on what how a file is being used, there are a variety of
'ways the software may appear to lock up:
'  During a share violation  (open WDA, then try open R or W and you get it).
'  Waiting for access (open R or W or WDA and try open WDA and you get it).
'  Waiting for a record/spot to be unlocked by another process.
'In all cases it's important to remember that the software is just waiting.


'get the latest value from settings.001, then update that file, then change
'the settings file for our node as well.
'by reading in from .001--all nodes get updated in their own time.
'(when we write out Settings.)
SUB IncreaseHiFilePtr

  K = FileOpenW(ParseForPath$(FileNames(75)) + Short$(112))
  CALL FileGetLoc(K,98&,4,K1&)
  Settings.HiFilePtr = K1& + 1
  CALL FilePutLoc(K,98&,4,Settings.HiFilePtr)
  CALL FileCloseW(K)

END SUB

'get the latest value from settings.001, then update that file, then change
'the settings file for our node as well.
'by reading in from .001--all nodes get updated in their own time.
'(when we write out Settings.)
SUB IncreaseCallerNum

  K = FileOpenW(ParseForPath$(FileNames(75)) + Short$(112))
  CALL FileGetLoc(K,278&,4,K1&)
  Settings.CallerNumber = K1& + 1
  CALL FilePutLoc(K,278&,4,Settings.CallerNumber)
  CALL FileCloseW(K)

END SUB

'""
'p -1 if should compare User1 and User2 first.
'SUB UpdateUserRec (p)
'
'K$ = Null$
'FOR K = 1 TO 26
'  SELECT CASE K
'    CASE 1  : K0 = (User1.UserName      = User2.UserName)
'    CASE 2  : K0 = (User1.Password      = User2.Password)
'    CASE 3  : K0 = (User1.CityState     = User2.CityState)
'    CASE 4  : K0 = (User1.HomePhone     = User2.HomePhone)
'    CASE 5  : K0 = (User1.BBSPhone      = User2.BBSPhone)
'    CASE 6  : K0 = (User1.BirthDate     = User2.BirthDate)
'    CASE 7  : K0 = (User1.SecLevel      = User2.SecLevel)
'    CASE 8  : K0 = (User1.FirstCall     = User2.FirstCall)
'    CASE 9  : K0 = (User1.Attr          = User2.Attr)
'    CASE 10 : K0 = (User1.Toggles       = User2.Toggles)
'    CASE 12 : K0 = (User1.Protocol      = User2.Protocol)
'    CASE 13 : K0 = (User1.Votes         = User2.Votes)
'    CASE 14 : K0 = (User1.SubsStart     = User2.SubsStart)
'    CASE 15 : K0 = (User1.Language      = User2.Language)
'    CASE 16 : K0 = (User1.Monies        = User2.Monies)
'    CASE 17 : K0 = (User1.LastCallerNum = User2.LastCallerNum)
'    CASE 18 : K0 = (User1.LastDateOn    = User2.LastDateOn)
'    CASE 19 : K0 = (User1.PswdChange    = User2.PswdChange)
'    CASE 20 : K0 = (User1.AlterDate     = User2.AlterDate)
'    CASE 21 : K0 = (User1.Toggles2      = User2.Toggles2)
'    CASE 22 : K0 = (User1.PRStuff       = User2.PRStuff)
'    CASE 23 : K0 = (User1.Connect       = User2.Connect)
'    CASE 24 : K0 = (User1.HiFilePtr     = User2.HiFilePtr)
'    CASE 25 : K0 = (User1.HighestPtr    = User2.HighestPtr)
'    CASE 26 : K0 = (User1.PagedSysop    = User2.PagedSysop)
'    CASE 27 : K0 = (User1.Logons        = User2.Logons)
'    CASE 28 : K0 = (User1.Attempts      = User2.Attempts)
'    CASE 29 : K0 = (User1.MinCredits    = User2.MinCredits)
'    CASE 30 : K0 = (User1.MinMegs       = User2.MinMegs)
'    CASE 31 : K0 = (User1.MsgsPosted    = User2.MsgsPosted)
'    CASE 32 : K0 = (User1.EMsgsPosted   = User2.EMsgsPosted)
'    CASE 33 : K0 = (User1.FMsgsPosted   = User2.FMsgsPosted)
'    CASE 34 : K0 = (User1.NetMailSent   = User2.NetMailSent)
'    CASE 35 : K0 = (User1.NetMailRcvd   = User2.NetMailRcvd)
'    CASE 36 : K0 = (User1.Elapsed       = User2.Elapsed)
'    CASE 37 : K0 = (User1.Dnlds         = User2.Dnlds)
'    CASE 38 : K0 = (User1.DLBytes       = User2.DLBytes)
'    CASE 39 : K0 = (User1.MinsDLing     = User2.MinsDLing)
'    CASE 40 : K0 = (User1.BadDLs        = User2.BadDLs)
'    CASE 41 : K0 = (User1.Uplds         = User2.Uplds)
'    CASE 42 : K0 = (User1.ULBytes       = User2.ULBytes)
'    CASE 43 : K0 = (User1.MinsULing     = User2.MinsULing)
'    CASE 44 : K0 = (User1.BadULs        = User2.BadULs)
'    CASE 45 : K0 = (User1.Doors         = User2.Doors)
'    CASE 46 : K0 = (User1.Group         = User2.Group)
'    CASE 47 : K0 = (User1.SysopNote     = User2.SysopNote)
'    CASE 48 : K0 = (User1.UserNote      = User2.UserNote)
'end select
'next
'
'
'logic:
'load User1
'alter User. in mem.
'load User2 (leave file open)
'if user1 <> user2 then compare with User.--if not a field we modified,then
'use user2's, else use User's. (most recent mod).
'not User--AnyUser! (bah!, and User!)--really do need an LSET User=A$
'actually, that's more real problems: since it means keeping a "first User."
'duplicate throughout the user's session --although not hard if user is not
'the sysop!
'
'
'END SUB
