; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routines returns a semi-unique number for each string it's used upon.
; It's used with names to speed up access for mail reading, it's also used
; as a checksum in the message headers.
;
; Usage: Result% = StrCkSum(Input$)
; Where Input$ is the string to find the checksum of, and Result% contains
; the integer checksum found.
;
; The total of the ASCII values of the string shouldn't exceed 65,534.  Or
; about 256 characters with ASCII codes of 255.  Or about 515 characters with
; ASCII codes of 127.
;
; The equivalent Basic code:
;    FUNCTION NameCkSum%(K$)
;    K = 0
;    FOR K0 = 1 TO LEN(K$)
;      K = K + Asci(MID$(K$,K0,1))
;    NEXT
;    NameCkSum = K
;    END FUNCTION
;

.Model Medium, Basic
.Code

            PUBLIC  StrCkSum          ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

StrCkSum    proc    uses DS, Descriptor

            cld                       ;Move forward in the string.

            mov     ax,Descriptor     ;Get descriptor of the string.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di             ;Move size of string into CX.
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If a null string, then exit.

            mov     ds,dx
            xchg    si,ax             ;Get address of the string into SI.

            xor     ax,ax             ;Zero AX (need to zero AH).
            mov     bx,ax             ;Zero out BX--start with a clean slate.
        R1: lodsb                     ;Get the next byte.
            add     bx,ax             ;Add AX (really just AL) to total (BX).
            loop    R1                ;Decrement CX, loop if not zero.
            xchg    ax,bx             ;AX gets the value.

      Done: ret

StrCkSum    endp                      ;End of routine.

End

