; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will return the value of 2^n (1, 2, 4, 8, 16, etc.).
;
; Usage:  Result% = Power2(RaiseTo%)
; Declare: DECLARE FUNCTION Power2% (BYVAL RaiseTo%)
;
; Where RaiseTo% is a number from 0 to 15 and Result% contains the resulting
; number.
;
; No error checking is done, so only send 0 to 15.  A 0 returns 1, 1 returns
; 2, 2 returns 4, etc.
;
; The equivalent Basic code:
;    FUNCTION Power2% (K)
;    SELECT CASE K
;      CASE 0 : K0 = 1
;      CASE 1 : K0 = 2
;      CASE 2 : K0 = 4
;      CASE 3 : K0 = 8
;      CASE 4 : K0 = 16
;      CASE 5 : K0 = 32
;      CASE 6 : K0 = 64
;      CASE 7 : K0 = 128
;      CASE 8 : K0 = 256
;      . . .
;    END SELECT
;    Power2 = K0
;    END FUNCTION
;

.Model Medium, Basic
.Code

            PUBLIC  Power2            ;Make this routine available to LINK.

Power2      proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     cx,[bp + 06]      ;Get size, all we really want is CL.
            mov     ax,0001           ;We just shift over a bit.
            shl     ax,cl             ;Do shift for size sent.
            pop     bp
            ret     2                 ;Pop-return past our input parameter.

Power2      endp                      ;End of routine.

End

