; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine returns with a integer value in a string at an offset.
;
; Usage:  Result% = IntMid(Input$,Offset%)
;
; Where Input$ is the text to to analyze, and Result% contains the value
; itself.  
;
; Will get a random value if you feed it a null string, or an Offset of
; zero or greater than the length of the string.  Offset% goes from 1 to n.
;
; It's a faster replacement for CVL(MID$(Input$,Offset%,4)).
;

.Model Medium, Basic
.Code

            PUBLIC  IntMid            ;Make this routine available to LINK.

            extrn   StringAddress: proc

IntMid      proc    far

            push    bp
            mov     bp,sp

            mov     ax,[bp + 08]
            push    ax
            call    StringAddress
            xchg    ax,si
            mov     bx,[bp + 06]
            dec     bx
            mov     es,dx
            mov     ax,es:[si + bx]

            pop     bp
            ret     4                 ;Pop-return past our input parameters.

IntMid      endp                      ;End of routine.

End


