; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; These are the assembly graphics routines I created for the GIP stuff.
;
; If anyone can improve upon them, please do and send me the changes.
;



.Model Medium, Basic
.Code


;Change to a screen mode.
;
;GSetMode (BYVAL ModeToUse%, BYVAL 640x480x256Mode%,  BYVAL 800x600x256Mode%)
;
; upon entry: 0 = 80x25x16 ansi mode
;             1 = 320x200x4 CGA mode (for testing only)
;             2 = 640x480x16 VGA mode
;             3 = 320x200x256 VGA mode
;             4 = 640x480x256 SVGA mode
;             5 = 800x600x256 SVGA mode
;

            PUBLIC  GSetMode          ;Make this routine available to LINK.

GSetMode    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     al,[bp + 0AH]     ;Get the mode to use.
            mov     GModeInUse,al
            mov     GScrMem,0A000H

        R0: cmp     al,1              ;Check to see if graphics mode 1,
            jne     RN1
            mov     al,4              ;which is 320x200x4 CGA
            mov     GScrMem,0B800H
            jmp     D1

       RN1: cmp     al,-1             ;Check to see if graphics mode 1,
            jne     R2
            mov     al,4              ;which is 320x200x4 CGA
            mov     GScrMem,0B800H
            jmp     D1

        R2: cmp     al,2              ;Check to see if graphics mode 18,
            jne     RN2               ;which is 640x480x16 VGA
            mov     al,12H
            jmp     D1

       RN2: cmp     al,-2             ;Check to see if graphics mode 18,
            jne     R3                ;which is 640x480x16 VGA
            mov     al,12H
            jmp     D1

        R3: cmp     al,3              ;Check to see if graphics mode 19,
            jne     RN3               ;which is 320x200x256 VGA
            mov     al,13H
            jmp     D1

       RN3: cmp     al,-3             ;Check to see if graphics mode 19,
            jne     R4                ;which is 320x200x256 VGA
            mov     al,13H
            jmp     D1

        R4: cmp     al,4              ;Check to see if 640x480x256
            jne     R5
            mov     al,[bp + 08]
            jmp     D1

        R5: cmp     al,5              ;Check to see if 800x600x256
            jne     D2
            mov     al,[bp + 06]
            jmp     D1

        D2: mov     al,3              ;Else, standard 80x25x16 ANSI mode.

        D1: xor     ah,ah
            INT     10H

      Done: pop     bp
            ret     6                 ;Pop-return past our input parameters.

GSetMode    endp                      ;End of routine.


;Display text in a given color at given coordinates.
;
;ColorText (BYVAL Horiz%, BYVAL Vert%, BYVAL Color%, BYVAL CharToDisp%)
;
;Temporarily using DOS 8x8 font until I can figure out the TrueType font
;file structure and implement those fonts.
;

            PUBLIC  ColorText         ;Make this routine available to LINK.

ColorText   proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bl,[bp + 06]      ;Character to display
            cmp     bl,32             ;Nothing to do if a space.
            je      Done

            push    ds

            mov     es,GScrMem
            mov     al,8              ;8 pixels high.
            mul     bl
            mov     si,0FA6EH         ;Start of DOS font table.
            add     si,ax
            mov     bx,0F000H         ;Segment of the font table.
            mov     ds,bx

            mov     dx,[bp + 0AH]     ;Vertical start.
            mov     bl,[bp + 08]      ;Color to use.

            mov     bh,8              ;8 pixels high.
        R1: mov     di,8              ;8 pixels wide.
            mov     cx,[bp + 0CH]     ;Horizontal start.
            lodsb                     ;AL <- (DS:SI)
        R2: shl     al,1              ;Pixel value -> CF.
            jnc     R3
            push    ax
            push    dx
            push    di
            call    gpixel2
            pop     di
            pop     dx
            pop     ax
        R3: inc     cx                ;Move right one pixel.
            dec     di
            jnz     R2
            inc     dx                ;Move down one pixel.
            dec     bh
            jnz     R1

            pop     ds

      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

ColorText   endp                      ;End of routine.



;Draw a pixel in a given color at given coordinates.
;
;GPixel (BYVAL Horiz%, BYVAL Vert%, BYVAL Color%)
;

            PUBLIC  GPixel            ;Make this routine available to LINK.

GPixel      proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     es,GScrMem
            mov     bl,[bp + 06]      ;Pixel's color.
            mov     dx,[bp + 08]      ;vertical position.
            mov     cx,[bp + 0AH]     ;horizontal position.
            call    gpixel2

            pop     bp
            ret     6                 ;Pop-return past our input parameter.

GPixel      endp                      ;End of routine.



;The heart of all these graphics routines.  Draw a pixel.
;
;bl = pixel's color
;cx = horizontal position
;dx = vertical position
;
;changes: AX DX DI (only those routines that use need push/pop b4 hand).
;
; Non-direct negative modes and the SVGA (for now) modes fall through
; and are displayed using the slower INT 10H (Video BIOS that is stored
; within each video card, and may possibly be unique enough that these
; direct routines won't work).
;

GPixel2     proc    far               ;Beginning of routine.

            cmp     GModeInUse,1      ;CGA
            jne     R2

            push    cx

            ror     dx,1
            mov     al,80
            mul     dl
            shl     dh,1
            jae     R1
            add     ax,2000H
        R1: mov     dh,bl                  ;save color for later.

            mov     dl,3
            and     dl,cl
            shr     cx,1
            shr     cx,1
            mov     di,ax
            add     di,cx

            mov     cl,dl
            shl     cl,1
            inc     cl
            inc     cl

            mov     al,es:[di]

            rol     al,cl
            mov     ah,bl
            and     dh,3                 ;00000011 mask
            and     al,252               ;11111100 mask
            or      al,dh
            ror     al,cl
            stosb                        ;(ES:DI) <- AL

            pop     cx
            ret


       R2:  cmp     GModeInUse,2      ;640x480x16 VGA
            jne     R3

            push    cx

            mov     ax,80
            mul     dx
            mov     di,ax
            mov     ax,0A0H           ;GScrMem
            mov     dx,1000H
            mul     dx
            add     di,ax
            push    cx
            shr     cx,1
            shr     cx,1
            shr     cx,1
            add     di,cx
            pop     cx
            and     cx,7
            mov     ch,80H

            mov     dx,03CEH
            mov     ax,3
            out     dx,ax             ;vga graphics index
            mov     ax,0205H
            out     dx,ax             ;vga graphics index
            shr     ch,cl
            mov     ah,ch
            mov     al,8
            out     dx,ax
            mov     ah,es:[di]
            mov     al,bl
            stosb                     ;(ES:DI) <- al

            mov     dx,03CEH
            mov     ax,3
            out     dx,ax
            mov     ax,0FF08H
            out     dx,ax
            mov     ax,5
            out     dx,ax

            pop     cx
            ret

       R3:  cmp     GModeInUse,3      ;320x200x256 VGA
            jne     R4
            mov     ax,320
            mul     dx                ;h*w
            add     ax,cx
            mov     di,ax
            mov     al,bl
            stosb
            ret

       R4:  push    si                ;non-direct and SVGA modes.
            push    bx
            mov     ah,0CH            ;BIOS: draw pixel
            mov     al,bl
            xor     bh,bh             ;video page 0.
            INT     10H               ;changes ax,si,di
            pop     bx
            pop     si
            ret

GPixel2     endp                      ;End of routine.


;Draw a line.
;
;GLine (BYVAL CurrentH%, BYVAL CurrentV%, BYVAL TillH%, BYVAL TillV%, BYVAL Colr%, BYVAL GDither%)
;
;cx = horizontal position
;dx = vertical position
;bl = color
;DPattern = pattern to use.
;

            PUBLIC  GLine             ;Make this routine available to LINK.

GLine       proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     es,GScrMem

            mov     ax,[bp + 06]   ;dither
            mov     DPattern,ax
            rol     DPattern,1

            mov     bl,[bp + 08]      ;Pixel's color.

            mov     cx,[bp + 10H]    ;CurrentH
            mov     dx,[bp + 0EH]    ;CurrentV
            mov     SlopeH,1
            mov     SlopeV,1

            mov     si,[bp + 0AH]    ;TillV
            sub     si,dx
            cmp     si,0
            jge     S1
            neg     si
            mov     SlopeV,-1

        S1: mov     di,[bp + 0CH]   ;TillH
            sub     di,cx
            cmp     di,0
            jge     S2
            neg     di
            mov     SlopeH,-1

        S2: cmp     di,si
            jle     S3

;
; Plot the line.
;

            mov     ax,di
            shr     ax,1
            mov     unk1,ax           ;unk1 = DI \ 2
            mov     Counter,di
            ror     DPattern,1
            jnc     z1
            push    dx
            push    di
            call    gpixel2
            pop     di
            pop     dx
z1:         cmp     di,0
            je      Done

        R1: add     cx,SlopeH
            add     unk1,si
            cmp     unk1,di
            jle     R2
            sub     unk1,di
            add     dx,SlopeV
        R2: ror     DPattern,1
            jnc     z2
            push    dx
            push    di
            call    gpixel2
            pop     di
            pop     dx
z2:         dec     Counter
            jnz     R1
            jmp     Done

;
; Plot the line.
;

        S3: mov     ax,si
            shr     ax,1
            mov     unk1,ax           ;unk1 = SI \ 2
            mov     Counter,si

            ror     DPattern,1
            jnc     z3
            push    dx
            push    di
            call    gpixel2
            pop     di
            pop     dx
z3:         cmp     si,0
            je      Done

        R3: add     dx,SlopeV
            add     unk1,di
            cmp     unk1,si
            jle     R4
            sub     unk1,si
            add     cx,SlopeH
        R4: ror     DPattern,1
            jnc     z4
            push    dx
            push    di
            call    gpixel2
            pop     di
            pop     dx
z4:         dec     Counter
            jnz     R3

      Done: pop     bp
            ret     0CH               ;Pop-return past our input parameter.

SlopeH      DW   0
SlopeV      DW   0
unk1        DW   0
Counter     DW   0
DPattern    DW   0

GLine       endp                      ;End of routine.

GScrMem     DW   0
GModeInUse  DB   0


End

