; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will retrieve data from a file at a specific location.
;
; Usage:  CALL FileGetLoc(Handle%, Location&, Size%, x)
; Declare: DECLARE SUB FileGetLoc (BYVAL Handle%, BYVAL Location&, BYVAL Size%, x AS ANY)
;
; Where Handle% is the file handle to use, Location& is the location - 1 to
; load from, Size% is the size of the data to write out, and x is any
; non-string variable.
;
; Location& specifies the location to load the data from--using a 0..n scale,
; which means we actually load from location Location& + 1.
;
; It does no negative number checking.  A zero put's it at position 1.  A 3
; put's it on the 4th character, and so on.  Thus, no more need for the "+ 1"
; when doing: (rec - 1) * len + 1   to position it, now (rec - 1) * len does
; it.
;

.Model Medium, Basic
.Code

            PUBLIC  FileGetLoc        ;Make this routine available to LINK.

            extrn   Delay:far

FileGetLoc  proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0EH]     ;Get the file handle into BX.
            mov     ax,4200H          ;Subfunction to seek to loc in file.
            mov     dx,[bp + 0AH]     ;Low order word of long offset.
            mov     cx,[bp + 0CH]     ;High order word of long offset.
            int     21H               ;Call DOS Services to do it.

            mov     cx,[bp + 08]      ;Length to read in.
            mov     dx,[bp + 06]      ;Address of data to load in.
        R0: mov     ah,3FH            ;Subfunction to read from a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     Done              ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     Done
            call    Delay
            jmp     R0

      Done: pop     bp
            ret     0AH               ;Pop-return past our input parameters.

FileGetLoc   endp                     ;End of routine.

End

