; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This is just a substitute for using the INTERRUPT routine to access X00's
; functions.  Interrupt wanted like three parameters and a special type/etc.
; (see InterruptX) and it just wasn't necessary if all I do with it is call
; one interrupt (&H14--the fossil).
;
; Usage: Result% = FosIntAX(Port%,&Hyyyy)
; Declare:  DECLARE FUNCTION FosIntAX% (BYVAL Port%,BYVAL Func%)
;
; Where Result% contains the fossils return value, Port% contains which port
; to use (1 to n), and Func% which fossil function call to do.  I use &Hyyyy
; hex formats for the Func%, because it's easier to keep track of what
; function I'm doing.
;
; Sending it a zero for port is basically saying don't do anything.  This
; allows the port 0 to be considered as a local user logon.
;
; It checks for a port of 0, but not for anything else.  Thus you could send
; it port -1000, but the fossil driver probably filters this error.
;

.Model Medium, Basic
.Code
 
            PUBLIC  FosIntAX          ;Make this routine available to LINK.

FosIntAX    proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            xor     ax,ax             ;Exit with at least a zero.
            mov     dx,[bp + 08]      ;Get our Port%.
            or      dx,dx             ;They sent us a zero,
            jz      Done              ;so exit.
            dec     dx                ;The fossil wants 0 to n ports.
            mov     ax,[bp + 06]      ;Get our fossil function call.
            int     14H               ;Call the fossil.
     Done:  pop     bp
            ret     4
 
FosIntAX    endp                      ;End of routine.

End




