; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This file contains routines to set, clear, and toggle a bit of a given
; integer.
;

.Model Medium
.Code

;
; This routine will clear a bit of a given integer.
;
; Usage:  CALL = BitClear (Input%, BitNum%)
; Declare: DECLARE SUB BitClear (Input%, BYVAL BitNum%)
;
; Where Input% is the integer containing our flags and BitNum% is the bit
; number to clear (set to zero).
;
; This routine is complimentary to BitSet.
;
; No error checking is done, so only send 1 to 16 for the BitNum%.
;

            PUBLIC  BitClear          ;Make this routine available to LINK.

BitClear    proc    far               ;Beginning of routine.

            mov     bx,0001           ;Function for BitStuff to do.
            call    BitStuff          ;BitStuff does our work.
            ret     4                 ;Pop-return past our input parameters.

BitClear    endp                      ;End of routine.


;
; This routine will set a bit of a given integer.
;
; Usage:  CALL = BitSet (Input%, BitNum%)
; Declare: DECLARE SUB BitSet (Input%, BYVAL BitNum%)
;
; Where Input% is the integer containing our flags and BitNum% is the bit
; number to set (set to 1).
;
; This routine is complimentary to BitClear.
;
; No error checking is done, so only send 1 to 16 for the BitNum%.
;

            PUBLIC  BitSet            ;Make this routine available to LINK.

BitSet      proc    far               ;Beginning of routine.

            mov     bx,0002           ;Function for BitStuff to do.
            call    BitStuff          ;BitStuff does our work.
            ret     4                 ;Pop-return past our input parameters.

BitSet      endp                      ;End of routine.


;
; This routine will toggle a bit of a given integer.
;
; Usage:  CALL = BitToggle (Input%, BitNum%)
; Declare: DECLARE SUB BitToggle (Input%, BYVAL BitNum%)
;
; Where Input% is the integer containing our flags and BitNum% is the bit
; number to toggle (zero -> 1, 1 -> zero).
;
; If a zero or negative BitNum%, nothing will be done.  No error checking is
; done for values greater than 16.  0, 1-16 should be the only values your
; program sends.
;

            PUBLIC  BitToggle         ;Make this routine available to LINK.

BitToggle   proc    far               ;Beginning of routine.

            mov     bx,0003           ;Function for BitStuff to do.
            call    BitStuff          ;BitStuff does our work.
            ret     4                 ;Pop-return past our input parameters.

BitToggle   endp                      ;End of routine.


;
; Internal routine used by BitClear, BitSet, and BitToggle.
;
; Fed the "what to do" via BX, it goes and does it.
;

BitStuff    proc    near              ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     cx,[bp + 08]      ;Get size, all we really want is CL.
            dec     cx                ;Real world 1-16 to our 0-15.
            js      Done              ;They sent us a zero or negative.
            mov     ax,0001           ;We just shift over a bit.
            shl     ax,cl             ;Do shift for size sent.
            mov     si,[bp + 0AH]     ;Get the address of our number.
            mov     dx,[si]           ;Get the actual number.
            dec     bx                ;If BX = 1,
            jz      D2                ; then we clear the bit.
            dec     bx                ;If BX = 2,
            jz      D1                ; then we set the bit.
                                      ;Otherwise we toggle the bit.
            test    dx,ax             ;Test our bit.
            jz      D1                ;Zero, so jump.
            jmp     D2                ;Not zero.
        D1: or      dx,ax             ;Set the desired bit.
            jmp     D3
        D2: not     ax                ;Build our mask.
            and     dx,ax             ;Clear off the desired bit.
        D3: mov     [si],dx           ;Save the result.
      Done: pop     bp
            ret

BitStuff    endp                      ;End of routine.

End

