; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine uses gets the ASCII value of the first character of a string.
;
; Usage:  Result% = AscNull(Input$)
; Where Input$ is the text to to analyze, and Result% contains the value
; itself.  Returns 0 if the string is null, or the first character contains
; a CHR$(0) code.
;
; Essentially a direct replacement for the basic ASC function when I expect
; a null string.
;

.Model Medium, Basic
.Code

            PUBLIC  AscNull            ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

AscNull     proc    uses DS, Descriptor

            mov     ax,Descriptor
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            xchg    ax,si
            xor     ax,ax             ;Zero out AX, returns at least a 0.
            jcxz    Done              ;If a null string, then exit.

            mov     ds,dx
            lodsb                     ;Get the first byte.

      Done: ret

AscNull     endp                      ;End of routine.

End

