; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine uses DOS interrupt 21H to display text to the screen.
;
; Usage:  CALL Ansi(String$)
; Where String$ is the text to display.
;
; This routine is completely distinct from the Basic command LOCATE.  When
; you shell to DOS, the cursor jumps to where ever you were when you entered
; the program, or to whatever LOCATE values you used.
;

.Model Medium, Basic
.Code

            PUBLIC  Ansi              ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

Ansi        proc    uses ds, descriptor

            mov     ax,descriptor     ;Get string descriptor.
            push    ax
            push    ax
            call    StringLength      ;Get string length into AX.
            xchg    ax,di             ;Length of string -> CX.
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;Exit if a null string.
            mov     ds,dx
            xchg    ax,bx

            mov     ah,02             ;Set up for INT 21H, subfunction 02H.
        R1: mov     dl,[bx]           ;Get character to display into DL.
            int     21H               ;Display the character.
            inc     bx                ;Point to next char
            loop    R1                ;Loop until all are done.

      Done: ret

Ansi        endp                      ;End of routine.

End

