/********************************************************************/
/* Special Note:						    */
/*	This command file is strictly use-at-your-own-risk.  Do NOT */
/* run this file until you have read through the code and comments  */
/* and made whatever changes are necessary or appropriate for your  */
/* system and setup.  Things to watch for include:		    */
/*    - paths and naming of temporary files			    */
/*    - check appropriate code to ensure path to Desktop (i.e. OS/2 */
/*      drive) is located correctly				    */
/*    - folder 'exclude list' entries (the exclude list entered     */
/*	below is used on my system; I left it here as an example)   */
/*								    */
/* Frank Yannetta						    */
/*								    */
/* P.S. to Melissa Woo						    */
/*	I hope you will forgive the excessive liberties I have 	    */
/* taken with your code.  I admit this may have become a bit over-  */
/* blown.							    */
/*								    */
/* ================================================================ */
/* OPENFDR.CMD v.1.3 - by M. Woo, Champaign-Urbana OS/2 Users Group */
/* -- choose a folder to open from a popup list under 4OS2.         */
/* Requires OS/2 (R) REXX, J.P. Software Inc.'s 4OS2 (TM).          */
/*                                                                  */
/* My contact addresses through Dec, 1993 (I don't know where I'll  */
/* be after then) are: Internet: m-woo@uiuc.edu, Fidonet: 1:233/4.0 */
/*                                                                  */
/* NOTE: if your desktop doesn't reside on the C: drive, or you are */
/* using OS/2 v2.0, you will have to modify this script where       */
/* indicated to reflect your actual desktop's subdirectory.         */
/*                                                                  */
/* Unfortunately, I don't know of a way to make the folder open in  */
/* front of the 4OS/2 command window, without adding another set of */
/* external REXX functions.  Suggestions would be greatly           */
/* appreciated!                                                     */
/*                                  				    */
/*------------------------------------------------------------------*/
/* Modifications: (F.Yannetta - 11/08/93)                           */
/* 1.  Added second SysSetObjectData line to bring folder to FG     */
/*                                  				    */
/* (trivial stuff)                          			    */
/* 2.  Increased width of 4OS2 Select dialog                	    */
/* 3.  Replaced '^', '_' and '!!' in folder names with single space */
/*------------------------------------------------------------------*/
/* Modifications: (F.Yannetta - 11/10/93)                           */
/* 1. Major changes to usage and form - utility is now iterative,   */
/*    permitting repeated selections of folders (intention is to    */
/*    have this command file started in background session,         */
/*    available via Task List, to permit folder access at any time  */
/*    regardless of how obscured the Desktop is by app windows)     */
/* 2. re 1. above, added selection which refreshes the folder list  */
/*    (in the event that new folders are added this option updates  */
/*    the list without need to restart command file)                */
/* 3. all literals with regard to file names have been replaced    */
/*    with variables;  file name assignments all point to %TEMP     */
/*    directory if defined, otherwise temporary files are created   */
/*    in root dir of current drive                                  */
/* 4. Added exclude list variable to permit exclusion of named      */
/*    folders or of subfolders located in a named parent folder.    */
/* 5. Added Dick Goran's suggestion re locating the drive on which  */
/*    the Desktop folder resides (i.e. the file system location)    */
/*								    */
/* (trivial stuff)						    */
/* 6. added ANSI screen colour directives and a help message;       */
/* 7. Name of the session as seen on the Task List now reads        */
/*    'DESKTOP Folder List'.  This remains in effect only while	    */
/*    this command file is running.  On termination, Task List name */
/*    reverts to former name of the session (usually 'OS/2 Window') */
/* 8. replaced 'del' commands with SysFileDelete                    */
/*								    */
/*------------------------------------------------------------------*/
/*                                                                  */
/* The user assumes responsibility for any damage caused by this    */
/* program.  There is no warranty, and the program is guaranteed    */
/* only to waste space on your hard drive.                          */
/* ================================================================ */

/* Load the external REXXUtil functions.         */

call RxFuncAdd "SysLoadFuncs", "REXXutil", "SysLoadFuncs"
call SysLoadFuncs

    /* change Task List title for session; this is 	*/
    /* temporary and will revert to old title on exit	*/
'window "DESKTOP Folder List" RESTORE'

call SysCls
rc = SysCurPos(0,0)
'echo [33;44;1m'   	/* set ansi screen colours:  YELLOW on dark BLUE */

say ' Select the DESKTOP folder you wish to open, select  REFRESH  to update  '
say ' the folder list, or press <ESC> to return to the OS/2 session.                '

'echo [0m'     	/* reset ansi screen colours:  GREY on BLACK */

/*-------------------------------------------------------------------*/

	/* list of folders to exclude from display - to include	*/
	/* all folders set ExcludeFolders = ''			*/
	/* - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
	/* NOPE!  No wild cards - strictly name by name.	*/
	/* - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
	/* To exclude folders, add names to list, seperated by 	*/
	/* spaces.  To exclude folders within a folder add the	*/
	/* name of the parent folder followed by a backslash 	*/
	/* ('\').  In the former case, subfolders to the 	*/
	/* excluded folder will be listed.  In the latter case 	*/
	/* the parent folder will be listed but not subfolders.	*/
	/* - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
	/* Note: folder names specified are as they would appear*/
	/* in the Real Name field of the parent folder's details*/
	/* view.  To prevent ambiguity, folder paths can be	*/
	/* specified (e.g. Work\General!!Info would bypass the  */
	/* General!!Info subfolder located in the Work folder 	*/
	/* but would  display General!!Info folders located 	*/
	/* elsewhere.) 						*/
	/* - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ExcludeFolders = 'Templates\ Network Incoming!!Files\'


	/* get path of temporary directory if defined */
tpath = value( 'TEMP',,'OS2ENVIRONMENT' )
	/* temporary data coloection files */
FoldersList   = tpath'\folder$'
FoldersSorted = tpath'\folder$.srt'
ResponseFile  = tpath'\choice$'


	/* Note: the chars  (ascii 17) and  (ascii 16) aren't strictly    */
	/* necessary, however the first char of refresh_msg should have an  */
	/* ascii value < 32 to ensure that this string gets sorted to       */
	/* beginning of the folder list		                            */
refresh_msg = ' REFRESH '



	/* To find the Desktop directory, get full filespec of system 	*/
	/* INI file and extract drive letter - this assumes that 	*/
	/* Desktop is located on the same drive as the INI file;  	*/
	/* ((thanks to Dick Goran))					*/
	/* -------------------------------------------------------------*/
	/* If your Desktop directory is located on a drive other than   */
	/* the drive where the INI files are stored then you should 	*/
	/* delete this section and change the SysFileTree statement,	*/
	/* below, to include the correct specification for the Desktop	*/
	/* directory.   Note: the Desktop name under OS/2 2.0 is of the */
	/* format <drive>:\OS!2 2.0 DESKTOP\				*/

sys_ini_value = VALUE( 'SYSTEM_INI',, 'OS2ENVIRONMENT' )
sys_ini_drive = FILESPEC( 'D', sys_ini_value )		/* letter & colon */
DesktopPath  = sys_ini_drive || '\desktop\*'



/*---------------------------------------------------*/
/* Start main loop: collect all folders names, sort  */
/* these and then start secondary loop for selection */
/*---------------------------------------------------*/
refresh = 1
do while refresh

		/* Creates an array of all the subdirectories     */
		/* below "desktop" (recursively).                 */
	call SysFileTree DesktopPath, "dirs.", "DSO" 

	/*--------------------------------------------------------------*/
	/* Create an array of folder names by reading the subdirectory	*/
	/* array and truncating them after the final backslash.  	*/
	/* Special chars ('^', '_', and '!!') are replaced by single	*/
	/* spaces.  Folders located in 'Templates' folder are not to be	*/
	/* displayed.							*/
	/*--------------------------------------------------------------*/

	lineout(FoldersList,refresh_msg) '>& nul'
	do i=1 to dirs.0 
			/* check ExcludeFolder list to see if folder should	*/
			/* be displayed.					*/
			/* - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
			/* if not then replace that folders name with null char */
			/* (ascii 0xFF) when saving the entry in dirname stem;  */
			/* this entry is not output to the FoldersList file so  */
			/* the actual string could be anything not usually 	*/
			/* expected for a folder name				*/
		if ExcludeFolders \= '' then do
			ExList = ExcludeFolders
			do while ExList \= ''
				parse var ExList ExFolder ExList
				nloc = pos('\'ExFolder, dirs.i )
				if nloc > 0 then do
					if ( pos( '\', ExFolder ) > 0 ) | ( ExFolder = substr( dirs.i, nloc+1 ) ) 
					then do
						dirname.i = x2c( 'FF' )
						iterate	i	/* get next name */
						end
					end
				end  /* ------------ exclude list loop */
			end

		lastslash = lastpos("\", dirs.i) 
		dirname.i = delstr(dirs.i, 1, lastslash)
		dirname.i = space( translate( dirname.i, '', '^_', ' ' ), 1 )
		NLpos = pos( '!!', dirname.i )
		do while ( NLpos > 0 )
			dirname.i = delstr( dirname.i, NLpos, 2 )
			dirname.i = insert( ' ', dirname.i, NLpos-1 )
			NLpos = pos( '!!', dirname.i )
			end
			name=dirname.i
		lineout(FoldersList,name) '>& nul'

		end     /* folder name loop */

		/* ============================================== */
		/* This section closes the newly-created text     */
		/* file, sorts it alphabetically, then runs the   */
		/* 4OS/2 variable function %@select on the text   */
		/* file to create the popup menu.                 */
		/* ============================================== */

			/* Closes the unsorted list file then sorts   */
			/* the output into a new file                 */
		lineout(FoldersList) '>& nul'
		'sort <' FoldersList '>' FoldersSorted

		/*--------------------------------------------------*/
		/* Start loop to repeatedly select folders from the */
		/* current list.  Open each selection.              */
		/*--------------------------------------------------*/
		continue = 1
		do while continue

				/* Directs the user's selection into a file */
				/* and pipes any error messages to nul.     */
			'echos %@select[' FoldersSorted ',4,1,17,77,Open DESKTOP Folder] 1>'ResponseFile '2>nul' 

				/* Assigns the text in response file to the variable */
				/* "answer" and closes the response file             */
			answer=linein(ResponseFile)
			lineout(ResponseFile) '>&nul'

			/*--------------------------------------------*/
			/* check 'answer' to see if response requires */
			/* special attention - i.e. escape or refresh */
			/*--------------------------------------------*/
				/* In case the user presses Esc to cancel the     */
				/* popup menu, this if-then-do loop will catch    */
				/* it and exit all loops ((cleanup follows))      */
			if answer = '' then do
				continue = 0
				refresh = 0
				end 

				/* if 'REFRESH' is selected then  */
				/* exit the inner (CONTINUE) loop */
			else if answer = refresh_msg then do
				continue = 0
				end

			/*--------------------------------------*/
			/* otherwise a folder name was selected */
			/*--------------------------------------*/
			else do
				/* ============================================== */
				/* This section reads the array of your           */
				/* folder names.  When the user's choice is the   */
				/* same as the folder name, the correct folder    */
				/* will be opened.                                */
				/* ============================================== */

				do k=1 to dirs.0 until (answer=dirname.k)
					thedir=dirs.k
					end 	/* do k loop */

					/* open correct folder, specified by "thedir"     */ 
					/* (fy) Change:  Second call was added to 'pop'   */
					/* folder to foreground.  Crude???                */
				call SysSetObjectData  thedir, "OPEN=DEFAULT"; 
				call SysSetObjectData  thedir, "OPEN=DEFAULT"; 
				end

					/* CLEANUP */
					/* delete old 'choice' file */
				call SysFileDelete ResponseFile
				/* 'del' ResponseFile '/q /f' */

			end /* do while CONTINUE */

			/* CLEANUP */
			/* delete old folder list files */
		rc = SysFileDelete( FoldersList )
		rc = SysFileDelete( FoldersSorted )
		/* 'del' FoldersSorted FoldersList '/q /f'  */

		end /* do while REFRESH */

	/* CLEANUP */
call SysCls

exit
