VERSION 2.00
Begin Form SetTimeForm 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Set Time"
   ClientHeight    =   1305
   ClientLeft      =   2970
   ClientTop       =   3315
   ClientWidth     =   3570
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   1740
   Left            =   2895
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1305
   ScaleWidth      =   3570
   Top             =   2955
   Width           =   3720
   Begin SSCommand Command3D1 
      Height          =   465
      Left            =   165
      Picture         =   SETTIME.FRX:0000
      TabIndex        =   18
      Top             =   720
      Width           =   540
   End
   Begin CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   360
      Index           =   1
      Left            =   2265
      TabIndex        =   20
      Top             =   765
      Width           =   1155
   End
   Begin CommandButton Command1 
      Caption         =   "Set"
      Default         =   -1  'True
      Height          =   360
      Index           =   0
      Left            =   885
      TabIndex        =   19
      Top             =   765
      Width           =   1155
   End
   Begin PictureBox SpinButton 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   360
      Index           =   1
      Left            =   3255
      ScaleHeight     =   330
      ScaleWidth      =   135
      TabIndex        =   17
      TabStop         =   0   'False
      Top             =   240
      Width           =   165
   End
   Begin SSFrame Frame3D1 
      ForeColor       =   &H00000000&
      Height          =   444
      Index           =   1
      Left            =   1830
      TabIndex        =   11
      Top             =   156
      Width           =   1395
      Begin TextBox tYear 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   780
         MaxLength       =   4
         TabIndex        =   14
         Tag             =   "y"
         Text            =   "1955"
         Top             =   150
         Width           =   480
      End
      Begin TextBox tDay 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   450
         MaxLength       =   2
         TabIndex        =   13
         Tag             =   "d"
         Text            =   "17"
         Top             =   150
         Width           =   240
      End
      Begin TextBox tMonth 
         Alignment       =   1  'Right Justify
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   120
         MaxLength       =   2
         TabIndex        =   12
         Tag             =   "n"
         Text            =   "09"
         Top             =   150
         Width           =   240
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "/"
         Height          =   225
         Index           =   3
         Left            =   690
         TabIndex        =   16
         Top             =   150
         Width           =   105
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "/"
         Height          =   225
         Index           =   2
         Left            =   345
         TabIndex        =   15
         Top             =   150
         Width           =   105
      End
   End
   Begin PictureBox SpinButton 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Height          =   360
      Index           =   0
      Left            =   1590
      ScaleHeight     =   330
      ScaleWidth      =   135
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   240
      Width           =   165
   End
   Begin PictureBox N 
      AutoSize        =   -1  'True
      Height          =   360
      Left            =   2970
      Picture         =   SETTIME.FRX:016A
      ScaleHeight     =   330
      ScaleWidth      =   135
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   1995
      Visible         =   0   'False
      Width           =   165
   End
   Begin PictureBox U 
      AutoSize        =   -1  'True
      Height          =   360
      Left            =   3180
      Picture         =   SETTIME.FRX:0294
      ScaleHeight     =   330
      ScaleWidth      =   135
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   1980
      Visible         =   0   'False
      Width           =   165
   End
   Begin PictureBox D 
      AutoSize        =   -1  'True
      Height          =   360
      Left            =   3405
      Picture         =   SETTIME.FRX:03BE
      ScaleHeight     =   330
      ScaleWidth      =   135
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   1980
      Visible         =   0   'False
      Width           =   165
   End
   Begin SSFrame Frame3D1 
      ForeColor       =   &H00000000&
      Height          =   444
      Index           =   0
      Left            =   168
      TabIndex        =   8
      Top             =   156
      Width           =   1392
      Begin TextBox tHour 
         Alignment       =   1  'Right Justify
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   120
         MaxLength       =   2
         MultiLine       =   -1  'True
         TabIndex        =   1
         Tag             =   "h"
         Text            =   "12"
         Top             =   150
         Width           =   240
      End
      Begin TextBox tMinute 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   456
         MaxLength       =   2
         TabIndex        =   2
         Tag             =   "m"
         Text            =   "00"
         Top             =   150
         Width           =   240
      End
      Begin TextBox tAMPM 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   1020
         TabIndex        =   4
         Tag             =   "a"
         Text            =   "am"
         Top             =   150
         Width           =   285
      End
      Begin TextBox tSecond 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   225
         Left            =   780
         MaxLength       =   2
         TabIndex        =   3
         Tag             =   "s"
         Text            =   "00"
         Top             =   150
         Width           =   240
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   ":"
         Height          =   225
         Index           =   0
         Left            =   345
         TabIndex        =   10
         Top             =   150
         Width           =   105
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   ":"
         Height          =   225
         Index           =   1
         Left            =   675
         TabIndex        =   9
         Top             =   150
         Width           =   105
      End
   End
End
Option Explicit
DefInt A-Z
Dim LastY As Single
Dim Active As String
Dim LastDirection As String
Dim tVal As Integer

' Jeffrey M. Richter's Spin Button Control from Windows 3: A Developer's Guide
' Adapted for Visual Basic by Costas Kitsos with Mr. Richter's kind permission

' Windows API functions used by the Spin Button Control
Declare Function GetTickCount Lib "User" () As Long
Declare Function GetAsyncKeyState Lib "User" (ByVal vKey As Integer) As Integer

Sub Command1_Click (Index As Integer)
If Index = 0 Then
  Time = tHour.Text + ":" + tMinute.Text + ":" + tSecond.Text + UCase$(tAMPM.Text)
  Date = tMonth.Text + "/" + tDay.Text + "/" + tYear.Text
  LastTime = 0
  Unload SetTimeForm
End If
If Index = 1 Then
  LastTime = 0
  Unload SetTimeForm
End If

End Sub

Sub Command3D1_Click ()
AtomicTimeWasSet = False
Atomic.Show 1
Unload Atomic
If AtomicTimeWasSet Then
   Unload SetTimeForm
End If
End Sub

Sub FlipFlopTAMPM ()
         If tAMPM.Text = "am" Then
            tAMPM.Text = "pm"
         Else
            tAMPM.Text = "am"
         End If

End Sub

Sub Form_GotFocus ()
    tHour.SetFocus
    DoEvents

End Sub

Sub Form_Load ()
SetTimeForm.Left = Settings.Left + (Settings.Width / 2) - (SetTimeForm.Width / 2)
SetTimeForm.Top = Settings.Top + (Settings.Height / 2) - (SetTimeForm.Height / 2)
Dim Instant As Double
Dim InitialHeight As Integer
    InitialHeight = SpinButton(0).Height
    SpinButton(0).Picture = N.Picture       'Set to the Normal Spin Button
    SpinButton(0).Top = SpinButton(0).Top + (InitialHeight - SpinButton(0).Height) / 2
    SpinButton(1).Picture = N.Picture       'Set to the Normal Spin Button
    SpinButton(1).Top = SpinButton(1).Top + (InitialHeight - SpinButton(1).Height) / 2
    Instant = Now
    If Hour(Instant) = 0 Then
       tHour.Text = "12"
       tAMPM.Text = "am"
    End If
    If Hour(Instant) >= 1 And Hour(Instant) <= 11 Then
       tHour.Text = Format$(Hour(Instant))
       tAMPM.Text = "am"
    End If
    If Hour(Instant) = 12 Then
       tHour.Text = Format$(Hour(Instant))
       tAMPM.Text = "pm"
    End If
    If Hour(Instant) >= 13 And Hour(Instant) <= 23 Then
       tHour.Text = Format$(Hour(Instant) - 12)
       tAMPM.Text = "pm"
    End If
    tMinute.Text = Format$(Minute(Instant), "00")
    tSecond.Text = Format$(Second(Instant), "00")
    tMonth.Text = Format$(Month(Instant), "00")
    tDay.Text = Format$(Day(Instant), "00")
    tYear.Text = Format$(Year(Instant), "0000")
    'SetTimeFOrm.Show
    'DoEvents

End Sub

Sub MoveDown (c As Control)
Dim CurVal As Integer
CurVal% = Val(c.Text)
Select Case c.Tag
   Case "h"
      If CurVal% = 12 Then
         FlipFlopTAMPM
      End If
      If CurVal% = 1 Then
         c.Text = "12"
      Else
         c.Text = Val(c.Text) - 1
      End If
   Case "m"
      If CurVal% = 0 Then
         c.Text = "59"
      Else
         c.Text = Format$(Val(c.Text) - 1, "00")
      End If
   Case "s"
      If CurVal% = 0 Then
         c.Text = "59"
      Else
         c.Text = Format$(Val(c.Text) - 1, "00")
      End If
   Case "a"
      FlipFlopTAMPM
   Case "n"
      If CurVal% = 1 Then
         c.Text = "12"
      Else
         c.Text = Format$(Val(c.Text) - 1, "00")
      End If
   Case "d"
      If CurVal% = 1 Then
         c.Text = "31"
      Else
         c.Text = Format$(Val(c.Text) - 1, "00")
      End If
   Case "y"
      If CurVal% = 1 Then
         c.Text = "2050"
      Else
         c.Text = Format$(Val(c.Text) - 1, "0000")
      End If
End Select

'c.Text = Val(c.Text) - 1
End Sub

Sub MoveUp (c As Control)
Dim CurVal As Integer
CurVal% = Val(c.Text)
Select Case c.Tag
   Case "h"
      If CurVal% = 11 Then
         FlipFlopTAMPM
      End If
      If CurVal% = 12 Then
         c.Text = "1"
      Else
         c.Text = Val(c.Text) + 1
      End If
   Case "m"
      If CurVal% = 59 Then
         c.Text = "00"
      Else
         c.Text = Format$(Val(c.Text) + 1, "00")
      End If
   Case "s"
      If CurVal% = 59 Then
         c.Text = "00"
      Else
         c.Text = Format$(Val(c.Text) + 1, "00")
      End If
   Case "a"
      FlipFlopTAMPM
   Case "n"
      If CurVal% = 12 Then
         c.Text = "01"
      Else
         c.Text = Format$(Val(c.Text) + 1, "00")
      End If
   Case "d"
      If CurVal% = 31 Then
         c.Text = "01"
      Else
         c.Text = Format$(Val(c.Text) + 1, "00")
      End If
   Case "y"
      If CurVal% = 2050 Then
         c.Text = "1980"
      Else
         c.Text = Format$(Val(c.Text) + 1, "0000")
      End If

End Select

End Sub

Sub SpinButton_DblClick (Index As Integer)
If (Index = 1) And (Active$ <> "n") And (Active$ <> "d") And (Active$ <> "y") Then
   tMonth.SetFocus
End If
If (Index = 0) And (Active$ <> "h") And (Active$ <> "m") And (Active$ <> "s") And (Active$ <> "a") Then
   tHour.SetFocus
End If
If LastDirection$ = "u" Then
   Select Case Active$
     Case "n"
        Call MoveUp(tMonth)
     Case "d"
        Call MoveUp(tDay)
     Case "y"
        Call MoveUp(tYear)
     Case "h"
        Call MoveUp(tHour)
     Case "m"
        Call MoveUp(tMinute)
     Case "s"
        Call MoveUp(tSecond)
     Case "a"
        Call MoveUp(tAMPM)
   End Select
Else
   Select Case Active$
     Case "n"
        Call MoveDown(tMonth)
     Case "d"
        Call MoveDown(tDay)
     Case "y"
        Call MoveDown(tYear)
     Case "h"
        Call MoveDown(tHour)
     Case "m"
        Call MoveDown(tMinute)
     Case "s"
        Call MoveDown(tSecond)
     Case "a"
        Call MoveDown(tAMPM)
   End Select
End If
SpinButton(Index).SetFocus
End Sub

Sub SpinButton_GotFocus (Index As Integer)
If (Index = 1) And (Active$ <> "n") And (Active$ <> "d") And (Active$ <> "y") Then
   tMonth.SetFocus
   Exit Sub
End If
If (Index = 0) And (Active$ <> "h") And (Active$ <> "m") And (Active$ <> "s") And (Active$ <> "a") Then
   tHour.SetFocus
   Exit Sub
End If
   Select Case Active$
     Case "n"
        tMonth.SetFocus
     Case "d"
        tDay.SetFocus
     Case "y"
        tYear.SetFocus
     Case "h"
        tHour.SetFocus
     Case "m"
        tMinute.SetFocus
     Case "s"
        tSecond.SetFocus
     Case "a"
        tAMPM.SetFocus
   End Select
End Sub

Sub SpinButton_MouseDown (Index As Integer, Button As Integer, Shift As Integer, x As Single, Y As Single)

Const VK_LBUTTON = &H1
Const TIME_DELAY = 180      ' Time delay between Spin Button Events

Dim dwEvent As Long
LastY = Y
' Make sure that the Spin Button Event occurs at least once
dwEvent = GetTickCount() - TIME_DELAY

SpinIt:

   ' Do this while the user holds down the left mouse button
   Do While (GetAsyncKeyState(VK_LBUTTON) And &H8000) = -32768

        ' Break out of the loop if we haven't waited long enough
        If dwEvent + TIME_DELAY > GetTickCount() Then GoTo Break:

        ' If the user wants to increment the counter
        If Y > (SpinButton(Index).Height \ 2) Then
            SpinButton(Index).Picture = d.Picture  ' Set Picture to Up
            If Index = 1 Then
            Select Case Active$
               Case "n"
                   Call MoveDown(tMonth)
               Case "d"
                   Call MoveDown(tDay)
               Case "y"
                   Call MoveDown(tYear)
            End Select
            End If
            If Index = 0 Then
            Select Case Active$
               Case "h"
                   Call MoveDown(tHour)
               Case "s"
                   Call MoveDown(tSecond)
               Case "m"
                   Call MoveDown(tMinute)
               Case "a"
                   Call MoveDown(tAMPM)
            End Select
            End If
            LastDirection$ = "d"
        End If

        ' If the user wants to decrement the counter
        If Y < (SpinButton(Index).Height \ 2) Then
            SpinButton(Index).Picture = u.Picture   ' Set Picture to Down
            If Index = 1 Then
            Select Case Active$
               Case "n"
                   Call MoveUp(tMonth)
               Case "d"
                   Call MoveUp(tDay)
               Case "y"
                   Call MoveUp(tYear)
            End Select
            End If
            If Index = 0 Then
            Select Case Active$
               Case "h"
                   Call MoveUp(tHour)
               Case "s"
                   Call MoveUp(tSecond)
               Case "m"
                   Call MoveUp(tMinute)
               Case "a"
                   Call MoveUp(tAMPM)
            End Select
            End If
            LastDirection$ = "u"
        End If

        ' Save the last time the Spin Button was active
        dwEvent = GetTickCount()
    Loop
    
    ' Set the Picture to Normal
    SpinButton(Index).Picture = N.Picture
    If Index = 1 Then
    Select Case Active$
       Case "n"
          tMonth.SetFocus
       Case "d"
          tDay.SetFocus
       Case "y"
          tYear.SetFocus
    End Select
    End If
    If Index = 0 Then
    Select Case Active$
       Case "h"
          tHour.SetFocus
       Case "m"
          tMinute.SetFocus
       Case "s"
          tSecond.SetFocus
       Case "a"
          tAMPM.SetFocus
    End Select
    End If
    DoEvents
    
    Exit Sub

Break:
    GoTo SpinIt:

End Sub

Sub tAMPM_GotFocus ()
tAMPM.SelStart = 0
tAMPM.SelLength = 2
Active$ = "a"

End Sub

Sub tAMPM_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   FlipFlopTAMPM
   KeyAscii = 0
   tAMPM.SelStart = 0
   tAMPM.SelLength = 2
End If
End Sub

Sub tAMPM_LostFocus ()
If tAMPM.Text <> "am" And tAMPM.Text <> "pm" Then
   tAMPM.Text = "am"
End If

End Sub

Sub tDay_GotFocus ()
tDay.SelStart = 0
tDay.SelLength = 2
Active$ = "d"
End Sub

Sub tDay_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If

End Sub

Sub tDay_LostFocus ()
tVal = Val(tDay.Text)
If tVal < 1 Or tVal > 31 Then
   tVal = 1
End If
tDay.Text = Format$(tVal, "00")
End Sub

Sub tHour_GotFocus ()
tHour.SelStart = 0
tHour.SelLength = 2
Active$ = "h"
End Sub

Sub tHour_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If

End Sub

Sub tHour_LostFocus ()
tVal = Val(tHour.Text)
If tVal < 1 Or tVal > 12 Then
   tVal = 12
End If
tHour.Text = Format$(tVal, "0")
End Sub

Sub tMinute_GotFocus ()
tMinute.SelStart = 0
tMinute.SelLength = 2
Active$ = "m"
End Sub

Sub tMinute_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If

End Sub

Sub tMinute_LostFocus ()
tVal = Val(tMinute.Text)
If tVal <= 0 Or tVal > 59 Then
   tVal = 0
End If
tMinute.Text = Format$(tVal, "00")
End Sub

Sub tMonth_GotFocus ()
tMonth.SelStart = 0
tMonth.SelLength = 2
Active$ = "n"
End Sub

Sub tMonth_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If
End Sub

Sub tMonth_LostFocus ()
tVal = Val(tMonth.Text)
If tVal < 1 Or tVal > 12 Then
   tVal = 12
End If
tMonth.Text = Format$(tVal, "00")
End Sub

Sub tSecond_GotFocus ()
tSecond.SelStart = 0
tSecond.SelLength = 2
Active$ = "s"
End Sub

Sub tSecond_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If
End Sub

Sub tSecond_LostFocus ()
tVal = Val(tSecond.Text)
If tVal <= 0 Or tVal > 59 Then
   tVal = 0
End If
tSecond.Text = Format$(tVal, "00")
End Sub

Sub tYear_GotFocus ()
tYear.SelStart = 0
tYear.SelLength = 4
Active$ = "y"
End Sub

Sub tYear_KeyPress (KeyAscii As Integer)
If KeyAscii >= 32 Then
   If KeyAscii < Asc("0") Or KeyAscii > Asc("9") Then KeyAscii = 0
End If

End Sub

Sub tYear_LostFocus ()
tVal = Val(tYear.Text)
If tVal < 100 Then tVal = tVal + 1900
If tVal < 1980 Or tVal > 2050 Then
   tVal = 1980
End If
tYear.Text = Format$(tVal, "0000")
End Sub

