[StepOne] 
' ----- APPLICATIONSTART ----------------------------------------------------------
' This application controls StepOne installation interpreter from 
' Markus Kreisel and Renate Reinartz.
' Vendor: See Program
' Please don't change this file!!
' ---------------------------------------------------------------------------------------

language "windows"		' initialisize language
if "win" 310
	void
	goto This_version_dont_works_with_Win300_sorrymessage

gosub init                      ' intitialisation
gosub welcome			' welcome screen
gosub check_lib                 ' check for libs
gosub app_active		' check, if Shih Tao is loaded
gosub select_path		' select path for installation
gosub copy			' copy files
gosub progman			' install icons in Program Manager
gosub iniedit			' edit the shihtao.ini
gosub complete			' installation complete
gosub cleanup			' cleanup temp files
end
' ----- PROGRAM END --------------------------------------------------------------------


' ----- Subroutines ------------------------------------------------------------------
[init]
{
	Copyright			' show copyright dialog
	
	language english	
			
	let "version" 1,50	
	let "prg" shihtao
	let "prgname" Shih Tao
	
	color 12			' 12 = light red
	txtsize 10			' initialize font size
	
	target "" windows		' initialize target path
	source "" runpath		' initialize source path
	let "copyspace" 300000 		' length of files to copy
	
	space "0" windows		' length of files to copy in Windows path
	space "70000" system		' length of files to copy in System path
	space "400000" target		' length of files to copy in target path
		
}
' ---------------------------------------------------------------------------------------
[welcome]
{
	gosub load_picture shihinst.rl_ shihinst.rle
	banner "Welcome..."
	wndshow "{prgname} Installation"
	wndtxt "Welcome to installation@of {prgname} version {version} for Windows." ok
}
' ---------------------------------------------------------------------------------------
[check_lib]
{
	banner "Check libs"        
	wndtxt "Shih Tao needs Custom Controls from the threed.vbx file in your system directory. " +
	wndtxt "Some installations copy this libraries into the windows " +
	wndtxt "directory of your system. This isnt the correct location. " +
	wndtxt "StepOne is able to move the needed Controls from " +
	wndtxt "windows directory to system directory. " +
	wndtxt "StepOne will ask for permission before moving threed.vbx. " +
	wndtxt "While moving StepOne checks the file for version info and date. " +
	wndtxt "After the installation you will find the newest Version of " +
	wndtxt "threed.vbx in your windows directory." ok

	gosub lib_verify threed.vbx
}
[lib_verify]
parameter dateiname
{
	
	gosub task_verify {lib_verify.dateiname}

	exist "[windows]\{lib_verify.dateiname}"
		void
		return

	selection "Move {lib_verify.dateiname}?~Yes~No~[END]~0~1" variable
	if "{variable}" 0
		void
		return

	copy "[windows]\{lib_verify.dateiname}~[system]\{lib_verify.dateiname}~"
	del "[windows]\{lib_verify.dateiname}"
}

[task_verify]
parameter dateiname
{

	[retry]
	taskactive "{task_verify.dateiname}"
		void
		Return

	askbox "{task_verify.dateiname} is in use. Cancel the Task using the file then press OK. Cancel will stop the installation."
		goto retry
		gosub ins_cancel
	
}

[select_path]
{
	banner "Select target path"
	wndtxt "StepOne will copy files to your harddisk. " +
	wndtxt "Please select the path where {prgname} should be installed. " cont
	target "" windows
	cd ".."
	iniread "[windows]\win.ini~KRS~{prg}Path~[target]\{prg}"
	inputbox "Select target path~Please select a path:~[stack]" path
	target "" stack
	iniedit "[windows]\win.ini~KRS~{prg}Path~[stack]"
}

' ---------------------------------------------------------------------------------------	
[app_active]
{
	taskactive "[target]\{prg}.exe"
	goto prg_active
	goto prg_not_active
	[prg_active]
	banner "{prgname} aktive"
	wndtxt "" delete
	askbox "{prgname} is aktive. Choose `Yes` to close " +
	askbox "{prgname} or `No` to exit installation." yes
		taskclose "{prg}.exe"
		goto ins_cancel
	taskactive "[target]\{prg}.exe"
		goto prg_active
		goto prg_not_active
	[prg_not_active]
	banner "Copying..."
	wndtxt "" delete
}
' ---------------------------------------------------------------------------------------
[copy]
{
	copygo "{copyspace}"
		copy "[source]\{prg}.ex_~[target]\{prg}.exe~The program.@Youll play it day and night."
		copy "[source]\{prg}.hl_~[target]\{prg}.hlp~Onlinehelp. Here youll find help for all situation (especially for {prgname})."
		copy "[source]\shresdll.dl_~[target]\shresdll.dll~
		copy "[source]\{prg}.rl_~[target]\{prg}.rle~
		copy "[source]\readme.txt~[target]\readme.txt~"
		copy "[source]\threed.vb_~[system]\threed.vbx~
		cd "symbol"
		gosub symbol_copy shihtao
		gosub symbol_copy quadro
		gosub symbol_copy modern
		gosub symbol_copy far_east
		cd ".."
	copystop 
	copystatus
		void
		gosub copyerror
}
' ---------------------------------------------------------------------------------------
[symbol_copy]
parameter q
{
	copy "[source]\{symbol_copy.q}._~[target]\{symbol_copy.q}~Different sets of symbols."
	copy "[source]\{symbol_copy.q}.2_~[target]\{symbol_copy.q}.2~"
	copy "[source]\{symbol_copy.q}.3_~[target]\{symbol_copy.q}.3~"
	copy "[source]\{symbol_copy.q}.4_~[target]\{symbol_copy.q}.4~"
	copy "[source]\{symbol_copy.q}.5_~[target]\{symbol_copy.q}.5~"
	copy "[source]\{symbol_copy.q}.6_~[target]\{symbol_copy.q}.6~"
}
' ---------------------------------------------------------------------------------------
[progman]
{
	banner "Install icons..."
	wndtxt "Installation program will install icons in " +
	wndtxt "Windows Program Manager. " +
	wndtxt "During installation of icons installation screen " +
	wndtxt "will be hidden..." ok
	wndhide
	wndtxt "" delete
	prgmanreplace "[target]\{prg}.exe~KRS~{prgname} for Windows" 
	prgmanreplace "[target]\readme.txt~KRS~{prgname} last infos"
	wndshow
}
' ---------------------------------------------------------------------------------------
[iniedit]
{
	
	iniedit "[windows]\win.ini~Extensions~ga,~[target]\{prg}.exe ^.gam"
	iniedit "[target]\{prg}.ini~{prg}~SymbolPath~[target]\symbol"	
	iniedit "[target]\{prg}.ini~{prg}~GameFilesPath~[target]\gam"
	RegBaseEdit ".GAM~ShihTaoGame"
	RegBaseEdit "ShihTaoGame~{prgname} Game file"
	RegBaseEdit "ShihTaoGame\shell\open\command~[target]\{prg}.exe"
	RegBaseEdit "ShihTaoGame\shell\open\ddeexec~open %1"
	RegBaseEdit "ShihTaoGame\shell\open\ddeexec\application~{prg}"
	RegBaseEdit "ShihTaoGame\shell\open\ddeexec\topic~shibrett"
	
}
' ---------------------------------------------------------------------------------------
[complete]
{
	exist "[target]\{prg}.exe"
		void
		goto ins_error
	wndshow
	banner "Last news"
	wndtxt "[target]\readme.txt" file	
	banner "Heureka..."
	wndtxt "Installation is successfully completed.@" +
	wndtxt "Start {prgname} with a doubleclick on {prgname} icon " +
	wndtxt "in Program Manager group {gruppe}.@@" 
	wndtxt "Note: After ending StepOne there may be a short break, when " +
        wndtxt "program LastStep deletes temp files for installation." end
	wndhide
}
' ---------------------------------------------------------------------------------------
[copyerror]
{
	banner "Ouch..."
	wndtxt "Program end.@" +
	wndtxt "Not all files could be copied." +
	wndtxt "Perhaps {prgname} will not work correctly." ok
	goto ins_error
}
' ---------------------------------------------------------------------------------------
[load_picture]
parameter p1,p2
{
	copy "[source]\{load_picture.p1}~[temp]\{load_picture.p2}~" 
	picload "[temp]\{load_picture.p2}"
	del "[temp]\{load_picture.p2}" 
}

[This_version_dont_works_with_Win300_sorrymessage]
{
	Msgbox "{prgname} requires at least Windows 3.1. Installation will be canceled." OK
	goto ins_error
}

[cleanup]
{
	shell "[source]\laststep.exe~[windows]\stepone.exe [windows]\soresdll.dll"
}

' --- SYSTEMLABEL -----------------------------------------------------------------------
[ins_error]
	wndshow "Error"
	beep 1
	banner "Error!"
	wndtxt "There is an error accounted. " +
	wndtxt "Restart Windows and try again." OK
	wndtxt "If the problems will accounted again, please ask " +
	wndtxt "the support:@Markus Kreisel & Renate Reinartz@Homburger Str. 22@50969 Koeln@Federal Republic of Germany@CompuServe 100116,2133@@or ask your vendor" end
	gosub cleanup
	end
' ---------------------------------------------------------------------------------------
[ins_cancel]
	wndshow "Error"
	beep 1
	banner "Cancel!"
	wndtxt "You have canceled installation. {prgname} will " +
	wndtxt "not work properly. " end
	gosub cleanup
	end
' ---------------------------------------------------------------------------------------
