/***********************************************************************/
/* THE.C - The Hessling Editor                                         */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\the.c 1.4 1993/09/01 16:27:17 MH Interim MH $
*/

#include <stdio.h>

#define MAIN 1
#include "the.h"
#include "proto.h"
#include <signal.h>

#if defined(DOS) || defined(OS2)
#  if !defined(EMX) && !defined(GO32)
#    include <direct.h>
#  endif
#endif

/*--------------------------- global data -----------------------------*/
 WINDOW *foot,*error_window,*divider;
 VIEW_DETAILS *vd_current=(VIEW_DETAILS *)NULL;
 VIEW_DETAILS *vd_first=(VIEW_DETAILS *)NULL;
 VIEW_DETAILS *vd_mark=(VIEW_DETAILS *)NULL;
 char number_of_views = 0;                          /* number of views */
 char number_of_files = 0;                          /* number of files */
 char display_screens = 1;                        /* number of screens */
 char current_screen = 0;
 SCREEN_DETAILS screen[MAX_SCREENS];            /* 2 screen structures */
 bool horizontal=TRUE;
 short save_coord_x[VIEW_WINDOWS];
 short save_coord_y[VIEW_WINDOWS];

 LINE *next_line,*curr_line;
 LINE *first_file_name=NULL,*current_file_name=NULL;
 bool error_on_screen=FALSE;
 bool colour_support=TRUE;         /* indicates if colour is supported */
 char *rec;
 unsigned short rec_len = 0;                          /* length of rec */
 char *cmd_rec;
 unsigned short cmd_rec_len = 0;                  /* length of cmd_rec */
 char *pre_rec;
 unsigned short pre_rec_len = 0;                  /* length of cmd_rec */
 char focus_changed = NO;   /* indicates if focus line has changed */
 char current_changed = NO; /* indicates if current line has changed */
 char mode_insert=NO;           /* defines insert mode toggle */
 char in_profile;          /* indicates if processing profile */
 char execute_profile; /* indicates if we are to process any profile */
 char in_macro;         /* indicates if processing REXX macro */
 char file_read=NO;     /* indicates if we have read the file */
 char curses_started=NO;  /* indicates if cureses has started */

#if defined(DOS) || defined(OS2)
 bool extended_display_mode=TRUE;      /* display all 256 characters ? */
#else
 bool extended_display_mode=FALSE;     /* display all 256 characters ? */
#endif

 char *the_version = (char *)"1.5";
 char term_name[20];  /* $TERM value */
#if defined(UNIX)
 char user_home_dir[MAX_FILE_NAME+1];
#   define THE_PROFILE_FILE ".therc"
#else
#   define THE_PROFILE_FILE "PROFILE.THE"
#endif
 char *helpfilename = (char *)"THE.HLP";
 char *tempfilename = (char *)"THE.$$$";
#if !defined(NOREXX)
 char *rexxoutname = (char *)"REXX.$$$";
 char rexx_pathname[MAX_FILE_NAME+1];
 char rexx_filename[10];
#endif
#ifdef VMS
 char *dirfilename = (char *)"DIR.THE";
#else
 char *dirfilename = (char *)"DIR.DIR";
#endif
 char macro_suffix[12] = ".the";  /* default extension for macros */
 char dir_pathname[MAX_FILE_NAME+1];
 char dir_filename[10];
 char curr_path[MAX_FILE_NAME+1];
 char sp_path[MAX_FILE_NAME+1];
 char sp_fname[MAX_FILE_NAME+1];
 char dir_path[MAX_FILE_NAME+1];   /* for dir and ls commands */

 char the_home_dir[MAX_FILE_NAME+1];
 char the_macro_path[MAX_FILE_NAME+1];   /* for macro command */
 char the_help_file[MAX_FILE_NAME+1];
 char the_profile_file[MAX_FILE_NAME+1];

 char *prf_arg=(char *)NULL;
 bool profile_specified=FALSE;

 char tabkey_insert='C';
 char tabkey_overwrite='T';
 unsigned short file_start = 36;
 char *last_target;

#if defined(UNIX) || defined(OS2)
 char *spooler_name;
#endif

char file_disposition;

struct stat stat_buf;

int reserved_top=0;
int reserved_bottom=0;

int lastrc=0;
extern DEFINE *first_define;
#if !defined(NOREXX)
extern LINE *first_prefix_synonym;
#endif
/*---------------------------------------------------------------------*/
/* Following are for getopt function(s).                               */
/*---------------------------------------------------------------------*/
extern char *optarg;
extern int optind;

/***********************************************************************/
#ifdef PROTO
int main(int argc, char *argv[])
#else
int main(argc,argv)
int argc;
char *argv[];
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern bool CLEARSCREENx;
/*---------------------- function definitions -------------------------*/

/*--------------------------- local data ------------------------------*/
 register int i,j,k;
 char *prf=(char *)NULL;
 int c;
 int malloc_fd;
 bool trap_signals=TRUE;
 bool pause_for_errors=FALSE;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef __EMX__
 _wildcard(&argc,&argv);
#endif
#ifdef TRACE
 trace_initialise();
 trace_function("the.c:     main");
#endif
/*---------------------------------------------------------------------*/
/* Set up flag to indicate that we are not interactive...yet.          */
/*---------------------------------------------------------------------*/
 in_profile = TRUE;
 execute_profile = TRUE;
 in_macro = FALSE;
/*---------------------------------------------------------------------*/
/* Initialise the printer spooler.                                     */
/*---------------------------------------------------------------------*/
#if defined(UNIX) || defined(OS2)
 if ((spooler_name = (char *)malloc(4*sizeof(char))) == NULL)
   {
    display_error(30,(char *)"");
    exit_clean(1);
   }
#  ifdef UNIX
 strcpy(spooler_name,(char *)"lpr");
#  else
 strcpy(spooler_name,(char *)"LPT1");
#  endif
#endif
/*---------------------------------------------------------------------*/
/* Get all environment variables here. Some may be overridden by       */
/* command-line switches. (future possibility)                        */
/*---------------------------------------------------------------------*/
#if defined(UNIX)
 if (getenv("HOME") != NULL)
    strcpy(user_home_dir,getenv("HOME"));
 else
    strcpy(user_home_dir,"./");
 if (*(user_home_dir+strlen(user_home_dir)-1) != ISLASH)
    strcat(user_home_dir,ISTR_SLASH);
 if (getenv("TERM") != NULL)
    strcpy(term_name,getenv("TERM"));
 else
    strcpy(term_name,"default");
#endif
#if defined(DOS)
 strcpy(term_name,"DOS");
#endif
#if defined(OS2)
 strcpy(term_name,"OS2");
#endif
/*---------------------------------------------------------------------*/
/* Get THE_HOME_DIR first (as all other paths rely on this value)      */
/*---------------------------------------------------------------------*/
 if (getenv("THE_HOME_DIR") != NULL)
   {
    strcpy(the_home_dir,getenv("THE_HOME_DIR"));
    (void *)strtrans(the_home_dir,OSLASH,ISLASH);
    if ((the_home_dir[strlen(the_home_dir)-1]) != ISLASH)
       strcat(the_home_dir,ISTR_SLASH);
   }
 else
   {
#if defined(UNIX)
    strcpy(the_home_dir,THE_HOME_DIRECTORY);
#else
    strcpy(the_home_dir,argv[0]);
    (void *)strtrans(the_home_dir,OSLASH,ISLASH);
    i = strzreveq(the_home_dir,ISLASH);
    if (i != (-1))
       the_home_dir[i+1] = '\0';
    else
       the_home_dir[0] = '\0';
#endif
   }
/*---------------------------------------------------------------------*/
/* Get THE_MACRO_PATH environment variable. If not set set up default  */
/* to be THE_HOME_DIR followed by the current directory.               */
/*---------------------------------------------------------------------*/
 if (getenv("THE_MACRO_PATH") != NULL)
    strcpy(the_macro_path,getenv("THE_MACRO_PATH"));
 else
   {
    strcpy(the_macro_path,the_home_dir);
#if defined(UNIX)
    strcat(the_macro_path,":.");
#else
    strcat(the_macro_path,";.");
#endif
   }
 (void *)strtrans(the_macro_path,OSLASH,ISLASH);
#ifdef VMS
 strcpy(the_macro_path,"");
#endif
/*---------------------------------------------------------------------*/
/* Set up help file name.                                              */
/*---------------------------------------------------------------------*/
 if (getenv("THE_HELP_FILE") != NULL)
    strcpy(the_help_file,getenv("THE_HELP_FILE"));
 else
   {
    strcpy(the_help_file,the_home_dir);
    strcat(the_help_file,term_name);
    strcat(the_help_file,".hlp");
   }
 (void *)strtrans(the_help_file,OSLASH,ISLASH);
/*---------------------------------------------------------------------*/
/* Set up profile file name.                                           */
/*---------------------------------------------------------------------*/
 if (getenv("THE_PROFILE_FILE") != NULL)
    strcpy(the_profile_file,getenv("THE_PROFILE_FILE"));
 else
   {
#if defined(UNIX)
    strcpy(the_profile_file,user_home_dir);
#else
    strcpy(the_profile_file,the_home_dir);
#endif
    strcat(the_profile_file,THE_PROFILE_FILE);
   }
 (void *)strtrans(the_profile_file,OSLASH,ISLASH);
/*---------------------------------------------------------------------*/
/* Process the command line arguments.                                 */
/*---------------------------------------------------------------------*/
 while ((c = getopt(argc,argv,"smnp:w:a:h?")) != EOF)
   switch((char)c)
     {
      case 's':        /* don't trap signals */
               trap_signals = FALSE;
               break;
      case 'm':        /* force into MONO */
               colour_support = FALSE;
               break;
      case 'n':        /* do not execute any profile file */
               execute_profile = FALSE;
               break;
      case 'p':        /* profile file name */
               if ((prf = (char *)malloc((strlen(optarg)+1)*sizeof(char))) == NULL)
                 {
                  display_error(30,(char *)"");
                  exit_clean(1);
                 }
               strcpy(prf,optarg);
               break;
      case 'a':        /* profile arguments */
               if ((prf_arg = (char *)malloc((strlen(optarg)+1)*sizeof(char))) == NULL)
                 {
                  display_error(30,(char *)"");
                  exit_clean(1);
                 }
               strcpy(prf_arg,optarg);
               break;
      case 'w':        /* width of line */
               max_line_length = (short)atoi(optarg);
               if (max_line_length < 10)
                 {
                  display_error(5,(char *)"width MUST be >= 10");
                  exit_clean(1);
                 }
               break;
      case 'h':
      case '?':
               display_info(argv[0]);
               exit_clean(0);
               break;
      default:
               break;
     }

 if (optind<argc)
   {
    while(optind<argc)
      {
       if ((current_file_name = add_line(first_file_name,
                                         current_file_name,
                                         strtrans(argv[optind],OSLASH,ISLASH),
                                         strlen(argv[optind]))) == NULL)
           {
            display_error(30,(char *)"");
            exit_clean(1);
           }
       if (first_file_name == NULL)
          first_file_name = current_file_name;
       optind++;
      }
   }
 else
   {
    if ((current_file_name = add_line(first_file_name,
                                      current_file_name,
                                      CURRENT_DIR,
                                      strlen(CURRENT_DIR))) == NULL)
        {
         display_error(30,(char *)"");
         exit_clean(1);
        }
    if (first_file_name == NULL)
       first_file_name = current_file_name;
   }
/*---------------------------------------------------------------------*/
/* Override any default paths,filenames etc if supplied on command line*/
/*---------------------------------------------------------------------*/
 if (prf != NULL)
   {
    strcpy(the_profile_file,prf);
    (void *)strtrans(the_profile_file,OSLASH,ISLASH);
    profile_specified = TRUE;
   }
/*---------------------------------------------------------------------*/
/* Allocate some memory to last_target and set it to a blank value.    */
/*---------------------------------------------------------------------*/
 if ((last_target = (char *)malloc(80*sizeof(char))) == NULL)
    exit_clean(1);
 strcpy(last_target,"");
/*---------------------------------------------------------------------*/
/* Allocate some memory to rec.                                        */
/*---------------------------------------------------------------------*/
 if ((rec = (char *)malloc((max_line_length+1)*sizeof(char))) == NULL)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Allocate some memory for temporary space...                         */
/*---------------------------------------------------------------------*/
 if (allocate_temp_space(max_line_length,TEMP_PARAM) != RC_OK)
    exit_clean(1);
 if (allocate_temp_space(max_line_length,TEMP_TMP_CMD) != RC_OK)
    exit_clean(1);
 if (allocate_temp_space(max_line_length,TEMP_TEMP_CMD) != RC_OK)
    exit_clean(1);
/* if (allocate_temp_space(max_line_length,TEMP_MACRO) != RC_OK)
    exit_clean(1);*/
/*---------------------------------------------------------------------*/
/* Allocate memory to pre_rec and set it to blanks.                    */
/*---------------------------------------------------------------------*/
 if ((pre_rec = (char *)malloc((PREFIX_WIDTH+1)*sizeof(char))) == NULL)
    exit_clean(1);
 memset(pre_rec,' ',PREFIX_WIDTH+1);
 pre_rec_len = 0;
/*---------------------------------------------------------------------*/
/* Determine the current working directory.                            */
/* Do this before any other file setting up so that we don't change the*/
/* current directory from the default.                                 */
/*---------------------------------------------------------------------*/
#if defined(EMX)
 _getcwd2(curr_path,MAX_FILE_NAME);
#else
 getcwd(curr_path,MAX_FILE_NAME);
#endif
/*---------------------------------------------------------------------*/
/* Set up filename for directory temporary file (DIR.DIR).             */
/* Set up filename for REXX capture file (REXX.$$$).                   */
/*---------------------------------------------------------------------*/
#ifdef UNIX
 strcpy(dir_pathname,user_home_dir);
#endif
#if defined(DOS) || defined(OS2)
 strcpy(dir_pathname,ISTR_SLASH);
#endif
#ifdef VMS
 strcpy(dir_pathname,"");
#endif

#if !defined(NOREXX)
 strcpy(rexx_pathname,dir_pathname);
#endif

 strcat(dir_pathname,dirfilename);
 if (splitpath(dir_pathname) != RC_OK)
    exit_clean(1);
 strcpy(dir_pathname,sp_path);
 strcpy(dir_filename,sp_fname);

#if !defined(NOREXX)
 strcat(rexx_pathname,rexxoutname);
 if (splitpath(rexx_pathname) != RC_OK)
    exit_clean(1);
 strcpy(rexx_pathname,sp_path);
 strcpy(rexx_filename,sp_fname);
#endif
/*---------------------------------------------------------------------*/
/* Set up default values for SET commands etc.                         */
/*---------------------------------------------------------------------*/
 set_defaults();
/*---------------------------------------------------------------------*/
/* Set up initial colours to 0.                                        */
/*---------------------------------------------------------------------*/
 for (i=0;i<ATTR_MAX;i++)
     colour[i] = (chtype)0;
/*---------------------------------------------------------------------*/
/* Initialise command array to empty strings.                          */
/*---------------------------------------------------------------------*/
 init_command();
/*---------------------------------------------------------------------*/
/* Initialise rexx support if appropriate.                             */
/*---------------------------------------------------------------------*/
#if !defined(NOREXX)
 if (initialise_rexx() != RC_OK)
   {
    display_error(54,(char *)"");
    exit_clean(6);
   }
#endif
/*---------------------------------------------------------------------*/
/* Read each file into memory and apply the profile file to each of the*/
/* files.                                                              */
/*---------------------------------------------------------------------*/
 current_file_name = first_file_name;
 while(current_file_name != NULL)
   {
   if ((rc = get_file(current_file_name->line)) != RC_OK)
     {
      if (rc == RC_DISK_FULL)
         display_error(57,(char *)"...probably");
      exit_clean(2);
     }
   pre_process_line(0L);
   if (execute_profile)
     {
      (void)get_profile(prf_arg);
      if (error_on_screen)
        {
         pause_for_errors = TRUE;
         error_on_screen = FALSE;
        }
     }
   current_file_name = current_file_name->next;
   }
 if (number_of_files == 0)
    exit_clean(0);
#ifdef USE_VOID
 ll_free((void *)first_file_name);
#else
 lll_free(first_file_name);
#endif
 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;
 pre_process_line(CURRENT_VIEW->focus_line);
 CURRENT_VIEW->current_window = WINDOW_COMMAND;

/*---------------------------------------------------------------------*/
/* If we have had an error in the profile file we need to pause so the */
/* user sees the messages. This pause should only occur if the number  */
/* of files > 0. ie the profile file does not contain a 'file' or 'quit*/
/* command.                                                            */
/*---------------------------------------------------------------------*/
 if (pause_for_errors && number_of_files != 0)
   {
    fprintf(stderr,"\n%s","Hit RETURN to continue...");
    fflush(stderr);
    (void)getchar();
    error_on_screen = FALSE;
   }

/*---------------------------------------------------------------------*/
/* Trap signals to exit gracefully, unless user has specified they not */
/* be trapped.                                                         */
/*---------------------------------------------------------------------*/
 if (trap_signals)
    init_signals();
/*---------------------------------------------------------------------*/
/* Start up curses. This allows profile commands to be processed before*/
/* curses starts.                                                      */
/*---------------------------------------------------------------------*/
 initscr();
 curses_started = YES;
/*---------------------------------------------------------------------*/
/* Determine if colour support available.                              */
/*---------------------------------------------------------------------*/
 if (colour_support) /* if default setting not overridden on command line */
   {
    colour_support = FALSE;
#ifdef A_COLOR
    if (has_colors())
      {
       start_color();
       colour_support = TRUE;
      }
#endif
   }
/*---------------------------------------------------------------------*/
/* Set various terminal characteristics...                             */
/*---------------------------------------------------------------------*/
#if !defined(VMS)
 cbreak();
#endif
#if !defined(MINIX)
 raw();
#endif
#if defined(USE_EXTCURSES)
 extended(FALSE);
#endif
#if defined(DOS) || defined(OS2)
 raw_output(TRUE);
#endif
 nonl();
 noecho();
#if !defined(NO_KEYPAD)
 keypad(stdscr,TRUE);
#endif
/*---------------------------------------------------------------------*/
/* Set up default colours for each window component.                   */
/*---------------------------------------------------------------------*/
 set_default_colours();
/*---------------------------------------------------------------------*/
/* We are now finished with profile commands.                          */
/*---------------------------------------------------------------------*/
 in_profile = FALSE;
/*---------------------------------------------------------------------*/
/* Call insertmode command to set default mode to whatever the current */
/* setting is. If set in profile, could be anything.                   */
/* Run AFTER initscr() as it uses curs_set().                          */
/*---------------------------------------------------------------------*/
 Insertmode(mode_insert ? (char *)"ON" : (char *)"OFF");
/*---------------------------------------------------------------------*/
/* Allocate memory to cmd_rec and set it to blanks.                    */
/* This is done here so that COLS is valid; set up by initscr().       */
/*---------------------------------------------------------------------*/
 if ((cmd_rec = (char *)malloc((COLS+1)*sizeof(char))) == NULL)
    exit_clean(1);
 memset(cmd_rec,' ',COLS);
 cmd_rec_len = 0;
/*---------------------------------------------------------------------*/
/* Set up screen default sizes.                                        */
/*---------------------------------------------------------------------*/
 set_screen_defaults();
/*---------------------------------------------------------------------*/
/* For each file being edited, set up the curses windows for each of  */
/* them.                                                               */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;
 while(CURRENT_VIEW != NULL)
   {
    if (set_up_windows() != RC_OK)
       exit_clean(1);
    CURRENT_VIEW = CURRENT_VIEW->next;
   }
 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;
 pre_process_line(CURRENT_VIEW->focus_line);
 CURRENT_VIEW->current_window = WINDOW_COMMAND;
/*---------------------------------------------------------------------*/
/* Set up the other "global" windows.                                  */
/*---------------------------------------------------------------------*/
 foot = newwin(1,COLS,LINES-1,0);
 error_window = newwin(1,COLS,LINES-1,0);
 divider = newwin(LINES-1,2,0,(COLS/2)-1);
 wattrset(foot,colour[ATTR_STATAREA]);
 wattrset(error_window,colour[ATTR_MSGLINE]);
 wattrset(divider,colour[ATTR_DIVIDER]);

 clear_footing();
 wmove(divider,0,0);
 for (i=0;i<LINES-1;i++)
    mvwaddstr(divider,i,0,"||");
/*---------------------------------------------------------------------*/
/* This is where it all happens.                                       */
/*---------------------------------------------------------------------*/
 editor();
/*---------------------------------------------------------------------*/
/* Finalise rexx support if appropriate.                               */
/*---------------------------------------------------------------------*/
#if !defined(NOREXX)
 finalise_rexx();
#endif
/*---------------------------------------------------------------------*/
/* Get rid of any temporary directory file or REXX capture file.       */
/*---------------------------------------------------------------------*/
 strcpy(sp_path,dir_pathname);
 strcat(sp_path,dir_filename);
 remove_file(sp_path);

#if !defined(NOREXX)
 strcpy(sp_path,rexx_pathname);
 strcat(sp_path,rexx_filename);
 remove_file(sp_path);
#endif
/*---------------------------------------------------------------------*/
/* Free up the dynamically allocated memory.                           */
/*---------------------------------------------------------------------*/
 if (first_define != NULL)
    first_define = dll_free(first_define);
#if !defined(NOREXX)
 if (first_prefix_synonym != NULL)
    first_prefix_synonym = lll_free(first_prefix_synonym);
#endif
 free(last_target);
 free(rec);
 free(cmd_rec);
/*---------------------------------------------------------------------*/
/* Free memory for temp_params and tmp_cmd                             */
/*---------------------------------------------------------------------*/
 free_temp_space(TEMP_PARAM);
 free_temp_space(TEMP_MACRO);
 free_temp_space(TEMP_TEMP_CMD);
 free_temp_space(TEMP_TMP_CMD);

 if (prf != (char*)NULL)
    free(prf);
 if (prf_arg != (char*)NULL)
    free(prf_arg);
 add_to_recovery_list(NULL,(-1));      /* frees up memory for recovery */

#if defined(UNIX) || defined(OS2)
 free(spooler_name);
#endif

 delwin(divider);
 delwin(error_window);
/*---------------------------------------------------------------------*/
/* If the user wants a clearscreen done before exiting, do it...       */
/*---------------------------------------------------------------------*/
 if (CLEARSCREENx)
   {
    wclear(stdscr);
    move(0,0);
    attrset(A_NORMAL);
    refresh();
   }
 else
/*---------------------------------------------------------------------*/
/* ...otherwise, get the cursor to the bottom line.                    */
/*---------------------------------------------------------------------*/
   {
    wattrset(foot,A_NORMAL);
    mvwaddstr(foot,0,0,"THE - END");
    wrefresh(foot);
   }
 delwin(foot);
 exit_clean(0);
}
/***********************************************************************/
#ifdef PROTO
void init_signals(void)
#else
void init_signals()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     init_signals");
#endif
#ifdef UNIX
 signal(SIGQUIT,handle_signal);
 signal(SIGHUP,handle_signal);
 signal(SIGABRT,handle_signal);
 signal(SIGFPE,handle_signal);
 signal(SIGSEGV,handle_signal);
 signal(SIGINT,handle_signal);
 signal(SIGTERM,handle_signal);
#if defined(SIGBUS)
 signal(SIGBUS,handle_signal);
#endif
#endif
#ifdef TRACE
 trace_return();
#endif
 return;
}
#ifdef UNIX
/***********************************************************************/
#ifdef PROTO
void handle_signal(int err)
#else
void handle_signal(err)
int err;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     handle_signal");
#endif
 endwin();
 fprintf(stderr,"\nTHE terminated with signal: %d\n\n",err);
 exit_clean(2);
}
#endif
/***********************************************************************/
#ifdef PROTO
void display_info(char *argv0)
#else
void display_info(argv0)
char *argv0;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/

 fprintf(stderr,"\nTHE %s Copyright (C) 1991-1993 Mark Hessling. All rights reserved.\n",the_version);
 fprintf(stderr,"THE is distributed under the terms of the GNU General Public License \n");
 fprintf(stderr,"and comes with NO WARRANTY. See the file COPYING for details.\n");
 fprintf(stderr,"\nUsage:\n\n%s [-h?nms] [-p profile] [-a profile_arg] [-w width] [[dir] [file [...]]]\n",argv0);
 fprintf(stderr,"\nwhere:\n\n");
 fprintf(stderr,"-h,-?                  show this message\n");
 fprintf(stderr,"-n                     do not execute a profile file\n");
 fprintf(stderr,"-m                     force display into mono\n");
 fprintf(stderr,"-s                     turn off signal trapping (Unix only)\n");
 fprintf(stderr,"-p profile             filename of profile file\n");
 fprintf(stderr,"-a profile_arg         argument(s) to profile file (only with REXX)\n");
 fprintf(stderr,"-w width               maximum width of line (default 2048)\n");
 fprintf(stderr,"[dir [file [...]]]     file(s) and/or directory to be edited\n\n");
 fflush(stderr);
 return;
}
/***********************************************************************/
#ifdef PROTO
void exit_clean(short err_num)
#else
void exit_clean(err_num)
short err_num;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern bool CLEARSCREENx;
/*--------------------------- local data ------------------------------*/
#ifdef DOS
char get_mode(void);
#endif
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     exit_clean");
#endif

 if (curses_started)
   {
    mode_insert=NO;
    draw_cursor(ON);
#ifdef BSD
    nl();
    echo();
#endif
    endwin();
   }
 if (!CLEARSCREENx)
    printf("\n");
 if (file_exists(tempfilename))
    remove_file(tempfilename);
#ifdef TRACE
 trace_return();
#endif
 exit(err_num);
}
