/*
   
                                  STRPLINE
                                Version 1.12
           Copyright (c) Bob Swift, 1988-1993.  All Rights Reserved.
                   Compiled with the Borland C++ compiler.
   
   This program is designed to read an input text file and strip out all
   lines beginning with one of a series of patterns given in a configuration
   file.  The configuration file is a simple text file with each match
   pattern on a separate line.  Any line in the configuration file that
   begins with a caret (^) is considered to be a comment line and will not
   be processed.  The program creates a backup file called filename.BAK
   prior to beginning the stripping operation.  This file is left upon
   completion of the program.

   The format for using this program is as follows:

   
        STRPLINE <filename> [configfile]
   
   where <filename>   is the name of the text file to be stripped
         [configfile] is the file containing the patters to match
                      default is STRPLINE.CFG in the current directory
   
   
   The text file to be stripped must be in the current directory.  The
   configuration may be specified with a full drive and path.  If the
   configuration file is not specified, it will default to STRPLINE.CFG
   in the current directory.  You are allowed a maximum of 256 search
   patterns of 40 characters maximum.
   
   The program will display a VERY brief set of instructions if it is called
   without any arguments or if it encounters an error.  The following is a
   list of the error codes returned by the program:
   
                  0 - No errors.  Normal termination.
                  1 - Missing or extra command line arguments.
                  2 - Unable to open the input file.
                  3 - Unable to open the output file.
                  4 - Problem writing to output file.
                  5 - Problem closing input file.
                  6 - Problem closing output file.
                  7 - Input file not in current directory.
                  8 - Unable to open configuration file.
                  9 - Problem closing configuration file.
                 10 - No patterns in configuration file to strip.
                 11 - Unable to open backup file.
   
   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.
   
   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:
   
            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.
            
            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.
            
            - If you find the program useful, I ask that you do 
              something to brighten somebody else's day.  Just 
              exactly what, I will leave up to you.

   
   You may freely distribute this program provided that you distribute only 
   the complete archive which includes the STRPLINE.EXE, STRPLINE.C,
   STRPLINE.CFG and STRPLINE.DOC.  In addition, You MUST NOT charge for the
   program nor can you charge a copy fee over $4.00 (including the price of
   the diskette).  

   
                                                   Bob Swift (1:342/5)


*/

#include <stdio.h>
#include <string.h> 

void exit(int ernum);
void linetest();
void helpscrn(int errornumber);

FILE *infile,*outfile;
int flag,flag1,count;
unsigned in_line,strp_line,out_line;
char *flnames[3];
char cfgfile[128];
char inline[256];
char linetst1[40];
char lintest[256][40];
char *line;
char version[] = {"1.12"};  /* Current Version Number */

void main(int argc, char *argv[])
{
printf("\n\nSTRPLINE Version %s - Copyright (c) Bob Swift, 1988-1993\n",version);

if (argc > 3 || argc < 2)
   helpscrn(1);

in_line = 0;
out_line = 0;
strp_line = 0;

flnames[1]=strupr(argv[1]);             /*  Input File  */

if (argc == 3)
   flnames[2]=strupr(argv[2]);          /*  Configuration File  */
else
   {
   strcpy(cfgfile,"STRPLINE.CFG");
   flnames[2] = cfgfile;
   }

/*  Check if input file in current directory  */
if (strchr(flnames[1],'\\')!=NULL || strchr(flnames[1],':')!=NULL)
   helpscrn(7);

/*  Check if configuration file exists  */
infile=fopen(flnames[2],"r");
if (infile == NULL)
   helpscrn(8);

flag = 0;
flag1 = 0;
count = 0;

/*  Read configuration file and set up search patters  */
while (flag1 < 256)
{
if (fgets(inline,256,infile) != NULL)
  {
  line = inline;
  if (inline[0]!='^')
    {
    count++;
    flag1 = count;
    strcpy(lintest[count],inline);
    }
  }
else
  flag1 = 256;
}

flag=fclose(infile);
if (flag != 0)
   helpscrn(9);

/*  Exit if no patterns to match  */
if (count < 1)
   helpscrn(10);

/*  Strip off carriage returns from patterns  */
for (flag=1;flag<=count;flag++)
   {
   for (flag1=0;lintest[flag][flag1]!='\n'&&lintest[flag][flag1]!='\0';flag1++)
      {
      /*  NULL Line  */
      }
   lintest[flag][flag1]='\0';
   }

/*  If input file has no extension finish it with a period  */
if (strchr(flnames[1],'.')==NULL)
   strcat(flnames[1],".");

/*  Check if input file exists  */
infile=fopen(flnames[1],"r");
if (infile == NULL)
   helpscrn(2);
flag=fclose(infile);
if (flag != 0)
   helpscrn(5);

/*  Build file name for backup file  */
strcpy(inline,flnames[1]);
for (flag1=0;inline[flag1]!='.';flag1++)
   {
   /*  NULL Line  */
   }
inline[flag1] = '\0';
strcat(inline,".BAK");
flnames[3] = inline;

/*  Exit if input file has an extension of BAK  */
if (strcmp(flnames[1],flnames[3])==0)
   helpscrn(11);

/*  Check for existing backup file and delete  */
infile=fopen(flnames[3],"r");
fclose(infile);
if (infile != NULL)
   {
   flag=unlink(flnames[3]);
   if (flag != 0)
      helpscrn(11);
   }

/*  Rename input file with extension of BAK  */
if (rename(flnames[1],flnames[3]) != 0)
   helpscrn(11);

/*  Open source file  */
infile=fopen(flnames[3],"r");
if (infile == NULL)
   helpscrn(2);

/*  Open destination file  */
outfile=fopen(flnames[1],"w");
if (outfile == NULL)
   helpscrn(3);

/*  Print out list of patterns to match  */
strcpy(inline,"\nStripping: ");
for (flag=1;flag<=count;flag++)
   {
   if (lintest[flag][0]=='\0')
     {
     printf("%sBlank Lines\n",inline);
     }
   else
     {
     printf("%s%s\n",inline,lintest[flag]);
     }
   strcpy(inline,"           ");
   }

/*  Here's where we actually do the stripping.  First print out a       */
/*  heading for the on-screen line counter and initialize the counter.  */
/*  printf("\n    Lines of Text:");  */
printf("\n Input    Out   Stripped\n");

/*  Get line from source file and increment counter  */
while (fgets(inline,256,infile) != NULL)
  {
  in_line++;
  line = inline;

/*  Cycle through the search patterns  */
  flag1 = 1;
  while (flag1 <= count)
     {
     flag = 0;

     if (lintest[flag1][0]=='\0')
       {
       if (line[0]=='\n')
         flag = 1;
       }
     else
       {

/*  Here is the call to the actual matching routine  */
       strcpy(linetst1,lintest[flag1]);
       linetest();
       }

/*  Quit checking if a match is found  */
     if (flag != 0)
        flag1 = count;
     flag1++;
     }

/*  No match -- output line to destination file  */
  if (flag == 0)
    {
    out_line++;
    if (fputs(inline,outfile) == EOF)
       helpscrn(4);
    }

/*  A match -- increment counter  */
  else
    {
    strp_line++;
    }

/*  Display current line count so user doesn't get worried  */
  printf("\r %#05u   %#05u   %#05u",in_line,out_line,strp_line);
  }

/*  Close the source file  */
flag=fclose(infile);
if (flag != 0)
   helpscrn(5);

/*  Close the destination file  */
flag=fclose(outfile);
if (flag != 0)
   helpscrn(6);

/*  Thank the user and exit gracefully  */
printf("\n\nConversion complete.  Thank-you for using STRPLINE.\n\n");
exit(0);
}


/*  This is the routine that actually checks for a match  */
void linetest()
{
int j;
for ( j=0; linetst1[j] == inline[j]; j++ )
    if (linetst1[j+1] == '\0') flag = 1;
}


/*  Here are the error messages and VERY brief instructions  */
void helpscrn(int ernum2)
{
printf("\n\n");
switch (ernum2) {

case  2 : printf("Unable to open input file - %s\n\n",flnames[1]);
          break;

case  3 : printf("Unable to open output file - %s\n\n",flnames[1]);
          break;

case  4 : printf("Problem writing to output file - %s\n\n",flnames[1]);
          break;

case  5 : printf("Problem closing input file - %s\n\n",flnames[1]);
          break;

case  6 : printf("Problem closing output file - %s\n\n",flnames[2]);
          break;

case  7 : printf("Input file not in current directory - %s\n\n",flnames[1]);
          break;

case  8 : printf("Unable to open configuration file - %s\n\n",flnames[2]);
          break;

case  9 : printf("Problem closing configuration file - %s\n\n",flnames[2]);
          break;

case 10 : printf("No patterns in configuration file to strip.\n\n");
          break;

case 11 : printf("Unable to open backup file - %s\n\n",flnames[3]);
          break;
}

printf("This program is used to remove selected");
printf(" lines from an input text file.  The\n");
printf("lines to be removed must begin with one");
printf(" of a series of patterns listed in a\n");
printf("configuration file.  The program is used as follows:\n\n");
printf("     STRPLINE <filename> [configfile]\n\n");
printf("where <filename>   is the name of the text file to be stripped\n");
printf("      [configfile] is the file containing the patters to match\n");
printf("                   default is STRPLINE.CFG");
printf(" in the current directory\n\n");
exit(ernum2);
}

