(* ************************************************************** *)
(* redemo1.pas - Demonstrates how to access a resource file's     *)
(*               header information.                              *)
(*                                                                *)
(* ************************************************************** *)

Program redemo1;
   uses dos,crt;

Type
  resheadrec = Record
                 rfid     : array[1..3] of char;(* resource file id - RES   *)
                 resitems : Word;               (* number of resource items *)
               End;

  resitemrec =Record
                rt     : Word;                    (* resource type *)
                rid    : array[1..12] of char;    (* resource id   *)
                offset : longint;                 (* file offset   *)
                length : longint;                 (* file size     *)
              End;


Procedure dis_res_header(filename : String);
Var
 F     : FILE;
 i     : integer;
 res   : resitemrec;
 resh  : resheadrec;
 Error : Word;
begin
{$I-}
 Assign(F,filename);
 Reset(F,1);
 Error:=IORESULT;
 if (Error=0) then
 begin
   Blockread(F,resh,sizeof(resh));                (* res header       *)
   Writeln(' RES ID    = ',resh.rfid);
   Writeln(' RES ITEMS = ',resh.resitems);
   For i:=1 to resh.resitems do
   begin
     Blockread(F,res,sizeof(res));                (* res item record  *)
     Writeln(' ITEM# ',i,' TYPE= ',res.rt,' ID= ',res.rid:12,
             ' OFFSET= ',res.offset,' LENGTH= ',res.length);
   end;
   close(F);
 end;
{$I+}
end;



begin
  dis_res_header('pics.res');
  repeat until keypressed;
end.
