;
; WHICHCPU.ASM - Copyright (C) 1993 - Tony Doimeadios - All Rights Reserved
;
;         Made-----------: 09/24/93
;         Last Modified--: 09/24/93
;
;         This function will return the type of cpu in the system
;           88
;           286
;           386
;           486
;
;         How to use it:
;           This function is linked in with QB4.5 or PDS7.1
;           Declare Function WhichCPU%()
;           Print WhichCPU%
;           would declare and activate the function.
;
;         Technical Details:
;           I used Turbo Assembler 3.0 to compile this source code.
;           TASM WHICHCPU
;           LIB WHICHCPU.LIB +WHICHCPU.OBJ;
;           LINK /Q /SEG:1024 WHICHCPU.LIB,,NUL,QBXQLB;
;           This produces WHICHCPU.LIB and WHICHCPU.QLB
;           To load it into QB/QBX: QBX /L WHICHCPU
;
;
;
;
;         This program is hereby released into the Public Domain.
;           This program can be freely copied and distributed as
;           long as the information in this block of comments is
;           not changed.
;
;         If you have any problems, complaints or requests, you can
;           address them to the author.  I'm always happy to hear
;           from people that use my programs.
;            Ŀ 
;             Tony Doimeadios, P.O. Box 431, Brunswick, GA  31521 
;            
    
    
    DOSSEG
    .MODEL MEDIUM, BASIC
    .DATA

    
    .CODE
    mov ax,@Data
    mov ds,ax                   ;set DS to point to the data segment

    public WhichCPU


;---------------------------------------------------------------------
WhichCPU PROC FAR
    
    ;this is a BASIC FUNCTION that returns a number, indicating cpu type
    ;usage--: PRINT WhichCPU%
    
    ;Determine whether the CPU in use is an 8086/88, an 80286,
    ;an 80386 or an 80486.  Returns the CPU type in the AX register.

    ;The first step is to determine whether the chip is an 8086/8088.
    ;The key difference is based on what the CPU does when it executes
    ;the PUSH instruction.  The 8086/8088 decrements the stack pointer
    ;first, then writes the saved value to the stack, then decrement
    ;the stack pointer.  Thus, when SP is pushed, and the pushed value
    ;is popped off, the value popped off will equal the current stack 
    ;pointer, unless the chip is an 8086 or an 8088.
    
    push sp                     ;push sp
    pop ax                      ;retrieve value
    cmp ax,sp                   ;is it the same value that was pushed?
    je Try286                   ;if same, it is a 80286 or higher
    mov ax,88                   ;nope, set register to reflect 8088
    jmp short Done              ;bail out



    ;the second step is to determine whether the chip is an 80286.
    ;The key difference is the IOPL bits in the flag register; the 80386
    ;and 80486 has them, the 80286 does not.  The 80286 will not allow them
    ;to be set; the 80386 and 80486 will.

Try286:
    pushf                       ;push flags
    pop ax                      ;retreive them
    or ax,03000h                ;set IOPL bits
    push ax                     ;stuff back
    popf                        ;pop flags back - this is where the 80286 
                                ; will put them back the way they were
    pushf                       ;push them back
    pop ax                      ;see if CPU overrode the IOPL bits
    test ax,03000h              ;if the IOPL bits are reset, the CPU did
                                ; and the chip is an 80286
    jnz Try386                  ;nope, go see if we're an 80386
    mov ax,286                  ;set register to reflect we're an 80286
    jmp short Done              ;bail out


    
    
    
    ;the third step is to determine whether the chip is an 80386.
    ;the key difference is the alignment check bit in the flags
    ;register: the 80486 has one, the 80386 does not.  As with the
    ;80286 and the IOPL bits, the 80386 will not let you set that bit,
    ;but the 80486 will.

Try386:
    db 66h                      ;(32 bit)
    pushf                       ;push extended flags register
    pop ax                      ;read low word
    and ax,00fffh               ;clear IOPL bits - level zero
    pop dx                      ;read high word
    or dx,00004h                ;set alignment check bit
    push dx                     ;push flags back
    push ax                     ;push flags back
    db 66h                      ;(32 bit)
    popf                        ;pop flags register - this is where
                                ; the 80386 will undo your work
    db 66h                      ;(32 bits) 
    pushf                       ;push flags back
    pop ax                      ;read what we did
    pop dx                      ;find out if the CPU reset the
                                ; alignment check bit
    test dx,4                   ;
    jnz short Try486            ;if it didn't, the chip is an 80486
    mov ax,386                  ;set register to reflect we're an 8386
    jmp short Done              ;bail out


    
    

    ;this routine does NOT take into account the Pentium (80586)
    ;therefore, this routine will report an '486' for both the
    ;80486 and the Pentium chips
    
Try486:
    mov ax,486                  ;must be a 80486


Done:    
    ret                         ;we're thru - bail out

WhichCPU ENDP
;---------------------------------------------------------------------


    END
