/* Header file for use API interfaces for Keyed File System          */
#ifndef KFS_H_INCLUDED
  #define KFS_H_INCLUDED
  #define KFS_MaxName 64
  /* Valid return codes                                              */
  #define KFS_EOF                   -1
  #define KFS_OK                     0
  #define KFS_Invalid_File_Name      1
  #define KFS_PTR_File_Open_Error    2
  #define KFS_Data_File_Open_Error   3
  #define KFS_Key_Already_Exists     4
  #define KFS_Key_Not_Found          5
  #define KFS_Prior_Key_Not_Found    6
  #define KFS_Keyed_File_Empty       7
  #define KFS_File_Error             8
  #define KFS_File_Already_Exists    9
  #define KFS_Recordsize_Too_Short  10
  #define KFS_Invalid_Request       11
  #define KFS_Key_Length_Invalid    12
  #define KFS_No_Space_On_Disk      13
  /* End of return codes                                             */
  #define KFS_Normal_PTR             0x00
  #define KFS_Small_PTR              0x01
  #define KFS_Numeric_Keys           0x02
  #define KFS_Ignore_Case            0x04
  #define KFS_Version                0x0200
  #include <stdio.h>
  typedef
    struct KFS_FI {
      short KFS_rc;
      short KFS_keypos;                /* Relative to 0              */
      short KFS_keylen;
      short KFS_recsize;
      FILE  *KFS_ptrfile;
      FILE  *KFS_datafile;
      void  *KFS_cr;
      long  KFS_prev_ptrptr;
      long  KFS_ptrptr;
      long  KFS_dataptr;
      short KFS_ptridx;
      unsigned short KFS_driveno;
      char  KFS_flags;                 /* 0x01 = small PTR file      */
                                       /* 0x02 = numeric keys        */
                                       /* 0x04 = ignore case         */
      char  KFS_filename[KFS_MaxName];
    } KFS_FILEINFO;
  void _far KFS_Add(KFS_FILEINFO *, void *);
  void _far KFS_Close(KFS_FILEINFO *);
  void _far KFS_Create(KFS_FILEINFO *);
  void _far KFS_Delete(KFS_FILEINFO *, void *);
  void _far KFS_Open(KFS_FILEINFO *);
  void _far KFS_Read(KFS_FILEINFO *, void *);
  void _far KFS_ReadFirst(KFS_FILEINFO *, void *);
  void _far KFS_ReadGen(KFS_FILEINFO *, void *, short);
  void _far KFS_ReadGenNumeric(KFS_FILEINFO *, void *);
  void _far KFS_ReadNext(KFS_FILEINFO *, void *);
  void _far KFS_Replace(KFS_FILEINFO *, void *);
#endif
