// filelvw.h : interface of the CFilelookView class
//
/////////////////////////////////////////////////////////////////////////////

class CFilelookView : public CView
{
protected: // create from serialization only
	CFilelookView();
	DECLARE_DYNCREATE(CFilelookView)

// Attributes
public:
	CFilelookDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CFilelookView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
    virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// Generated message map functions
protected:
	//{{AFX_MSG(CFilelookView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnFileClose();
	afx_msg void OnUpdateIndicatorColumn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateIndicatorFilesize(CCmdUI* pCmdUI);
	afx_msg void OnUpdateIndicatorRow(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	short       m_nVScrollPos;
	short       m_nHScrollPos;


	LONG        m_lTopLine;

	UINT        m_nCxChar;
	UINT        m_nCyChar;
	UINT        m_nLinesPainted;

};

#ifndef _DEBUG	// debug version in filelvw.cpp
inline CFilelookDoc* CFilelookView::GetDocument()
   { return (CFilelookDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
