// filelvw.cpp : implementation of the CFilelookView class
//

#include "stdafx.h"
#include "filelook.h"
#include "mainfrm.h"

#include "fileldoc.h"
#include "filelvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilelookView

IMPLEMENT_DYNCREATE(CFilelookView, CView)

BEGIN_MESSAGE_MAP(CFilelookView, CView)
	//{{AFX_MSG_MAP(CFilelookView)
	ON_WM_CREATE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_COLUMN, OnUpdateIndicatorColumn)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_FILESIZE, OnUpdateIndicatorFilesize)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_ROW, OnUpdateIndicatorRow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilelookView construction/destruction

CFilelookView::CFilelookView()
{
	// TODO: add construction code here
}

CFilelookView::~CFilelookView()
{
}


void CFilelookView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
  CFilelookDoc* pDoc = GetDocument();
  CLineFile *m_pMyFile=pDoc->m_pMyFile;
  
  CView::OnUpdate(pSender, lHint, pHint);
  
  if(m_pMyFile==NULL){
		m_lTopLine = 0L;
		m_nVScrollPos = 0;
		SetScrollPos( SB_VERT, m_nVScrollPos, TRUE );
		m_nHScrollPos = 0;
		SetScrollPos( SB_HORZ, m_nHScrollPos, TRUE );
  }
}


/////////////////////////////////////////////////////////////////////////////
// CFilelookView drawing

void CFilelookView::OnDraw(CDC* pDC)
{
	CFilelookDoc* pDoc = GetDocument();
	CLineFile *m_pMyFile=pDoc->m_pMyFile;
	CStatusBar *pStatusBar = &(((CMainFrame*)GetParentFrame())->m_wndStatusBar);

	// TODO: add draw code here
	char        acBuf[ SIZESTRING ];
	CRect       rect, rect2;
	int         y;
	char*       pc;

	GetClientRect( &rect );
	pDC->SetTextAlign( TA_LEFT );
	pDC->SelectStockObject( OEM_FIXED_FONT );
	pDC->SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
	pDC->SetBkColor(::GetSysColor(COLOR_WINDOW));
	
	if ( m_pMyFile != NULL ) {
		m_pMyFile->Seek( m_lTopLine, CFile::begin );

		rect2.left  = rect.left;
		rect2.right = rect.right;

		m_nLinesPainted = 0;
		for ( y = m_nCxChar/2; y < rect.bottom; y += m_nCyChar ){
			m_pMyFile->NextLine( acBuf, SIZESTRING );

			pc = acBuf;
			if ( (int)strlen(acBuf) < m_nHScrollPos){
				*acBuf = 0;
			}
			else{
				pc += m_nHScrollPos;
			}

			rect2.top = y;
			rect2.bottom = y + m_nCyChar;
			pDC->ExtTextOut( m_nCyChar/2, rect2.top, ETO_OPAQUE, &rect2,
						   pc, strlen(pc), NULL );
			m_nLinesPainted++;
		}
	}
	else{
		m_lTopLine = 0L;
		m_nVScrollPos = 0;
		SetScrollPos( SB_VERT, m_nVScrollPos, TRUE );
		m_nHScrollPos = 0;
		SetScrollPos( SB_HORZ, m_nHScrollPos, TRUE );
	}
    char tempBuf[20];
    sprintf(tempBuf,"%6ld",m_lTopLine);
    pStatusBar->SetPaneText(PANE_IDX_ROW,tempBuf,TRUE);
    sprintf(tempBuf,"%4d",m_nHScrollPos);
    pStatusBar->SetPaneText(PANE_IDX_COLUMN,tempBuf,TRUE);
    sprintf(tempBuf,"%8ld",pDoc->m_lFileSize);
    pStatusBar->SetPaneText(PANE_IDX_FILESIZE,tempBuf,TRUE);
}



/////////////////////////////////////////////////////////////////////////////
// CFilelookView diagnostics

#ifdef _DEBUG
void CFilelookView::AssertValid() const
{
	CView::AssertValid();
}

void CFilelookView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFilelookDoc* CFilelookView::GetDocument() 
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFilelookDoc)));
	return (CFilelookDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFilelookView message handlers


int CFilelookView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	TEXTMETRIC tm;
	CWindowDC dc( this );

	dc.SelectStockObject( SYSTEM_FIXED_FONT );
	dc.GetTextMetrics( &tm );

	m_nCxChar = tm.tmAveCharWidth;
	m_nCyChar = tm.tmHeight + tm.tmExternalLeading;

	m_nVScrollPos = 0;
	m_nHScrollPos = 0;
	m_lTopLine = 0L;

	SetScrollRange( SB_VERT, 0, SCROLLMAX, FALSE );
	SetScrollRange( SB_HORZ, 0, SIZESTRING, FALSE );
	return 0;
}

void CFilelookView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	CFilelookDoc* pDoc = GetDocument();
	CLineFile *m_pMyFile=pDoc->m_pMyFile;
	char        acBuf[SIZESTRING];
	LONG m_lFileSize = pDoc->m_lFileSize;
	LONG        oldLine = m_lTopLine;
	LONG        l;

	if ( m_pMyFile == NULL )
		return;

	switch ( nSBCode ){
		case SB_LINEUP:
			if ( m_lTopLine > 0L ){
				m_pMyFile->SetBegin( m_lTopLine );
				m_lTopLine = m_pMyFile->BackLines( acBuf, SIZESTRING, 1 );
			}
			break;

		case SB_LINEDOWN:
			m_pMyFile->Seek( m_lTopLine, CFile::begin);
			m_lTopLine = m_pMyFile->NextLine( acBuf, SIZESTRING );
			break;

		case SB_PAGEUP:
			if ( m_lTopLine > 0L ){
				m_pMyFile->SetBegin( m_lTopLine );
				m_lTopLine = m_pMyFile->BackLines( acBuf, SIZESTRING,
												   m_nLinesPainted );
			}
			break;

		case SB_PAGEDOWN:
			m_lTopLine = m_pMyFile->GetPosition();
			break;

		case SB_BOTTOM:
			nPos = 1000;
			goto ThumbGoTo;

		case SB_TOP:
			nPos = 0;

		case SB_THUMBPOSITION:
	ThumbGoTo:

			m_nVScrollPos = nPos;
			if ( m_lFileSize > 40000L )	{
				l = ( m_lFileSize / 1000L ) * nPos;
			}
			else{
				l = ( m_lFileSize * nPos ) / 1000L;
			}

			m_lTopLine = m_pMyFile->LineNear( acBuf, SIZESTRING, l );
			break;

		default:
			return;
	}

	if ( m_lTopLine < 0L ){
		m_lTopLine = 0L;
	}

	if ( m_lFileSize > 40000 )	{
		m_nVScrollPos = (short)(m_lTopLine  / ( m_lFileSize / 1000L ));
	}
	else {
		m_nVScrollPos = (short)(m_lTopLine * 1000L / m_lFileSize);
	}

	if ( m_nVScrollPos < 0 ){
		m_nVScrollPos = 0;
	}
	if ( m_nVScrollPos > SCROLLMAX ){
		m_nVScrollPos = SCROLLMAX;
	}

	SetScrollPos( SB_VERT, m_nVScrollPos, TRUE );

	if ( m_lTopLine != oldLine ){
		Invalidate( FALSE );
	}

	CView::OnVScroll(nSBCode, nPos, pScrollBar);
}


void CFilelookView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	CFilelookDoc* pDoc = GetDocument();
	CLineFile *m_pMyFile=pDoc->m_pMyFile;

	if ( m_pMyFile == NULL ){
		return;
	}

	switch ( nSBCode ){
	case SB_LINEUP:
		m_nHScrollPos -= 1;
		break;

	case SB_LINEDOWN:
		m_nHScrollPos += 1;
		break;

	case SB_PAGEUP:
		m_nHScrollPos -= 10;
		break;

	case SB_PAGEDOWN:
		m_nHScrollPos += 10;
		break;

	case SB_TOP:
		nPos = 0;
	case SB_THUMBPOSITION:
		m_nHScrollPos = nPos;
		break;

	default:
		return;
	}

	if ( m_nHScrollPos < 0 ){
		m_nHScrollPos = 0;
	}

	if ( m_nHScrollPos > SIZESTRING ){
		m_nHScrollPos = SIZESTRING;
	}

	SetScrollPos( SB_HORZ, m_nHScrollPos, TRUE );
	Invalidate( FALSE );
	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CFilelookView::OnKeyDown( UINT wChar, UINT  nRepCnt , UINT  wFlags )
{
	switch( wChar )	{
	case VK_HOME:
		SendMessage( WM_VSCROLL, SB_TOP, 0L);
		SendMessage( WM_HSCROLL, SB_TOP, 0L);
		break;

	case VK_END:
		SendMessage( WM_VSCROLL, SB_BOTTOM, 0L);
		break;

	case VK_PRIOR:
		SendMessage( WM_VSCROLL, SB_PAGEUP, 0L);
		break;

	case VK_NEXT:
		SendMessage( WM_VSCROLL, SB_PAGEDOWN, 0L);
		break;

	case VK_UP:
		SendMessage( WM_VSCROLL, SB_LINEUP, 0L);
		break;

	case VK_DOWN:
		SendMessage( WM_VSCROLL, SB_LINEDOWN, 0L);
		break;

	case VK_RIGHT:
		SendMessage( WM_HSCROLL, SB_LINEDOWN, 0L);
		break;

	case VK_LEFT:
		SendMessage( WM_HSCROLL, SB_LINEUP, 0L);
		break;
	}
	
}

void CFilelookView::OnFileClose()
{
	GetDocument()->DeleteContents();
	Invalidate(TRUE);
	
}


void CFilelookView::OnUpdateIndicatorColumn(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
	
}

void CFilelookView::OnUpdateIndicatorFilesize(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
	
}

void CFilelookView::OnUpdateIndicatorRow(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
	
}
