// filelook.h : main header file for the FILELOOK application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

#define SCROLLMAX 1000
#define SIZESTRING  256        // max characters in string
#define PANE_IDX_ROW 4
#define PANE_IDX_COLUMN 5
#define PANE_IDX_FILESIZE 6

/////////////////////////////////////////////////////////////////////////////
// Derived class to handle large line files
class CLineFile : public CFile
{
	DECLARE_DYNAMIC(CLineFile)
public:
// Constructors
					CLineFile();
					CLineFile(const char* pszFileName, UINT nOpenFlags);

// Overridables

	virtual LONG    NextLine(char FAR* lpsz, UINT nMax);
	virtual LONG    BackLines(char FAR* lpsz, UINT nMax, UINT nLines);
	virtual LONG    LineNear(char FAR* lpsz, UINT nMax, LONG  lOffset);
	virtual LONG    SetBegin(LONG lnewBegin);
			LONG    GetBegin() { return m_lBeginLine; };


// Implementation
	virtual         ~CLineFile();

private:
	LONG    m_lBeginLine;   // 0 for beginning of file
							// -1 for don't know
							// offset of beginning of a line
};







/////////////////////////////////////////////////////////////////////////////
// CFilelookApp:
// See filelook.cpp for the implementation of this class
//

class CFilelookApp : public CWinApp
{
public:
	CFilelookApp();

// Overrides
	virtual BOOL InitInstance();

// Implementation

	//{{AFX_MSG(CFilelookApp)
	afx_msg void OnAppAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
