// fileldoc.cpp : implementation of the CFilelookDoc class
//

#include "stdafx.h"
#include "filelook.h"

#include "fileldoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilelookDoc

IMPLEMENT_DYNCREATE(CFilelookDoc, CDocument)

BEGIN_MESSAGE_MAP(CFilelookDoc, CDocument)
	//{{AFX_MSG_MAP(CFilelookDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilelookDoc construction/destruction

CFilelookDoc::CFilelookDoc()
{
	// TODO: add one-time construction code here
	m_pMyFile = NULL;
}

CFilelookDoc::~CFilelookDoc()
{
}


void CFilelookDoc::DeleteContents()
{
	if (m_pMyFile != NULL)
	{
		m_pMyFile->Close();
		delete m_pMyFile;
		m_pMyFile=NULL;
		SetTitle("No file");
	}
}



BOOL CFilelookDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CFilelookDoc serialization

void CFilelookDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


/////////////////////////////////////////////////////////////////////////////
// CFilelookDoc diagnostics

#ifdef _DEBUG
void CFilelookDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CFilelookDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFilelookDoc commands

BOOL CFilelookDoc::OnOpenDocument(const char* pszPathName)
{
	// TODO: Add your command handler code here
	CString strFileTitle;

	//
	// First close any open file
	//

	if ( m_pMyFile != NULL )
	{
		m_pMyFile->Close();
		delete m_pMyFile;
		m_pMyFile = NULL;
		SetTitle("No file");
     	UpdateAllViews(NULL);
	}

	TRY
	{
			//
			// try to open the file here
			//
			m_pMyFile = new CLineFile( pszPathName,
										CFile::modeRead | CFile::typeBinary);
			m_lFileSize = m_pMyFile->GetLength();
			if (m_lFileSize ==0){
              m_pMyFile->Close();
		      delete m_pMyFile;
		      m_pMyFile = NULL;
		      return 0;
		    }

			m_pMyFile->SeekToBegin();

			SetTitle( pszPathName );
			UpdateAllViews(NULL);
	}
	CATCH( CFileException, e )
	{
		char ErrorMsg[ 80 ];
		sprintf( ErrorMsg,"Error!\nOpening %s returned a 0x%lx.",
				(const char*)strFileTitle, e->m_lOsError );
		AfxMessageBox( ErrorMsg );
	}
	END_CATCH
    return TRUE;	
}
