rem echo off
goto start
:usage
echo .=================================================================
echo .===== extract.bat -- extract all fields from VENDINFO       =====
echo .=====                file, writing results to out_file      =====
echo .=====                                                       =====
echo .===== usage:                                                =====
echo .=====        extract diz_file out_file                      =====
echo .===== where:                                                =====
echo .=====        diz_file = pathname of VENDINFO file           =====
echo .=====                                                       =====
echo .=====        out_file = pathname of output file to which    =====
echo .=====                   extracted information should be     =====
echo .=====                   written                             =====
echo .=====                                                       =====
echo .===== example:                                              =====
echo .=====        vendtest vendinfo.diz sample.prn               =====
echo .=====                                                       =====
echo .=== Copyright 1993 Rams' Island Software All Rights Reserved ====
echo .== 1993 Rams' Island Software, 7644 Lakecliff, Parker CO 80134 ==
echo .=================================================================
goto exit

:start
rem ----- desired VendPrcs test goes here ---------------------------
if %1.==. goto usage
if %2.==. goto usage

rem ----- test for valid, authenticated file ------------------------
vendprcs %1 -zk                      -y " "                      > %2
if errorlevel 12 goto allOK

:test11
if not errorlevel 11 goto test10
echo NOTE: This VENDINFO.DIZ file has a missing or invalid      >> %2
echo       author authentication code.  If you are the author   >> %2
echo       and you are testing your VENDINFO.DIZ file, this     >> %2
echo       simply means that you have not yet registered        >> %2
echo       VendEdit and entered the registration numbers so     >> %2
echo       that VendEdit can produce an authenticated record.   >> %2
echo       (Or it may be that the company name in the VENDINFO  >> %2
echo       file you're producing doesn't match the name you've  >> %2
echo       registered.)                                         >> %2
echo       If you have found this VENDINFO.DIZ file in a        >> %2
echo       distributed package, however, then that package may  >> %2
echo       be hacked or corrupted, and is, in any case, in      >> %2
echo       violation of the VendEdit license.                   >> %2
goto continue

:test10
if not errorlevel 10 goto allOK
echo NOTE: This VENDINFO.DIZ file has an incorrect size or CRC  >> %2
echo       for either the text or the data section, and may be  >> %2
echo       a hacked or corrupted file.                          >> %2
goto exit

:allOK
echo NOTE: This VENDINFO.DIZ file has passed all validity and   >> %2
echo       security tests, including size and CRC tests and     >> %2
echo       basic author source authentication.                  >> %2

:continue
rem ----- extract all information from file -------------------------
vendprcs VENDDATA                   -y " "                      -na >> %2
vendprcs VENDDATA                   -y " "                      -na >> %2
vendprcs VENDDATA -xpp  -zn         -y "Product Information: @" -na >> %2
vendprcs VENDDATA -xpe  -zn         -y " @ v"                  -na >> %2
vendprcs VENDDATA -xpv  -zn         -y "@ "                    -na >> %2
vendprcs VENDDATA -xpt              -y "(@)"                   -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Header Information   " -na >> %2
vendprcs VENDDATA -xhv              -y "        VI Version: @" -na >> %2
vendprcs VENDDATA -xht              -y "       Header Type: @" -na >> %2
vendprcs VENDDATA -xhd              -y "         Prep Date: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Product Information  " -na >> %2
vendprcs VENDDATA -xpy              -y "      Product Type: @" -na >> %2
vendprcs VENDDATA -xpp              -y "      Product Name: @" -na >> %2
vendprcs VENDDATA -xpe              -y "    Name Extension: @" -na >> %2
vendprcs VENDDATA -xpv              -y "           Version: @" -na >> %2
vendprcs VENDDATA -xpt              -y "              Date: @" -na >> %2
vendprcs VENDDATA -xpr              -y "    Version Reason: @" -na >> %2
vendprcs VENDDATA -xpn              -y "   Filename Prefix: @" -na >> %2
vendprcs VENDDATA -xppn             -y "   Number of Parts: @" -na >> %2
vendprcs VENDDATA -xppt             -y "         This Part: @" -na >> %2
vendprcs VENDDATA -xppl -zi20 -zc45 -y "     List of Parts: @" -na >> %2
vendprcs VENDDATA -xppc -zi20 -zc45 -y "  CompuServe Parts: @" -na >> %2
vendprcs VENDDATA -xph  -zi20 -zc45 -y "  Screenshot Types: @" -na >> %2
vendprcs VENDDATA -xpx  -zi20 -zc45 -y "          Replaced: @" -na >> %2
vendprcs VENDDATA                   -y "     Description 1:  " -na >> %2
vendprcs VENDDATA -xpd1 -zi10                                -na >> %2
vendprcs VENDDATA                   -y "     Description 2:  " -na >> %2
vendprcs VENDDATA -xpd2 -zi10 -zc70                          -na >> %2
vendprcs VENDDATA -xpd3 -zi20 -zc45 -y "     Description 3: @" -na >> %2
vendprcs VENDDATA -xpd4 -zi20 -zc45 -y "     Description 4: @" -na >> %2
vendprcs VENDDATA                   -y "     Description 5:  " -na >> %2
vendprcs VENDDATA -xpd5 -zi10 -zc70                          -na >> %2
vendprcs VENDDATA                   -y "     Description 6:  " -na >> %2
vendprcs VENDDATA -xpd6 -zi10 -zc70                          -na >> %2
vendprcs VENDDATA -xpc1             -y "        Categories: @" -na >> %2
vendprcs VENDDATA -xpc2             -y "                    @" -na >> %2
vendprcs VENDDATA -xpc3             -y "                    @" -na >> %2
vendprcs VENDDATA -xpc4             -y "                    @" -na >> %2
vendprcs VENDDATA -xpc5             -y "                    @" -na >> %2
vendprcs VENDDATA -xpk  -zi20 -zc45 -y "          Keywords: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Platform Information " -na >> %2
vendprcs VENDDATA                   -y " Minimal Platform    " -na >> %2
vendprcs VENDDATA -xp1c             -y "               CPU: @" -na >> %2
vendprcs VENDDATA -xp1s             -y "       Clock Speed: @" -na >> %2
vendprcs VENDDATA -xp1o             -y "         Op System: @" -na >> %2
vendprcs VENDDATA -xp1rs            -y "        Std Memory: @" -na >> %2
vendprcs VENDDATA -xp1rm            -y "        EMS Memory: @" -na >> %2
vendprcs VENDDATA -xp1re            -y "        Ext Memory: @" -na >> %2
vendprcs VENDDATA -xp1rx            -y "        XMS Memory: @" -na >> %2
vendprcs VENDDATA -xp1dm            -y "    Disk Min Instl: @" -na >> %2
vendprcs VENDDATA -xp1df            -y "   Disk Full Instl: @" -na >> %2
vendprcs VENDDATA                   -y " Recommended Platform" -na >> %2
vendprcs VENDDATA -xp2c             -y "               CPU: @" -na >> %2
vendprcs VENDDATA -xp2s             -y "       Clock Speed: @" -na >> %2
vendprcs VENDDATA -xp2o             -y "         Op System: @" -na >> %2
vendprcs VENDDATA -xp2rs            -y "        Std Memory: @" -na >> %2
vendprcs VENDDATA -xp2rm            -y "        EMS Memory: @" -na >> %2
vendprcs VENDDATA -xp2re            -y "        Ext Memory: @" -na >> %2
vendprcs VENDDATA -xp2rx            -y "        XMS Memory: @" -na >> %2
vendprcs VENDDATA -xp2dm            -y "    Disk Min Instl: @" -na >> %2
vendprcs VENDDATA -xp2df            -y "   Disk Full Instl: @" -na >> %2
vendprcs VENDDATA                   -y " Features            " -na >> %2
vendprcs VENDDATA -xpfcf            -y "  Config:      FPU: @" -na >> %2
vendprcs VENDDATA -xpfcl            -y "  Config:   Laptop: @" -na >> %2
vendprcs VENDDATA -xpfcm            -y "  Config:      MCA: @" -na >> %2
vendprcs VENDDATA -xpfro            -y "  RAM:Exp *or* Ext: @" -na >> %2
vendprcs VENDDATA -xpfrm            -y "  RAM:         EMS: @" -na >> %2
vendprcs VENDDATA -xpfre            -y "  RAM:    Extended: @" -na >> %2
vendprcs VENDDATA -xpfrx            -y "  RAM:         XMS: @" -na >> %2
vendprcs VENDDATA -xpfrh            -y "  RAM:       HIMEM: @" -na >> %2
vendprcs VENDDATA -xpfdh            -y "  Disk: Hard Drive: @" -na >> %2
vendprcs VENDDATA -xpfdf            -y "  Disk:  Flop Only: @" -na >> %2
vendprcs VENDDATA -xpfdc            -y "  Disk:     CD-ROM: @" -na >> %2
vendprcs VENDDATA -xpfop            -y "  Port:   Parallel: @" -na >> %2
vendprcs VENDDATA -xpfos            -y "  Port:     Serial: @" -na >> %2
vendprcs VENDDATA -xpfoc            -y "  Port:     PCMCIA: @" -na >> %2
vendprcs VENDDATA -xpfog            -y "  Port:       Game: @" -na >> %2
vendprcs VENDDATA -xpfvm            -y "  Video:       MDA: @" -na >> %2
vendprcs VENDDATA -xpfvh            -y "  Video:  Hercules: @" -na >> %2
vendprcs VENDDATA -xpfvt            -y "  Video:     Tandy: @" -na >> %2
vendprcs VENDDATA -xpfvc            -y "  Video:       CGA: @" -na >> %2
vendprcs VENDDATA -xpfve            -y "  Video:       EGA: @" -na >> %2
vendprcs VENDDATA -xpfvn            -y "  Video:      MCGA: @" -na >> %2
vendprcs VENDDATA -xpfvo            -y "  Video:  MCGA 256: @" -na >> %2
vendprcs VENDDATA -xpfvv            -y "  Video:       VGA: @" -na >> %2
vendprcs VENDDATA -xpfvw            -y "  Video: SVGA VESA: @" -na >> %2
vendprcs VENDDATA -xpfvs            -y "  Video: SVGA Othr: @" -na >> %2
vendprcs VENDDATA -xpfv8            -y "  Video:      8514: @" -na >> %2
vendprcs VENDDATA -xpfvx            -y "  Video:       XGA: @" -na >> %2
vendprcs VENDDATA -xpfva            -y "  Video:       B&W: @" -na >> %2
vendprcs VENDDATA -xpfvb            -y "  Video:     Color: @" -na >> %2
vendprcs VENDDATA -xpfik            -y "  Input:  Keyboard: @" -na >> %2
vendprcs VENDDATA -xpfim            -y "  Input:     Mouse: @" -na >> %2
vendprcs VENDDATA -xpfid            -y "  Input: Digitizer: @" -na >> %2
vendprcs VENDDATA -xpfij            -y "  Input:  Joystick: @" -na >> %2
vendprcs VENDDATA -xpfal            -y "  Scanner:Logitech: @" -na >> %2
vendprcs VENDDATA -xpfag            -y "  Scanner:  Genius: @" -na >> %2
vendprcs VENDDATA -xpfaf            -y "  Scanner: HP Flat: @" -na >> %2
vendprcs VENDDATA -xpfpy            -y "  Print:       Yes: @" -na >> %2
vendprcs VENDDATA -xpfpt            -y "  Print:      Text: @" -na >> %2
vendprcs VENDDATA -xpfpi            -y "  Print: IBM Graph: @" -na >> %2
vendprcs VENDDATA -xpfpe            -y "  Print:  Epson  9: @" -na >> %2
vendprcs VENDDATA -xpfpf            -y "  Print:  Epson 24: @" -na >> %2
vendprcs VENDDATA -xpfpd            -y "  Print:   DeskJet: @" -na >> %2
vendprcs VENDDATA -xpfpp            -y "  Print:  PaintJet: @" -na >> %2
vendprcs VENDDATA -xpfpl            -y "  Print:  LaserJet: @" -na >> %2
vendprcs VENDDATA -xpfps            -y "  Print: Postscrpt: @" -na >> %2
vendprcs VENDDATA -xpfpo            -y "  Print:   Plotter: @" -na >> %2
vendprcs VENDDATA -xpfma            -y "  Modem: AnySerial: @" -na >> %2
vendprcs VENDDATA -xpfmh            -y "  Modem:     Hayes: @" -na >> %2
vendprcs VENDDATA -xpfmf            -y "  Modem: FAX/Modem: @" -na >> %2
vendprcs VENDDATA -xpfsy            -y "  Sound:       Yes: @" -na >> %2
vendprcs VENDDATA -xpfsa            -y "  Sound:     AdLib: @" -na >> %2
vendprcs VENDDATA -xpfsc            -y "  Sound:     Covox: @" -na >> %2
vendprcs VENDDATA -xpfsb            -y "  Sound:  SBlaster: @" -na >> %2
vendprcs VENDDATA -xpfsm            -y "  Sound:      MIDI: @" -na >> %2
vendprcs VENDDATA -xpfne            -y "  Network         : @" -na >> %2
vendprcs VENDDATA -xps  -zi20 -zc45 -y "     Other Reqd SW: @" -na >> %2
vendprcs VENDDATA -xpo  -zi20 -zc45 -y "     Other Require: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Author Information   " -na >> %2
vendprcs VENDDATA -xan              -y "       Author Name: @" -na >> %2
vendprcs VENDDATA -xac              -y "      Company Name: @" -na >> %2
vendprcs VENDDATA -xaa  -zi20 -zc45 -y "           Address: @" -na >> %2
vendprcs VENDDATA -xap              -y "      Author Phone: @" -na >> %2
vendprcs VENDDATA -xaf              -y "        Author FAX: @" -na >> %2
vendprcs VENDDATA -xaq              -y "     Queries Phone: @" -na >> %2
vendprcs VENDDATA -xaen             -y "          BBS Name: @" -na >> %2
vendprcs VENDDATA -xaeb             -y "         BBS Phone: @" -na >> %2
vendprcs VENDDATA -xaeu             -y "      BBS Username: @" -na >> %2
vendprcs VENDDATA -xaea             -y "       Amer OnLine: @" -na >> %2
vendprcs VENDDATA -xaec             -y "        CompuServe: @" -na >> %2
vendprcs VENDDATA -xaed             -y "            Delphi: @" -na >> %2
vendprcs VENDDATA -xaeg             -y "             Genie: @" -na >> %2
vendprcs VENDDATA -xaep             -y "           Prodigy: @" -na >> %2
vendprcs VENDDATA -xaef             -y "           FidoNet: @" -na >> %2
vendprcs VENDDATA -xaei             -y "          Internet: @" -na >> %2
vendprcs VENDDATA -xaer             -y "              RIME: @" -na >> %2
vendprcs VENDDATA -xaeo -zi20 -zc45 -y "      Other E-Mail: @" -na >> %2
vendprcs VENDDATA       -zn         -y "  Known Trade Assn: "  -na >> %2
vendprcs VENDDATA -xamb -zn        -zt "ASAD "                 -na >> %2
vendprcs VENDDATA -xama -zn        -zt "ASP "                  -na >> %2
vendprcs VENDDATA -xamd -zn        -zt "DSAH "                 -na >> %2
vendprcs VENDDATA -xame -zn        -zt "ESC "                  -na >> %2
vendprcs VENDDATA -xamp -zn        -zt "SPA "                  -na >> %2
vendprcs VENDDATA -xams -zn        -zt "STAR "                 -na >> %2
vendprcs VENDDATA                   -y " "                     -na >> %2
vendprcs VENDDATA -xamx -zi20 -zc45 -y "  Other Trade Assn: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Order Information    " -na >> %2
vendprcs VENDDATA -xoa  -zi20 -zc45 -y "           Address: @" -na >> %2
vendprcs VENDDATA -xot              -y "   Toll-Free Phone: @" -na >> %2
vendprcs VENDDATA -xop              -y "       Order Phone: @" -na >> %2
vendprcs VENDDATA -xof              -y "         Order FAX: @" -na >> %2
vendprcs VENDDATA -xoen             -y "          BBS Name: @" -na >> %2
vendprcs VENDDATA -xoeb             -y "         BBS Phone: @" -na >> %2
vendprcs VENDDATA -xoeu             -y "      BBS Username: @" -na >> %2
vendprcs VENDDATA -xoea             -y "       Amer OnLine: @" -na >> %2
vendprcs VENDDATA -xoec             -y "        CompuServe: @" -na >> %2
vendprcs VENDDATA -xoed             -y "            Delphi: @" -na >> %2
vendprcs VENDDATA -xoeg             -y "             Genie: @" -na >> %2
vendprcs VENDDATA -xoep             -y "           Prodigy: @" -na >> %2
vendprcs VENDDATA -xoef             -y "           FidoNet: @" -na >> %2
vendprcs VENDDATA -xoei             -y "          Internet: @" -na >> %2
vendprcs VENDDATA -xoer             -y "              RIME: @" -na >> %2
vendprcs VENDDATA -xoeo -zi20 -zc45 -y "      Other E-Mail: @" -na >> %2
vendprcs VENDDATA       -zn         -y "      Credit Cards: "  -na >> %2
vendprcs VENDDATA -xoce -zn        -zt "Access/Euro "          -na >> %2
vendprcs VENDDATA -xoca -zn        -zt "Amex "                 -na >> %2
vendprcs VENDDATA -xocc -zn        -zt "Diner's "              -na >> %2
vendprcs VENDDATA -xocd -zn        -zt "Discover "             -na >> %2
vendprcs VENDDATA -xocm -zn        -zt "MasterCard "           -na >> %2
vendprcs VENDDATA -xocv -zn        -zt "VISA "                 -na >> %2
vendprcs VENDDATA                   -y " "                     -na >> %2
vendprcs VENDDATA -xocx -zi20 -zc45 -y "      Other Credit: @" -na >> %2
vendprcs VENDDATA -xoxms            -y "   Pay: In-Ctry MO: @" -na >> %2
vendprcs VENDDATA -xoxmi            -y "   Pay: Internl MO: @" -na >> %2
vendprcs VENDDATA -xoxps            -y "   Pay: CkPersSame: @" -na >> %2
vendprcs VENDDATA -xoxph            -y "   Pay: CkPrsHrdSn: @" -na >> %2
vendprcs VENDDATA -xoxpr            -y "   Pay: CkPrsHrdRe: @" -na >> %2
vendprcs VENDDATA -xoxpo            -y "   Pay: CkPrsOther: @" -na >> %2
vendprcs VENDDATA -xoxbs            -y "   Pay: CkBankSame: @" -na >> %2
vendprcs VENDDATA -xoxbh            -y "   Pay: CkBnkHrdSn: @" -na >> %2
vendprcs VENDDATA -xoxbr            -y "   Pay: CkBnkHrdRe: @" -na >> %2
vendprcs VENDDATA -xoxbo            -y "   Pay: CkBnkOther: @" -na >> %2
vendprcs VENDDATA -xoxcs            -y "   Pay:   CashSame: @" -na >> %2
vendprcs VENDDATA -xoxch            -y "   Pay:   CashHard: @" -na >> %2
vendprcs VENDDATA -xoxco            -y "   Pay:  CashOther: @" -na >> %2
vendprcs VENDDATA -xoxts            -y "   Pay: TravCkSame: @" -na >> %2
vendprcs VENDDATA -xoxto            -y "   Pay: TrvCkOther: @" -na >> %2
vendprcs VENDDATA -xoxa             -y "   Pay:     AmexMO: @" -na >> %2
vendprcs VENDDATA -xoxe             -y "   Pay: EuroCheque: @" -na >> %2
vendprcs VENDDATA -xoxd             -y "   Pay: DirectBank: @" -na >> %2
vendprcs VENDDATA -xoxon            -y "   Pay:   PONumber: @" -na >> %2
vendprcs VENDDATA -xoxoh            -y "   Pay:   POHrdcpy: @" -na >> %2
vendprcs VENDDATA -xoxx -zi20 -zc45 -y "       Other Funds: @" -na >> %2
vendprcs VENDDATA -xob  -zi20 -zc45 -y "      Bank Account: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Prices and Benefits  " -na >> %2
vendprcs VENDDATA -xic              -y "    Price Currency: @" -na >> %2
vendprcs VENDDATA -y "                      Minimum   Maximum" -na >> %2
vendprcs VENDDATA -xi1p -zn      -y "     Regist. Price:    @" -na >> %2
vendprcs VENDDATA -xi2p                            -y "     @" -na >> %2
vendprcs VENDDATA -xi1bad -zn    -y "   Bene: Addl Data:    @" -na >> %2
vendprcs VENDDATA -xi2bad                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bap -zn    -y "   Bene: Addl Prog:    @" -na >> %2
vendprcs VENDDATA -xi2bap                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bbs -zn    -y "   Bene: BBS Suppt:    @" -na >> %2
vendprcs VENDDATA -xi2bbs                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bbr -zn    -y "   Bene: Branding :    @" -na >> %2
vendprcs VENDDATA -xi2bbr                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bbu -zn    -y "   Bene: Bug Notes:    @" -na >> %2
vendprcs VENDDATA -xi2bbu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcc -zn    -y "   Bene: CheatCode:    @" -na >> %2
vendprcs VENDDATA -xi2bcc                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcm -zn    -y "   Bene: Commissin:    @" -na >> %2
vendprcs VENDDATA -xi2bcm                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcn -zn    -y "   Bene: Contest  :    @" -na >> %2
vendprcs VENDDATA -xi2bcn                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcu -zn    -y "   Bene: Customztn:    @" -na >> %2
vendprcs VENDDATA -xi2bcu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcr -zn    -y "   Bene: Conv Othr:    @" -na >> %2
vendprcs VENDDATA -xi2bcr                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bcx -zn    -y "   Bene: Conv Old :    @" -na >> %2
vendprcs VENDDATA -xi2bcx                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bdi -zn    -y "   Bene: Discounts:    @" -na >> %2
vendprcs VENDDATA -xi2bdi                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1ben -zn    -y "   Bene: Enhanced :    @" -na >> %2
vendprcs VENDDATA -xi2ben                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bfg -zn    -y "   Bene: Goodies  :    @" -na >> %2
vendprcs VENDDATA -xi2bfg                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bfu -zn    -y "   Bene: Future   :    @" -na >> %2
vendprcs VENDDATA -xi2bfu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bgu -zn    -y "   Bene: Guarantee:    @" -na >> %2
vendprcs VENDDATA -xi2bgu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bhi -zn    -y "   Bene: Hints    :    @" -na >> %2
vendprcs VENDDATA -xi2bhi                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bla -zn    -y "   Bene: Latest   :    @" -na >> %2
vendprcs VENDDATA -xi2bla                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bls -zn    -y "   Bene: Life Supp:    @" -na >> %2
vendprcs VENDDATA -xi2bls                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bne -zn    -y "   Bene: Newslettr:    @" -na >> %2
vendprcs VENDDATA -xi2bne                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bpp -zn    -y "   Bene: Prep Form:    @" -na >> %2
vendprcs VENDDATA -xi2bpp                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bpm -zn    -y "   Bene: Print Man:    @" -na >> %2
vendprcs VENDDATA -xi2bpm                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bqr -zn    -y "   Bene: QuickRef :    @" -na >> %2
vendprcs VENDDATA -xi2bqr                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1brl -zn    -y "   Bene: RecordLim:    @" -na >> %2
vendprcs VENDDATA -xi2brl                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bre -zn    -y "   Bene: RRS Elim :    @" -na >> %2
vendprcs VENDDATA -xi2bre                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1brd -zn    -y "   Bene: RepeatDly:    @" -na >> %2
vendprcs VENDDATA -xi2brd                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bsd -zn    -y "   Bene: Samp Data:    @" -na >> %2
vendprcs VENDDATA -xi2bsd                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bso -zn    -y "   Bene: SourceCod:    @" -na >> %2
vendprcs VENDDATA -xi2bso                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bsu -zn    -y "   Bene: Subscript:    @" -na >> %2
vendprcs VENDDATA -xi2bsu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1btl -zn    -y "   Bene: Time Limt:    @" -na >> %2
vendprcs VENDDATA -xi2btl                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1btu -zn    -y "   Bene: Tutorial :    @" -na >> %2
vendprcs VENDDATA -xi2btu                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bun -zn    -y "   Bene: UpdateNot:    @" -na >> %2
vendprcs VENDDATA -xi2bun                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1buf -zn    -y "   Bene: UpdateFre:    @" -na >> %2
vendprcs VENDDATA -xi2buf                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bvs -zn    -y "   Bene: VoiceSupp:    @" -na >> %2
vendprcs VENDDATA -xi2bvs                         -y "      @" -na >> %2
vendprcs VENDDATA -xi1bwa -zn    -y "   Bene: Watermark:    @" -na >> %2
vendprcs VENDDATA -xi2bwa                         -y "      @" -na >> %2
vendprcs VENDDATA         -zn     -y "   String Example :    " -na >> %2
vendprcs VENDDATA -xi1bad -zn -zt "A"                          -na >> %2
vendprcs VENDDATA -xi1bbs -zn -zt "B"                          -na >> %2
vendprcs VENDDATA -xi1bcm -zn -zt "C"                          -na >> %2
vendprcs VENDDATA -xi1bdi -zn -zt "D"                          -na >> %2
vendprcs VENDDATA -xi1ben -zn -zt "E"                          -na >> %2
vendprcs VENDDATA                   -y " "                     -na >> %2
vendprcs VENDDATA -xi1v -zi20 -zc45 -y "    Min Other Bene: @" -na >> %2
vendprcs VENDDATA -xi2v -zi20 -zc45 -y "    Max Other Bene: @" -na >> %2
vendprcs VENDDATA                   -y "  Shipping and Handlg" -na >> %2
vendprcs VENDDATA -xisc             -y "      Same Country: @" -na >> %2
vendprcs VENDDATA -xisn             -y "     North America: @" -na >> %2
vendprcs VENDDATA -xiss             -y "     South America: @" -na >> %2
vendprcs VENDDATA -xise             -y "            Europe: @" -na >> %2
vendprcs VENDDATA -xisa             -y "              Asia: @" -na >> %2
vendprcs VENDDATA -xisf             -y "            Africe: @" -na >> %2
vendprcs VENDDATA -xisp             -y "       Pacific Rim: @" -na >> %2
vendprcs VENDDATA -xims             -y "     Site Licenses: @" -na >> %2
vendprcs VENDDATA -ximt             -y "     SiteLice Text: @" -na >> %2
vendprcs VENDDATA -ximd             -y "     Dlr Discounts: @" -na >> %2
vendprcs VENDDATA -xime             -y "     Dlr Disc Text: @" -na >> %2
vendprcs VENDDATA -ximr             -y "         Royalties: @" -na >> %2
vendprcs VENDDATA -ximq             -y "   Royalties Negot: @" -na >> %2
vendprcs VENDDATA -ximp             -y "    Royalties Text: @" -na >> %2
vendprcs VENDDATA -ximn             -y "     NSV Available: @" -na >> %2
vendprcs VENDDATA -ximl             -y "     LCR Available: @" -na >> %2
vendprcs VENDDATA -xirm             -y "       Min Royalty: @" -na >> %2
vendprcs VENDDATA -xirn -zi20 -zc45 -y "  Min Royalty Text: @" -na >> %2
vendprcs VENDDATA -xirx             -y "       Max Royalty: @" -na >> %2
vendprcs VENDDATA -xiry -zi20 -zc45 -y "  Max Royalty Text: @" -na >> %2
vendprcs VENDDATA -xira -zi20 -zc45 -y "     Royalty Agent: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Support Information  " -na >> %2
vendprcs VENDDATA -xsa  -zi20 -zc45 -y "           Address: @" -na >> %2
vendprcs VENDDATA -xsp              -y "       Order Phone: @" -na >> %2
vendprcs VENDDATA -xsf              -y "         Order FAX: @" -na >> %2
vendprcs VENDDATA -xsen             -y "          BBS Name: @" -na >> %2
vendprcs VENDDATA -xseb             -y "         BBS Phone: @" -na >> %2
vendprcs VENDDATA -xseu             -y "      BBS Username: @" -na >> %2
vendprcs VENDDATA -xsea             -y "       Amer OnLine: @" -na >> %2
vendprcs VENDDATA -xsec             -y "        CompuServe: @" -na >> %2
vendprcs VENDDATA -xsed             -y "            Delphi: @" -na >> %2
vendprcs VENDDATA -xseg             -y "             Genie: @" -na >> %2
vendprcs VENDDATA -xsep             -y "           Prodigy: @" -na >> %2
vendprcs VENDDATA -xsef             -y "           FidoNet: @" -na >> %2
vendprcs VENDDATA -xsei             -y "          Internet: @" -na >> %2
vendprcs VENDDATA -xser             -y "              RIME: @" -na >> %2
vendprcs VENDDATA -xseo -zi20 -zc45 -y "      Other E-Mail: @" -na >> %2
vendprcs VENDDATA -xss  -zi20 -zc45 -y "    Support Forums: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "General Distrib Info " -na >> %2
vendprcs VENDDATA -xgt              -y "      Distrib Type: @" -na >> %2
vendprcs VENDDATA -xgmu             -y "   US Only (crypt): @" -na >> %2
vendprcs VENDDATA                   -y "  Allowed Changes    " -na >> %2
vendprcs VENDDATA -xgmp             -y "       Pkg No Mods: @" -na >> %2
vendprcs VENDDATA -xgmf             -y "     Files No Mods: @" -na >> %2
vendprcs VENDDATA -xgmhs            -y "       Help/Go Sep: @" -na >> %2
vendprcs VENDDATA -xgmas            -y "      Ads Separate: @" -na >> %2
vendprcs VENDDATA -xgmaa            -y "        Ads Append: @" -na >> %2
vendprcs VENDDATA -xgmi             -y "       New Install: @" -na >> %2
vendprcs VENDDATA -xgmit            -y "      Install Text: @" -na >> %2
vendprcs VENDDATA -xgmc             -y "      New Compress: @" -na >> %2
vendprcs VENDDATA -xgmci            -y "     Intl Compress: @" -na >> %2
vendprcs VENDDATA -xgmct            -y "     Compress Text: @" -na >> %2
vendprcs VENDDATA                   -y "  Bundling Allowed   " -na >> %2
vendprcs VENDDATA -xgms             -y "      With Similar: @" -na >> %2
vendprcs VENDDATA -xgmsp            -y "      Permiss Reqd: @" -na >> %2
vendprcs VENDDATA -xgmst            -y "      Similar Text: @" -na >> %2
vendprcs VENDDATA -xgmd             -y "   With Dissimilar: @" -na >> %2
vendprcs VENDDATA -xgmdp            -y "      Permiss Reqd: @" -na >> %2
vendprcs VENDDATA -xgmdt            -y "       Dissim Text: @" -na >> %2
vendprcs VENDDATA                   -y "  Miscellaneous      " -na >> %2
vendprcs VENDDATA -xgg  -zi20 -zc45 -y "        Geographic: @" -na >> %2
vendprcs VENDDATA -xgi  -zi20 -zc45 -y "           Install: @" -na >> %2
vendprcs VENDDATA -xgc  -zi20 -zc45 -y "          Compress: @" -na >> %2
vendprcs VENDDATA -xgh  -zi20 -zc45 -y "            Change: @" -na >> %2
vendprcs VENDDATA -xgs  -zi20 -zc45 -y "     Group Similar: @" -na >> %2
vendprcs VENDDATA -xgd  -zi20 -zc45 -y "      Group Dissim: @" -na >> %2
vendprcs VENDDATA -xgu  -zi20 -zc45 -y "    Vendor Upgrade: @" -na >> %2

vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "Distribution Policy  " -na >> %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   BBS               " -na >> %2
call extrdist VENDDATA b %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   File-Distrib Net  " -na >> %2
call extrdist VENDDATA f %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Disk Vendor       " -na >> %2
call extrdist VENDDATA d %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   CD-ROM            " -na >> %2
call extrdist VENDDATA c %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Single-Site Rack  " -na >> %2
call extrdist VENDDATA o %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Rack Distributor  " -na >> %2
call extrdist VENDDATA r %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Book Enclosure    " -na >> %2
call extrdist VENDDATA k %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Subscription      " -na >> %2
call extrdist VENDDATA s %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Magazine Cover Disk" -na >> %2
call extrdist VENDDATA m %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   TV/Cable/Satellite" -na >> %2
call extrdist VENDDATA t %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Phone (1-900)     " -na >> %2
call extrdist VENDDATA p %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Install by Distributor" -na >> %2
call extrdist VENDDATA i %2
vendprcs VENDDATA                   -y "                     " -na >> %2
vendprcs VENDDATA                   -y "   Other Methods     " -na >> %2
call extrdist VENDDATA u %2

vendprcs                      -y " "                               >> %2
vendprcs                   -y "Distributors of Registered Version" >> %2
for %%i in (1 2 3 4 5 6 7 8 9 10) do call extrregl %1 %%i %2

:exit


