echo off
cls
rem Installation batch file for STATMAN.

rem user must specify a valid drive letter (C to F)
if %1. == . goto nodrive
if %1 == c: goto start
if %1 == C: goto start
if %1 == d: goto start
if %1 == D: goto start
if %1 == e: goto start
if %1 == E: goto start
if %1 == f: goto start
if %1 == F: goto start
goto invaliddrive

:start

echo ͻ
echo                                                                        
echo                 STATMAN Fantasy Baseball Installation                  
echo                                                                        
echo    This will create a directory called %1\STATMAN on your hard disk,   
echo    and will install STATMAN Fantasy Baseball in that directory.        
echo                                                                        
echo    You will need about 1 megabyte of free disk space on your hard      
echo    disk to install STATMAN.                                            
echo                                                                        
echo     If you don't want to install STATMAN at this time, press Ctrl-C.   
echo                                                                        
echo ͼ
pause

rem check for \statman on the specified drive
chmod -hr %1\statman\*.*
if not exist %1\statman\*.* goto createdirectory
del %1\statman\*.*

rem create \statman on the specified drive
:createdirectory
echo 
echo Creating directory %1\STATMAN
md %1\statman
rem create \statman\yearly on the specified drive
echo Creating directory %1\STATMAN\YEARLY
md %1\statman\yearly
rem create \statman\update on the specified drive
echo Creating directory %1\STATMAN\UPDATE
md %1\statman\update

:1

rem make sure default drive contains the program disk
if exist statman.exe goto 2
echo 
echo Insert the PROGRAM DISK at this time.
pause
goto 1

:2

rem copy files to hard disk
echo 
echo Copying STATMAN.EXE....
copy statman.exe %1\statman
if not exist %1\statman\statman.exe goto installerror

if not exist makefile.exe goto 3
makefile %1\statman

:3
rem make sure default drive contains the DATA DISK

if exist makedb.exe goto 4
echo 
echo Insert the DATA DISK at this time.
pause
goto 3

:4

rem copy data files to hard disk

echo 
echo Copying MLTEAMS.DB....
copy mlteams.db %1\statman
if not exist %1\statman\mlteams.db goto installerror

echo 
echo Copying HELP.DAT....
copy *.dat %1\statman
if not exist %1\statman\help.dat goto installerror

rem copy PLAYER database files to hard disk

echo 
echo Copying STATMAN files to build PLAYER Database....
copy makedb.exe %1\statman\yearly
if not exist %1\statman\yearly\makedb.exe goto installerror

copy *.ros %1\statman\yearly
if not exist %1\statman\yearly\*.ros goto installerror

rem build PLAYER database

echo 
echo Building PLAYER Database....
echo this may take a few minutes...
%1
cd \statman\yearly
makedb %1\statman\yearly player93.ros
del *.exe
del *.ros

rem leave user ready to start... in %1\statman
%1
cd \statman

echo 
echo STATMAN has been correctly installed.
echo 
echo To start STATMAN, type STATMAN at the DOS prompt.

goto done

rem --- user didn't specify a drive letter followed by a colon.
:nodrive
echo ͻ
echo                                                                        
echo                           INSTALLATION ERROR!                          
echo                                                                        
echo         To install STATMAN on your hard disk, you MUST specify         
echo         the drive to install STATMAN onto.                             
echo           Example:                                                     
echo                   to install STATMAN on drive C                        
echo                   type "INSTALL C:" and press Enter.                   
echo                                                                        
echo ͼ
goto errorDone

rem --- user specified invalid drive letter.
:invaliddrive
echo ͻ
echo                                                                        
echo                           INSTALLATION ERROR!                          
echo                                                                        
echo           The hard drive letter MUST be a VALID drive letter           
echo           from C to F and MUST be followed by a colon.                 
echo             Example:                                                   
echo                     to install STATMAN on drive C                      
echo                     type "INSTALL C:" and press Enter.                   
echo                                                                        
echo ͼ
goto errorDone

rem --- general installation error.
:installationerror
echo ͻ
echo                                                                        
echo                           INSTALLATION ERROR!                          
echo                                                                        
echo           Perhaps there isn't enough space on your hard disk.          
echo         Installation requires at least 1 megabyte of free space!       
echo                                                                        
echo ͼ
goto errorDone

rem --- dir already exists.
:directorythere
echo ͻ
echo                                                                        
echo                           INSTALLATION ERROR!                          
echo                                                                        
echo       The %1\STATMAN directory already exists on this disk drive!      
echo       Delete this directory and all files in it and try again.         
echo                                                                        
echo ͼ
goto errorDone

rem --- goto here after an error is detected, to print a message and exit.
:errorDone
echo 
echo STATMAN was not installed correctly.
echo 

rem --- exit batch file.
:done

