/* LiveWire 2.1 installation program */

/* Install REXX system functions */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* Determine the path to LiveWire */
parse source . . argv0 .
temp = reverse(argv0)
temp = substr(temp, pos('\', temp))
if length(temp) > 3 then temp = substr(temp, 2)
CurrentPath = reverse(temp)

/* Begin installation */
ECHO OFF
call SysCls
Say "LiveWire 2.1 Release Install Program"
Say "Copyright 1993 Les Novell"
Say ""
Say "This installation script assumes that it is running from the directory"
Say "on your hard drive where you want LiveWire 2.1"
Say ""
Say "This installation program will remove all old LiveWire configuration files"
Say "(except dialing directories), create the .\PROTOCOL directory,"
Say "and install a desktop folder for LiveWire."
Say ""
Say "Press [ENTER] to perform installation, or [CTRL-BREAK] to halt"
Pull A

call SysCls
Say "Beginning installation..."
Say ""
Say "Removing any residual configuration files..."
"ERASE LW.CFG LW.ICI LW.MAC LW.MHF LW.XLT VT100.EMU 2>NUL"
Say ""
Say "Creating directory PROTOCOL..."
Say "  LiveWire will search this directory for installable file transfer"
Say "  protocols, including the path."
"MKDIR PROTOCOL 2>NUL"
Say ""
Say "Creating a desktop folder for LiveWire"
Say "  The desktop folder will contain the program and related"
Say "  documentation. It will be located in the upper left-hand"
Say "  corner of your desktop. Move it wherever you like."
Say ""

/* Create the LiveWire folder */
setting="OBJECTID=<LIVEWIRE21_FOLDER>;";
ret = SysCreateObject("WPFolder", "LiveWire Communications", "<WP_DESKTOP>", setting, "U")

/* Create Registration object */
setting="OBJECTID=<LIVEWIRE21_REG>;"||,
	 "EXENAME="||CurrentPath||"\LW21.EXE;"||,
         "ICONFILE="||CurrentPath||"\LWREG.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PARAMETERS=REGISTER;"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "Register LiveWire", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create README object */
setting="OBJECTID=<LIVEWIRE21_README>;"||,
	 "EXENAME=E.EXE;"||,
	 "PARAMETERS=READ.ME;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "Read Me First", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create DOCUMENTATION object */
setting="OBJECTID=<LIVEWIRE21_DOCS>;"||,
	 "EXENAME=VIEW.EXE;"||,
	 "PARAMETERS=LW21.INF;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "LiveWire 2.1 Manuals", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create ORDER.FRM object */
setting="SHADOWID="||CurrentPath||"\ORDER.FRM;"
ret = SysCreateObject("WPShadow", "How to order LiveWire 2.1", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create Program object */
setting="OBJECTID=<LW_EXE>;"||,
	 "EXENAME="||CurrentPath||"\LW21.EXE;"||,
         "ICONFILE="||CurrentPath||"\LWPRG.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "LiveWire 2.1 Program", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create Host Mode object */
setting="OBJECTID=<LIVEWIRE21_HOST>;"||,
	 "EXENAME="||CurrentPath||"\LW21.EXE;"||,
	 "PARAMETERS=/Shost.cmd;"||,
         "ICONFILE="||CurrentPath||"\LWHST.ICO;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=WINDOWABLEVIO;"
ret = SysCreateObject("WPProgram", "LiveWire 2.1 Host Mode", "<LIVEWIRE21_FOLDER>", setting, "R")

/* Create PM File Transfer Monitor object */
setting="OBJECTID=<LIVEWIRE21_XFERMONITOR>;"||,
	 "EXENAME="||CurrentPath||"\LWXFER.EXE;"||,
	 "STARTUPDIR="CurrentPath";"||,
	 "PROGTYPE=PM;"
ret = SysCreateObject("WPProgram", "File Transfer Monitor", "<LIVEWIRE21_FOLDER>", setting, "R")

Say "Installation complete."
Say "To configure LiveWire, double click on the LiveWire icon."
Say ""
