#ifndef FPL_H
#define FPL_H
/*
**   $Filename: libraries/FPL.h $
**   $Release: 6.0 $
**   $Date: 1994/02/18 19:08:51 $
**
**   (C) Copyright 1992, 1993 by FrexxWare
**       All Rights Reserved
*/

/************************************************************************
 *                                                                      *
 * fpl.library - A run time library interpreting script langauge.       *
 * Copyright (C) 1992, 1993 FrexxWare                                   *
 * Author: Daniel Stenberg                                              *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                      *
 * Daniel Stenberg                                                      *
 * Birger Jarlsgatan 93b 3tr                                            *
 * 113 56 Stockholm                                                     *
 * Sweden                                                               *
 *                                                                      *
 * FidoNet 2:201/328      email: dast@sth.frontec.se                    *
 *                                                                      *
 ************************************************************************/

/***** ALL BY FPL SUPPLIED, IMPLEMENTED AND SUPPORTED RETURN CODES: ******/
typedef enum {
  FPL_OK,
  FPL_EXIT_OK,		 /* no error, the program stated simply exit() */
  FPL_COULDNT_OPEN_DOS,
  FPL_DIVISION_BY_ZERO,
  FPL_ILLEGAL_ANCHOR,
  FPL_ILLEGAL_ARRAY,
  FPL_ILLEGAL_ASSIGN,
  FPL_ILLEGAL_BREAK,
  FPL_ILLEGAL_CONDOP,
  FPL_ILLEGAL_CONTINUE,
  FPL_ILLEGAL_DECLARE,
  FPL_ILLEGAL_PARAMETER,
  FPL_ILLEGAL_PREOPERATION,
  FPL_ILLEGAL_PROTOTYPE,
  FPL_ILLEGAL_RESIZE,
  FPL_ILLEGAL_STATEMENT,
  FPL_ILLEGAL_VARIABLE,
  FPL_INTERNAL_ERROR,
  FPL_INSIDE_NOT_FOUND,
  FPL_MISSING_APOSTROPHE,
  FPL_MISSING_ARGUMENT,
  FPL_MISSING_BRACE,
  FPL_MISSING_BRACKET,
  FPL_MISSING_OPERAND,
  FPL_MISSING_PARENTHESES,
  FPL_MISSING_SEMICOLON,
  FPL_NO_ACTION,
  FPL_OPEN_ERROR,
  FPL_OUT_OF_MEMORY,
  FPL_OUT_OF_REACH,
  FPL_OUT_OF_STACK,
  FPL_PROGRAM_STOPPED,
  FPL_READONLY_VIOLATE,
  FPL_SYNTAX_ERROR,
  FPL_UNBALANCED_COMMENT,
  FPL_UNEXPECTED_END,
  FPL_UNMATCHED_BRACE,
  FPL_IDENTIFIER_NOT_FOUND,
  FPL_IDENTIFIER_USED,

  FPL_UNKNOWN_ERROR /* this or higher is unknown error codes! */

  } ReturnCode;

/*********************************************************************
 *
 * Argument defines:
 *
 */
  
#define FPL_STRARG        'S'
#define FPL_INTARG        'I'
#define FPL_OPTARG	  'O'
#define FPL_STRARG_OPT    (FPL_STRARG^32)
#define FPL_INTARG_OPT    (FPL_INTARG^32)
#define FPL_OPTARG_OPT    (FPL_OPTARG^32)
#define FPL_ARGLIST       '>'

/*********************************************************************
 * fplInit() and fplReset() tags:
 ********************************************************************/

#define FPLTAG_END            0
#define FPLTAG_DONE           0
#define FPLSEND_DONE	      0
#define FPLSEND_END	      0
/* End of tag list defines! */

#define FPLTAG_INTERVAL       1 /* data is a function pointer */
/* Define the interval function pointer! */

#define FPLTAG_ZERO_TERMINATE 2 /* obsolete tag from version 5*/

#define FPLTAG_STACK          3 /* data is size in bytes */
/* Important only for the Amiga library version! Default startup size of the
   library stack. */

#define FPLTAG_USERDATA       4 /* data is free to use to anything! */
/* Userdata able to read anywhere with GetUserdata(): */

#define FPLTAG_FUNCDATA       FPLTAG_USERDATA /* data is free to use */
/* Specifies private data to a specific function. */

#define FPLTAG_FUNCTION       5 /* data is a function pointer */
/* fplAddFunction() tag only. function handler routine for this function. */

#define FPLTAG_MAXSTACK	      6 /* data is size in bytes */
/* (Amiga) Max stack allocation left when a single FPL execution is done. */

#define FPLTAG_STACKLIMIT     7 /* data is size in bytes */
/* (Amiga) Absolute maximum memory area used as stack by one single FPL
   program. */

/* removed obsolete tag `FPLTAG_FREE' ! */

#define FPLTAG_INTERNAL_ALLOC 9 /* data is function pointer */
/* To a "void *(*)(long)" (on Amiga, the parameter will be sent in d0
   and *not* on the stack)! */
#define FPLTAG_INTERNAL_DEALLOC 10 /* data is function pointer */
/* To a "void (*)(void *, long);" (on Amiga, the parameters will be sent in
   the registers a1 and d0 and *NOT* on the stack as all other functions do. */

#define FPLTAG_INTERPRET 11 /* data is a char pointer */
/* To a fully FPL syntax statement to be interpreted instead of the
   actual main function of the program that is about to get started. */

#define FPLTAG_STARTPOINT 12 /* data is a char pointer */
/* To the alternative start position of this program. */
#define FPLTAG_STARTLINE  13 /* data is integer */
/* The line of the upper start point if not 1. */

#define FPLTAG_STOREGLOBALS 14 /* data is boolean */
/* This enables/disables the FPL global symbol storage ability. */

#define FPLTAG_CACHEALLFILES 15 /* data is one of the defines below */
/* Should FPL cache all files exporting functions? */

#define FPLTAG_CACHEFILE 16 /* data is one of the defines below */
/* Should FPL cache this file. Default is FPLTAG_CACHEALLFILES or false. */

#define FPLCACHE_NONE    0 /* never cache */
#define FPLCACHE_ALWAYS  1 /* always cache */
#define FPLCACHE_EXPORTS 2 /* cache if symbols were exported */

#define FPLTAG_FILEID 17 /* data is a unique file identification 32-bit */
/* This fileID is used by FPL. Associate this program with this fileID!
   If you ever make a FPLSEND_FLUSHCACHEDFILES and this file is removed from
   memory, FPL will use this when requesting the file from you!
   If this file doesn't declare any `export' functions, if you never flushes
   this file or if you don't allow saved export variables, this tag can be
   ignored (FPL will then create a temporary fileID to use). */

#define FPLTAG_PROGNAME 18 /* data is char pointer to zero terminated name */
/* When using fplExecuteScript(), FPL does not have a name for the program.
   If you want anything but <unknown program> in a possible error report,
   you should use this. fplEXecuteFile() automatically sets this tag, but
   if you don't want the program to be named as the file name, use this tag
   then too! */

#define FPLTAG_FILEGLOBALS 19 /* data is pointer to long */
#define FPLTAG_ISCACHED FPLTAG_FILEGLOBALS
/* Supply this tag with a pointer to a `long' and receive a zero (0) if no
   global symbols was declared, or a non-zero (_not_ the number of symbols)
   value if any global symbols were declared.

   If this leaves a non-zero value, it means that FPL has stored symbols
   associated with this program's ID. If you do not want them, use the
   {FPLSEND_FREEFILE, filename} tag to clean up. If you want to be able
   to start the same program using the old global symbol values (and not
   confusing the interpreter), use the same file name on next start.
   */

#define FPLTAG_FILENAMEGET 20 /* data is boolean */
/* This tag tells FPL that the program name is ok to use as file name to load
   the program from after a flush. fplExecuteFile() uses this tag as default.
   */

#define FPLTAG_MINSTACK 21 /* data is long */
/* (Amiga) This tag is used in fplInit() or fplReset() and informs FPL about
   the smallest acceptable stack size that you want when the interface
   function is called. */

#define FPLTAG_LOCKUSED 22 /* data is boolean */
/* (Amiga) This tag makes FPL to Lock() on the file currently executed with
   fplExecuteFile() or a program exeuted with that function that declared
   global data. */

/**** NEW FROM VERSION 5: ****/

#define FPLTAG_HASH_TABLE_SIZE 23 /* data is a long */
/* This sets the hash table size. USE ONLY IN fplInit()!!! */

#define FPLTAG_NEWLINE_HOOK 24 /* data is a standard long (*)(void *); */
/* Called after every newline character read. The argument is sent in register
   A0 in the Amiga version. The argument is so far only the fplinit() return
   code. This might be subject to change to next release!! If you intend to
   use this, use caution! */

/**** NEW FROM VERSION 5.3: ****/
#define FPLTAG_ALLFUNCTIONS 25 /* data is boolean */
/* Enables the FPL_UNKNOWN_FUNCTION interface message. Whenever FPL finds a
   function not recognized, it will still parse all arguments and call the
   interface function. */

/**** NEW FROM VERSION 8 (expected anyway): ****/
#define FPLTAG_COMPILE 26

#define FPLTAG_STRING_RETURN 27 /* data is pointer to a char pointer */
/* enables the top level FPL program to return a string to the calling
   program in the pointer the data supplies a pointer to. NULL disables
   the ability. The string should be freed using the brand new function
   fplFreeString() */

#define DUMMY	100	  /* ignore this */

/**********************************************************************
 * Here follows the tags for the fplSend() function. New for V3.
 *********************************************************************/

#define FPLSEND_STRING	(DUMMY +1)
/* Use this when returning a string from a user function. See FPLSEND_STRLEN */

#define FPLSEND_STRLEN  (DUMMY +2)
/* Specifies the length of the returned string. If this is -1, a strlen()
   will be performed by FPL to find out the real length! */

#define FPLSEND_INT	(DUMMY +3)
/* You return an integer from the function. */

#define FPLSEND_GETRESULT (DUMMY +4)
/* You specify a pointer to a `long' to hold the result of the last interval
   function call. */

#define FPLSEND_GETLINE (DUMMY +5)
/* You specify a pointer to a `long' to hold the number of the current line the
   interpreter is working on. */

#define FPLSEND_GETRETURNCODE (DUMMY +6)
/* You specify a pointer to a `long'  to hold the value received by the last
   return() or exit() call in the FPL program. */

#define FPLSEND_GETUSERDATA (DUMMY +7)
/* You specify a pointer to a `long'  to hold the userdata specified in the
   `FPLTAG_USERDATA' tag's data field in the fplInit() call. */

#define FPLSEND_GETCOLUMN (DUMMY +8)
/* You specify a pointer to a `long'  to hold the number of the current column
   the interpreter is working on. */

#define FPLSEND_FLUSHCACHE (DUMMY +9)
/* specify TRUE/FALSE wheather you want FPL to flush (empty) the internal
   memory cache/queue. */

#define FPLSEND_FREEFILE (DUMMY +10) /* data is a program name pointer */
/* FPL frees all functions associated with the given program! */

#define FPLSEND_PROGRAMFILE FPLSEND_STRING
/* Used when returning a program's file name to FPL. */

#define FPLSEND_PROGRAM (DUMMY +11) /* data is pointer to an array */
/* When using functions in different source files, this is one way to give
   FPL information about where to find a certain function! */

#define FPLSEND_GETPROGNAME (DUMMY +12)
/* Get pointer to the last interpretated FPL program name. If any error has
   occurred, this will be the failing program name! */

#define FPLSEND_CONFIRM (DUMMY +13)
/* Used to confirm the query from FPL. Currently, taht can only be
   FPL_FLUSH_FILE. */

#define FPLSEND_FLUSHFILE (DUMMY +14)
/* Flush the file with the specified fileID. If no ID is specified, all unused
   files will be flushed. */

#define FPLSEND_STEP (DUMMY +15)
/* Moves the current interpret position. Negative number is backwards and
   positive forwards. */

#define FPLSEND_GETSTACKSIZE (DUMMY + 16) /* data is pointer to long */
/* (Amiga) Receive the current stack size! */

#define FPLSEND_GETSTACKUSED (DUMMY + 17) /* data is pointer to long */
/* (Amiga) Receive the current amount of stack used (this isn't an exact
   figure) */

#define FPLSEND_SETPROGNAME (DUMMY + 18) /* data is char pointer */
/* This tag forces a new name to the current (executing) program.
   See also FPLTAG_PROGNAME */

#define FPLSEND_SETFILENAMEGET (DUMMY + 19) /* data is boolean */
/* This tag sets or clears the same FPLTAG_FILENAMEGET option */

/**** NEW FOR VERSION 4: ****/

#define FPLSEND_GETSYMBOL_FUNCTIONS	(DUMMY + 20)
#define FPLSEND_GETSYMBOL_MYFUNCTIONS	(DUMMY + 21)
#define FPLSEND_GETSYMBOL_FPLFUNCTIONS	(DUMMY + 22)
#define FPLSEND_GETSYMBOL_VARIABLES	(DUMMY + 23)
#define FPLSEND_GETSYMBOL_CACHEDFILES	(DUMMY + 24)
#define FPLSEND_GETSYMBOL_FREE		(DUMMY + 25)
/* See FPL.guide for information and docs */

/**** NEW FOR VERSION 5: ****/

#define FPLSEND_GETPROG (DUMMY + 26)
/* Supply a pointer to a char pointer, and you'll get a pointer to the current
   program. */

#define FPLSEND_GETINTERVAL (DUMMY + 27)
/* Supply a pointer to a function pointer, and you'll receive a pointer to the
   specified interval function. */

#define FPLSEND_GETNEWLINE_HOOK (DUMMY + 28)
/* Supply a pointer to a function pointer, and you'll receive a pointer to the
   specified newline hook. */

#define FPLSEND_GETFUNCTION (DUMMY + 29)
/* Supply a pointer to a function pointer, and you'll receive a pointer to the
   specified interface function. */

#define FPLSEND_GETSYMBOL_ALLVARIABLES (DUMMY + 30)
#define FPLSEND_GETSYMBOL_ALLFUNCTIONS (DUMMY + 31)
/* See FPL.guide for information */

/**** NEW FOR VERSION 5.3: ****/
#define FPLSEND_GETVIRLINE (DUMMY + 32)
/* return the virtual line number in the long you send a pointer to!
   NOTE: The virtual line number is most often the "real" line number of your
   program. FPL counts every appearance of \x0a in the program and that makes
   the VIRTUAL line number since that has nothing to do with how FPL really
   counts the lines!
   Future versions will be able to change this line number run-time, using the
   #line - instruction!
   */

#define FPLSEND_GETVIRFILE (DUMMY + 33)
/* return the virtual filename in the char pointer you send a pointer to!
   NOTE: The virtual file name is most often the name of the current
   executed program. 
   Future versions will be able to change this line number run-time, using the
   #line - instruction!
   */

/**** NEW FOR VERSION 6: ****/
#define FPLSEND_DONTCOPY_STRING (DUMMY + 34)
/* The string we send to FPL is allocated with fplAllocString(). */

struct fplArgument {
  /*
   * Interface function argument structure...
   */

  char *name;		/* Name */
  long ID;              /* ID */
  void **argv;          /* Pointer array of all arguments in the same order as
			   they were read. Integers are simply stored in the
			   pointer (read docs for info about this). */
  long argc;            /* Number of members in the array above */
  void *key;		/* The return code from your initial fplInit() call! */
  char *format;		/* Pointer to the actual format string of this
			   function. Functions using '>' in their format
			   string can get quite a long string here... */
  void *funcdata;	/* The same data as passed in the FPLTAG_FUNCDATA tag
			   of your AddFunction() call. Your possibility to
			   pass function specific data through the library. */
  /* NEW FOR FPL 5.10 */
  char ret;		/* Expected return type. Especially usefull when
			   using functions with optional return types. */
};

struct fplSymbol {
  /*
   * Using the functions FPLSEND_GETSYMBOL_XXXXXXX will result in a pointer
   * to a structure like this!
   *
   * Free that pointer by FPLSEND_GETSYMBOL_FREE.
   */
  long num;
  char **array;
};

/****************************/
/***** STRING LENGTH: *******/
/****************************/
/* Since the no-zero-terminated-strings theories was introduced, we can't
   use a simple strlen() to get the string length. This macro will do the
   job for you. (Extensively typecasted to apply to ANSI standard.)
   Supply the name of the structure pointer you received in the interface
   function, and the number of the string. Returns the length of that
   string. */
#define FPL_STRING_LENGTH(arg, n)\
  ((long)*(long *)((char *)(arg)->argv[n]-sizeof(long)))

/* Supply a string pointer received in the interface function. Returns
   the length of the FPL-string! */
#define FPL_STRLEN(arg)\
  ((long)*(long *)((char *)(arg)-sizeof(long)))

/****************************/
/***** FPLARGUMENT.ID: ******/
/****************************/
#define FPL_GENERAL_ERROR -1
/* There was an error in the interpreting.
   arg->argv[0] contains the error number.
   */

#define FPL_FILE_REQUEST  -2
/* FPL wants a file from you that was previously flushed! The arg->argv[0]
   contains the fileID of the program. Use FPLSEND_PROGRAM or
   FPLSEND_PROGFILE to respond. */

#define FPL_FLUSH_FILE -3
/* FPL allows you to remove the allocation associated with a certain program.
   The arg->argv[0] contains the fileID. Respond with FPLSEND_CONFIRM and the
   data field TRUE if you really do want to flush that program. */

#define FPL_WARNING -4
/* FPL warning. ->argv[0] holds the error number. Return a fplSend() with
   {FPLSEND_CONFIRM, TRUE} if you want FPL to try to continue anyway! */

#define FPL_HIJACK_READ -5
/* The program accessed a variable that previously has been hijacked!
   This is currently not implemented, but are tested in the laboratories! */

#define FPL_UNKNOWN_FUNCTION -6 /* New from version 5.3 */
/* The program has interpreted an unknown function identifier. The name
   is found in the ->name member, and the parameters are read as usual via
   the ->format member from the ->argc and ->argv members. ->funcdata are
   reserved for future use, do not depend upon it to hold anything
   particular. This is activated with FPLTAG_ALLFUNCTIONS. */

#define FPL_COMPILE -7 /* development ID */

/****************************/
/****** Limitations: ********/
/****************************/
/* Max length of a resulting error message: */
#define FPL_ERRORMSG_LENGTH 100

#define FPLNAME "fpl.library"

#define FPL_VERSION  5
#define FPL_REVISION 12
#endif
