;;; loaddefs.el --- define standard autoloads and keys of other files

;; Modified for emx by Eberhard Mattes, Dec 1993

;; Copyright (C) 1985, 1986, 1987, 1992, 1993 Free Software Foundation, Inc.

;; Maintainer: FSF
;; Keywords: internal

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;; Special formatting conventions are used in this file!
;;;
;;; a backslash-newline is used at the beginning of a documentation string
;;; when that string should be stored in the file etc/DOCnnn, not in core.
;;;
;;; Such strings read into Lisp as numbers (during the pure-loading phase).
;;;
;;; But you must obey certain rules to make sure the string is understood
;;; and goes into etc/DOCnnn properly.  Otherwise, the string will not go
;;; anywhere!
;;;
;;; The doc string must appear in the standard place in a call to
;;; defun, autoload, defvar or defconst.  No Lisp macros are recognized.
;;; The open-paren starting the definition must appear in column 0.
;;;
;;; In defvar and defconst, there is an additional rule:
;;; The double-quote that starts the string must be on the same
;;; line as the defvar or defconst.
;;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;;; **********************************************************************
;;; You should never need to write autoloads by hand and put them here.
;;;
;;; It is no longer necessary.  Instead use autoload.el to maintain them
;;; for you.  Just insert ";;;###autoload" before defuns or defmacros you
;;; want to be autoloaded, or other forms you want copied into loaddefs.el
;;; (defvars, key definitions, etc.).  For example, 
;;;	;;;###autoload
;;;	(defun foobar () ....)
;;;	;;;###autoload (define-key global-map "f" 'foobar)
;;;	;;;###autoload
;;;	(defvar foobar-var nil "\
;;;	This is foobar-var's doc-string.")
;;;
;;; Then do M-x update-file-autoloads on the file to update loaddefs.el.
;;;
;;; You can also use M-x update-directory-autoloads to update the autoloads
;;; in loaddefs.el for all .el files in the lisp/ directory, or M-x
;;; update-autoloads-here to update the autoloads for each file that
;;; already has an autoload section in this file.
;;; **********************************************************************

;;; Code:

;;; This code was NOT generated by autoload.el.

(defconst mode-line-buffer-identification (purecopy '("Emacs: %12b"))
  "Mode-line control for identifying the buffer being displayed.
Its default value is \"Emacs: %12b\".  Major modes that edit things
other than ordinary files may change this (e.g. Info, Dired,...)")

(make-variable-buffer-local 'mode-line-buffer-identification)

(defconst mode-line-process nil
  "Mode-line control for displaying info on process status.
Normally nil in most modes, since there is no process to display.")

(make-variable-buffer-local 'mode-line-process)

(defconst mode-line-modified (purecopy '("--%1*%1*-"))
  "Mode-line control for displaying whether current buffer is modified.")

(make-variable-buffer-local 'mode-line-modified)

(setq-default mode-line-format
  (list (purecopy "")
   'mode-line-modified
   'mode-line-buffer-identification
   (purecopy "   ")
   'global-mode-string
   (purecopy "   %[(")
   'mode-name 'minor-mode-alist "%n" 'mode-line-process
   (purecopy ")%]--")
   (purecopy '(line-number-mode "L%l--"))
   (purecopy '(-3 . "%p"))
   (purecopy "-%-")))

(defvar minor-mode-alist nil "\
Alist saying how to show minor modes in the mode line.
Each element looks like (VARIABLE STRING);
STRING is included in the mode line iff VARIABLE's value is non-nil.

Actually, STRING need not be a string; any possible mode-line element
is okay.  See `mode-line-format'.")
(setq minor-mode-alist (mapcar 'purecopy
			       '((abbrev-mode " Abbrev")
				 (overwrite-mode overwrite-mode)
				 (auto-fill-function " Fill")
				 ;; not really a minor mode...
				 (defining-kbd-macro " Def"))))

;; These variables are used by autoloadable packages.
;; They are defined here so that they do not get overridden
;; by the loading of those packages.

;; Names in directory that end in one of these
;; are ignored in completion,
;; making it more likely you will get a unique match.
(setq completion-ignored-extensions
      (if (eq system-type 'vax-vms)
	  '(".obj" ".elc" ".exe" ".bin" ".lbin" ".sbin"
	    ".dvi" ".toc" ".log" ".aux"
	    ".lof" ".brn" ".rnt" ".mem" ".lni" ".lis"
	    ".olb" ".tlb" ".mlb" ".hlb" ".glo" ".idx" ".lot" ".fmt")
	'(".o" ".elc" "~" ".bin" ".lbin" ".fasl"
	  ".dvi" ".toc" ".log" ".aux" ".a" ".ln"
	  ".lof" ".blg" ".bbl" ".glo" ".idx" ".lot" ".fmt")))

(make-variable-buffer-local 'indent-tabs-mode)

;; This is here to avoid autoloading etags on M-TAB.
;; M-x visit-tags-table will autoload etags, which will redefine complete-tag.
(defun complete-tag ()
  "Perform tags completion on the text around point.
Completes to the set of names listed in the current tags table.  
The string to complete is chosen in the same way as the default
for \\[find-tag] (which see)."
  (interactive)
  (error (substitute-command-keys
	  "No tags table loaded.  Try \\[visit-tags-table].")))

;; Reduce total amount of space we must allocate during this function
;; that we will not need to keep permanently.
(garbage-collect)

(define-key ctl-x-map "n" (make-sparse-keymap))
(define-key ctl-x-map "r" (make-sparse-keymap))

;These commands are defined in editfns.c
;but they are not assigned to keys there.
(put 'narrow-to-region 'disabled t)
(define-key ctl-x-map "nn" 'narrow-to-region)
(define-key ctl-x-map "nw" 'widen)
;; (define-key ctl-x-map "n" 'narrow-to-region)
;; (define-key ctl-x-map "w" 'widen)

(define-key global-map "\C-j" 'newline-and-indent)
(define-key global-map "\C-m" 'newline)
(define-key global-map "\C-o" 'open-line)
(define-key esc-map "\C-o" 'split-line)
(define-key global-map "\C-q" 'quoted-insert)
(define-key esc-map "^" 'delete-indentation)
(define-key esc-map "\\" 'delete-horizontal-space)
(define-key esc-map "m" 'back-to-indentation)
(define-key ctl-x-map "\C-o" 'delete-blank-lines)
(define-key esc-map " " 'just-one-space)
(define-key esc-map "z" 'zap-to-char)
(define-key esc-map "=" 'count-lines-region)
(define-key ctl-x-map "=" 'what-cursor-position)
;; This key sequence might cause a certain amount of trouble with function
;; keys.  Namely, it means you can't bind ESC followed by a function key.
;; However, people might not mind that too terribly much.
;; So I will leave this alone for now.
(define-key esc-map "\e" 'eval-expression)
;; Changed from C-x ESC so that function keys work following C-x.
(define-key ctl-x-map "\e\e" 'repeat-complex-command)
(define-key ctl-x-map "u" 'advertised-undo)
;; Many people are used to typing C-/ on X terminals and getting C-_.
(define-key global-map [?\C-/] 'undo)
(define-key global-map "\C-_" 'undo)
(define-key esc-map "!" 'shell-command)
(define-key esc-map "|" 'shell-command-on-region)

(define-key global-map "\C-u" 'universal-argument)
(let ((i ?0))
  (while (<= i ?9)
    (define-key esc-map (char-to-string i) 'digit-argument)
    (setq i (1+ i))))
(define-key esc-map "-" 'negative-argument)
;; Define control-digits.
(let ((i ?0))
  (while (<= i ?9)
    (define-key global-map (read (format "[?\\C-%c]" i)) 'digit-argument)
    (setq i (1+ i))))
(define-key global-map [?\C--] 'negative-argument)
;; Define control-meta-digits.
(let ((i ?0))
  (while (<= i ?9)
    (define-key esc-map (read (format "[?\\C-%c]" i)) 'digit-argument)
    (setq i (1+ i))))
(define-key global-map [?\C-\M--] 'negative-argument)

(define-key global-map "\C-k" 'kill-line)
(define-key global-map "\C-w" 'kill-region)
(define-key esc-map "w" 'kill-ring-save)
(define-key esc-map "\C-w" 'append-next-kill)
(define-key global-map "\C-y" 'yank)
(define-key esc-map "y" 'yank-pop)

;; (define-key ctl-x-map "a" 'append-to-buffer)

(define-key global-map "\C-@" 'set-mark-command)
;; Many people are used to typing C-SPC and getting C-@.
(define-key global-map [?\C-\ ] 'set-mark-command)
(define-key ctl-x-map "\C-x" 'exchange-point-and-mark)

(define-key global-map "\C-n" 'next-line)
(define-key global-map "\C-p" 'previous-line)
(define-key ctl-x-map "\C-n" 'set-goal-column)

;;(defun function-key-error ()
;;  (interactive)
;;  (error "That function key is not bound to anything."))

;; Apparently some terminals have a labeled help key.
(define-key function-key-map [help] "\C-h")
(define-key global-map [menu] 'execute-extended-command)
(define-key global-map [find] 'search-forward)

;; natural bindings for terminal keycaps --- defined in X keysym order
(define-key global-map [home]		'beginning-of-buffer)
(define-key global-map [left]		'backward-char)
(define-key global-map [up]		'previous-line)
(define-key global-map [right]		'forward-char)
(define-key global-map [down]		'next-line)
(define-key global-map [prior]		'scroll-down)
(define-key global-map [next]		'scroll-up)
(define-key global-map [M-next]		'scroll-other-window)
(define-key global-map [end]		'end-of-buffer)
(define-key global-map [begin]		'beginning-of-buffer)
;; (define-key global-map [select]		'function-key-error)
;; (define-key global-map [print]		'function-key-error)
(define-key global-map [execute]	'execute-extended-command)
(define-key global-map [insert]		'overwrite-mode)
(define-key global-map [undo]		'undo)
(define-key global-map [redo]		'repeat-complex-command)
;; (define-key global-map [clearline]	'function-key-error)
(define-key global-map [insertline]	'open-line)
(define-key global-map [deleteline]	'kill-line)
;; (define-key global-map [insertchar]	'function-key-error)
(define-key global-map [deletechar]	'delete-char)
;; (define-key global-map [backtab]	'function-key-error)
;; (define-key global-map [f1]		'function-key-error)
;; (define-key global-map [f2]		'function-key-error)
;; (define-key global-map [f3]		'function-key-error)
;; (define-key global-map [f4]		'function-key-error)
;; (define-key global-map [f5]		'function-key-error)
;; (define-key global-map [f6]		'function-key-error)
;; (define-key global-map [f7]		'function-key-error)
;; (define-key global-map [f8]		'function-key-error)
;; (define-key global-map [f9]		'function-key-error)
;; (define-key global-map [f10]		'function-key-error)
;; (define-key global-map [f11]		'function-key-error)
;; (define-key global-map [f12]		'function-key-error)
;; (define-key global-map [f13]		'function-key-error)
;; (define-key global-map [f14]		'function-key-error)
;; (define-key global-map [f15]		'function-key-error)
;; (define-key global-map [f16]		'function-key-error)
;; (define-key global-map [f17]		'function-key-error)
;; (define-key global-map [f18]		'function-key-error)
;; (define-key global-map [f19]		'function-key-error)
;; (define-key global-map [f20]		'function-key-error)
;; (define-key global-map [f21]		'function-key-error)
;; (define-key global-map [f22]		'function-key-error)
;; (define-key global-map [f23]		'function-key-error)
;; (define-key global-map [f24]		'function-key-error)
;; (define-key global-map [f25]		'function-key-error)
;; (define-key global-map [f26]		'function-key-error)
;; (define-key global-map [f27]		'function-key-error)
;; (define-key global-map [f28]		'function-key-error)
;; (define-key global-map [f29]		'function-key-error)
;; (define-key global-map [f30]		'function-key-error)
;; (define-key global-map [f31]		'function-key-error)
;; (define-key global-map [f32]		'function-key-error)
;; (define-key global-map [f33]		'function-key-error)
;; (define-key global-map [f34]		'function-key-error)
;; (define-key global-map [f35]		'function-key-error)
;; (define-key global-map [kp-backtab]	'function-key-error)
;; (define-key global-map [kp-space]	'function-key-error)
;; (define-key global-map [kp-tab]		'function-key-error)
;; (define-key global-map [kp-enter]	'function-key-error)
;; (define-key global-map [kp-f1]		'function-key-error)
;; (define-key global-map [kp-f2]		'function-key-error)
;; (define-key global-map [kp-f3]		'function-key-error)
;; (define-key global-map [kp-f4]		'function-key-error)
;; (define-key global-map [kp-multiply]	'function-key-error)
;; (define-key global-map [kp-add]		'function-key-error)
;; (define-key global-map [kp-separator]	'function-key-error)
;; (define-key global-map [kp-subtract]	'function-key-error)
;; (define-key global-map [kp-decimal]	'function-key-error)
;; (define-key global-map [kp-divide]	'function-key-error)
;; (define-key global-map [kp-0]		'function-key-error)
;; (define-key global-map [kp-1]		'function-key-error)
;; (define-key global-map [kp-2]		'function-key-error)
;; (define-key global-map [kp-3]		'function-key-error)
;; (define-key global-map [kp-4]		'function-key-error)
;; (define-key global-map [kp-5]		'recenter)
;; (define-key global-map [kp-6]		'function-key-error)
;; (define-key global-map [kp-7]		'function-key-error)
;; (define-key global-map [kp-8]		'function-key-error)
;; (define-key global-map [kp-9]		'function-key-error)
;; (define-key global-map [kp-equal]	'function-key-error)

(define-key global-map "\C-t" 'transpose-chars)
(define-key esc-map "t" 'transpose-words)
(define-key esc-map "\C-t" 'transpose-sexps)
(define-key ctl-x-map "\C-t" 'transpose-lines)

(define-key esc-map ";" 'indent-for-comment)
(define-key esc-map "j" 'indent-new-comment-line)
(define-key esc-map "\C-j" 'indent-new-comment-line)
(define-key ctl-x-map ";" 'set-comment-column)
(define-key ctl-x-map "f" 'set-fill-column)
(define-key ctl-x-map "$" 'set-selective-display)

(define-key esc-map "@" 'mark-word)
(define-key esc-map "f" 'forward-word)
(define-key esc-map "b" 'backward-word)
(define-key esc-map "d" 'kill-word)
(define-key esc-map "\177" 'backward-kill-word)

(define-key esc-map "<" 'beginning-of-buffer)
(define-key esc-map ">" 'end-of-buffer)
(define-key ctl-x-map "h" 'mark-whole-buffer)
(define-key esc-map "\\" 'delete-horizontal-space)

(defalias 'mode-specific-command-prefix (make-sparse-keymap))
(defconst mode-specific-map (symbol-function 'mode-specific-command-prefix)
  "Keymap for characters following C-c.")
(define-key global-map "\C-c" 'mode-specific-command-prefix)

(global-set-key [M-right]  'forward-word)
(global-set-key [M-left]   'backward-word)

(define-key esc-map "\C-f" 'forward-sexp)
(define-key esc-map "\C-b" 'backward-sexp)
(define-key esc-map "\C-u" 'backward-up-list)
(define-key esc-map "\C-@" 'mark-sexp)
(define-key esc-map [?\C-\ ] 'mark-sexp)
(define-key esc-map "\C-d" 'down-list)
(define-key esc-map "\C-k" 'kill-sexp)
(define-key esc-map "\C-n" 'forward-list)
(define-key esc-map "\C-p" 'backward-list)
(define-key esc-map "\C-a" 'beginning-of-defun)
(define-key esc-map "\C-e" 'end-of-defun)
(define-key esc-map "\C-h" 'mark-defun)
(define-key esc-map "(" 'insert-parentheses)
(define-key esc-map ")" 'move-past-close-and-reindent)
(define-key esc-map "\t" 'lisp-complete-symbol)

(define-key ctl-x-map "\C-e" 'eval-last-sexp)

(define-key ctl-x-map "r\C-@" 'point-to-register)
(define-key ctl-x-map [?r ?\C-\ ] 'point-to-register)
(define-key ctl-x-map "r " 'point-to-register)
(define-key ctl-x-map "rj" 'jump-to-register)
(define-key ctl-x-map "rs" 'copy-to-register)
(define-key ctl-x-map "rx" 'copy-to-register)
(define-key ctl-x-map "ri" 'insert-register)
(define-key ctl-x-map "rg" 'insert-register)
(define-key ctl-x-map "rr" 'copy-rectangle-to-register)
(define-key ctl-x-map "rc" 'clear-rectangle)
(define-key ctl-x-map "rk" 'kill-rectangle)
(define-key ctl-x-map "ry" 'yank-rectangle)
(define-key ctl-x-map "ro" 'open-rectangle)
(define-key ctl-x-map "rt" 'string-rectangle)
(define-key ctl-x-map "rw" 'window-configuration-to-register)
(define-key ctl-x-map "rf" 'frame-configuration-to-register)

(define-key ctl-x-map "/" 'point-to-register)
(define-key ctl-x-map "j" 'jump-to-register)
(define-key ctl-x-map "x" 'copy-to-register)
(define-key ctl-x-map "g" 'insert-register)
;; (define-key ctl-x-map "r" 'copy-rectangle-to-register)

(define-key esc-map "q" 'fill-paragraph)
;; (define-key esc-map "g" 'fill-region)
(define-key ctl-x-map "." 'set-fill-prefix)

(define-key esc-map "{" 'backward-paragraph)
(define-key esc-map "}" 'forward-paragraph)
(define-key esc-map "h" 'mark-paragraph)
(define-key esc-map "a" 'backward-sentence)
(define-key esc-map "e" 'forward-sentence)
(define-key esc-map "k" 'kill-sentence)
(define-key ctl-x-map "\177" 'backward-kill-sentence)

(define-key ctl-x-map "[" 'backward-page)
(define-key ctl-x-map "]" 'forward-page)
(define-key ctl-x-map "\C-p" 'mark-page)
(define-key ctl-x-map "l" 'count-lines-page)
(define-key ctl-x-map "np" 'narrow-to-page)
;; (define-key ctl-x-map "p" 'narrow-to-page)

(define-key ctl-x-map "al" 'add-mode-abbrev)
(define-key ctl-x-map "a\C-a" 'add-mode-abbrev)
(define-key ctl-x-map "ag" 'add-global-abbrev)
(define-key ctl-x-map "a+" 'add-mode-abbrev)
(define-key ctl-x-map "aig" 'inverse-add-global-abbrev)
(define-key ctl-x-map "ail" 'inverse-add-mode-abbrev)
;; (define-key ctl-x-map "a\C-h" 'inverse-add-global-abbrev)
(define-key ctl-x-map "a-" 'inverse-add-global-abbrev)
(define-key ctl-x-map "ae" 'expand-abbrev)
(define-key ctl-x-map "a'" 'expand-abbrev)
;; (define-key ctl-x-map "\C-a" 'add-mode-abbrev)
;; (define-key ctl-x-map "\+" 'add-global-abbrev)
;; (define-key ctl-x-map "\C-h" 'inverse-add-mode-abbrev)
;; (define-key ctl-x-map "\-" 'inverse-add-global-abbrev)
(define-key esc-map "'" 'abbrev-prefix-mark)
(define-key ctl-x-map "'" 'expand-abbrev)


;;; Generated autoloads follow (made by autoload.el).

;;; To sort them, execute the following after narrowing
;;; to a region starting just after the following formfeed (control-l)
;;; and ending just after the last formfeed in the file.

;;;(sort-regexp-fields nil "\n*.*\n.*from \\(.*\\)[^]*" "\\1"
;;;		    (point-min) (point-max))

;;;### (autoloads (change-log-mode add-change-log-entry-other-window add-change-log-entry find-change-log prompt-for-change-log-name) "add-log" "add-log.el" (11496 28641))
;;; Generated autoloads from add-log.el

(autoload (quote prompt-for-change-log-name) "add-log" "\
Prompt for a change log name." nil nil)

(autoload (quote find-change-log) "add-log" "\
Find a change log file for \\[add-change-log-entry] and return the name.
Optional arg FILE-NAME is a name to try first.
If FILE-NAME is nil, use the value of `change-log-default-name' if non-nil.
Failing that, use \"ChangeLog\" in the current directory.
If the file does not exist in the named directory, successive parent
directories are tried.

Once a file is found, `change-log-default-name' is set locally in the
current buffer to the complete file name." nil nil)

(autoload (quote add-change-log-entry) "add-log" "\
Find change log file and add an entry for today.
Optional arg (interactive prefix) non-nil means prompt for user name and site.
Second arg is file name of change log.  If nil, uses `change-log-default-name'.
Third arg OTHER-WINDOW non-nil means visit in other window.
Fourth arg NEW-ENTRY non-nil means always create a new entry at the front;
never append to an existing entry." t nil)

(autoload (quote add-change-log-entry-other-window) "add-log" "\
Find change log file in other window and add an entry for today.
Optional arg (interactive prefix) non-nil means prompt for user name and site.
Second arg is file name of change log.  If nil, uses `change-log-default-name'." t nil)
(define-key ctl-x-4-map "a" 'add-change-log-entry-other-window)

(autoload (quote change-log-mode) "add-log" "\
Major mode for editing change logs; like Indented Text Mode.
Prevents numeric backups and sets `left-margin' to 8 and `fill-column' to 74.
New log entries are usually made with \\[add-change-log-entry] or \\[add-change-log-entry-other-window].
Each entry behaves as a paragraph, and the entries for one day as a page.
Runs `change-log-mode-hook'." t nil)

;;;***

;;;### (autoloads (ad-start-advice defadvice ad-add-advice) "advice" "advice.el" (11335 1783))
;;; Generated autoloads from advice.el

(defvar ad-start-advice-on-load t "\
*Non-NIL will start advice magic when this file gets loaded.
Also see function `ad-start-advice'.")

(defvar ad-activate-on-definition nil "\
*Non-NIL means automatic advice activation at function definition.
Set this variable to t if you want to enable forward advice (which is
automatic advice activation of a previously undefined function at the
point the function gets defined/loaded/autoloaded). The value of this
variable takes effect only during the execution of `ad-start-advice'. 
If non-NIL it will enable definition hooks regardless of the value
of `ad-enable-definition-hooks'.")

(defvar ad-redefinition-action (quote warn) "\
*Defines what to do with redefinitions during de/activation.
Redefinition occurs if a previously activated function that already has an
original definition associated with it gets redefined and then de/activated.
In such a case we can either accept the current definition as the new
original definition, discard the current definition and replace it with the
old original, or keep it and raise an error. The values `accept', `discard',
`error' or `warn' govern what will be done. `warn' is just like `accept' but
it additionally prints a warning message. All other values will be
interpreted as `error'.")

(defvar ad-definition-hooks nil "\
*List of hooks to be run after a function definition.
The variable `ad-defined-function' will be bound to the name of
the currently defined function when the hook function is run.")

(defvar ad-enable-definition-hooks nil "\
*Non-NIL will enable hooks to be run on function definition.
Setting this variable is a noop unless the value of
`ad-activate-on-definition' (which see) is NIL.")

(defvar ad-use-jwz-byte-compiler (fboundp (quote eval-when-compile)) "\
*Non-NIL means Jamie Zawinski's v19 byte-compiler will be used.
If you use a v18 Emacs and don't use jwz's optimizing byte-compiler (the
normal case) then this variable should be NIL, because otherwise
enabling definition hooks (e.g., for forward advice) will redefine the 
`byte-code' subr which will lead to some performance degradation for
byte-compiled code.")

(autoload (quote ad-add-advice) "advice" "\
Adds a piece of ADVICE to FUNCTION's list of advices in CLASS.
If FUNCTION already has one or more pieces of advice of the specified
CLASS then POSITION determines where the new piece will go. The value
of POSITION can either be `first', `last' or a number where 0 corresponds
to `first'. Numbers outside the range will be mapped to the closest
extreme position. If there was already a piece of ADVICE with the same
name, then the position argument will be ignored and the old advice
will be overwritten with the new one.
    If the FUNCTION was not advised already, then its advice info will be 
initialized. Redefining a piece of advice whose name is part of the cache-id
will clear the cache." nil nil)

(autoload (quote defadvice) "advice" "\
Defines a piece of advice for FUNCTION (a symbol).

  (defadvice <function> (<class> <name> [<position>] [<arglist>] {<flags>}*)
    [ [<documentation-string>] [<interactive-form>] ]
    {<body-form>}* )

<function> ::= name of the function to be advised
<class> ::= before | around | after | activation | deactivation
<name> ::= non-NIL symbol that names this piece of advice
<position> ::= first | last | <number> (optional, defaults to `first',
    see also `ad-add-advice')
<arglist> ::= an optional argument list to be used for the advised function
    instead of the argument list of the original. The first one found in
    before/around/after advices will be used.
<flags> ::= protect | disable | activate | compile | preactivate
    All flags can be specified with unambiguous initial substrings.
<documentation-string> ::= optional documentation for this piece of advice
<interactive-form> ::= optional interactive form to be used for the advised
    function. The first one found in before/around/after advices will be used.
<body-form> ::= any s-expression

Semantics of the various flags:
`protect': The piece of advice will be protected against non-local exits in
any code that precedes it. If any around advice of a function is protected
then automatically all around advices will be protected (the complete onion).

`activate': All advice of FUNCTION will be activated immediately if
FUNCTION has been properly defined prior to the defadvice.

`compile': In conjunction with `activate' specifies that the resulting
advised function should be compiled.

`disable': The defined advice will be disabled, hence it will not be used 
during activation until somebody enables it.

`preactivate': Preactivates the advised FUNCTION at macro expansion/compile
time. This generates a compiled advised definition according to the current
advice state that will be used during activation if appropriate. Only use
this if the defadvice gets actually compiled (with a v18 byte-compiler put
the defadvice into the body of a defun).

Look at the file advice.el for comprehensive documentation." nil (quote macro))

(autoload (quote ad-start-advice) "advice" "\
Redefines some primitives to start the advice magic.
If `ad-activate-on-definition' is t then advice information will
automatically get activated whenever an advised function gets defined or
redefined.  This will enable goodies such as forward advice and
automatically enable function definition hooks. If its value is nil but
the value of `ad-enable-definition-hooks' is t then definition hooks
will be enabled without having automatic advice activation, otherwise
function definition hooks will be disabled too. If definition hooks are
enabled then functions stored in `ad-definition-hooks' are run whenever
a function gets defined or redefined." t nil)

;;;***

;;;### (autoloads (ange-ftp-hook-function) "ange-ftp" "ange-ftp.el" (11365 55979))
;;; Generated autoloads from ange-ftp.el

(autoload (quote ange-ftp-hook-function) "ange-ftp" nil nil nil)

;; (or (assoc "^/[^/:]*[^/:]:" file-name-handler-alist) (setq file-name-handler-alist (cons (quote ("^/[^/:]*[^/:]:" . ange-ftp-hook-function)) file-name-handler-alist)))

;; (or (assoc "^/[^/:]*\\'" file-name-handler-alist) (setq file-name-handler-alist (cons (quote ("^/[^/:]*\\'" . ange-ftp-completion-hook-function)) file-name-handler-alist)))

;;;***

;;;### (autoloads (appt-make-list) "appt" "appt.el" (10941 42374))
;;; Generated autoloads from appt.el

(defvar appt-issue-message t "\
*Non-nil means check for appointments in the diary buffer.
To be detected, the diary entry must have the time
as the first thing on a line.")

(defvar appt-message-warning-time 10 "\
*Time in minutes before an appointment that the warning begins.")

(defvar appt-audible t "\
*Non-nil means beep to indicate appointment.")

(defvar appt-visible t "\
*Non-nil means display appointment message in echo area.")

(defvar appt-display-mode-line t "\
*Non-nil means display minutes to appointment and time on the mode line.")

(defvar appt-msg-window t "\
*Non-nil means display appointment message in another window.")

(defvar appt-display-duration 5 "\
*The number of seconds an appointment message is displayed.")

(defvar appt-display-diary t "\
*Non-nil means to display the next days diary on the screen. 
This will occur at midnight when the appointment list is updated.")

(autoload (quote appt-make-list) "appt" nil nil nil)

;;;***

;;;### (autoloads (super-apropos apropos) "apropos" "apropos.el" (11283 60450))
;;; Generated autoloads from apropos.el

(autoload (quote apropos) "apropos" "\
Show all symbols whose names contain matches for REGEXP.
If optional argument DO-ALL is non-nil, does more (time-consuming) work such as
showing key bindings.  Optional argument PRED is called with each symbol, and
if it returns nil, the symbol is not shown.

Returns list of symbols and documentation found." t nil)

(autoload (quote super-apropos) "apropos" "\
Show symbols whose names/documentation contain matches for REGEXP.
If optional argument DO-ALL is non-nil, does more (time-consuming) work such as
showing key bindings and documentation that is not stored in the documentation
file.

Returns list of symbols and documentation found." t nil)

;;;***

;;;### (autoloads (asm-mode) "asm-mode" "asm-mode.el" (11240 17420))
;;; Generated autoloads from asm-mode.el

(autoload (quote asm-mode) "asm-mode" "\
Major mode for editing typical assembler code.
Features a private abbrev table and the following bindings:

\\[asm-colon]	outdent a preceding label, tab to next tab stop.
\\[tab-to-tab-stop]	tab to next tab stop.
\\[asm-newline]	newline, then tab to next tab stop.
\\[asm-comment]	smart placement of assembler comments.

The character used for making comments is set by the variable
`asm-comment-char' (which defaults to `?;').

Alternatively, you may set this variable in `asm-set-comment-hook', which is
called near the beginning of mode initialization.

Turning on Asm mode runs the hook `asm-mode-hook' at the end of initialization.

Special commands:\\{asm-mode-map}
" t nil)

;;;***

;;;### (autoloads (batch-update-autoloads update-directory-autoloads update-autoloads-here update-file-autoloads) "autoload" "autoload.el" (11341 50340))
;;; Generated autoloads from autoload.el

(autoload (quote update-file-autoloads) "autoload" "\
Update the autoloads for FILE in `generated-autoload-file'
(which FILE might bind in its local variables)." t nil)

(autoload (quote update-autoloads-here) "autoload" "\
Update sections of the current buffer generated by \\[update-file-autoloads]." t nil)

(autoload (quote update-directory-autoloads) "autoload" "\
Run \\[update-file-autoloads] on each .el file in DIR." t nil)

(autoload (quote batch-update-autoloads) "autoload" "\
Update the autoloads for the files or directories on the command line.
Runs \\[update-file-autoloads] on files and \\[update-directory-autoloads]
on directories.  Must be used only with -batch, and kills Emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-update-autoloads *.el\"" nil nil)

;;;***

;;;### (autoloads (awk-mode) "awk-mode" "awk-mode.el" (11181 53242))
;;; Generated autoloads from awk-mode.el

(autoload (quote awk-mode) "awk-mode" "\
Major mode for editing AWK code.
This is much like C mode except for the syntax of comments.  It uses
the same keymap as C mode and has the same variables for customizing
indentation.  It has its own abbrev table and its own syntax table.

Turning on AWK mode calls the value of the variable `awk-mode-hook'
with no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (\`) "backquote" "backquote.el" (11285 49676))
;;; Generated autoloads from backquote.el

(autoload (quote \`) "backquote" "\
(` FORM)  is a macro that expands to code to construct FORM.
Note that this is very slow in interpreted code, but fast if you compile.
FORM is one or more nested lists, which are `almost quoted':
They are copied recursively, with non-lists used unchanged in the copy.
 (` a b) == (list 'a 'b)  constructs a new list with two elements, `a' and `b'.
 (` a (b c)) == (list 'a (list 'b 'c))  constructs two nested new lists.

However, certain special lists are not copied.  They specify substitution.
Lists that look like (, EXP) are evaluated and the result is substituted.
 (` a (, (+ x 5))) == (list 'a (+ x 5))

Elements of the form (,@ EXP) are evaluated and then all the elements
of the result are substituted.  This result must be a list; it may
be `nil'.

As an example, a simple macro `push' could be written:
   (defmacro push (v l)
        (` (setq (, l) (cons (,@ (list v l))))))
or as
   (defmacro push (v l)
        (` (setq (, l) (cons (, v) (, l)))))

LIMITATIONS: \"dotted lists\" are not allowed in FORM.
The ultimate cdr of each list scanned by ` must be `nil'.
(This does not apply to constants inside expressions to be substituted.)

Substitution elements are not allowed as the cdr
of a cons cell.  For example, (` (A . (, B))) does not work.
Instead, write (` (A (,@ B))).

You cannot construct vectors, only lists.  Vectors are treated as
constants.

BEWARE BEWARE BEWARE
Inclusion of (,ATOM) rather than (, ATOM)
or of (,@ATOM) rather than (,@ ATOM)
will result in errors that will show up very late." nil (quote macro))

;;;***

;;;### (autoloads (bibtex-mode) "bibtex" "bibtex.el" (11287 29229))
;;; Generated autoloads from bibtex.el

(autoload (quote bibtex-mode) "bibtex" "\
Major mode for editing bibtex files.

\\{bibtex-mode-map}

A command such as \\[bibtex-Book] will outline the fields for a BibTeX book entry.

The optional fields start with the string OPT, and thus ignored by BibTeX.
The OPT string may be removed from a field with \\[bibtex-remove-OPT].
\\[bibtex-kill-optional-field] kills the current optional field entirely.
\\[bibtex-remove-double-quotes] removes the double-quotes around the text of
the current field.  \\[bibtex-empty-field] replaces the text of the current
field with the default \"\".

The command \\[bibtex-clean-entry] cleans the current entry, i.e. (i) removes
double-quotes from entirely numerical fields, (ii) removes OPT from all
non-empty optional fields, (iii) removes all empty optional fields, and (iv)
checks that no non-optional fields are empty.

Use \\[bibtex-find-text] to position the dot at the end of the current field.
Use \\[bibtex-next-field] to move to end of the next field.

The following may be of interest as well:

  Functions:
    find-bibtex-duplicates
    find-bibtex-entry-location
    hide-bibtex-entry-bodies
    sort-bibtex-entries
    validate-bibtex-buffer

  Variables:
    bibtex-clean-entry-zap-empty-opts
    bibtex-entry-field-alist
    bibtex-include-OPTannote
    bibtex-include-OPTcrossref
    bibtex-include-OPTkey
    bibtex-maintain-sorted-entries
    bibtex-mode-user-optional-fields

Fields:
    address
           Publisher's address
    annote
           Long annotation used for annotated bibliographies (begins sentence)
    author
           Name(s) of author(s), in BibTeX name format
    booktitle
           Book title when the thing being referenced isn't the whole book.
           For book entries, the title field should be used instead.
    chapter
           Chapter number
    crossref
	   The database key of the entry being cross referenced.
    edition
           Edition of a book (e.g., \"second\")
    editor
           Name(s) of editor(s), in BibTeX name format.
           If there is also an author field, then the editor field should be
           for the book or collection that the work appears in
    howpublished
            How something strange has been published (begins sentence)
    institution
           Sponsoring institution
    journal
           Journal name (macros are provided for many)
    key
           Alphabetizing and labeling key (needed when no author or editor)
    month
           Month (macros are provided)
    note
           To help the reader find a reference (begins sentence)
    number
           Number of a journal or technical report
    organization
           Organization (sponsoring a conference)
    pages
           Page number or numbers (use `--' to separate a range)
    publisher
           Publisher name
    school
           School name (for theses)
    series
           The name of a series or set of books.
           An individual book will will also have it's own title
    title
           The title of the thing being referenced
    type
           Type of a technical report (e.g., \"Research Note\") to be used
           instead of the default \"Technical Report\"
    volume
           Volume of a journal or multivolume work
    year
           Year---should contain only numerals
---------------------------------------------------------
Entry to this mode calls the value of bibtex-mode-hook if that value is
non-nil." t nil)

;;;***

;;;### (autoloads (blackbox) "blackbox" "blackbox.el" (11356 18211))
;;; Generated autoloads from blackbox.el

(autoload (quote blackbox) "blackbox" "\
Play blackbox.  Optional prefix argument is the number of balls;
the default is 4.

What is blackbox?

Blackbox is a game of hide and seek played on an 8 by 8 grid (the
Blackbox).  Your opponent (Emacs, in this case) has hidden several
balls (usually 4) within this box.  By shooting rays into the box and
observing where they emerge it is possible to deduce the positions of
the hidden balls.  The fewer rays you use to find the balls, the lower
your score.

Overview of play:

\\<blackbox-mode-map>To play blackbox, type \\[blackbox].  An optional prefix argument
specifies the number of balls to be hidden in the box; the default is
four.

The cursor can be moved around the box with the standard cursor
movement keys.

To shoot a ray, move the cursor to the edge of the box and press SPC.
The result will be determined and the playfield updated.

You may place or remove balls in the box by moving the cursor into the
box and pressing \\[bb-romp].

When you think the configuration of balls you have placed is correct,
press \\[bb-done].  You will be informed whether you are correct or
not, and be given your score.  Your score is the number of letters and
numbers around the outside of the box plus five for each incorrectly
placed ball.  If you placed any balls incorrectly, they will be
indicated with `x', and their actual positions indicated with `o'.

Details:

There are three possible outcomes for each ray you send into the box:

	Detour: the ray is deflected and emerges somewhere other than
		where you sent it in.  On the playfield, detours are
		denoted by matching pairs of numbers -- one where the
		ray went in, and the other where it came out.

	Reflection: the ray is reflected and emerges in the same place
		it was sent in.  On the playfield, reflections are
		denoted by the letter `R'.

	Hit:	the ray strikes a ball directly and is absorbed.  It does
		not emerge from the box.  On the playfield, hits are
		denoted by the letter `H'.

The rules for how balls deflect rays are simple and are best shown by
example.

As a ray approaches a ball it is deflected ninety degrees.  Rays can
be deflected multiple times.  In the diagrams below, the dashes
represent empty box locations and the letter `O' represents a ball.
The entrance and exit points of each ray are marked with numbers as
described under \"Detour\" above.  Note that the entrance and exit
points are always interchangeable.  `*' denotes the path taken by the
ray.

Note carefully the relative positions of the ball and the ninety
degree deflection it causes.

    1                                            
  - * - - - - - -         - - - - - - - -         - - - - - - - -       
  - * - - - - - -         - - - - - - - -         - - - - - - - -       
1 * * - - - - - -         - - - - - - - -         - O - - - - O -       
  - - O - - - - -         - - O - - - - -         - - * * * * - -
  - - - - - - - -         - - - * * * * * 2     3 * * * - - * - -
  - - - - - - - -         - - - * - - - -         - - - O - * - -      
  - - - - - - - -         - - - * - - - -         - - - - * * - -       
  - - - - - - - -         - - - * - - - -         - - - - * - O -       
                                2                         3

As mentioned above, a reflection occurs when a ray emerges from the same point
it was sent in.  This can happen in several ways:

                                                                           
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - O - - -         - - O - O - - -          - - - - - - - -
R * * * * - - - -         - - - * - - - -          O - - - - - - -
  - - - - O - - -         - - - * - - - -        R - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -       R * * * * - - - -          - - - - - - - -
  - - - - - - - -         - - - - O - - -          - - - - - - - -

In the first example, the ray is deflected downwards by the upper
ball, then left by the lower ball, and finally retraces its path to
its point of origin.  The second example is similar.  The third
example is a bit anomalous but can be rationalized by realizing the
ray never gets a chance to get into the box.  Alternatively, the ray
can be thought of as being deflected downwards and immediately
emerging from the box.

A hit occurs when a ray runs straight into a ball:

  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - O - - -
  - - - - - - - -         - - - - O - - -        H * * * * - - - -
  - - - - - - - -       H * * * * O - - -          - - - * - - - -
  - - - - - - - -         - - - - O - - -          - - - O - - - -
H * * * O - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -

Be sure to compare the second example of a hit with the first example of
a reflection." t nil)

;;;***


;;;### (autoloads (list-bookmarks bookmark-load bookmark-save bookmark-write bookmark-delete bookmark-insert bookmark-rename bookmark-locate bookmark-relocate bookmark-jump bookmark-set) "bookmark" "bookmark.el" (11468 39303))
;;; Generated autoloads from bookmark.el

(if (symbolp (key-binding "r")) nil (progn (define-key ctl-x-map "rb" (quote bookmark-jump)) (define-key ctl-x-map "rm" (quote bookmark-set)) (define-key ctl-x-map "rl" (quote list-bookmarks))))

(defvar bookmark-map nil "\
Keymap containing bindings to bookmark functions.
It is not bound to any key by default: to bind it
so that you have a bookmark prefix, just use `global-set-key' and bind a
key of your choice to `bookmark-map'.  All interactive bookmark
functions have a binding in this keymap.")

(define-prefix-command (quote bookmark-map))

(define-key bookmark-map "x" (quote bookmark-set))

(define-key bookmark-map "m" (quote bookmark-set))

(define-key bookmark-map "j" (quote bookmark-jump))

(define-key bookmark-map "g" (quote bookmark-jump))

(define-key bookmark-map "i" (quote bookmark-insert))

(define-key bookmark-map "e" (quote edit-bookmarks))

(define-key bookmark-map "f" (quote bookmark-locate))

(define-key bookmark-map "r" (quote bookmark-rename))

(define-key bookmark-map "d" (quote bookmark-delete))

(define-key bookmark-map "l" (quote bookmark-load))

(define-key bookmark-map "w" (quote bookmark-write))

(define-key bookmark-map "s" (quote bookmark-save))

(add-hook (quote kill-emacs-hook) (function (lambda nil (and (featurep (quote bookmark)) bookmark-alist (bookmark-time-to-save-p t) (bookmark-save)))))

(autoload (quote bookmark-set) "bookmark" "\
Set a bookmark named NAME inside a file.  
With prefix arg, will not overwrite a bookmark that has the same name
as NAME if such a bookmark already exists, but instead will \"push\"
the new bookmark onto the bookmark alist.  Thus the most recently set
bookmark with name NAME would be the one in effect at any given time,
but the others are still there, should you decide to delete the most
recent one.

To yank words from the text of the buffer and use them as part of the
bookmark name, type C-w while setting a bookmark.  Successive C-w's
yank successive words.

Typing C-v inserts the name of the current file being visited. Typing
C-u inserts the name of the last bookmark used in the buffer (as an
aid in using a single bookmark name to track your progress through a
large file).  If no bookmark was used, then C-u behaves like C-v and
inserts the name of the file being visited.

Use \\[bookmark-delete] to remove bookmarks (you give it a name,
and it removes only the first instance of a bookmark with that name from
the list of bookmarks.)" t nil)

(autoload (quote bookmark-jump) "bookmark" "\
Jump to bookmark BOOKMARK (a point in some file).  
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

If the file pointed to by BOOKMARK no longer exists, you will be asked
if you wish to give the bookmark a new location, and bookmark-jump
will then jump to the new location, as well as recording it in place
of the old one in the permanent bookmark record." t nil)

(autoload (quote bookmark-relocate) "bookmark" "\
Relocate BOOKMARK -- prompts for a filename, and makes an already
existing bookmark point to that file, instead of the one it used to
point at.  Useful when a file has been renamed after a bookmark was
set in it." t nil)

(autoload (quote bookmark-locate) "bookmark" "\
Insert the name of the file associated with BOOKMARK.
Optional second arg NO-INSERTION means merely return the filename as a
string." t nil)

(autoload (quote bookmark-rename) "bookmark" "\
Change the name of OLD-BOOKMARK to NEWNAME.  
If called from keyboard, prompts for OLD-BOOKMARK and NEWNAME.
If called from menubar, OLD-BOOKMARK is selected from a menu, and
prompts for NEWNAME. 
If called from Lisp, prompts for NEWNAME if only OLD-BOOKMARK was
passed as an argument.  If called with two strings, then no prompting
is done.  You must pass at least OLD-BOOKMARK when calling from Lisp.

While you are entering the new name, consecutive C-w's insert
consectutive words from the text of the buffer into the new bookmark
name, and C-v inserts the name of the file." t nil)

(autoload (quote bookmark-insert) "bookmark" "\
Insert the text of the file pointed to by bookmark BOOKMARK.  
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this." t nil)

(autoload (quote bookmark-delete) "bookmark" "\
Delete the bookmark named NAME from the bookmark list.  
Removes only the first instance of a bookmark with that name.  If
there are one or more other bookmarks with the same name, they will
not be deleted.  Defaults to the \"current\" bookmark (that is, the
one most recently used in this file, if any)." t nil)

(autoload (quote bookmark-write) "bookmark" "\
Write bookmarks to a file (for which the user will be prompted
interactively).  Don't use this in Lisp programs; use bookmark-save
instead." t nil)

(autoload (quote bookmark-save) "bookmark" "\
Save currently defined bookmarks.
Saves by default in the file defined by the variable
`bookmark-file'.  With a prefix arg, save it in file FILE.

If you are calling this from Lisp, the two arguments are PREFIX-ARG
and FILE, and if you just want it to write to the default file, then
pass no arguments.  Or pass in nil and FILE, and it will save in FILE
instead.  If you pass in one argument, and it is non-nil, then the
user will be interactively queried for a file to save in.

When you want to load in the bookmarks from a file, use
`bookmark-load', \\[bookmark-load].  That function will prompt you
for a file, defaulting to the file defined by variable
`bookmark-file'." t nil)

(autoload (quote bookmark-load) "bookmark" "\
Load bookmarks from FILE (which must be in bookmark format).
Appends loaded bookmarks to the front of the list of bookmarks.  If
optional second argument REVERT is non-nil, existing bookmarks are
destroyed.  Optional third arg NO-MSG means don't display any messages
while loading.

If you load a file that doesn't contain a proper bookmark alist, you
will corrupt Emacs's bookmark list.  Generally, you should only load
in files that were created with the bookmark functions in the first
place.  Your own personal bookmark file, `~/.emacs-bkmrks', is
maintained automatically by Emacs; you shouldn't need to load it
explicitly." t nil)

(defalias (quote edit-bookmarks) (quote list-bookmarks))

(autoload (quote list-bookmarks) "bookmark" "\
Display a list of existing bookmarks.
The list is displayed in a buffer named `*Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying." t nil)
(autoload 'menu-bar-bookmark-map "bookmark" nil t 'keymap)

;;;***

;;;### (autoloads (batch-byte-compile display-call-tree byte-compile compile-defun byte-compile-file byte-recompile-directory) "bytecomp" "bytecomp.el" (11367 8231))
;;; Generated autoloads from bytecomp.el

(autoload (quote byte-recompile-directory) "bytecomp" "\
Recompile every `.el' file in DIRECTORY that needs recompilation.
This is if a `.elc' file exists but is older than the `.el' file.
Files in subdirectories of DIRECTORY are processed also.

If the `.elc' file does not exist, normally the `.el' file is *not* compiled.
But a prefix argument (optional second arg) means ask user,
for each such `.el' file, whether to compile it.  Prefix argument 0 means
don't ask and compile the file anyway.

A nonzero prefix argument also means ask about each subdirectory." t nil)

(autoload (quote byte-compile-file) "bytecomp" "\
Compile a file of Lisp code named FILENAME into a file of byte code.
The output file's name is made by appending `c' to the end of FILENAME.
With prefix arg (noninteractively: 2nd arg), load the file after compiling." t nil)

(autoload (quote compile-defun) "bytecomp" "\
Compile and evaluate the current top-level form.
Print the result in the minibuffer.
With argument, insert value in current buffer after the form." t nil)

(autoload (quote byte-compile) "bytecomp" "\
If FORM is a symbol, byte-compile its function definition.
If FORM is a lambda or a macro, byte-compile it as a function." nil nil)

(autoload (quote display-call-tree) "bytecomp" "\
Display a call graph of a specified file.
This lists which functions have been called, what functions called
them, and what functions they call.  The list includes all functions
whose definitions have been compiled in this Emacs session, as well as
all functions called by those functions.

The call graph does not include macros, inline functions, or
primitives that the byte-code interpreter knows about directly (eq,
cons, etc.).

The call tree also lists those functions which are not known to be called
(that is, to which no calls have been compiled), and which cannot be
invoked interactively." t nil)

(autoload (quote batch-byte-compile) "bytecomp" "\
Run `byte-compile-file' on the files remaining on the command line.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.
Each file is processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-byte-compile $emacs/ ~/*.el\"" nil nil)

;;;***

;;;### (autoloads (list-yahrzeit-dates calendar) "calendar" "calendar.el" (11494 46605))
;;; Generated autoloads from calendar.el

(defvar calendar-week-start-day 0 "\
*The day of the week on which a week in the calendar begins.
0 means Sunday (default), 1 means Monday, and so on.")

(defvar view-diary-entries-initially nil "\
*If t, the diary entries for the current date will be displayed on entry.
The diary is displayed in another window when the calendar is first displayed,
if the current date is visible.  The number of days of diary entries displayed
is governed by the variable `number-of-diary-entries'.")

(defvar number-of-diary-entries 1 "\
*Specifies how many days of diary entries are to be displayed initially.
This variable affects the diary display when the command M-x diary is used,
or if the value of the variable `view-diary-entries-initially' is t.  For
example, if the default value 1 is used, then only the current day's diary
entries will be displayed.  If the value 2 is used, then both the current
day's and the next day's entries will be displayed.  The value can also be
a vector such as [0 2 2 2 2 4 1]; this value will cause no diary entries to
be displayed on Sunday, the current date's and the next day's diary entries
to be displayed Monday through Thursday, Friday through Monday's entries to
be displayed on Friday, and only Saturday's entries to be displayed on
Saturday.  This variable does not affect the diary display with the `d'
command from the calendar; in that case, the prefix argument controls the
number of days of diary entries displayed.")

(defvar mark-diary-entries-in-calendar nil "\
*If t, dates with diary entries will be marked in the calendar window.
The marking symbol is specified by the variable `diary-entry-marker'.")

(defvar diary-entry-marker "+" "\
*The symbol used to mark dates that have diary entries.")

(defvar view-calendar-holidays-initially nil "\
*If t, holidays for current three month period will be displayed on entry.
The holidays are displayed in another window when the calendar is first
displayed.")

(defvar mark-holidays-in-calendar nil "\
*If t, dates of holidays will be marked in the calendar window.
The marking symbol is specified by the variable `calendar-holiday-marker'.")

(defvar calendar-holiday-marker "*" "\
*The symbol used to mark notable dates in the calendar.")

(defvar all-hebrew-calendar-holidays nil "\
*If nil, show only major holidays from the Hebrew calendar.

If nil, the only holidays from the Hebrew calendar shown will be those days of
such major interest as to appear on secular calendars.

If t, the holidays shown in the calendar will include all special days that
would be shown on a complete Hebrew calendar.")

(defvar all-christian-calendar-holidays nil "\
*If nil, show only major holidays from the Christian calendar.

If nil, the only holidays from the Christian calendar shown will be those days
of such major interest as to appear on secular calendars.

If t, the holidays shown in the calendar will include all special days that
would be shown on a complete Christian calendar.")

(defvar all-islamic-calendar-holidays nil "\
*If nil, show only major holidays from the Islamic calendar.

If nil, the only holidays from the Islamic calendar shown will be those days
of such major interest as to appear on secular calendars.

If t, the holidays shown in the calendar will include all special days that
would be shown on a complete Islamic calendar.")

(defvar calendar-load-hook nil "\
*List of functions to be called after the calendar is first loaded.
This is the place to add key bindings to calendar-mode-map.")

(defvar initial-calendar-window-hook nil "\
*List of functions to be called when the calendar window is first opened.
The functions invoked are called after the calendar window is opened, but
once opened is never called again.  Leaving the calendar with the `q' command
and reentering it will cause these functions to be called again.")

(defvar today-visible-calendar-hook nil "\
*List of functions called whenever the current date is visible.
This can be used, for example, to replace today's date with asterisks; a
function `calendar-star-date' is included for this purpose:
    (setq today-visible-calendar-hook 'calendar-star-date)
It could also be used to mark the current date with `='; a function is also
provided for this:
    (setq today-visible-calendar-hook 'calendar-mark-today)

The corresponding variable `today-invisible-calendar-hook' is the list of
functions called when the calendar function was called when the current
date is not visible in the window.

Other than the use of the provided functions, the changing of any
characters in the calendar buffer by the hooks may cause the failure of the
functions that move by days and weeks.")

(defvar today-invisible-calendar-hook nil "\
*List of functions called whenever the current date is not visible.

The corresponding variable `today-visible-calendar-hook' is the list of
functions called when the calendar function was called when the current
date is visible in the window.

Other than the use of the provided functions, the changing of any
characters in the calendar buffer by the hooks may cause the failure of the
functions that move by days and weeks.")

(defvar diary-file "~/diary" "\
*Name of the file in which one's personal diary of dates is kept.

The file's entries are lines in any of the forms

            MONTH/DAY
            MONTH/DAY/YEAR
            MONTHNAME DAY
            MONTHNAME DAY, YEAR
            DAYNAME

at the beginning of the line; the remainder of the line is the diary entry
string for that date.  MONTH and DAY are one or two digit numbers, YEAR is
a number and may be written in full or abbreviated to the final two digits.
If the date does not contain a year, it is generic and applies to any year.
DAYNAME entries apply to any date on which is on that day of the week.
MONTHNAME and DAYNAME can be spelled in full, abbreviated to three
characters (with or without a period), capitalized or not.  Any of DAY,
MONTH, or MONTHNAME, YEAR can be `*' which matches any day, month, or year,
respectively.

The European style (in which the day precedes the month) can be used
instead, if you execute `european-calendar' when in the calendar, or set
`european-calendar-style' to t in your .emacs file.  The European forms are

            DAY/MONTH
            DAY/MONTH/YEAR
            DAY MONTHNAME
            DAY MONTHNAME YEAR
            DAYNAME

To revert to the default American style from the European style, execute
`american-calendar' in the calendar.

A diary entry can be preceded by a diary-nonmarking-symbol (ordinarily `&')
to make that entry nonmarking--that is, it will not be marked on dates in
the calendar window but will appear in a diary window.

Multiline diary entries are made by indenting lines after the first with
either a TAB or one or more spaces.

Lines not in one the above formats are ignored.  Here are some sample diary
entries (in the default American style):

     12/22/1988 Twentieth wedding anniversary!!
     &1/1. Happy New Year!
     10/22 Ruth's birthday.
     21: Payday
     Tuesday--weekly meeting with grad students at 10am
              Supowit, Shen, Bitner, and Kapoor to attend.
     1/13/89 Friday the thirteenth!!
     &thu 4pm squash game with Lloyd.
     mar 16 Dad's birthday
     April 15, 1989 Income tax due.
     &* 15 time cards due.

If the first line of a diary entry consists only of the date or day name with
no trailing blanks or punctuation, then that line will not be displayed in the
diary window; only the continuation lines will be shown.  For example, the
single diary entry

     02/11/1989
      Bill Blattner visits Princeton today
      2pm Cognitive Studies Committee meeting
      2:30-5:30 Lizzie at Lawrenceville for `Group Initiative'
      4:00pm Jamie Tappenden
      7:30pm Dinner at George and Ed's for Alan Ryan
      7:30-10:00pm dance at Stewart Country Day School

will appear in the diary window without the date line at the beginning.  This
facility allows the diary window to look neater, but can cause confusion if
used with more than one day's entries displayed.

Diary entries can be based on Lisp sexps.  For example, the diary entry

      %%(diary-block 11 1 1990 11 10 1990) Vacation

causes the diary entry \"Vacation\" to appear from November 1 through November
10, 1990.  Other functions available are `diary-float', `diary-anniversary',
`diary-cyclic', `diary-day-of-year', `diary-iso-date', `diary-french-date',
`diary-hebrew-date', `diary-islamic-date', `diary-mayan-date',
`diary-yahrzeit', `diary-sunrise-sunset', `diary-phases-of-moon',
`diary-parasha', `diary-omer', `diary-rosh-hodesh', and
`diary-sabbath-candles'.  See the documentation for the function
`list-sexp-diary-entries' for more details.

Diary entries based on the Hebrew and/or the Islamic calendar are also
possible, but because these are somewhat slow, they are ignored
unless you set the `nongregorian-diary-listing-hook' and the
`nongregorian-diary-marking-hook' appropriately.  See the documentation
for these functions for details.

Diary files can contain directives to include the contents of other files; for
details, see the documentation for the variable `list-diary-entries-hook'.")

(defvar diary-nonmarking-symbol "&" "\
*Symbol indicating that a diary entry is not to be marked in the calendar.")

(defvar hebrew-diary-entry-symbol "H" "\
*Symbol indicating a diary entry according to the Hebrew calendar.")

(defvar islamic-diary-entry-symbol "I" "\
*Symbol indicating a diary entry according to the Islamic calendar.")

(defvar diary-include-string "#include" "\
*The string indicating inclusion of another file of diary entries.
See the documentation for the function `include-other-diary-files'.")

(defvar sexp-diary-entry-symbol "%%" "\
*The string used to indicate a sexp diary entry in diary-file.
See the documentation for the function `list-sexp-diary-entries'.")

(defvar abbreviated-calendar-year t "\
*Interpret a two-digit year DD in a diary entry as either 19DD or 20DD.
For the Gregorian calendar; similarly for the Hebrew and Islamic calendars.
If this variable is nil, years must be written in full.")

(defvar european-calendar-style nil "\
*Use the European style of dates in the diary and in any displays.
If this variable is t, a date 1/2/1990 would be interpreted as February 1,
1990.  The accepted European date styles are

            DAY/MONTH
            DAY/MONTH/YEAR
            DAY MONTHNAME
            DAY MONTHNAME YEAR
            DAYNAME

Names can be capitalized or not, written in full, or abbreviated to three
characters with or without a period.")

(defvar american-date-diary-pattern (quote ((month "/" day "[^/0-9]") (month "/" day "/" year "[^0-9]") (monthname " *" day "[^,0-9]") (monthname " *" day ", *" year "[^0-9]") (dayname "\\W"))) "\
*List of pseudo-patterns describing the American patterns of date used.
See the documentation of diary-date-forms for an explanation.")

(defvar european-date-diary-pattern (quote ((day "/" month "[^/0-9]") (day "/" month "/" year "[^0-9]") (backup day " *" monthname "\\W+\\<[^*0-9]") (day " *" monthname " *" year "[^0-9]") (dayname "\\W"))) "\
*List of pseudo-patterns describing the European patterns of date used.
See the documentation of diary-date-forms for an explanation.")

(defvar european-calendar-display-form (quote ((if dayname (concat dayname ", ")) day " " monthname " " year)) "\
*Pseudo-pattern governing the way a date appears in the European style.
See the documentation of calendar-date-display-form for an explanation.")

(defvar american-calendar-display-form (quote ((if dayname (concat dayname ", ")) monthname " " day ", " year)) "\
*Pseudo-pattern governing the way a date appears in the American style.
See the documentation of calendar-date-display-form for an explanation.")

(defvar print-diary-entries-hook (quote lpr-buffer) "\
*List of functions called after a temporary diary buffer is prepared.
The buffer shows only the diary entries currently visible in the diary
buffer.  The default just does the printing.  Other uses might include, for
example, rearranging the lines into order by day and time, saving the buffer
instead of deleting it, or changing the function used to do the printing.")

(defvar list-diary-entries-hook nil "\
*List of functions called after diary file is culled for relevant entries.
It is to be used for diary entries that are not found in the diary file.

A function `include-other-diary-files' is provided for use as the value of
this hook.  This function enables you to use shared diary files together
with your own.  The files included are specified in the diary-file by lines
of the form

        #include \"filename\"

This is recursive; that is, #include directives in files thus included are
obeyed.  You can change the \"#include\" to some other string by changing
the variable `diary-include-string'.  When you use `include-other-diary-files'
as part of the list-diary-entries-hook, you will probably also want to use the
function `mark-included-diary-files' as part of the mark-diary-entries-hook.

For example, you could use

     (setq list-diary-entries-hook
       '(include-other-diary-files sort-diary-entries))
     (setq diary-display-hook 'fancy-diary-display)

in your .emacs file to cause the fancy diary buffer to be displayed with
diary entries from various included files, each day's entries sorted into
lexicographic order.")

(defvar diary-hook nil "\
*List of functions called after the display of the diary.
Can be used for appointment notification.")

(defvar diary-display-hook nil "\
*List of functions that handle the display of the diary.
If nil (the default), `simple-diary-display' will be used.  Use `ignore' for no
diary display.

Ordinarily, this just displays the diary buffer (with holidays indicated in
the mode line), if there are any relevant entries.  At the time these
functions are called, the variable `diary-entries-list' is a list, in order
by date, of all relevant diary entries in the form of ((MONTH DAY YEAR)
STRING), where string is the diary entry for the given date.  This can be
used, for example, a different buffer for display (perhaps combined with
holidays), or produce hard copy output.

A function `fancy-diary-display' is provided as an alternative
choice for this hook; this function prepares a special noneditable diary
buffer with the relevant diary entries that has neat day-by-day arrangement
with headings.  The fancy diary buffer will show the holidays unless the
variable `holidays-in-diary-buffer' is set to nil.  Ordinarily, the fancy
diary buffer will not show days for which there are no diary entries, even
if that day is a holiday; if you want such days to be shown in the fancy
diary buffer, set the variable `diary-list-include-blanks' to t.")

(defvar nongregorian-diary-listing-hook nil "\
*List of functions called for listing diary file and included files.
As the files are processed for diary entries, these functions are used to cull
relevant entries.  You can use either or both of `list-hebrew-diary-entries'
and `list-islamic-diary-entries'.  The documentation for these functions
describes the style of such diary entries.")

(defvar mark-diary-entries-hook nil "\
*List of functions called after marking diary entries in the calendar.

A function `mark-included-diary-files' is also provided for use as the
mark-diary-entries-hook; it enables you to use shared diary files together
with your own.  The files included are specified in the diary-file by lines
of the form
        #include \"filename\"
This is recursive; that is, #include directives in files thus included are
obeyed.  You can change the \"#include\" to some other string by changing the
variable `diary-include-string'.  When you use `mark-included-diary-files' as
part of the mark-diary-entries-hook, you will probably also want to use the
function `include-other-diary-files' as part of the list-diary-entries-hook.")

(defvar nongregorian-diary-marking-hook nil "\
*List of functions called for marking diary file and included files.
As the files are processed for diary entries, these functions are used to cull
relevant entries.  You can use either or both of `mark-hebrew-diary-entries'
and `mark-islamic-diary-entries'.  The documentation for these functions
describes the style of such diary entries.")

(defvar diary-list-include-blanks nil "\
*If nil, do not include days with no diary entry in the list of diary entries.
Such days will then not be shown in the the fancy diary buffer, even if they
are holidays.")

(defvar holidays-in-diary-buffer t "\
*If t, the holidays will be indicated in the diary display.
The holidays will be given in the mode line of the diary buffer, or in the
fancy diary buffer next to the date.  This slows down the diary functions
somewhat; setting it to nil will make the diary display faster.")

(defvar general-holidays (quote ((holiday-fixed 1 1 "New Year's Day") (holiday-float 1 1 3 "Martin Luther King Day") (holiday-fixed 2 2 "Ground Hog Day") (holiday-fixed 2 14 "Valentine's Day") (holiday-float 2 1 3 "President's Day") (holiday-fixed 3 17 "St. Patrick's Day") (holiday-fixed 4 1 "April Fool's Day") (holiday-float 5 0 2 "Mother's Day") (holiday-float 5 1 -1 "Memorial Day") (holiday-fixed 6 14 "Flag Day") (holiday-float 6 0 3 "Father's Day") (holiday-fixed 7 4 "Independence Day") (holiday-float 9 1 1 "Labor Day") (holiday-float 10 1 2 "Columbus Day") (holiday-fixed 10 31 "Halloween") (holiday-fixed 11 11 "Veteran's Day") (holiday-float 11 4 4 "Thanksgiving"))) "\
*General holidays.  Default value is for the United States.
See the documentation for `calendar-holidays' for details.")

(defvar local-holidays nil "\
*Local holidays.
See the documentation for `calendar-holidays' for details.")

(defvar other-holidays nil "\
*User defined holidays.
See the documentation for `calendar-holidays' for details.")

(defvar hebrew-holidays-1 (quote ((holiday-rosh-hashanah-etc) (if all-hebrew-calendar-holidays (holiday-julian 11 (let* ((m displayed-month) (y displayed-year) (year)) (increment-calendar-month m y -1) (let ((year (extract-calendar-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y)))))) (if (zerop (% (1+ year) 4)) 22 21))) "\"Tal Umatar\" (evening)")))))

(defvar hebrew-holidays-2 (quote ((if all-hebrew-calendar-holidays (holiday-hanukkah) (holiday-hebrew 9 25 "Hanukkah")) (if all-hebrew-calendar-holidays (holiday-hebrew 10 (let ((h-year (extract-calendar-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list displayed-month 28 displayed-year)))))) (if (= (% (calendar-absolute-from-hebrew (list 10 10 h-year)) 7) 6) 11 10)) "Tzom Teveth")) (if all-hebrew-calendar-holidays (holiday-hebrew 11 15 "Tu B'Shevat")))))

(defvar hebrew-holidays-3 (quote ((if all-hebrew-calendar-holidays (holiday-hebrew 11 (let ((m displayed-month) (y displayed-year)) (increment-calendar-month m y 1) (let* ((h-year (extract-calendar-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list m (calendar-last-day-of-month m y) y))))) (s-s (calendar-hebrew-from-absolute (if (= (% (calendar-absolute-from-hebrew (list 7 1 h-year)) 7) 6) (calendar-dayname-on-or-before 6 (calendar-absolute-from-hebrew (list 11 17 h-year))) (calendar-dayname-on-or-before 6 (calendar-absolute-from-hebrew (list 11 16 h-year)))))) (day (extract-calendar-day s-s))) day)) "Shabbat Shirah")))))

(defvar hebrew-holidays-4 (quote ((holiday-passover-etc) (if (and all-hebrew-calendar-holidays (let* ((m displayed-month) (y displayed-year) (year)) (increment-calendar-month m y -1) (let ((year (extract-calendar-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y)))))) (= 21 (% year 28))))) (holiday-julian 3 26 "Kiddush HaHamah")) (if all-hebrew-calendar-holidays (holiday-tisha-b-av-etc)))))

(defvar hebrew-holidays (append hebrew-holidays-1 hebrew-holidays-2 hebrew-holidays-3 hebrew-holidays-4) "\
*Jewish holidays.
See the documentation for `calendar-holidays' for details.")

(defvar christian-holidays (quote ((if all-christian-calendar-holidays (holiday-fixed 1 6 "Epiphany")) (holiday-easter-etc) (if all-christian-calendar-holidays (holiday-greek-orthodox-easter)) (if all-christian-calendar-holidays (holiday-fixed 8 15 "Assumption")) (if all-christian-calendar-holidays (holiday-advent)) (holiday-fixed 12 25 "Christmas") (if all-christian-calendar-holidays (holiday-julian 12 25 "Eastern Orthodox Christmas")))) "\
*Christian holidays.
See the documentation for `calendar-holidays' for details.")

(defvar islamic-holidays (quote ((holiday-islamic 1 1 (format "Islamic New Year %d" (let ((m displayed-month) (y displayed-year)) (increment-calendar-month m y 1) (extract-calendar-year (calendar-islamic-from-absolute (calendar-absolute-from-gregorian (list m (calendar-last-day-of-month m y) y))))))) (if all-islamic-calendar-holidays (holiday-islamic 1 10 "Ashura")) (if all-islamic-calendar-holidays (holiday-islamic 3 12 "Mulad-al-Nabi")) (if all-islamic-calendar-holidays (holiday-islamic 7 26 "Shab-e-Mi'raj")) (if all-islamic-calendar-holidays (holiday-islamic 8 15 "Shab-e-Bara't")) (holiday-islamic 9 1 "Ramadan Begins") (if all-islamic-calendar-holidays (holiday-islamic 9 27 "Shab-e Qadr")) (if all-islamic-calendar-holidays (holiday-islamic 10 1 "Id-al-Fitr")) (if all-islamic-calendar-holidays (holiday-islamic 12 10 "Id-al-Adha")))) "\
*Islamic holidays.
See the documentation for `calendar-holidays' for details.")

(defvar solar-holidays (quote ((if (fboundp (quote atan)) (solar-equinoxes-solstices)) (if (progn (require (quote cal-dst)) t) (funcall (quote holiday-sexp) calendar-daylight-savings-starts (quote (format "Daylight Savings Time Begins %s" (if (fboundp (quote atan)) (solar-time-string (/ calendar-daylight-savings-starts-time (float 60)) date (quote standard)) ""))))) (funcall (quote holiday-sexp) calendar-daylight-savings-ends (quote (format "Daylight Savings Time Ends %s" (if (fboundp (quote atan)) (solar-time-string (/ (- calendar-daylight-savings-ends-time calendar-daylight-time-offset) (float 60)) date (quote daylight)) "")))))) "\
*Sun-related holidays.
See the documentation for `calendar-holidays' for details.")

(autoload (quote calendar) "calendar" "\
Display a three-month calendar in another window.
The three months appear side by side, with the current month in the middle
surrounded by the previous and next months.  The cursor is put on today's date.

If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file; appropriate setting
of the variable `view-diary-entries-initially' will cause the diary entries for
the current date to be displayed in another window.  The value of the variable
`number-of-diary-entries' controls the number of days of diary entries
displayed upon initial display of the calendar.

An optional prefix argument ARG causes the calendar displayed to be ARG
months in the future if ARG is positive or in the past if ARG is negative;
in this case the cursor goes on the first day of the month.

Once in the calendar window, future or past months can be moved into view.
Arbitrary months can be displayed, or the calendar can be scrolled forward
or backward.

The cursor can be moved forward or backward by one day, one week, one month,
or one year.  All of these commands take prefix arguments which, when negative,
cause movement in the opposite direction.  For convenience, the digit keys
and the minus sign are automatically prefixes.  The window is replotted as
necessary to display the desired date.

Diary entries can be marked on the calendar or displayed in another window.

Use M-x describe-mode for details of the key bindings in the calendar window.

The Gregorian calendar is assumed.

After loading the calendar, the hooks given by the variable
`calendar-load-hook' are run.  This the place to add key bindings to the
calendar-mode-map.

After preparing the calendar window initially, the hooks given by the variable
`initial-calendar-window-hook' are run.

The hooks given by the variable `today-visible-calendar-hook' are run
everytime the calendar window gets scrolled, if the current date is visible
in the window.  If it is not visible, the hooks given by the variable
`today-invisible-calendar-hook' are run.  Thus, for example, setting
`today-visible-calendar-hook' to 'calendar-star-date will cause today's date
to be replaced by asterisks to highlight it whenever it is in the window." t nil)

(autoload (quote list-yahrzeit-dates) "calendar" "\
List Yahrzeit dates for *Gregorian* DEATH-DATE from START-YEAR to END-YEAR.
When called interactively from the calendar window, the date of death is taken
from the cursor position." t nil)

;;;***

;;;### (autoloads (set-case-syntax set-case-syntax-pair set-case-syntax-delims describe-buffer-case-table) "case-table" "case-table.el" (11283 37570))
;;; Generated autoloads from case-table.el

(autoload (quote describe-buffer-case-table) "case-table" "\
Describe the case table of the current buffer." t nil)

(autoload (quote set-case-syntax-delims) "case-table" "\
Make characters L and R a matching pair of non-case-converting delimiters.
This sets the entries for L and R in TABLE, which is a string
that will be used as the downcase part of a case table.
It also modifies `standard-syntax-table', and `text-mode-syntax-table' to
indicate left and right delimiters." nil nil)

(autoload (quote set-case-syntax-pair) "case-table" "\
Make characters UC and LC a pair of inter-case-converting letters.
This sets the entries for characters UC and LC in TABLE, which is a string
that will be used as the downcase part of a case table.
It also modifies `standard-syntax-table' and `text-mode-syntax-table'
to indicate an (uppercase, lowercase) pair of letters." nil nil)

(autoload (quote set-case-syntax) "case-table" "\
Make characters C case-invariant with syntax SYNTAX.
This sets the entries for character C in TABLE, which is a string
that will be used as the downcase part of a case table.
It also modifies `standard-syntax-table' and `text-mode-syntax-table'.
SYNTAX should be \" \", \"w\", \".\" or \"_\"." nil nil)

;;;***

;;;### (autoloads (command-history-mode list-command-history repeat-matching-complex-command) "chistory" "chistory.el" (11196 27803))
;;; Generated autoloads from chistory.el

(autoload (quote repeat-matching-complex-command) "chistory" "\
Edit and re-evaluate complex command with name matching PATTERN.
Matching occurrences are displayed, most recent first, until you select
a form for evaluation.  If PATTERN is empty (or nil), every form in the
command history is offered.  The form is placed in the minibuffer for
editing and the result is evaluated." t nil)

(autoload (quote list-command-history) "chistory" "\
List history of commands typed to minibuffer.
The number of commands listed is controlled by `list-command-history-max'.
Calls value of `list-command-history-filter' (if non-nil) on each history
element to judge if that element should be excluded from the list.

The buffer is left in Command History mode." t nil)

(autoload (quote command-history-mode) "chistory" "\
Major mode for examining commands from `command-history'.
The number of commands listed is controlled by `list-command-history-max'.
The command history is filtered by `list-command-history-filter' if non-nil.
Use \\<command-history-map>\\[command-history-repeat] to repeat the command on the current line.

Otherwise much like Emacs-Lisp Mode except that there is no self-insertion
and digits provide prefix arguments.  Tab does not indent.
\\{command-history-map}
Calls the value of `command-history-hook' if that is non-nil.
The Command History listing is recomputed each time this mode is invoked." t nil)

;;;***

;;;### (autoloads (common-lisp-indent-function) "cl-indent" "cl-indent.el" (11285 49748))
;;; Generated autoloads from cl-indent.el

(autoload (quote common-lisp-indent-function) "cl-indent" nil nil nil)

;;;***

;;;### (autoloads (make-comint) "comint" "comint.el" (11367 8243))
;;; Generated autoloads from comint.el

(autoload (quote make-comint) "comint" "\
Make a comint process NAME in a buffer, running PROGRAM.
The name of the buffer is made by surrounding NAME with `*'s.
If there is already a running process in that buffer, it is not restarted.
Optional third arg STARTFILE is the name of a file to send the contents of to 
the process.  Any more args are arguments to PROGRAM." nil nil)

;;;***

;;;### (autoloads (compare-windows) "compare-w" "compare-w.el" (11330 25785))
;;; Generated autoloads from compare-w.el

(autoload (quote compare-windows) "compare-w" "\
Compare text in current window with text in next window.
Compares the text starting at point in each window,
moving over text in each one as far as they match.

A prefix arg means ignore changes in whitespace.
The variable `compare-windows-whitespace' controls how whitespace is skipped.
If `compare-ignore-case' is non-nil, changes in case are also ignored." t nil)

;;;***

;;;### (autoloads (next-error compilation-minor-mode grep compile) "compile" "compile.el" (11358 55857))
;;; Generated autoloads from compile.el

(defvar compilation-mode-hook nil "\
*List of hook functions run by `compilation-mode' (see `run-hooks').")

(defconst compilation-window-height nil "\
*Number of lines in a compilation window.  If nil, use Emacs default.")

(defvar compilation-buffer-name-function nil "\
Function to compute the name of a compilation buffer.
The function receives one argument, the name of the major mode of the
compilation buffer.  It should return a string.
nil means compute the name with `(concat \"*\" (downcase major-mode) \"*\")'.")

(defvar compilation-finish-function nil "\
*Function to call when a compilation process finishes.
It is called with two arguments: the compilation buffer, and a string
describing how the process finished.")

(defvar compilation-search-path (quote (nil)) "\
*List of directories to search for source files named in error messages.
Elements should be directory names, not file names of directories.
nil as an element means to try the default directory.")

(autoload (quote compile) "compile" "\
Compile the program including the current buffer.  Default: run `make'.
Runs COMMAND, a shell command, in a separate process asynchronously
with output going to the buffer `*compilation*'.

You can then use the command \\[next-error] to find the next error message
and move to the source code that caused it.

To run more than one compilation at once, start one and rename the
`*compilation*' buffer to some other name with \\[rename-buffer].
Then start the next one.

The name used for the buffer is actually whatever is returned by
the function in `compilation-buffer-name-function', so you can set that
to a function that generates a unique name." t nil)

(autoload (quote grep) "compile" "\
Run grep, with user-specified args, and collect output in a buffer.
While grep runs asynchronously, you can use the \\[next-error] command
to find the text that grep hits refer to.

This command uses a special history list for its arguments, so you can
easily repeat a grep command." t nil)

(autoload (quote compilation-minor-mode) "compile" "\
Toggle compilation minor mode.
With arg, turn compilation mode on if and only if arg is positive.
See `compilation-mode'." t nil)

(autoload (quote next-error) "compile" "\
Visit next compilation error message and corresponding source code.
This operates on the output from the \\[compile] command.
If all preparsed error messages have been processed,
the error message buffer is checked for new ones.

A prefix arg specifies how many error messages to move;
negative means move back to previous error messages.
Just C-u as a prefix means reparse the error message buffer
and start at the first error.

\\[next-error] normally applies to the most recent compilation started,
but as long as you are in the middle of parsing errors from one compilation
output buffer, you stay with that compilation output buffer.

Use \\[next-error] in a compilation output buffer to switch to
processing errors from that compilation.

See variables `compilation-parse-errors-function' and
`compilation-error-regexp-alist' for customization ideas." t nil)

(define-key ctl-x-map "`" (quote next-error))

;;;***

;;;### (autoloads (shuffle-vector cookie-snarf cookie-insert cookie) "cookie1" "cookie1.el" (11356 11391))
;;; Generated autoloads from cookie1.el

(autoload (quote cookie) "cookie1" "\
Return a random phrase from PHRASE-FILE.  When the phrase file
is read in, display STARTMSG at beginning of load, ENDMSG at end." nil nil)

(autoload (quote cookie-insert) "cookie1" "\
Insert random phrases from PHRASE-FILE; COUNT of them.  When the phrase file
is read in, display STARTMSG at beginning of load, ENDMSG at end." nil nil)

(autoload (quote cookie-snarf) "cookie1" "\
Reads in the PHRASE-FILE, returns it as a vector of strings.  Emit
STARTMSG and ENDMSG before and after.  Caches the result; second and
subsequent calls on the same file won't go to disk." nil nil)

(autoload (quote shuffle-vector) "cookie1" "\
Randomly permute the elements of VECTOR (all permutations equally likely)" nil nil)

;;;***

;;;### (autoloads (c++-mode) "cplus-md" "cplus-md.el" (11349 24039))
;;; Generated autoloads from cplus-md.el

(autoload (quote c++-mode) "cplus-md" "\
Major mode for editing C++ code.  Very much like editing C code.
Expression and list commands understand all C++ brackets.
Tab at left margin indents for C++ code
Comments are delimited with /* ... */ {or with // ... <newline>}
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{c++-mode-map}
Variables controlling indentation style:
 c-tab-always-indent
    Non-nil means TAB in C mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
    Default is t.
 c-auto-newline
    Non-nil means automatically newline before and after braces,
    and after colons and semicolons, inserted in C code.
 c-indent-level
    Indentation of C statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 c-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 c-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to c-continued-statement-offset.
 c-brace-offset
    Extra indentation for line if it starts with an open brace.
 c-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 c-argdecl-indent
    Indentation level of declarations of C function arguments.
 c-label-offset
    Extra indentation for line that is a label, or case or ``default:'', or
    ``public:'' or ``private:'', or ``protected:''.
 c++-electric-colon
    If non-nil at invocation of c++-mode (t is the default) colon electricly
    indents.
 c++-empty-arglist-indent
    If non-nil, a function declaration or invocation which ends a line with a
    left paren is indented this many extra spaces, instead of flush with the
    left paren.
 c++-friend-offset
    Offset of C++ friend class declarations relative to member declarations.
 c++-member-init-indent
    Indentation level of member initializations in function declarations,
    if they are on a separate line beginning with a colon.
 c++-continued-member-init-offset
    Extra indentation for continuation lines of member initializations; NIL
    means to align with previous initializations rather than with the colon.

Settings for K&R, BSD, and Stroustrup indentation styles are
  c-indent-level                5    8    4
  c-continued-statement-offset  5    8    4
  c-continued-brace-offset                0
  c-brace-offset               -5   -8    0
  c-brace-imaginary-offset                0
  c-argdecl-indent              0    8    4
  c-label-offset               -5   -8   -4
  c++-empty-arglist-indent                4
  c++-friend-offset                       0

Turning on C++ mode calls the value of the variable `c++-mode-hook' with
no args if that value is non-nil." t nil)

;;;***

;;;### (autoloads (dabbrev-expand) "dabbrev" "dabbrev.el" (11292 51554))
;;; Generated autoloads from dabbrev.el

(autoload (quote dabbrev-expand) "dabbrev" "\
Expand previous word \"dynamically\".
Expands to the most recent, preceding word for which this is a prefix.
If no suitable preceding word is found, words following point are considered.

If `case-fold-search' and `case-replace' are non-nil (usually true)
then the substituted word may be case-adjusted to match the abbreviation
that you had typed.  This takes place if the substituted word, as found,
is all lower case, or if it is at the beginning of a sentence and only
its first letter was upper case.

A positive prefix arg N says to take the Nth backward DISTINCT
possibility.  A negative argument says search forward.  The variable
`dabbrev-backward-only' may be used to limit the direction of search to
backward if set non-nil.

If the cursor has not moved from the end of the previous expansion and
no argument is given, replace the previously-made expansion
with the next possible expansion not yet tried." t nil)

(define-key esc-map "/" (quote dabbrev-expand))

;;;***

;;;### (autoloads (cancel-debug-on-entry debug-on-entry debug) "debug" "debug.el" (11181 53262))
;;; Generated autoloads from debug.el

(setq debugger (quote debug))

(autoload (quote debug) "debug" "\
Enter debugger.  Returns if user says \"continue\".
Arguments are mainly for use when this is called from the internals
of the evaluator.

You may call with no args, or you may pass nil as the first arg and
any other args you like.  In that case, the list of args after the
first will be printed into the backtrace buffer." nil nil)

(autoload (quote debug-on-entry) "debug" "\
Request FUNCTION to invoke debugger each time it is called.
If the user continues, FUNCTION's execution proceeds.
Works by modifying the definition of FUNCTION,
which must be written in Lisp, not predefined.
Use \\[cancel-debug-on-entry] to cancel the effect of this command.
Redefining FUNCTION also does that." t nil)

(autoload (quote cancel-debug-on-entry) "debug" "\
Undo effect of \\[debug-on-entry] on FUNCTION.
If argument is nil or an empty string, cancel for all functions." t nil)

;;;***

;;;### (autoloads (delete-selection-mode) "delsel" "delsel.el" (11259 36696))
;;; Generated autoloads from delsel.el

(defalias (quote pending-delete-mode) (quote delete-selection-mode))

(autoload (quote delete-selection-mode) "delsel" "\
Toggle Delete Selection mode.
When ON, typed text replaces the selection if the selection is active.
When OFF, typed text is just inserted at point." t nil)

;;;***

;;;### (autoloads (diary) "diary" "diary.el" (11360 16265))
;;; Generated autoloads from diary.el

(autoload (quote diary) "diary" "\
Generate the diary window for ARG days starting with the current date.
If no argument is provided, the number of days of diary entries is governed
by the variable `number-of-diary-entries'.  This function is suitable for
execution in a `.emacs' file." t nil)

;;;***

;;;### (autoloads (diff-backup diff) "diff" "diff.el" (11302 33003))
;;; Generated autoloads from diff.el

(autoload (quote diff) "diff" "\
Find and display the differences between OLD and NEW files.
Interactively the current buffer's file name is the default for for NEW
and a backup file for NEW is the default for OLD.
With prefix arg, prompt for diff switches." t nil)

(autoload (quote diff-backup) "diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'." t nil)

;;;***

;;;### (autoloads (dired-hide-all dired-hide-subdir dired-tree-down dired-tree-up dired-kill-subdir dired-mark-subdir-files dired-goto-subdir dired-prev-subdir dired-maybe-insert-subdir dired-downcase dired-upcase dired-do-symlink-regexp dired-do-hardlink-regexp dired-do-copy-regexp dired-do-rename-regexp dired-do-rename dired-do-hardlink dired-do-symlink dired-do-copy dired-create-directory dired-string-replace-match dired-do-redisplay dired-do-load dired-do-byte-compile dired-do-compress dired-do-kill-lines dired-do-shell-command dired-do-print dired-do-chown dired-do-chgrp dired-do-chmod dired-backup-diff dired-diff) "dired-aux" "dired-aux.el" (11364 34565))
;;; Generated autoloads from dired-aux.el

(autoload (quote dired-diff) "dired-aux" "\
Compare file at point with file FILE using `diff'.
FILE defaults to the file at the mark.
The prompted-for file is the first file given to `diff'.
With prefix arg, prompt for second argument SWITCHES,
 which is options for `diff'." t nil)

(autoload (quote dired-backup-diff) "dired-aux" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'.
With prefix arg, prompt for argument SWITCHES which is options for `diff'." t nil)

(autoload (quote dired-do-chmod) "dired-aux" "\
Change the mode of the marked (or next ARG) files.
This calls chmod, thus symbolic modes like `g+w' are allowed." t nil)

(autoload (quote dired-do-chgrp) "dired-aux" "\
Change the group of the marked (or next ARG) files." t nil)

(autoload (quote dired-do-chown) "dired-aux" "\
Change the owner of the marked (or next ARG) files." t nil)

(autoload (quote dired-do-print) "dired-aux" "\
Print the marked (or next ARG) files.
Uses the shell command coming from variables `lpr-command' and
`lpr-switches' as default." t nil)

(autoload (quote dired-do-shell-command) "dired-aux" "\
Run a shell command COMMAND on the marked files.
If no files are marked or a specific numeric prefix arg is given,
the next ARG files are used.  Just \\[universal-argument] means the current file.
The prompt mentions the file(s) or the marker, as appropriate.

If there is output, it goes to a separate buffer.

Normally the command is run on each file individually.
However, if there is a `*' in the command then it is run
just once with the entire file list substituted there.

No automatic redisplay of dired buffers is attempted, as there's no
telling what files the command may have changed.  Type
\\[dired-do-redisplay] to redisplay the marked files.

The shell command has the top level directory as working directory, so
output files usually are created there instead of in a subdir." t nil)

(autoload (quote dired-do-kill-lines) "dired-aux" "\
Kill all marked lines (not the files).
With a prefix argument, kill that many lines starting with the current line.
(A negative argument kills lines before the current line.)
To kill an entire subdirectory, go to its directory header line
and use this command with a prefix argument (the value does not matter)." t nil)

(autoload (quote dired-do-compress) "dired-aux" "\
Compress or uncompress marked (or next ARG) files." t nil)

(autoload (quote dired-do-byte-compile) "dired-aux" "\
Byte compile marked (or next ARG) Emacs Lisp files." t nil)

(autoload (quote dired-do-load) "dired-aux" "\
Load the marked (or next ARG) Emacs Lisp files." t nil)

(autoload (quote dired-do-redisplay) "dired-aux" "\
Redisplay all marked (or next ARG) files.
If on a subdir line, redisplay that subdirectory.  In that case,
a prefix arg lets you edit the `ls' switches used for the new listing." t nil)

(autoload (quote dired-string-replace-match) "dired-aux" "\
Replace first match of REGEXP in STRING with NEWTEXT.
If it does not match, nil is returned instead of the new string.
Optional arg LITERAL means to take NEWTEXT literally.
Optional arg GLOBAL means to replace all matches." nil nil)

(autoload (quote dired-create-directory) "dired-aux" "\
Create a directory called DIRECTORY." t nil)

(autoload (quote dired-do-copy) "dired-aux" "\
Copy all marked (or next ARG) files, or copy the current file.
This normally preserves the last-modified date when copying.
When operating on just the current file, you specify the new name.
When operating on multiple or marked files, you specify a directory
and new symbolic links are made in that directory
with the same names that the files currently have." t nil)

(autoload (quote dired-do-symlink) "dired-aux" "\
Make symbolic links to current file or all marked (or next ARG) files.
When operating on just the current file, you specify the new name.
When operating on multiple or marked files, you specify a directory
and new symbolic links are made in that directory
with the same names that the files currently have." t nil)

(autoload (quote dired-do-hardlink) "dired-aux" "\
Add names (hard links) current file or all marked (or next ARG) files.
When operating on just the current file, you specify the new name.
When operating on multiple or marked files, you specify a directory
and new hard links are made in that directory
with the same names that the files currently have." t nil)

(autoload (quote dired-do-rename) "dired-aux" "\
Rename current file or all marked (or next ARG) files.
When renaming just the current file, you specify the new name.
When renaming multiple or marked files, you specify a directory." t nil)

(autoload (quote dired-do-rename-regexp) "dired-aux" "\
Rename marked files containing REGEXP to NEWNAME.
As each match is found, the user must type a character saying
  what to do with it.  For directions, type \\[help-command] at that time.
NEWNAME may contain \\=\\<n> or \\& as in `query-replace-regexp'.
REGEXP defaults to the last regexp used.
With a zero prefix arg, renaming by regexp affects the complete
  pathname - usually only the non-directory part of file names is used
  and changed." t nil)

(autoload (quote dired-do-copy-regexp) "dired-aux" "\
Copy all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload (quote dired-do-hardlink-regexp) "dired-aux" "\
Hardlink all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload (quote dired-do-symlink-regexp) "dired-aux" "\
Symlink all marked files containing REGEXP to NEWNAME.
See function `dired-rename-regexp' for more info." t nil)

(autoload (quote dired-upcase) "dired-aux" "\
Rename all marked (or next ARG) files to upper case." t nil)

(autoload (quote dired-downcase) "dired-aux" "\
Rename all marked (or next ARG) files to lower case." t nil)

(autoload (quote dired-maybe-insert-subdir) "dired-aux" "\
Insert this subdirectory into the same dired buffer.
If it is already present, just move to it (type \\[dired-do-redisplay] to refresh),
  else inserts it at its natural place (as `ls -lR' would have done).
With a prefix arg, you may edit the ls switches used for this listing.
  You can add `R' to the switches to expand the whole tree starting at
  this subdirectory.
This function takes some pains to conform to `ls -lR' output." t nil)

(autoload (quote dired-prev-subdir) "dired-aux" "\
Go to previous subdirectory, regardless of level.
When called interactively and not on a subdir line, go to this subdir's line." t nil)

(autoload (quote dired-goto-subdir) "dired-aux" "\
Go to end of header line of DIR in this dired buffer.
Return value of point on success, otherwise return nil.
The next char is either \\n, or \\r if DIR is hidden." t nil)

(autoload (quote dired-mark-subdir-files) "dired-aux" "\
Mark all files except `.' and `..'." t nil)

(autoload (quote dired-kill-subdir) "dired-aux" "\
Remove all lines of current subdirectory.
Lower levels are unaffected." t nil)

(autoload (quote dired-tree-up) "dired-aux" "\
Go up ARG levels in the dired tree." t nil)

(autoload (quote dired-tree-down) "dired-aux" "\
Go down in the dired tree." t nil)

(autoload (quote dired-hide-subdir) "dired-aux" "\
Hide or unhide the current subdirectory and move to next directory.
Optional prefix arg is a repeat factor.
Use \\[dired-hide-all] to (un)hide all directories." t nil)

(autoload (quote dired-hide-all) "dired-aux" "\
Hide all subdirectories, leaving only their header lines.
If there is already something hidden, make everything visible again.
Use \\[dired-hide-subdir] to (un)hide a particular subdirectory." t nil)

;;;***

;;;### (autoloads (dired-noselect dired-other-frame dired-other-window dired) "dired" "dired.el" (11355 44777))
;;; Generated autoloads from dired.el

(defvar dired-listing-switches "-al" "\
*Switches passed to `ls' for dired.  MUST contain the `l' option.
May contain all other options that don't contradict `-l';
may contain even `F', `b', `i' and `s'.")

(defvar dired-chown-program (if (memq system-type (quote (hpux dgux usg-unix-v irix))) "chown" "/etc/chown") "\
Name of chown command (usually `chown' or `/etc/chown').")

(defvar dired-ls-F-marks-symlinks nil "\
*Informs dired about how `ls -lF' marks symbolic links.
Set this to t if `insert-directory-program' with `-lF' marks the symbolic link
itself with a trailing @ (usually the case under Ultrix).

Example: if `ln -s foo bar; ls -F bar' gives `bar -> foo', set it to
nil (the default), if it gives `bar@ -> foo', set it to t.

Dired checks if there is really a @ appended.  Thus, if you have a
marking `ls' program on one host and a non-marking on another host, and
don't care about symbolic links which really end in a @, you can
always set this variable to t.")

(defvar dired-trivial-filenames "^\\.\\.?$\\|^#" "\
*Regexp of files to skip when finding first file of a directory.
A value of nil means move to the subdir line.
A value of t means move to first file.")

(defvar dired-keep-marker-rename t "\
*Controls marking of renamed files.
If t, files keep their previous marks when they are renamed.
If a character, renamed files (whether previously marked or not)
are afterward marked with that character.")

(defvar dired-keep-marker-copy 67 "\
*Controls marking of copied files.
If t, copied files are marked if and as the corresponding original files were.
If a character, copied files are unconditionally marked with that character.")

(defvar dired-keep-marker-hardlink 72 "\
*Controls marking of newly made hard links.
If t, they are marked if and as the files linked to were marked.
If a character, new links are unconditionally marked with that character.")

(defvar dired-keep-marker-symlink 89 "\
*Controls marking of newly made symbolic links.
If t, they are marked if and as the files linked to were marked.
If a character, new links are unconditionally marked with that character.")

(defvar dired-dwim-target nil "\
*If non-nil, dired tries to guess a default target directory.
This means: if there is a dired buffer displayed in the next window,
use its current subdir, instead of the current subdir of this dired buffer.

The target is used in the prompt for file copy, rename etc.")

(defvar dired-copy-preserve-time t "\
*If non-nil, Dired preserves the last-modified time in a file copy.
(This works on only some systems.)")
(define-key ctl-x-map "d" 'dired)

(autoload (quote dired) "dired" "\
\"Edit\" directory DIRNAME--delete, rename, print, etc. some files in it.
Optional second argument SWITCHES specifies the `ls' options used.
(Interactively, use a prefix argument to be able to specify SWITCHES.)
Dired displays a list of files in DIRNAME (which may also have
shell wildcards appended to select certain files).  If DIRNAME is a cons,
its first element is taken as the directory name and the resr as an explicit
list of files to make directory entries for.
\\<dired-mode-map>You can move around in it with the usual commands.
You can flag files for deletion with \\[dired-flag-file-deletion] and then
delete them by typing \\[dired-do-flagged-delete].
Type \\[describe-mode] after entering dired for more info.

If DIRNAME is already in a dired buffer, that buffer is used without refresh." t nil)
(define-key ctl-x-4-map "d" 'dired-other-window)

(autoload (quote dired-other-window) "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but selects in another window." t nil)
(define-key ctl-x-5-map "d" 'dired-other-frame)

(autoload (quote dired-other-frame) "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but makes a new frame." t nil)

(autoload (quote dired-noselect) "dired" "\
Like `dired' but returns the dired buffer as value, does not select it." nil nil)

;;;***

;;;### (autoloads (disassemble) "disass" "disass.el" (11295 37242))
;;; Generated autoloads from disass.el

(autoload (quote disassemble) "disass" "\
Print disassembled code for OBJECT in (optional) BUFFER.
OBJECT can be a symbol defined as a function, or a function itself
(a lambda expression or a compiled-function object).
If OBJECT is not already compiled, we compile it, but do not
redefine OBJECT if it is a symbol." t nil)

;;;***

;;;### (autoloads (standard-display-european create-glyph standard-display-underline standard-display-graphic standard-display-g1 standard-display-ascii standard-display-default standard-display-8bit make-display-table describe-current-display-table) "disp-table" "disp-table.el" (11265 29044))
;;; Generated autoloads from disp-table.el

(autoload (quote describe-current-display-table) "disp-table" "\
Describe the display table in use in the selected window and buffer." t nil)

(autoload (quote make-display-table) "disp-table" "\
Return a new, empty display table." nil nil)

(autoload (quote standard-display-8bit) "disp-table" "\
Display characters in the range L to H literally." nil nil)

(autoload (quote standard-display-default) "disp-table" "\
Display characters in the range L to H using the default notation." nil nil)

(autoload (quote standard-display-ascii) "disp-table" "\
Display character C using string S." nil nil)

(autoload (quote standard-display-g1) "disp-table" "\
Display character C as character SC in the g1 character set." nil nil)

(autoload (quote standard-display-graphic) "disp-table" "\
Display character C as character GC in graphics character set." nil nil)

(autoload (quote standard-display-underline) "disp-table" "\
Display character C as character UC plus underlining." nil nil)

(autoload (quote create-glyph) "disp-table" nil nil nil)

(autoload (quote standard-display-european) "disp-table" "\
Toggle display of European characters encoded with ISO 8859.
When enabled, characters in the range of 160 to 255 display not
as octal escapes, but as accented characters.
With prefix argument, enable European character display iff arg is positive." t nil)

;;;***

;;;### (autoloads (dissociated-press) "dissociate" "dissociate.el" (11356 11391))
;;; Generated autoloads from dissociate.el

(autoload (quote dissociated-press) "dissociate" "\
Dissociate the text of the current buffer.
Output goes in buffer named *Dissociation*,
which is redisplayed each time text is added to it.
Every so often the user must say whether to continue.
If ARG is positive, require ARG chars of continuity.
If ARG is negative, require -ARG words of continuity.
Default is 2." t nil)

;;;***

;;;### (autoloads (doctor) "doctor" "doctor.el" (11344 11919))
;;; Generated autoloads from doctor.el

(autoload (quote doctor) "doctor" "\
Switch to *doctor* buffer and start giving psychotherapy." t nil)

;;;***

;;;### (autoloads (dunnet) "dunnet" "dunnet.el" (11356 11391))
;;; Generated autoloads from dunnet.el

(autoload (quote dunnet) "dunnet" "\
Switch to *dungeon* buffer and start game." t nil)

;;;***

;;;### (autoloads (electric-buffer-list) "ebuff-menu" "ebuff-menu.el" (11189 17403))
;;; Generated autoloads from ebuff-menu.el

(autoload (quote electric-buffer-list) "ebuff-menu" "\
Pops up a buffer describing the set of Emacs buffers.
Vaguely like ITS lunar select buffer; combining typeoutoid buffer
listing with menuoid buffer selection.

If the very next character typed is a space then the buffer list
window disappears.  Otherwise, one may move around in the buffer list
window, marking buffers to be selected, saved or deleted.

To exit and select a new buffer, type a space when the cursor is on
the appropriate line of the buffer-list window.  Other commands are
much like those of buffer-menu-mode.

Calls value of `electric-buffer-menu-mode-hook' on entry if non-nil.

\\{electric-buffer-menu-mode-map}" t nil)

;;;***

;;;### (autoloads (Electric-command-history-redo-expression) "echistory" "echistory.el" (11288 43486))
;;; Generated autoloads from echistory.el

(autoload (quote Electric-command-history-redo-expression) "echistory" "\
Edit current history line in minibuffer and execute result.
With prefix arg NOCONFIRM, execute current line as-is without editing." t nil)

;;;***

;;;### (autoloads (edebug-debug edebug-defun) "edebug" "edebug.el" (11285 51182))
;;; Generated autoloads from edebug.el

(autoload (quote edebug-defun) "edebug" "\
Evaluate defun or defmacro, like eval-defun, but with edebug calls.
Print its name in the minibuffer and leave point after any error it finds,
with mark at the original point." t nil)

(defvar global-edebug-prefix "X" "\
Prefix key for global edebug commands, available from any buffer.")

(defvar global-edebug-map nil "\
Global map of edebug commands, available from any buffer.")

(if global-edebug-map nil (setq global-edebug-map (make-sparse-keymap)) (global-unset-key global-edebug-prefix) (global-set-key global-edebug-prefix global-edebug-map) (define-key global-edebug-map "d" (quote edebug-defun)) (define-key global-edebug-map " " (quote edebug-step-through)) (define-key global-edebug-map "g" (quote edebug-go)) (define-key global-edebug-map "G" (quote edebug-Go-nonstop)) (define-key global-edebug-map "t" (quote edebug-trace)) (define-key global-edebug-map "T" (quote edebug-Trace-fast)) (define-key global-edebug-map "c" (quote edebug-continue)) (define-key global-edebug-map "C" (quote edebug-Continue-fast)) (define-key global-edebug-map "b" (quote edebug-set-breakpoint)) (define-key global-edebug-map "x" (quote edebug-set-conditional-breakpoint)) (define-key global-edebug-map "u" (quote edebug-unset-breakpoint)) (define-key global-edebug-map "w" (quote edebug-where)) (define-key global-edebug-map "q" (quote top-level)))

(autoload (quote edebug-debug) "edebug" "\
Replacement for debug.  
If an error or quit occurred and we are running an edebugged function,
show where we last were.  Otherwise call debug normally." nil nil)

;;;***

;;;### (autoloads (read-kbd-macro edit-kbd-macro edit-last-kbd-macro) "edmacro" "edmacro.el" (11176 61364))
;;; Generated autoloads from edmacro.el

(autoload (quote edit-last-kbd-macro) "edmacro" "\
Edit the most recently defined keyboard macro." t nil)

(autoload (quote edit-kbd-macro) "edmacro" "\
Edit a keyboard macro which has been given a name by `name-last-kbd-macro'.
(See also `edit-last-kbd-macro'.)" t nil)

(autoload (quote read-kbd-macro) "edmacro" "\
Read the region as a keyboard macro definition.
The region is interpreted as spelled-out keystrokes, e.g., \"M-x abc RET\".
The resulting macro is installed as the \"current\" keyboard macro.

Symbols:  RET, SPC, TAB, DEL, LFD, NUL; C-key; M-key.  (Must be uppercase.)
          REM marks the rest of a line as a comment.
          Whitespace is ignored; other characters are copied into the macro." t nil)

;;;***

;;;### (autoloads (edt-emulation-on) "edt" "edt.el" (11344 10928))
;;; Generated autoloads from edt.el

(autoload (quote edt-emulation-on) "edt" "\
Emulate DEC's EDT editor.
Note that many keys are rebound; including nearly all keypad keys.
Use \\[edt-emulation-off] to undo all rebindings except the keypad keys." t nil)

;;;***

;;;### (autoloads (report-emacs-bug) "emacsbug" "emacsbug.el" (11185 3426))
;;; Generated autoloads from emacsbug.el

(autoload (quote report-emacs-bug) "emacsbug" "\
Report a bug in GNU Emacs.
Prompts for bug subject.  Leaves you in a mail buffer." t nil)

;;;***

;;;### (autoloads (emerge-files-with-ancestor-remote emerge-files-remote emerge-files-with-ancestor-command emerge-files-command emerge-buffers-with-ancestor emerge-buffers emerge-files-with-ancestor emerge-files) "emerge" "emerge.el" (11356 11307))
;;; Generated autoloads from emerge.el

(autoload (quote emerge-files) "emerge" "\
Run Emerge on two files." t nil)

(autoload (quote emerge-files-with-ancestor) "emerge" "\
Run Emerge on two files, giving another file as the ancestor." t nil)

(autoload (quote emerge-buffers) "emerge" "\
Run Emerge on two buffers." t nil)

(autoload (quote emerge-buffers-with-ancestor) "emerge" "\
Run Emerge on two buffers, giving another buffer as the ancestor." t nil)

(autoload (quote emerge-files-command) "emerge" nil nil nil)

(autoload (quote emerge-files-with-ancestor-command) "emerge" nil nil nil)

(autoload (quote emerge-files-remote) "emerge" nil nil nil)

(autoload (quote emerge-files-with-ancestor-remote) "emerge" nil nil nil)

;;;***

;;;### (autoloads (setenv) "env" "env.el" (11288 64005))
;;; Generated autoloads from env.el

(autoload (quote setenv) "env" "\
Set the value of the environment variable named VARIABLE to VALUE.
VARIABLE should be a string.  VALUE is optional; if not provided or is
`nil', the environment variable VARIABLE will be removed.  
This function works by modifying `process-environment'." t nil)

;;;***

;;;### (autoloads (complete-tag select-tags-table tags-apropos list-tags tags-query-replace tags-search tags-loop-continue next-file find-tag-regexp find-tag-other-frame find-tag-other-window find-tag find-tag-noselect tags-table-files visit-tags-table) "etags" "etags.el" (11487 17108))
;;; Generated autoloads from etags.el

(defvar tags-file-name nil "\
*File name of tags table.
To switch to a new tags table, setting this variable is sufficient.
If you set this variable, do not also set `tags-table-list'.
Use the `etags' program to make a tags table file.")
(put 'tags-file-name 'variable-interactive "fVisit tags table: ")

(defvar tags-table-list nil "\
*List of file names of tags tables to search.
An element that is a directory means the file \"TAGS\" in that directory.
To switch to a new list of tags tables, setting this variable is sufficient.
If you set this variable, do not also set `tags-file-name'.
Use the `etags' program to make a tags table file.")

(defvar find-tag-hook nil "\
*Hook to be run by \\[find-tag] after finding a tag.  See `run-hooks'.
The value in the buffer in which \\[find-tag] is done is used,
not the value in the buffer \\[find-tag] goes to.")

(defvar find-tag-default-function nil "\
*A function of no arguments used by \\[find-tag] to pick a default tag.
If nil, and the symbol that is the value of `major-mode'
has a `find-tag-default-function' property (see `put'), that is used.
Otherwise, `find-tag-default' is used.")

(defvar default-tags-table-function nil "\
*If non-nil, a function of no arguments to choose a default tags file
for a particular buffer.")

(autoload (quote visit-tags-table) "etags" "\
Tell tags commands to use tags table file FILE.
FILE should be the name of a file created with the `etags' program.
A directory name is ok too; it means file TAGS in that directory.

Normally \\[visit-tags-table] sets the global value of `tags-file-name'.
With a prefix arg, set the buffer-local value instead.
When you find a tag with \\[find-tag], the buffer it finds the tag
in is given a local value of this variable which is the name of the tags
file the tag was in." t nil)

(autoload (quote tags-table-files) "etags" "\
Return a list of files in the current tags table.
Assumes the tags table is the current buffer.
File names returned are absolute." nil nil)

(autoload (quote find-tag-noselect) "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Returns the buffer containing the tag's definition and moves its point there,
but does not select the buffer.
The default for TAGNAME is the expression in the buffer near point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

See documentation of variable `tags-file-name'." t nil)

(autoload (quote find-tag) "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition, and move point there.
The default for TAGNAME is the expression in the buffer around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

See documentation of variable `tags-file-name'." t nil)
(define-key esc-map "." 'find-tag)

(autoload (quote find-tag-other-window) "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another window, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

See documentation of variable `tags-file-name'." t nil)
(define-key ctl-x-4-map "." 'find-tag-other-window)

(autoload (quote find-tag-other-frame) "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another frame, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

See documentation of variable `tags-file-name'." t nil)
(define-key ctl-x-5-map "." 'find-tag-other-frame)

(autoload (quote find-tag-regexp) "etags" "\
Find tag (in current tags table) whose name matches REGEXP.
Select the buffer containing the tag's definition and move point there.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg OTHER-WINDOW is non-nil, select the buffer in another window.

See documentation of variable `tags-file-name'." t nil)

(autoload (quote next-file) "etags" "\
Select next file among files in current tags table.

A first argument of t (prefix arg, if interactive) initializes to the
beginning of the list of files in the tags table.  If the argument is
neither nil nor t, it is evalled to initialize the list of files.

Non-nil second argument NOVISIT means use a temporary buffer
 to save time and avoid uninteresting warnings.

Value is nil if the file was already visited;
if the file was newly read in, the value is the filename." t nil)

(autoload (quote tags-loop-continue) "etags" "\
Continue last \\[tags-search] or \\[tags-query-replace] command.
Used noninteractively with non-nil argument to begin such a command (the
argument is passed to `next-file', which see).
Two variables control the processing we do on each file:
the value of `tags-loop-scan' is a form to be executed on each file
to see if it is interesting (it returns non-nil if so)
and `tags-loop-operate' is a form to execute to operate on an interesting file
If the latter returns non-nil, we exit; otherwise we scan the next file." t nil)
(define-key esc-map "," 'tags-loop-continue)

(autoload (quote tags-search) "etags" "\
Search through all files listed in tags table for match for REGEXP.
Stops when a match is found.
To continue searching for next match, use command \\[tags-loop-continue].

See documentation of variable `tags-file-name'." t nil)

(autoload (quote tags-query-replace) "etags" "\
Query-replace-regexp FROM with TO through all files listed in tags table.
Third arg DELIMITED (prefix arg) means replace only word-delimited matches.
If you exit (\\[keyboard-quit] or ESC), you can resume the query-replace
with the command \\[tags-loop-continue].

See documentation of variable `tags-file-name'." t nil)

(autoload (quote list-tags) "etags" "\
Display list of tags in file FILE.
FILE should not contain a directory specification." t nil)

(autoload (quote tags-apropos) "etags" "\
Display list of all tags in tags table REGEXP matches." t nil)

(autoload (quote select-tags-table) "etags" "\
Select a tags table file from a menu of those you have already used.
The list of tags tables to select from is stored in `tags-table-file-list';
see the doc of that variable if you want to add names to the list." t nil)

(autoload (quote complete-tag) "etags" "\
Perform tags completion on the text around point.
Completes to the set of names listed in the current tags table.  
The string to complete is chosen in the same way as the default
for \\[find-tag] (which see)." t nil)
(define-key esc-map "\t" 'complete-tag)

;;;***

;;;### (autoloads (find-grep-dired find-name-dired find-dired) "find-dired" "find-dired.el" (11269 25506))
;;; Generated autoloads from find-dired.el

(defvar find-ls-option (if (eq system-type (quote berkeley-unix)) "-ls" "-exec ls -ldi {} \\;") "\
*Option to `find' to produce an `ls -l'-type listing.")

(defvar find-grep-options (if (eq system-type (quote berkeley-unix)) "-s" "-l") "\
*Option to grep to be as silent as possible.
On Berkeley systems, this is `-s', for others it seems impossible to
suppress all output, so `-l' is used to print nothing more than the
file name.")

(autoload (quote find-dired) "find-dired" "\
Run `find' and go into dired-mode on a buffer of the output.
The command run (after changing into DIR) is

    find . \\( ARGS \\) -ls" t nil)

(autoload (quote find-name-dired) "find-dired" "\
Search DIR recursively for files matching the globbing pattern PATTERN,
and run dired on those files.
PATTERN is a shell wildcard (not an Emacs regexp) and need not be quoted.
The command run (after changing into DIR) is

    find . -name 'PATTERN' -ls" t nil)

(autoload (quote find-grep-dired) "find-dired" "\
Find files in DIR containing a regexp ARG and start Dired on output.
The command run (after changing into DIR) is

    find . -exec grep -s ARG {} \\; -ls

Thus ARG can also contain additional grep options." t nil)

;;;***

;;;### (autoloads (enable-flow-control-on enable-flow-control) "flow-ctrl" "flow-ctrl.el" (11288 50957))
;;; Generated autoloads from flow-ctrl.el

(autoload (quote enable-flow-control) "flow-ctrl" "\
Enable use of flow control; let user type C-s as C-\\ and C-q as C-^." t nil)

(autoload (quote enable-flow-control-on) "flow-ctrl" "\
Enable flow control if using one of a specified set of terminal types.
Use `(enable-flow-control-on \"vt100\" \"h19\")' to enable flow control
on VT-100 and H19 terminals.  When flow control is enabled,
you must type C-\\ to get the effect of a C-s, and type C-^
to get the effect of a C-q." nil nil)

;;;***

;;;### (autoloads (font-lock-mode) "font-lock" "font-lock.el" (11361 29125))
;;; Generated autoloads from font-lock.el

(defvar font-lock-mode-hook nil "\
Function or functions to run on entry to Font Lock mode.")

(autoload (quote font-lock-mode) "font-lock" "\
Toggle Font Lock mode.
With arg, turn Font Lock mode on if and only if arg is positive.

When Font Lock mode is enabled, text is fontified as you type it:

 - comments are displayed in `font-lock-comment-face';
     (That is a variable whose value should be a face name.)
 - strings are displayed in `font-lock-string-face';
 - documentation strings are displayed in `font-lock-doc-string-face';
 - function and variable names in their defining forms are displayed
   in `font-lock-function-name-face';
 - and certain other expressions are displayed in other faces
   according to the value of the variable `font-lock-keywords'.

When you turn Font Lock mode on/off, the buffer is fontified/defontified.
To fontify a buffer without having newly typed text become fontified, you
can use \\[font-lock-fontify-buffer]." t nil)

;;;***

;;;### (autoloads (forms-find-file-other-window forms-find-file forms-mode) "forms" "forms.el" (11336 20307))
;;; Generated autoloads from forms.el

(autoload (quote forms-mode) "forms" "\
Major mode to visit files in a field-structured manner using a form.

Commands (prefix with C-c if not in read-only mode):
\\{forms-mode-map}" t nil)

(autoload (quote forms-find-file) "forms" "\
Visit a file in Forms mode." t nil)

(autoload (quote forms-find-file-other-window) "forms" "\
Visit a file in Forms mode in other window." t nil)

;;;***

;;;### (autoloads (fortran-mode) "fortran" "fortran.el" (11285 51227))
;;; Generated autoloads from fortran.el

(defvar fortran-tab-mode-default nil "\
*Default tabbing/carriage control style for empty files in Fortran mode.
A value of t specifies tab-digit style of continuation control.
A value of nil specifies that continuation lines are marked
with a character in column 6.")

(autoload (quote fortran-mode) "fortran" "\
Major mode for editing Fortran code.
\\[fortran-indent-line] indents the current Fortran line correctly. 
DO statements must not share a common CONTINUE.

Type ;? or ;\\[help-command] to display a list of built-in abbrevs for Fortran keywords.

Key definitions:
\\{fortran-mode-map}

Variables controlling indentation style and extra features:

 comment-start
    Normally nil in Fortran mode.  If you want to use comments
    starting with `!', set this to the string \"!\".
 fortran-do-indent
    Extra indentation within do blocks.  (default 3)
 fortran-if-indent
    Extra indentation within if blocks.  (default 3)
 fortran-structure-indent
    Extra indentation within structure, union and map blocks.  (default 3)
 fortran-continuation-indent
    Extra indentation applied to continuation statements.  (default 5)
 fortran-comment-line-extra-indent
    Amount of extra indentation for text within full-line comments. (default 0)
 fortran-comment-indent-style
    nil    means don't change indentation of text in full-line comments,
    fixed  means indent that text at `fortran-comment-line-extra-indent' beyond
           the value of `fortran-minimum-statement-indent-fixed' (for fixed
           format continuation style) or `fortran-minimum-statement-indent-tab'
           (for TAB format continuation style).
    relative  means indent at `fortran-comment-line-extra-indent' beyond the
 	      indentation for a line of code.
    (default 'fixed)
 fortran-comment-indent-char
    Single-character string to be inserted instead of space for
    full-line comment indentation.  (default \" \")
 fortran-minimum-statement-indent-fixed
    Minimum indentation for Fortran statements in fixed format mode. (def.6)
 fortran-minimum-statement-indent-tab
    Minimum indentation for Fortran statements in TAB format mode. (default 9)
 fortran-line-number-indent
    Maximum indentation for line numbers.  A line number will get
    less than this much indentation if necessary to avoid reaching
    column 5.  (default 1)
 fortran-check-all-num-for-matching-do
    Non-nil causes all numbered lines to be treated as possible \"continue\"
    statements.  (default nil)
 fortran-blink-matching-if 
    From a Fortran ENDIF statement, blink the matching IF statement.
    (default nil)
 fortran-continuation-string
    Single-character string to be inserted in column 5 of a continuation
    line.  (default \"$\")
 fortran-comment-region
    String inserted by \\[fortran-comment-region] at start of each line in 
    region.  (default \"c$$$\")
 fortran-electric-line-number
    Non-nil causes line number digits to be moved to the correct column 
    as typed.  (default t)
 fortran-break-before-delimiters
    Non-nil causes `fortran-do-auto-fill' breaks lines before delimiters.
    (default t)
 fortran-startup-message
    Set to nil to inhibit message first time Fortran mode is used.

Turning on Fortran mode calls the value of the variable `fortran-mode-hook'
with no args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (gnus) "gnus" "gnus.el" (11367 8636))
;;; Generated autoloads from gnus.el

(autoload (quote gnus) "gnus" "\
Read network news.
If optional argument CONFIRM is non-nil, ask NNTP server." t nil)

;;;***

;;;### (autoloads (gnus-post-news) "gnuspost" "gnuspost.el" (11339 29602))
;;; Generated autoloads from gnuspost.el

(fset (quote sendnews) (quote gnus-post-news))

(fset (quote postnews) (quote gnus-post-news))

(autoload (quote gnus-post-news) "gnuspost" "\
Begin editing a new USENET news article to be posted.
Type \\[describe-mode] once editing the article to get a list of commands." t nil)

;;;***

;;;### (autoloads (gomoku) "gomoku" "gomoku.el" (11356 11391))
;;; Generated autoloads from gomoku.el

(autoload (quote gomoku) "gomoku" "\
Start a Gomoku game between you and Emacs.
If a game is in progress, this command allow you to resume it.
If optional arguments N and M are given, an N by M board is used.

You and Emacs play in turn by marking a free square.  You mark it with X
and Emacs marks it with O. The winner is the first to get five contiguous
marks horizontally, vertically or in diagonal.

You play by moving the cursor over the square you choose and hitting
\\<gomoku-mode-map>\\[gomoku-human-plays].
Use \\[describe-mode] for more info." t nil)

;;;***

;;;### (autoloads (set-gosmacs-bindings) "gosmacs" "gosmacs.el" (11190 10276))
;;; Generated autoloads from gosmacs.el

(autoload (quote set-gosmacs-bindings) "gosmacs" "\
Rebind some keys globally to make GNU Emacs resemble Gosling Emacs.
Use \\[set-gnu-bindings] to restore previous global bindings." t nil)

;;;***

;;;### (autoloads (perldb xdb dbx sdb gdb) "gud" "gud.el" (11436 59090))
;;; Generated autoloads from gud.el

(autoload (quote gdb) "gud" "\
Run gdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger." t nil)

(autoload (quote sdb) "gud" "\
Run sdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger." t nil)

(autoload (quote dbx) "gud" "\
Run dbx on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger." t nil)

(autoload (quote xdb) "gud" "\
Run xdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

You can set the variable 'gud-xdb-directories' to a list of program source
directories if your program contains sources from more than one directory." t nil)

(autoload (quote perldb) "gud" "\
Run perldb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger." t nil)

;;;***

;;;### (autoloads (hanoi) "hanoi" "hanoi.el" (11324 28709))
;;; Generated autoloads from hanoi.el

(autoload (quote hanoi) "hanoi" "\
Towers of Hanoi diversion.  Argument is number of rings." t nil)

;;;***

;;;### (autoloads (Helper-help Helper-describe-bindings) "helper" "helper.el" (10941 42412))
;;; Generated autoloads from helper.el

(autoload (quote Helper-describe-bindings) "helper" "\
Describe local key bindings of current mode." t nil)

(autoload (quote Helper-help) "helper" "\
Provide help for current mode." t nil)

;;;***

;;;### (autoloads (hexlify-buffer hexl-find-file hexl-mode) "hexl" "hexl.el" (11500 60646))
;;; Generated autoloads from hexl.el

(autoload (quote hexl-mode) "hexl" "\
\\<hexl-mode-map>
A major mode for editing binary files in hex dump format.

This function automatically converts a buffer into the hexl format
using the function `hexlify-buffer'.

Each line in the buffer has an \"address\" (displayed in hexadecimal)
representing the offset into the file that the characters on this line
are at and 16 characters from the file (displayed as hexadecimal
values grouped every 16 bits) and as their ASCII values.

If any of the characters (displayed as ASCII characters) are
unprintable (control or meta characters) they will be replaced as
periods.

If `hexl-mode' is invoked with an argument the buffer is assumed to be
in hexl format.

A sample format:

  HEX ADDR: 0001 0203 0405 0607 0809 0a0b 0c0d 0e0f     ASCII-TEXT
  --------  ---- ---- ---- ---- ---- ---- ---- ----  ----------------
  00000000: 5468 6973 2069 7320 6865 786c 2d6d 6f64  This is hexl-mod
  00000010: 652e 2020 4561 6368 206c 696e 6520 7265  e.  Each line re
  00000020: 7072 6573 656e 7473 2031 3620 6279 7465  presents 16 byte
  00000030: 7320 6173 2068 6578 6164 6563 696d 616c  s as hexadecimal
  00000040: 2041 5343 4949 0a61 6e64 2070 7269 6e74   ASCII.and print
  00000050: 6162 6c65 2041 5343 4949 2063 6861 7261  able ASCII chara
  00000060: 6374 6572 732e 2020 416e 7920 636f 6e74  cters.  Any cont
  00000070: 726f 6c20 6f72 206e 6f6e 2d41 5343 4949  rol or non-ASCII
  00000080: 2063 6861 7261 6374 6572 730a 6172 6520   characters.are 
  00000090: 6469 7370 6c61 7965 6420 6173 2070 6572  displayed as per
  000000a0: 696f 6473 2069 6e20 7468 6520 7072 696e  iods in the prin
  000000b0: 7461 626c 6520 6368 6172 6163 7465 7220  table character 
  000000c0: 7265 6769 6f6e 2e0a                      region..

Movement is as simple as movement in a normal emacs text buffer.  Most
cursor movement bindings are the same (ie. Use \\[hexl-backward-char], \\[hexl-forward-char], \\[hexl-next-line], and \\[hexl-previous-line]
to move the cursor left, right, down, and up).

Advanced cursor movement commands (ala \\[hexl-beginning-of-line], \\[hexl-end-of-line], \\[hexl-beginning-of-buffer], and \\[hexl-end-of-buffer]) are
also supported.

There are several ways to change text in hexl mode:

ASCII characters (character between space (0x20) and tilde (0x7E)) are
bound to self-insert so you can simply type the character and it will
insert itself (actually overstrike) into the buffer.

\\[hexl-quoted-insert] followed by another keystroke allows you to insert the key even if
it isn't bound to self-insert.  An octal number can be supplied in place
of another key to insert the octal number's ASCII representation.

\\[hexl-insert-hex-char] will insert a given hexadecimal value (if it is between 0 and 0xFF)
into the buffer at the current point.

\\[hexl-insert-octal-char] will insert a given octal value (if it is between 0 and 0377)
into the buffer at the current point.

\\[hexl-insert-decimal-char] will insert a given decimal value (if it is between 0 and 255)
into the buffer at the current point.

\\[hexl-mode-exit] will exit hexl-mode.

Note: saving the file with any of the usual Emacs commands
will actually convert it back to binary format while saving.

You can use \\[hexl-find-file] to visit a file in hexl-mode.

\\[describe-bindings] for advanced commands." t nil)

(autoload (quote hexl-find-file) "hexl" "\
Edit file FILENAME in hexl-mode.
Switch to a buffer visiting file FILENAME, creating one in none exists." t nil)

(autoload (quote hexlify-buffer) "hexl" "\
Convert a binary buffer to hexl format" t nil)

;;;***

;;;### (autoloads (hide-ifdef-mode) "hideif" "hideif.el" (11285 51258))
;;; Generated autoloads from hideif.el

(autoload (quote hide-ifdef-mode) "hideif" "\
Toggle Hide-Ifdef mode.  This is a minor mode, albeit a large one.
With ARG, turn Hide-Ifdef mode on iff arg is positive.
In Hide-Ifdef mode, code within #ifdef constructs that the C preprocessor
would eliminate may be hidden from view.  Several variables affect
how the hiding is done:

hide-ifdef-env
	An association list of defined and undefined symbols for the
	current buffer.  Initially, the global value of `hide-ifdef-env'
	is used.

hide-ifdef-define-alist
	An association list of defined symbol lists.  
        Use `hide-ifdef-set-define-alist' to save the current `hide-ifdef-env'
        and `hide-ifdef-use-define-alist' to set the current `hide-ifdef-env'
        from one of the lists in `hide-ifdef-define-alist'.

hide-ifdef-lines
	Set to non-nil to not show #if, #ifdef, #ifndef, #else, and
	#endif lines when hiding.

hide-ifdef-initially
	Indicates whether `hide-ifdefs' should be called when Hide-Ifdef mode
	is activated.

hide-ifdef-read-only
	Set to non-nil if you want to make buffers read only while hiding.
	After `show-ifdefs', read-only status is restored to previous value.

\\{hide-ifdef-mode-map}" t nil)

(defvar hide-ifdef-initially nil "\
*Non-nil if `hide-ifdefs' should be called when Hide-Ifdef mode
is first activated.")

(defvar hide-ifdef-read-only nil "\
*Set to non-nil if you want buffer to be read-only while hiding text.")

(defvar hide-ifdef-lines nil "\
*Set to t if you don't want to see the #ifX, #else, and #endif lines.")

;;;***

;;;### (autoloads (make-hippie-expand-function hippie-expand) "hippie-exp" "hippie-exp.el" (11336 59237))
;;; Generated autoloads from hippie-exp.el

(defvar hippie-expand-try-functions-list (quote (try-complete-file-name try-expand-all-abbrevs try-expand-line try-expand-dabbrev try-expand-dabbrev-all-buffers try-complete-lisp-symbol)) "\
The list of expansion functions tried in order by `hippie-expand'.
To change the behavior of `hippie-expand', remove, change the order of,
or insert functions in this list.")

(defvar hippie-expand-verbose t "\
*Non-nil makes `hippie-expand' output which function it is trying.")

(defvar hippie-expand-max-buffers nil "\
*The maximum number of buffers (apart from the current) searched.
If nil, all buffers are searched.")

(autoload (quote hippie-expand) "hippie-exp" "\
Try to expand text before point, using multiple methods.
The expansion functions in `hippie-expand-try-functions-list' are
tried in order, until a possible expansion is found.  Repeated
application of `hippie-expand' inserts successively possible
expansions.  
With a positive numeric argument, jumps directly to the ARG next
function in this list.  With a negative argument or just \\[universal-argument], 
undoes the expansion." t nil)

(autoload (quote make-hippie-expand-function) "hippie-exp" "\
Construct a function similar to `hippie-expand'.
Make it use the expansion functions in TRY-LIST.  An optional second
argument VERBOSE non-nil makes the function verbose." nil (quote macro))

;;;***

;;;### (autoloads (inferior-lisp) "inf-lisp" "inf-lisp.el" (11294 14427))
;;; Generated autoloads from inf-lisp.el

(defvar inferior-lisp-filter-regexp "\\`\\s *\\(:\\(\\w\\|\\s_\\)\\)?\\s *\\'" "\
*What not to save on inferior Lisp's input history.
Input matching this regexp is not saved on the input history in Inferior Lisp
mode.  Default is whitespace followed by 0 or 1 single-letter colon-keyword 
(as in :a, :c, etc.)")

(defvar inferior-lisp-program "lisp" "\
*Program name for invoking an inferior Lisp with for Inferior Lisp mode.")

(defvar inferior-lisp-load-command "(load \"%s\")\n" "\
*Format-string for building a Lisp expression to load a file.
This format string should use `%s' to substitute a file name
and should result in a Lisp expression that will command the inferior Lisp
to load that file.  The default works acceptably on most Lisps.
The string \"(progn (load \\\"%s\\\" :verbose nil :print t) (values))\\
\"
produces cosmetically superior output for this application,
but it works only in Common Lisp.")

(defvar inferior-lisp-prompt "^[^> ]*>+:? *" "\
Regexp to recognise prompts in the Inferior Lisp mode.
Defaults to \"^[^> ]*>+:? *\", which works pretty good for Lucid, kcl,
and franz.  This variable is used to initialize `comint-prompt-regexp' in the 
Inferior Lisp buffer.

More precise choices:
Lucid Common Lisp: \"^\\(>\\|\\(->\\)+\\) *\"
franz: \"^\\(->\\|<[0-9]*>:\\) *\"
kcl: \"^>+ *\"

This is a fine thing to set in your .emacs file.")

(defvar inferior-lisp-mode-hook (quote nil) "\
*Hook for customising Inferior Lisp mode.")

(autoload (quote inferior-lisp) "inf-lisp" "\
Run an inferior Lisp process, input and output via buffer `*inferior-lisp*'.
If there is a process already running in `*inferior-lisp*', just switch
to that buffer.
With argument, allows you to edit the command line (default is value
of `inferior-lisp-program').  Runs the hooks from
`inferior-lisp-mode-hook' (after the `comint-mode-hook' is run).
(Type \\[describe-mode] in the process buffer for a list of commands.)" t nil)

(defalias (quote run-lisp) (quote inferior-lisp))

;;;***

;;;### (autoloads (Info-goto-emacs-key-command-node Info-goto-emacs-command-node info-standalone info) "info" "info.el" (11362 48870))
;;; Generated autoloads from info.el

(autoload (quote info) "info" "\
Enter Info, the documentation browser.
Optional argument FILE specifies the file to examine;
the default is the top-level directory of Info.

In interactive use, a prefix argument directs this command
to read a file name from the minibuffer." t nil)

(autoload (quote info-standalone) "info" "\
Run Emacs as a standalone Info reader.
Usage:  emacs -f info-standalone [filename]
In standalone mode, \\<Info-mode-map>\\[Info-exit] exits Emacs itself." nil nil)

(autoload (quote Info-goto-emacs-command-node) "info" "\
Go to the Info node in the Emacs manual for command COMMAND.
The command is found by looking up in Emacs manual's Command Index." t nil)

(autoload (quote Info-goto-emacs-key-command-node) "info" "\
Go to the Info node in the Emacs manual the command bound to KEY, a string.
Interactively, if the binding is execute-extended-command, a command is read.
The command is found by looking up in Emacs manual's Command Index." t nil)

;;;***

;;;### (autoloads (batch-info-validate Info-validate Info-split Info-tagify) "informat" "informat.el" (11136 13191))
;;; Generated autoloads from informat.el

(autoload (quote Info-tagify) "informat" "\
Create or update Info-file tag table in current buffer." t nil)

(autoload (quote Info-split) "informat" "\
Split an info file into an indirect file plus bounded-size subfiles.
Each subfile will be up to 50,000 characters plus one node.

To use this command, first visit a large Info file that has a tag
table.  The buffer is modified into a (small) indirect info file which
should be saved in place of the original visited file.

The subfiles are written in the same directory the original file is
in, with names generated by appending `-' and a number to the original
file name.  The indirect file still functions as an Info file, but it
contains just the tag table and a directory of subfiles." t nil)

(autoload (quote Info-validate) "informat" "\
Check current buffer for validity as an Info file.
Check that every node pointer points to an existing node." t nil)

(autoload (quote batch-info-validate) "informat" "\
Runs `Info-validate' on the files remaining on the command line.
Must be used only with -batch, and kills Emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-info-validate $info/ ~/*.info\"" nil nil)

;;;***

;;;### (autoloads (iso-accents-mode) "iso-acc" "iso-acc.el" (11467 25993))
;;; Generated autoloads from iso-acc.el

(autoload (quote iso-accents-mode) "iso-acc" "\
Toggle a minor mode in which accents modify the following letter.
This permits easy insertion of accented characters according to ISO-8859-1.
When Iso-accents mode is enabled, accent character keys
(', \", ^ and ~) do not self-insert; instead, they modify the following
letter key so that it inserts an ISO accented letter.

With an argument, a positive argument enables ISO-accents mode, 
and a negative argument disables it." t nil)

;;;***

;;;### (autoloads (ispell-message ispell-complete-word-interior-frag ispell-complete-word ispell-region ispell-word ispell) "ispell" "ispell.el" (11485 39692))
;;; Generated autoloads from ispell.el

(autoload (quote ispell) "ispell" "\
Run Ispell over current buffer's visited file.
First the file is scanned for misspelled words, then Ispell
enters a loop with the following commands for every misspelled word:

DIGIT	Near miss selector.  If the misspelled word is close to
	some words in the dictionary, they are offered as near misses.
r	Replace.  Replace the word with a string you type.  Each word
	of your new string is also checked.
i	Insert.  Insert this word in your private dictionary (kept in
	`$HOME/ispell.words').
a	Accept.  Accept this word for the rest of this editing session,
 	but don't put it in your private dictionary.
l	Lookup.  Look for a word in the dictionary by fast binary
	search, or search for a regular expression in the dictionary
	using grep.
SPACE	Accept the word this time, but complain if it is seen again.
q, \\[keyboard-quit]	Leave the command loop.  You can come back later with \\[ispell-next]." t nil)

(defalias (quote ispell-buffer) (quote ispell))

(autoload (quote ispell-word) "ispell" "\
Check the spelling of the word under the cursor.
See the command `ispell' for more information.
With a prefix argument, resume handling of the previous Ispell command." t nil)

(define-key esc-map "$" (quote ispell-word))

(autoload (quote ispell-region) "ispell" "\
Check the spelling for all of the words in the region." t nil)

(autoload (quote ispell-complete-word) "ispell" "\
Complete word using letters at point to word beginning using `look'.
With optional argument INTERIOR-FRAG, word fragment at point is assumed to be
an interior word fragment in which case `ispell-have-new-look' should be t.
See also `ispell-look-dictionary' and `ispell-gnu-look-still-broken-p'." t nil)

(autoload (quote ispell-complete-word-interior-frag) "ispell" "\
Runs `ispell-complete-word' with a non-nil INTERIOR-FRAG.
A completion list is built for word fragment at point which is assumed to be
an interior word fragment.  `ispell-have-new-look' should be t." t nil)

(autoload (quote ispell-message) "ispell" "\
Check the spelling of a mail message or news post.
Don't check spelling of message headers or included messages.

To spell-check whenever a message is sent, include this line in .emacs:
   (setq news-inews-hook (setq mail-send-hook 'ispell-message))

Or you can bind the function to C-c i in gnus or mail with:
   (setq mail-mode-hook (setq news-reply-mode-hook
    (function (lambda () (local-set-key \"\\C-ci\" 'ispell-message)))))" t nil)

;;;***

;;;### (autoloads (ledit-from-lisp-mode ledit-mode) "ledit" "ledit.el" (11181 53296))
;;; Generated autoloads from ledit.el

(defconst ledit-save-files t "\
*Non-nil means Ledit should save files before transferring to Lisp.")

(defconst ledit-go-to-lisp-string "%?lisp" "\
*Shell commands to execute to resume Lisp job.")

(defconst ledit-go-to-liszt-string "%?liszt" "\
*Shell commands to execute to resume Lisp compiler job.")

(autoload (quote ledit-mode) "ledit" "\
\\<ledit-mode-map>Major mode for editing text and stuffing it to a Lisp job.
Like Lisp mode, plus these special commands:
  \\[ledit-save-defun]	-- record defun at or after point
	   for later transmission to Lisp job.
  \\[ledit-save-region] -- record region for later transmission to Lisp job.
  \\[ledit-go-to-lisp] -- transfer to Lisp job and transmit saved text.
  \\[ledit-go-to-liszt] -- transfer to Liszt (Lisp compiler) job
	   and transmit saved text.
\\{ledit-mode-map}
To make Lisp mode automatically change to Ledit mode,
do (setq lisp-mode-hook 'ledit-from-lisp-mode)" t nil)

(autoload (quote ledit-from-lisp-mode) "ledit" nil nil nil)

;;;***

;;;### (autoloads (life) "life" "life.el" (11356 11391))
;;; Generated autoloads from life.el

(autoload (quote life) "life" "\
Run Conway's Life simulation.
The starting pattern is randomly selected.  Prefix arg (optional first
arg non-nil from a program) is the number of seconds to sleep between
generations (this defaults to 1)." t nil)

;;;***

;;;### (autoloads (unload-feature) "loadhist" "loadhist.el" (11215 17597))
;;; Generated autoloads from loadhist.el

(autoload (quote unload-feature) "loadhist" "\
Unload the library that provided FEATURE, restoring all its autoloads.
If the feature is required by any other loaded code, and optional FORCE
is nil, raise an error." t nil)

;;;***

;;;### (autoloads (print-region lpr-region print-buffer lpr-buffer) "lpr" "lpr.el" (11359 12171))
;;; Generated autoloads from lpr.el

(defvar lpr-switches nil "\
*List of strings to pass as extra switch args to lpr when it is invoked.")

(defvar lpr-command (if (memq system-type (quote (usg-unix-v dgux-unix hpux irix))) "lp" "lpr") "\
*Shell command for printing a file")

(autoload (quote lpr-buffer) "lpr" "\
Print buffer contents as with Unix command `lpr'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload (quote print-buffer) "lpr" "\
Print buffer contents as with Unix command `lpr -p'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload (quote lpr-region) "lpr" "\
Print region contents as with Unix command `lpr'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

(autoload (quote print-region) "lpr" "\
Print region contents as with Unix command `lpr -p'.
`lpr-switches' is a list of extra switches (strings) to pass to lpr." t nil)

;;;***

;;;### (autoloads (phases-of-moon) "lunar" "lunar.el" (11367 8268))
;;; Generated autoloads from lunar.el

(autoload (quote phases-of-moon) "lunar" "\
Display the quarters of the moon for last month, this month, and next month.
If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file." t nil)

;;;***

;;;### (autoloads (apply-macro-to-region-lines kbd-macro-query insert-kbd-macro name-last-kbd-macro) "macros" "macros.el" (11351 17266))
;;; Generated autoloads from macros.el

(autoload (quote name-last-kbd-macro) "macros" "\
Assign a name to the last keyboard macro defined.
Argument SYMBOL is the name to define.
The symbol's function definition becomes the keyboard macro string.
Such a \"function\" cannot be called from Lisp, but it is a valid editor command." t nil)

(autoload (quote insert-kbd-macro) "macros" "\
Insert in buffer the definition of kbd macro NAME, as Lisp code.
Optional second arg KEYS means also record the keys it is on
(this is the prefix argument, when calling interactively).

This Lisp code will, when executed, define the kbd macro with the same
definition it has now.  If you say to record the keys, the Lisp code
will also rebind those keys to the macro.  Only global key bindings
are recorded since executing this Lisp code always makes global
bindings.

To save a kbd macro, visit a file of Lisp code such as your `~/.emacs',
use this command, and then save the file." t nil)

(autoload (quote kbd-macro-query) "macros" "\
Query user during kbd macro execution.
  With prefix argument, enters recursive edit, reading keyboard
commands even within a kbd macro.  You can give different commands
each time the macro executes.
  Without prefix argument, asks whether to continue running the macro.
Your options are: \\<query-replace-map>
\\[act]	Finish this iteration normally and continue with the next.
\\[skip]	Skip the rest of this iteration, and start the next.
\\[exit]	Stop the macro entirely right now.
\\[recenter]	Redisplay the screen, then ask again.
\\[edit]	Enter recursive edit; ask again when you exit from that." t nil)

(autoload (quote apply-macro-to-region-lines) "macros" "\
For each complete line between point and mark, move to the beginning
of the line, and run the last keyboard macro.

When called from lisp, this function takes two arguments TOP and
BOTTOM, describing the current region.  TOP must be before BOTTOM.
The optional third argument MACRO specifies a keyboard macro to
execute.

This is useful for quoting or unquoting included text, adding and
removing comments, or producing tables where the entries are regular.

For example, in Usenet articles, sections of text quoted from another
author are indented, or have each line start with `>'.  To quote a
section of text, define a keyboard macro which inserts `>', put point
and mark at opposite ends of the quoted section, and use
`\\[apply-macro-to-region-lines]' to mark the entire section.

Suppose you wanted to build a keyword table in C where each entry
looked like this:

    { \"foo\", foo_data, foo_function }, 
    { \"bar\", bar_data, bar_function },
    { \"baz\", baz_data, baz_function },

You could enter the names in this format:

    foo
    bar
    baz

and write a macro to massage a word into a table entry:

    \\C-x (
       \\M-d { \"\\C-y\", \\C-y_data, \\C-y_function },
    \\C-x )

and then select the region of un-tablified names and use
`\\[apply-macro-to-region-lines]' to build the table from the names.
" t nil)

(define-key ctl-x-map "q" (quote kbd-macro-query))

;;;***

;;;### (autoloads nil "mail-utils" "mail-utils.el" (11323 3305))
;;; Generated autoloads from mail-utils.el

(defvar mail-use-rfc822 nil "\
*If non-nil, use a full, hairy RFC822 parser on mail addresses.
Otherwise, (the default) use a smaller, somewhat faster, and
often correct parser.")

;;;***

;;;### (autoloads (define-mail-abbrev build-mail-abbrevs mail-abbrevs-setup) "mailabbrev" "mailabbrev.el" (11349 45422))
;;; Generated autoloads from mailabbrev.el

(autoload (quote mail-abbrevs-setup) "mailabbrev" nil nil nil)

(autoload (quote build-mail-abbrevs) "mailabbrev" "\
Read mail aliases from `~/.mailrc' file and set `mail-abbrevs'." nil nil)

(autoload (quote define-mail-abbrev) "mailabbrev" "\
Define NAME as a mail-abbrev that translates to DEFINITION.
If DEFINITION contains multiple addresses, separate them with commas." t nil)

;;;***

;;;### (autoloads (define-mail-alias) "mailalias" "mailalias.el" (11294 13866))
;;; Generated autoloads from mailalias.el

(autoload (quote define-mail-alias) "mailalias" "\
Define NAME as a mail alias that translates to DEFINITION.
This means that sending a message to NAME will actually send to DEFINITION.
DEFINITION can be one or more mail addresses separated by commas." t nil)

;;;***

;;;### (autoloads (makefile-mode) "makefile" "makefile.el" (11285 53103))
;;; Generated autoloads from makefile.el

(autoload (quote makefile-mode) "makefile" "\
Major mode for editing Makefiles.
Calling this function invokes the function(s) \"makefile-mode-hook\" before
doing anything else.

\\{makefile-mode-map}

In the browser, use the following keys:

\\{makefile-browser-map}

makefile-mode can be configured by modifying the following
variables:

makefile-mode-name:
    The \"pretty name\" of makefile-mode, as it
    appears in the modeline.

makefile-browser-buffer-name:
    Name of the macro- and target browser buffer.

makefile-target-colon:
    The string that gets appended to all target names
    inserted by makefile-insert-target.
    \":\" or \"::\" are quite common values.

makefile-macro-assign:
   The string that gets appended to all macro names
   inserted by makefile-insert-macro.
   The normal value should be \" = \", since this is what
   standard make expects. However, newer makes such as dmake
   allow a larger variety of different macro assignments, so you
   might prefer to use \" += \" or \" := \" .

makefile-tab-after-target-colon:
   If you want a TAB (instead of a space) to be appended after the
   target colon, then set this to a non-nil value.

makefile-browser-leftmost-column:
   Number of blanks to the left of the browser selection mark.

makefile-browser-cursor-column:
   Column in which the cursor is positioned when it moves
   up or down in the browser.

makefile-browser-selected-mark:
   String used to mark selected entries in the browser.

makefile-browser-unselected-mark:
   String used to mark unselected entries in the browser.

makefile-browser-auto-advance-after-selection-p:
   If this variable is set to a non-nil value the cursor
   will automagically advance to the next line after an item
   has been selected in the browser.

makefile-pickup-everything-picks-up-filenames-p:
   If this variable is set to a non-nil value then
   makefile-pickup-everything also picks up filenames as targets
   (i.e. it calls makefile-find-filenames-as-targets), otherwise
   filenames are omitted.

makefile-cleanup-continuations-p:
   If this variable is set to a non-nil value then makefile-mode
   will assure that no line in the file ends with a backslash
   (the continuation character) followed by any whitespace.
   This is done by silently removing the trailing whitespace, leaving
   the backslash itself intact.
   IMPORTANT: Please note that enabling this option causes makefile-mode
   to MODIFY A FILE WITHOUT YOUR CONFIRMATION when 'it seems necessary'.

makefile-browser-hook:
   A function or list of functions to be called just before the
   browser is entered. This is executed in the makefile buffer.

makefile-special-targets-list:
   List of special targets. You will be offered to complete
   on one of those in the minibuffer whenever you enter a \".\"
   at the beginning of a line in makefile-mode." t nil)

;;;***

;;;### (autoloads (make-command-summary) "makesum" "makesum.el" (11181 53304))
;;; Generated autoloads from makesum.el

(autoload (quote make-command-summary) "makesum" "\
Make a summary of current key bindings in the buffer *Summary*.
Previous contents of that buffer are killed first." t nil)

;;;***

;;;### (autoloads (manual-entry) "man" "man.el" (11358 46030))
;;; Generated autoloads from man.el

(defalias (quote man) (quote manual-entry))

(autoload (quote manual-entry) "man" "\
Get a Un*x manual page and put it in a buffer.
This command is the top-level command in the man package.  It runs a Un*x
command to retrieve and clean a manpage in the background and places the
results in a Man mode (manpage browsing) buffer.  See variable
`Man-notify' for what happens when the buffer is ready.
Universal argument ARG, is passed to `Man-getpage-in-background'." t nil)

;;;***

;;;### (autoloads (map-y-or-n-p) "map-ynp" "map-ynp.el" (11449 65482))
;;; Generated autoloads from map-ynp.el

(autoload (quote map-y-or-n-p) "map-ynp" "\
Ask a series of boolean questions.
Takes args PROMPTER ACTOR LIST, and optional args HELP and ACTION-ALIST.

LIST is a list of objects, or a function of no arguments to return the next
object or nil.

If PROMPTER is a string, the prompt is (format PROMPTER OBJECT).  If not
a string, PROMPTER is a function of one arg (an object from LIST), which
returns a string to be used as the prompt for that object.  If the return
value is not a string, it is eval'd to get the answer; it may be nil to
ignore the object, t to act on the object without asking the user, or a
form to do a more complex prompt.

ACTOR is a function of one arg (an object from LIST),
which gets called with each object that the user answers `yes' for.

If HELP is given, it is a list (OBJECT OBJECTS ACTION),
where OBJECT is a string giving the singular noun for an elt of LIST;
OBJECTS is the plural noun for elts of LIST, and ACTION is a transitive
verb describing ACTOR.  The default is (\"object\" \"objects\" \"act on\").

At the prompts, the user may enter y, Y, or SPC to act on that object;
n, N, or DEL to skip that object; ! to act on all following objects;
ESC or q to exit (skip all following objects); . (period) to act on the
current object and then exit; or \\[help-command] to get help.

If ACTION-ALIST is given, it is an alist (KEY FUNCTION HELP) of extra keys
that will be accepted.  KEY is a character; FUNCTION is a function of one
arg (an object from LIST); HELP is a string.  When the user hits KEY,
FUNCTION is called.  If it returns non-nil, the object is considered
\"acted upon\", and the next object from LIST is processed.  If it returns
nil, the prompt is repeated for the same object.

Final optional argument NO-CURSOR-IN-ECHO-AREA non-nil says not to set
`cursor-in-echo-area' while prompting.

This function uses `query-replace-map' to define the standard responses,
but not all of the responses which `query-replace' understands
are meaningful here.

Returns the number of actions taken." nil nil)

;;;***

;;;### (autoloads (mh-smail mh-rmail) "mh-e" "mh-e.el" (11365 38303))
;;; Generated autoloads from mh-e.el

(autoload (quote mh-rmail) "mh-e" "\
Inc(orporate) new mail (no arg) or scan a MH mail box (arg given).
This front end uses the MH mail system, which uses different conventions
from the usual mail system." t nil)

(autoload (quote mh-smail) "mh-e" "\
Compose and send mail with the MH mail system." t nil)

;;;***

;;;### (autoloads (convert-mocklisp-buffer) "mlconvert" "mlconvert.el" (11339 6975))
;;; Generated autoloads from mlconvert.el

(autoload (quote convert-mocklisp-buffer) "mlconvert" "\
Convert buffer of Mocklisp code to real Lisp that GNU Emacs can run." t nil)

;;;***

;;;### (autoloads (modula-2-mode) "modula2" "modula2.el" (11181 53306))
;;; Generated autoloads from modula2.el

(autoload (quote modula-2-mode) "modula2" "\
This is a mode intended to support program development in Modula-2.
All control constructs of Modula-2 can be reached by typing C-c
followed by the first character of the construct.
\\<m2-mode-map>
  \\[m2-begin] begin         \\[m2-case] case
  \\[m2-definition] definition    \\[m2-else] else
  \\[m2-for] for           \\[m2-header] header
  \\[m2-if] if            \\[m2-module] module
  \\[m2-loop] loop          \\[m2-or] or
  \\[m2-procedure] procedure     Control-c Control-w with
  \\[m2-record] record        \\[m2-stdio] stdio
  \\[m2-type] type          \\[m2-until] until
  \\[m2-var] var           \\[m2-while] while
  \\[m2-export] export        \\[m2-import] import
  \\[m2-begin-comment] begin-comment \\[m2-end-comment] end-comment
  \\[suspend-emacs] suspend Emacs     \\[m2-toggle] toggle
  \\[m2-compile] compile           \\[m2-next-error] next-error
  \\[m2-link] link

   `m2-indent' controls the number of spaces for each indentation.
   `m2-compile-command' holds the command to compile a Modula-2 program.
   `m2-link-command' holds the command to link a Modula-2 program." t nil)

;;;***

;;;### (autoloads (mpuz) "mpuz" "mpuz.el" (11356 11391))
;;; Generated autoloads from mpuz.el

(autoload (quote mpuz) "mpuz" "\
Multiplication puzzle with GNU Emacs." t nil)

;;;***

;;;### (autoloads (disable-command enable-command disabled-command-hook) "novice" "novice.el" (11261 24403))
;;; Generated autoloads from novice.el

(setq disabled-command-hook (quote disabled-command-hook))

(autoload (quote disabled-command-hook) "novice" nil nil nil)

(autoload (quote enable-command) "novice" "\
Allow COMMAND to be executed without special confirmation from now on.
The user's .emacs file is altered so that this will apply
to future sessions." t nil)

(autoload (quote disable-command) "novice" "\
Require special confirmation to execute COMMAND from now on.
The user's .emacs file is altered so that this will apply
to future sessions." t nil)

;;;***

;;;### (autoloads (nroff-mode) "nroff-mode" "nroff-mode.el" (11267 60509))
;;; Generated autoloads from nroff-mode.el

(autoload (quote nroff-mode) "nroff-mode" "\
Major mode for editing text intended for nroff to format.
\\{nroff-mode-map}
Turning on Nroff mode runs `text-mode-hook', then `nroff-mode-hook'.
Also, try `nroff-electric-mode', for automatically inserting
closing requests for requests that are used in matched pairs." t nil)

;;;***

;;;### (autoloads (edit-options list-options) "options" "options.el" (11181 53232))
;;; Generated autoloads from options.el

(autoload (quote list-options) "options" "\
Display a list of Emacs user options, with values and documentation." t nil)

(autoload (quote edit-options) "options" "\
Edit a list of Emacs user option values.
Selects a buffer containing such a list,
in which there are commands to set the option values.
Type \\[describe-mode] in that buffer for a list of commands." t nil)

;;;***

;;;### (autoloads (outline-minor-mode outline-mode) "outline" "outline.el" (11340 12742))
;;; Generated autoloads from outline.el

(autoload (quote outline-mode) "outline" "\
Set major mode for editing outlines with selective display.
Headings are lines which start with asterisks: one for major headings,
two for subheadings, etc.  Lines not starting with asterisks are body lines. 

Body text or subheadings under a heading can be made temporarily
invisible, or visible again.  Invisible lines are attached to the end 
of the heading, so they move with it, if the line is killed and yanked
back.  A heading with text hidden under it is marked with an ellipsis (...).

Commands:\\<outline-mode-map>
\\[outline-next-visible-heading]   outline-next-visible-heading      move by visible headings
\\[outline-previous-visible-heading]   outline-previous-visible-heading
\\[outline-forward-same-level]   outline-forward-same-level        similar but skip subheadings
\\[outline-backward-same-level]   outline-backward-same-level
\\[outline-up-heading]   outline-up-heading		    move from subheading to heading

M-x hide-body	make all text invisible (not headings).
M-x show-all	make everything in buffer visible.

The remaining commands are used when point is on a heading line.
They apply to some of the body or subheadings of that heading.
\\[hide-subtree]   hide-subtree	make body and subheadings invisible.
\\[show-subtree]   show-subtree	make body and subheadings visible.
\\[show-children]   show-children	make direct subheadings visible.
		 No effect on body, or subheadings 2 or more levels down.
		 With arg N, affects subheadings N levels down.
M-x hide-entry	   make immediately following body invisible.
M-x show-entry	   make it visible.
M-x hide-leaves	   make body under heading and under its subheadings invisible.
		     The subheadings remain visible.
M-x show-branches  make all subheadings at all levels visible.

The variable `outline-regexp' can be changed to control what is a heading.
A line is a heading if `outline-regexp' matches something at the
beginning of the line.  The longer the match, the deeper the level.

Turning on outline mode calls the value of `text-mode-hook' and then of
`outline-mode-hook', if they are non-nil." t nil)

(autoload (quote outline-minor-mode) "outline" "\
Toggle Outline minor mode.
With arg, turn Outline minor mode on if arg is positive, off otherwise.
See the command `outline-mode' for more information on this mode." t nil)

;;;***

;;;### (autoloads (perl-mode) "perl-mode" "perl-mode.el" (11360 25587))
;;; Generated autoloads from perl-mode.el

(autoload (quote perl-mode) "perl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all Perl brackets.
Tab indents for Perl code.
Comments are delimited with # ... \\n.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{perl-mode-map}
Variables controlling indentation style:
 perl-tab-always-indent
    Non-nil means TAB in Perl mode should always indent the current line,
    regardless of where in the line point is when the TAB command is used.
 perl-tab-to-comment
    Non-nil means that for lines which don't need indenting, TAB will
    either delete an empty comment, indent an existing comment, move 
    to end-of-line, or if at end-of-line already, create a new comment.
 perl-nochange
    Lines starting with this regular expression will not be auto-indented.
 perl-indent-level
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 perl-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 perl-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to perl-continued-statement-offset.
 perl-brace-offset
    Extra indentation for line if it starts with an open brace.
 perl-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 perl-label-offset
    Extra indentation for line that is a label.

Various indentation styles:       K&R  BSD  BLK  GNU  LW
  perl-indent-level                5    8    0    2    4
  perl-continued-statement-offset  5    8    4    2    4
  perl-continued-brace-offset      0    0    0    0   -4
  perl-brace-offset               -5   -8    0    0    0
  perl-brace-imaginary-offset      0    0    4    0    0
  perl-label-offset               -5   -8   -2   -2   -2

Turning on Perl mode calls the value of the variable perl-mode-hook with no 
args, if that value is non-nil." t nil)

;;;***

;;;### (autoloads (picture-mode) "picture" "picture.el" (11292 51488))
;;; Generated autoloads from picture.el

(autoload (quote picture-mode) "picture" "\
Switch to Picture mode, in which a quarter-plane screen model is used.
Printing characters replace instead of inserting themselves with motion
afterwards settable by these commands:
  C-c <	  Move left after insertion.
  C-c >	  Move right after insertion.
  C-c ^	  Move up after insertion.
  C-c .	  Move down after insertion.
  C-c `	  Move northwest (nw) after insertion.
  C-c '	  Move northeast (ne) after insertion.
  C-c /	  Move southwest (sw) after insertion.
  C-c \\   Move southeast (se) after insertion.
The current direction is displayed in the mode line.  The initial
direction is right.  Whitespace is inserted and tabs are changed to
spaces when required by movement.  You can move around in the buffer
with these commands:
  \\[picture-move-down]	  Move vertically to SAME column in previous line.
  \\[picture-move-up]	  Move vertically to SAME column in next line.
  \\[picture-end-of-line]	  Move to column following last non-whitespace character.
  \\[picture-forward-column]	  Move right inserting spaces if required.
  \\[picture-backward-column]	  Move left changing tabs to spaces if required.
  C-c C-f Move in direction of current picture motion.
  C-c C-b Move in opposite direction of current picture motion.
  Return  Move to beginning of next line.
You can edit tabular text with these commands:
  M-Tab	  Move to column beneath (or at) next interesting character.
	    `Indents' relative to a previous line.
  Tab	  Move to next stop in tab stop list.
  C-c Tab Set tab stops according to context of this line.
	    With ARG resets tab stops to default (global) value.
	    See also documentation of variable	picture-tab-chars
	    which defines \"interesting character\".  You can manually
	    change the tab stop list with command \\[edit-tab-stops].
You can manipulate text with these commands:
  C-d	  Clear (replace) ARG columns after point without moving.
  C-c C-d Delete char at point - the command normally assigned to C-d.
  \\[picture-backward-clear-column]  Clear (replace) ARG columns before point, moving back over them.
  \\[picture-clear-line]	  Clear ARG lines, advancing over them.	 The cleared
	    text is saved in the kill ring.
  \\[picture-open-line]	  Open blank line(s) beneath current line.
You can manipulate rectangles with these commands:
  C-c C-k Clear (or kill) a rectangle and save it.
  C-c C-w Like C-c C-k except rectangle is saved in named register.
  C-c C-y Overlay (or insert) currently saved rectangle at point.
  C-c C-x Like C-c C-y except rectangle is taken from named register.
  \\[copy-rectangle-to-register]   Copies a rectangle to a register.
  \\[advertised-undo]   Can undo effects of rectangle overlay commands
	    commands if invoked soon enough.
You can return to the previous mode with:
  C-c C-c Which also strips trailing whitespace from every line.
	    Stripping is suppressed by supplying an argument.

Entry to this mode calls the value of  picture-mode-hook  if non-nil.

Note that Picture mode commands will work outside of Picture mode, but
they are not defaultly assigned to keys." t nil)

(defalias (quote edit-picture) (quote picture-mode))

;;;***

;;;### (autoloads (run-prolog prolog-mode) "prolog" "prolog.el" (11181 53308))
;;; Generated autoloads from prolog.el

(autoload (quote prolog-mode) "prolog" "\
Major mode for editing Prolog code for Prologs.
Blank lines and `%%...' separate paragraphs.  `%'s start comments.
Commands:
\\{prolog-mode-map}
Entry to this mode calls the value of `prolog-mode-hook'
if that value is non-nil." t nil)

(autoload (quote run-prolog) "prolog" "\
Run an inferior Prolog process, input and output via buffer *prolog*." t nil)

;;;***

;;;### (autoloads (clear-rectangle string-rectangle open-rectangle insert-rectangle yank-rectangle kill-rectangle extract-rectangle delete-extract-rectangle delete-rectangle) "rect" "rect.el" (11237 13138))
;;; Generated autoloads from rect.el

(autoload (quote delete-rectangle) "rect" "\
Delete (don't save) text in rectangle with point and mark as corners.
The same range of columns is deleted in each line starting with the line
where the region begins and ending with the line where the region ends." t nil)

(autoload (quote delete-extract-rectangle) "rect" "\
Delete contents of rectangle and return it as a list of strings.
Arguments START and END are the corners of the rectangle.
The value is list of strings, one for each line of the rectangle." nil nil)

(autoload (quote extract-rectangle) "rect" "\
Return contents of rectangle with corners at START and END.
Value is list of strings, one for each line of the rectangle." nil nil)

(autoload (quote kill-rectangle) "rect" "\
Delete rectangle with corners at point and mark; save as last killed one.
Calling from program, supply two args START and END, buffer positions.
But in programs you might prefer to use `delete-extract-rectangle'." t nil)

(autoload (quote yank-rectangle) "rect" "\
Yank the last killed rectangle with upper left corner at point." t nil)

(autoload (quote insert-rectangle) "rect" "\
Insert text of RECTANGLE with upper left corner at point.
RECTANGLE's first line is inserted at point, its second
line is inserted at a point vertically under point, etc.
RECTANGLE should be a list of strings.
After this command, the mark is at the upper left corner
and point is at the lower right corner." nil nil)

(autoload (quote open-rectangle) "rect" "\
Blank out rectangle with corners at point and mark, shifting text right.
The text previously in the region is not overwritten by the blanks,
but instead winds up to the right of the rectangle." t nil)

(autoload (quote string-rectangle) "rect" "\
Insert STRING on each line of the region-rectangle, shifting text right.
The left edge of the rectangle specifies the column for insertion.
This command does not delete or overwrite any existing text.

Called from a program, takes three args; START, END and STRING." t nil)

(autoload (quote clear-rectangle) "rect" "\
Blank out rectangle with corners at point and mark.
The text previously in the region is overwritten by the blanks.
When called from a program, requires two args which specify the corners." t nil)

;;;***

;;;### (autoloads (reposition-window) "reposition" "reposition.el" (11339 34632))
;;; Generated autoloads from reposition.el

(autoload (quote reposition-window) "reposition" "\
Make the current definition and/or comment visible.
Further invocations move it to the top of the window or toggle the
visibility of comments that precede it.
  Point is left unchanged unless prefix ARG is supplied.
  If the definition is fully onscreen, it is moved to the top of the
window.  If it is partly offscreen, the window is scrolled to get the
definition (or as much as will fit) onscreen, unless point is in a comment
which is also partly offscreen, in which case the scrolling attempts to get
as much of the comment onscreen as possible.
  Initially `reposition-window' attempts to make both the definition and
preceding comments visible.  Further invocations toggle the visibility of
the comment lines.
  If ARG is non-nil, point may move in order to make the whole defun
visible (if only part could otherwise be made so), to make the defun line
visible (if point is in code and it could not be made so, or if only
comments, including the first comment line, are visible), or to make the
first comment line visible (if point is in a comment)." t nil)

(define-key esc-map "" (quote reposition-window))

;;;***

;;;### (autoloads (resume-suspend-hook) "resume" "resume.el" (11236 37830))
;;; Generated autoloads from resume.el

(autoload (quote resume-suspend-hook) "resume" "\
Clear out the file used for transmitting args when Emacs resumes." nil nil)

;;;***

;;;### (autoloads (make-ring ring-p) "ring" "ring.el" (11367 8270))
;;; Generated autoloads from ring.el

(autoload (quote ring-p) "ring" "\
Returns t if X is a ring; nil otherwise." nil nil)

(autoload (quote make-ring) "ring" "\
Make a ring that can contain SIZE elements." nil nil)

;;;***

;;;### (autoloads (rlogin-delchar-or-send-Ctrl-D rlogin-send-Ctrl-backslash rlogin-send-Ctrl-Z rlogin-send-Ctrl-C rlogin-mode rlogin-password rlogin-with-args rlogin) "rlogin" "rlogin.el" (11261 49048))
;;; Generated autoloads from rlogin.el

(defvar rlogin-program "rlogin" "\
*Name of program to invoke rlogin")

(defvar rlogin-explicit-args nil "\
*List of arguments to pass to rlogin on the command line.")

(defvar rlogin-mode-hook nil "\
*Hooks to run after setting current buffer to rlogin-mode.")

(defvar rlogin-process-connection-type nil "\
*If non-`nil', use a pty for the local rlogin process.  
If `nil', use a pipe (if pipes are supported on the local system).  

Generally it is better not to waste ptys on systems which have a static
number of them.  On the other hand, some implementations of `rlogin' assume
a pty is being used, and errors will result from using a pipe instead.")

(defvar rlogin-password-paranoia nil "\
*If non-`nil', query user for a password in the minibuffer when a Password: prompt appears.
It's also possible to selectively enter passwords without echoing them in
the minibuffer using the command `rlogin-password' explicitly.")

(defvar rlogin-mode-map (quote nil))

(autoload (quote rlogin) "rlogin" "\
Open a network login connection to HOST via the `rlogin' program.
Input is sent line-at-a-time to the remote connection.

Communication with HOST is recorded in a buffer *rlogin-HOST*.
If a prefix argument is given and the buffer *rlogin-HOST* already exists,
a new buffer with a different connection will be made. 

The variable `rlogin-program' contains the name of the actual program to
run.  It can be a relative or absolute path. 

The variable `rlogin-explicit-args' is a list of arguments to give to
the rlogin when starting." t nil)

(autoload (quote rlogin-with-args) "rlogin" "\
Open a new rlogin connection to HOST, even if one already exists. 
String ARGS is given as arguments to the `rlogin' program, overriding the
value of `rlogin-explicit-args'." t nil)

(autoload (quote rlogin-password) "rlogin" "\
Read a password and send it to an rlogin session.
For each character typed, a `*' is echoed in the minibuffer.
End with RET, LFD, or ESC.  DEL or C-h rubs out.  C-u kills line.
C-g aborts attempt to read and send password. 

Optional argument PROC is the process to which the password should be sent.
If not provided, send to the process in the current buffer.  This argument
is intended primarily for use by `rlogin-filter'." t nil)

(autoload (quote rlogin-mode) "rlogin" "\
Set major-mode for rlogin sessions. 
If `rlogin-mode-hook' is set, run it." t nil)

(autoload (quote rlogin-send-Ctrl-C) "rlogin" nil t nil)

(autoload (quote rlogin-send-Ctrl-Z) "rlogin" nil t nil)

(autoload (quote rlogin-send-Ctrl-backslash) "rlogin" nil t nil)

(autoload (quote rlogin-delchar-or-send-Ctrl-D) "rlogin" "\
Delete ARG characters forward, or send a C-d to process if at end of
buffer." t nil)

;;;***

;;;### (autoloads (rmail-input rmail-mode rmail) "rmail" "rmail.el" (11360 11262))
;;; Generated autoloads from rmail.el

(defvar rmail-dont-reply-to-names nil "\
*A regexp specifying names to prune of reply to messages.
A value of nil means exclude your own name only.")

(defvar rmail-default-dont-reply-to-names "info-" "\
A regular expression specifying part of the value of the default value of
the variable `rmail-dont-reply-to-names', for when the user does not set
`rmail-dont-reply-to-names' explicitly.  (The other part of the default
value is the user's name.)
It is useful to set this variable in the site customization file.")

(defvar rmail-ignored-headers "^via:\\|^mail-from:\\|^origin:\\|^status:\\|^received:\\|^message-id:\\|^summary-line:" "\
*Gubbish headers one would rather not see.")

(defvar rmail-delete-after-output nil "\
*Non-nil means automatically delete a message that is copied to a file.")

(defvar rmail-primary-inbox-list nil "\
*List of files which are inboxes for user's primary mail file `~/RMAIL'.
`nil' means the default, which is (\"/usr/spool/mail/$USER\")
(the name varies depending on the operating system,
and the value of the environment variable MAIL overrides it).")

(defvar rmail-mail-new-frame nil "\
*Non-nil means Rmail makes a new frame for composing outgoing mail.")

(autoload (quote rmail) "rmail" "\
Read and edit incoming mail.
Moves messages into file named by  rmail-file-name  (a babyl format file)
 and edits that file in RMAIL Mode.
Type \\[describe-mode] once editing that file, for a list of RMAIL commands.

May be called with filename as argument; then performs rmail editing on
that file, but does not copy any new mail into the file." t nil)

(autoload (quote rmail-mode) "rmail" "\
Rmail Mode is used by \\<rmail-mode-map>\\[rmail] for editing Rmail files.
All normal editing commands are turned off.
Instead, these commands are available:

\\[rmail-beginning-of-message]	Move point to front of this message (same as \\[beginning-of-buffer]).
\\[scroll-up]	Scroll to next screen of this message.
\\[scroll-down]	Scroll to previous screen of this message.
\\[rmail-next-undeleted-message]	Move to Next non-deleted message.
\\[rmail-previous-undeleted-message]	Move to Previous non-deleted message.
\\[rmail-next-message]	Move to Next message whether deleted or not.
\\[rmail-previous-message]	Move to Previous message whether deleted or not.
\\[rmail-first-message]	Move to the first message in Rmail file.
\\[rmail-last-message]	Move to the last message in Rmail file.
\\[rmail-show-message]	Jump to message specified by numeric position in file.
\\[rmail-search]	Search for string and show message it is found in.
\\[rmail-delete-forward]	Delete this message, move to next nondeleted.
\\[rmail-delete-backward]	Delete this message, move to previous nondeleted.
\\[rmail-undelete-previous-message]	Undelete message.  Tries current message, then earlier messages
	till a deleted message is found.
\\[rmail-edit-current-message]	Edit the current message.  \\[rmail-cease-edit] to return to Rmail.
\\[rmail-expunge]	Expunge deleted messages.
\\[rmail-expunge-and-save]	Expunge and save the file.
\\[rmail-quit]       Quit Rmail: expunge, save, then switch to another buffer.
\\[save-buffer] Save without expunging.
\\[rmail-get-new-mail]	Move new mail from system spool directory into this file.
\\[rmail-mail]	Mail a message (same as \\[mail-other-window]).
\\[rmail-continue]	Continue composing outgoing message started before.
\\[rmail-reply]	Reply to this message.  Like \\[rmail-mail] but initializes some fields.
\\[rmail-retry-failure]	Send this message again.  Used on a mailer failure message.
\\[rmail-forward]	Forward this message to another user.
\\[rmail-output-to-rmail-file]       Output this message to an Rmail file (append it).
\\[rmail-output]	Output this message to a Unix-format mail file (append it).
\\[rmail-input]	Input Rmail file.  Run Rmail on that file.
\\[rmail-add-label]	Add label to message.  It will be displayed in the mode line.
\\[rmail-kill-label]	Kill label.  Remove a label from current message.
\\[rmail-next-labeled-message]   Move to Next message with specified label
          (label defaults to last one specified).
          Standard labels: filed, unseen, answered, forwarded, deleted.
          Any other label is present only if you add it with \\[rmail-add-label].
\\[rmail-previous-labeled-message]   Move to Previous message with specified label
\\[rmail-summary]	Show headers buffer, with a one line summary of each message.
\\[rmail-summary-by-labels]	Summarize only messages with particular label(s).
\\[rmail-summary-by-recipients]   Summarize only messages with particular recipient(s).
\\[rmail-summary-by-regexp]   Summarize only messages with particular regexp(s).
\\[rmail-summary-by-topic]   Summarize only messages with subject line regexp(s).
\\[rmail-toggle-header]	Toggle display of complete header." t nil)

(autoload (quote rmail-input) "rmail" "\
Run Rmail on file FILENAME." t nil)

;;;***

;;;### (autoloads (rmail-file-p) "rmailout" "rmailout.el" (11496 44723))
;;; Generated autoloads from rmailout.el

(autoload (quote rmail-file-p) "rmailout" nil nil nil)

;;;***

;;;### (autoloads (rot13-other-window) "rot13" "rot13.el" (11295 37709))
;;; Generated autoloads from rot13.el

(autoload (quote rot13-other-window) "rot13" "\
Display current buffer in rot 13 in another window." t nil)

;;;***

;;;### (autoloads (sc-cite-original) "sc" "sc.el" (11350 50069))
;;; Generated autoloads from sc.el

(autoload (quote sc-cite-original) "sc" "\
Hook version of sc-cite.
This is callable from the various mail and news readers' reply
function according to the agreed upon standard. See \\[sc-describe]
for more details.  Sc-cite-original does not do any yanking of the
original message but it does require a few things:

     1) The reply buffer is the current buffer.

     2) The original message has been yanked and inserted into the
        reply buffer.

     3) Verbose mail headers from the original message have been
        inserted into the reply buffer directly before the text of the
        original message.

     4) Point is at the beginning of the verbose headers.

     5) Mark is at the end of the body of text to be cited." nil nil)

;;;***

;;;### (autoloads (scheme-mode) "scheme" "scheme.el" (11285 51473))
;;; Generated autoloads from scheme.el

(autoload (quote scheme-mode) "scheme" "\
Major mode for editing Scheme code.
Editing commands are similar to those of lisp-mode.

In addition, if an inferior Scheme process is running, some additional
commands will be defined, for evaluating expressions and controlling
the interpreter, and the state of the process will be displayed in the
modeline of all Scheme buffers.  The names of commands that interact
with the Scheme process start with \"xscheme-\".  For more information
see the documentation for xscheme-interaction-mode.

Commands:
Delete converts tabs to spaces as it moves back.
Blank lines separate paragraphs.  Semicolons start comments.
\\{scheme-mode-map}
Entry to this mode calls the value of scheme-mode-hook
if that value is non-nil." t nil)

;;;***

;;;### (autoloads (scribe-mode) "scribe" "scribe.el" (11185 15625))
;;; Generated autoloads from scribe.el

(autoload (quote scribe-mode) "scribe" "\
Major mode for editing files of Scribe (a text formatter) source.
Scribe-mode is similar text-mode, with a few extra commands added.
\\{scribe-mode-map}

Interesting variables:

scribe-fancy-paragraphs
  Non-nil makes Scribe mode use a different style of paragraph separation.

scribe-electric-quote
  Non-nil makes insert of double quote use `` or '' depending on context.

scribe-electric-parenthesis
  Non-nil makes an open-parenthesis char (one of `([<{')
  automatically insert its close if typed after an @Command form." t nil)

;;;***

;;;### (autoloads (mail-other-frame mail-other-window mail mail-mode) "sendmail" "sendmail.el" (11356 48606))
;;; Generated autoloads from sendmail.el

(defvar mail-self-blind nil "\
Non-nil means insert BCC to self in messages to be sent.
This is done when the message is initialized,
so you can remove or alter the BCC field to override the default.")

(defvar mail-interactive nil "\
Non-nil means when sending a message wait for and display errors.
nil means let mailer mail back a message to report errors.")

(defvar mail-yank-ignored-headers "^via:\\|^mail-from:\\|^origin:\\|^status:\\|^remailed\\|^received:\\|^message-id:\\|^summary-line:\\|^to:\\|^subject:\\|^in-reply-to:\\|^return-path:" "\
Delete these headers from old message when it's inserted in a reply.")

(defvar send-mail-function (quote sendmail-send-it) "\
Function to call to send the current buffer as mail.
The headers are be delimited by a line which is `mail-header-separator'.")

(defvar mail-header-separator "--text follows this line--" "\
*Line used to separate headers from text in messages being composed.")

(defvar mail-archive-file-name nil "\
*Name of file to write all outgoing messages in, or nil for none.
Do not use an rmail file here!  Instead, use its inbox file.")

(defvar mail-signature nil "\
*Text inserted at end of mail buffer when a message is initialized.
If t, it means to insert the contents of the file `~/.signature'.")

(autoload (quote mail-mode) "sendmail" "\
Major mode for editing mail to be sent.
Like Text Mode but with these additional commands:
C-c C-s  mail-send (send the message)    C-c C-c  mail-send-and-exit
C-c C-f  move to a header field (and create it if there isn't):
	 C-c C-f C-t  move to To:	C-c C-f C-s  move to Subj:
	 C-c C-f C-b  move to BCC:	C-c C-f C-c  move to CC:
C-c C-t  move to message text.
C-c C-y  mail-yank-original (insert current message, in Rmail).
C-c C-q  mail-fill-yanked-message (fill what was yanked).
C-c C-v  mail-sent-via (add a sent-via field for each To or CC)." t nil)

(autoload (quote mail) "sendmail" "\
Edit a message to be sent.  Prefix arg means resume editing (don't erase).
When this function returns, the buffer `*mail*' is selected.
The value is t if the message was newly initialized; otherwise, nil.

By default, the signature file `~/.signature' is inserted at the end;
see the variable `mail-signature'.

\\<mail-mode-map>
While editing message, type \\[mail-send-and-exit] to send the message and exit.

Various special commands starting with C-c are available in sendmail mode
to move to message header fields:
\\{mail-mode-map}

If `mail-self-blind' is non-nil, a BCC to yourself is inserted
when the message is initialized.

If `mail-default-reply-to' is non-nil, it should be an address (a string);
a Reply-to: field with that address is inserted.

If `mail-archive-file-name' is non-nil, an FCC field with that file name
is inserted.

If `mail-setup-hook' is bound, its value is called with no arguments
after the message is initialized.  It can add more default fields.

When calling from a program, the second through fifth arguments
 TO, SUBJECT, IN-REPLY-TO and CC specify if non-nil
 the initial contents of those header fields.
 These arguments should not have final newlines.
The sixth argument REPLYBUFFER is a buffer whose contents
 should be yanked if the user types C-c C-y.
The seventh argument ACTIONS is a list of actions to take
 if/when the message is sent.  Each action looks like (FUNCTION . ARGS);
 when the message is sent, we apply FUNCTION to ARGS.
 This is how Rmail arranges to mark messages `answered'." t nil)

(autoload (quote mail-other-window) "sendmail" "\
Like `mail' command, but display mail buffer in another window." t nil)

(autoload (quote mail-other-frame) "sendmail" "\
Like `mail' command, but display mail buffer in another frame." t nil)
(define-key ctl-x-map "m" 'mail)
(define-key ctl-x-4-map "m" 'mail-other-window)
(define-key ctl-x-5-map "m" 'mail-other-frame)

;;;***

;;;### (autoloads (server-start) "server" "server.el" (11365 58935))
;;; Generated autoloads from server.el

(autoload (quote server-start) "server" "\
Allow this Emacs process to be a server for client processes.
This starts a server communications subprocess through which
client \"editors\" can send your editing commands to this Emacs job.
To use the server, set up the program `etc/emacsclient' in the
Emacs distribution as your standard \"editor\".

Prefix arg means just kill any existing server communications subprocess." t nil)

;;;***

;;;### (autoloads (sgml-mode) "sgml-mode" "sgml-mode.el" (11274 32251))
;;; Generated autoloads from sgml-mode.el

(autoload (quote sgml-mode) "sgml-mode" "\
Major mode for editing SGML.
Makes > display the matching <.  Makes / display matching /.
Use \\[sgml-validate] to validate your document with an SGML parser." t nil)

;;;***

;;;### (autoloads (shell) "shell" "shell.el" (11336 59243))
;;; Generated autoloads from shell.el

(defvar shell-prompt-pattern "^[^#$%>\n]*[#$%>] *" "\
Regexp to match prompts in the inferior shell.
Defaults to \"^[^#$%>\\n]*[#$%>] *\", which works pretty well.
This variable is used to initialise `comint-prompt-regexp' in the 
shell buffer.

The pattern should probably not match more than one line.  If it does,
shell-mode may become confused trying to distinguish prompt from input
on lines which don't start with a prompt.

This is a fine thing to set in your `.emacs' file.")

(autoload (quote shell) "shell" "\
Run an inferior shell, with I/O through buffer *shell*.
If buffer exists but shell process is not running, make new shell.
If buffer exists and shell process is running, 
 just switch to buffer `*shell*'.
Program used comes from variable `explicit-shell-file-name',
 or (if that is nil) from the ESHELL environment variable,
 or else from SHELL if there is no ESHELL.
If a file `~/.emacs_SHELLNAME' exists, it is given as initial input
 (Note that this may lose due to a timing error if the shell
  discards input when it starts up.)
The buffer is put in Shell mode, giving commands for sending input
and controlling the subjobs of the shell.  See `shell-mode'.
See also the variable `shell-prompt-pattern'.

The shell file name (sans directories) is used to make a symbol name
such as `explicit-csh-args'.  If that symbol is a variable,
its value is used as a list of arguments when invoking the shell.
Otherwise, one argument `-i' is passed to the shell.

(Type \\[describe-mode] in the shell buffer for a list of commands.)" t nil)

;;;***

;;;### (autoloads (solar-equinoxes-solstices sunrise-sunset) "solar" "solar.el" (11494 46887))
;;; Generated autoloads from solar.el

(defvar calendar-time-display-form (quote (12-hours ":" minutes am-pm (if time-zone " (") time-zone (if time-zone ")"))) "\
*The pseudo-pattern that governs the way a time of day is formatted.

A pseudo-pattern is a list of expressions that can involve the keywords
`12-hours', `24-hours', and `minutes',  all numbers in string form,
and `am-pm' and `time-zone',  both alphabetic strings.

For example, the form

  '(24-hours \":\" minutes
    (if time-zone \" (\") time-zone (if time-zone \")\"))

would give military-style times like `21:07 (UTC)'.")

(defvar calendar-latitude nil "\
*Latitude of `calendar-location-name' in degrees, + north, - south.
For example, 40.7 for New York City.
It may not be a good idea to set this in advance for your site;
if there may be users running Emacs at your site
who are physically located elsewhere, they would get the wrong
value and might not know how to override it.")

(defvar calendar-longitude nil "\
*Longitude of `calendar-location-name' in degrees, + east, - west.
For example, -74.0 for New York City.
It may not be a good idea to set this in advance for your site;
if there may be users running Emacs at your site
who are physically located elsewhere, they would get the wrong
value and might not know how to override it.")

(defvar calendar-location-name (quote (let ((float-output-format "%.1f")) (format "%s%s, %s%s" (abs calendar-latitude) (if (> calendar-latitude 0) "N" "S") (abs calendar-longitude) (if (> calendar-longitude 0) "E" "W")))) "\
*Expression evaluating to name of `calendar-longitude', calendar-latitude'.
Default value is just the latitude, longitude pair.")

(autoload (quote sunrise-sunset) "solar" "\
Local time of sunrise and sunset for today.  Accurate to +/- 2 minutes.
If called with an optional prefix argument, prompts for date.

If called with an optional double prefix argument, prompts for longitude,
latitude, time zone, and date.

This function is suitable for execution in a .emacs file." t nil)

(autoload (quote solar-equinoxes-solstices) "solar" "\
Date and time of equinoxes and solstices, if visible in the calendar window.
Requires floating point." nil nil)

;;;***

;;;### (autoloads (reverse-region sort-columns sort-regexp-fields sort-fields sort-float-fields sort-numeric-fields sort-pages sort-paragraphs sort-lines) "sort" "sort.el" (11344 9594))
;;; Generated autoloads from sort.el

(autoload (quote sort-lines) "sort" "\
Sort lines in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload (quote sort-paragraphs) "sort" "\
Sort paragraphs in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload (quote sort-pages) "sort" "\
Sort pages in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort)." t nil)

(autoload (quote sort-numeric-fields) "sort" "\
Sort lines in region numerically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
Specified field must contain a number in each line of the region.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort.
If you want to sort floating-point numbers, try `sort-float-fields'." t nil)

(autoload (quote sort-float-fields) "sort" "\
Sort lines in region numerically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.  Specified field
must contain a floating point number in each line of the region.  With a
negative arg, sorts by the ARGth field counted from the right.  Called from a
program, there are three arguments: FIELD, BEG and END.  BEG and END specify
region to sort." t nil)

(autoload (quote sort-fields) "sort" "\
Sort lines in region lexicographically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort." t nil)

(autoload (quote sort-regexp-fields) "sort" "\
Sort the region lexicographically as specified by RECORD-REGEXP and KEY.
RECORD-REGEXP specifies the textual units which should be sorted.
  For example, to sort lines RECORD-REGEXP would be \"^.*$\"
KEY specifies the part of each record (ie each match for RECORD-REGEXP)
  is to be used for sorting.
  If it is \"\\digit\" then the digit'th \"\\(...\\)\" match field from
  RECORD-REGEXP is used.
  If it is \"\\&\" then the whole record is used.
  Otherwise, it is a regular-expression for which to search within the record.
If a match for KEY is not found within a record then that record is ignored.

With a negative prefix arg sorts in reverse order.

For example: to sort lines in the region by the first word on each line
 starting with the letter \"f\",
 RECORD-REGEXP would be \"^.*$\" and KEY would be \"\\=\\<f\\w*\\>\"" t nil)

(autoload (quote sort-columns) "sort" "\
Sort lines in region alphabetically by a certain range of columns.
For the purpose of this command, the region includes
the entire line that point is in and the entire line the mark is in.
The column positions of point and mark bound the range of columns to sort on.
A prefix argument means sort into reverse order.

Note that `sort-columns' rejects text that contains tabs,
because tabs could be split across the specified columns
and it doesn't know how to handle that.  Also, when possible,
it uses the `sort' utility program, which doesn't understand tabs.
Use \\[untabify] to convert tabs to spaces before sorting." t nil)

(autoload (quote reverse-region) "sort" "\
Reverse the order of lines in a region.
From a program takes two point or marker arguments, BEG and END." t nil)

;;;***

;;;### (autoloads (spell-string spell-region spell-word spell-buffer) "spell" "spell.el" (11285 51501))
;;; Generated autoloads from spell.el

(autoload (quote spell-buffer) "spell" "\
Check spelling of every word in the buffer.
For each incorrect word, you are asked for the correct spelling
and then put into a query-replace to fix some or all occurrences.
If you do not want to change a word, just give the same word
as its \"correct\" spelling; then the query replace is skipped." t nil)

(autoload (quote spell-word) "spell" "\
Check spelling of word at or before point.
If it is not correct, ask user for the correct spelling
and `query-replace' the entire buffer to substitute it." t nil)

(autoload (quote spell-region) "spell" "\
Like `spell-buffer' but applies only to region.
Used in a program, applies from START to END.
DESCRIPTION is an optional string naming the unit being checked:
for example, \"word\"." t nil)

(autoload (quote spell-string) "spell" "\
Check spelling of string supplied as argument." t nil)

;;;***

;;;### (autoloads (snarf-spooks spook) "spook" "spook.el" (11332 39077))
;;; Generated autoloads from spook.el

(autoload (quote spook) "spook" "\
Adds that special touch of class to your outgoing mail." t nil)

(autoload (quote snarf-spooks) "spook" "\
Return a vector containing the lines from `spook-phrases-file'." nil nil)

;;;***

;;;### (autoloads (tabify untabify) "tabify" "tabify.el" (11202 22548))
;;; Generated autoloads from tabify.el

(autoload (quote untabify) "tabify" "\
Convert all tabs in region to multiple spaces, preserving columns.
Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops." t nil)

(autoload (quote tabify) "tabify" "\
Convert multiple spaces in region to tabs when possible.
A group of spaces is partially replaced by tabs
when this can be done without changing the column they end at.
Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops." t nil)

;;;***

;;;### (autoloads (tar-mode) "tar-mode" "tar-mode.el" (11354 62228))
;;; Generated autoloads from tar-mode.el

(autoload (quote tar-mode) "tar-mode" "\
Major mode for viewing a tar file as a dired-like listing of its contents.
You can move around using the usual cursor motion commands. 
Letters no longer insert themselves.
Type `e' to pull a file out of the tar file and into its own buffer.
Type `c' to copy an entry from the tar file into another file on disk.

If you edit a sub-file of this archive (as with the `e' command) and 
save it with Control-x Control-s, the contents of that buffer will be 
saved back into the tar-file buffer; in this way you can edit a file 
inside of a tar archive without extracting it and re-archiving it.

See also: variables `tar-update-datestamp' and `tar-anal-blocksize'.
\\{tar-mode-map}" nil nil)

;;;***

;;;### (autoloads (rsh telnet) "telnet" "telnet.el" (11357 58585))
;;; Generated autoloads from telnet.el

(autoload (quote telnet) "telnet" "\
Open a network login connection to host named HOST (a string).
Communication with HOST is recorded in a buffer *HOST-telnet*.
Normally input is edited in Emacs and sent a line at a time." t nil)

(autoload (quote rsh) "telnet" "\
Open a network login connection to host named HOST (a string).
Communication with HOST is recorded in a buffer *HOST-rsh*.
Normally input is edited in Emacs and sent a line at a time." t nil)

;;;***

;;;### (autoloads (terminal-emulator) "terminal" "terminal.el" (11285 51534))
;;; Generated autoloads from terminal.el

(autoload (quote terminal-emulator) "terminal" "\
Under a display-terminal emulator in BUFFER, run PROGRAM on arguments ARGS.
ARGS is a list of argument-strings.  Remaining arguments are WIDTH and HEIGHT.
BUFFER's contents are made an image of the display generated by that program,
and any input typed when BUFFER is the current Emacs buffer is sent to that
program an keyboard input.

Interactively, BUFFER defaults to \"*terminal*\" and PROGRAM and ARGS
are parsed from an input-string using your usual shell.
WIDTH and HEIGHT are determined from the size of the current window
-- WIDTH will be one less than the window's width, HEIGHT will be its height.

To switch buffers and leave the emulator, or to give commands
to the emulator itself (as opposed to the program running under it),
type Control-^.  The following character is an emulator command.
Type Control-^ twice to send it to the subprogram.
This escape character may be changed using the variable `terminal-escape-char'.

`Meta' characters may not currently be sent through the terminal emulator.

Here is a list of some of the variables which control the behaviour
of the emulator -- see their documentation for more information:
terminal-escape-char, terminal-scrolling, terminal-more-processing,
terminal-redisplay-interval.

This function calls the value of terminal-mode-hook if that exists
and is non-nil after the terminal buffer has been set up and the
subprocess started.

Presently with `termcap' only; if somebody sends us code to make this
work with `terminfo' we will try to use it." t nil)

;;;***

;;;### (autoloads (latex-mode plain-tex-mode tex-mode) "tex-mode" "tex-mode.el" (11354 8216))
;;; Generated autoloads from tex-mode.el

(defvar tex-shell-file-name nil "\
*If non-nil, is file name to use for the subshell in which TeX is run.")

(defvar tex-directory "." "\
*Directory in which temporary files are left.
You can make this /tmp if your TEXINPUTS has no relative directories in it
and you don't try to apply \\[tex-region] or \\[tex-buffer] when there are
\\input commands with relative directories.")

(defvar tex-offer-save t "\
*If non-nil, ask about saving modified buffers before \\[tex-file] is run.")

(defvar tex-run-command "tex" "\
*Command used to run TeX subjob.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.")

(defvar latex-run-command "latex" "\
*Command used to run LaTeX subjob.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.")

(defvar latex-block-names nil "\
*User defined LaTeX block names.
Combined with `standard-latex-block-names' for minibuffer completion.")

(defvar slitex-run-command "slitex" "\
*Command used to run SliTeX subjob.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.")

(defvar tex-bibtex-command "bibtex" "\
*Command used by `tex-bibtex-file' to gather bibliographic data.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.")

(defvar tex-dvi-print-command "lpr -d" "\
*Command used by \\[tex-print] to print a .dvi file.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.")

(defvar tex-alt-dvi-print-command "lpr -d" "\
*Command used by \\[tex-print] with a prefix arg to print a .dvi file.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.

If two printers are not enough of a choice, you can define the value
of tex-alt-dvi-print-command to be an expression that asks what you want;
for example,

    (setq tex-alt-dvi-print-command
         '(format \"lpr -P%s\" (read-string \"Use printer: \")))

would tell \\[tex-print] with a prefix argument to ask you which printer to
use.")

(defvar tex-dvi-view-command nil "\
*Command used by \\[tex-view] to display a .dvi file.
If this string contains an asterisk (*), it will be replaced by the
filename; if not, the name of the file, preceded by blank, will be added to
this string.

This can be set conditionally so that the previewer used is suitable for the
window system being used.  For example,

    (setq tex-dvi-view-command
          (if (eq window-system 'x) \"xdvi\" \"dvi2tty * | cat -s\"))

would tell \\[tex-view] use xdvi under X windows and to use dvi2tty
otherwise.")

(defvar tex-show-queue-command "lpq" "\
*Command used by \\[tex-show-print-queue] to show the print queue.
Should show the queue(s) that \\[tex-print] puts jobs on.")

(defvar tex-default-mode (quote plain-tex-mode) "\
*Mode to enter for a new file that might be either TeX or LaTeX.
This variable is used when it can't be determined whether the file
is plain TeX or LaTeX or what because the file contains no commands.
Normally set to either 'plain-tex-mode or 'latex-mode.")

(defvar tex-open-quote "``" "\
*String inserted by typing \\[tex-insert-quote] to open a quotation.")

(defvar tex-close-quote "''" "\
*String inserted by typing \\[tex-insert-quote] to close a quotation.")

(autoload (quote tex-mode) "tex-mode" "\
Major mode for editing files of input for TeX, LaTeX, or SliTeX.
Tries to determine (by looking at the beginning of the file) whether
this file is for plain TeX, LaTeX, or SliTeX and calls plain-tex-mode,
latex-mode, or slitex-mode, respectively.  If it cannot be determined,
such as if there are no commands in the file, the value of tex-default-mode
is used." t nil)

(defalias (quote TeX-mode) (quote tex-mode))

(defalias (quote LaTeX-mode) (quote latex-mode))

(autoload (quote plain-tex-mode) "tex-mode" "\
Major mode for editing files of input for plain TeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run TeX on the current region, plus a \"header\"
copied from the top of the file (containing macro definitions, etc.),
running TeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[validate-tex-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{tex-mode-map}

Mode variables:
tex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for TeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Plain-tex mode calls the value of `text-mode-hook', then the value
of `tex-mode-hook', and then the value of `plain-tex-mode-hook'.  When the
special subshell is initiated, the value of `tex-shell-hook' is called." t nil)

(defalias (quote plain-TeX-mode) (quote plain-tex-mode))

(autoload (quote latex-mode) "tex-mode" "\
Major mode for editing files of input for LaTeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run LaTeX on the current region, plus the preamble
copied from the top of the file (containing \\documentstyle, etc.),
running LaTeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[validate-tex-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{tex-mode-map}

Mode variables:
latex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for LaTeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Latex mode calls the value of text-mode-hook, then the value of
tex-mode-hook, and then the value of latex-mode-hook.  When the special
subshell is initiated, the value of tex-shell-hook is called." t nil)

;;;***

;;;### (autoloads (texinfo-format-region texinfo-format-buffer) "texinfmt" "texinfmt.el" (11462 52384))
;;; Generated autoloads from texinfmt.el

(autoload (quote texinfo-format-buffer) "texinfmt" "\
Process the current buffer as texinfo code, into an Info file.
The Info file output is generated in a buffer visiting the Info file
names specified in the @setfilename command.

Non-nil argument (prefix, if interactive) means don't make tag table
and don't split the file if large.  You can use Info-tagify and
Info-split to do these manually." t nil)

(autoload (quote texinfo-format-region) "texinfmt" "\
Convert the current region of the Texinfo file to Info format.
This lets you see what that part of the file will look like in Info.
The command is bound to \\[texinfo-format-region].  The text that is
converted to Info is stored in a temporary buffer." t nil)

;;;***

;;;### (autoloads (texinfo-mode) "texinfo" "texinfo.el" (11367 23334))
;;; Generated autoloads from texinfo.el

(autoload (quote texinfo-mode) "texinfo" "\
Major mode for editing Texinfo files.

  It has these extra commands:
\\{texinfo-mode-map}

  These are files that are used as input for TeX to make printed manuals
and also to be turned into Info files with \\[makeinfo-buffer] or
the `makeinfo' program.  These files must be written in a very restricted and
modified version of TeX input format.

  Editing commands are like text-mode except that the syntax table is
set up so expression commands skip Texinfo bracket groups.  To see
what the Info version of a region of the Texinfo file will look like,
use \\[makeinfo-region], which runs `makeinfo' on the current region.

  You can show the structure of a Texinfo file with \\[texinfo-show-structure].
This command shows the structure of a Texinfo file by listing the
lines with the @-sign commands for @chapter, @section, and the like.
These lines are displayed in another window called the *Occur* window.
In that window, you can position the cursor over one of the lines and
use \\[occur-mode-goto-occurrence], to jump to the corresponding spot
in the Texinfo file.

  In addition, Texinfo mode provides commands that insert various
frequently used @-sign commands into the buffer.  You can use these
commands to save keystrokes.  And you can insert balanced braces with
\\[texinfo-insert-braces] and later use the command \\[up-list] to
move forward past the closing brace.

Also, Texinfo mode provides functions for automatically creating or
updating menus and node pointers.  These functions

  * insert the `Next', `Previous' and `Up' pointers of a node,
  * insert or update the menu for a section, and
  * create a master menu for a Texinfo source file.

Here are the functions:

    texinfo-update-node                \\[texinfo-update-node]
    texinfo-every-node-update          \\[texinfo-every-node-update]
    texinfo-sequential-node-update 

    texinfo-make-menu                  \\[texinfo-make-menu]
    texinfo-all-menus-update           \\[texinfo-all-menus-update]
    texinfo-master-menu

    texinfo-indent-menu-description (column &optional region-p)

The `texinfo-column-for-description' variable specifies the column to
which menu descriptions are indented. 

Passed an argument (a prefix argument, if interactive), the
`texinfo-update-node' and `texinfo-make-menu' functions do their jobs
in the region.

To use the updating commands, you must structure your Texinfo file
hierarchically, such that each `@node' line, with the exception of the
Top node, is accompanied by some kind of section line, such as an
`@chapter' or `@section' line.

If the file has a `top' node, it must be called `top' or `Top' and
be the first node in the file.

Entering Texinfo mode calls the value of text-mode-hook, and then the
value of texinfo-mode-hook." t nil)

;;;***

;;;### (autoloads (texinfo-sequential-node-update texinfo-every-node-update texinfo-update-node) "texnfo-upd" "texnfo-upd.el" (11488 11824))
;;; Generated autoloads from texnfo-upd.el

(autoload (quote texinfo-update-node) "texnfo-upd" "\
Without any prefix argument, update the node in which point is located.
Non-nil argument (prefix, if interactive) means update the nodes in the
marked region.

The functions for creating or updating nodes and menus, and their
keybindings, are:

    texinfo-update-node (&optional region-p)    \\[texinfo-update-node]
    texinfo-every-node-update ()                \\[texinfo-every-node-update]
    texinfo-sequential-node-update (&optional region-p)

    texinfo-make-menu (&optional region-p)      \\[texinfo-make-menu]
    texinfo-all-menus-update ()                 \\[texinfo-all-menus-update]
    texinfo-master-menu ()

    texinfo-indent-menu-description (column &optional region-p)

The `texinfo-column-for-description' variable specifies the column to
which menu descriptions are indented. Its default value is 32." t nil)

(autoload (quote texinfo-every-node-update) "texnfo-upd" "\
Update every node in a Texinfo file." t nil)

(autoload (quote texinfo-sequential-node-update) "texnfo-upd" "\
Update one node (or many) in a Texinfo file with sequential pointers.

This function causes the `Next' or `Previous' pointer to point to the
immediately preceding or following node, even if it is at a higher or
lower hierarchical level in the document.  Continually pressing `n' or
`p' takes you straight through the file.

Without any prefix argument, update the node in which point is located.
Non-nil argument (prefix, if interactive) means update the nodes in the
marked region.

This command makes it awkward to navigate among sections and
subsections; it should be used only for those documents that are meant
to be read like a novel rather than a reference, and for which the
Info `g*' command is inadequate." t nil)

;;;***

;;;### (autoloads (display-time) "time" "time.el" (11322 20891))
;;; Generated autoloads from time.el

(defvar display-time-day-and-date nil "\
*Non-nil means \\[display-time] should display day and date as well as time.")

(autoload (quote display-time) "time" "\
Display current time, load level, and mail flag in mode line of each buffer.
Updates automatically every minute.
If `display-time-day-and-date' is non-nil, the current day and date
are displayed as well.
After each update, `display-time-hook' is run with `run-hooks'." t nil)

;;;***

;;;### (autoloads (time-stamp) "time-stamp" "time-stamp.el" (11351 4303))
;;; Generated autoloads from time-stamp.el

(autoload (quote time-stamp) "time-stamp" "\
Update the time stamp string in the buffer.
Only does its thing if the variable  time-stamp-active  is non-nil.
Typically used on  write-file-hooks  for automatic time-stamping.
The format of the time stamp is determined by the variable
time-stamp-format.  The first  time-stamp-line-limit  lines of the
buffer (normally 8) are searched for the time stamp template,
and if it is found, a new time stamp is written into it." t nil)

;;;***

;;;### (autoloads (run-at-time) "timer" "timer.el" (11285 51562))
;;; Generated autoloads from timer.el

(autoload (quote run-at-time) "timer" "\
Run a function at a time, and optionally on a regular interval.
Arguments are TIME, REPEAT, FUNCTION &rest ARGS.
TIME, a string, can be specified absolutely or relative to now.
TIME can also be an integer, a number of seconds.
REPEAT, an integer number of seconds, is the interval on which to repeat
the call to the function.  If REPEAT is nil, call it just once.

Absolute times may be specified in a wide variety of formats;
Something of the form `HOUR:MIN:SEC TIMEZONE MONTH/DAY/YEAR', where
all fields are numbers, works; the format used by the Unix `date'
command works too.

Relative times may be specified as a series of numbers followed by units:
  1 min         	denotes one minute from now.
  min			does too.
  1 min 5 sec		denotes 65 seconds from now.
  1 min 2 sec 3 hour 4 day 5 week 6 fortnight 7 month 8 year
			denotes the sum of all the given durations from now." t nil)

;;;***

;;;### (autoloads (tpu-edt-on) "tpu-edt" "tpu-edt.el" (11368 32024))
;;; Generated autoloads from tpu-edt.el

(fset (quote tpu-edt-mode) (quote tpu-edt-on))

(fset (quote tpu-edt) (quote tpu-edt-on))

(autoload (quote tpu-edt-on) "tpu-edt" "\
Turn on TPU/edt emulation." t nil)

;;;***

;;;### (autoloads (tq-create) "tq" "tq.el" (10941 58296))
;;; Generated autoloads from tq.el

(autoload (quote tq-create) "tq" "\
Create and return a transaction queue communicating with PROCESS.
PROCESS should be a subprocess capable of sending and receiving
streams of bytes.  It may be a local process, or it may be connected
to a tcp server on another machine." nil nil)

;;;***

;;;### (autoloads (trace-function-background trace-function) "trace" "trace.el" (11256 21938))
;;; Generated autoloads from trace.el

(defvar trace-buffer "*trace-output*" "\
*Trace output will by default go to that buffer.")

(autoload (quote trace-function) "trace" "\
Traces FUNCTION with trace output going to BUFFER.
For every call of FUNCTION Lisp-style trace messages that display argument
and return values will be inserted into BUFFER. This function generates the
trace advice for FUNCTION and activates it together with any other advice
there might be!! The trace BUFFER will popup whenever FUNCTION is called.
Do not use this to trace functions that switch buffers or do any other
display oriented stuff, use `trace-function-background' instead." t nil)

(autoload (quote trace-function-background) "trace" "\
Traces FUNCTION with trace output going quietly to BUFFER.
For every call of FUNCTION Lisp-style trace messages that display argument
and return values will be inserted into BUFFER. This function generates the
trace advice for FUNCTION and activates it together with any other advice
there might be!! Trace output will quietly go to BUFFER without changing
the window or buffer configuration at all." t nil)

;;;***

;;;### (autoloads (tc-recenter tc-scroll-down tc-scroll-up tc-scroll-line tc-associated-buffer tc-merge tc-dissociate tc-split tc-associate-buffer tc-two-columns) "two-column" "two-column.el" (11223 37223))
;;; Generated autoloads from two-column.el

(defvar tc-mode-map nil "\
Keymap for commands for two-column mode.")

(if tc-mode-map nil (setq tc-mode-map (make-sparse-keymap)) (define-key tc-mode-map "1" (quote tc-merge)) (define-key tc-mode-map "2" (quote tc-two-columns)) (define-key tc-mode-map "b" (quote tc-associate-buffer)) (define-key tc-mode-map "e" (quote tc-dissociate)) (define-key tc-mode-map "" (quote tc-recenter)) (define-key tc-mode-map "o" (quote tc-associated-buffer)) (define-key tc-mode-map "s" (quote tc-split)) (define-key tc-mode-map "{" (quote shrink-window-horizontally)) (define-key tc-mode-map "}" (quote enlarge-window-horizontally)) (define-key tc-mode-map " " (quote tc-scroll-up)) (define-key tc-mode-map "" (quote tc-scroll-down)) (define-key tc-mode-map "
" (quote tc-scroll-line)))

(global-set-key "6" tc-mode-map)

(autoload (quote tc-two-columns) "two-column" "\
Split current window vertically for two-column editing.

When called the first time, associates a buffer with the current
buffer.  Both buffers are put in two-column minor mode and
tc-mode-hook gets called on both.  These buffers remember
about one another, even when renamed.

When called again, restores the screen layout with the current buffer
first and the associated buffer to it's right.

If you include long lines, i.e which will span both columns (eg.
source code), they should be in what will be the first column, with
the associated buffer having empty lines next to them.

You have the following commands at your disposal:

\\[tc-two-columns]   Rearrange screen
\\[tc-associate-buffer]   Reassociate buffer after changing major mode
\\[tc-scroll-up]   Scroll both buffers up by a screenfull
\\[tc-scroll-down]   Scroll both buffers down by a screenful
\\[tc-scroll-line]   Scroll both buffers up by one or more lines
\\[tc-recenter]   Recenter and realign other buffer
\\[shrink-window-horizontally], \\[enlarge-window-horizontally]   Shrink, enlarge current column
\\[tc-associated-buffer]   Switch to associated buffer
\\[tc-merge]   Merge both buffers

These keybindings can be customized in your ~/.emacs by `tc-prefix'
and `tc-mode-map'.

The appearance of the screen can be customized by the variables
`tc-window-width', `tc-beyond-fill-column',
`tc-mode-line-format' and `truncate-partial-width-windows'." t nil)

(autoload (quote tc-associate-buffer) "two-column" "\
Associate another buffer with this one in two-column minor mode.
Can also be used to associate a just previously visited file, by
accepting the proposed default buffer.

See  \\[tc-two-columns]  and  `lisp/two-column.el'  for further details." t nil)

(autoload (quote tc-split) "two-column" "\
Unmerge a two-column text into two buffers in two-column minor mode.
The text is unmerged at the cursor's column which becomes the local
value of `tc-window-width'.  Only lines that have the ARG same
preceding characters at that column get split.  The ARG preceding
characters without any leading whitespace become the local value for
`tc-separator'.  This way lines that continue across both
columns remain untouched in the first buffer.

This function can be used with a prototype line, to set up things as
you like them.  You write the first line of each column with the
separator you like and then unmerge that line.  E.g.:

First column's text    sSs  Second columns text
		       \\___/\\
			/    \\
   5 character Separator      You type  M-5 \\[tc-split]  with the point here

See  \\[tc-two-columns]  and  `lisp/two-column.el'  for further details." t nil)

(autoload (quote tc-dissociate) "two-column" "\
Turn off two-column minor mode in current and associated buffer.
If the associated buffer is unmodified and empty, it is killed." t nil)

(autoload (quote tc-merge) "two-column" "\
Merges the associated buffer with the current buffer.
They get merged at the column, which is the value of
`tc-window-width', i.e. usually at the vertical window
separator.  This separator gets replaced with white space.  Beyond
that the value of gets inserted on merged lines.  The two columns are
thus pasted side by side, in a single text.  If the other buffer is
not displayed to the left of this one, then this one becomes the left
column.

If you want `tc-separator' on empty lines in the second column,
you should put just one space in them.  In the final result, you can strip
off trailing spaces with \\[beginning-of-buffer] \\[replace-regexp] [ SPC TAB ] + $ RET RET" t nil)

(autoload (quote tc-associated-buffer) "two-column" "\
Switch to associated buffer." t nil)

(autoload (quote tc-scroll-line) "two-column" "\
Scroll current window upward by ARG lines.
The associated window gets scrolled to the same line." t nil)

(autoload (quote tc-scroll-up) "two-column" "\
Scroll current window upward by ARG screens.
The associated window gets scrolled to the same line." t nil)

(autoload (quote tc-scroll-down) "two-column" "\
Scroll current window downward by ARG screens.
The associated window gets scrolled to the same line." t nil)

(autoload (quote tc-recenter) "two-column" "\
Center point in window.  With ARG, put point on line ARG.
This counts from bottom if ARG is negative.  The associated window
gets scrolled to the same line." t nil)

;;;***

;;;### (autoloads (ununderline-region underline-region) "underline" "underline.el" (11185 16923))
;;; Generated autoloads from underline.el

(autoload (quote underline-region) "underline" "\
Underline all nonblank characters in the region.
Works by overstriking underscores.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

(autoload (quote ununderline-region) "underline" "\
Remove all underlining (overstruck underscores) in the region.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

;;;***

;;;### (autoloads (unrmail batch-unrmail) "unrmail" "unrmail.el" (11345 60792))
;;; Generated autoloads from unrmail.el

(autoload (quote batch-unrmail) "unrmail" "\
Convert Rmail files to mailbox files.
Specify the input Rmail file names as command line arguments.
For each Rmail file, the corresponding output file name
is made by adding `.mail' at the end.
For example, invoke `emacs -batch -f batch-unrmail RMAIL'." nil nil)

(autoload (quote unrmail) "unrmail" "\
Convert Rmail file FILE to mailbox-format file TO-FILE." t nil)

;;;***

;;;### (autoloads (ask-to-update-copyright update-copyright) "upd-copyr" "upd-copyr.el" (11086 5246))
;;; Generated autoloads from upd-copyr.el

(defvar replace-copying-with nil "\
*If non-nil, replace copying notices with this file.")

(autoload (quote update-copyright) "upd-copyr" "\
Update the copyright notice at the beginning of the buffer
to indicate the current year.  If optional arg REPLACE is given
(interactively, with prefix arg) replace the years in the notice
rather than adding the current year after them.
If `replace-copying-with' is set, the copying permissions following the
copyright are replaced as well.

If optional third argument ASK is non-nil, the user is prompted for whether
or not to update the copyright.  If optional fourth argument ASK-YEAR is
non-nil, the user is prompted for whether or not to replace the year rather
than adding to it." t nil)

(autoload (quote ask-to-update-copyright) "upd-copyr" "\
If the current buffer contains a copyright notice that is out of date,
ask the user if it should be updated with `update-copyright' (which see).
Put this on write-file-hooks." nil nil)

;;;***

;;;### (autoloads (ask-user-about-supersession-threat ask-user-about-lock) "userlock" "userlock.el" (10941 47202))
;;; Generated autoloads from userlock.el

(autoload (quote ask-user-about-lock) "userlock" "\
Ask user what to do when he wants to edit FILE but it is locked by USER.
This function has a choice of three things to do:
  do (signal 'buffer-file-locked (list FILE USER))
    to refrain from editing the file
  return t (grab the lock on the file)
  return nil (edit the file even though it is locked).
You can rewrite it to use any criterion you like to choose which one to do." nil nil)

(autoload (quote ask-user-about-supersession-threat) "userlock" "\
Ask a user who is about to modify an obsolete buffer what to do.
This function has two choices: it can return, in which case the modification
of the buffer will proceed, or it can (signal 'file-supersession (file)),
in which case the proposed buffer modification will not be made.

You can rewrite this to use any criterion you like to choose which one to do.
The buffer in question is current when this function is called." nil nil)

;;;***

;;;### (autoloads (vc-update-change-log vc-cancel-version vc-revert-buffer vc-print-log vc-retrieve-snapshot vc-create-snapshot vc-directory vc-insert-headers vc-version-other-window vc-diff vc-register vc-next-action) "vc" "vc.el" (11495 462))
;;; Generated autoloads from vc.el

(defvar vc-checkin-hook nil "\
*List of functions called after a checkin is done.  See `run-hooks'.")

(autoload (quote vc-next-action) "vc" "\
Do the next logical checkin or checkout operation on the current file.
   If the file is not already registered, this registers it for version
control and then retrieves a writable, locked copy for editing.
   If the file is registered and not locked by anyone, this checks out
a writable and locked file ready for editing.
   If the file is checked out and locked by the calling user, this
first checks to see if the file has changed since checkout.  If not,
it performs a revert.
   If the file has been changed, this pops up a buffer for entry
of a log message; when the message has been entered, it checks in the
resulting changes along with the log message as change commentary.  If
the variable `vc-keep-workfiles' is non-nil (which is its default), a
read-only copy of the changed file is left in place afterwards.
   If the file is registered and locked by someone else, you are given
the option to steal the lock.
   If you call this from within a VC dired buffer with no files marked,
it will operate on the file in the current line.
   If you call this from within a VC dired buffer, and one or more
files are marked, it will accept a log message and then operate on
each one.  The log message will be used as a comment for any register
or checkin operations, but ignored when doing checkouts.  Attempted
lock steals will raise an error." t nil)

(autoload (quote vc-register) "vc" "\
Register the current file into your version-control system." t nil)

(autoload (quote vc-diff) "vc" "\
Display diffs between file versions.
Normally this compares the current file and buffer with the most recent 
checked in version of that file.  This uses no arguments.
With a prefix argument, it reads the file name to use
and two version designators specifying which versions to compare." t nil)

(autoload (quote vc-version-other-window) "vc" "\
Visit version REV of the current buffer in another window.
If the current buffer is named `F', the version is named `F.~REV~'.
If `F.~REV~' already exists, it is used instead of being re-created." t nil)

(autoload (quote vc-insert-headers) "vc" "\
Insert headers in a file for use with your version-control system.
Headers desired are inserted at the start of the buffer, and are pulled from
the variable `vc-header-alist'." t nil)

(autoload (quote vc-directory) "vc" "\
Show version-control status of all files under the current directory." t nil)

(autoload (quote vc-create-snapshot) "vc" "\
Make a snapshot called NAME.
The snapshot is made from all registered files at or below the current
directory.  For each file, the version level of its latest
version becomes part of the named configuration." t nil)

(autoload (quote vc-retrieve-snapshot) "vc" "\
Retrieve the snapshot called NAME.
This function fails if any files are locked at or below the current directory
Otherwise, all registered files are checked out (unlocked) at their version
levels in the snapshot." t nil)

(autoload (quote vc-print-log) "vc" "\
List the change log of the current buffer in a window." t nil)

(autoload (quote vc-revert-buffer) "vc" "\
Revert the current buffer's file back to the latest checked-in version.
This asks for confirmation if the buffer contents are not identical
to that version." t nil)

(autoload (quote vc-cancel-version) "vc" "\
Get rid of most recently checked in version of this file.
A prefix argument means do not revert the buffer afterwards." t nil)

(autoload (quote vc-update-change-log) "vc" "\
Find change log file and add entries from recent RCS logs.
The mark is left at the end of the text prepended to the change log.
With prefix arg of C-u, only find log entries for the current buffer's file.
With any numeric prefix arg, find log entries for all files currently visited.
Otherwise, find log entries for all registered files in the default directory.
From a program, any arguments are passed to the `rcs2log' script." t nil)

;;;***

;;;### (autoloads (vi-mode) "vi" "vi.el" (11285 51569))
;;; Generated autoloads from vi.el

(autoload (quote vi-mode) "vi" "\
Major mode that acts like the `vi' editor.
The purpose of this mode is to provide you the combined power of vi (namely,
the \"cross product\" effect of commands and repeat last changes) and Emacs.

This command redefines nearly all keys to look like vi commands.
It records the previous major mode, and any vi command for input
(`i', `a', `s', etc.) switches back to that mode.
Thus, ordinary Emacs (in whatever major mode you had been using)
is \"input\" mode as far as vi is concerned.

To get back into vi from \"input\" mode, you must issue this command again.
Therefore, it is recommended that you assign it to a key.

Major differences between this mode and real vi :

* Limitations and unsupported features
  - Search patterns with line offset (e.g. /pat/+3 or /pat/z.) are
    not supported.
  - Ex commands are not implemented; try ':' to get some hints.
  - No line undo (i.e. the 'U' command), but multi-undo is a standard feature.

* Modifications
  - The stopping positions for some point motion commands (word boundary,
    pattern search) are slightly different from standard 'vi'.
    Also, no automatic wrap around at end of buffer for pattern searching.
  - Since changes are done in two steps (deletion then insertion), you need
    to undo twice to completely undo a change command.  But this is not needed
    for undoing a repeated change command.
  - No need to set/unset 'magic', to search for a string with regular expr
    in it just put a prefix arg for the search commands.  Replace cmds too.
  - ^R is bound to incremental backward search, so use ^L to redraw screen.

* Extensions
  - Some standard (or modified) Emacs commands were integrated, such as
    incremental search, query replace, transpose objects, and keyboard macros.
  - In command state, ^X links to the 'ctl-x-map', and ESC can be linked to
    esc-map or set undefined.  These can give you the full power of Emacs.
  - See vi-com-map for those keys that are extensions to standard vi, e.g.
    `vi-name-last-change-or-macro', `vi-verify-spelling', `vi-locate-def',
    `vi-mark-region', and 'vi-quote-words'.  Some of them are quite handy.
  - Use \\[vi-switch-mode] to switch among different modes quickly.
  
Syntax table and abbrevs while in vi mode remain as they were in Emacs." t nil)

;;;***

;;;### (autoloads (view-mode view-buffer-other-window view-buffer view-file-other-window view-file) "view" "view.el" (11336 19791))
;;; Generated autoloads from view.el

(autoload (quote view-file) "view" "\
View FILE in View mode, returning to previous buffer when done.
The usual Emacs commands are not available; instead,
a special set of commands (mostly letters and punctuation)
are defined for moving around in the buffer.
Space scrolls forward, Delete scrolls backward.
For list of all View commands, type ? or h while viewing.

This command runs the normal hook `view-hook'." t nil)

(autoload (quote view-file-other-window) "view" "\
View FILE in View mode in other window.
Return to previous buffer when done.
The usual Emacs commands are not available; instead,
a special set of commands (mostly letters and punctuation)
are defined for moving around in the buffer.
Space scrolls forward, Delete scrolls backward.
For list of all View commands, type ? or h while viewing.

This command runs the normal hook `view-hook'." t nil)

(autoload (quote view-buffer) "view" "\
View BUFFER in View mode, returning to previous buffer when done.
The usual Emacs commands are not available; instead,
a special set of commands (mostly letters and punctuation)
are defined for moving around in the buffer.
Space scrolls forward, Delete scrolls backward.
For list of all View commands, type ? or h while viewing.

This command runs the normal hook `view-hook'." t nil)

(autoload (quote view-buffer-other-window) "view" "\
View BUFFER in View mode in another window,
returning to original buffer when done *only* if 
prefix argument NOT-RETURN is nil (which is the default).

The usual Emacs commands are not available in View mode; instead,
a special set of commands (mostly letters and punctuation)
are defined for moving around in the buffer.
Space scrolls forward, Delete scrolls backward.
For list of all View commands, type ? or h while viewing.

This command runs the normal hook `view-hook'." t nil)

(autoload (quote view-mode) "view" "\
Major mode for viewing text but not editing it.
Letters do not insert themselves.  Instead these commands are provided.
Most commands take prefix arguments.  Commands dealing with lines
default to \"scroll size\" lines (initially size of window).
Search commands default to a repeat count of one.
M-< or <	move to beginning of buffer.
M-> or >	move to end of buffer.
C-v or Space	scroll forward lines.
M-v or DEL	scroll backward lines.
CR or LF	scroll forward one line (backward with prefix argument).
z		like Space except set number of lines for further
		   scrolling commands to scroll by.
C-u and Digits	provide prefix arguments.  `-' denotes negative argument.
=		prints the current line number.
g		goes to line given by prefix argument.
/ or M-C-s	searches forward for regular expression
\\ or M-C-r	searches backward for regular expression.
n		searches forward for last regular expression.
p		searches backward for last regular expression.
C-@ or .	set the mark.
x		exchanges point and mark.
C-s or s	do forward incremental search.
C-r or r	do reverse incremental search.
@ or '		return to mark and pops mark ring.
		  Mark ring is pushed at start of every
		  successful search and when jump to line to occurs.
		  The mark is set on jump to buffer start or end.
? or h		provide help message (list of commands).
\\[Helper-help]		provides help (list of commands or description of a command).
C-n		moves down lines vertically.
C-p		moves upward lines vertically.
C-l		recenters the screen.
q or C-c	exit view-mode and return to previous buffer.

Entry to this mode runs the normal hook `view-hook'.

\\{view-mode-map}" nil nil)

;;;***

;;;### (autoloads (vip-mode) "vip" "vip.el" (11285 51578))
;;; Generated autoloads from vip.el

(autoload (quote vip-mode) "vip" "\
Turn on VIP emulation of VI." t nil)

;;;***

;;;### (autoloads (wordstar-mode) "ws-mode" "ws-mode.el" (11486 24343))
;;; Generated autoloads from ws-mode.el

(autoload (quote wordstar-mode) "ws-mode" "\
Major mode with WordStar-like key bindings.

BUGS:
 - Help menus with WordStar commands (C-j just calls help-for-help)
   are not implemented
 - Options for search and replace
 - Show markers (C-k h) is somewhat strange
 - Search and replace (C-q a) is only available in forward direction

No key bindings beginning with ESC are installed, they will work
Emacs-like.

The key bindings are:

  C-a		backward-word
  C-b		fill-paragraph
  C-c		scroll-up-line
  C-d		forward-char
  C-e		previous-line
  C-f		forward-word
  C-g		delete-char
  C-h		backward-char
  C-i		indent-for-tab-command
  C-j		help-for-help
  C-k		ordstar-C-k-map
  C-l		ws-repeat-search
  C-n		open-line
  C-p		quoted-insert
  C-r		scroll-down-line
  C-s		backward-char
  C-t		kill-word
  C-u		keyboard-quit
  C-v		overwrite-mode
  C-w		scroll-down
  C-x		next-line
  C-y		kill-complete-line
  C-z		scroll-up

  C-k 0		ws-set-marker-0
  C-k 1		ws-set-marker-1
  C-k 2		ws-set-marker-2
  C-k 3		ws-set-marker-3
  C-k 4		ws-set-marker-4
  C-k 5		ws-set-marker-5
  C-k 6		ws-set-marker-6
  C-k 7		ws-set-marker-7
  C-k 8		ws-set-marker-8
  C-k 9		ws-set-marker-9
  C-k b		ws-begin-block
  C-k c		ws-copy-block
  C-k d		save-buffers-kill-emacs
  C-k f		find-file
  C-k h		ws-show-markers
  C-k i		ws-indent-block
  C-k k		ws-end-block
  C-k p		ws-print-block
  C-k q		kill-emacs
  C-k r		insert-file
  C-k s		save-some-buffers
  C-k t		ws-mark-word
  C-k u		ws-exdent-block
  C-k C-u	keyboard-quit
  C-k v		ws-move-block
  C-k w		ws-write-block
  C-k x		kill-emacs
  C-k y		ws-delete-block

  C-o c		center-line
  C-o b		switch-to-buffer
  C-o j		justify-current-line
  C-o k		kill-buffer
  C-o l		list-buffers
  C-o m		auto-fill-mode
  C-o r		set-fill-column
  C-o C-u	keyboard-quit
  C-o wd	delete-other-windows
  C-o wh	split-window-horizontally
  C-o wo	other-window
  C-o wv	split-window-vertically

  C-q 0		ws-find-marker-0
  C-q 1		ws-find-marker-1
  C-q 2		ws-find-marker-2
  C-q 3		ws-find-marker-3
  C-q 4		ws-find-marker-4
  C-q 5		ws-find-marker-5
  C-q 6		ws-find-marker-6
  C-q 7		ws-find-marker-7
  C-q 8		ws-find-marker-8
  C-q 9		ws-find-marker-9
  C-q a		ws-query-replace
  C-q b		ws-to-block-begin
  C-q c		end-of-buffer
  C-q d		end-of-line
  C-q f		ws-search
  C-q k		ws-to-block-end
  C-q l		ws-undo
  C-q p		ws-last-cursorp
  C-q r		beginning-of-buffer
  C-q C-u	keyboard-quit
  C-q w		ws-last-error
  C-q y		ws-kill-eol
  C-q DEL	ws-kill-bol
" t nil)

;;;***

;;;### (autoloads (run-scheme) "xscheme" "xscheme.el" (11185 17047))
;;; Generated autoloads from xscheme.el

(autoload (quote run-scheme) "xscheme" "\
Run an inferior Scheme process.
Output goes to the buffer `*scheme*'.
With argument, asks for a command line." t nil)

;;;***

;;;### (autoloads (psychoanalyze-pinhead yow) "yow" "yow.el" (11285 51586))
;;; Generated autoloads from yow.el

(autoload (quote yow) "yow" "\
Return or display a random Zippy quotation." t nil)

(autoload (quote psychoanalyze-pinhead) "yow" "\
Zippy goes to the analyst." t nil)

;;;***

;;; Don't make backup versions of this file - most of it is generated
;;; automatically by autoload.el, and what isn't changes rarely.
;;; Local Variables:
;;; version-control: never
;;; no-byte-compile: t
;;; no-update-autoloads: t
;;; End:
;;; loaddefs.el ends here
