/*------------------------------------------------------------------
 * cposthdr.h : default postscript header for cPost output
 *------------------------------------------------------------------
 * 02-01-93 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

static char *Header_1[] =
   {
   "%%-----------------------------------------------------------------",
   "%% font names and sizes",
   "%%-----------------------------------------------------------------",
   "",
   "/Inch { 72    mul } def",
   "/Cm   { 28.35 mul } def",
   "/Mm   { 2.835 mul } def",
   "",
   "/nFontName /Courier              def % font name for normal text",
   "/kFontName /Times-BoldItalic     def % font name for keywords",
   "/iFontName /Courier              def % font name for identifiers",
   "/fFontName /Times-Bold           def % font name for functions",
   "/dFontName /Times-Bold           def % font name for function definitions",
   "/cFontName /Courier-Oblique      def % font name for comments",
   "/pFontName /Helvetica            def % font name for preprocessor",
   "/lFontName /Courier              def % font name for line numbers",
   "",
   "/nFontSize  8                    def % font size for normal text",
   "/kFontSize  8                    def % font size for keywords",
   "/iFontSize  8                    def % font size for identifiers",
   "/fFontSize 11                    def % font size for functions",
   "/dFontSize 11                    def % font size for function definitions",
   "/cFontSize  8                    def % font size for comments",
   "/pFontSize 11                    def % font size for preprocessor",
   "/lFontSize  7                    def % font size for line numbers",
   "",
   "%%-----------------------------------------------------------------",
   "%% colors",
   "%%-----------------------------------------------------------------",
   "/nColor [ 0 0 0 ]                def % color for normal text",
   "/kColor [ 0 0 0 ]                def % color for keywords",
   "/iColor [ 0 0 0 ]                def % color for identifiers",
   "/fColor [ 0 0 0 ]                def % color for functions",
   "/dColor [ 0 0 0 ]                def % color for function definitions",
   "/cColor [ 0 0 0 ]                def % color for comments",
   "/pColor [ 0 0 0 ]                def % color for preprocessor",
   "/lColor [ 0 0 0 ]                def % color for line numbers",
   "",
   "",
   "%%------------------------------------------------------------------",
   "%% page size, margin size",
   "%%------------------------------------------------------------------",
   "/pLength   11     Inch           def % page length",
   "/pWidth     8.5   Inch           def % page width",
   "",
   "/lMargin     .5   Inch           def % margin: left",
   "/rMargin     .5   Inch           def % margin: right",
   "/tMargin     .75  Inch           def % margin: top",
   "/bMargin     .75  Inch           def % margin: bottom",
   "",
   "%%------------------------------------------------------------------",
   "%% header (and footer) info",
   "%%------------------------------------------------------------------",
   "/yh1 pLength .65 Inch sub def",
   "/yh2 pLength .5  Inch sub def",
   "/yh3 .65  Inch def",
   "/yh4 .45  Inch def",
   "",
   "%%------------------------------------------------------------------",
   "%% print a header and footer for odd numbered pages",
   "%%------------------------------------------------------------------",
   "/header1",
   "   {",
   "   lColor aload pop setrgbcolor",
   "   newpath",
   "      lMargin            yh1 moveto",
   "      pWidth rMargin sub yh1 lineto",
   "   stroke",
   "",
   "   /Times-Roman findfont 14 scalefont setfont",
   "",
   "   lMargin yh2 moveto",
   "   currFunc show",
   "",
   "   /numberBuffer 10 string def",
   "   pWidth rMargin                           sub",
   "   pageNum numberBuffer cvs stringwidth pop sub",
   "   (page ) stringwidth pop                  sub",
   "   yh2 moveto",
   "   (page ) show numberBuffer show",
   "",
   "   newpath",
   "      lMargin yh3 moveto",
   "      pWidth rMargin sub yh3 lineto",
   "   stroke",
   "",
   "   /Helvetica findfont 7 scalefont setfont",
   "",
   "   lMargin yh4 moveto",
   "   (Print date: ) show",
   "   printDate show",
   "",
   "   lMargin 2 Inch add yh4 moveto",
   "   (File date: ) show",
   "   fileDateTime show",
   "",
   "   /Times-Roman findfont 14 scalefont setfont",
   "",
   "   pWidth rMargin           sub",
   "   fileName stringwidth pop sub",
   "",
   "   yh4 moveto",
   "   fileName show",
   "   }",
   "   def",
   "",
   "%%------------------------------------------------------------------",
   "%% print a header and footer for even numbered pages",
   "%%------------------------------------------------------------------",
   "/header2",
   "   {",
   "   lColor aload pop setrgbcolor",
   "   newpath",
   "      lMargin            yh1 moveto",
   "      pWidth rMargin sub yh1 lineto",
   "   stroke",
   "",
   "   /Times-Roman findfont 14 scalefont setfont",
   "",
   "   pWidth rMargin           sub",
   "   currFunc stringwidth pop sub",
   "   yh2 moveto",
   "   currFunc show",
   "",
   "   /numberBuffer 10 string def",
   "   pageNum numberBuffer cvs pop",
   "   lMargin yh2 moveto",
   "   (page ) show numberBuffer show",
   "",
   "   newpath",
   "      lMargin yh3 moveto",
   "      pWidth rMargin sub yh3 lineto",
   "   stroke",
   "",
   "   /Helvetica findfont 7 scalefont setfont",
   "",
   "   4 Inch yh4 moveto",
   "   (Print date: ) show",
   "   printDate show",
   "",
   "   6 Inch yh4 moveto",
   "   (File date: ) show",
   "   fileDateTime show",
   "",
   "   /Times-Roman findfont 14 scalefont setfont",
   "",
   "   lMargin yh4 moveto",
   "   fileName show",
   "   }",
   "   def",
   "",
   "%%------------------------------------------------------------------",
   "%% user defined from imbed file",
   "%%------------------------------------------------------------------",
   "",
   };

static char *Header_2[] =
   {
   "",
   "%%------------------------------------------------------------------",
   "%% define actual header procs to use",
   "%%------------------------------------------------------------------",
   "/Header1 { header1 } def",
   "/Header2 { oDuplex { header2 } { header1 } ifelse } def",
   "",
   "%%------------------------------------------------------------------",
   "%% define our fonts to shorter names",
   "%%------------------------------------------------------------------",
   "/nFont nFontName findfont nFontSize scalefont def",
   "/kFont kFontName findfont kFontSize scalefont def",
   "/iFont iFontName findfont iFontSize scalefont def",
   "/fFont fFontName findfont fFontSize scalefont def",
   "/dFont dFontName findfont dFontSize scalefont def",
   "/cFont cFontName findfont cFontSize scalefont def",
   "/pFont pFontName findfont pFontSize scalefont def",
   "/lFont lFontName findfont lFontSize scalefont def",
   "",
   "%%------------------------------------------------------------------",
   "%% define our fonts to REAL short names",
   "%%------------------------------------------------------------------",
   "/n { nColor nFont nFontSize } def",
   "/k { kColor kFont kFontSize } def",
   "/i { iColor iFont iFontSize } def",
   "/f { fColor fFont fFontSize } def",
   "/d { dColor dFont dFontSize } def",
   "/c { cColor cFont cFontSize } def",
   "/p { pColor pFont pFontSize } def",
   "/l { lColor lFont lFontSize } def",
   "",
   "%%-----------------------------------------------------------------",
   "%% max function",
   "%%-----------------------------------------------------------------",
   "/max",
   "   {",
   "   2 copy",
   "   lt { exch } if",
   "   pop",
   "   } def",
   "",
   "%%-----------------------------------------------------------------",
   "%% maximum line height",
   "%%-----------------------------------------------------------------",
   "/maxLineHeight",
   "   nFontSize",
   "   kFontSize max",
   "   iFontSize max",
   "   fFontSize max",
   "   dFontSize max",
   "   cFontSize max",
   "   pFontSize max",
   "   lFontSize max",
   "   def",
   "",
   "%%------------------------------------------------------------------",
   "%% see if x lines will fit on the page",
   "%%------------------------------------------------------------------",
   "/linesFit",
   "   {",
   "   maxLineHeight mul currY exch sub bMargin sub",
   "   0 lt",
   "   { showPage } if",
   "   } def",
   "",
   "%%-----------------------------------------------------------------",
   "%% print stack",
   "%%-----------------------------------------------------------------",
   "/Stack",
   "   {",
   "   (stack(bottom->top)) print <0D0A> print",
   "   pstack",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% width of one space in normal font",
   "%%------------------------------------------------------------------",
   "/spaceWidth",
   "   nFont setfont ( ) stringwidth pop",
   "   def",
   "",
   "%%------------------------------------------------------------------",
   "%% width of line number information",
   "%%------------------------------------------------------------------",
   "/lineNoWidth",
   "   oNumber",
   "      { lFont setfont (12345678) stringwidth pop }",
   "      { 0 }",
   "      ifelse",
   "   def",
   "",
   "%%------------------------------------------------------------------",
   "%% take a column, return an X offset from left margin",
   "%%------------------------------------------------------------------",
   "/getXfromCol",
   "   {",
   "   spaceWidth mul                % size of column number of spaces",
   "   lMargin  lineNoWidth add add  % left margin and size of line no info",
   "   spaceWidth oSpace mul add     % add spaces",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% given the text/font array from showLine, calculate line height",
   "%%------------------------------------------------------------------",
   "/calcLineHeight",
   "   {",
   "   /lineHeight lFontSize def",
   "",
   "   lineArray aload",
   "",
   "   length 4 idiv",
   "      {",
   "      pop",
   "      pop",
   "",
   "      dup",
   "      lineHeight gt",
   "         {",
   "         /lineHeight exch def",
   "         }",
   "         {",
   "         pop",
   "         } ifelse",
   "",
   "      pop",
   "      } repeat",
   "",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% reverse contents of an array",
   "%%------------------------------------------------------------------",
   "/reverseLineArray",
   "   {",
   "",
   "   /Ind1 0                 def",
   "   /Ind2 numElements 1 sub def",
   "",
   "   numElements 2 idiv",
   "      {",
   "      /Item1 lineArray Ind1 get def",
   "      /Item2 lineArray Ind2 get def",
   "",
   "      lineArray Ind1 Item2 put",
   "      lineArray Ind2 Item1 put",
   "",
   "      /Ind1 Ind1 1 add def",
   "      /Ind2 Ind2 1 sub def",
   "      } repeat",
   "",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% given an array of text/font info, print it",
   "%%------------------------------------------------------------------",
   "/showLine",
   "   {",
   "   /lineArray exch def",
   "   /numElements lineArray length def",
   "",
   "   reverseLineArray",
   "",
   "   calcLineHeight",
   "",
   "   currY lineHeight sub bMargin le",
   "      {",
   "      showPage",
   "      } if",
   "",
   "   /currY currY lineHeight sub def",
   "",
   "",
   "   oNumber",
   "      {",
   "      lColor aload pop setrgbcolor",
   "      lMargin currY moveto",
   "",
   "      lFont setfont",
   "",
   "      /numberBuffer 8 string def",
   "      lineNum numberBuffer cvs stringwidth pop",
   "      lineNoWidth exch sub 0 rmoveto",
   "",
   "      numberBuffer show",
   "      } if",
   "",
   "   0 getXfromCol currY moveto",
   "",
   "   lineArray aload pop",
   "",
   "   numElements 4 idiv",
   "     {",
   "     aload pop setrgbcolor",
   "     setfont",
   "     pop",
   "     show",
   "     } repeat",
   "",
   "   /lineNum lineNum 1 add def",
   "",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% end of page reached",
   "%%------------------------------------------------------------------",
   "/showPage",
   "   {",
   "   pageNum 2 mod 1 eq { Header1 } { Header2 } ifelse",
   "   showpage",
   "   oXlate",
   "   /pageNum pageNum 1 add def",
   "   /currY pLength tMargin sub def",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% start a new source file",
   "%%------------------------------------------------------------------",
   "/startFile",
   "   {",
   "   /fileDateTime exch def",
   "   /fileName     exch def",
   "   /pageNum         1 def",
   "   /lineNum         1 def",
   "   /currFunc       () def",
   "   /currY     pLength tMargin sub def",
   "   oXlate",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% end a source file",
   "%%------------------------------------------------------------------",
   "/endFile",
   "   {",
   "   oDuplex { pageNum 2 mod 1 eq { showPage } if } if",
   "   showPage",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% middle bracket",
   "%%------------------------------------------------------------------",
   "/mB",
   "   {",
   "   1 sub getXfromCol /currX exch def",
   "   gsave",
   "   newpath",
   "",
   "   currX currY moveto",
   "   0 lineHeight rlineto",
   "",
   "   .2 setlinewidth",
   "   stroke",
   "   grestore",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% upper bracket",
   "%%------------------------------------------------------------------",
   "/uB",
   "   {",
   "   1 sub getXfromCol /currX exch def",
   "   gsave",
   "   newpath",
   "",
   "   currX currY moveto",
   "",
   "   currX                currY lineHeight .4 mul add",
   "   currX spaceWidth add currY lineHeight .4 mul add",
   "   spaceWidth 2 div arcto 4 { pop } repeat",
   "",
   "   .2 setlinewidth",
   "   stroke",
   "   grestore",
   "   } def",
   "",
   "%%------------------------------------------------------------------",
   "%% lower bracket",
   "%%------------------------------------------------------------------",
   "/lB",
   "   {",
   "   1 sub getXfromCol /currX exch def",
   "   gsave",
   "   newpath",
   "",
   "   currX currY lineHeight add moveto",
   "",
   "   currX                currY lineHeight .4 mul add",
   "   currX spaceWidth add currY lineHeight .4 mul add",
   "   spaceWidth 2 div arcto 4 { pop } repeat",
   "",
   "   .2 setlinewidth",
   "   stroke",
   "   grestore",
   "   } def",
   "",
   "%%-----------------------------------------------------------------",
   "%% now the actual file data",
   "%%-----------------------------------------------------------------",
   };
