EXTPROC CEnvi
/*******************************************************************
 *** Terminal.cmd - Simple terminal, sample demonstration of the ***
 *** ver.1          Comm.lib serial communications library       ***
 *******************************************************************/

CommPortName = "COM2";  // Set this to your valid port

#include <FileIO.lib>
#include <DevIOCTL.lib>
#include <Comm.lib>

// Open (try) the port
   printf("Opening port \"%s\"...",CommPortName);
   CommHandle = CommOpen(CommPortName,Error);

   if ( NULL == CommHandle ) {
      printf("\n\aError %d: Unable to open port \"%s\"\n",Error,CommPortName);
      printf("Press any key to exit...");
      getch();
   } else {

      printf("\nComm port is open. You are in Terminal mode.  Press ALT-X to  quit\n");

      // Set up routine to Close port in case of sudden program exit
      atexit("CloseCommHandle");

      for ( ; ; ) {  // forever

         // Read whatever characters are in keyboard into a buffer
         if ( 0 != (key = GetKey()) ) {
            WriteLen = 0;
            do {
               WriteBuf[WriteLen++] = byte(key);
            } while( 0 != (key = GetKey()) );
            // write characters from buffer to comm port
            if ( 0 != CommWrite(CommHandle,WriteBuf,WriteLen,BytesWritten)
              || BytesWritten != WriteLen )
               printf("\n\aWrite Error\n");
         }

         // If any bytes available, then write to the screen
         if ( 0 != (ReadError = CommRead(CommHandle,ReadBuf,200,BytesRead)) )
            printf("\n\aRead Error %d\n",ReadError);
         if ( BytesRead )
            fwrite(ReadBuf,BytesRead,stdout);
      }

   }


// Routine to get keyboard keys, and skip weird ones; Exit with ALT_X
   GetKey()
   {
      if ( kbhit() ) {
         c = getch();
         if ( 0 == c ) {
            #define ALTX_CODE 0x2D
            if ( ALTX_CODE == getch() )
               exit(EXIT_SUCCESS);
         }
      } else
         c = 0;
      return c;
   }


// This routine will be called to close port when program terminates
   CloseCommHandle()
   {
      CommClose(CommHandle);
   }


