@ECHO OFF
REM *************************************************************
REM *** OS2DEMO.CMD - Unattended demo script for showing off  ***
REM *** ver.1         the powers of OS/2 running Windows, DOS ***
REM ***               and PM programs. Thanks to Bob Weeks    ***
REM ***               for the idea.                           ***
REM *************************************************************

::***************************************************************************
::***                   START OF CONFIGURATION SECTION
::***
::*** 1) Set the following GRAPHIC_PROGRAM_SPEC to specify a DOS program
::***    that runs at hi-resolution and looks good in a DOS box.
::***    If you can't think of something then just use COMMAND.COM.
  SET GRAPHIC_PROGRAM_SPEC=E:\Personal\AcidWarp.exe
::***
::*** 2) During the demo, a coach window always shows at the bottom of
::***    the screen.  In the following lines, specify the the size of
::***    the font for that window (use a valid font size) and change
::***    the number of lines showing if you wish.
  SET COACH_FONTSIZE=30x12
  SET COACH_LINECOUNT=2
::***
::*** 3) The fancier Windows parts of this demo must communicate with
::***    multiple windows session using Nombas' CEnvi for Windows.
::***    If you don't already have CEnvi for Windows then you can
::***    probably download the software from wherever you got CEnvi
::***    for OS/2. If you register CEnvi for OS/2 then you also get
::***    CEnvi for Windows.  Contact Nombas is you need more help.
::***    Using CEnvi for Windows, you next need to create the
::***    ServeOS2.exe program.  To do this start windows, run
::***    CEnvi.exe, and at the CEnvi prompt enter:
::***           /BIND=ServeOS2 ServeOS2
::***    This will create the ServeOS2.exe file.  In the following
::***    line, set the SERVEOS2_SPEC variable to the location of
::***    the ServeOS2.exe executable.
  SET SERVEOS2_SPEC=ServeOS2.exe
::***
::*** 4) This demo does some pretty fancy stuff, with complicated
::***    interactions between parts, and so it is not unreasonable
::***    to expect it to get "stuck" now and then.  (On the latest
::***    test on my system, which was also running a BBS at the same
::***    time as this demo, the demo ran for about 200 repetitions
::***    before it got stuck when a Windows applications had a GPF
::***    in the wrong place.  If you want the computer to reboot
::***    if anything goes wrong with the demo (for example, if the
::***    demo is to run unattended in a store, and the computer runs
::***    OS2DEMO.CMD when it reboots) then uncomment the following
::***    line.  DEMO_HUNG_REBOOT_TIMEOUT, if it exists in the
::***    environment block, specifies how many minutes the computer
::***    must appear to be hung (the focus window stops changing) before
::***    the computer reboots itself.  Warning: the computer doesn't
::***    do a controlled shutdown, but simplu mimics ctrl-alt-del.  This
::***    is very unlikely to cause any problems after minutes of the
::***    computer doing nothing.
 REM SET DEMO_HUNG_REBOOT_TIMEOUT=3
::***
::*** 5) If you are experiencing periodic hangs of this DEMO, then
::***    it is useful to have some idea later about where the demo
::***    stopped running.  If you uncomment the following line and
::***    set it to specify a log file, then some information will be
::***    stored in the file to examine for the state of OS2DEMO.CMD
::***    to know where it hung.
 REM SET OS2DEMO_LOGFILE=C:\OS2DEMO.LOG
::***
::*** 6) This is not necessary, but to make the Windows section of this
::***    demo look its best, you should start Windows and configure the
::***    CLOCK so that it is analog with seconds showing, the CALCULATOR
::***    so that is is in standard and not scientific mode, and the
::***    NOTEPAD so that the text is readable
::***
::*** 7) Register CEnvi.  Otherwise, this demo will occasionally get
::***    halted by a "PLEASE REGISTER, I NEED THE MONEY" message, which
::***    does not make for an impressive demo.
::***
::*** 8) Put a "REM" in front of the following line to avoid jumping to
::***    the "please configure" message
 REM GOTO CONFIGURED
::***
::***                    END OF CONFIGURATION SECTION
::***************************************************************************

ECHO OS2DEMO: This is a very comprehensive stand-alone demo of
ECHO          OS2. Before using this demo you should edit this
ECHO          OS2Demo.cmd file and check the settings in the
ECHO          Configuration section. After OS2Demo.cmd has been
ECHO          edited then run it again to amaze your family and
ECHO          friends.
PAUSE
EXIT


:CONFIGURED
IF "%1" == "CALLING_MYSELF" GOTO CALLING_MYSELF

REM *** KILL ANY SESSIONS WE MAY HAVE LEFT RUNNING
call kill "OS/2 Demo"
call kill "One DOS Session"
call kill "Another DOS Session"
call kill "OS2DEMO.BAT"
call kill "Session:ServeOS2"
call kill "OS2Demo Rebooter"

CALL SESSION.CMD /Title "OS/2 Demo" /F /WIN /MAX /FONT %COACH_FONTSIZE% %COMSPEC% /C %0 CALLING_MYSELF

EXIT

:CALLING_MYSELF
REM **********************************************************
REM *** This section is called by the first pass, but will ***
REM *** have a better title and bigger font size, and put  ***
REM *** this screen in lower right corner of the screen    ***
REM **********************************************************

REM Make this window take up few lines only in
mode 80,%COACH_LINECOUNT%
call winset "OS/2 Demo" BIGGEST
call winset "OS/2 Demo" BIGGEST

REM CEnvi script to move this window to the lower right corner of the screen
CEnvi #include '%0,cmd,,GOTO END_LOWER_RIGHT,:END_LOWER_RIGHT'
GOTO END_LOWER_RIGHT

   // Move this window to lower right corner of screen
   #include "WinTools.lib"

   suspend(1000);
   GetScreenSize(ScreenWidth,ScreenHeight);
   GetSize(Info().WinHandle,MyWidth,MyHeight);
   SetPosition(Info().WinHandle,ScreenWidth - MyWidth,0);
   suspend(2000);

:END_LOWER_RIGHT

REM ****************************************************************
REM *** HUNG_REBOOT: If the DEMO_HUNG_REBOOT_TIMEOUT environment ***
REM *** variable was specified then start a hidden background    ***
REM *** session that will reboot the computer if the window      ***
REM *** focus stops changing                                     ***
REM ****************************************************************

IF ""=="%DEMO_HUNG_REBOOT_TIMEOUT%" GOTO END_HUNG_REBOOT
CALL SESSION.CMD /Title "OS2Demo Rebooter" /B /FS /HID CEnvi.exe #include '%0,CMD,,GOTO END_HUNG_REBOOT,:END_HUNG_REBOOT' RebootIfHung(%DEMO_HUNG_REBOOT_TIMEOUT%)
GOTO END_HUNG_REBOOT

#define SUSPEND_BETWEEN_CHECKS   10 // approx. seconds between checks

RebootIfHung(MinutesToTimeout)
{
   MillisecondSuspend = 1000 * SUSPEND_BETWEEN_CHECKS;
   SecondsToTimeout = 60 * MinutesToTimeout;
   PreviousFocusWindow = GetFocus();
   TimeOfLastFocusChange = time();

   for ( ; ; ) {
      suspend(MillisecondSuspend);
      if ( (FocusWindow = GetFocus()) != PreviousFocusWindow ) {
         // focus window has changed. Good!
         TimeOfLastFocusChange = time();
         PreviousFocusWindow = FocusWindow;
      } else {
         // focus window has not changed
         if ( SecondsToTimeout < difftime(time(),TimeOfLastFocusChange) ) {
            RebootSystemEEEEK();
         }
      }
   }
}

GetFocus()
{
   #define HWND_DESKTOP 1
   #define ORD_WIN32QUERYFOCUS   817
   return DynamicLink("PMWIN",ORD_WIN32QUERYFOCUS,BIT32,CDECL,HWND_DESKTOP);
}

RebootSystemEEEEK()
{
   #define ORD_DOS32OPEN   273
   #define FILE_NORMAL     0x0000
   #define FILE_OPEN       0x0001
   #define OPEN_SHARE_DENYNONE      0x0040
   #define OPEN_ACCESS_READWRITE    0x0002
   if ( !DynamicLink("doscalls",ORD_DOS32OPEN,BIT32,CDECL,
                     "\\DEV\\DOS$",FileHandle,ActionTaken,0,
                     FILE_NORMAL,FILE_OPEN,
                     OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,0) ) {

      #define ORD_DOS32DEVIOCTL     284
      #define CATEGORY_DOSSYS       0xD5
      #define FUNCTION_REBOOT       0xAB
      DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
                  FileHandle,CATEGORY_DOSSYS,FUNCTION_REBOOT,
                  NULL,0,NULL,NULL,0,NULL);

      #define ORD_DOS32CLOSE  257
      DynamicLink("doscalls",ORD_DOS32CLOSE,BIT32,CDECL,FileHandle);
   }
}

:END_HUNG_REBOOT

REM *************************************************************
REM *** STAY ON TOP: will now run code to stay on top, and    ***
REM *** spawn a new CMD.EXE to continue with this batch file  ***
REM *************************************************************

SET OS2DEMO_FILESPEC=%0
SET DELDIR=
CEnvi.exe #include '%0,cmd,,GOTO END_STAY_ON_TOP,:END_STAY_ON_TOP'
GOTO END_STAY_ON_TOP

   #define ON_TOP_DELAY 1800
   sprintf(SpawnCommand,"%s /C CEnvi #include \'%s,CMD,,AUTOMATED_SCRIPT_AT_LAST\' RunForever()",
           defined(OS2_SHELL) ? OS2_SHELL : "CMD.EXE",OS2DEMO_FILESPEC);
   CmdChildID = spawn(P_NOWAIT,SpawnCommand);

   while ( ValidProcessID(CmdChildID) ) {
      PutMyselfOnTop();
      suspend(ON_TOP_DELAY);
   }
 
   ValidProcessID(id)   // return TRUE if this ID is OK
   {
      if ( pList = ProcessList(False) ) {
         for ( li = GetArraySpan(pList); 0 <= li; li-- ) {
            if ( id == pList[li].id )
               return(True);
         }
      }
      return False;
   }

   SetWindowPos(pHandle,pBehindHandle,pColumn,pRow,pWidth,pHeight,pFlags)
   {
      #define ORD_WIN32SETWINDOWPOS 875
      PMDynamicLink("PMWIN",ORD_WIN32SETWINDOWPOS,BIT32,CDECL,
                    pHandle,pBehindHandle,pColumn,pRow,pWidth,pHeight,pFlags);
   }

   PutMyselfOnTop()
   {
      #define HWND_TOP     3
      #define SWP_ZORDER   4
      SetWindowPos(Info().WinHandle,HWND_TOP,0,0,0,0,SWP_ZORDER);
   }

:END_STAY_ON_TOP
CEnvi printf('\a\a\a\a\a\a\a\a\a\a'); getch();
EXIT


AUTOMATED_SCRIPT_AT_LAST
//***********************************************************************
//***********************************************************************
//************************                       ************************
//************************  FINALLY! THE SCRIPT  ************************
//************************                       ************************
//***********************************************************************
//***********************************************************************

#include <WinTools.lib>
#include <Dos_Boss.lib>
#include <Win_Boss.lib>
#include <KeyPush.lib>

/*************** MANY DOS SESSIONS ***************/
ManyDosSessions()
{
   LogHere("ManyDosSession()");
   SetWindowTitle(Info().WinHandle,"OS/2 Demo: MULTIPLE SIMULTANEOUS DOS SESSIONS");

   EraseScreen();
   printf("With OS/2, you can run as many DOS sessions in as many different ways\n"
          "as you want.  ALL AT THE SAME TIME!!!");

   // Make a batch file for the DOS commands, and the GO file
   lFp = fopen("C:\\OS2DEMO.BAT","wt");
   fprintf(lFp,":AGAIN\n");
   fprintf(lFp,"DIR /On\n");
   fprintf(lFp,"CLS\n");
   fprintf(lFp,"TYPE C:\\AUTOEXEC.BAT\n");
   fprintf(lFp,"C:\n");
   fprintf(lFp,"CD OS2\n");
   fprintf(lFp,"DIR *.EXE /W\n");
   fprintf(lFp,"CD \\\n");
   fprintf(lFp,"SET\n");
   fprintf(lFp,"ver\n");
   fprintf(lFp,"@IF EXIST C:\\OS2DEMO.GO GOTO AGAIN\n");
   fprintf(lFp,"EXIT\n");
   fclose(lFp);
   fclose(fopen("C:\\OS2DEMO.GO","w"));

   // start two DOS sessions
   RestoreDefaultDOSSettings();
   QCall("session_cmd", "/TITLE", "Another DOS session", "/F", "/WIN", "/DOS", "/FONT", "8x8",
         "/SET", "IDLE_SECONDS=0", "/SET", "IDLE_SENSITIVITY=40" );
   AnotherHwnd = GetWindowHandle("Another DOS session");
   QCall("session_cmd", "/TITLE", "One DOS session", "/F", "/WIN", "/DOS", "/FONT", "16x8",
         "/SET", "IDLE_SECONDS=0", "/SET", "IDLE_SENSITIVITY=40" );
   OneHwnd = GetWindowHandle("One DOS session");

   // Start DOS windows 25-line mode
   PasteToDOSWindow("One DOS session","mode 80,25\rcls\r");
   PasteToDOSWindow("Another DOS session","mode 80,25\rcls\r");
   WaitSeconds(3);

   // adjust one DOS window in upper-right edge of screen
   ShowWindow(OneHwnd,SW_SHOWMAXNOACTIVE);
   GetSize(OneHwnd,width,height);
   SetPosition(OneHwnd,ScreenWidth-width,ScreenHeight-height);

   // adjust other DOS window so it's near left and just above this one
   SetPosition(AnotherHwnd,12,MyHeight - 2);

   // Tell each DOS session to run the batch file
   PasteToDOSWindow("One DOS session","C:\\OS2DEMO.BAT\r");
   PasteToDOSWindow("Another DOS session","C:\\OS2DEMO.BAT\r");

   WaitSeconds(1);
   SetWindowTitle(OneHwnd,"One DOS Session");
   SetWindowTitle(AnotherHwnd,"Another DOS Session");


   WaitSeconds(20);

   sprintf(lPosition,"%d,%d",ScreenWidth/10,ScreenHeight/4);
   RestoreDefaultDOSSettings()
   QCall("session_cmd", "/TITLE", "Hi-res graphics session", "/F", "/POS", lPosition, "/WIN", "/DOS",
         "/SET", "IDLE_SECONDS=0", "/SET", "IDLE_SENSITIVITY=100",
         "/SET", "HW_TIMER=1", "/SET", "VIDEO_8514A_XGA_IOTRAP=1",
         GRAPHIC_PROGRAM_SPEC);
   printf("  Including hi-res graphics...");

   WaitSeconds(20);

   EraseScreen();
   printf("The DOS sessions may be windowed, as you see here\n"
          "or they may be full screen...");
   WaitSeconds(1);
   QCall( "domenu_cmd", "Hi-res graphics session", "Full-screen" );

   // also tell the other DOS windows to go away
   // tell both DOS sessions to exit
   WaitSeconds(4);
   printf("  or windowed again.");
   QCall( "switch_cmd", "OS/2 Demo" );
   QCall( "domenu_cmd", "Hi-res graphics session", "Windowed" );
   WaitSeconds(5);

   QCall( "kill_cmd", "Hi-res graphics session");
   EraseScreen();
   printf("Give these DOS sessions a moment to exit...");
   remove("C:\\OS2DEMO.GO");

   // Wait up to 20 seconds for these sessions to exit
   StartTime = time();
   while ( (IsWindow(OneHwnd) || IsWindow(AnotherHwnd))
        && difftime(time(),StartTime) < 20 )
      suspend(100);
   // kill the windows just in case they're not already dead
   QCall( "kill_cmd", "One DOS Session" );
   QCall( "kill_cmd", "Another DOS Session" );
   remove("C:\\OS2DEMO.BAT");
}

/*************** MANY WINDOWS SESSIONS ***************/

NombasAdvertisement =
   "MEMO\rTo: All personnel\r\r"
   "I just saw an amazing computer demo. The automated demo was controlled "
   "by a program called CEnvi, from Nombas, for OS/2, DOS, and Windows.\r\r"
   "We need CEnvi NOW! Contact:\r"
   "   Nombas\r"
   "   P.O. Box 875\r"
   "   Medford, MA 02155\r\r"
   "CEnvi interprets the simple yet powerful Cmm language for our OS/2, DOS, "
   "and Windows systems. CEnvi also creates hundreds of the simplest "
   "programs you ever saw.  Our problems are solved by CEnvi: The Mother of "
   "All Utilities!\r\r"
   "I just can't say enough about Nombas' CEnvi. It's a scripting language, "
   "a programmer's toolbox, a glue to connect all applications and operating "
   "systems, and CEnvi (\'C\' Envy) is a catchy name.\r\r"
   "IS and PC experts don't have to waste time anymore "
   "customizing all of our computer systems, as now they can write simple "
   "CEnvi scripts for every system, and customize them for each system.\r\r"
   "Call Nombas: (617)391-6595 and get us a good deal on CEnvi for all "
   "our systems all over the world.\r\r"
   "Also, tell our application programmers to stop fiddling with their "
   "internal macro language and use Nombas Cmm-interpreter.\r\r"
   "Somebody get me a cheesburger!";


ManyWindowsSessions()
{
   LogHere("ManyWindowsSessions()");
   // start two ServeOS2 sessions to wait for our calls
   RestoreDefaultDOSSettings();

   SetWindowTitle(Info().WinHandle,"OS/2 Demo: MULTIPLE SIMULTANEOUS WINDOWS SESSIONS");
   EraseScreen();
   printf("OS/2 supports your Windows applications.");
   QCall("session_cmd", "/W", "/WIN", "/SEP",
         "/SET", "IDLE_SECONDS=2", "/SET", "IDLE_SENSITIVITY=75",
         "/SET", "DPMI_MEMORY_LIMIT=7",
         SERVEOS2_SPEC, "/NAME", "Right", "/DELAY", "500" );
   printf("\b,\nand OS/2 supports more Windows applications");
   while ( !WinBossSelect("Right") ) suspend(800);
   printf(", better,");

   // get the process ID of this session, so we can kill it later
   lSwitchList = WinQuerySwitchList(Info().hab);
   lSwitchCount = 1 + GetArraySpan(lSwitchList);
   RightProcessID = 0;
   for ( li = 0; li < lSwitchCount; li++ ) {
      if ( 0 == WinQuerySwitchEntry(lSwitchList[li],lSwEntry)
        && lSwEntry.title  &&  !stricmp(lSwEntry.title,"Session:ServeOS2.exe") ) {
         RightProcessID = lSwEntry.process;
         break;
      }
   }

   printf("\nthan ANY other operating system...");
   QCall("session_cmd", "/W", "/WIN", "/SEP", "/ENH",
         "/SET", "DPMI_MEMORY_LIMIT=4",
         "/SET", "IDLE_SECONDS=2", "/SET", "IDLE_SENSITIVITY=75",
         SERVEOS2_SPEC, "/NAME", "Left", "/DELAY", "500" );
   printf("\b\b\b - bar none!");
   while ( !WinBossSelect("Left") ) suspend(800);

   EraseScreen();
   printf("With OS/2, you can run MULTIPLE copies of Windows 3.x sessions.");

   // start clock in left session at top, in middle
   LClockWidth = LClockHeight = ScreenHeight / 4;
   LClockLeft = (ScreenWidth/2-LClockWidth)/2;
   LClockTop = ScreenHeight / 14;
   LClockRight = LClockLeft + LClockWidth;
   LClockBottom = LClockTop + LClockHeight;
   WinBossSelect("Left");
   if ( !WinFunction("spawn",LeftClockHandle,P_NOWAIT,"Clock.exe") )
      FatalError("Unable to start clock.");
   WinVoidFunction("SetWindowRect",LeftClockHandle,LClockLeft,LClockTop,LClockRight,LClockBottom);
 
   // start bigger clock on right
   RClockWidth = RClockHeight = ScreenHeight / 3;
   RClockLeft = ScreenWidth/2+(ScreenWidth/2-RClockWidth)/2;
   RClockTop = LClockTop;
   RClockRight = RClockLeft + RClockWidth;
   RClockBottom = RClockTop + RClockHeight;
   WinBossSelect("Right");
   if ( !WinFunction("spawn",RightClockHandle,P_NOWAIT,"Clock.exe") )
      FatalError("Unable to start clock.");
   WinVoidFunction("SetWindowRect",RightClockHandle,RClockLeft,RClockTop,RClockRight,RClockBottom);

   printf("\nSuch as these two Windows clocks, each in its own separate session.");
   WaitSeconds(13);

   // show that each different session is in a diff. mode with diff. settings
   EraseScreen();
   printf("Like DOS sessions under OS/2, each Windows session can have any configuration.");
   WinVoidFunction("KeyPushFocusID",0);
   WinVoidFunction("KeyStroke",WVK_ALT,'S');
   WinVoidFunction("KeyStroke",WVK_UP);
   WinVoidFunction("KeyStroke",WVK_RETURN);
   printf("\nOn the right: Standard mode with 7 megabytes of memory.");
   WaitSeconds(4);

   WinBossSelect("Left");
   WinVoidFunction("SetActiveWindow",LeftClockHandle);
   WinVoidFunction("KeyPushFocusID",0);
   WinVoidFunction("KeyStroke",WVK_ALT,'S');
   WinVoidFunction("KeyStroke",WVK_UP);
   WinVoidFunction("KeyStroke",WVK_RETURN);
   printf("\nOn the left: Enhanced mode with 4 megabytes of memory.");
   WaitSeconds(7);
   WinVoidFunction("KeyStroke",WVK_SPACE);
 
   WinBossSelect("Right");
   WinVoidFunction("SetActiveWindow","About Clock");
   WinVoidFunction("KeyStroke",WVK_SPACE);
   WaitSeconds(3);

   EraseScreen();
   printf("Each separate, seamless Windows session is just like one single Windows 3.x\n"
          "running under DOS.");

   // Start Program Manager on the left and right, but with clock on top.  These
   // program managers will fill up most of the screen side by side
   ProgManWidth = ScreenWidth / 2 - ScreenWidth / 25;
   ProgManTop = 0;
   ProgManHeight = ScreenHeight - MyHeight - 20;
   LProgmanLeft = ((ScreenWidth/2)-ProgManWidth)/2;
   RProgmanLeft = ScreenWidth/2 + lProgmanLeft;
   if ( !WinFunction("spawn",RightProgmanHandle,P_NOWAIT,"Progman.exe") )
      FatalError("Unable to start right progman.");
   WinVoidFunction("SetWindowRect",RightProgmanHandle,
                   RProgmanLeft,ProgManTop,RProgmanLeft+ProgManWidth,ProgManTop+ProgManHeight);
   WinVoidFunction("SetActiveWindow",RightClockHandle);

   // program manager on the left
   WinBossSelect("Left");
   if ( !WinFunction("spawn",LeftProgmanHandle,P_NOWAIT,"Progman.exe") )
      FatalError("Unable to start left progman.");
   WinVoidFunction("SetWindowRect",LeftProgmanHandle,
                   LProgmanLeft,ProgManTop,LProgmanLeft+ProgManWidth,ProgManTop+ProgManHeight);
   WinVoidFunction("SetActiveWindow",LeftClockHandle);

   // start Notepad.exe on the left side, bleeding a little onto the right
   if ( !WinFunction("spawn",NotepadHandle,P_NOWAIT,"NotePad.exe") )
      FatalError("Unable to start notepad.exe.");
   NotepadTop = LClockBottom - 8;
   NotepadLeft = 0;
   NotepadRight = (ScreenWidth / 2) - (ScreenWidth / 20);
   NotepadBottom = ScreenHeight - MyHeight + 5;
   WinVoidFunction("SetWindowRect",NotepadHandle,NotepadLeft,NotepadTop,NotepadRight,NotepadBottom);

   WinBossSelect("Right");
   if ( !WinFunction("spawn",RightCalcHandle,P_NOWAIT,"Calc.exe") )
      FatalError("Unable to start calculator.");
   WinVoidFunction("SetPosition",RightCalcHandle,ScreenWidth/2+ScreenWidth/30,RClockHeight + RClockTop - 13);
   printf(" These two sessions, for example, are each SEPARATELY busy...");
 
   // spend a little while pushing buttons on the calculcators
   WinBossSelect("Left");
   WinVoidFunction("SetActiveWindow",NotepadHandle);
   // Make sure notepad has word wrap on
   WinFunction("GetMenu",NotepadMenu,NotepadHandle);
   WinFunction("FindMenuString",WordWrapID,NotepadMenu,"Word Wrap");
   #define WMF_CHECKED      0x08    // checkmark is next to item
   #define WMF_BYCOMMAND    0x0000  // use the item ID
   WinFunction("GetMenuState",WordWrapState,NotepadMenu,WordWrapID,WMF_BYCOMMAND);
   if ( !(WMF_CHECKED & WordWrapState) )
      WinVoidFunction("MenuCommand",NotepadHandle,WordWrapID);

   // send long Nombas advertisement to notpad
   WinNoWaitFunction("SpeedKeys",NombasAdvertisement,50);

   WinBossSelect("Right");
   WinVoidFunction("SetActiveWindow",RightCalcHandle);
   WinVoidFunction("SpeedKeys","3.14159/-345+212.456=",900);

   // Cause a GPF in the right session, and wait till the GPF shows up
   PreGPFWindow = GetActiveWindow();
   WinNoWaitFunction("poke",0,UWORD32);
   while ( PreGPFWindow == GetActiveWindow() ) suspend(800);
   WaitSeconds(2);

   EraseScreen();
   printf("OOOPS!  There's that dreaded Windows GPF in the session on the right.");
   for ( i = 0; i < 4; i++ ) {
      DosBeep(400,300);
      DosBeep(200,300);
   }
   WaitSeconds(2);
   printf("\nBut OS/2's crash protection lets the other Windows session continue...");
   WaitSeconds(8);

//   WinBossSelect("Left");
//   WinVoidFunction("SetActiveWindow",LeftCalcHandle);
//   WinVoidFunction("SpeedKeys","6.2+3/4.5+8.2+4-0.15/3=",900);

   EraseScreen();
   printf("OS/2 can end the \"CRASHED\" windows session...");
   WaitSeconds(2);

   KeyStroke(VK_SPACE);
   QCall( "kill_cmd", RightProcessID );
   printf("\b\b\b, and continue without worry.");
   WaitSeconds(7);

   EraseScreen();
   printf("OS/2 truly is a better Window(s) than Windows\n"
          "(More Wow than WOW!)");
   WaitSeconds(4);
   printf("   Let's continue...");
   WaitSeconds(1);

   QCall( "kill_cmd", "Session:ServeOS2" );

}

/*************** DOS CONFIGURATIONS ***************/
DosConfigurations()
{
   LogHere("DosConfigurations()");
   SetWindowTitle(Info().WinHandle,"OS/2 Demo: BYE BYE MEMORY MANAGERS");

   EraseScreen();
   printf("With OS/2, you don't need DOS memory managers, reboots, and frustration.\n"
          "Each simultaneous DOS session in OS/2 has independent memory configuration.");

   lRowIncrement = ScreenHeight / 20;  // how much to raise each window
   lColIncrement = ScreenWidth / 20;   // how much to push each window to the right

   lRow = MyHeight + ScreenHeight / 50;
   lCol = ScreenWidth / 20;
   sprintf(lPosition,"%d,%d",lCol,lRow);
   RestoreDefaultDOSSettings();
   QCall( "session_cmd", "/TITLE", "Teeny-Tiny DOS Memory", "/F", "/WIN", "/DOS",
          "/FONT", "14x8", "/POS", lPosition, "/K",
          "/SET", "DPMI_DOS_API=DISABLED",
          "/SET", "DPMI_MEMORY_LIMIT=0",
          "/SET", "DPMI_NETWORK_BUFF_SIZE=0",
          "/SET", "EMS_FRAME_LOCATION=NONE",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "EMS_LOW_OS_MAP_REGION=0",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "XMS_HANDLES=0",
          "/SET", "XMS_MEMORY_LIMIT=0",
          "/SET", "XMS_MINIMUM_HMA=0",
          "/SET", "DOS_RMSIZE=90",
          "MEM.EXE" );
   WaitSeconds(2);
   EraseScreen();
   printf("Here is a session with a mere 90K of memory...");
   WaitSeconds(10);

   lRow += lRowIncrement; lCol += lColIncrement;
   sprintf(lPosition,"%d,%d",lCol,lRow);
   RestoreDefaultDOSSettings();
   QCall( "session_cmd", "/TITLE", "Lots of EMS Memory", "/F", "/WIN", "/DOS",
          "/FONT", "14x8", "/POS", lPosition, "/K",
          "/SET", "DPMI_DOS_API=DISABLED",
          "/SET", "DPMI_MEMORY_LIMIT=0",
          "/SET", "DPMI_NETWORK_BUFF_SIZE=0",
          "/SET", "EMS_FRAME_LOCATION=AUTO",
          "/SET", "EMS_LOW_OS_MAP_REGION=0",
          "/SET", "EMS_MEMORY_LIMIT=32768",
          "/SET", "XMS_HANDLES=0",
          "/SET", "XMS_MEMORY_LIMIT=0",
          "/SET", "XMS_MINIMUM_HMA=0",
          "MEM.EXE" );
   WaitSeconds(1);
   EraseScreen();
   printf("Here is a session with 32 megabytes of EMS memory...");
   WaitSeconds(7);

   lRow += lRowIncrement; lCol += lColIncrement;
   sprintf(lPosition,"%d,%d",lCol,lRow);
   RestoreDefaultDOSSettings();
   QCall( "session_cmd", "/TITLE", "Lots of XMS Memory", "/F", "/WIN", "/DOS",
          "/FONT", "14x8", "/POS", lPosition, "/K",
          "/SET", "DPMI_DOS_API=DISABLED",
          "/SET", "DPMI_MEMORY_LIMIT=0",
          "/SET", "DPMI_NETWORK_BUFF_SIZE=0",
          "/SET", "EMS_FRAME_LOCATION=NONE",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "EMS_LOW_OS_MAP_REGION=0",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "XMS_HANDLES=127",
          "/SET", "XMS_MEMORY_LIMIT=16384",
          "/SET", "XMS_MINIMUM_HMA=63",
          "MEM.EXE" );
   WaitSeconds(1);
   EraseScreen();
   printf("Here is a session with 16 megabyte of XMS memory...");
   WaitSeconds(7);

   lRow += lRowIncrement; lCol += lColIncrement;
   sprintf(lPosition,"%d,%d",lCol,lRow);
   RestoreDefaultDOSSettings();
   QCall( "session_cmd", "/TITLE", "Tons of Virtual Memory", "/F", "/WIN", "/DOS",
          "/FONT", "14x8", "/POS", lPosition, "/K",
          "/SET", "DPMI_DOS_API=ENABLED",
          "/SET", "DPMI_MEMORY_LIMIT=512",
          "/SET", "DPMI_NETWORK_BUFF_SIZE=0",
          "/SET", "EMS_FRAME_LOCATION=AUTO",
          "/SET", "EMS_LOW_OS_MAP_REGION=0",
          "/SET", "EMS_MEMORY_LIMIT=32768",
          "/SET", "XMS_HANDLES=127",
          "/SET", "XMS_MEMORY_LIMIT=16384",
          "/SET", "XMS_MINIMUM_HMA=63",
          "MEM.EXE" );
   WaitSeconds(1);
   EraseScreen();
   printf("Plus this session with 32 Mbyte EMS, 16 MByte XMS, and 512 MByte DPMI memory."
          "\nThat's 560 Megs of memory--much more memory than is in this computer!");
   WaitSeconds(7);

   lRow += lRowIncrement; lCol += lColIncrement;
   sprintf(lPosition,"%d,%d",lCol,lRow);
   RestoreDefaultDOSSettings();
   QCall( "session_cmd", "/TITLE", "Lots of DOS Memory", "/F", "/WIN", "/DOS",
          "/FONT", "14x8", "/POS", lPosition, "/K",
          "/SET", "VIDEO_MODE_RESTRICTION=CGA            ",
          "/SET", "DOS_DEVICE=",
          "/SET", "DOS_FCBS=1",
          "/SET", "DOS_FCBS_KEEP=1",
          "/SET", "DOS_FILES=20",
          "/SET", "DOS_HIGH=1",
          "/SET", "DOS_RMSIZE=640",
          "/SET", "DOS_UMB=1",
          "/SET", "DPMI_DOS_API=DISABLED",
          "/SET", "DPMI_MEMORY_LIMIT=0",
          "/SET", "DPMI_NETWORK_BUFF_SIZE=0",
          "/SET", "EMS_FRAME_LOCATION=NONE",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "EMS_LOW_OS_MAP_REGION=0",
          "/SET", "EMS_MEMORY_LIMIT=0",
          "/SET", "XMS_HANDLES=0",
          "/SET", "XMS_MEMORY_LIMIT=0",
          "/SET", "XMS_MINIMUM_HMA=0",
          "MEM.EXE" );
   WaitSeconds(1);
   EraseScreen();
   printf("Finally, here is a DOS session with over 700K conventional memory.");
   WaitSeconds(8);

   QCall( "domenu_cmd", "Lots of DOS Memory", "Close" );
   QCall( "domenu_cmd", "Tons of Virtual Memory", "Close" );
   QCall( "domenu_cmd", "Lots of XMS Memory", "Close" );
   QCall( "domenu_cmd", "Lots of EMS Memory", "Close" );
   QCall( "domenu_cmd", "Teeny-Tiny DOS Memory", "Close" );
}

/******************* PMApplets *******************/

PMApplets()
{
   LogHere("DosConfigurations()");
   SetWindowTitle(Info().WinHandle,"OS/2 Demo: PM Appletts");

   EraseScreen();
   printf("OS/2, the 32-bit multi-threaded, multi-tasking operating system\n"
          "truly shines when running true 32-bit PM applications...");

   // start pmspread
   PMSpreadWidth = ScreenWidth * 3 / 5 ;
   PMSpreadHeight = (ScreenHeight - MyHeight) * 3 / 5 ;
   PMSpreadCol = ScreenWidth - PMSpreadWidth;
   PMSpreadRow = MyHeight;
   sprintf(lSize,"%d,%d",PMSpreadWidth,PMSpreadHeight);
   sprintf(lPos,"%d,%d",PMSpreadCol,PMSpreadRow);
   QCall( "session_cmd", "/Title", "untitled - Spreadsheet", "/PM",
          "/SIZE", lSize, "/POS", lPos, "PMSpread.exe" );

   // start klondike
   KlondikeWidth = ScreenWidth * 5 / 7 ;
   KlondikeHeight = (ScreenHeight - MyHeight) * 5 / 7 ;
   KlondikeCol = 0;
   KlondikeRow = MyHeight + (ScreenHeight - MyHeight) - KlondikeHeight;
   sprintf(lSize,"%d,%d",KlondikeWidth,KlondikeHeight);
   sprintf(lPos,"%d,%d",KlondikeCol,KlondikeRow);
   QCall( "session_cmd", "/Title", "Klondike", "/PM", "/B",
          "/SIZE", lSize, "/POS", lPos, "Klondike.exe" );
   QCall( "domenu_cmd", "Klondike", "None" );

   EraseScreen();
   printf("What do you want to do?  Work?  Play?");

   // tell klondike to go automatic
   QCall( "domenu_cmd", "Klondike", "Very Slow" );
   QCall( "domenu_cmd", "Klondike", "Auto play" );

   printf("  How about Work AND play?!\n"
          "OS/2 will even play solitaire for you.  Talk about productivity!");

   #define PLAY_TIME    30    // how many seconds to play
   StartPlay = time();
   KeyPushFocusID(NULL);
   directions = { VK_LEFT, VK_UP, VK_RIGHT, VK_DOWN };
   do {
      // enter a number in the spreadsheet
      for ( backspace = 0; backspace < 3; backspace++ ) {
         suspend(250);
         KeyStroke(VK_BACKSPACE);
      } 
      sprintf(RandomNumber,"%d",rand() % 1000);
      SpeedKeys(RandomNumber,300);
      suspend(300);
      KeyStroke(VK_ENTER);
      suspend(300);
      KeyStroke(directions[rand() % 4]);
      suspend(300);
   } while ( difftime(time(),StartPlay) < PLAY_TIME );

   // turn off auto play
   QCall( "switch_cmd", "Klondike" );
   WaitSeconds(1);
   KeyStroke(VK_CTRL,'P');
   WaitSeconds(2);

   QCall( "kill_cmd", "Spreadsheet" );
   QCall( "kill_cmd", "Klondike" );
}

/************** QCall ************************
 *** Quick call to included .CMD utilities ***
 *********************************************/

QCall(pCmdName /*lotta args */)
{
   lArgc = va_arg();
   for ( lVarCount = 0; lVarCount < lArgc; lVarCount++ ) {
      lVar = va_arg(lVarCount);
      if ( 1 == DataDimension(lVar) )
         strcpy(lArgv[lVarCount],lVar);
      else
         sprintf(lArgv[lVarCount],"%d",lVar);
   }
   function(pCmdName,lArgc,lArgv);
}


#define main session_cmd
#include <Session.cmd>

#define main switch_cmd
#include <Switch.cmd>

#define main kill_cmd
#include <Kill.cmd>
KillQuietMode = True;

#define main winset_cmd
#include <WinSet.cmd>

#define main domenu_cmd
#include <DoMenu.cmd>

#define main switch_cmd
#include <Switch.cmd>

/************************ SESSION ************************
 *** session_cmd is called a lot here, so provide this ***
 *** means to restore original sessions settings       ***
 *********************************************************/

gDefaultDOSSettings = {
   "COM_DIRECT_ACCESS=0",  // 0 or 1
   "COM_HOLD=0",           // 0 or 1
   "COM_RECEIVE_BUFFER_FLUSH="   // select one of the following
      //"ALL",
      //"RECEIVE DATA INTERRUPT ENABLE",
      //"SWITCH TO FOREGROUND",
      "NONE",
   "COM_SELECT="
      " ALL",
      //"COM1",
      //"COM2",
      //"COM3",
      //"COM4",
      //"NONE",
   "DOS_AUTOEXEC=C:\\AUTOEXEC.BAT",
   "DOS_BACKGROUND_EXECUTION=1", // 0 or 1
   "DOS_BREAK=1", // 0 or 1
   "DOS_DEVICE=SIZE=0  C:\\OS2\\MDOS\\ANSI.SYS",
   "DOS_FCBS=16",
   "DOS_FCBS_KEEP=8",
   "DOS_FILES=75",
   "DOS_HIGH=0",  // 0 or 1
   "DOS_LASTDRIVE=Z",
   "DOS_RMSIZE=640",
   "DOS_SHELL=C:\\OS2\\MDOS\\COMMAND.COM C:\\OS2\\MDOS",
   "DOS_UMB=0",   // 0 or 1
   "DOS_VERSION=DCJSS02.EXE,3,40,255"
      "\nDFIA0MOD.SYS,3,40,255"
      "\nDXMA0MOD.SYS,3,40,255"
      "\nEXCEL.EXE,10,10,4"
      "\nIBMCACHE.COM,3,40,255"
      "\nIBMCACHE.SYS,3,40,255"
      "\nISAM.EXE,3,40,255"
      "\nISAM2.EXE,3,40,255"
      "\nISQL.EXE,3,40,255"
      "\nMSD.EXE,5,00,255"
      "\nNET3.COM,3,40,255"
      "\nNETX.COM,4,00,255"
      "\nNETX.EXE,5,00,255"
      "\nPSCPG.COM,3,40,255"
      "\nSAF.EXE,3,40,255"
      "\nWIN200.BIN,10,10,4",
   "DPMI_DOS_API="   // select one of the following
      "AUTO",
      //"ENABLED",
      //"DISABLED",
   "DPMI_MEMORY_LIMIT=4",
   "DPMI_NETWORK_BUFF_SIZE=8",
   "EMS_FRAME_LOCATION="
      "AUTO",
      //"NONE",
      //"C000",
      //"C400",
      //"C800",
      //"CC00",
      //"D000",
      //"D400",
      //"D800",
      //"DC00",
      //"8000",
      //"8400",
      //"8800",
      //"8C00",
      //"9000",
   "EMS_HIGH_OS_MAP_REGION=0",
   "EMS_LOW_OS_MAP_REGION=384",
   "EMS_MEMORY_LIMIT=2048",
   "HW_NOSOUND=0",      // 0 or 1
   "HW_ROM_TO_RAM=0",   // 0 or 1
   "HW_TIMER=0",        // 0 or 1
   "IDLE_SECONDS=0",
   "IDLE_SENSITIVITY=75",
   "INT_DURING_IO=0",   // 0 or 1
   "KBD_ALTHOME_BYPASS=0", // 0 or 1
   "KBD_BUFFER_EXTEND=1",  // 0 or 1
   "KBD_CTRL_BYPASS="   // select one of the following
      "NONE",
      //"ALT_ESC",
      //"CTRL_ESC",
   "KBD_RATE_LOCK=0",   // 0 or 1
   "MEM_EXCLUDE_REGIONS=",
   "MEM_INCLUDE_REGIONS=",
   "MOUSE_EXCLUSIVE_ACCESS=0",   // 0 or 1
   "PRINT_SEPARATE_OUTPUT=1",    // 0 or 1
   "PRINT_TIMEOUT=15",
   "VIDEO_8514A_XGA_IOTRAP=1",   // 0 or 1
   "VIDEO_FASTPASTE=0",          // 0 or 1
   "VIDEO_MODE_RESTRICTION="  // select one of the following
      "NONE         ",
      //"CGA            ",
      //"MONO           ",
   "VIDEO_ONDEMAND_MEMORY=1",    // 0 or 1
   "VIDEO_RETRACE_EMULATION=1",  // 0 or 1
   "VIDEO_ROM_EMULATION=1",      // 0 or 1
   "VIDEO_SWITCH_NOTIFICATION=0",// 0 or 1
   "VIDEO_WINDOW_REFRESH=1",
   "XMS_HANDLES=32",
   "XMS_MEMORY_LIMIT=2048",
   "XMS_MINIMUM_HMA=0"
};

RestoreDefaultDOSSettings()
{
   lSetCount = 1 + GetArraySpan(gDefaultDOSSettings);
   undefine(MyDefaultDOSSettings);
   for ( lSetting = 0; lSetting < lSetCount; lSetting++ )
      strcpy(MyDefaultDOSSettings[lSetting],gDefaultDOSSettings[lSetting]);
}

/*************** UTILITIES ************/
SetScreenColors(pFore,pBack)
{
   // set color for bright white on blue background
   #define BOLD_ON      1
   #define BLACK_FOR    30
   #define RED_FORE     31
   #define GREEN_FORE   32
   #define YELLOW_FORE  33
   #define BLUE_FORE    34
   #define MAGENTA_FORE 35
   #define CYAN_FORE    36
   #define WHITE_FORE   37
   #define BLACK_BACK   40
   #define RED_BACK     41
   #define GREEN_BACK   42
   #define YELLOW_BACK  43
   #define BLUE_BACK    44
   #define MAGENTA_BACK 45
   #define CYAN_BACK    46
   #define WHITE_BACK   47
   printf("\033[0;%d;%d;%dm",YELLOW_FORE,BLUE_BACK,BOLD_ON);
}

EraseScreen()  // clear screen
{
   printf("\033[2J");
}

WaitSeconds(lSec)
{
   lStartTime = time();
   while ( difftime(time(),lStartTime) < lSec )
      suspend(500);
}

FatalError(lFormatString/*,arg1,arg2...*/)
{
   va_start(lVaList,lFormatString);
   printf("\a\a\a\n");
   vprintf(lFormatString,lVaList);
   va_end(lVaList);
   abort();
}

DosBeep(Frequency,Duration)   // play specified Frequency, in Hz, for specified
{                             // duration, in milliseconds
   #define ORD_DOS32BEEP   286
   return DynamicLink("doscalls",ORD_DOS32BEEP,BIT32,CDECL,Frequency,Duration)
}

//***************************************************************************
//*** LogFile routines - If the OS2DEMO_LOGFILE environment variable is   ***
//*** not defined then these do nothing.  Else they initialize the log    ***
//*** file to append when the demo started at the end of the existing     ***
//*** log file.  LogHere() messages are added to the log file whenever    ***
//*** LogHere() is called, however these messages ovewrite each other so  ***
//*** that the log file does not grow too very large.  LogHere() messages ***
//*** timestamp and put a brief message so that you can look at the       ***
//*** file later to get an idea of what the last message was before a     ***
//*** demo ever hangs                                                     ***

gLogFileSeek;
#define EOF_CHAR  ( 'Z' - 'A' + 1 ) // ctrl-Z = EOF
InitializeLogFile(); // initialize log file when starting OS2DEMO


LogHere(FormatString/*,arg1,arg2,arg3*/)
{
   if ( defined(gLogFileSeek) ) {
      if ( fp = fopen(OS2DEMO_LOGFILE,"r+t") ) {

         // print this messages where the log messages go
         fseek(fp,gLogFileSeek);
         va_start(va_list,FormatString);
         vfprintf(fp,FormatString,va_list);
         va_end(va_list);

         // print the current time
         CurrentTime = ctime(time());
         CurrentTime[strlen(CurrentTime)-1] = '\0';
         fprintf(fp,"\nLogHere at: %s\n",CurrentTime);

         // add ctrl-z (EOF) character after this message
         fprintf(fp,"%c",EOF_CHAR);
         fclose(fp);
      }
   }
}

InitializeLogFile()  // start log, set timestamp of start, and save seek position
{
   if ( defined(OS2DEMO_LOGFILE) ) {
      if ( (fp = fopen(OS2DEMO_LOGFILE,"r+b"))
        || (fp = fopen(OS2DEMO_LOGFILE,"wb")) ) {
         // read to end of file or EOF_CHAR
         fseek(fp,0,SEEK_SET);
         gLogFileSeek = ftell(fp);
         while ( EOF != (lChar = fgetc(fp))  &&  EOF_CHAR != lChar ) {
            gLogFileSeek = ftell(fp);
         }
 
         // write log time start message
         fseek(fp,gLogFileSeek);
         CurrentTime = ctime(time());
         CurrentTime[strlen(CurrentTime)-1] = '\0';
         fprintf(fp,"\r\n\r\n\r\nStartTest at: %s\r\n\r\n",CurrentTime);
         // remember where to write following messages
         gLogFileSeek = ftell(fp);
         fclose(fp);
      }
   }
}



/********************** MAIN OS2DEMO ROUTINE ***********************/

// Make a nicer screen color using ANSI codes;  Black on white?
SetScreenColors();
EraseScreen();

// get screen dimensions
GetScreenSize(ScreenWidth,ScreenHeight);
GetSize(Info().WinHandle,MyWidth,MyHeight);

RunForever()
{
   for( ; ; ) {

      LogHere("Start sesson all over again");

      ManyDosSessions();

      DosConfigurations();

      ManyWindowsSessions();

      PMApplets();

      //WorkplaceShell();  not written yet

      //WorkingTogether(); not written yet

      EraseScreen();
      SetWindowTitle(Info().WinHandle,"OS/2 Demo: ALL DONE!");
      printf("That was such a fun demo!  Let's do it again.");
      WaitSeconds(6);
   }
}


