#============================================================================
#
#       GOTO/GOSUB Demo Program for XA 
#
#       This command file produces lighting effects for a Christmas display.
#       Four modules are used, you can add more if desired. 
#

# Names for XMAS_RED, XMAS_GREEN, XMAS_BLUE, XMAS_WHITE, as well as 
# BRIGHT and FADE have already been assigned in XA.INI

GOTO start           #   Skip subroutines

#
# Subroutine #1 
#

:SUB1
XMAS_GREEN BRIGHT    #   1) Fade up GREEN  (so GREEN and RED are BRIGHT)
XMAS_RED FADE        #   2) Dim RED (so only GREEN is BRIGHT)
XMAS_BLUE BRIGHT     #   3) Fade up BLUE  (so GREEN and BLUE are BRIGHT)
XMAS_GREEN FADE      #   4) Dim GREEN (so only BLUE is BRIGHT)
XMAS_WHITE BRIGHT    #   5) Fade up WHITE  (so BLUE and WHITE are BRIGHT)
XMAS_BLUE FADE       #   6) Dim BLUE (so only WHITE is BRIGHT)
XMAS_RED BRIGHT      #   7) Fade up RED  (so WHITE and RED are BRIGHT)        
XMAS_WHITE FADE      #   8) Dim WHITE (so only RED is BRIGHT)
RETURN                                                          





:start


# Initialization - 
# Let's start by turning all modules ON, Then fade all but RED

XMAS_RED ON
XMAS_GREEN ON
XMAS_BLUE ON
XMAS_WHITE ON

XMAS_GREEN FADE
XMAS_BLUE FADE
XMAS_WHITE FADE

# This section is the main loop. All subroutines are called from here

:loop

GOSUB sub1      # Execute subroutine once...        
GOSUB sub1      # Execute subroutine twice...

XMAS_GREEN BRIGHT    # Brighten everything
XMAS_BLUE BRIGHT     #
XMAS_WHITE BRIGHT    #

DELAY 0:0:5     # Wait 5 seconds

# Now DIM all but the RED

XMAS_GREEN FADE
XMAS_BLUE FADE
XMAS_WHITE FADE

DISPLAY OFF
# Now jump back to the ":outer" label and repeat this sequence all over again.
# This sequence will continue forever until either:
#       1) The <ESC> key is pressed (which will jump to the label ":EXIT"), 
#       2) The condintional IF statement tests for the Current time being
#          greater than 11:30 pm on FRI and SAT nights, or the time being
#          greater than 10:30 pm any other night. 
#          Requires: Registered Version XA 2.x
#          

DISPLAY ON
IF ((CDAY == FRI) OR (CDAY == SAT))  # Keep lights on later (FRI and SAT)
  IF (CTIME >= TIME 11:30 PM)
    GOTO EXIT
  ENDIF
ELSE
  IF (CTIME >= TIME 10:30 PM)
    GOTO EXIT
  ENDIF
ENDIF
GOTO loop                            # No conditions met, continue program...

# The ":EXIT" label is searched for by the interpreter whenever the <ESC>
# key is pressed. This allows the interpreter to execute a controlled shutdown.

:EXIT

XMAS_RED OFF
XMAS_GREEN OFF
XMAS_BLUE OFF
XMAS_WHITE OFF

# Turn the PC off when done (commented out)...
# P_C OFF
