; GC1000 v0.50 by Douglas W. Hogarth  9/11/93 (history in gc1000.hst)
;
; sets PC time using Heath GC-1000 Most Accurate Clock
;
; use MASM61 command ML GC1000.ASM to assemble/link        
; set FORCE equate for ignoring ? in tenths of seconds
; set NIST equate to dial NIST for calibration (debug option, not robust)
; set EVENT equate to use RTC Event rather than Timer2 sub-delay method
;        
        .MODEL  tiny            ;.COM file
        .186                    ;uses string-in function & shift by constant
        .NOLIST
        INCLUDE DOS.INC         ;ShowStr, GetDate, OpenFile, Read...
        .LIST
;FORCE   EQU     -1              ;TRUE
;NIST    EQU     -1              ;TRUE
EVENT   EQU     -1              ;TRUE
SUBDELAY EQU    10662           ;sub-hundredth delay counter IFNDEF EVENT
HUNDREDTH EQU   11932           ;number of delay counts in .01 second
USECDELAY EQU   8936            ;microsecond delay IFDEF EVENT
;9578/7774 dly (~8ms) w/correct=5 is using Hayes Optima 144 & DX2-66 no cache
;? on Compaq(Rockwell 224) & DX-33 w/64K cache use 3555/0097 w/correct=6
;for now we use ~average which is 10662/8936 w/correct=6 (hence +/-.01 second)
        .DATA        
port    WORD    0               ;0=COM1 default
mode    BYTE    0               ;0=AUTO mode default (vs NORM)
correct BYTE    6               ;hundredths of seconds delay for AUTO
        
        IFDEF   NIST
cmd1    BYTE    'ATE0Q1&Q0&D2',0dh      ;init string (no echo, no results)
cmd2    BYTE    'ATDT13034944774',0dh   ;dial command for NIST (tone, LD)
        ENDIF

        .DATA?
hours   BYTE    3 DUP(?)        ;this is where the clock string starts
mins    BYTE    3 DUP(?)        ;(also used by NIST)
secs    BYTE    3 DUP(?)        ;(also used by NIST)
tenths  BYTE    6 DUP(?)
day     BYTE    3 DUP(?)
month   BYTE    2 DUP(?)
tail    BYTE    4 DUP(?)        ;"/  ",0dh to be filled with 0dh,0ah,'$'
year    WORD    ?               ;to save MS-DOS year 
portbase WORD   ?               ;will be filled with 3F8, 2F8, etc
pport   WORD    ?               ;will be filled with 3BC, etc
ctenths BYTE    ?               ;to save tenths for compare
        IFDEF   FORCE
csecs   BYTE    ?               ;to save secs for compare
        ENDIF
mcr     BYTE    ?               ;to save Modem Control Register

        .CODE
        .STARTUP
        mov     cl,ds:[80h]     ;# of chars after command name
        inc     cl              ;allow for CR to get out
        mov     si,81h          ;unformatted parameter area
        xor     ch,ch           ;now cx=count
        cld                     ;prepare for increment
parse:        
        lodsb                   ;get byte, bump si
        cmp     al,0dh          ;CR=end
        je      eol             ;yes, end of line
        cmp     al,' '          ;space?
        jne     @F
        loop    parse           ;yes, keep looking
@@:
        cmp     al,'2'          ;COM2 (instead of 1)?
        jne     @F              ;nope, check another
        mov     BYTE PTR port,1 ;change from default 0=COM1
        loop    parse           ;keep looking
@@:
        and     al,11011111b    ;mask lowercase to uppercase (hack)
        cmp     al,'N'          ;Normal mode (vs auto)?
        jne     @F              ;nope, check another
setnorm:        
        or      mode,1          ;set NORM
        add     correct,4       ;add .04 second (should be .05?)
        loop    parse
@@:
        cmp     al,'D'          ;one-second Delay (vs no delay)?
        jne     @F              ;nope, check another
        add     correct,100     ;add 1.00 second
        jmp     setnorm         ;force NORM
@@:        
        cmp     al,'P'          ;Pulse?
        jne     @F              ;nope, check another
        or      mode,10b        ;set PULSE
        loop    parse
@@:
        mov     cl,255          ;invalid syntax, set errorlevel
        jmp     getout          ;exit without querying clock
eol:
        mov     ax,40h          ;BIOS data segment
        push    es              ;save (although same as ds, etc)
        mov     es,ax
        mov     bx,port         ;grab default or parameter (COM2)
        mov     dx,bx           ;for BIOS call below
        shl     bx,1            ;*2, from byte to word offset
        mov     ax,es:[bx]      ;get portbase from 40:0, 40:2, etc
        mov     portbase,ax     ;save it
        mov     ax,es:[8]       ;LPT1
        inc     ax              ;(was base)
        inc     ax              ;(now control)
        mov     pport,ax        ;save it in case of PULSE
        pop     es              ;restore (although same as ds, etc)
        
        IFDEF   NIST
        xor     dx,1            ;change COM1 to 2 and vice versa
        mov     ax,10000011b    ;1200,N,1,8 (modem settings for NIST)
        int     14h             ;async comm
        mov     ax,0500h        ;read modem control register
        int     14h             ;PS/2 async comm
        or      bl,1b           ;toggle DTR so we can hangup later
        mov     ax,0501h        ;write modem control register
        int     14h             ;PS/2 async comm
        mov     si,offset cmd1  ;initialize modem
prepare:   
        lodsb                   ;get one character
        mov     ah,1            ;transmit
        int     14h             ;async comm
        cmp     al,0dh          ;last one?
        jne     prepare         ;nope, loop
        mov     si,offset cmd2  ;dial NIST
;
; hack - problems like BUSY or failure to sync will cause a hang
;
cleanup:
        mov     ah,2            ;receive
        int     14h             ;async comm
        and     ah,10000000b    ;timeout?
        jz      cleanup         ;no, more stuff for the bit bucket
dial:
        lodsb                   ;get one character
        mov     ah,1            ;transmit
        int     14h             ;async comm
        cmp     al,0dh          ;last one?
        jne     dial            ;nope, loop
        in      al,61h          ;port B
        jmp     $+2             ;iodelay
        and     al,11111101b    ;speaker off
        or      al,1            ;timer on
        out     61h,al          ;port B
        jmp     $+2             ;iodelay (needed?)
        mov     al,10110100b    ;counter 2, word, generator, binary
        out     43h,al          ;internal timer control register
        mov     secs+2,0        ;init state
echochar:   
        mov     ah,2            ;receive
        int     14h             ;async comm
        and     ah,10000000b    ;timeout?
        jnz     echochar        ;yes, try again
        cmp     al,'#'          ;OTM with actual advance?
        je      otm             ;got on-time marker!
        mov     ah,1            ;transmit/echo (so that * turns to #)
        int     14h             ;async comm
        cmp     al,'-'          ;part of date
        jne     @F              ;not yet
        mov     secs+2,0        ;reset state
@@:     
        cmp     al,':'          ;next two might be minutes?
        jne     nocolon         ;not yet
        cmp     secs+2,0        ;first one?
        je      @F              ;yep
        inc     secs+2          ;here come seconds, state 4
        jmp     echochar        ;loop
@@:
        inc     secs+2          ;state 1
        jmp     echochar        ;loop
nocolon:
        cmp     secs+2,1        ;save first digit?
        jne     @F              ;nope
        mov     mins,al         ;save
        inc     secs+2          ;state 2
        jmp     echochar        ;loop
@@:
        cmp     secs+2,2        ;save second digit?
        jne     @F              ;nope
        mov     mins+1,al       ;save second digit
        inc     secs+2          ;state 3
        jmp     echochar        ;loop
@@:
        cmp     secs+2,4        ;save first digit?
        jne     @F              ;nope
        mov     secs,al         ;save
        inc     secs+2          ;state 5
        jmp     echochar        ;loop
@@:
        cmp     secs+2,5        ;save second digit?
        jne     echochar        ;nope, loop
        mov     secs+1,al       ;save
        mov     secs+2,0        ;reset state
        jmp     echochar        ;loop
otm:                            
        IFNDEF  EVENT
        mov     al,LOW HUNDREDTH
        out     42h,al          ;counter lsb
        jmp     $+2             ;iodelay
        mov     al,HIGH HUNDREDTH
        out     42h,al          ;msb
;
; 8254 is now generating sub-hundredth second info, for later analysis
;
        ELSE
        mov     ax,8300h        ;event wait
        mov     bx,offset mode  ;es:bx=bit bucket for high bit semaphore
        mov     cx,00ffh        ;(could set ch=ff also, but no need)
        mov     dx,0ffffh       ;cx:dx=around 16 seconds with ~1ms res
        int     15h             ;BIOS
;
; DWORD in BIOS data area is now jumping every 976us, for later analysis
;
        ENDIF

        @GetTime                ;hack
;
; this code assumes we have correct hour, so don't use it on the border
;
        mov     ax,WORD PTR mins
        call    fromasc
        mov     cl,al           ;cl now has minutes from NIST storage
        mov     ax,WORD PTR secs
        call    fromasc
        mov     dh,al           ;dh now has seconds from NIST storage
        xor     dl,dl           ;zero hundredths (assumed +/-2ms)
        mov     ah,2dh          ;@SetTime
        int     21h
        mov     ax,0500h        ;read modem control register
        int     14h             ;PS/2 async comm
        and     bl,NOT 1b       ;toggle DTR to hangup
        mov     ax,0501h        ;write modem control register
        int     14h             ;PS/2 async comm
        xor     dx,1            ;change COM1/2 back
        ENDIF
        
        mov     ax,11100010b    ;init 9600,N,1,7
        int     14h             ;Async comm
        test    mode,1          ;NORM?
        jz      @F              ;nope
;        
; the following call assumes PS/2 or later compatible BIOS
;
        mov     ax,0500h        ;read modem control register
        int     14h             ;PS/2 async comm
        mov     mcr,bl          ;save it
@@:        
        @GetDate                ;from MS-DOS
        mov     year,cx         ;save for later use

clock:                          ;routine to read time
        mov     ctenths,'9'     ;initialize compare storage
        
        IFDEF  FORCE
        mov     csecs,'?'       ;initialize compare storage
        ENDIF

clock2:
        mov     dx,portbase
        mov     di,OFFSET hours
clock3:        
        in      al,dx           ;clear out any garbage/reset errors
        test    mode,1          ;NORM?
        jnz     @F              ;yep
        cmp     al,0dh          ;CR is end of string
        jne     clock3          ;loop for start of string
        jmp     getchar
@@:
        mov     bl,mcr          ;restore
        mov     dx,port
        mov     ax,0501h        ;write modem control register
        or      bl,10b          ;specify RTS
        int     14h             ;PS/2 async comm
        mov     ax,0501h
        and     bl,NOT 10b      ;toggle
        int     14h             ;PS/2 async comm
getchar:                
        mov     dx,port
        mov     cx,0800H        ;char timeout counter
@@:
        mov     ah,3            ;read status
        int     14h
        and     ah,81h          ;timeout/ready
        cmp     ah,1            ;ready?
        loopne  @B              ;nope, keep checking
        jcxz    clock           ;timeout, try again
;        
; note: we go direct at this point because BIOS requires DSR
;
        mov     dx,portbase
        insb                    ;get char, save it, next
        cmp     di,OFFSET hours+23 ;done?
        jl      getchar         ;no, loop for next char
        cmp     secs+2,'.'      ;ninth character=decimal?
        jne     clock           ;bad string, try again
        cmp     hours+1,'?'     ;second character means not set yet
        mov     cl,5            ;load potential errorlevel
        je      getout          ;time N/A, skip display
        dec     cl              ;adjust potential errorlevel
        mov     al,tenths       ;tenths from this clock read
        cmp     al,'?'          ;question mark means >24hrs since Hi Spec
        
        IFNDEF  FORCE
        je      done            ;y-display w/o set and return errorlevel 4
        ELSE
        jne     tenthsok        ;n-continue accurate processing
        test    mode,1          ;NORM?      
        mov     tenths,'5'      ;halfway guess, estimate +/-.50 error
        jnz     @F              ;yep
        mov     tenths,'0'      ;forced, expect -.02 additional error
        mov     al,secs+1       ;least significant second        
        cmp     al,csecs        ;compare to "previous" seconds
        xchg    csecs,al        ;store for potential compare later
        je      clock2          ;try again until just changed
        cmp     al,'?'          ;was first time through?
        je      clock2          ;yes, wait until real change
@@:        
        jmp     usetime         ;continue (potentially inaccurate)
        ENDIF

tenthsok:
        test    mode,1          ;NORM?
        jnz     usetime         ;yep
        cmp     al,ctenths      ;compare to "previous" tenths
        xchg    ctenths,al      ;store for potential compare later
        je      clock2          ;try again until just changed                                 
        and     al,1            ;was odd tenths?
        jnz     clock2          ;yes, wait until change to (first) odd
usetime:
        mov     ax,WORD PTR hours
        call    fromasc         ;convert to byte
        mov     ah,tenths+2     ;A/PM indicator
        cmp     ax,'A'*256+12   ;12AM (midnight)?
        jne     @F              ;nope
        xor     al,al           ;special case, adjust to 00
        jmp     military
@@:
        cmp     ah,'P'          ;PM?
        jne     military        ;nope, don't adjust
        cmp     al,12           ;noon?
        je      military        ;special case - don't adjust
        add     al,12           ;adjust to 24 hour clock
military:
        mov     ch,al           ;hour
        mov     ax,WORD PTR mins
        call    fromasc         ;convert
        mov     cl,al           ;minute
        mov     ax,WORD PTR secs
        call    fromasc
        mov     dh,al           ;second
        mov     al,tenths       ;no hundredths from clock
        mov     ah,'0'          ;pretend base for hundredths
        call    fromasc
        add     al,correct      ;accuracy factor
        cmp     al,100          ;max hundredths
        jb      gothunds        ;we're okay now
        inc     dh              ;carry to second
        sub     al,100          ;adjust hundredths
        cmp     al,100          ;check max again
        jb      @F              ;okay, but handle potential rollover
        inc     dh              ;another second (correct was >100)
        sub     al,100          ;adjust hundredths again
@@:
        cmp     dh,60           ;max seconds
        jb      gothunds
        inc     cl              ;carry to minute
        sub     dh,60           ;adjust
        cmp     cl,60           ;max
        jb      gothunds
        inc     ch              ;carry to hour
        sub     cl,60           ;adjust
        cmp     ch,24           ;max
        jb      gothunds
        jmp     clock           ;if still rollover, try again (KISS)
gothunds:
        mov     dl,al           ;"hundred"
        
        IFDEF   NIST
        IFNDEF  EVENT
        mov     al,10000000b    ;counter 2, latch
        out     43h,al          ;internal timer control register
        jmp     $+2             ;iodelay
        in      al,42h          ;lsb
        jmp     $+2             ;iodelay
        mov     ah,al           ;save
        in      al,42h          ;msb
        xchg    al,ah           ;ax=sub hundredth countdown
;        
; ax now contains a value which can be inspected under DEBUG,
; and used to set SUBDELAY =HUNDREDTHS-(AX)
;
        ELSE
        mov     ax,8301h        ;cancel event wait
        int     15h             ;BIOS
;
; 40:9C and 40:9E now contain a value which can be inspected under DEBUG,
; and used to set USECDELAY =10000-(DWORD)
;
        ENDIF
        int     3               ;breakpoint if debugger loaded
        ENDIF        
        
        IFNDEF  EVENT
;        
; now we use 8254 to delay until we are near .01 second transition.
; of course the clock accuracy is only spec'ed within 10ms...
;
        in      al,61h          ;port B
        jmp     $+2             ;iodelay
        and     al,11111101b    ;speaker off
        or      al,1            ;timer on
        out     61h,al          ;port B
        jmp     $+2             ;iodelay (needed?)
        mov     al,10110000b    ;counter 2, word, counter, binary
        out     43h,al          ;internal timer control register
        jmp     $+2             ;iodelay
        mov     al,LOW SUBDELAY
        out     42h,al          ;counter lsb
        jmp     $+2             ;iodelay
        mov     al,HIGH SUBDELAY
        out     42h,al          ;msb
@@:     jmp     $+2             ;iodelay
        in      al,61h          ;port B
        and     al,00100000b    ;mask all except output signal
        jnz     @B              ;loop until expired
        ELSE
;        
; now we use RTC to delay until we are near .01 second transition.
; resolution is only 976us, and of course clock is only within 10ms...
;
        push    cx              ;save these since they have the time
        push    dx
        mov     ah,86h          ;unconditional wait
        xor     cx,cx           ;zero
        mov     dx,USECDELAY    ;(976us resolution)
        int     15h             ;BIOS
        pop     dx
        pop     cx              ;time registers restored
        ENDIF
        
        test    mode,10b        ;PULSE?     
        jz      @F              ;nope
        push    dx              ;save
        mov     dx,pport        ;printer control port
        mov     al,00001101b    ;strobe high
        out     dx,al           ;do it (takes about xus?)
        jmp     $+2             ;iodelay
        dec     al              ;strobe low
        out     dx,al           ;do it
        pop     dx              ;restore
@@:        
        mov     ah,2dh          ;@SetTime                
        int     21h             ;MS-DOS (and therefore on ver>=33, CMOS)
        add     ch,dh           ;add seconds to hours for special compare
        cmp     cx,(23+59)*256+59 ;last second before midnight?
        mov     cl,2            ;load potential errorlevel (warning)
        je      done            ;yes, don't risk rollover issues
        mov     ax,WORD PTR day ;day of month from clock
        call    fromasc         ;convert
        mov     dh,al           
        mov     ax,WORD PTR month
        call    fromasc
        mov     dl,al           
        mov     cx,year         ;GC-1000 year requires switch set & max '98
        mov     ah,2bh          ;@SetDate
        int     21h             ;MS-DOS (and CMOS)
        xor     cl,cl           ;reset errorlevel 0 (OK, w/date)
done:        
        mov     tail,0dh        ;carriage return
        mov     tail+1,0ah      ;linefeed
        mov     tail+2,'$'      ;end of string
        @ShowStr hours          ;display what we got from clock, w/o year
getout:        
        mov     al,cl           ;return code ("errorlevel") in AL
        .EXIT
        
fromasc PROC
        and     ax,0F0Fh        ;remove bias
        xchg    al,ah
        aad                     
        ret                     ;one byte in AL
fromasc ENDP
        
        END
;
; "to do" list (prioritize A-B-C)
;
;       A - a desirable comm improvement would be to make the read 
;       of the clock more robust - properly check for overrun/parity
;       errors & have an overall timeout (for improperly attached clock,
;       returns errorlevel 6).  also justify the character timeout value
;       and debug under Windows NT?
;
;       B - verify that my time reference (NIST using modem)
;       is correct, perhaps by hooking up pulse to event trigger
;       input of a syncronized timing module
;
;       B - experiment with clock presenting "one second delay" to verify
;       assumptions made (tested with GCSIM.BAS)
;
;       C - automatically support NORMAL mode (no incoming string), with
;       potential default to bump up CORRECT factor by one second -
;       new override switch would then be desirable to stop the bump
;
;       C - add logic to do year in some cases (when GC-1000>MS-DOS>79?),
;       return errorlevel 1 for case of time/date set but incorrect GC-1000
;       year.  stop using .186 instructions for those old PC/XT folks?
;
;       C - add logic to guess if we are in period of one hour error at
;       the daylight savings change twice/year and set errorlevel 3 if so.
;       guess based on ~1hr difference between clock and PC time, Saturday
;       pm vs Sunday before 2am, etc (but still set time by clock).
;
;       C - test PULSE parameter
;
;       C - change FORCE to cmd line switch for time/date set even with ?
;       character in tenths of second field.  
;
;       C - move additions to CORRECT out of the parsing loop or check
;       for repeated parameters
;
;       ? - make callable from TimeGen/AutoDial (pretend to be TimeSet if
;       discovered renamed to TIMESET - not sure how those work together).
;       perhaps this would also work for callers like JPLCLOCK, etc.
