{*
*=========================================================================
*  BTVCONST.PAS  Version 2.00
*
*  BTRIEVE object oriented interface for Turbo Pascal 6.0, 7.0
*
*  Copyright (c) 1993 by Richard W. Hansen, all rights reserved.
*
*
*  Requires Turbo Pascal version 6.0, 7.0
*
*
*  Registration and payment of a license fee is required for any use, whether
*  in whole or part, of this source code.
*=========================================================================
*
*}

{****************************************************************************}
{*   REVISION HISTORY                                                       *}
{*                                                                          *}
{*  Date     Who  What                                                      *}
{* ======================================================================== *}
{* 10/02/93  RWH  Added constants for extended Get & Insert operations.     *}
{* 11/03/93  RWH  Changed bOutOfMemory error code to 5000.                  *}
{****************************************************************************}

UNIT BtvConst;

INTERFACE

CONST
  {----- Btrieve operation codes -----}
  bOpen               = 0;
  bClose              = 1;
  bInsert             = 2;
  bUpdate             = 3;
  bDelete             = 4;
  bGetEqual           = 5;
  bGetNext            = 6;
  bGetPrev            = 7;
  bGetGreat           = 8;
  bGetGreatEqual      = 9;
  bGetLess            = 10;
  bGetLessEqual       = 11;
  bGetFirst           = 12;
  bGetLast            = 13;
  bCreate             = 14;
  bStat               = 15;
  bBeginTransaction   = 19;
  bEndTransaction     = 20;
  bAbortTransaction   = 21;
  bGetPosition        = 22;
  bGetDirect          = 23;
  bStepNext           = 24;
  bStop               = 25;
  bVersion            = 26;
  bUnlock             = 27;
  bReset              = 28;
  bSetOwner           = 29;
  bClearOwner         = 30;
  bCreateIndex        = 31;
  bDropIndex          = 32;
  bStepFirst          = 33;
  bStepLast           = 34;
  bStepPrev           = 35;
  bXGetNext           = 36;
  bXGetPrev           = 37;
  bXStepNext          = 38;
  bXStepPrev          = 39;
  bXInsert            = 40;

  bGetKey             = 50;

  {----- Btrieve Status Codes -----}
  bOkay               = 0;
  bInvalidOp          = 1;
  bIOerror            = 2;
  bFileNotOpen        = 3;
  bKeyNotFound        = 4;
  bDuplicateKey       = 5;
  bInvalidKey         = 6;
  bDifferentKey       = 7;
  bInvalidPos         = 8;
  bEOF                = 9;
  bKeyModifyErr       = 10;
  bInvalidName        = 11;
  bFileNotFound       = 12;
  bExtendedFileErr    = 13;
  bPreImageOpenErr    = 14;
  bPreImageIOErr      = 15;
  bExpansionErr       = 16;
  bCloseErr           = 17;
  bDiskFull           = 18;
  bUnRecoverableErr   = 19;
  bNotLoaded          = 20;
  bKeyBufferShort     = 21;
  bDataBufferShort    = 22;
  bPosBlockShort      = 23;
  bPageSizeErr        = 24;
  bCreateIOErr        = 25;
  bNumberKeys         = 26;
  bInvalidKeyPos      = 27;
  bRecordLenErr       = 28;
  bKeyLenErr          = 29;
  bNotBtrieveFile     = 30;
  bFileExtended       = 31;
  bExtendIOErr        = 32;
  bExtendNameErr      = 34;
  bDirectoryErr       = 35;
  bTransactionErr     = 36;
  bTransactionActive  = 37;
  bTransactionFileErr = 38;
  bTransactionEndErr  = 39;
  bTransactionMaxFiles= 40;
  bOpNotAllowed       = 41;
  bAcceleratedErr     = 42;
  bInvalidAddress     = 43;
  bNullKeypath        = 44;
  bBadKeyFlags        = 45;
  bFileAccessDenied   = 46;
  bMaxOpenFiles       = 47;
  bInvalidAltSequence = 48;
  bKeyTypeErr         = 49;
  bOwnerIsSet         = 50;
  bInvalidOwner       = 51;
  bCacheWriteErr      = 52;
  bInvalidVersion     = 53;
  bVariablePageErr    = 54;
  bAutoIncrementErr   = 55;
  bBadIndex           = 56;
  bExpandedMemoryErr  = 57;
  bCompressBuffShort  = 58;
  bFileExists         = 59;
  bRejectMax          = 60;
  bWorkSpaceShort     = 61;
  bDescriptorErr      = 62;
  bExtInsertBuffErr   = 63;
  bFilterLimit        = 64;
  bFieldOffsetErr     = 65;
  bTTSabort           = 74;
  bDeadlock           = 78;
  bConflict           = 80;
  bLockErr            = 81;
  bLostPosition       = 82;
  bOutOfTransaction   = 83;
  bRecordInUse        = 84;
  bFileInUse          = 85;
  bFileTblFull        = 86;
  bHandleTblFull      = 87;
  bBadModeErr         = 88;
  bDeviceTableFull    = 90;
  bServerErr          = 91;
  bTranTableFull      = 92;
  bBadLockType        = 93;
  bPermissionErr      = 94;
  bSessionInvalid     = 95;
  bCommunicationErr   = 96;
  bDataMessageShort   = 97;
  bInternalTTSerr     = 98;
  bLastError          = bInternalTTSerr;

  bOutOfMemory        = 5000;
  bDuplicateFilename  = bOutOfMemory + 1;
  bLoadInputErr       = bDuplicateFilename + 1;

  {----- Btrieve constants -----}
  bNormal             = 0;

  bNOJustify          = 0;        { String justification types }
  bRJustify           = 1;
  bLJustify           = 2;

  bOverWrite          = 0;       { File create mode }
  bNoOverWrite        = -1;       { File create mode }

  bNoAccess           = 0;
  bReadAccess         = 1;        { File owner access modes }
  bWriteAccessEncrypt = 2;
  bReadAccessEncrypt  = 3;

  bVariableLen        = 1;        { File flags }
  bBlankTruncate      = 2;
  bPreallocate        = 4;
  bDataCompress       = 8;
  bKeyOnly            = 16;
  b10Free             = 64;
  b20Free             = 128;
  b30Free             = 192;

  bAccelerated        = -1;       { File open modes }
  bReadOnly           = -2;
  bVerify             = -3;
  bExclusive          = -4;

  bDuplicates         = 1;        { Key flags }
  bModifiable         = 2;
  bBinary             = 4;
  bNull               = 8;
  bSegmented          = 16;
  bAltSequence        = 32;
  bDescending         = 64;
  bSupplemental       = 128;
  bExtended           = 256;
  bManual             = 512;

  bString             = 0;        { Key types }
  bInteger            = 1;
  bFloat              = 2;
  bDate               = 3;
  bTime               = 4;
  bDecimal            = 5;
  bMoney              = 6;
  bLogical            = 7;
  bNumeric            = 8;
  bBfloat             = 9;
  bLstring            = 10;
  bZstring            = 11;
  bUnsigned           = 14;
  bAutoIncrement      = 15;

  bNoLock             = 0;        { Lock types }
  bSingleWait         = 100;
  bSingleNoWait       = 200;
  bMultipleWait       = 300;
  bMultipleNoWait     = 400;

  bXGetEqual          = 1;        { extended get compare codes }
  bXGetGreat          = 2;
  bXGetLess           = 3;
  bXGetNotEqual       = 4;
  bXGetGreatEqual     = 5;
  bXGetLessEqual      = 6;

  bXAltSeqCompare     = 32;       { biases to be added to compare codes }
  bXFieldCompare      = 64;
  bXNoCaseCompare     = 128;

  bXDone              = 0;        { extended get logical operation codes }
  bXLogicAND          = 1;
  bXLogicOR           = 2;


  PosBlockSize        = 128;

  MaxSegments         = 24;       { maximum number of segments in a key   }
  MaxBuffSize         : Word = 16 * 1024; { 16k max buffer size in bytes  }

  {$IFDEF WINDOWS}
  wm_BrieveNotLoaded  : Word = $7FFF;
  {$ENDIF}

IMPLEMENTATION

end.
