{* This is a real mode interface to the Btrieve TSR.
*  Requires Turbo Pascal version 6.0, 7.0
*
*  IT CANNOT BE USED FOR PROTECTED MODE OR WINDOWS!!!!!
*
*}

UNIT BTRVDOS;
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$N-}    {No numeric coprocessor}

{****************************************************************************}
{*   REVISION HISTORY                                                       *}
{*                                                                          *}
{*  Date     Who  What                                                      *}
{* ======================================================================== *}
{* 02/01/92  RWH  Changed all instances of Data Buffer Length from Integer  *}
{*                to Word so variable length records can be up to 64K.      *}
{* 07/28/93  RWH  Removed all code for some obscure multi-tasking operating *}
{*                system that Novell once supported and is not needed for   *}
{*                Turbo Pascal. Should speed access up somewhat.            *}
{****************************************************************************}

INTERFACE


USES
   Dos;

CONST
  BTR_INT        : Byte = $7B;


Function BTRV(    OP       : Integer;     { operation code     }
              var POS,                    { position block     }
                  DATA;                   { data buffer        }
              var DATALEN  : Word;        { data buffer length }
              var KBUF;                   { key buffer         }
                  KEY      : Integer      { index/key path     }
              ): Integer;

{============================================================================}
IMPLEMENTATION


Function BTRV(    OP       : Integer;
              var POS,
                  DATA;
              var DATALEN  : Word;
              var KBUF;
                  KEY      : Integer
              ): Integer;

  const
    VAR_ID         = $6176;   {id for variable length records - 'va'}
    BTR_OFFSET     = $0033;

  type
    ADDR32 = record               {32 bit address}
      OFFSET : Integer;
      SEGMENT: Integer;
    end;

    BTR_PARMS = record
      USER_BUF_ADDR  : ADDR32;  {data buffer address}
      USER_BUF_LEN   : Word;    {data buffer length}
      USER_CUR_ADDR  : ADDR32;  {currency block address}
      USER_FCB_ADDR  : ADDR32;  {file control block address}
      USER_FUNCTION  : Integer; {Btrieve operation}
      USER_KEY_ADDR  : ADDR32;  {key buffer address}
      USER_KEY_LENGTH: Byte;    {key buffer length}
      USER_KEY_NUMBER: Byte;    {key number}
      USER_STAT_ADDR : ADDR32;  {return status address}
      XFACE_ID       : Integer; {language interface id}
    end;

  var
    STAT : Integer;             {Btrieve status code}
    XDATA: BTR_PARMS;           {Btrieve parameter block}
    REGS : Dos.Registers;       {register structure used on interrrupt call}

  begin
    REGS.AX := $3500 + BTR_INT;
    INTR($21, REGS);

    if (REGS.BX <> BTR_OFFSET) then         {make sure Btrieve is installed}
      STAT := 20

    else
    begin
      {make normal btrieve call}
      with XDATA do
      begin
        USER_BUF_ADDR.SEGMENT  := SEG(DATA);
        USER_BUF_ADDR.OFFSET   := OFS(DATA);              {set data buffer address}
        USER_BUF_LEN           := DATALEN;
        USER_FCB_ADDR.SEGMENT  := SEG(POS);
        USER_FCB_ADDR.OFFSET   := OFS(POS);               {set FCB address}
        USER_CUR_ADDR.SEGMENT  := USER_FCB_ADDR.SEGMENT;  {set cur seg}
        USER_CUR_ADDR.OFFSET   := USER_FCB_ADDR.OFFSET+38;{set cur ofs}
        USER_FUNCTION          := OP;                     {set Btrieve operation code}
        USER_KEY_ADDR.SEGMENT  := SEG(KBUF);
        USER_KEY_ADDR.OFFSET   := OFS(KBUF);              {set key buffer address}
        USER_KEY_LENGTH        := 255;                    {assume its large enough}
        USER_KEY_NUMBER        := KEY;                    {set key number}
        USER_STAT_ADDR.SEGMENT := SEG(STAT);
        USER_STAT_ADDR.OFFSET  := OFS(STAT);              {set status address}
        XFACE_ID               := VAR_ID;                 {set language id}
      end;

      REGS.DX := OFS(XDATA);
      REGS.DS := SEG(XDATA);
      INTR(BTR_INT, REGS);
      DATALEN := XDATA.USER_BUF_LEN;
    end;

    BTRV := STAT;
  end;

End.
