
uses crt, dos, defAMG, rgaAMG;

const
    titlestr : string[80] = 'AMG 2.2 Copyright (c) 1993 Milen Georgiev. All Rights Reserved. Nov 1 1993    ';


var
	wa: array[0..3] of byte;

procedure MyInt24h(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); interrupt;
var
	c : char;
    e : word;
    s : pathstr;
begin
		e := di and $00ff;
        case e of
        	0 : s := 'Disk is write protected';
            1 : s := 'Unknown unit ID';
            2 : s := 'Disk drive not ready';
            3 : s := 'Unknown command';
            4 : s := 'Disk data error';
            5 : s := 'Bad request structure length';
            6 : s := 'Disk seek error';
            7 : s := 'Unknown disk media type';
            8 : s := 'Disk sector not found';
            9 : s := 'Printer out of paper';
            10: s := 'Write fault error';
            11: s := 'Read fault error';
            12: s := 'General failure';
            15: s := 'Invalid disk change';
        else
        	s := 'I/O Error';
        end;

        s := s + '     (R)etry or (C)ancel';
        s := s + copy(EmptyStr,1,78 - length(s));
        if wherey < 22 then
        begin
	        dosx := wherex; dosy := wherey;
        end;
	   	    sound(400);delay(100);nosound;
	        BottomLine(s, lightred + blink);
			repeat
               	c := WaitKey;
                c := upcase(c);
           	until (c = 'R') or (c = 'C');
		  	BottomLine('                                                                ',black);
			window(2,3,79,18); textbackground(blue); textcolor(white);
			showcursor; gotoxy(dosx,dosy);

	ax := ax and $ff00;
	if c = 'R' then
	    ax := ax or 1
    else
    begin
    	criterr := true;
    	ax := ax or 3;
    end;

end;


procedure Init;
begin
	excldpth := false;
 	mltplvlm := false;
    password := '';
    Tstint := false;
    Method := NormalCompr;
    delaftarc := false;
    querybefovr := true;
    assign(rqstfile,workdir + 'rqstfAMG.&&&');
    assign(temparc,workdir + 'tmpaAMG.&&&');
    assign(delfile,workdir + 'delfAMG.&&&');
    vlmcnt := 0;
end;

procedure InfoWin;
var
	ss : pathstr;
begin
	window(1,1,80,25);
    textBackground(black);
	clrscr;
	window(1,1,80,24);
    textBackground(lightgray);
	clrscr;
    textbackground(lightgray); textcolor(black);
    write(' ' + titlestr);

	window(1,2,80,23);
    textBackground(blue); textcolor(white);
	clrscr;
    window(1,1,80,25);
    gotoxy(1,2);  write('ͻ');
    gotoxy(1,23); write('ͼ');
    for i := 3 to 22 do
    begin
    	gotoxy(1,i);write('');
    end;
    for i := 3 to 22 do
    begin
    	gotoxy(80,i);write('');
    end;

	window(2,19,79,22);
    textBackground(cyan); textcolor(white);
	clrscr;
    window(1,1,80,25);

    gotoxy(2,19);  write('Ŀ');
    gotoxy(2,22);  write('');
    for i := 20 to 21 do
    begin
    	gotoxy(2,i);write('');
    	gotoxy(18,i);write('');
    end;
    gotoxy(5,19);  write(' Selected ');
    gotoxy(3,20);  write('Files: ');
    gotoxy(3,21);  write('Bytes: ');
    gotoxy(9,20);  write(selfiles);
    gotoxy(9,21);  write(selbytes);


    gotoxy(62,19);  write('Ŀ');
    gotoxy(62,22);  write('');
    for i := 20 to 21 do
    begin
    	gotoxy(62,i);write('');
    	gotoxy(79,i);write('');
    end;
    gotoxy(65,19);  write(' Processed ');
    gotoxy(63,20);  write('Files: ');
    gotoxy(63,21);  write('Bytes: ');
    gotoxy(69,20);  write(procfiles);
    gotoxy(69,21);  write(procbytes);

    gotoxy(20,20);write('0%       25%       50%       75%     100%');
    gotoxy(20,21);write('');


    gotoxy(1,24); textbackground(lightgray); textcolor(black);
    write(' Esc Break       ');
    case Method of
    	SuperFastCompr  : s := 'Method: Super Fast Compression';
    	FastCompr       : s := 'Method: Fast Compression';
    	LessMemCompr    : s := 'Method: LessMem Compression';
        NormalCompr     : s := 'Method: Normal Compression';
        MaxCompr        : s := 'Method: Max Compression';
    end;
    ss := copy(cmnd,1,4);
    if (ss <> 'extr') and (ss <> 'test') then
    begin
	    gotoxy(80 - length(s),24);
	    write(s);
    end;
end;


procedure AddFile;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(36 - (length(ArcDOSName) div 2),2); writeln(' Adding to ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    if delaftarc then
    begin
		rewrite(delfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;

    if arcexist then
    begin
    	seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        BlockRead(arcfile,ArcHeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(ArcHeader[10],ArcCmntLen,2);
        if ArcCmntLen > 0 then
        begin
        	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	end;
    end
    else
    begin
	    FillChar(ArcHeader,12,0);
        ArcHeader[0] := $AD; ArcHeader[1] := $36;
        ArcHeader[2] := $22;
    	ArcCmntLen := 0;
        if ADrive > 2 then
        	assign(temparc,ArcName);
    end;

    if length(CmntFileName) > 0 then
    begin
        findfirst(CmntFileName,Archive,sr);
        if DosError <> 0 then
        begin
	       	MessageWin('File ' + CmntFileName + ' not found');
    	    exit;
        end
        else
        begin
            assign(CmntFile, CmntFileName);
            filemode := 0;
            reset(CmntFile, 1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            li := filesize(CmntFile);
            if li > 8192 then
            	ArcCmntLen := 8192
            else
            	ArcCmntLen := li;
            BlockRead(CmntFile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            close(CmntFile);
        end;
    end;

    ArcHeader[10] := lo(ArcCmntLen);
 	ArcHeader[11] := hi(ArcCmntLen);
    rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    blockwrite(temparc,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 12 then DiskFull;
    if ArcCmntLen > 0 then
    begin
    	BlockWrite(temparc,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> ArcCmntLen then DiskFull;
    end;

	if arcexist then
    begin
        while not eof(arcfile) do
        begin
            fileinarc := filepos(arcfile);
            blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        Move(FileHeader[0],i,2);
    	    if i <> $1C94 then
            begin
    	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
    	       	close(arcfile);
                close(temparc);
                erase(temparc);
				close(rqstfile);
        		exit;
            end;

            FPath := ''; FName := ''; FExt := '';
            PathLen := FileHeader[32];
			if PathLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            for i := 1 to PathLen do
            	Fpath := Fpath + chr(PosBuf[i-1]);
            FileCmntLen := FileHeader[33] + 256*FileHeader[34];
			if FileCmntLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            Move(FileHeader[2],flen,4);
            if (FileHeader[16] and $80) <> 0 then
            begin
	            seek(arcfile, fileinarc + flen);
				continue;
            end;
            for i := 1 to 8 do
              	if fileheader[20+i] <> 0 then
                   	FName := FName + chr(FileHeader[20+i])
                 else
                   	break;
            for i := 1 to 3 do
	           	if  fileheader[28+i] <> 0 then
       				FExt := FExt + chr(fileheader[28+i])
                else
                   	break;
            ms := FName + FExt;
            seek(rqstfile,rqstfn);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            match := false;
            while not eof(rqstfile) and not(match) do
            begin
               	read(rqstfile,pths);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                delname := pths;
{	            delete(pths,1,length(rqstpath));}
	            if pths[1] = '\' then
	            	delete(pths,1,1);
                fsplit(pths,FPath,FName,FExt);
                if FPath[1] = '\' then delete(FPath,1,1);
                if length(FExt) > 0 then
	                delete(FExt,1,1);
                ws := FName + FExt;
                if ws = ms then
                begin
                   	match := true;
                    seek(rqstfile,filepos(rqstfile) - 1);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                    ws := '';
                    write(rqstfile,ws);
        			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		        end;
            end;

            if match then
            begin
               	textname := pths;
                broken := false;

                EncodFile;

                if delaftarc then
                begin
	                write(delfile,delname);
    				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                end;

	            seek(arcfile, fileinarc + flen);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                if broken then
                begin
    		       	close(arcfile);
        	        close(temparc);
            	    erase(temparc);
					close(rqstfile);
        			exit;
                end;
            end
            else
            begin
               	CopyArcFile;
            end;
        end;
    end;

    seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
    	read(rqstfile,textname);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        delname := textname;
		if length(textname) > 0 then
        begin
           	FileCmntLen := 0;
            broken := false;

		    EncodFile;

            if delaftarc then
            begin
                write(delfile,delname);
   				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;

            if broken then
            begin
   		       	close(arcfile);
       	        close(temparc);
           	    erase(temparc);
				close(rqstfile);
       			exit;
            end;
        end;
    end;
    dosx := wherex; dosy := wherey; window(1,1,80,25);
    textbackground(cyan); textcolor(white);
    gotoxy(69,21);write(procbytes);
    s := ''; for j := 1 to 41 do s := s + '';
    gotoxy(20,21); textcolor(yellow); write(s);
    if keypressed then begin c := readkey; if ord(c) = 27 then begin broken := true; exit; end; end;
    window(2,3,79,18); gotoxy(dosx,dosy);
	textbackground(blue); textcolor(white);
    hidecursor;
	close(rqstfile);
   	close(temparc);
    if (arcexist) or (ADrive < 3) then
    begin
	    CopyTempArc;
    end;
    if delaftarc then
    begin
		seek(delfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    while not eof(delfile) do
    	begin
            if PressEsc then
            	break;
	      	read(delfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    WorkingWin('Deleting ' + ws);
	        assign(f,ws);
            SetFAttr(f,Archive);
    	    erase(f);
	    end;
    	close(delfile);
	    erase(delfile);
    end;
end;


procedure SEA;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(25 - (length(ArcDOSName) div 2),2); writeln(' Creating self extracting archive ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    if delaftarc then
    begin
		rewrite(delfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;


    FillChar(ArcHeader,12,0);
    ArcHeader[0] := $AD; ArcHeader[1] := $36;
    ArcHeader[2] := $22;
   	ArcCmntLen := 0;

    if length(CmntFileName) > 0 then
    begin
        findfirst(CmntFileName,Archive,sr);
        if DosError <> 0 then
        begin
	       	MessageWin('File ' + CmntFileName + ' not found');
    	    exit;
        end
        else
        begin
            assign(CmntFile, CmntFileName);
            filemode := 0;
            reset(CmntFile, 1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            li := filesize(CmntFile);
            if li > 8192 then
            	ArcCmntLen := 8192
            else
            	ArcCmntLen := li;
            BlockRead(CmntFile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            close(CmntFile);
        end;
    end;

    assign(temparc,ArcName);
    filemode := 2;
    reset(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    seek(temparc,filesize(temparc));
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    move(selfiles,ArcHeader[4],2);
    move(selbytes,ArcHeader[6],4);
    ArcHeader[10] := lo(ArcCmntLen);
 	ArcHeader[11] := hi(ArcCmntLen);
    blockwrite(temparc,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 12 then DiskFull;
    if ArcCmntLen > 0 then
    begin
    	BlockWrite(temparc,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> ArcCmntLen then DiskFull;
    end;

    seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
    	read(rqstfile,textname);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        delname := textname;
		if length(textname) > 0 then
        begin
           	FileCmntLen := 0;
            broken := false;

		    EncodFile;

            if delaftarc then
            begin
                write(delfile,delname);
   				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;

            if broken then
            begin
       	        close(temparc);
           	    erase(temparc);
				close(rqstfile);
       			exit;
            end;
        end;
    end;
    hidecursor;
	close(rqstfile);
	close(temparc);
    if delaftarc then
    begin
		seek(delfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    while not eof(delfile) do
    	begin
            if PressEsc then
            	break;
	      	read(delfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    WorkingWin('Deleting ' + ws);
	        assign(f,ws);
            SetFAttr(f,Archive);
    	    erase(f);
	    end;
    	close(delfile);
	    erase(delfile);
    end;
end;


procedure MVA;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(24 - (length(ArcDOSName) div 2),2); writeln(' Creating multiple volume archive ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    if delaftarc then
    begin
		rewrite(delfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;


    mltplvlm := true;
    FillChar(ArcHeader,12,0);
    ArcHeader[0] := $AD; ArcHeader[1] := $36;
    ArcHeader[2] := $22;
    move(selfiles,ArcHeader[4],2);
    move(selbytes,ArcHeader[6],4);

    if length(CmntFileName) > 0 then
    begin
        findfirst(CmntFileName,Archive,sr);
        if DosError <> 0 then
        begin
	       	MessageWin('File ' + CmntFileName + ' not found');
    	    exit;
        end
        else
        begin
            assign(CmntFile, CmntFileName);
		    filemode := 0;
            reset(CmntFile, 1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            li := filesize(CmntFile);
            if li > 8192 then
            	ArcCmntLen := 8192
            else
            	ArcCmntLen := li;
	    	BlockRead(CmntFile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    		close(CmntFile);
        end;
    end
    else
	   	ArcCmntLen := 0;

    ArcHeader[10] := lo(ArcCmntLen);
	ArcHeader[11] := hi(ArcCmntLen);

   	assign(temparc, arcname);
    ADiskFree := diskfree(ADrive);

    ADiskFree := ADiskFree - ArcCmntLen - 12;
	if ADiskFree < 10000 then
    begin
       	MessageWin('Not enough free space on target disk.');
        exit;
    end;

    rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    blockwrite(temparc,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 12 then DiskFull;
    if ArcCmntLen > 0 then
    begin
    	BlockWrite(temparc,PosBuf,ArcCmntLen,NmbWriten);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbWriten <> ArcCmntLen then DiskFull;
    end;


    seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
    	read(rqstfile,textname);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        delname := textname;
		if length(textname) > 0 then
        begin
           	FileCmntLen := 0;
            broken := false;

		    EncodFile;

            if delaftarc then
            begin
                write(delfile,delname);
   				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;

            if broken then
            begin
   		       	close(arcfile);
       	        close(temparc);
           	    erase(temparc);
				close(rqstfile);
       			exit;
            end;
        end;
    end;
    hidecursor;
	close(rqstfile);
   	close(temparc);
    if delaftarc then
    begin
		seek(delfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    while not eof(delfile) do
    	begin
            if PressEsc then
            	break;
	      	read(delfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    WorkingWin('Deleting ' + ws);
	        assign(f,ws);
            SetFAttr(f,Archive);
    	    erase(f);
	    end;
    	close(delfile);
	    erase(delfile);
    end;
end;


procedure FreshenArchive;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(35 - (length(ArcDOSName) div 2),2); writeln(' Updating ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    if delaftarc then
    begin
		rewrite(delfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;

    rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if arcexist then
    begin
    	seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        BlockRead(arcfile,ArcHeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(ArcHeader[10],ArcCmntLen,2);
        if ArcCmntLen > 0 then
        begin
        	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	end;
    end
    else
    begin
	    FillChar(ArcHeader,12,0);
        ArcHeader[0] := $AD; ArcHeader[1] := $36;
        ArcHeader[2] := $22;
    	ArcCmntLen := 0;
    end;

    if length(CmntFileName) > 0 then
    begin
        findfirst(CmntFileName,Archive,sr);
        if DosError <> 0 then
        begin
	       	MessageWin('File ' + CmntFileName + ' not found');
    	    exit;
        end
        else
        begin
            assign(CmntFile, CmntFileName);
		    filemode := 0;
            reset(CmntFile, 1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            li := filesize(CmntFile);
            if li > 8192 then
            	ArcCmntLen := 8192
            else
            	ArcCmntLen := li;
            BlockRead(CmntFile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            close(CmntFile);
        end;
    end;

    ArcHeader[10] := lo(ArcCmntLen);
 	ArcHeader[11] := hi(ArcCmntLen);
    blockwrite(temparc,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 12 then DiskFull;
    if ArcCmntLen > 0 then
    begin
    	BlockWrite(temparc,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> ArcCmntLen then DiskFull;
    end;

	if arcexist then
    begin
        while not eof(arcfile) do
        begin
       	    if PressEsc then
           	begin
	            broken := true;
		       	close(arcfile);
       	        close(temparc);
        	    erase(temparc);
				close(rqstfile);
   				exit;
            end;


            fileinarc := filepos(arcfile);
            blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        Move(FileHeader[0],i,2);
    	    if i <> $1C94 then
            begin
    	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
    	       	close(arcfile);
                close(temparc);
                erase(temparc);
				close(rqstfile);
        		exit;
            end;

            Move(FileHeader[10],Time,4);
            FPath := ''; FName := ''; FExt := '';
            PathLen := FileHeader[32];
			if PathLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            for i := 1 to PathLen do
            	Fpath := Fpath + chr(PosBuf[i-1]);
            FileCmntLen := FileHeader[33] + 256*FileHeader[34];
			if FileCmntLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            Move(FileHeader[2],flen,4);
            if (FileHeader[16] and $80) <> 0 then
            begin
	            seek(arcfile, fileinarc + flen);
				continue;
            end;
            for i := 1 to 8 do
              	if fileheader[20+i] <> 0 then
                   	FName := FName + chr(FileHeader[20+i])
                 else
                   	break;
            for i := 1 to 3 do
	           	if  fileheader[28+i] <> 0 then
       				FExt := FExt + chr(fileheader[28+i])
                else
                   	break;
            ms := FName + FExt;
            seek(rqstfile,rqstfn);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            match := false;

            while not eof(rqstfile) and not(match) do
            begin

       		    if PressEsc then
           		begin
		            broken := true;
			       	close(arcfile);
    	   	        close(temparc);
        		    erase(temparc);
					close(rqstfile);
	   				exit;
    	        end;

               	read(rqstfile,pths);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		        delname := pths;
{	            delete(pths,1,length(rqstpath));}
	            if pths[1] = '\' then
	            	delete(pths,1,1);
                findfirst(pths,AttrMask,sr);
                fsplit(pths,FPath,FName,FExt);
                if FPath[1] = '\' then delete(FPath,1,1);
                if length(FExt) > 0 then
	                delete(FExt,1,1);
                ws := FName + FExt;
                if ws = ms then
                begin
                   	match := true;
                    seek(rqstfile,filepos(rqstfile) - 1);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                    ws := '';
                    write(rqstfile,ws);
                end;
            end;

            if match then
            begin
               	textname := pths;
   	            broken := false;
            	if Time < sr.time then
                begin

        	        EncodFile;

	                if delaftarc then
    	            begin
	    	            write(delfile,delname);
    					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	                end;

	                seek(arcfile, fileinarc + flen);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                end
                else
                begin
	               	CopyArcFile;
				    inc(procfiles);
                    procbytes := procbytes + sr.size;
				    dosx := wherex; dosy := wherey; window(1,1,80,25);
				    textbackground(cyan); textcolor(white);
                    gotoxy(69,21);write(procbytes);
                    i := trunc(41 * procbytes / selbytes);
                    s := ''; for j := 1 to i do s := s + '';
                    gotoxy(20,21); textcolor(yellow); write(s);
			        if keypressed then begin c := readkey; if ord(c) = 27 then begin broken := true; exit; end; end;
				    window(2,3,79,18); gotoxy(dosx,dosy);
				    textbackground(blue); textcolor(white);
            	end;
           	    if broken then
               	begin
   			       	close(arcfile);
        	        close(temparc);
   	        	    erase(temparc);
					close(rqstfile);
       				exit;
                end;
            end
            else
            begin
               	CopyArcFile;
            end;
        end;
    end;
    dosx := wherex; dosy := wherey; window(1,1,80,25);
    textbackground(cyan); textcolor(white);
    gotoxy(69,21);write(procbytes);
    s := ''; for j := 1 to 41 do s := s + '';
    gotoxy(20,21); textcolor(yellow); write(s);
    if keypressed then begin c := readkey; if ord(c) = 27 then begin broken := true; exit; end; end;
    window(2,3,79,18); gotoxy(dosx,dosy);
	textbackground(blue); textcolor(white);
    hidecursor;
	close(rqstfile);
   	close(temparc);
    CopyTempArc;
    if delaftarc then
    begin
		seek(delfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    while not eof(delfile) do
    	begin
            if PressEsc then
            	break;
	      	read(delfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    WorkingWin('Deleting ' + ws);
	        assign(f,ws);
            SetFAttr(f,Archive);
    	    erase(f);
	    end;
    	close(delfile);
	    erase(delfile);
    end;
end;


procedure UpdateArchive;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(36 - (length(ArcDOSName) div 2),2); writeln(' Updating ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    if delaftarc then
    begin
		rewrite(delfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;

    if arcexist then
    begin
    	seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        BlockRead(arcfile,ArcHeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(ArcHeader[10],ArcCmntLen,2);
        if ArcCmntLen > 0 then
        begin
        	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	end;
    end
    else
    begin
	    FillChar(ArcHeader,12,0);
        ArcHeader[0] := $AD; ArcHeader[1] := $36;
        ArcHeader[2] := $22;
    	ArcCmntLen := 0;
        if ADrive > 2 then
        	assign(temparc,ArcName);
    end;

    if length(CmntFileName) > 0 then
    begin
        findfirst(CmntFileName,Archive,sr);
        if DosError <> 0 then
        begin
	       	MessageWin('File ' + CmntFileName + ' not found');
    	    exit;
        end
        else
        begin
            assign(CmntFile, CmntFileName);
		    filemode := 0;
            reset(CmntFile, 1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            li := filesize(CmntFile);
            if li > 8192 then
            	ArcCmntLen := 8192
            else
            	ArcCmntLen := li;
            BlockRead(CmntFile,PosBuf,ArcCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            close(CmntFile);
        end;
    end;

    ArcHeader[10] := lo(ArcCmntLen);
 	ArcHeader[11] := hi(ArcCmntLen);
    rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    blockwrite(temparc,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 12 then DiskFull;
    if ArcCmntLen > 0 then
    begin
    	BlockWrite(temparc,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> ArcCmntLen then DiskFull;
	end;

	if arcexist then
    begin
        while not eof(arcfile) do
        begin
            fileinarc := filepos(arcfile);
            blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        Move(FileHeader[0],i,2);
    	    if i <> $1C94 then
            begin
    	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
    	       	close(arcfile);
                close(temparc);
                erase(temparc);
				close(rqstfile);
        		exit;
            end;

            Move(FileHeader[10],Time,4);
            FPath := ''; FName := ''; FExt := '';
            PathLen := FileHeader[32];
			if PathLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            for i := 1 to PathLen do
            	Fpath := Fpath + chr(PosBuf[i-1]);
            FileCmntLen := FileHeader[33] + 256*FileHeader[34];
			if FileCmntLen > 0 then
            begin
            	BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            end;
            Move(FileHeader[2],flen,4);
            if (FileHeader[16] and $80) <> 0 then
            begin
	            seek(arcfile, fileinarc + flen);
				continue;
            end;
            for i := 1 to 8 do
              	if fileheader[20+i] <> 0 then
                   	FName := FName + chr(FileHeader[20+i])
                 else
                   	break;
            for i := 1 to 3 do
	           	if  fileheader[28+i] <> 0 then
       				FExt := FExt + chr(fileheader[28+i])
                else
                   	break;
            ms := FName + FExt;
            seek(rqstfile,rqstfn);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            match := false;
            while not eof(rqstfile) and not(match) do
            begin
               	read(rqstfile,pths);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		        delname := pths;
{	            delete(pths,1,length(rqstpath));}
	            if pths[1] = '\' then
	            	delete(pths,1,1);
                findfirst(pths,AttrMask,sr);
                fsplit(pths,FPath,FName,FExt);
                if FPath[1] = '\' then delete(FPath,1,1);
                if length(FExt) > 0 then
	                delete(FExt,1,1);
                ws := FName + FExt;
                if ws = ms then
                begin
                   	match := true;
                    seek(rqstfile,filepos(rqstfile) - 1);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                    ws := '';
                    write(rqstfile,ws);
                end;
            end;

            if match then
            begin
               	textname := pths;
   	            broken := false;
            	if Time < sr.time then
                begin

        	        EncodFile;

	                if delaftarc then
    	            begin
	    	            write(delfile,delname);
    					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	                end;

	                seek(arcfile, fileinarc + flen);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                end
                else
                begin
	               	CopyArcFile;
				    inc(procfiles);
                    procbytes := procbytes + sr.size;
				    dosx := wherex; dosy := wherey; window(1,1,80,25);
				    textbackground(cyan); textcolor(white);
                    gotoxy(69,21);write(procbytes);
                    i := trunc(41 * procbytes / selbytes);
                    s := ''; for j := 1 to i do s := s + '';
                    gotoxy(20,21); textcolor(yellow); write(s);
			        if keypressed then begin c := readkey; if ord(c) = 27 then begin broken := true; exit; end; end;
				    window(2,3,79,18); gotoxy(dosx,dosy);
				    textbackground(blue); textcolor(white);

            	end;
           	    if broken then
               	begin
	    	   		MessageWin( 'User break');
   			       	close(arcfile);
        	        close(temparc);
   	        	    erase(temparc);
					close(rqstfile);
       				exit;
                end;
            end
            else
            begin
               	CopyArcFile;
            end;
        end;
    end;

    seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
    	read(rqstfile,textname);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        delname := textname;
		if length(textname) > 0 then
        begin
           	FileCmntLen := 0;
            broken := false;

		    EncodFile;

            if delaftarc then
            begin
	            write(delfile,delname);
    			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        end;

            if broken then
            begin
   		       	close(arcfile);
       	        close(temparc);
           	    erase(temparc);
				close(rqstfile);
       			exit;
            end;
        end;
    end;
    dosx := wherex; dosy := wherey; window(1,1,80,25);
    textbackground(cyan); textcolor(white);
    gotoxy(69,21);write(procbytes);
    s := ''; for j := 1 to 41 do s := s + '';
    gotoxy(20,21); textcolor(yellow); write(s);
    if keypressed then begin c := readkey; if ord(c) = 27 then begin broken := true; exit; end; end;
    window(2,3,79,18); gotoxy(dosx,dosy);
	textbackground(blue); textcolor(white);
    hidecursor;
	close(rqstfile);
   	close(temparc);
    if (arcexist) or (ADrive < 3) then
    begin
	    CopyTempArc;
    end;
    if delaftarc then
    begin
		seek(delfile,0);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    while not eof(delfile) do
    	begin
            if PressEsc then
            	break;
	      	read(delfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    WorkingWin('Deleting ' + ws);
	        assign(f,ws);
            SetFAttr(f,Archive);
    	    erase(f);
	    end;
    	close(delfile);
	    erase(delfile);
    end;

end;

procedure CheckPath;
var
	ss : pathstr;
begin
    if length(FPath) > 0 then
	begin
        ms := FPath;
        ss := tardir;
        while length(ms) > 0 do
        begin
        	i := Pos('\',ms);
            ws := copy(ms,1,i-1);
            delete(ms,1,i);
            if ss[length(ss)] <> '\' then ss := ss + '\';
            ss := ss + ws;
		    FindFirst(ss + '\.',Directory,sr);
	    	if DosError <> 0 then
		    begin
	    		MkDir(ss);
		    end;
        end;
	end;
end;


procedure ExtractFile;
var
	c : char;

begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(34 - (length(ArcDOSName) div 2),2); writeln(' Extracting from ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    seek(arcfile,0);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    BlockRead(arcfile,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    Move(ArcHeader[10],ArcCmntLen,2);
    if ArcCmntLen > 0 then
    begin
    	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        writeln('');
		for i := 0 to ArcCmntLen - 1 do
        begin
        	write(chr(PosBuf[i]));
        end;
        writeln('');
    end;

	seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
        read(rqstfile,ws);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        val(ws,FileHdrPos,i);
        seek(arcfile,FileHdrPos);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;

        blockread(arcfile,FileHeader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(FileHeader[0],i,2);
   	    if i <> $1C94 then
        begin
   	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
   	       	close(arcfile);
			close(rqstfile);
       		exit;
        end;

		Move(FileHeader[6],TextFileSize,4);
        if (FileHeader[16] and $80) <> 0 then
        begin
			continue;
        end;

        FPath := ''; FName := ''; FExt := '';
		PathLen := FileHeader[32];
		if PathLen > 0 then
        begin
           	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        end;
        if excldpth then
           	PathLen := 0;
        for i := 1 to PathLen do
        	FPath := FPath + chr(PosBuf[i-1]);

        for i := 1 to 8 do
        	if FileHeader[20+i] <> 0 then
            	FName := FName + chr(FileHeader[20+i]);
        for i := 1 to 3 do
        	if FileHeader[28+i] <> 0 then
            	FExt := FExt + chr(FileHeader[28+i]);

        if not excldpth then
        	CheckPath;
        if (TarDir[length(TarDir)] <> '\') and (Length(TarDir) > 0) then
            TarDir := TarDir + '\';
        if (FPath[length(FPath)] <> '\') and (Length(FPath) > 0) then
            FPath := FPath + '\';
        textname := tardir + FPath + FName + '.' + FExt;
        if textname[length(textname)] = '.' then
        	delete(textname,length(textname),1);
        TextDOSName := FName + '.' + FExt;
        if TextDOSName[length(TextDOSName)] = '.' then
        	delete(TextDOSName,length(TextDOSName),1);
        assign(temparc, textname);

		writeln(''); write(textname);

        if querybefovr then
   		begin
	        findfirst(textname,Archive + ReadOnly + Hidden + SysFile,sr);
		    if DosError = 0 then
        	begin
		        dosx := wherex; dosy := wherey;
       		    BottomLine('File ' + TextDOSName + ' exist. Overwrite Y/N: ', lightred + blink);
				repeat
    	        	c := WaitKey;
        	        c := upcase(c);
	   	       	until (ord(c) = 13) or (c = 'Y') or (c = 'N') or (ord(c) = 27);
    	        if ord(c) = 27 then
        	    begin
		        	broken := true;
    	   	        exit;
        	   	end;
			  	BottomLine('                                                                ',black);
				window(2,3,79,18); textbackground(blue); textcolor(white);
				showcursor; gotoxy(dosx,dosy);
	    		if c = 'N' then
    	        begin
	       			write('   Skiped');

				    inc(procfiles);
			        procbytes := procbytes + TextFileSize;
					dosx := wherex; dosy := wherey; window(1,1,80,25);
				    textbackground(cyan); textcolor(white);
                    gotoxy(69,21);write(procbytes);
                    i := trunc(41 * procbytes / selbytes);
                    s := ''; for j := 1 to i do s := s + '';
                    gotoxy(20,21); textcolor(yellow); write(s);
			        window(2,3,79,18); gotoxy(dosx,dosy);
				    textbackground(blue); textcolor(white);

    	            continue;
	            end
    	        else
        	    begin
                    SetFAttr(temparc,Archive);
				    filemode := 2;
	                reset(temparc,1);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	            end;
    	    end
        	else
	        begin
				rewrite(temparc,1);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	    end;
        end
        else
        begin
			rewrite(temparc,1);
            myiorslt:=ioresult;
            if myiorslt <> 0 then
	            SetFAttr(temparc,Archive);
			rewrite(temparc,1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
   	    end;

        if (FileHeader[15] and 1) <> 0 then filebecont := true else filebecont := false;

    	FileCmntLen := FileHeader[33] + FileHeader[34]*256;

	    if FileCmntLen > 0 then
        begin
	    	BlockRead(ArcFile,PosBuf,FileCmntLen,i);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        writeln('');
			for i := 0 to FileCmntLen - 1 do
            begin
	        	write(chr(PosBuf[i]));
            end;
	        writeln('');
    	end;

	    TextFileCnt := 0;
        broken := false;

		DecodFile;

        if broken then
        begin
	       	close(arcfile);
   	        close(temparc);
       	    erase(temparc);
			close(rqstfile);
  			exit;
        end;

	    Move(FileHeader[10],Time,4);
	    SetFTime(temparc,Time);

	    close(temparc);

		Attr := FileHeader[14];
	    SetFAttr(temparc,Attr);

		Move(FileHeader[17],li,4);
        if (length(password) > 0) and ((FileHeader[15] and 4) <> 0) then
        	li := li xor pass;
        if crc = li then
        begin
   			write('   CRC OK');
        end
        else
        begin
			erase(temparc);
        	write('   Bad CRC! File not extracted.');
            sound(400); delay(200); nosound;
    	end;
    end;
    hidecursor;
	close(rqstfile);
    close(arcfile);
end;


procedure ExtractMVA;
var
	i : word;
begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(33 - (length(arcDOSname) div 2),2); writeln(' Extracting from ',arcDOSname,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    ArcSize := filesize(arcfile);
    seek(arcfile,0);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    BlockRead(arcfile,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    Move(ArcHeader[10],ArcCmntLen,2);
    if ArcCmntLen > 0 then
    begin
    	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        writeln('');
		for i := 0 to ArcCmntLen - 1 do
        begin
        	write(chr(PosBuf[i]));
        end;
        writeln('');
    end;

    fileinarc := filepos(arcfile);

    while fileinarc < ArcSize do
    begin
        seek(arcfile,fileinarc);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockread(arcfile,FileHeader,35);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(FileHeader[0],i,2);
   	    if i <> $1C94 then
        begin
   	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
   	       	close(arcfile);
       		exit;
        end;

        FPath := ''; FName := ''; FExt := '';
		PathLen := FileHeader[32];

		if PathLen > 0 then
        begin
           	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	end;

        if excldpth then
           	PathLen := 0;

        for i := 1 to PathLen do
        	FPath := FPath + chr(PosBuf[i-1]);

        for i := 1 to 8 do
        	if FileHeader[20+i] <> 0 then
            	FName := FName + chr(FileHeader[20+i]);
        for i := 1 to 3 do
        	if FileHeader[28+i] <> 0 then
            	FExt := FExt + chr(FileHeader[28+i]);

       if not excldpth then
	        CheckPath;

        if (TarDir[length(TarDir)] <> '\') and (Length(TarDir) > 0) then
            TarDir := TarDir + '\';
        if (FPath[length(FPath)] <> '\') and (Length(FPath) > 0) then
            FPath := FPath + '\';
        textname := TarDir + FPath + FName + '.' + FExt;
        if textname[length(textname)] = '.' then
        	delete(textname,length(textname),1);
        TextDOSName := FName + '.' + FExt;
        if TextDOSName[length(TextDOSName)] = '.' then
        	delete(TextDOSName,length(TextDOSName),1);
        assign(temparc, textname);

		writeln(''); write(textname);
        findfirst(textname,Archive + ReadOnly + Hidden + SysFile,sr);
	    if DosError = 0 then
        begin
            SetFAttr(temparc,Archive);
		    filemode := 2;
	        reset(temparc,1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
   	    end
       	else
        begin
			rewrite(temparc,1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
   	    end;

        if (FileHeader[15] and 1) <> 0 then filebecont := true else filebecont := false;
		Move(FileHeader[6],TextFileSize,4);
		Move(FileHeader[2],CmprFileSize,4);
        if (FileHeader[16] and $80) <> 0 then
        begin
            fileinarc := fileinarc + CmprFileSize;
			continue;
        end;

    	FileCmntLen := FileHeader[33] + FileHeader[34]*256;

	    if FileCmntLen > 0 then
        begin
	    	BlockRead(ArcFile,PosBuf,FileCmntLen,i);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        writeln('');
			for i := 0 to FileCmntLen - 1 do
            begin
	        	write(chr(PosBuf[i]));
            end;
	        writeln('');
    	end;


	    TextFileCnt := 0;
        broken := false;

		DecodFile;

        if broken then
        begin
	       	close(arcfile);
		    close(temparc);
       	    erase(temparc);
  			exit;
        end;

	    Move(FileHeader[10],Time,4);
	    SetFTime(temparc,Time);

	    close(temparc);

		Attr := FileHeader[14];
	    SetFAttr(temparc,Attr);

		Move(FileHeader[17],li,4);
        if (length(password) > 0) and ((FileHeader[15] and 4) <> 0) then
        	li := li xor pass;
        if crc = li then
        begin
		    gotoxy(length(textname) + 5,wherey);
   			write('CRC OK');
        end
        else
        begin
			erase(temparc);
		    gotoxy(length(textname) + 5,wherey);
        	write('Bad CRC! File not extracted.');
            sound(400); delay(200); nosound;
    	end;

        fileinarc := fileinarc + CmprFileSize;
    end;
    close(arcfile);
end;

procedure TestIntegrity;
var
	c : char;

begin
    i := InitMemLzw;
    if i <> cmMemOk then
    begin
		MessageWin('Not enough memory ');
        close(arcfile);
        exit;
    end;

    InfoWin;
    window(1,1,80,25); textbackground(blue); textcolor(white);
	gotoxy(30 - (length(ArcDOSName) div 2),2); writeln(' Testing Integrity of ',ArcDOSName,' ');
    window(2,3,79,18); textbackground(blue); textcolor(white);
    dosx := wherex; dosy := wherey;

    seek(arcfile,0);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    BlockRead(arcfile,ArcHeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    Move(ArcHeader[10],ArcCmntLen,2);
    if ArcCmntLen > 0 then
    begin
    	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        writeln('');
		for i := 0 to ArcCmntLen - 1 do
        begin
        	write(chr(PosBuf[i]));
        end;
        writeln('');
    end;

	seek(rqstfile,rqstfn);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(rqstfile) do
    begin
        read(rqstfile,ws);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        val(ws,FileHdrPos,i);
        seek(arcfile,FileHdrPos);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;

        blockread(arcfile,FileHeader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        Move(FileHeader[0],i,2);
   	    if i <> $1C94 then
        begin
   	   		MessageWin( ' Structure of ' + ArcDOSName + ' is damaged');
   	       	close(arcfile);
			close(rqstfile);
       		exit;
        end;

		Move(FileHeader[6],TextFileSize,4);

        if (FileHeader[16] and $80) <> 0 then
        begin
			continue;
        end;

        FPath := ''; FName := ''; FExt := '';
		PathLen := FileHeader[32];
		if PathLen > 0 then
        begin
           	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        end;
        if excldpth then
           	PathLen := 0;
        for i := 1 to PathLen do
        	FPath := FPath + chr(PosBuf[i-1]);

        for i := 1 to 8 do
        	if FileHeader[20+i] <> 0 then
            	FName := FName + chr(FileHeader[20+i]);
        for i := 1 to 3 do
        	if FileHeader[28+i] <> 0 then
            	FExt := FExt + chr(FileHeader[28+i]);

        TextDOSName := FName + '.' + FExt;
        if TextDOSName[length(TextDOSName)] = '.' then
        	delete(TextDOSName,length(TextDOSName),1);
		textname := TextDOSName;
		writeln(''); write(textname);

        if (FileHeader[15] and 1) <> 0 then filebecont := true else filebecont := false;

    	FileCmntLen := FileHeader[33] + FileHeader[34]*256;

	    if FileCmntLen > 0 then
        begin
	    	BlockRead(ArcFile,PosBuf,FileCmntLen,i);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        writeln('');
			for i := 0 to FileCmntLen - 1 do
            begin
	        	write(chr(PosBuf[i]));
            end;
	        writeln('');
    	end;

	    TextFileCnt := 0;
        broken := false;

		DecodFile;

        if broken then
        begin
	       	close(arcfile);
			close(rqstfile);
  			exit;
        end;

		Move(FileHeader[17],li,4);
        if (length(password) > 0) and ((FileHeader[15] and 4) <> 0) then
        	li := li xor pass;
        if crc = li then
        begin
   			write('   CRC OK');
        end
        else
        begin
        	write('   Bad CRC!');
            sound(400); delay(200); nosound;
    	end;
    end;
    hidecursor;
	close(rqstfile);
    close(arcfile);
end;




begin
    if (ParamCount <> 4) or (ParamStr(4) <> 'joro') then
    begin
    	writeln;
        writeln(' Incorect start of program!');
        halt(1);
    end;
    criterr := false;
    SetIntVec($24,addr(MyInt24h));
    startdir := ParamStr(1);
    workdir := ParamStr(2);
    AMGdir := ParamStr(3);
    Init;
    procfiles := 0; procbytes := 0;

    filemode := 2;
	reset(rqstfile);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    read(rqstfile,cmnd);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    read(rqstfile,ArcName);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    read(rqstfile,TarDir);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;

    read(rqstfile,ws);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	s := copy(ws,1,5);
    val(s,selfiles,i);
    s := copy(ws,6,9);
    val(s,selbytes,i);
	s := copy(ws,15,5);
    val(s,ProFilTyp,i);
    AttrMask := Archive + ReadOnly;
	if (ProFilTyp and 1) <> 0 then
	   	AttrMask := AttrMask + Hidden;
	if (ProFilTyp and 2) <> 0 then
       	AttrMask := AttrMask + SysFile;

    read(rqstfile,ws);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    c := ws[1];
	case c of
    	's' : Method := SuperFastCompr;
    	'f' : Method := FastCompr;
    	'l' : Method := LessMemCompr;
        'n' : Method := NormalCompr;
        'm' : Method := MaxCompr;
    end;
   	c := ws[3];
    if c = 'd' then
   	   	delaftarc := true
	else
		delaftarc := false;
   	c := ws[5];
    if c = 'q' then
   	   	querybefovr := true
	else
		querybefovr := false;

    read(rqstfile,ws);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	password := ws;
    if length(password) > 0 then
    begin
    	fillchar(PosBuf,4,0);
        j := 0;
        for i := 1 to length(password) do
        begin
        	PosBuf[j] := PosBuf[j] xor ord(password[i]);
            inc(j);
            j := j and 3;
        end;
        move(PosBuf,pass,4);
    end;

    read(rqstfile,CmntFileName);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    read(rqstfile,ws);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;
    ArcDOSName := AName + AExt;
    if ArcDOSName[length(ArcDOSName)] = '.' then
    	delete(ArcDOSName,length(ArcDOSName),1);

    findfirst(arcname,archive,sr);
    if DosError <> 0 then
    begin
        arcexist := false;
       	assign(arcfile,arcname);
		rewrite(arcfile);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end
    else
    begin
   		assign(arcfile,arcname);
	    filemode := 2;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if filesize(arcfile) > 11 then
            arcexist := true
        else
        begin
           	MessageWin(ArcDOSName + ' is not AMG Archive');
		    showcursor;
		    textbackground(black); textcolor(lightgray);
		    clrscr;
            halt(1);
		end;
	end;

    if cmnd = 'add' then
 		AddFile
    else
    	if cmnd = 'freshen' then
			FreshenArchive
        else
    		if cmnd = 'update' then
				UpdateArchive
            else
  				if (cmnd = 'extract') then
                begin
                  	excldpth := true;
					ExtractFile;
                end
                else
                   	if cmnd = 'MVA' then
                       	MVA
                    else
	                   	if cmnd = 'SEA' then
		                   	SEA
                        else
                           	if (cmnd = 'extractpath') then
                            begin
                               	excldpth := false;
                                ExtractFile;
                            end
                            else
	                           	if cmnd = 'extractmva' then
    	                        begin
        	                       	excldpth := false;
            	                    ExtractMVA;
                	            end
                                else
                                begin
		                           	if cmnd = 'test' then
    		                        begin
                                        TstInt := true;
            		                    TestIntegrity;
                		            end;
                                end;
end.