

program mAMG;

uses Crt, Dos, printer, Objects, Drivers, Memory, Views, Menus, Dialogs,
  StdDlg, MsgBox, App, Editors, FV, mendef, defamg, rgaamg;

type
    PStatTxt = ^TStatTxt;
    TStatTxt = object(TStaticText)
    	constructor Init(R: TRect; S : String);
        function GetPalette : PPalette; virtual;
	end;

    PPrmTxt = ^TPrmTxt;
    TPrmTxt = object(TParamText)
    	constructor Init(R: TRect; S : String; PrmCount: integer);
        function GetPalette : PPalette; virtual;
	end;

    PSelTxt = ^TSelTxt;
    TSelTxt = object(TParamText)
    	constructor Init(R: TRect; S : String; PrmCount: integer);
        function GetPalette : PPalette; virtual;
	end;

	PStrList = ^TStrList;
    TStrList = object(TCollection)
        constructor Init;
    	procedure FreeItem(Item : Pointer); virtual;
    end;


	PDirFileList = ^TDirFileList;
    TDirFileList = object(TSortedCollection)
        constructor Init;
    	procedure FreeItem(Item : Pointer); virtual;
        function Compare(Key1, Key2 : Pointer) : integer; virtual;
    end;

	PDirFileBox = ^TDirFileBox;
    TDirFileBox = object(TListBox)
	    DirFileList : PDirFileList;
        DirList : PStrList;
    	constructor Init(R:TRect; vSB : PScrollBar);
        destructor Done; virtual;
        function GetPalette : PPalette; virtual;
        function GetText(i : integer; m : integer) : string; virtual;
		procedure ScanDir;
        procedure SelCount;
        procedure MakeRqstFile;
        procedure GetComment;
        procedure PutComment;
    end;


    PDirFileWin = ^TDirFileWin;
	TDirFileWin = object(TWindow)
    	vSB : PScrollBar;
        PathTxt : PPrmTxt;
        SelTxt : PSelTxt;
		EW, EditFileWin : PEditWindow;
   		ComWin, ViewFileWin : PWindow;
    	DirFileBox : PDirFileBox;
		constructor Init;
  		procedure HandleEvent(var Event : TEvent); virtual;
        procedure Draw; virtual;
        procedure ViewComment;
        procedure EditComment;
        procedure CloseComment;
		procedure SelOne;
		procedure SelOneNxt;
		procedure SelAll;
		procedure SelAllDir;
		procedure UnSelAll;
		procedure PerWillcards;
        procedure FromTo;
        procedure Before;
        procedure After;
        procedure Today;
        procedure ToBottom;
        procedure ToTop;
        procedure PrnCmnt;
        procedure PrnDir;
    	procedure CopyDirFile;
        procedure DelDirFile;
        procedure ViewFile;
        procedure EditFile;
    	procedure DownDir;
        procedure UpDir;
        procedure ModFileMask;
	end;

	PArcFileList = ^TArcFileList;
    TArcFileList = object(TSortedCollection)
        constructor Init;
    	procedure FreeItem(Item : Pointer); virtual;
        function Compare(Key1, Key2 : Pointer) : integer; virtual;
    end;


	PArcFileBox = ^TArcFileBox;
    TArcFileBox = object(TListBox)
	    ArcFileList : PArcFileList;
    	constructor Init(R:TRect; vSB : PScrollBar);
        destructor Done; virtual;
        function GetPalette : PPalette; virtual;
        function GetText(i : integer; m : integer) : string; virtual;
		procedure ScanArc;
		procedure SelCount;
        procedure MakeRqstFile;
        procedure GetComment;
        procedure PutComment;
    end;


    PArcFileWin = ^TArcFileWin;
	TArcFileWin = object(TWindow)
    	vSB : PScrollBar;
        ArcTxt, TotalTxt : PPrmTxt;
        SelTxt : PSelTxt;
		EW : PEditWindow;
   		ComWin : PWindow;
    	ArcFileBox : PArcFileBox;
		constructor Init;
  		procedure HandleEvent(var Event : TEvent); virtual;
        procedure Draw; virtual;
        procedure ViewComment;
        procedure EditComment;
        procedure CloseComment;
    	procedure DeleteArcFile;
		procedure SelOne;
		procedure SelOneNxt;
		procedure SelAll;
		procedure UnSelAll;
		procedure PerWillcards;
        procedure FromTo;
        procedure Before;
        procedure After;
        procedure Today;
        procedure ToBottom;
        procedure ToTop;
        procedure PrnCmnt;
        procedure PrnArc;
	end;



	PMyApp = ^TMyApp;
	TMyApp = object(TApplication)
	    DirFileWin : PDirFileWin;
    	ArcFileWin : PArcFileWin;
        HelpWin : PWindow;
	    constructor Init;
        destructor Done; virtual;
    	procedure InitStatusLine; virtual;
	    procedure InitMenuBar; virtual;
  		procedure HandleEvent(var Event : TEvent); virtual;
    	procedure ViewArchive;
        procedure CloseArchive;
	    procedure AddDirFile;
        procedure MVA;
        procedure SEA;
    	procedure FreshenArchive;
    	procedure UpdateArchive;
	    procedure ExtractArcFile;
	    procedure ExtractArcPath;
	    procedure ExtractMVA;
        procedure TestIntegrity;
    	procedure ChCurDir;
        procedure ViewHelp;
        procedure CloseWin;
        procedure Sort;
        procedure SaveOpt;
        procedure Preferences;
        procedure PrintOrderForm;
        procedure GoDos;
	end;


var
	MyApp: TMyApp;



procedure TMyApp.PrintOrderForm;
var

	OrderRec : TOrderRec;
    s1, s2, s3 : string[20];
begin
	with OrderRec do
    begin
    	name := '';
        company := '';
        address := '';
        city := '';
        stt := '';
        zipcode := '';
        country := '';
        email := '';
        fax := '';
        date := '';
        payment := 0;
        diskette := 0;
        language := 0;
	end;

    i := Application^.ExecuteDialog(New(POrderDlg, Init), @OrderRec);
    if i <> cmCancel then
    begin
	    i := MessageBox('   Is the printer ready?', nil, mfConfirmation + mfYesButton + mfNoButton);
    	if i <> cmYes then
        	exit;
	    WorkingWin('Printing...');
        with OrderRec do
        begin
			writeln(lst,'');
            writeln(lst,'         AMG ORDER FORM INDIVIDUAL USE');
            writeln(lst,'         -----------------------------');
            writeln(lst,'');
            writeln(lst,'');
    	    writeln(lst,'TO:                          Date: ' + date);
            writeln(lst,'     Milen Georgiev');
            writeln(lst,'     P.O.Box 533');
            writeln(lst,'     Varna 9000');
            writeln(lst,'     Bulgaria');
            writeln(lst,'');
            writeln(lst,'');
            writeln(lst,'FROM:');
            writeln(lst,'');
            writeln(lst,'     Name: ' + name);
            writeln(lst,'');
            writeln(lst,'  Company: ' + company);
            writeln(lst,'');
            writeln(lst,'  Address: ' + address);
            writeln(lst,'');
			writeln(lst,'     City: ' + city);
            writeln(lst,'');
			writeln(lst,'    State: ' + stt + '    Zip Code: ' + zipcode);
            writeln(lst,'');
			writeln(lst,'  Country: ' + country);
            writeln(lst,'');
			writeln(lst,'    E-Mail: ' + email + '   Fax: ' + fax);
            writeln(lst,'');
            if payment = 0 then
            	s1 := 'Check'
            else
            	s1 := 'Money Order';
            if diskette = 0 then
            	s2 := '5.25"'
            else
            	s2 := '3.5"';
            if language = 0 then
            	s3 := 'English'
            else
            	s3 := 'Deutsche';
            writeln(lst,'   Payment method: ' + s1 + '    Diskette size: ' + s2);
            writeln(lst,'   Language: ' + s3);
            writeln(lst,'');
			writeln(lst,'      Enclosed Registration fee  US$30')
        end;
	end;
    if ArcFileWin = nil then
	    DirFileWin^.DrawView
    else
    	ArcFileWin^.DrawView;
end;



procedure PutPar;
begin
    write(rqstfile,ArcName);
    write(rqstfile,TarDir);
    str(selfiles:5,ws);
    str(selbytes:9,s);
    ws := ws + s;
    str(ProFilTyp:5,s);
    ws := ws + s;
    str(SortKey:5,s);
    ws := ws + s;
    str(SortMtd:5,s);
    ws := ws + s;
    dirfoc := MyApp.DirFileWin^.DirFileBox^.Focused;
    str(dirfoc:5,s);
    ws := ws + s;
    arcfoc := MyApp.ArcFileWin^.ArcFileBox^.Focused;
    str(arcfoc:5,s);
    ws := ws + s;
    str(twocol:5,s);
    ws := ws + s;
    write(rqstfile,ws);
	case Method of
        SuperFastCompr : ws := 's';
    	FastCompr      : ws := 'f';
        LessMemCompr    : ws := 'l';
        NormalCompr    :ws  := 'n';
        MaxCompr       : ws := 'm';
    end;
    if delaftarc then
    	ws := ws + ' d'
    else
    	ws := ws + '  ';
    if querybefovr then
    	ws := ws + ' q'
    else
    	ws := ws + '  ';
    if MyApp.ArcFileWin <> nil then
    	ws := ws + ' o'
    else
    	ws := ws + '  ';
    write(rqstfile,ws);

    ws := password;
    write(rqstfile,ws);
    write(rqstfile,CmntFileName);
    write(rqstfile,filemask);
end;



procedure TMyApp.Preferences;
var
	i : integer;
    Pref : PrefRec;
    awo : boolean;
    oldtwocol : word;

begin
	Pref.mtd := Method;
    Pref.filpro := ord(delaftarc) + 2 * ord(querybefovr);
	Pref.typfil := ProFilTyp;
    Pref.twocol := twocol;
    oldtwocol := twocol;
    i := Application^.ExecuteDialog(New(PPrefDlg, Init), @Pref);
    if i <> cmCancel then
    begin
    	Method := Pref.mtd;
        if (Pref.filpro and 1) = 0 then
        	delaftarc := false
        else
        	delaftarc := true;
        if (Pref.filpro and 2) = 0 then
        	querybefovr := false
        else
        	querybefovr := true;

        ProFilTyp := Pref.typfil;
        AttrMask := Archive + ReadOnly;
		if (ProFilTyp and 1) <> 0 then
        	AttrMask := AttrMask + Hidden + SysFile;
        twocol := Pref.twocol;
        if twocol <> oldtwocol then
        begin
			rewrite(rqstfile);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
			ws := 'reset';
		    write(rqstfile,ws);
		    PutPar;
		    closefilepath(rqstfile);

			Event.What := evCommand;
		    Event.Command := cmQuit;
		    PutEvent(Event);
		end;
    end;
end;




constructor TStatTxt.Init(R : TRect; S : String);
begin
	inherited Init(R, S);
end;

function TStatTxt.GetPalette : PPalette;
const
  MyPal : String[length(CStaticText)] = #3;
begin
  GetPalette := @MyPal;
end;


constructor TPrmTxt.Init(R : TRect; S : String; PrmCount : integer);
begin
	inherited Init(R, S, PrmCount);
    ParamList := @PrmAr;
end;

function TPrmTxt.GetPalette : PPalette;
const
  MyPal : String[length(CStaticText)] = #3;
begin
  GetPalette := @MyPal;
end;


constructor TSelTxt.Init(R : TRect; S : String; PrmCount : integer);
begin
	inherited Init(R, S, PrmCount);
    ParamList := @PrmAr;
end;

function TSelTxt.GetPalette : PPalette;
const
  MyPal : String[length(CStaticText)] = #5;
begin
  GetPalette := @MyPal;
end;


function GetListName(s : string) : string;
var
	i : word;
    ss : string;
begin

	ss := '';
    for i := 3 to 10 do
	    if s[i] <> ' ' then
    		ss := ss + s[i];
    if s[12] <> ' ' then
    begin
    	ss := ss + '.';
	    for i := 12 to 14 do
		    if s[i] <> ' ' then
    			ss := ss + s[i];
    end;
    GetListName := ss;
end;


function LeadZero(a : word) : string;
var
	s : string;

begin
	str(a:2,s);
    if s[1] = ' ' then s[1] := '0';
    LeadZero := s;
end;




{ TStrList }

constructor TStrList.Init;
begin
	inherited Init(10,5);
end;

procedure TStrList.FreeItem(Item : Pointer);
begin
	DisposeStr(Item);
end;


{ TDirFileList }

constructor TDirFileList.Init;
begin
	inherited Init(10,5);
    Duplicates := true;
end;

procedure TDirFileList.FreeItem(Item : Pointer);
begin
	DisposeStr(Item);
end;


function TDirFileList.Compare(Key1, Key2 : Pointer) : integer;
var
	i,j : integer;
    s1, s2 : string[20];
    ps1, ps2 : PString;

begin
	ps1 := Key1;
    ps2 := Key2;
    case SortKey of
    	NotSorted: begin
	        		s1 := '1';
    	            s2 := '2';
        	       end;
    	NameK: begin
        		s1 := copy(ps1^,3,8);
                s2 := copy(ps2^,3,8);
              end;
    	ExtK:  begin
        		s1 := copy(ps1^,12,3);
                s2 := copy(ps2^,12,3);
              end;
    	OriginalK:  begin
	        			s1 := copy(ps1^,15,9);
    	            	s2 := copy(ps2^,15,9);
        	       end;
    	CompressedK: begin
		        		s1 := '1';
    		            s2 := '2';
        		    end;
    	DateK: begin
		       		s1 := datestr(copy(ps1^,30,8));
    		    	s2 := datestr(copy(ps2^,30,8));
               end;
    	RatioK: begin
		       		s1 := '1';
    		    	s2 := '2';
               end;
    end;

    if SortMtd = AscSort then
    begin
	    if s1 < s2 then
    		Compare := -1
	    else
	    	if s1 > s2 then
	        	Compare := 1
	        else
	        	Compare := 0;
    end
    else
    begin
	    if s1 < s2 then
    		Compare := 1
	    else
	    	if s1 > s2 then
	        	Compare := -1
	        else
	        	Compare := 0;
    end;
end;



{ TDirFileBox }

constructor TDirFileBox.Init(R : TRect; vSB : PScrollBar);
var
	nc : word;
begin
	if (twocol and 1) = 0 then
    	nc := 1
    else
    	nc := 2;
	inherited Init(R, nc, vSB);
    DirList := New(PStrList, Init);
	ScanDir;
end;

destructor TDirFileBox.Done;
begin
	Dispose(DirList ,Done);
    if List <> nil then
	    Dispose(DirFileList, Done);
    Inherited Done;
end;

function TDirFileBox.GetPalette : PPalette;
const
  MyPal : String[length(CListViewer)] = #6#6#7#1#2;
begin
  GetPalette := @MyPal;
end;

function TDirFileBox.GetText(i : integer; m : integer) : string;
var
	ps : PString;
begin
	ps := DirFileList^.At(i);
    GetText := ps^;
end;

procedure TDirFileBox.ScanDir;
var
	s, s1 : string;
begin
    selfiles := 0; selbytes := 0;
    NewList(nil);
    DirFileList  := New(PDirFileList, Init);
    ws := rqstpath;
    if ws[length(ws)] <> '\' then ws := ws + '\';

    findfirst(ws + '*.*',Directory,sr);
	while doserror = 0 do
    begin
        if MaxAvail < 10000 then
        begin
	       	MessageBox('There is not enough memory for entire list',nil,mfInformation + mfOkButton);
            break;
        end;

        FSplit(sr.Name, FPath, FName, FExt);
        if (sr.name[1] <> '.') and (FExt <> '.&&&') then
        begin
	        s := '  ' + FName + copy(EmptyStr,1,8-length(FName));
    	    delete(FExt,1,1);
        	s := s + ' ' + FExt + copy(EmptyStr,1,3-length(FExt));
	        if (sr.Attr and Directory) <> 0 then
            begin
		        s := s + ' <DIR> ';
	        	DirFileList^.Insert(NewStr(s));
    	    end;
        end;
   		findnext(sr);
    end;

    findfirst(ws + FileMask,AttrMask,sr);
	while doserror = 0 do
    begin
        if MaxAvail < 10000 then
        begin
	       	MessageBox('There is not enough memory for entire list',nil,mfInformation + mfOkButton);
            break;
        end;

        FSplit(sr.Name, FPath, FName, FExt);
        if (sr.name[1] <> '.') and (FExt <> '.&&&') then
        begin
	        s := '  ' + FName + copy(EmptyStr,1,8-length(FName));
    	    delete(FExt,1,1);
        	s := s + ' ' + FExt + copy(EmptyStr,1,3-length(FExt));
	        if (sr.Attr and Directory) <> 0 then
		        s := s + ' <DIR> '
			else
			begin
		        str(sr.Size:9,s1);
	    	    s := s + '' + s1 + copy(s1,1,9-length(s1));
    	    	s1 := '....';
	            if (sr.Attr and Archive) <> 0 then	s1[4] := 'A';
    	        if (sr.Attr and ReadOnly) <> 0 then	s1[3] := 'R';
        	    if (sr.Attr and SysFile) <> 0 then	s1[2] := 'S';
	            if (sr.Attr and Hidden) <> 0 then	s1[1] := 'H';
    	    	s := s + ' ' + s1;
        	    UnpackTime(sr.Time,DT);
	            s := s + ' ' + LeadZero(DT.Day);
    	        s := s + '/' + LeadZero(DT.Month);
        	    str(DT.Year:4,s1);
	            s := s + '/' + copy(s1,3,2);
    	        s := s + ' ' + LeadZero(DT.Hour);
        	    s := s + ':' + LeadZero(DT.Min);
	            s := s + ':' + LeadZero(DT.Sec);
    	    end;
        	DirFileList^.Insert(NewStr(s));
        end;
   		findnext(sr);
    end;
	NewList(DirFileList);
    if DirFoc >= DirFileList^.Count then
    	DirFoc := 0;
    FocusItem(DirFoc)
end;

procedure TDirFileBox.SelCount;
var
	i, j : word;
    ps : PString;
    s : string;
    l : longint;
begin
	selfiles := 0; selbytes := 0;
    for i := 0 to DirFileList^.Count-1 do
    begin
    	ps := DirFileList^.At(i);
        if ps^[1] = chr(4) then
        begin
	        if copy(ps^,16,5) = '<DIR>' then
    	    begin
            	DirList^.FreeAll;
                WorkingWin('Scanning Directory');
			    ws := '';
                ws := ws + GetListName(ps^) + '\';
                DirList^.Insert(NewStr(ws));
                while DirList^.Count > 0 do
                begin
                    ps := DirList^.At(0);
                    cursrcdir := ps^;
                    DirList^.AtFree(0);

                    findfirst(cursrcdir + '*.*',Directory,sr);
                    while DosError = 0 do
                    begin
    		    	    if (sr.attr = directory) then
                        begin
							if sr.name[1] <> '.' then
		                		DirList^.Insert(NewStr(cursrcdir + sr.name + '\'));
                        end;
            			findnext(sr);
                    end;

                    findfirst(cursrcdir + FileMask,AttrMask,sr);
                    while DosError = 0 do
                    begin
    		    	    if (sr.attr <> directory) then
                        begin
		                    if copy(sr.Name,length(sr.Name)-3,4) <> '.&&&' then
                            begin
	                            inc(selfiles);
    	                        selbytes := selbytes + sr.Size;
                            end;
                        end;
            			findnext(sr);
                    end;
                end;
                DirList^.FreeAll;
        	end
	        else
            begin
	        	inc(selfiles);
    	        s := copy(ps^,15,9);
	            val(s,l,j);
    	        selbytes := selbytes + l;
        	end;
        end;
    end;
end;


procedure TDirFileBox.MakeRqstFile;
var
	i, j : word;
    ps : PString;
    s : string;
    l : longint;
begin
    WorkingWin('Making Request File');
    for i := 0 to DirFileList^.Count-1 do
    begin
    	ps := DirFileList^.At(i);
        if ps^[1] = chr(4) then
        begin
	        if copy(ps^,16,5) = '<DIR>' then
    	    begin
            	DirList^.FreeAll;
			    ws := '';
                ws := ws + GetListName(ps^) + '\';
                DirList^.Insert(NewStr(ws));
                while DirList^.Count > 0 do
                begin
                    ps := DirList^.At(0);
                    cursrcdir := ps^;
                    DirList^.AtFree(0);

                    findfirst(cursrcdir + '*.*',Directory,sr);
                    while DosError = 0 do
                    begin
    		    	    if (sr.attr = directory) then
                        begin
							if sr.name[1] <> '.' then
		                		DirList^.Insert(NewStr(cursrcdir + sr.name + '\'));
                        end;
            			findnext(sr);
                    end;

                    findfirst(cursrcdir + FileMask,AttrMask,sr);
                    while DosError = 0 do
                    begin
    		    	    if (sr.attr <> directory) then
                        begin
                            ws := cursrcdir + sr.Name;
                            write(rqstfile,ws);
                        end;
            			findnext(sr);
                    end;
                end;
                DirList^.FreeAll;
        	end
	        else
            begin
                ws := GetListName(ps^);
                write(rqstfile,ws);
        	end;
        end;
    end;
    closefilepath(rqstfile);
end;


procedure TDirFileWin.CopyDirFile;
var
	i, j : word;
    ps : PString;
    s : string;
    PutR : PutRec;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    while true do
    begin
		PutR.p := TarDir;
    	i := Application^.ExecuteDialog(New(PPutDlg, Init), @PutR);
	    if i = cmCancel then
    	    exit;

        ms := PutR.p;
	    if ms = ' ' then
        	ms := '';
        if length(ms) = 0 then
        begin
        	tardir := rqstpath;
            break;
        end
        else
        begin
            ms := FExpand(ms);
            GetDir(0, ws);
            ChDir(ms);
            if IOResult = 0 then
            begin
            	ChDir(ws);
                tardir := ms;
            	break;
            end
            else
            	MessageBox('  Target directory not found', nil, mfError + mfOkButton);
		end;
    end;

    s := TarDir;
    if s[length(s)] <> '\' then
    	s := s + '\';

    for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
    	ps := DirFileBox^.DirFileList^.At(i);
        if ps^[1] = chr(4) then
        begin
            if PressEsc then
			begin
				DrawView;
                exit;
            end;
		    ws := rqstpath;
		    if ws[length(ws)] <> '\' then ws := ws + '\';
            ws := ws + GetListName(ps^);
            fsplit(ws,FPath,FName,FExt);
            WorkingWin('Coping ' + FName + FExt);
            copyfile(ws,s + FName + FExt);
        end;
    end;
	DrawView;
end;


procedure TDirFileWin.DelDirFile;
var
	i, j : word;
    ps : PString;
    s : string;
	f : file;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    i := MessageBox('      Delete Selected file(s)',nil,mfConfirmation + mfYesButton + mfNoButton);
	if i <> cmYes then
    	exit;


    for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
    	ps := DirFileBox^.DirFileList^.At(i);
        if ps^[1] = chr(4) then
        begin
            if PressEsc then
            begin
			   	DirFileBox^.ScanDir;
				DrawView;
            	exit;
            end;
		    ws := rqstpath;
		    if ws[length(ws)] <> '\' then ws := ws + '\';
			s := GetListName(ps^);
			ws := ws + s;
			WorkingWin('Deleting ' + s);
        	assign(f,ws);
            SetFAttr(f,Archive);
            erase(f);
        end;
    end;
   	DirFileBox^.ScanDir;
	DrawView;
end;

procedure TDirFileWin.ViewFile;
var
    fn : pathstr;
    D : PFileDialog;
    ps : PString;
begin
    DisableCommands(AllCommands);
    EnableCommands(CommandClose);

    i := DirFileBox^.Focused;
    ps := DirFileBox^.DirFileList^.At(i);
    fn := GetListName(ps^);

	ViewFileWin := New(PFileWindow,Init(fn));
    if  MyApp.ValidView(ViewFileWin) <> nil then
    begin
	    ViewFileWin^.Flags := 0;
    	ViewFileWin^.HelpCtx := hcCloseWin;
		Application^.InsertWindow(ViewFileWin);
    end
    else
    begin
        ViewFileWin := nil;
    	EnableCommands(AllCommands);
  		DisableCommands(CommandArc);
   	   	MessageBox( '       File is too big',nil,mfError + mfOkButton);
    end;

end;


procedure TDirFileWin.EditFile;
var
    fn : pathstr;
    D : PFileDialog;
    R : TRect;

begin
    DisableCommands(AllCommands);
    EnableCommands(CommandClose);

    fn := '';
	D := New(PFileDialog, Init('*.*', 'Edit File',
    '~N~ame', fdOkButton, 5));
	if MyApp.ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(fn);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
        end;
    end
    else
    begin
    	Dispose(D, Done);
    end;

    if length(fn) = 0 then
    begin
    	EnableCommands(AllCommands);
  		DisableCommands(CommandArc);
		exit;
    end;

    findfirst(fn,Archive,sr);
	if DosError <> 0 then
    begin
    	assign(f,fn);
        rewrite(f);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        closefile(f);
    end;

	Desktop^.GetExtent(R);
	EditFileWin := New(PEditWindow, Init(R, fn, wnNoNumber));
    if  MyApp.ValidView(EditFileWin) <> nil then
    begin
	    EditFileWin^.Flags := 0;
    	EditFileWin^.HelpCtx := hcEditWin;
		Application^.InsertWindow(EditFileWin);
    end
    else
    begin
        EditFileWin := nil;
    	EnableCommands(AllCommands);
  		DisableCommands(CommandArc);
    end;
end;

procedure TDirFileBox.GetComment;
var
	R : TRect;
    s,ss : string;
    ps : PString;
    i : word;
	cf : file;

begin
    ps := DirFileList^.At(Focused);
    ArcName := GetListName(ps^);
    if ps^[28] <> 'A' then
    begin
        s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
    	PrmAr[0] := longint(@s);
       	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        ArcName := '';
       	exit;
    end;
    assign(arcfile,ArcName);
    filemode := 0;
    reset(arcfile,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    blockread(arcfile,archeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    fileinarc := 12;
    if (archeader[0] <> $AD) or (archeader[1] <> $36) then
    begin
      	closefile(arcfile);
        s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
    	PrmAr[0] := longint(@s);
       	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        ArcName := '';
        exit;
   	end;

    if (archeader[2] > $22) then
    begin
      	closefile(arcfile);
        i := archeader[2] shr 4;
        str(i:1,s);
        i := archeader[2] and 15;
        str(i:1,ss);
        s := s + '.' + ss;
    	PrmAr[0] := longint(@s);
       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
        ArcName := '';
        exit;
   	end;

    assign(cf,workdir + 'Comment.&&&');
    rewrite(cf,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    Move(ArcHeader[10],ArcCmntLen,2);
  	if ArcCmntLen > 0 then
    begin
       	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        BlockWrite(cf,PosBuf,ArcCmntLen,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if NmbRead <> ArcCmntLen then DiskFull;
    end;
    closefile(cf);
end;

procedure TDirFileBox.PutComment;
var
    s,ss : string;
    ps : PString;
    i : word;
	cf : file;
begin
		assign(cf,workdir + 'Comment.&&&');
	    filemode := 2;
        reset(cf,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(cf) = 0 then
        begin
            closefile(cf);
            erase(cf);
            exit;
        end;
		WorkingWin('Writing Comment');
        rewrite(temparc,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    filemode := 2;
        reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        BlockRead(arcfile,ArcHeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        i := ArcHeader[10] + ArcHeader[11] * 256;
        seek(arcfile,i + 12);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        ArcCmntLen := filesize(cf);
        if ArcCmntLen > 8191 then ArcCmntLen := 8191;
		ArcHeader[10] := lo(ArcCmntLen);
        ArcHeader[11] := hi(ArcCmntLen);
        BlockWrite(temparc,ArcHeader,12,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if NmbWriten <> 12 then DiskFull;
      	BlockRead(cf,PosBuf,8191,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if NmbWriten <> NmbRead then DiskFull;
		while not eof(arcfile) do
        begin
           	BlockRead(arcfile,PosBuf,8191,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        if NmbWriten <> NmbRead then DiskFull;
        end;
        closefile(arcfile);
	   	closefile(temparc);
	   	CopyTempArc;
        closefile(cf);
        erase(cf);
end;




{ TDirFileWin }

constructor TDirFileWin.Init;
var
	R : TRect;
    s : string;

begin
    R.Assign(0,0,80,23);
	inherited Init(R,'Directory contents',0);
  	SetState(sfShadow,false);

    vSB := StandardScrollBar(sbVertical + sbHandleKeyboard);
    R.Assign(1,3,79,21);
	DirFileBox := New(PDirFileBox, Init(R,vSB));
    Insert(DirFileBox);

    R.Assign(1,1,70,2);
    PathTxt := New(PPrmTxt, Init(R,'Path %-70s ',1));
    Insert(PathTxt);
    R.Assign(1,2,79,3);
    if (twocol and 1) = 0 then
    	s := ' T Name     Ext     Size Attr   Date     Time  '
    else
		s := ' T Name     Ext     Size Attr   Date     T Name     Ext     Size Attr   Date';
    Insert(New(PStatTxt, Init(R,s)));
    R.Assign(1,21,79,22);
    SelTxt := New(PSelTxt, Init(R,'              Selected files: %-5d           Selected bytes: %-9d',2));
	Insert(SelTxt);

    EW := nil; ComWin := nil;
    EditFileWin := nil; ViewFileWin := nil;
end;

procedure TDirFileWin.SelOne;
var
    ps : Pstring;
begin
    ps := DirFileBox^.DirFileList^.At(DirFileBox^.Focused);
    if ps^[1] <> chr(4) then
    	ps^[1] := chr(4)
    else
    	ps^[1] := ' ';
    DirFileBox^.SelCount;
    DirFileBox^.DrawView;
    DrawView;
end;

procedure TDirFileWin.SelOneNxt;
var
    ps : Pstring;
    i : word;
begin
    ps := DirFileBox^.DirFileList^.At(DirFileBox^.Focused);
    if ps^[1] <> chr(4) then
    	ps^[1] := chr(4)
    else
    	ps^[1] := ' ';
    i := DirFileBox^.Focused;
    if i < DirFileBox^.DirFileList^.Count - 1 then
    	DirFileBox^.FocusItem(i+1);
    DirFileBox^.SelCount;
    DirFileBox^.DrawView;
    DrawView;
end;

procedure TDirFileWin.SelAll;
var
    ps : PString;
    i : word;
begin
	for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
	    ps := DirFileBox^.DirFileList^.At(i);
        if copy(ps^,16,5) <> '<DIR>' then
		    ps^[1] := chr(4);
    end;
    DirFileBox^.SelCount;
    DirFileBox^.DrawView;
    DrawView;
end;

procedure TDirFileWin.SelAllDir;
var
    ps : PString;
    i : word;
begin
	for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
	    ps := DirFileBox^.DirFileList^.At(i);
	    ps^[1] := chr(4);
    end;
    DirFileBox^.SelCount;
    DirFileBox^.DrawView;
    DrawView;
end;

procedure TDirFileWin.UnSelAll;
var
    ps : PString;
    i : word;
begin
	for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
	    ps := DirFileBox^.DirFileList^.At(i);
	    ps^[1] := ' ';
    end;
    DirFileBox^.SelCount;
    DirFileBox^.DrawView;
    DrawView;
end;


procedure TDirFileWin.PerWillcards;
var
	i,j : integer;
    pwr : PerWCRec;
    ps : PString;
begin
	PWR.w := '';
    i := Application^.ExecuteDialog(New(PPWDlg, Init), @PWR);
    if i <> cmCancel then
    begin
        ws := PWR.w;
	        for i := 1 to length(ws) do
            	ws[i] := UpCase(ws[i]);
            fsplit(ws,FPath,FName,FExt);
            FExt := copy(FExt,2,length(FExt)-1);
            if length(FName) = 0 then
            	FName := '        '
            else
            begin
	            for i := 1 to length(FName) do
    	        	if FName[i] = '*' then
        	        begin
            	    	FName := copy(FName,1,i-1);
                	    for j := i to 8 do
							FName := FName + '?';
	                end;
                l := length(FName);
                for i := l + 1 to 8 do
                	FName := FName + ' ';
            end;
            if length(FExt) = 0 then
            	FExt := '   '
            else
            begin
	            for i := 1 to length(FExt) do
    	        	if FExt[i] = '*' then
        	        begin
            	    	FExt := copy(FExt,1,i-1);
                	    for j := i to 3 do
							FExt := FExt + '?';
	                end;
            end;

			for j := 0 to DirFileBox^.DirFileList^.Count - 1 do
            begin
            	ps := DirFileBox^.DirFileList^.At(j);
                s := copy(ps^,3,8) + copy(ps^,12,3);
                match := true;
                for i := 1 to 8 do
                	if (FName[i] <> '?') and (FName[i] <> s[i]) then
                    	match := false;
                for i := 1 to 3 do
                	if (FExt[i] <> '?') and (FExt[i] <> s[8+i]) then
                    	match := false;
				if match then
					ps^[1] := chr(4);
            end;
	    DirFileBox^.SelCount;
    	DirFileBox^.DrawView;
	    DrawView;
    end;
end;


procedure TDirFileWin.FromTo;
var
	i,j : integer;
    fromtorec : TFromToRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    FromTorec.fromdt := '  /  /  ';
    FromTorec.todt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PFromToDlg, Init), @fromtorec);
    if i <> cmCancel then
    begin
        fs := datestr(fromtorec.fromdt);
        ts := datestr(fromtorec.todt);

			for j := 0 to DirFileBox^.DirFileList^.Count - 1 do
            begin
            	ps := DirFileBox^.DirFileList^.At(j);
			    if copy(ps^,16,5) = '<DIR>' then
                	continue;
                s := copy(ps^,30,8);
                s := datestr(s);
			    if (s >= fs) and (s <= ts) then
                	ps^[1] := chr(4);
            end;
	    DirFileBox^.SelCount;
    	DirFileBox^.DrawView;
	    DrawView;
    end;
end;


procedure TDirFileWin.Before;
var
	i,j : integer;
    beforerec : TbeforeRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    beforerec.beforedt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PbeforeDlg, Init), @beforerec);
    if i <> cmCancel then
    begin
        ts := datestr(beforerec.beforedt);

			for j := 0 to DirFileBox^.DirFileList^.Count - 1 do
            begin
            	ps := DirFileBox^.DirFileList^.At(j);
			    if copy(ps^,16,5) = '<DIR>' then
                	continue;
                s := copy(ps^,30,8);
                s := datestr(s);
			    if s <= ts then
                	ps^[1] := chr(4);
            end;
	    DirFileBox^.SelCount;
    	DirFileBox^.DrawView;
	    DrawView;
    end;
end;


procedure TDirFileWin.After;
var
	i,j : integer;
    afterrec : TafterRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    afterrec.afterdt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PafterDlg, Init), @afterrec);
    if i <> cmCancel then
    begin
        fs := datestr(afterrec.afterdt);

			for j := 0 to DirFileBox^.DirFileList^.Count - 1 do
            begin
            	ps := DirFileBox^.DirFileList^.At(j);
			    if copy(ps^,16,5) = '<DIR>' then
                	continue;
                s := copy(ps^,30,8);
                s := datestr(s);
			    if s >= fs then
                	ps^[1] := chr(4);
            end;
	    DirFileBox^.SelCount;
    	DirFileBox^.DrawView;
	    DrawView;
    end;
end;

procedure TDirFileWin.Today;
var
	i,j : integer;
    y,m,d,w : word;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
	GetDate(y,m,d,w);
    str(d:2,s1);
    if s1[1] = ' ' then s1[1] := '0';
    s := s1;
    str(m:2,s1);
    if s1[1] = ' ' then s1[1] := '0';
    s := s + '/' + s1;
    str(y:4,s1);
    s := s + '/' + copy(s1,3,2);

        fs := datestr(s);

			for j := 0 to DirFileBox^.DirFileList^.Count - 1 do
            begin
            	ps := DirFileBox^.DirFileList^.At(j);
			    if copy(ps^,16,5) = '<DIR>' then
                	continue;
                s := copy(ps^,30,8);
                s := datestr(s);
			    if s = fs then
                	ps^[1] := chr(4);
            end;
	    DirFileBox^.SelCount;
    	DirFileBox^.DrawView;
	    DrawView;
end;


procedure TDirFileWin.ToBottom;
var
	i,j : integer;
    ps : PString;

begin
	for j := DirFileBox^.Focused to DirFileBox^.DirFileList^.Count - 1 do
    begin
       	ps := DirFileBox^.DirFileList^.At(j);
       	ps^[1] := chr(4);
	end;
    DirFileBox^.SelCount;
   	DirFileBox^.DrawView;
    DrawView;
end;

procedure TDirFileWin.ToTop;
var
	i,j : integer;
    ps : PString;

begin
	for j := 0 to DirFileBox^.Focused - 1 do
    begin
       	ps := DirFileBox^.DirFileList^.At(j);
       	ps^[1] := chr(4);
	end;
    DirFileBox^.SelCount;
   	DirFileBox^.DrawView;
    DrawView;
end;



procedure TDirFileWin.DownDir;
var
	ps : PString;
    i : word;
    s, ss : string;

begin
    if DirFileBox^.DirFileList^.Count = 0 then
    	exit;
    ps := DirFileBox^.DirFileList^.At(DirFileBox^.Focused);
   	ss := GetListName(ps^);
    if copy(ps^,16,5) <> '<DIR>' then
	begin
        s := copy(EmptyStr,1,12-length(ss)) + ss;
    	PrmAr[0] := longint(@s);
       	MessageBox(' %-12s is not a Directory',@PrmAr,mfInformation + mfOkButton);
        exit;
	end;

	ChDir(ss);
   	DirFoc := 0;
	GetDir(0,rqstpath);
   	DirFileBox^.ScanDir;
	DrawView;
end;

procedure TDirFileWin.UpDir;
var
	dn : pathstr;
    i, j : word;
begin
	if length(rqstpath) < 4 then
	begin
       	MessageBox('  You are in the root Directory',nil,mfInformation + mfOkButton);
        exit;
	end;

    j := length(rqstpath);
    dn := '';
    for i := j downto 1 do
    begin
    	if rqstpath[i] = '\' then
        	break;
	end;
    dn := copy(rqstpath,i+1,j-i);


	ChDir('..');
    dirfoc := 0;
    findfirst('*.*',Directory,sr);
    while DosError = 0 do
    begin
        if (sr.Attr = Directory) and (sr.Name[1] <> '.') then
        begin
    	    if sr.Name = dn then
        		break;
	    	inc(dirfoc);
        end;
        findnext(sr);
    end;

	GetDir(0,rqstpath);
   	DirFileBox^.ScanDir;
	DrawView;
end;


procedure TDirFileWin.HandleEvent(var Event: TEvent);
begin
	inherited HandleEvent(Event);
  	if Event.What = evBroadcast then
    begin
		if Event.Command = cmListItemSelected then
        begin
        	SelOne;
            ClearEvent(Event);
        end;
    end
    else
    	if Event.What = evCommand then
        begin
        	case Event.Command of
	          	cmVwCmmnt :  ViewComment;
    	       	cmEdtCmmnt : EditComment;
            	cmSelOne : SelOne;
                cmSelOneNxt : SelOneNxt;
            	cmSelAll :   SelAll;
            	cmSelAllDir : SelAllDir;
            	cmUnSelAll : UnSelAll;
                cmprWlcrd :  PerWillcards;
                cmFromTo : FromTo;
                cmBefore : Before;
                cmAfter : After;
                cmToday : Today;
                cmToBottom : ToBottom;
                cmToTop : ToTop;
                cmprncmnt : PrnCmnt;
                cmprndir : PrnDir;
	            cmCopyDirFile : CopyDirFile;
    	        cmDelDirFile : DelDirFile;
                cmViewFile : ViewFile;
                cmEditFile : EditFile;
                cmDownDir : DownDir;
                cmUpDir : UpDir;
	            cmfilemask : ModFileMask;
			else
            	exit;
            end;
            ClearEvent(Event);
        end;
end;


procedure TDirFileWin.Draw;

begin
	inherited Draw;
    PrmAr[0] := longint(@rqstpath);
    PathTxt^.Draw;
	PrmAr[0] := longint(selfiles);
	PrmAr[1] := selbytes;
	SelTxt^.Draw;

end;



{ TArcFileList }

constructor TArcFileList.Init;
begin
	inherited Init(10,5);
    Duplicates := true;
end;

procedure TArcFileList.FreeItem(Item : Pointer);
begin
	DisposeStr(Item);
end;


function TArcFileList.Compare(Key1, Key2 : Pointer) : integer;
var
	i,j : integer;
    s1, s2 : string[20];
    ps1, ps2 : PString;

begin
	ps1 := Key1;
    ps2 := Key2;
    case SortKey of
    	NotSorted: begin
	        		s1 := '1';
    	            s2 := '2';
        	       end;
    	NameK: begin
        		s1 := copy(ps1^,3,8);
                s2 := copy(ps2^,3,8);
              end;
    	ExtK:  begin
        		s1 := copy(ps1^,12,3);
                s2 := copy(ps2^,12,3);
              end;
    	OriginalK:  begin
	        			s1 := copy(ps1^,16,9);
    	            	s2 := copy(ps2^,16,9);
        	       end;
    	CompressedK: begin
		        		s1 := copy(ps1^,27,9);
    		            s2 := copy(ps2^,27,9);
        		    end;
    	DateK: begin
		       		s1 := datestr(copy(ps1^,45,8));
    		    	s2 := datestr(copy(ps2^,45,8));
               end;
    	RatioK: begin
	        		s1 := copy(ps1^,38,5);
   		            s2 := copy(ps2^,38,5);
               end;
    end;

    if SortMtd = AscSort then
    begin
	    if s1 < s2 then
    		Compare := -1
	    else
	    	if s1 > s2 then
	        	Compare := 1
	        else
	        	Compare := 0;
    end
    else
    begin
	    if s1 < s2 then
    		Compare := 1
	    else
	    	if s1 > s2 then
	        	Compare := -1
	        else
	        	Compare := 0;
    end;
end;




{ TArcFileBox }

constructor TArcFileBox.Init(R : TRect; vSB : PScrollBar);
var
	nc : word;
begin
	if (twocol and 2) = 0 then
    	nc := 1
    else
    	nc := 2;
	inherited Init(R, nc, vSB);
end;

destructor TArcFileBox.Done;
begin
    Dispose(ArcFileList, Done);
    Inherited Done;
end;


function TArcFileBox.GetPalette : PPalette;
const
  MyPal : String[length(CListViewer)] = #6#6#7#1#2;
begin
  GetPalette := @MyPal;
end;

function TArcFileBox.GetText(i : integer; m : integer) : string;
var
	ps : PString;
begin
	ps := ArcFileList^.At(i);
    GetText := ps^;
end;


procedure TArcFileBox.ScanArc;
var
	s, ss : string;
    i : word;
    fp : longint;

begin
    selfiles := 0; selbytes := 0;
    NewList(nil);
    WorkingWin('Scaning Archive');
    ArcFileList  := New(PArcFileList, Init);
    ArchiveSize := filesize(arcfile);
	seek(arcfile,0);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	TotalTextSize := 0; TotalCmprSize := 0;
    NmbArcFiles := 0;
    blockread(arcfile,archeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    fileinarc := 12;
    Move(ArcHeader[10],ArcCmntLen,2);
  	if ArcCmntLen > 0 then
    begin
        fileinarc := fileinarc + ArcCmntLen;
        seek(arcfile,fileinarc);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	end;
    pwis := false;

    while not eof(arcfile) do
    begin
        if MaxAvail < 10000 then
        begin
	       	MessageBox('There is not enough memory for entire list',nil,mfInformation + mfOkButton);
            break;
        end;
        fp := fileinarc;
        blockread(arcfile,fileheader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        Move(FileHeader[0],i,2);
        if i <> $1C94 then
        begin
        	closefile(arcfile);
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
            exit;
        end;
        FPath := ''; FName := ''; FExt := '';
        for i := 1 to 8 do
			if FileHeader[20+i] <> 0 then
               	FName := FName + chr(FileHeader[20+i]);

        for i := 1 to 3 do
			if FileHeader[28+i] <> 0 then
              	FExt := FExt + chr(FileHeader[28+i]);

        PathLen := FileHeader[32];
		if PathLen > 0 then
        begin
   	    	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            for i := 1 to PathLen do
              	FPath := FPath + chr(PosBuf[i-1]);
        end;

        FileCmntLen := FileHeader[33] + FileHeader[34] * 256;;
		if FileCmntLen > 0 then
        begin
   	    	BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        end;

        Move(FileHeader[6],TextFileSize,4);
        TotalTextSize := TotalTextSize + TextFileSize;

        Move(FileHeader[2],CmprFileSize,4);
        fileinarc := fileinarc + CmprFileSize;
        if (FileHeader[16] and $80) <> 0 then
        begin
			continue;
        end;

		if fileinarc > ArchiveSize then
        begin
        	closefile(arcfile);
    	   	MessageWin( ' Structure of archive is damaged');
            halt(1);
        end;

        CmprCodSize := CmprFileSize - 35 - PathLen - FileCmntLen;
        TotalCmprSize := TotalCmprSize + CmprCodSize;

		Attr := FileHeader[14];
        Move(FileHeader[10],Time,4);
        UnpackTime(Time,DT);
        if (FileHeader[15] and 1) = 1 then filebecont := true else filebecont := false;
        if (FileHeader[15] and 2) = 2 then fileisnext := true else fileisnext := false;
        Move(FileHeader[17],crc,4);

        ss := '  ' + FName + copy(EmptyStr,1,8-Length(FName));
        ss := ss + ' ' + FExt + copy(EmptyStr,1,3-length(FExt));
        str(TextFileSize:9,s);
        ss := ss + ' ' + s;
   	    str(CmprCodSize:9,s);
        ss := ss + '  ' + s;
        if TextFileSize = 0 then
        	s := '0.000'
        else
		    str((CmprCodSize)/(TextFileSize) : 4 : 3,s);
        ss := ss + '  ' + s;
		str(DT.day:2,s); if DT.day < 10 then s[1] := '0';
        ss := ss + '  ' + s;
        str(DT.month:2,s); if DT.month < 10 then s[1] := '0';
		ss := ss + '/' + s;
		str(DT.year:4,s); s := copy(s,3,2);
		ss := ss + '/' + s;
        str(DT.hour:2,s); if DT.hour < 10 then s[1] := '0';
		ss := ss + '  ' + s;
		str(DT.Min:2,s); if DT.min < 10 then s[1] := '0';
		ss := ss + ':' + s;
		str(DT.Sec:2,s); if DT.sec < 10 then s[1] := '0';
        ss := ss + ':' + s;
   	    s := '....';
	    if (Attr and Archive) <> 0 then	s[4] := 'A';
    	if (Attr and ReadOnly) <> 0 then s[3] := 'R';
        if (Attr and SysFile) <> 0 then	s[2] := 'S';
	    if (Attr and Hidden) <> 0 then	s[1] := 'H';
    	ss := ss + '  ' + s;
   	    s := '...';
        if FileCmntLen > 0 then
           	s[1] := 'Y';
        if (FileHeader[15] and 4) <> 0 then
        begin
           	s[2] := 'Y';
            pwis := true;
        end;
        if filebecont then
        	s[3] := 'N';
        if fileisnext then
        	s[3] := 'P';
   	    ss := ss + '  ' + s;
        str(fp:9,s);
        ss := ss + ' ' + s;
        ArcFileList^.Insert(NewStr(ss));
      	inc(NmbArcFiles);
        seek(arcfile,fileinarc);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	end;
	NewList(ArcFileList);
    if ArcFoc >= ArcFileList^.Count then
    	ArcFoc := 0;
    FocusItem(ArcFoc);
end;

procedure TArcFileBox.SelCount;
var
	i, j : word;
    ps : PString;
    s : string;
    l : longint;
begin
	selfiles := 0; selbytes := 0;
    for i := 0 to ArcFileList^.Count-1 do
    begin
    	ps := ArcFileList^.At(i);
        if ps^[1] = chr(251) then
        begin
        	inc(selfiles);
   	        s := copy(ps^,16,9);
            val(s,l,j);
   	        selbytes := selbytes + l;
        end;
    end;
end;

procedure TArcFileBox.MakeRqstFile;
var
	i, j : word;
    ps : PString;
    s : string;
    l : longint;
begin
    WorkingWin('Making Request File');
    for i := 0 to ArcFileList^.Count-1 do
    begin
    	ps := ArcFileList^.At(i);
        if ps^[1] = chr(251) then
        begin
            ws := copy(ps^,length(ps^)-8,9);
            write(rqstfile,ws);
        end;
    end;
    closefilepath(rqstfile);
end;


procedure TArcFileBox.GetComment;
var
	R : TRect;
    lookname, s,ss : string;
    ps : PString;
    i : word;
	cf : file;

begin
    WorkingWin('Scaning Archive');
   	ps := ArcFileList^.At(Focused);

    lookname := GetListName(ps^);
    filemode := 0;
    reset(arcfile,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;

    assign(cf,workdir + 'Comment.&&&');
	rewrite(cf,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;

    blockread(arcfile,archeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    fileinarc := 12;
    Move(ArcHeader[10],ArcCmntLen,2);
  	if ArcCmntLen > 0 then
    begin
        fileinarc := fileinarc + ArcCmntLen;
        seek(arcfile,fileinarc);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	end;

    while not eof(arcfile) do
    begin
        blockread(arcfile,fileheader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        Move(FileHeader[0],i,2);
        if i <> $1C94 then
        begin
        	closefile(arcfile);
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
            exit;
        end;
        Move(FileHeader[2],CmprFileSize,4);
   		FPath := ''; FName := ''; FExt := '';
        for i := 1 to 8 do
			if FileHeader[20+i] <> 0 then
    		   	FName := FName + chr(FileHeader[20+i]);
 		for i := 1 to 3 do
			if FileHeader[28+i] <> 0 then
        	   	FExt := FExt + chr(FileHeader[28+i]);
        ss := FName + '.' + FExt;
        if ss[length(ss)] = '.' then
        	delete(ss,length(ss),1);

        PathLen := FileHeader[32];
   		FileCmntLen := FileHeader[33] + FileHeader[34] * 256;

        if (FileHeader[16] and $80) <> 0 then
        begin
           	fileinarc := filepos(arcfile) + CmprFileSize - 35;
            seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
           	continue;
        end;

        if lookname <> ss then
   		begin
           	fileinarc := filepos(arcfile) + CmprFileSize - 35;
            seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
           	continue;
        end;
        fileinarc := filepos(arcfile);
		if FileCmntLen > 0 then
        begin
	     	BlockRead(arcfile,PosBuf,PathLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	     	BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
           	BlockWrite(cf,PosBuf,FileCmntLen,NmbWriten);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        if NmbWriten <> FileCmntLen then DiskFull;
	    end;
        break;
    end;
    closefile(cf);
end;

procedure TArcFileBox.PutComment;
var
    s,ss : string;
    ps : PString;
    i : word;
	cf : file;
    OldCmntLen : word;

begin
		WorkingWin('Writing Comment');
		assign(cf,workdir + 'Comment.&&&');
	    filemode := 2;
        reset(cf,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(cf) = 0 then
        begin
            closefile(cf);
            erase(cf);
            filemode := 2;
            reset(arcfile,1);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            exit;
        end;
		WorkingWin('Writing Comment');
        rewrite(temparc,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
 	  	fileinarc := fileinarc - 35;
	    filemode := 2;
		reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		flen := fileinarc;
        while flen > 0 do
        begin
            if flen > 8191 then
            	blen := 8191
            else
	           	blen := flen;
           	BlockRead(arcfile,PosBuf,blen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        if NmbWriten <> NmbRead then DiskFull;
            flen := flen - NmbRead;
        end;

        BlockRead(arcfile,FileHeader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		PathLen := FileHeader[32];
        OldCmntLen := FileHeader[33] + FileHeader[34] * 256;
        FileCmntLen := filesize(cf);
        if FileCmntLen > 8191 then FileCmntLen := 8191;
        FileHeader[33] := lo(FileCmntLen);
        FileHeader[34] := hi(FileCmntLen);
        Move(FileHeader[2],CmprFileSize,4);
        CmprFileSize := CmprFileSize - OldCmntLen + FileCmntLen;
        Move(CmprFileSize,FileHeader[2],4);
        BlockWrite(temparc,FileHeader,35,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if NmbWriten <> 35 then DiskFull;
        BlockRead(arcfile,PosBuf,PathLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if NmbWriten <> NmbRead then DiskFull;
        if OldCmntLen > 0 then
        begin
		    BlockRead(arcfile,PosBuf,OldCmntLen,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        end;

        if FileCmntLen > 0 then
        begin
            BlockRead(cf,PosBuf,8191,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        if NmbWriten <> NmbRead then DiskFull;
        end;

		while not eof(arcfile) do
        begin
          	BlockRead(arcfile,PosBuf,8191,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            BlockWrite(temparc,PosBuf,NmbRead,NmbWriten);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        if NmbWriten <> NmbRead then DiskFull;
        end;

	   	closefile(temparc);
	   	CopyTempArc;
        closefile(cf);
        erase(cf);
	    filemode := 2;
        reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
end;


{ TArcFileWin }

constructor TArcFileWin.Init;
var
    B: TDrawBuffer;
    C: Byte;
	R : TRect;
	s : string;

begin
    R.Assign(1,1,79,22);
	inherited Init(R,'Archive contents',0);

    vSB := StandardScrollBar(sbVertical + sbHandleKeyboard);
    R.Assign(1,3,77,18);
	ArcFileBox := New(PArcFileBox, Init(R,vSB));
    Insert(ArcFileBox);

    R.Assign(1,1,76,2);
    ArcTxt := New(PPrmTxt, Init(R,'Archive %-70s ',1));
    Insert(ArcTxt);
    R.Assign(1,18,76,19);
    SelTxt := New(PSelTxt, Init(R,'             Selected files: %-5d           Selected bytes: %-9d',2));
	Insert(SelTxt);
    R.Assign(1,2,76,3);
    if (twocol and 2) = 0 then
    	s := ' T Name     Ext      Size Compressed  Ratio    Date      Time    Attr  CPS'
    else
    	s := ' T Name     Ext      Size Compressed    T Name     Ext      Size Compressed';
    Insert(New(PStatTxt, Init(R,s)));
    R.Assign(1,19,76,20);
    TotalTxt := New(PPrmTxt, Init(R,' Total: %5d file(s)  Size: %-9d  Compessed: %-9d  Ratio: %5s',4));
    Insert(TotalTxt);

    EW := nil; ComWin := nil;
end;

procedure TArcFileWin.SelOne;
var
    ps : Pstring;
begin
    ps := ArcFileBox^.ArcFileList^.At(ArcFileBox^.Focused);

	if ps^[73] = 'P' then
    	exit;
    if ps^[1] <> chr(251) then
    	ps^[1] := chr(251)
    else
    	ps^[1] := ' ';
    ArcFileBox^.SelCount;
    ArcFileBox^.DrawView;
    DrawView;
end;

procedure TArcFileWin.SelOneNxt;
var
    ps : Pstring;
	i : word;
begin
    ps := ArcFileBox^.ArcFileList^.At(ArcFileBox^.Focused);

	if ps^[73] = 'P' then
    	exit;
    if ps^[1] <> chr(251) then
    	ps^[1] := chr(251)
    else
    	ps^[1] := ' ';
    i := ArcFileBox^.Focused;
    if i < ArcFileBox^.ArcFileList^.Count - 1 then
    	ArcFileBox^.FocusItem(i+1);
    ArcFileBox^.SelCount;
    ArcFileBox^.DrawView;
    DrawView;
end;


procedure TArcFileWin.SelAll;
var
    ps : PString;
    i : word;
begin
	for i := 0 to ArcFileBox^.ArcFileList^.Count-1 do
    begin
	    ps := ArcFileBox^.ArcFileList^.At(i);
		if ps^[73] = 'P' then
    		continue;
	    ps^[1] := chr(251);
    end;
    ArcFileBox^.SelCount;
    ArcFileBox^.DrawView;
    DrawView;
end;

procedure TArcFileWin.UnSelAll;
var
    ps : PString;
    i : word;
begin
	for i := 0 to ArcFileBox^.ArcFileList^.Count-1 do
    begin
	    ps := ArcFileBox^.ArcFileList^.At(i);
	    ps^[1] := ' ';
    end;
    ArcFileBox^.SelCount;
    ArcFileBox^.DrawView;
    DrawView;
end;

procedure TArcFileWin.PerWillcards;
var
	i,j : integer;
    pwr : PerWCRec;
    ps : PString;

begin
	PWR.w := '';
    i := Application^.ExecuteDialog(New(PPWDlg, Init), @PWR);
    if i <> cmCancel then
    begin
        ws := PWR.w;
	        for i := 1 to length(ws) do
            	ws[i] := UpCase(ws[i]);
            fsplit(ws,FPath,FName,FExt);
            FExt := copy(FExt,2,length(FExt)-1);
            if length(FName) = 0 then
            	FName := '        '
            else
            begin
	            for i := 1 to length(FName) do
    	        	if FName[i] = '*' then
        	        begin
            	    	FName := copy(FName,1,i-1);
                	    for j := i to 8 do
							FName := FName + '?';
	                end;
                l := length(FName);
                for i := l + 1 to 8 do
                	FName := FName + ' ';
            end;
            if length(FExt) = 0 then
            	FExt := '   '
            else
            begin
	            for i := 1 to length(FExt) do
    	        	if FExt[i] = '*' then
        	        begin
            	    	FExt := copy(FExt,1,i-1);
                	    for j := i to 3 do
							FExt := FExt + '?';
	                end;
            end;

			for j := 0 to ArcFileBox^.ArcFileList^.Count - 1 do
            begin
            	ps := ArcFileBox^.ArcFileList^.At(j);
                s := copy(ps^,3,8) + copy(ps^,12,3);
                match := true;
                for i := 1 to 8 do
                	if (FName[i] <> '?') and (FName[i] <> s[i]) then
                    	match := false;
                for i := 1 to 3 do
                	if (FExt[i] <> '?') and (FExt[i] <> s[8+i]) then
                    	match := false;
				if match and (ps^[73] <> 'P') then
					ps^[1] := chr(251);
            end;
	    ArcFileBox^.SelCount;
    	ArcFileBox^.DrawView;
	    DrawView;
    end;
end;



procedure TArcFileWin.FromTo;
var
	i,j : integer;
    fromtorec : TFromToRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    FromTorec.fromdt := '  /  /  ';
    FromTorec.todt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PFromToDlg, Init), @fromtorec);
    if i <> cmCancel then
    begin
        fs := datestr(fromtorec.fromdt);
        ts := datestr(fromtorec.todt);

			for j := 0 to ArcFileBox^.ArcFileList^.Count - 1 do
            begin
            	ps := ArcFileBox^.ArcFileList^.At(j);
                s := copy(ps^,45,8);
                s := datestr(s);
			    if (s >= fs) and (s <= ts) then
                	ps^[1] := Chr(251);
            end;
	    ArcFileBox^.SelCount;
    	ArcFileBox^.DrawView;
	    DrawView;
    end;
end;


procedure TArcFileWin.Before;
var
	i,j : integer;
    beforerec : TbeforeRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    beforerec.beforedt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PbeforeDlg, Init), @beforerec);
    if i <> cmCancel then
    begin
        ts := datestr(beforerec.beforedt);

			for j := 0 to ArcFileBox^.ArcFileList^.Count - 1 do
            begin
            	ps := ArcFileBox^.ArcFileList^.At(j);
                s := copy(ps^,45,8);
                s := datestr(s);
			    if s <= ts then
                	ps^[1] := Chr(251);
            end;
	    ArcFileBox^.SelCount;
    	ArcFileBox^.DrawView;
	    DrawView;
    end;
end;

procedure TArcFileWin.After;
var
	i,j : integer;
    afterrec : TafterRec;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
    afterrec.afterdt := '  /  /  ';
    i := Application^.ExecuteDialog(New(PafterDlg, Init), @afterrec);
    if i <> cmCancel then
    begin
        fs := datestr(afterrec.afterdt);

			for j := 0 to ArcFileBox^.ArcFileList^.Count - 1 do
            begin
            	ps := ArcFileBox^.ArcFileList^.At(j);
                s := copy(ps^,45,8);
                s := datestr(s);
			    if s >= fs then
                	ps^[1] := Chr(251);
            end;
	    ArcFileBox^.SelCount;
    	ArcFileBox^.DrawView;
	    DrawView;
    end;
end;


procedure TArcFileWin.Today;
var
	i,j : integer;
    y,m,d,w : word;
    fs, ts, s, s1 : string[20];
    ps : PString;

begin
	GetDate(y,m,d,w);
    str(d:2,s1);
    if s1[1] = ' ' then s1[1] := '0';
    s := s1;
    str(m:2,s1);
    if s1[1] = ' ' then s1[1] := '0';
    s := s + '/' + s1;
    str(y:4,s1);
    s := s + '/' + copy(s1,3,2);

        fs := datestr(s);

			for j := 0 to ArcFileBox^.ArcFileList^.Count - 1 do
            begin
            	ps := ArcFileBox^.ArcFileList^.At(j);
                s := copy(ps^,45,8);
                s := datestr(s);
			    if s >= fs then
                	ps^[1] := Chr(251);
            end;
	    ArcFileBox^.SelCount;
    	ArcFileBox^.DrawView;
	    DrawView;
end;

procedure TArcFileWin.ToBottom;
var
	i,j : integer;
    ps : PString;

begin
	for j := ArcFileBox^.Focused to ArcFileBox^.ArcFileList^.Count - 1 do
    begin
       	ps := ArcFileBox^.ArcFileList^.At(j);
       	ps^[1] := Chr(251);
	end;
    ArcFileBox^.SelCount;
   	ArcFileBox^.DrawView;
    DrawView;
end;

procedure TArcFileWin.ToTop;
var
	i,j : integer;
    ps : PString;

begin
	for j := 0 to ArcFileBox^.Focused - 1 do
    begin
       	ps := ArcFileBox^.ArcFileList^.At(j);
       	ps^[1] := Chr(251);
	end;
    ArcFileBox^.SelCount;
   	ArcFileBox^.DrawView;
    DrawView;
end;




procedure TArcFileWin.HandleEvent(var Event: TEvent);
begin
	inherited HandleEvent(Event);
  	if Event.What = evBroadcast then
    begin
		if Event.Command = cmListItemSelected then
        begin
        	SelOne;
            ClearEvent(Event);
        end;
    end
    else
    	if Event.What = evCommand then
        begin
        	case Event.Command of
	          	cmVwCmmnt :  ViewComment;
    	       	cmEdtCmmnt : EditComment;
	    	  	cmDelArc : DeleteArcFile;
            	cmSelOne :   SelOne;
            	cmSelOneNxt :   SelOneNxt;
            	cmSelAll :   SelAll;
            	cmUnSelAll :   UnSelAll;
                cmprWlcrd :  PerWillcards;
                cmFromTo : FromTo;
                cmBefore : Before;
                cmAfter : After;
                cmToday : Today;
                cmToBottom : ToBottom;
                cmToTop : ToTop;
                cmprncmnt : PrnCmnt;
                cmprnarc : PrnArc;
			else
            	exit;
            end;
            ClearEvent(Event);
        end;
end;


procedure TArcFileWin.Draw;
var
	C : Byte;
    s,ss : string;
    B : TDrawBuffer;

begin
	inherited Draw;

    PrmAr[0] := longint(@ArcName);
    ArcTxt^.Draw;

	PrmAr[0] := longint(NmbArcFiles);
	PrmAr[1] := TotalTextSize;
	PrmAr[2] := TotalCmprSize;
    if TotalTextSize <> 0 then
	    str((TotalCmprSize)/(TotalTextSize) : 4 : 3,RatioStr)
    else
    	RatioStr := '0.000';
    PrmAr[3] := longint(@RatioStr);
	TotalTxt^.Draw;

	PrmAr[0] := longint(selfiles);
	PrmAr[1] := selbytes;
	SelTxt^.Draw;

end;


{ TMyApp }




procedure TMyApp.GoDos;
begin
	rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	ws := 'quit';
    write(rqstfile,ws);
    PutPar;
    closefilepath(rqstfile);

	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
    exit;
end;


procedure TMyApp.AddDirFile;
var
	R: TRect;
    i : word;
    D : PFileDialog;
    s, ss : string;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    if delaftarc then
    begin
	    i := MessageBox('  Delete file(s) after archiving',nil,mfConfirmation + mfYesButton + mfNoButton);
		if i <> cmYes then
	    	exit;
	end;

	D := New(PFileDialog, Init('*.AMG', 'Archive Name',
    '~N~ame', fdOkButton, 5));
	if ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(ArcName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
    		exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;

    if length(AExt) = 0 then
       	ArcName := ArcName + '.AMG';
    findfirst(arcname,archive,sr);
    if DosError <> 0 then
    begin
        arcexist := false;
    end
    else
    begin
   		assign(arcfile,arcname);
	    filemode := 2;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(arcfile) < 12 then
		begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
			exit;
        end
        else
        	arcexist := true;
	end;

    if arcexist then
    begin
       	BlockRead(arcfile,i,2,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if i <> $36AD then
        begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
	       	exit;
        end;
    end;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := 'add';
    write(rqstfile,ws);
    PutPar;

	DirFileWin^.DirFileBox^.MakeRqstFile;
	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.MVA;
var
	R: TRect;
    i : word;
    D : PFileDialog;
    s,ss : string;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    if delaftarc then
    begin
	    i := MessageBox('  Delete file(s) after archiving',nil,mfConfirmation + mfYesButton + mfNoButton);
		if i <> cmYes then
	    	exit;
	end;

	D := New(PFileDialog, Init('*.AMG', 'Archive Name',
    '~N~ame', fdOkButton, 5));
	if ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(ArcName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
    		exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;
    if length(AExt) = 0 then
       	ArcName := ArcName + '.AMG';

    findfirst(arcname,archive,sr);
    if DosError <> 0 then
    begin
        arcexist := false;
    end
    else
    begin
   		assign(arcfile,arcname);
	    filemode := 2;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(arcfile) < 12 then
		begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
			exit;
        end
        else
        	arcexist := true;
	end;

    if (not arcexist) and ((ADrive = 1) or (ADrive = 2)) then
    begin
       	assign(temparc,arcname);
    end
    else
    begin
        R.Assign(10,8,70,18);
       	i := MessageBoxRect(R,'                Multiple volume archive ' + chr(13)
				+ '        can be created only on flopydisk drives ' + chr(13)
				+ '                and archive must not exist' + chr(13),
				nil,mfError + mfOkButton);
        closefile(arcfile);
        erase(arcfile);
        exit;
    end;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := 'MVA';
    write(rqstfile,ws);
	PutPar;

	DirFileWin^.DirFileBox^.MakeRqstFile;
	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.SEA;
var
	R: TRect;
    i : word;
    D : PFileDialog;

begin
{
       	MessageBox('Sorry! This command is available only to registered users',nil,mfInformation + mfOkButton);
		exit;
}
	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    if delaftarc then
    begin
	    i := MessageBox('  Delete file(s) after archiving',nil,mfConfirmation + mfYesButton + mfNoButton);
		if i <> cmYes then
	    	exit;
	end;

	D := New(PFileDialog, Init('*.EXE', 'Self Extracting Archive Name',
    '~N~ame', fdOkButton, 5));
	if ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(ArcName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
    		exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;
    if length(AExt) = 1 then
       	ArcName := ArcName + '.EXE';

	findfirst(amgdir + 'SEM.OVL',Archive,sr);
    if DosError <> 0 then
    begin
	    MessageBox('File SEM.OVL not found in AMG Directory', nil, mfError + mfOkButton);
		exit;
    end;

    copyfile(AMGdir + 'SEM.ovl',ArcName);

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := 'SEA';
    write(rqstfile,ws);
	PutPar;

	DirFileWin^.DirFileBox^.MakeRqstFile;
	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.ChCurDir;
var
	i : word;
begin
	i := Application^.ExecuteDialog(New(PChDirDialog, Init(cdNormal, 5)), nil);
    if i <> cmCancel then
    begin
    	DirFoc := 0;
		GetDir(0,rqstpath);
    	DirFileWin^.DirFileBox^.ScanDir;
	    DirFileWin^.DrawView;
    end;
end;


procedure TMyApp.FreshenArchive;
var
	R: TRect;
    i : word;
    D : PFileDialog;
    s, ss : string;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    if delaftarc then
    begin
	    i := MessageBox('  Delete file(s) after archiving',nil,mfConfirmation + mfYesButton + mfNoButton);
		if i <> cmYes then
	    	exit;
	end;

	D := New(PFileDialog, Init('*.AMG', 'Archive Name',
    '~N~ame', fdOkButton, 5));
	if ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(ArcName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
    		exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;
    if length(AExt) = 0 then
       	ArcName := ArcName + '.AMG';
    findfirst(arcname,archive,sr);
    if DosError <> 0 then
    begin
       	MessageBox('      Archive must exist',nil,mfInformation + mfOkButton);
		exit;
    end
    else
    begin
   		assign(arcfile,arcname);
	    filemode := 2;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(arcfile) > 0 then
            arcexist := true
        else
   		begin
    	   	MessageBox('      Archive must exist',nil,mfInformation + mfOkButton);
			exit;
    	end;
	end;


    if arcexist then
    begin
       	BlockRead(arcfile,i,2,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if i <> $36AD then
        begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
	       	exit;
        end;
    end;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := 'freshen';
    write(rqstfile,ws);
	PutPar;

	DirFileWin^.DirFileBox^.MakeRqstFile;
	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;



procedure TMyApp.UpdateArchive;
var
	R: TRect;
    i : word;
    D : PFileDialog;
    s, ss : string;

begin

	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    if delaftarc then
    begin
	    i := MessageBox('  Delete file(s) after archiving',nil,mfConfirmation + mfYesButton + mfNoButton);
		if i <> cmYes then
	    	exit;
	end;

	D := New(PFileDialog, Init('*.AMG', 'Archive Name',
    '~N~ame', fdOkButton, 5));
	if ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(ArcName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
    		exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;

    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;

    if length(AExt) = 0 then
       	ArcName := ArcName + '.AMG';

    findfirst(arcname,archive,sr);
    if DosError <> 0 then
    begin
        arcexist := false;
    end
    else
    begin
   		assign(arcfile,arcname);
	    filemode := 2;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if filesize(arcfile) < 12 then
		begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
			exit;
        end
        else
        	arcexist := true;
	end;

    if arcexist then
    begin
       	BlockRead(arcfile,i,2,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        if i <> $36AD then
        begin
	        FSplit(ArcName, FPath, FName, FExt);
        	ss := FName + FExt;
	        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
       		MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
            closefile(arcfile);
	       	exit;
        end;
    end;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := 'update';
    write(rqstfile,ws);
	PutPar;

	DirFileWin^.DirFileBox^.MakeRqstFile;
	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TArcFileWin.DeleteArcFile;
var
	i, j, nxtord : word;
    ps : PString;
    s : string;
    nxtpos : longint;

begin
	if selfiles = 0 then
    begin
       	MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
		exit;
    end;

    i := MessageBox('      Delete Selected file(s)',nil,mfConfirmation + mfYesButton + mfNoButton);
	if i <> cmYes then
    	exit;

    WorkingWin('Deleting file(s) from archive');

    for j := 0 to ArcFileBox^.ArcFileList^.Count-1 do
    begin
		ps := ArcFileBox^.ArcFileList^.At(j);
        if ps^[1] = chr(251) then
        begin
	        ws := copy(ps^,length(ps^)-8,9);
  			val(ws,NxtPos,k);
            nxtord := j;
          	break;
        end;
    end;

    rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    seek(arcfile,0);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    blockread(arcfile,archeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    BlockWrite(temparc,ArcHeader,12,NmbWriten);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    if NmbWriten <> 12 then DiskFull;
    Move(ArcHeader[10],ArcCmntLen,2);
    if ArcCmntLen > 0 then
    begin
       	BlockRead(arcfile,PosBuf,ArcCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        BlockWrite(temparc,PosBuf,ArcCmntLen,NmbWriten);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    if NmbWriten <> ArcCmntLen then DiskFull;
    end;
    fileinarc := filepos(arcfile);

    while not eof(arcfile) do
    begin
        blockread(arcfile,fileheader,35,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        move(FileHeader[2],flen,4);
        if (FileHeader[16] and $80) <> 0 then
        begin
           	fileinarc := fileinarc + flen;
            seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
           	continue;
        end;
        if fileinarc = NxtPos then
        begin
		    for j := NxtOrd + 1 to ArcFileBox^.ArcFileList^.Count-1 do
		    begin
    			ps := ArcFileBox^.ArcFileList^.At(j);
	            if ps^[1] = chr(251) then
    	        begin
			        ws := copy(ps^,length(ps^)-8,9);
        			val(ws,NxtPos,k);
		            nxtord := j;
                	break;
                end;
            end;
        end
        else
        begin
			CopyArcFile;
            if PressEsc then
            begin
                closefile(temparc);
                erase(temparc);
            	reset(arcfile,1);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
                ArcFileBox^.ScanArc;
                DrawView;
            	exit;
            end;
        end;
        fileinarc := fileinarc + flen;
        seek(arcfile,fileinarc);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
  	end;
   	closefile(temparc);
    CopyTempArc;
    filemode := 2;
	reset(arcfile,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ArcFileBox^.ScanArc;
    DrawView;
end;


procedure TMyApp.Sort;
var
	i : integer;
    SortRec : TSortRec;

begin
    SortRec.sk := SortKey;
    SortRec.sm := SortMtd;
    i := Application^.ExecuteDialog(New(PSortDlg, Init), @SortRec);
    if i <> cmCancel then
    begin
        SortKey := SortRec.sk;
        SortMtd := SortRec.sm;
        if ArcFileWin = nil then
        begin
        	DirFileWin^.DirFileBox^.ScanDir;
            DirFileWin^.DrawView;
            DrawView;
        end
        else
        begin
        	ArcFileWin^.ArcFileBox^.ScanArc;
            DrawView;
        end;
    end;
end;


procedure TDirFileWin.ModFileMask;
var
	i : integer;
    fmr : TFileMaskRec;

begin
	fmr.fm := filemask;
    i := Application^.ExecuteDialog(New(PFileMaskDlg, Init), @fmr);
    if i <> cmCancel then
    begin
        if fmr.fm[1] = ' ' then
        	filemask := '*.*'
        else
        begin
	    	filemask := fmr.fm;
		end;
        DirFileBox^.ScanDir;
        DirFileBox^.DrawView;
        DrawView;
    end;
end;


procedure CommentFromFile;
var
	i : integer;
    D : PFileDialog;

begin
    CmntFileName := '';
	D := New(PFileDialog, Init('*.*', 'Comment File Name',
    '~N~ame', fdOkButton, 5));
	if Application^.ValidView(D) <> nil then
	begin
    	if Desktop^.ExecView(D) <> cmCancel then
    	begin
      		D^.GetFileName(CmntFileName);
	    	Dispose(D, Done);
	    end
        else
        begin
	    	Dispose(D, Done);
			exit;
        end;
    end
    else
    begin
    	Dispose(D, Done);
    	exit;
    end;
end;


procedure TMyApp.ExtractArcFile;
var
	R: TRect;
    i : word;
    PutR : PutRec;
    ps :  PString;
    s, ss : string;
    fp : longint;

begin
	if ArcFileWin = nil then
    begin
	    ps := DirFileWin^.DirFileBox^.DirFileList^.At(DirFileWin^.DirFileBox^.Focused);
    	ArcName := GetListName(ps^);
	    if ps^[28] <> 'A' then
    	begin
        	s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	       	exit;
    	end;
	    ArcName := FExpand(ArcName);
	    fsplit(ArcName,APath,AName,AExt);
    	ADrive := ord(ArcName[1]) - 64;

	    assign(arcfile,ArcName);
    	filemode := 0;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	if (archeader[0] <> $AD) or (archeader[1] <> $36) then
	    begin
    	  	closefile(arcfile);
            ss := AName + AExt;
        	s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	        exit;
   		end;
	    if (archeader[2] > $22) then
    	begin
      		closefile(arcfile);
	        i := archeader[2] shr 4;
    	    str(i:1,s);
        	i := archeader[2] and 15;
	        str(i:1,ss);
    	    s := s + '.' + ss;
    		PrmAr[0] := longint(@s);
	       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
            ArcName := '';
	        exit;
   	end;
    end
    else
    begin
		if selfiles = 0 then
    	begin
       		MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
			exit;
    	end;
    end;

    while true do
    begin
		PutR.p := TarDir;
    	i := Application^.ExecuteDialog(New(PPutDlg, Init), @PutR);
	    if i = cmCancel then
    	    exit;

        ms := PutR.p;
	    if ms = ' ' then
        	ms := '';
        if length(ms) = 0 then
        begin
        	tardir := rqstpath;
            break;
        end
        else
        begin
            ms := FExpand(ms);
            GetDir(0, ws);
            ChDir(ms);
            if IOResult = 0 then
            begin
            	ChDir(ws);
                tardir := ms;
            	break;
            end
            else
            	MessageBox('  Target directory not found', nil, mfError + mfOkButton);
		end;
    end;

    if pwis and (length(password) = 0) then
   		ModPassword;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
   	ws := 'extract';
    write(rqstfile,ws);
   	PutPar;

    if ArcFileWin = nil then
    begin
        pwis := false;
	    selfiles := 0; selbytes := 0;
	    WorkingWin('Scaning Archive');
	    ArchiveSize := filesize(arcfile);
		seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		TotalTextSize := 0; TotalCmprSize := 0;
	    NmbArcFiles := 0;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	Move(ArcHeader[10],ArcCmntLen,2);
	  	if ArcCmntLen > 0 then
    	begin
        	fileinarc := fileinarc + ArcCmntLen;
	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

    	while not eof(arcfile) do
	    begin
	        fp := fileinarc;
    	  	inc(NmbArcFiles);
        	blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        Move(FileHeader[0],i,2);
	        if i <> $1C94 then
    	    begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
    	    end;

	        Move(FileHeader[6],TextFileSize,4);
    	    TotalTextSize := TotalTextSize + TextFileSize;

        	Move(FileHeader[2],CmprFileSize,4);
	        fileinarc := fileinarc + CmprFileSize;
	        if (FileHeader[16] and $80) <> 0 then
    	    begin
            	seek(arcfile,fileinarc);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	           	continue;
    	    end;
			if fileinarc > ArchiveSize then
        	begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
        	end;

        	if (FileHeader[15] and 4) <> 0 then
	            pwis := true;

            if (FileHeader[15] and 2) = 0 then
            begin
		        str(fp:9,ws);
    	        write(rqstfile,ws);
            end;

	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

        selfiles := NmbArcFiles;
        selbytes := TotalTextSize;
	    if pwis and (length(password) = 0) then
   			ModPassword;
        seek(rqstfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        PutPar;
	end
    else
    begin
		ArcFileWin^.ArcFileBox^.MakeRqstFile;
    end;

	closefile(arcfile);

	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.ExtractArcPath;
var
	R: TRect;
    i : word;
    PutR : PutRec;
    ps :  PString;
    s, ss : string;
    fp : longint;

begin
	if ArcFileWin = nil then
    begin
	    ps := DirFileWin^.DirFileBox^.DirFileList^.At(DirFileWin^.DirFileBox^.Focused);
    	ArcName := GetListName(ps^);
	    if ps^[28] <> 'A' then
    	begin
        	s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	       	exit;
    	end;
	    ArcName := FExpand(ArcName);
	    fsplit(ArcName,APath,AName,AExt);
    	ADrive := ord(ArcName[1]) - 64;

	    assign(arcfile,ArcName);
    	filemode := 0;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	if (archeader[0] <> $AD) or (archeader[1] <> $36) then
	    begin
    	  	closefile(arcfile);
            ss := AName + AExt;
        	s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	        exit;
   		end;
	    if (archeader[2] > $22) then
    	begin
      		closefile(arcfile);
	        i := archeader[2] shr 4;
    	    str(i:1,s);
        	i := archeader[2] and 15;
	        str(i:1,ss);
    	    s := s + '.' + ss;
    		PrmAr[0] := longint(@s);
	       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
            ArcName := '';
	        exit;
	   	end;
    end
    else
    begin
		if selfiles = 0 then
    	begin
       		MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
			exit;
    	end;
    end;

    while true do
    begin
		PutR.p := TarDir;
    	i := Application^.ExecuteDialog(New(PPutDlg, Init), @PutR);
	    if i = cmCancel then
    	    exit;

        ms := PutR.p;
	    if ms = ' ' then
        	ms := '';
        if length(ms) = 0 then
        begin
        	tardir := rqstpath;
            break;
        end
        else
        begin
            ms := FExpand(ms);
            GetDir(0, ws);
            ChDir(ms);
            if IOResult = 0 then
            begin
            	ChDir(ws);
                tardir := ms;
            	break;
            end
            else
            	MessageBox('  Target directory not found', nil, mfError + mfOkButton);
		end;
    end;


    if pwis and (length(password) = 0) then
    	ModPassword;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
   	ws := 'extractpath';
    write(rqstfile,ws);
   	PutPar;

    if ArcFileWin = nil then
    begin
        pwis := false;
	    selfiles := 0; selbytes := 0;
	    WorkingWin('Scaning Archive');
	    ArchiveSize := filesize(arcfile);
		seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		TotalTextSize := 0; TotalCmprSize := 0;
	    NmbArcFiles := 0;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	Move(ArcHeader[10],ArcCmntLen,2);
	  	if ArcCmntLen > 0 then
    	begin
        	fileinarc := fileinarc + ArcCmntLen;
	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

    	while not eof(arcfile) do
	    begin
	        fp := fileinarc;
    	  	inc(NmbArcFiles);
        	blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        Move(FileHeader[0],i,2);
	        if i <> $1C94 then
    	    begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
    	    end;

	        Move(FileHeader[6],TextFileSize,4);
    	    TotalTextSize := TotalTextSize + TextFileSize;

        	Move(FileHeader[2],CmprFileSize,4);
	        fileinarc := fileinarc + CmprFileSize;
	        if (FileHeader[16] and $80) <> 0 then
    	    begin
            	seek(arcfile,fileinarc);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	           	continue;
    	    end;
			if fileinarc > ArchiveSize then
        	begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
        	end;

        	if (FileHeader[15] and 4) <> 0 then
	            pwis := true;
            if (FileHeader[15] and 2) = 0 then
            begin
		        str(fp:9,ws);
    	        write(rqstfile,ws);
            end;

	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

        selfiles := NmbArcFiles;
        selbytes := TotalTextSize;
	    if pwis and (length(password) = 0) then
   			ModPassword;
        seek(rqstfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        PutPar;
	end
    else
    begin
		ArcFileWin^.ArcFileBox^.MakeRqstFile;
    end;

	closefile(arcfile);

	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.ExtractMVA;
var
	R: TRect;
    i : word;
    PutR : PutRec;
    ps :  PString;
    s, ss : string;

begin
	    ps := DirFileWin^.DirFileBox^.DirFileList^.At(DirFileWin^.DirFileBox^.Focused);
    	ArcName := GetListName(ps^);
	    if ps^[28] <> 'A' then
    	begin
        	s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	       	exit;
    	end;
	    ArcName := FExpand(ArcName);
	    fsplit(ArcName,APath,AName,AExt);
    	ADrive := ord(ArcName[1]) - 64;

	    assign(arcfile,ArcName);
    	filemode := 0;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	if (archeader[0] <> $AD) or (archeader[1] <> $36) then
	    begin
    	  	closefile(arcfile);
            ss := AName + AExt;
        	s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	        exit;
   		end;
	    if (archeader[2] > $22) then
    	begin
      		closefile(arcfile);
	        i := archeader[2] shr 4;
    	    str(i:1,s);
        	i := archeader[2] and 15;
	        str(i:1,ss);
    	    s := s + '.' + ss;
    		PrmAr[0] := longint(@s);
	       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
            ArcName := '';
	        exit;
	   	end;

	move(ArcHeader[4],selfiles,2);
    move(ArcHeader[6],selbytes,4);

	if selfiles = 0 then
   	begin
		closefile(arcfile);
   		MessageBox('This is not the first file of AMG MVA',nil,mfInformation + mfOkButton);
		exit;
   	end;

    while true do
    begin
		PutR.p := TarDir;
    	i := Application^.ExecuteDialog(New(PPutDlg, Init), @PutR);
	    if i = cmCancel then
    	    exit;

        ms := PutR.p;
	    if ms = ' ' then
        	ms := '';
        if length(ms) = 0 then
        begin
        	tardir := rqstpath;
            break;
        end
        else
        begin
            ms := FExpand(ms);
            GetDir(0, ws);
            ChDir(ms);
            if IOResult = 0 then
            begin
            	ChDir(ws);
                tardir := ms;
            	break;
            end
            else
            	MessageBox('  Target directory not found', nil, mfError + mfOkButton);
		end;
    end;


    if pwis and (length(password) = 0) then
    	ModPassword;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
   	ws := 'extractmva';
    write(rqstfile,ws);
   	PutPar;

	closefile(arcfile);
    closefilepath(rqstfile);

	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;


procedure TMyApp.TestIntegrity;
var
	R: TRect;
    i : word;
    PutR : PutRec;
    ps :  PString;
    s, ss : string;
    fp : longint;

begin
	if ArcFileWin = nil then
    begin
	    ps := DirFileWin^.DirFileBox^.DirFileList^.At(DirFileWin^.DirFileBox^.Focused);
    	ArcName := GetListName(ps^);
	    if ps^[28] <> 'A' then
    	begin
        	s := copy(EmptyStr,1,12-length(ArcName)) + ArcName;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	       	exit;
    	end;
	    ArcName := FExpand(ArcName);
	    fsplit(ArcName,APath,AName,AExt);
    	ADrive := ord(ArcName[1]) - 64;

	    assign(arcfile,ArcName);
    	filemode := 0;
	    reset(arcfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	if (archeader[0] <> $AD) or (archeader[1] <> $36) then
	    begin
    	  	closefile(arcfile);
            ss := AName + AExt;
        	s := copy(EmptyStr,1,12-length(ss)) + ss;
	    	PrmAr[0] := longint(@s);
    	   	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        	ArcName := '';
	        exit;
   		end;
	    if (archeader[2] > $22) then
    	begin
      		closefile(arcfile);
	        i := archeader[2] shr 4;
    	    str(i:1,s);
        	i := archeader[2] and 15;
	        str(i:1,ss);
    	    s := s + '.' + ss;
    		PrmAr[0] := longint(@s);
	       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
            ArcName := '';
	        exit;
	   	end;
    end
    else
    begin
		if selfiles = 0 then
    	begin
       		MessageBox('There is not any Selected file',nil,mfInformation + mfOkButton);
			exit;
    	end;
    end;

    if pwis and (length(password) = 0) then
    	ModPassword;

    rewrite(rqstfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
   	ws := 'test';
    write(rqstfile,ws);
   	PutPar;

    if ArcFileWin = nil then
    begin
        pwis := false;
	    selfiles := 0; selbytes := 0;
	    WorkingWin('Scaning Archive');
	    ArchiveSize := filesize(arcfile);
		seek(arcfile,0);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		TotalTextSize := 0; TotalCmprSize := 0;
	    NmbArcFiles := 0;
    	blockread(arcfile,archeader,12,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    fileinarc := 12;
    	Move(ArcHeader[10],ArcCmntLen,2);
	  	if ArcCmntLen > 0 then
    	begin
        	fileinarc := fileinarc + ArcCmntLen;
	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

    	while not eof(arcfile) do
	    begin
	        fp := fileinarc;
    	  	inc(NmbArcFiles);
        	blockread(arcfile,fileheader,35,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	        Move(FileHeader[0],i,2);
	        if i <> $1C94 then
    	    begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
    	    end;
        	FPath := ''; FName := ''; FExt := '';
	        for i := 1 to 8 do
				if FileHeader[20+i] <> 0 then
            	   	FName := FName + chr(FileHeader[20+i]);

    	    for i := 1 to 3 do
				if FileHeader[28+i] <> 0 then
    	          	FExt := FExt + chr(FileHeader[28+i]);

        	PathLen := FileHeader[32];
			if PathLen > 0 then
    	    begin
   	    		BlockRead(arcfile,PosBuf,PathLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            	for i := 1 to PathLen do
              		FPath := FPath + chr(PosBuf[i-1]);
	        end;

    	    FileCmntLen := FileHeader[33] + FileHeader[34] * 256;;
			if FileCmntLen > 0 then
            begin
   	    		BlockRead(arcfile,PosBuf,FileCmntLen,NmbRead);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
            end;

	        Move(FileHeader[6],TextFileSize,4);
    	    TotalTextSize := TotalTextSize + TextFileSize;

        	Move(FileHeader[2],CmprFileSize,4);
	        fileinarc := fileinarc + CmprFileSize;
	        if (FileHeader[16] and $80) <> 0 then
    	    begin
            	seek(arcfile,fileinarc);
				myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	           	continue;
    	    end;
			if fileinarc > ArchiveSize then
        	begin
        		closefile(arcfile);
	        	FSplit(ArcName, FPath, FName, FExt);
	        	ss := FName + FExt;
		        s := copy(EmptyStr,1,12-length(ss)) + ss;
	    		PrmAr[0] := longint(@s);
    	   		MessageBox( ' Structure of %-12s is damaged',@PrmAr,mfInformation + mfOkButton);
	            exit;
        	end;

	        CmprCodSize := CmprFileSize - 35 - PathLen - FileCmntLen;
    	    TotalCmprSize := TotalCmprSize + CmprCodSize;

        	if (FileHeader[15] and 4) <> 0 then
	            pwis := true;
            if (FileHeader[15] and 2) = 0 then
            begin
		        str(fp:9,ws);
    	        write(rqstfile,ws);
            end;

	        seek(arcfile,fileinarc);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		end;

        selfiles := NmbArcFiles;
        selbytes := TotalTextSize;
	    if pwis and (length(password) = 0) then
   			ModPassword;
        seek(rqstfile,1);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        PutPar;
	end
    else
    begin
		ArcFileWin^.ArcFileBox^.MakeRqstFile;
    end;

	closefile(arcfile);

	Event.What := evCommand;
    Event.Command := cmQuit;
    PutEvent(Event);
end;



procedure TMyApp.ViewArchive;
var
	ps : PString;
    i : word;
    s, ss : string;

begin
    i := DirFileWin^.DirFileBox^.Focused;

    DirFoc := i;
    ps := DirFileWin^.DirFileBox^.DirFileList^.At(i);
    if copy(ps^,16,5) = '<DIR>' then
    begin
       	ss := GetListName(ps^);
        s := copy(EmptyStr,1,12-length(ss)) + ss;
    	PrmAr[0] := longint(@s);
       	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        exit;
	end;

    s := ps^;
    ArcName := GetListName(s);
    ArcName := FExpand(ArcNAme);
    fsplit(ArcName,APath,AName,AExt);
    ADrive := ord(ArcName[1]) - 64;

    assign(arcfile,arcname);
    filemode := 0;
    reset(arcfile,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    blockread(arcfile,archeader,12,NmbRead);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    if (archeader[0] <> $AD) or (archeader[1] <> $36) then
    begin
       	closefile(arcfile);
        ss := AName + AExt;
      	s := copy(EmptyStr,1,12-length(ss)) + ss;
    	PrmAr[0] := longint(@s);
       	MessageBox(' %-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
        exit;
   	end;
	    if (archeader[2] > $22) then
    	begin
      		closefile(arcfile);
	        i := archeader[2] shr 4;
    	    str(i:1,s);
        	i := archeader[2] and 15;
	        str(i:1,ss);
    	    s := s + '.' + ss;
    		PrmAr[0] := longint(@s);
	       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
            ArcName := '';
	        exit;
	   	end;
    DisableCommands(CommandDir);
	EnableCommands(CommandArc);
    DirFileWin^.DirFileBox^.NewList(nil);
    ArcFileWin := New(PArcFileWin, Init);
    ArcFileWin^.Flags := 0;
    DirFileWin^.Options := 0;
    InsertWindow(ArcFileWin);
    ArcFileWin^.ArcFileBox^.ScanArc;
    ArcFileWin^.DrawView;
end;

procedure TMyApp.CloseArchive;
begin
    closefile(arcfile);
    DirFileWin^.Options := DirWinOpt;
    DisableCommands(CommandArc);
	EnableCommands(CommandDir);
    Dispose(ArcFileWin, Done);
    ArcFileWin := nil;
	DirFileWin^.Select;
    DirFileWin^.DirFileBox^.ScanDir;
    DirFileWin^.DrawView;
    pwis := false;
end;


procedure TDirFileWin.PrnDir;
var
	i : word;
    ps : PString;

begin
    i := MessageBox('   Is the printer ready?', nil, mfConfirmation + mfYesButton + mfNoButton);
    if i <> cmYes then
        exit;
    WorkingWin('Printing...');
	writeln(lst,'');
	writeln(lst,'AMG 2.2 File Compression Archiver Utility');
	writeln(lst,'Contents of Directory ' + rqstpath);
	writeln(lst,'');
    writeln(lst,'  Name     Ext     Size Attr   Date     Time  ');
    for i := 0 to DirFileBox^.DirFileList^.Count-1 do
    begin
    	ps := DirFileBox^.DirFileList^.At(i);
        ps^[1] := ' ';
        writeln(lst,ps^);
    end;
    DrawView;
end;


procedure TDirFileWin.PrnCmnt;
var
	s : Pathstr;
    i : word;
    f : file;
    a : byte;
    l : longint;

begin
    DirFileBox^.GetComment;
    if length(ArcName) = 0 then
    	exit;
    s := workdir + 'Comment.&&&';
	assign(f,s);
    filemode := 2;
    reset(f,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    l := filesize(f);
    if l = 0 then
	begin
    	i := MessageBox('           No comment here', nil, mfInformation + mfOkButton);
    	closefile(f);
        erase(f);
        exit;
	end;

    i := MessageBox('    Is the printer ready?', nil, mfConfirmation + mfYesButton + mfNoButton);
    if i <> cmYes then
    begin
    	closefile(f);
        erase(f);
        exit;
    end;
    WorkingWin('Printing...');
	writeln(lst,'');
	writeln(lst,' AMG 2.2 File Compression Archiver Utility');
	writeln(lst,'Comment of AMG Archive ' + ArcName);
	writeln(lst,'');
    while not eof(f) do
    begin
    	BlockRead(f,a,1,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        write(lst,chr(a));
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    end;
   	closefile(f);
    erase(f);
    DrawView;
end;



procedure TDirFileWin.ViewComment;
var
	s : Pathstr;
begin
    DirFileBox^.GetComment;
    if length(ArcName) = 0 then
    	exit;
    s := workdir + 'Comment.&&&';
	ComWin := New(PFileWindow,Init(s));
    if MyApp.ValidView(ComWin) <> nil then
    begin
	    DisableCommands(AllCommands);
    	EnableCommands(CommandClose);
	    ComWin^.Flags := 0;
    	ComWin^.HelpCtx := hcCloseWin;
		Application^.InsertWindow(ComWin);
    end
    else
        ComWin := nil;
end;

procedure TDirFileWin.EditComment;
var
	R : TRect;
begin
    DirFileBox^.GetComment;
    if length(ArcName) = 0 then
    	exit;
	Desktop^.GetExtent(R);
	EW := New(PEditWindow, Init(R, workdir + 'Comment.&&&', wnNoNumber));
    if MyApp.ValidView(EW) <> nil then
    begin
	    DisableCommands(AllCommands);
    	EnableCommands(CommandClose);
	    EW^.Flags := 0;
    	EW^.HelpCtx := hcEditWin;
		Application^.InsertWindow(EW);
    end
    else
    	EW := nil;
end;

procedure TDirFileWin.CloseComment;
var
	cf : file;
begin
	if EW <> NIL then
    begin
        Dispose(EW, Done);
        EW := nil;
        DirFileBox^.PutComment;
	    DirFileBox^.ScanDir;
    	DrawView;
    end
    else
    	if ComWin <> nil then
		begin
            assign(cf,workdir + 'Comment.&&&');
            erase(cf);
    		Dispose(ComWin, Done);
            ComWin := nil;
        end;
    EnableCommands(AllCommands);
    DisableCommands(CommandArc);
end;


procedure TArcFileWin.PrnArc;
var
	i : word;
    ps : PString;
    s1, s2, s3 : string[12];

begin
    i := MessageBox('   Is the printer ready?', nil, mfConfirmation + mfYesButton + mfNoButton);
    if i <> cmYes then
        exit;
    WorkingWin('Printing...');
	writeln(lst,'');
	writeln(lst,'AMG 2.2 File Compression Archiver Utility');
	writeln(lst,'Contents of AMG Archive ' + ArcName);
	writeln(lst,'');
    writeln(lst,'  Name     Ext      Size Compressed  Ratio    Date      Time    Attr  CPS');
    for i := 0 to ArcFileBox^.ArcFileList^.Count-1 do
    begin
    	ps := ArcFileBox^.ArcFileList^.At(i);
        ps^[1] := ' ';
        writeln(lst,copy(ps^,1,length(ps^)-10));
    end;
    writeln(lst,'');
    str(NmbArcFiles:5,s1);
    str(TotalTextSize:9,s2);
    str(TotalCmprSize:9,s3);
    writeln(lst,' Total: ' + s1 + ' file(s)  Size: ' + s2 + '  Compessed: ' + s3 + '  Ratio: ' + RatioStr);
    DrawView;
end;



procedure TArcFileWin.PrnCmnt;
var
	s : Pathstr;
    i : word;
    f : file;
    a : byte;
    l : longint;
	ps : PString;

begin
    ArcFileBox^.GetComment;
    s := workdir + 'Comment.&&&';
	assign(f,s);
    filemode := 2;
    reset(f,1);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    l := filesize(f);
    if l = 0 then
	begin
    	i := MessageBox('           No comment here', nil, mfInformation + mfOkButton);
    	closefile(f);
        erase(f);
        exit;
	end;

    i := MessageBox('    Is the printer ready?', nil, mfConfirmation + mfYesButton + mfNoButton);
    if i <> cmYes then
    begin
    	closefile(f);
        erase(f);
        exit;
    end;
   	ps := ArcFileBox^.ArcFileList^.At(ArcFileBox^.Focused);
    s := GetListName(ps^);
    WorkingWin('Printing...');
	writeln(lst,'');
	writeln(lst,' AMG 2.2 File Compression Archiver Utility');
	writeln(lst,'Comment of file ' + s + ' in AMG Archive ' + ArcName);
	writeln(lst,'');
    while not eof(f) do
    begin
    	BlockRead(f,a,1,NmbRead);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
        write(lst,chr(a));
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    end;
   	closefile(f);
    erase(f);
	DrawView;
end;


procedure TArcFileWin.ViewComment;
var
	s : Pathstr;
begin
    ArcFileBox^.GetComment;
    s := workdir + 'Comment.&&&';
	ComWin := New(PFileWindow,Init(s));
    if MyApp.ValidView(ComWin) <> nil then
    begin
	    DisableCommands(AllCommands);
    	EnableCommands(CommandClose);
	    ComWin^.Flags := 0;
    	ComWin^.HelpCtx := hcCloseWin;
		Application^.InsertWindow(ComWin);
    end
    else
    	ComWin := nil;
end;

procedure TArcFileWin.EditComment;
var
	R : TRect;
    ps : PString;
begin
    ps := ArcFileBox^.ArcFileList^.At(ArcFileBox^.Focused);

	if ps^[73] = 'P' then
    	exit;

    ArcFileBox^.GetComment;
	Desktop^.GetExtent(R);
	EW := New(PEditWindow, Init(R, workdir + 'Comment.&&&', wnNoNumber));
    if MyApp.VAlidView(EW) <> nil then
    begin
	    DisableCommands(AllCommands);
    	EnableCommands(CommandClose);
	    EW^.Flags := 0;
    	EW^.HelpCtx := hcEditWin;
		Application^.InsertWindow(EW);
    end
    else
    	EW := nil;
end;

procedure TArcFileWin.CloseComment;
var
	cf : file;
begin
	if EW <> NIL then
    begin
    	Dispose(EW, Done);
        EW := nil;
        ArcFileBox^.PutComment;
        ArcFoc := ArcFileBox^.Focused;
	    ArcFileBox^.ScanArc;
	    ArcFileBox^.FocusItem(ArcFoc);
    	DrawView;
    end
    else
    	if ComWin <> nil then
		begin
            assign(cf,workdir + 'Comment.&&&');
            erase(cf);
    		Dispose(ComWin, Done);
            ComWin := nil;
        end;
    EnableCommands(AllCommands);
    DisableCommands(CommandDir);
end;


procedure TMyApp.ViewHelp;
var
	s : string;
begin
    s := amgdir + 'MANUAL.DOC';
	HelpWin := New(PFileWindow,Init(s));
    if MyApp.ValidView(HelpWin) <> nil then
    begin
	    DisableCommands(AllCommands);
    	EnableCommands(CommandClose);
	    HelpWin^.Flags := 0;
    	HelpWin^.HelpCtx := hcCloseWin;
		InsertWindow(HelpWin);
    end
    else
    	HelpWin := nil;
end;


procedure TMyApp.CloseWin;
begin
   	if HelpWin <> nil then
	begin
   		Dispose(HelpWin, Done);
        HelpWin := nil;
	    EnableCommands(AllCommands);
        if ArcFileWin = nil then
	    	DisableCommands(CommandArc)
		else
	    	DisableCommands(CommandDir);
    end
    else
        if DirFileWin^.ViewFileWin <> nil then
        begin
	   		Dispose(DirFileWin^.ViewFileWin, Done);
    	    DirFileWin^.ViewFileWin := nil;
	    	EnableCommands(AllCommands);
    		DisableCommands(CommandArc)
        end
        else
	        if DirFileWin^.EditFileWin <> nil then
    	    begin
		    	Dispose(DirFileWin^.EditFileWin, Done);
        		DirFileWin^.EditFileWin := nil;
	    		DirFileWin^.DirFileBox^.ScanDir;
                DirFileWin^.DrawView;
		    	EnableCommands(AllCommands);
	    		DisableCommands(CommandArc)
            end
        	else
        	begin
		    	if ArcFileWin = nil then
    		    	DirFileWin^.CloseComment
	    	    else
    	  		 	ArcFileWin^.CloseComment;
            end;

end;


procedure TMyApp.SaveOpt;
begin
	assign(optfile,amgdir + 'amg.cnf');
    rewrite(optfile);
	myiorslt:=ioresult; if myiorslt <> 0 then io_error;
    ws := '';
    str(ProFilTyp:5,s);
    ws := ws + s;
    str(SortKey:5,s);
    ws := ws + s;
    str(SortMtd:5,s);
    ws := ws + s;
    str(twocol:5,s);
    ws := ws + s;
    write(optfile,ws);

	case Method of
        SuperFastCompr : ws := 's';
    	FastCompr      : ws := 'f';
        LessMemCompr   : ws := 'l';
        NormalCompr    : ws  := 'n';
        MaxCompr : ws := 'm';
    end;
    if delaftarc then
    	ws := ws + ' d'
    else
    	ws := ws + '  ';
    if querybefovr then
    	ws := ws + ' q'
    else
    	ws := ws + '  ';
    write(optfile,ws);

    ws := password;
    write(optfile,ws);
    write(optfile,filemask);
	close(optfile);
end;




constructor TMyApp.Init;
var
	R: TRect;
    s, ss : string;

begin
    MaxHeapSize := 8192;
    EditorDialog := StdEditorDialog;
	inherited Init;
	DisableCommands(CommandArc);
    EnableCommands(CommandDir);

    criterr := false;
    twocol := 0;
    SortKey := 0;
    SortMtd := 0;
	GetDir(0,rqstpath);

	dirfoc := 0; arcfoc := 0;
    TarDir := startdir;
	excldpth := false;
 	mltplvlm := false;
    pwis := false;
    password := '';
    filemask := '*.*';
    arcisopen := false;
    CmntFileName := '';
    ProFilTyp := 0;
    AttrMask := ReadOnly + Archive;
    assign(rqstfile,workdir + 'rqstfAMG.&&&');
    assign(temparc,workdir + 'tmpaAMG.&&&');
    assign(delfile,workdir + 'delfAMG.&&&');
    vlmcnt := 0;
    method :=NormalCompr;
    delaftarc := false;
	querybefovr := true;

    findfirst(workdir + 'rqstfAMG.&&&',Archive,sr);
    if DosError = 0 then
    begin
	    filemode := 2;
		reset(rqstfile);
		myiorslt:=ioresult; if myiorslt <> 0 then io_error;
	    read(rqstfile,cmnd);
	    read(rqstfile,ArcName);
    	read(rqstfile,TarDir);
	    read(rqstfile,ws);
		s := copy(ws,15,5);
	    val(s,ProFilTyp,i);
		if (ProFilTyp and 1) <> 0 then
        	AttrMask := AttrMask + Hidden + SysFile;

		s := copy(ws,20,5);
	    val(s,SortKey,i);
		s := copy(ws,25,5);
	    val(s,SortMtd,i);
		s := copy(ws,30,5);
	    val(s,dirfoc,i);
		s := copy(ws,35,5);
	    val(s,arcfoc,i);
		s := copy(ws,40,5);
	    val(s,twocol,i);


	    read(rqstfile,ws);
    	c := ws[1];
		case c of
    		's' : Method := SuperFastCompr;
    		'f' : Method := FastCompr;
    		'l' : Method := LessMemCompr;
	        'n' : Method := NormalCompr;
    	    'm' : Method := MaxCompr;
        end;
    	c := ws[3];
	    if c = 'd' then
    	   	delaftarc := true
		else
			delaftarc := false;
    	c := ws[5];
	    if c = 'q' then
    	   	querybefovr := true
		else
			querybefovr := false;
    	c := ws[7];
	    if c = 'o' then
    	   	arcisopen := true
		else
			arcisopen := false;

	    read(rqstfile,ws);
		password := ws;
	    read(rqstfile,CmntFileName);
        read(rqstfile,filemask);

	    DirFileWin := New(PDirFileWin, Init);
    	DirFileWin^.Flags := 0;
	    InsertWindow(DirFileWin);
	    DirWinOpt := DirFileWin^.Options;
		ArcFileWin := nil;
	    HelpWin := nil;


        if (arcisopen) and (arcname[1] > 'B') then
        begin
			assign(arcfile,arcname);
		    filemode := 0;
		    reset(arcfile,1);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		    blockread(arcfile,archeader,12,NmbRead);
			myiorslt:=ioresult; if myiorslt <> 0 then io_error;
		    if (archeader[0] <> $AD) or (archeader[1] <> $36) then
		    begin
		       	closefile(arcfile);
		        FSplit(ArcName, FPath, FName, FExt);
		       	ss := FName + FExt;
        		s := copy(EmptyStr,1,12-length(ss)) + ss;
		    	PrmAr[0] := longint(@s);
		       	MessageBox('%-12s is not AMG archive',@PrmAr,mfInformation + mfOkButton);
		        exit;
		   	end;
		    if (archeader[2] > $22) then
    		begin
      			closefile(arcfile);
	        	i := archeader[2] shr 4;
	    	    str(i:1,s);
    	    	i := archeader[2] and 15;
	    	    str(i:1,ss);
    	    	s := s + '.' + ss;
	    		PrmAr[0] := longint(@s);
		       	MessageBox(' AMG %-3s or higher is required',@PrmAr,mfInformation + mfOkButton);
        	    ArcName := '';
	        	exit;
		   	end;
		    DisableCommands(CommandDir);
			EnableCommands(CommandArc);
		    DirFileWin^.DirFileBox^.NewList(nil);
		    ArcFileWin := New(PArcFileWin, Init);
            ArcFileWin^.Flags := 0;
            DirFileWin^.Options := 0;
		    InsertWindow(ArcFileWin);
		    ArcFileWin^.ArcFileBox^.ScanArc;
		    ArcFileWin^.DrawView;
		end;
    end
    else
    begin
		assign(optfile,amgdir + 'amg.cnf');
     	reset(optfile);
        if ioresult = 0 then
        begin
            read(optfile,ws);
			s := copy(ws,1,5);
		    val(s,ProFilTyp,i);
			if (ProFilTyp and 1) <> 0 then
	        	AttrMask := AttrMask + Hidden + SysFile;
			s := copy(ws,6,5);
		    val(s,SortKey,i);
			s := copy(ws,11,5);
		    val(s,SortMtd,i);
			s := copy(ws,16,5);
		    val(s,twocol,i);

    		read(optfile,ws);
	    	c := ws[1];
			case c of
    			's' : Method := SuperFastCompr;
    			'f' : Method := FastCompr;
    			'l' : Method := LessMemCompr;
	        	'n' : Method := NormalCompr;
	    	    'm' : Method := MaxCompr;
	        end;
    		c := ws[3];
	    	if c = 'd' then
	    	   	delaftarc := true
			else
				delaftarc := false;
	    	c := ws[5];
		    if c = 'q' then
	    	   	querybefovr := true
			else
				querybefovr := false;

		    read(optfile,ws);
			password := ws;
        	read(optfile,filemask);
			close(optfile);
		end;


	    DirFileWin := New(PDirFileWin, Init);
    	DirFileWin^.Flags := 0;
	    InsertWindow(DirFileWin);
	    DirWinOpt := DirFileWin^.Options;
		ArcFileWin := nil;
	    HelpWin := nil;

	end;
end;

destructor TMyApp.Done;
begin
	If ArcFileWin <> nil then
    	Dispose(ArcFileWin, Done);
    Dispose(DirFileWin, Done);
    Inherited Done;
end;



procedure TMyApp.InitStatusLine;
var
  R: TRect;
  Status2 : PStatusDef;

begin
   Status2 :=
	   NewStatusDef(hcDownDir, hcDownDir,
    	 NewStatusKey('Change current directory with focused', 0, 0,
	 	 nil),
	   NewStatusDef(hcUpDir, hcUpDir,
	     NewStatusKey('Change current directory with parent', 0, 0,
 		 nil),
	   NewStatusDef(hcFromTo, hcFromTo,
    	 NewStatusKey('Select all files from specified date to another specified date', 0, 0,
	 	 nil),
	   NewStatusDef(hcBefore, hcBefore,
    	 NewStatusKey('Select all files before specified date', 0, 0,
	 	 nil),
	   NewStatusDef(hcAfter, hcAfter,
    	 NewStatusKey('Select all files after specified date', 0, 0,
	 	 nil),
	   NewStatusDef(hcToBottom, hcToBottom,
    	 NewStatusKey('Select all files from focused to the bottom of list', 0, 0,
	 	 nil),
	   NewStatusDef(hcToTop, hcToTop,
    	 NewStatusKey('Select all files from focused to the top of list', 0, 0,
	 	 nil),
	   NewStatusDef(hcextractMVA, hcextractMVA,
    	 NewStatusKey('Extract all files from focused in Directory window Multiple Volume Archive-MVA', 0, 0,
	 	 nil),
	   NewStatusDef(hcSort, hcSort,
    	 NewStatusKey('Choose file sorting key and method ', 0, 0,
	 	 nil),
	   NewStatusDef(hcSelOneNxt, hcSelOneNxt,
    	 NewStatusKey('Select or unselect focused file and focus next file' , 0, 0,
	 	 nil),
	   NewStatusDef(hcTstInt, hcTstInt,
    	 NewStatusKey('Test integrity of archive - extract files to memory' , 0, 0,
	 	 nil),
	   NewStatusDef(hcViewFile, hcViewFile,
    	 NewStatusKey('View text file' , 0, 0,
	 	 nil),
	   NewStatusDef(hcEditFile, hcEditFile,
    	 NewStatusKey('Edit text file' , 0, 0,
	 	 nil),
	   NewStatusDef(hcEditWin, hcEditWin,
	   	 NewStatusKey('~Esc~ to Close', kbEsc, cmCloseWin,
   		 NewStatusKey('~F2~ Save', kbF2, cmSave,
	     nil)),
	   NewStatusDef(hcSaveOpt, hcSaveOpt,
   		 NewStatusKey('Save all the settings in the Options menu to file AMG.CNF',0, 0,
	     nil),
	   NewStatusDef(hcfilemask, hcfilemask,
   		 NewStatusKey('Set filemask for files to be listed in the Directory window',0, 0,
	     nil),
       nil))))))))))))))));

  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusline, Init(R,
   NewStatusDef(0, 0,
     NewStatusKey('~F1~ Help', kbF1, cmViewHelp,
     NewStatusKey('~Alt+X~ Exit', kbAltX, cmGoDos,
     NewStatusKey('~F10~ Main menu',kbF10, cmMenu,
     NewStatusKey('~Ins~ View Archive ',kbIns, cmViewArc,
     NewStatusKey('~Shift+Ins~ Close Archive',kbShiftIns, cmClsArc,
     nil))))),
   NewStatusDef(hcCloseWin, hcCloseWin,
     NewStatusKey('~Esc~ to Close', kbEsc, cmCloseWin,
 	 nil),
   NewStatusDef(hcDirFile, hcDirFile,
     NewStatusKey('Procceses Selected files in directory', 0, 0,
 	 nil),
   NewStatusDef(hcArchive, hcArchive,
     NewStatusKey('Processes commpressed files in archive', 0, 0,
 	 nil),
   NewStatusDef(hcAdd, hcAdd,
     NewStatusKey('Add Selected disk files to archive ', 0, 0,
 	 nil),
   NewStatusDef(hcMVA, hcMVA,
     NewStatusKey('Create Multiple Volume Archive (MVA) on drive A or B', 0, 0,
 	 nil),
   NewStatusDef(hcSEA, hcSEA,
     NewStatusKey('Create Self Extracting Archive (SEA)', 0, 0,
 	 nil),
   NewStatusDef(hcFreshen, hcFreshen,
     NewStatusKey('Update matching files in archive that are older than the Selected files', 0, 0,
 	 nil),
   NewStatusDef(hcUpdate, hcUpdate,
     NewStatusKey('Update older files in archive and add new files', 0, 0,
 	 nil),
   NewStatusDef(hcChDir, hcChDir,
     NewStatusKey('Change current drive/directory', 0, 0,
 	 nil),
   NewStatusDef(hcDelArc, hcDelArc,
     NewStatusKey('Delete Selected files from the archive', 0, 0,
 	 nil),
   NewStatusDef(hcExtract, hcExtract,
     NewStatusKey('Extract Selected Files from the archive to the specified directory', 0, 0,
 	 nil),
   NewStatusDef(hcExtractPath, hcExtractPath,
     NewStatusKey('Extract Selected files from the archive with full path', 0, 0,
 	 nil),
   NewStatusDef(hcCmntFrmFl, hcCmntFrmFl,
     NewStatusKey('Get archive comment from text file', 0, 0,
 	 nil),
   NewStatusDef(hcCmmnt, hcCmmnt,
     NewStatusKey('Processes comment of focused archive/file in archive', 0, 0,
 	 nil),
   NewStatusDef(hcVwCmmnt, hcVwCmmnt,
     NewStatusKey('View comment of focused archive/file in archive', 0, 0,
 	 nil),
   NewStatusDef(hcEdtCmmnt, hcEdtCmmnt,
     NewStatusKey('Edit comment of focused archive/file in archive', 0, 0,
 	 nil),
   NewStatusDef(hcClsCmmnt, hcClsCmmnt,
     NewStatusKey('Close comment edit window', 0, 0,
 	 nil),
   NewStatusDef(hcPref, hcPref,
     NewStatusKey('Set compession method, type of files etc.', 0, 0,
 	 nil),
   NewStatusDef(hcCmntFrmFl, hcCmntFrmFl,
     NewStatusKey('Choose text file to be added as archive comment ', 0, 0,
 	 nil),
   NewStatusDef(hcPsswrd, hcPsswrd,
     NewStatusKey('Set/Clear password wich encrypte archive ', 0, 0,
 	 nil),
   NewStatusDef(hcSelAll, hcSelAll,
     NewStatusKey('Select all files' , 0, 0,
 	 nil),
   NewStatusDef(hcSelOne, hcSelOne,
     NewStatusKey('Select or unselect focused file' , 0, 0,
 	 nil),
   NewStatusDef(hcSelAllDir, hcSelAllDir,
     NewStatusKey('Select all files and directories ', 0, 0,
 	 nil),
   NewStatusDef(hcUnSelAll, hcUnSelAll,
     NewStatusKey('UnSelect all files and directories', 0, 0,
 	 nil),
   NewStatusDef(hcprWlcrd, hcprWlcrd,
     NewStatusKey('Select files per willcard', 0, 0,
 	 nil),
   NewStatusDef(hcfiltyp, hcfiltyp,
     NewStatusKey('Choose type of files to be processed - hidden/system', 0, 0,
 	 nil),
   NewStatusDef(hcprnarc, hcprnarc,
     NewStatusKey('Print archive contents - the same you seen in archive window ', 0, 0,
 	 nil),
   NewStatusDef(hcprncmnt, hcprncmnt,
     NewStatusKey('Print comment of currently focused archive/file in archive ', 0, 0,
 	 nil),
   NewStatusDef(hcprndir, hcprndir,
     NewStatusKey('Print directory contents - the same you seen in directory window ', 0, 0,
 	 nil),
   NewStatusDef(hcprnord, hcprnord,
     NewStatusKey('Ask you for registration and order data and otput order form to printer', 0, 0,
 	 nil),
   NewStatusDef(hcCopyDirFile, hcCopyDirFile,
     NewStatusKey('Copy Selected file(s) to another drive/directory', 0, 0,
 	 nil),
   NewStatusDef(hcDelDirFile, hcDelDirFile,
     NewStatusKey('Delete Selected file(s)', 0, 0,
 	 nil),
   Status2)))))))))))))))))))))))))))))))))));
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y:= R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcDirFile, NewMenu(
      NewItem('~A~dd to archive','F2',kbF2,cmAdd,hcAdd,
      NewItem('~F~reshen in archive','F3',kbF3,cmFreshen,hcFreshen,
      NewItem('~U~pdate in arcive','  F4',kbF4,cmUpdate,hcUpdate,
      NewItem('~M~VA','Alt+F2',kbAltF2,cmMVA,hcMVA,
      NewItem('~S~EA','Alt+F3',kbAltF3,cmSEA,hcSEA,
      NewItem('C~o~py','Alt+F4',kbAltF4,cmCopyDirFile,hcCopyDirFile,
      NewItem('~D~elete','Alt+F5',kbAltF5,cmDelDirFile,hcDelDirFile,
      NewItem('~V~iew','Shift+F7',kbShiftF7,cmViewFile,hcViewFile,
      NewItem('~E~dit','Shift+F8',kbShiftF8,cmEditFile,hcEditFile,
      NewItem('~C~hange dir...','F5',kbF5,cmChDir,hcChDir,
      NewItem('Do~w~n dir...','Gray +',kbGrayPlus,cmDownDir,hcDownDir,
      NewItem('U~p~ dir...','Gray -',kbGrayMinus,cmUpDir,hcUpDir,
	  nil))))))))))))),
    NewSubMenu('~A~rchive', hcArchive, NewMenu(
      NewItem('~E~xtract File(s)','F6',kbF6,cmExtract,hcExtract,
      NewItem('E~x~tract with path','F7',kbF7,cmExtractPath,hcExtractPath,
      NewItem('Extract ~M~VA','F8',kbF8,cmExtractMVA,hcExtractMVA,
      NewItem('~D~elete in Archive','Ctrl+F5',kbCtrlF5,cmDelArc,hcDelArc,
      NewItem('~T~est integrity','Alt+F6',kbAltF6,cmTstInt,hcTstInt,
	  nil)))))),
    NewSubMenu('~S~elect', hcSel, NewMenu(
      NewItem('Select/Unselect focused','Space Bar',0,cmSelOne,hcSelOne,
      NewItem('Select focused & go next','Enter',kbEnter,cmSelOneNxt,hcSelOneNxt,
      NewItem('~A~ll files','F9',kbF9,cmSelAll,hcSelAll,
      NewItem('All files & ~d~irectories','Shift+F9',kbShiftF9,cmSelAllDir,hcSelAllDir,
      NewItem('Per ~w~illcards','Ctrl+F9',kbCtrlF9,cmprWlcrd,hcprWlcrd,
      NewItem('~U~nselect all','Alt+F9',kbAltF9,cmUnSelAll,hcUnSelAll,
      NewItem('~F~rom ... to ...','',0,cmFromTo,hcFromTo,
      NewItem('~B~efore ... ','',0,cmBefore,hcBefore,
      NewItem('Afte~r~ ... ','',0,cmAfter,hcAfter,
      NewItem('T~o~day','Shift+F4',kbShiftF4,cmToday,hcToday,
      NewItem('All to the botto~m~ ','Shift+F5',kbShiftF5,cmToBottom,hcToBottom,
      NewItem('All to the ~t~op','Shift+F6',kbShiftF6,cmToTop,hcToTop,
	  nil))))))))))))),
    NewSubMenu('~C~omment', hcCmmnt, NewMenu(
      NewItem('~V~iew','Alt+F7',kbAltF7,cmVwCmmnt,hcVwCmmnt,
      NewItem('~E~dit','Alt+F8',kbAltF8,cmEdtCmmnt,hcEdtCmmnt,
      NewItem('From ~f~ile','',0,cmCmntFrmFl,hcCmntFrmFl,
	  nil)))),
    NewSubMenu('~O~ptions', hcNoContext, NewMenu(
      NewItem('~P~references','',0,cmpref,hcpref,
      NewItem('~S~ort','',0,cmSort,hcSort,
      NewItem('Pass~w~ord' ,'',0,cmPsswrd,hcPsswrd,
      NewItem('~F~ilemask' ,'Ctrl+F2',kbCtrlF2,cmfilemask,hcfilemask,
      NewItem('S~a~ve' ,'',0,cmSaveOpt,hcSaveOpt,
	  nil)))))),
    NewSubMenu('~P~rint', 0, NewMenu(
      NewItem('~A~rchive contents','Ctrl+F6',kbCtrlF6,cmprnarc,hcprnarc,
      NewItem('~C~omment','Ctrl+F7',kbCtrlF7,cmprncmnt,hcprncmnt,
      NewItem('~D~irectory contents','Ctrl+F8',kbCtrlF8,cmprndir,hcprndir,
      NewItem('~O~rder form','',0,cmprnord,hcprnord,
	  nil))))),
    nil)))))))));
end;


procedure TMyApp.HandleEvent(var Event : TEvent);

begin
	inherited HandleEvent(Event);
	if Event.What = evCommand then
	begin
    	case Event.Command of
	   		cmAdd: AddDirFile;
            cmMVA: MVA;
            cmSEA: SEA;
	      	cmFreshen : FreshenArchive;
    		cmUpdate : UpdateArchive;
   	  		cmExtract: ExtractArcFile;
   	  		cmExtractPath: ExtractArcPath;
   	  		cmExtractMVA: ExtractMVA;
            cmTstInt : TestIntegrity;
        	cmViewArc : ViewArchive;
            cmClsArc  : CloseArchive;
            cmPref : Preferences;
            cmSort : Sort;
        	cmPsswrd :  ModPassword;
            cmSaveOpt : SaveOpt;
            cmCmntFrmFl : CommentFromFile;
      		cmChDir : ChCurDir;
            cmprnord : PrintOrderForm;
            cmViewHelp : ViewHelp;
            cmCloseWin : CloseWin;
            cmGoDos : GoDos;
        else
        	exit;
        end;
	end
    else
    	exit;
	ClearEvent(Event);
end;


begin
    if (ParamCount <> 4) or (ParamStr(4) <> 'joro') then
    begin
    	writeln;
        writeln(' Incorect start of program!');
        halt(1);
    end;
    startdir := ParamStr(1);
    workdir := ParamStr(2);
    AMGdir := ParamStr(3);
  	MyApp.Init;
	MyApp.Run;
	MyApp.Done;
end.

