/*  $Id$
 *  
 *  File	clean.c
 *  Part of	ChessBase utilities file format (CBUFF)
 *  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
 *  Purpose	Clean up utility
 *  Works with	GNU CC 2.4.5
 *  
 *  Notice	Copyright (c) 1993  Anjo Anjewierden
 *  
 *  History	15/10/93  (Created)
 *  		14/11/93  (Last modified)
 */ 


/*------------------------------------------------------------
 *  Directives
 *------------------------------------------------------------*/

#include "cbuff.h"

char *		UTILITY_NAME = "Clean utility";
char *		UTILITY_VERSION = "1.1.0";

void		helpUtility(FILE *fd);

bool		DELETE_OPTION;


/*------------------------------------------------------------
 *  Clean utility
 *------------------------------------------------------------*/

void
cleanUtility(Option opt)
{ Game g = newGame();
  CBase cb = opt->database;
  long from = opt->from;
  long to = (opt->to < getNoGamesCBase(cb) ? opt->to : getNoGamesCBase(cb));
  long n;

  reportCBase(cb, stderr);

  if (opt->dump == NULL)
  { fprintf(stderr, "No output database specified (-dump or -append option)\n");
    exit(1);
  }

  n = to-from+1;
  if (n < 0)
    return;
  
  for (n=from; n<=to; n++)
  { environmentError(cb, g, n);
    initialiseGame(g, n, cb);
    if (foundError())
    { reportError(stderr);
      continue;
    }
    if (DELETE_OPTION && deletedGameP(g))
    { if (foundError())
      { reportError(stderr);
	continue;
      }
      fprintf(stderr, "Deleting game %6ld:  %s, %s\n",
	      n, getPlayersGame(g), getSourceGame(g));
      deleteGameCBase(cb, n);
    }
    if (foundError())
      reportError(stderr);
  }

  exportManyCBase(opt->dump, cb, 1, getNoGamesCBase(cb));

  freeGame(g);
}


/*------------------------------------------------------------
 *  Main
 *------------------------------------------------------------*/

int
main(int argc, char *argv[])
{ int i;
  Option options = newOption();

  /* initChessSymbols(); */

  DELETE_OPTION = TRUE;

  for (i=1; i<argc; i++)
  {
    if (strhead(argv[i], "-delete"))
    { DELETE_OPTION = TRUE;
      continue;
    }

    if (strhead(argv[i], "-delete"))
    { DELETE_OPTION = FALSE;
      continue;
    }

    if (strhead(argv[i], "-"))
    { int n;

      n = genericOption(options, argv, argc, i);
      if (n == 0)
      { fprintf(stderr, "Fatal: Unknown command %s\n", argv[i]);
	fprintf(stderr, "Do ``%s -help'' or see the documentation\n", argv[0]);
	exit(1);
      }
      i = n;
      continue;
    }

    setCurrentCBase(argv[i], "-database", argc, i);
    options->database = CurrentBase;
    cleanUtility(options);
    freeCBase(options->database);
    options->database = (CBase) NULL;
  }

  if (options->database)
  { cleanUtility(options);
    freeCBase(options->database);
  }

  exit(0);
}


/*------------------------------------------------------------
 *  Help
 *------------------------------------------------------------*/

void
helpUtility(FILE *fd)
{ helpCBUFF(fd);
  fprintf(fd, "%s options:\n", UTILITY_NAME);
  fprintf(fd, "-nodelete     Does not remove deleted games\n");
  fprintf(fd, "-delete       Removes deleted games (default)\n");
}
