Program VirtTest;

Uses Crt, VirtMem6;  { <- replace to VirtMem7 for TP 7.0 }

Const
   MaxBlocks = 5000;

Var

   I,
   Size,
   TempSize,
   BlockNo   : Word;
   Blocks    : Array [1 .. MaxBlocks] Of VMHandleType;
   MemType   : VMMemoryType;
   Locked,
   Done      : Boolean;
   XMem,
   EMem,
   CMem,
   DMem      : LongInt;
   ErrCode   : VMErrCodeType;

(************************************************)

Function GetProgramDir : String;

Var
   Dir    : String;
   DirLen : Byte Absolute Dir;

Begin

   Dir := ParamStr(0);

   While Dir[DirLen] <> '\' Do
      Dec (DirLen);

   Dec (DirLen);
   GetProgramDir := Dir;

End;

(************************************************)

Procedure CheckErr (Code : VMErrCodeType);

Begin

   If Code <> VMOk Then Begin
      Writeln (#7, VMErrorMsg (Code));

      If VMInstalled Then
         VMClose;

      Halt;
   End;

End;

(************************************************)

Begin

   ClrScr;
   Writeln ('Virtual Memory Test  from Patel Enterprises');
   Writeln ('-------------------------------------------');
   Writeln;
   VMInit (GetProgramDir, MaxLongInt);
   CheckErr (VMResult);
   Writeln ('Extended memory = ', VMXMSAvail);
   Writeln ('Expanded memory = ', VMEMSAvail);
   Writeln ('Conventional memory = ', VMCMSAvail);
   Writeln ('Disk memory = ', VMDMSAvail);
   Write ('Press RETURN to begin test...');
   Readln;
   Writeln;

   XMem := 0;
   EMem := 0;
   CMem := 0;
   DMem := 0;
   BlockNo := 1;
   Done := False;
   Size := 4096;

   While (BlockNo <= MaxBlocks) And (Not Done)  Do Begin
      VMAlloc (Blocks[BlockNo], Size);
      CheckErr (VMResult);

      GotoXY (1, WhereY);
      Write (BlockNo, ' block(s) allocated');

      VMQueryInfo (Blocks[BlockNo], TempSize, MemType, Locked);

      If MemType = XMS Then
         Inc (XMem, Size)
      Else If MemType = EMS Then
         Inc (EMem, Size)
      Else If MemType = CMS Then
         Inc (CMem, Size)
      Else
         Inc (DMem, Size);

      Done := DMem > 0;
      Inc (BlockNo);
   End;

   Dec (BlockNo);

   Writeln;
   Writeln;
   Writeln (XMem, ' bytes extended memory allocated');
   Writeln (EMem, ' bytes expanded memory allocated');
   Writeln (CMem, ' bytes conventional memory allocated');
   Writeln (DMem, ' bytes disk space allocated');
   Write ('Press RETURN to release memory ...');
   Readln;
   Writeln;


   For I := 1 To BlockNo Do Begin
      VMFree (Blocks[I]);
      CheckErr (VMResult);
      GotoXY (1, WhereY);
      Write (I, ' block(s) released');
   End;

   Writeln;
   Writeln;
   Writeln ('Extended memory = ', VMXMSAvail);
   Writeln ('Expanded memory = ', VMEMSAvail);
   Writeln ('Conventional memory = ', VMCMSAvail);
   Writeln ('Disk memory = ', VMDMSAvail);
   Write ('Press RETURN to end ...');
   Readln;

   VMClose;
   CheckErr (VMResult);

End.
